<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	
	
    <xsl:template match="/">
		<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="@*|node()">
		<xsl:choose>
			<xsl:when test="name()='sp'">
				<span>
					<xsl:variable name="word" select="word"/>
					<select name="replace">
						<option selected="true">
							<xsl:attribute name="value">
							<xsl:value-of select="$word"/>,<xsl:value-of select="$word"/>
							</xsl:attribute>
							<xsl:value-of select="$word"/>
						</option>
					<xsl:for-each select="alternatives/alt">
						<option>
							<xsl:attribute name="value">
							<xsl:value-of select="$word"/>,<xsl:value-of select="."/>
							</xsl:attribute>
							<xsl:value-of select="."/>
						</option>
					</xsl:for-each>			
					</select>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*"/>
					<xsl:apply-templates/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet> 
