/*
 * LocalBBCodeParser.java
 *
 * Created on 26 January 2005, 13:58
 */

package org.ten60.netkernel.forum.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.xml.xda.*;

import org.javabb.bbcode.*;
import java.util.regex.*;
import java.util.*;
/**
 *
 * @author  pjr
 */
public class LocalBBCodeParser extends NKFAccessorImpl
{	private static Pattern mPattern=Pattern.compile("\\[xml\\](.*?)\\[/xml\\]", Pattern.MULTILINE|Pattern.DOTALL );
	
	/** Creates a new instance of LocalBBCodeParser */
	public LocalBBCodeParser()
	{	super(8, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IXAspect xa=(IXAspect)context.sourceAspect("this:param:operand", IXAspect.class);
		String text="";
		try
		{	text=xa.getXDA().getText("/nvp/entry", false);
		}
		catch(Exception e)
		{	NetKernelException nke=new NetKernelException("Expected Fragment Reference","You must provide an XPointer fragment reference to the element containg the text to parsed", null);
			nke.addCause(e);
			throw nke;
		};
		
		//Substitute all [xml]...[/xml] blocks.
		StringBuffer from=new StringBuffer(text);
		StringBuffer to=new StringBuffer(2048);
		HashMap map=new HashMap(2);
		Matcher m = mPattern.matcher(from);
		int count=0;
		while (m.find())
		{	String xml=m.group(1);
			String replacement=null;
			try
			{	//Simple pipeline to style XML to XMLVerbatim and then block indent.
				INKFRequest req=context.createSubRequest();
				req.setURI("active:xslt");
				req.addArgument("operand", new StringAspect(xml));
				req.addArgument("operator", "ffcpl:/xlib/styles/xmlverbatim.xsl");
				IURRepresentation result=context.issueSubRequest(req);
				req=context.createSubRequest();
				req.setURI("active:xslt");
				req.addArgument("operand", result);
				req.addArgument("operator", "ffcpl:/resources/XML-Block-Transform.xsl");
				req.setAspectClass(IAspectString.class);
				result=context.issueSubRequest(req);
				IAspectString sa=(IAspectString)result.getAspect(IAspectString.class);
				replacement=sa.getString().replaceAll("\\$", "&#36;");
			}
			catch(Exception e)
			{	Throwable last=e;
				Throwable cause=last.getCause();
				while(cause!=null)
				{	last=cause;
					cause=last.getCause();			
				}
				replacement="<div class=\"forum-xml-error\">Malformed XML: "+XMLUtils.getInstance().escape(last.getMessage())+"</div>";
			}
			String token="XML-BLOCK-IDENTIFIER-"+count;
			count++;
			map.put(token, replacement);
			m.appendReplacement(to, token);
        }
        m.appendTail(to);
		
		//Process BBCode
		BBCodeProcessor bbproc=new BBCodeProcessor();
		bbproc.setAcceptBBCode(true);
		bbproc.setAcceptHTML(false);
		text=bbproc.preparePostText(to.toString());
		
		//Now replace all the XML BLOCKs
		Iterator it=map.keySet().iterator();
		while(it.hasNext())
		{	String token=(String)it.next();
			text=text.replaceFirst(token, (String)map.get(token));
		}
		
		INKFResponse resp=context.createResponseFrom(new StringAspect(text));
		resp.setMimeType("text/html");
		context.setResponse(resp);
	}
	
}
