package org.ten60.netkernel.protocolhandler.nk;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.*;
import java.net.URL;
import java.net.URLConnection;

public class Handler extends java.net.URLStreamHandler
{	
	private static Method sMethod;
	private static ClassLoader sClassLoader;
	
	public static void init(ClassLoader aClassLoader) 
	{	sClassLoader=aClassLoader;
	}
	
	public Handler()
	{	try
		{	Class providerClass = sClassLoader.loadClass("org.netkernel.layer0.util.NKProtocolHandlerRegistry");
			sMethod=providerClass.getMethod("getInputStream", new Class[]{URL.class});
		}
		catch (Exception e)
		{	//silent ignore
		}
	}
	
	static InputStream getInputStream(URL aURL) throws IOException
	{	InputStream result=null;
		try
		{	result=(InputStream)sMethod.invoke(null, new Object[]{aURL});
		}
		catch (InvocationTargetException e)
		{	Throwable e2=e.getTargetException();
			IOException e3;
			if (e2 instanceof IOException)
			{	e3=(IOException)e2;
			}
			else
			{	e3= new IOException();
				e3.initCause(e2);
			}
			throw e3;
		}
		catch (Exception e)
		{	IOException e2 = new IOException();
			e2.initCause(e);
			throw e2;
		}
		return result;
	}	
	
	@Override
	protected URLConnection openConnection(URL u) throws IOException
	{	return new NetKernelURLConnection(u);
	}
}
