#!/bin/bash
######################################################
#NetKernel Startup Script
#v1.4.1
#(C) 2002-2009, 1060 Research Limited
# Acknowledgement:  Thanks to Jeff Rogers for contributing this rewrite
######################################################

isSet() {
   if declare -p "$1" >/dev/null 2>&1 ; then
     return 0
   else
     return 1
   fi
}

push () {
   local -r name=${1?$FUNCNAME: missing name}
   local -r value=${2?$FUNCNAME: missing value}
   [[ $# -eq 2 ]] || argCountError "$#"
   isSet "$name" || eval $(printf "%s=()" "$name")
   local assignment
   assignment=$(printf '%s[${#%s[@]}]=%q' "$name" "$name" "$value")
   eval "$assignment"
}

#Main Path
INSTALLPATH='%INSTALL%'

#######################
#Move to InstallPath so relative paths are correct
#######################
cd "$INSTALLPATH"

#####################
#Get local path
#####################
LIB="$INSTALLPATH/lib"
EXT="$INSTALLPATH/lib/ext"
#####################
#system properties
#####################
push PROPS "-Djava.endorsed.dirs=$LIB/endorsed"

push PROPS "-Dsun.net.client.defaultConnectTimeout=20000"
push PROPS "-Dsun.net.client.defaultReadTimeout=20000"
push PROPS "-Djava.protocol.handler.pkgs=org.ten60.netkernel.protocolhandler"
push PROPS "-Djava.awt.headless=false"
push PROPS "-Dten60.pid=1"   #Process id must be set when using 'netkernel' daemon

#####################
#Debug flag
#####################
if [ "$1" = "-debug" ]
then
	echo "********* JAVA REMOTE DEBUG ENABLED **********"
	push PROPS "-Xdebug"
	push PROPS "-Xrunjdwp:transport=dt_socket,address=8000,suspend=n,server=y"
fi
if [ "$1" = "-help" ]
then
	echo "-debug  (optional) starts remote JVM debugging";
	exit;
fi


#####################
#Start Server
#####################
RUN=1
while [  $RUN -eq 1 ]; do

	#####################
	#Read bootjar.cnf in case externally so that we can replace bootloader with updates
	#####################
	read BOOTLOADER_JAR < "$INSTALLPATH/bin/bootjar.cnf"
	read JVMSETTINGS  < "$INSTALLPATH/bin/jvmsettings.cnf"

	#####################
	#Kernel ClassPath
	#####################
	CP=$INSTALLPATH/lib/$BOOTLOADER_JAR

	#Main Execution
	java $JVMSETTINGS "${PROPS[@]}" -cp "$CP" BootLoader "$INSTALLPATH"
 	
 	if [  $? != 100 ]; then
 		#Normal exit - reboot not requested
		RUN=0
 	fi
done