@echo off
rem ######################################################
rem #NetKernel Startup Script
rem #v1.3.0
rem #(C) 2002-2009, 1060 Research Limited
rem ######################################################
set INSTALLPATH="%INSTALL%"

rem #####################
rem #Get local path
rem #####################
set LIB=%INSTALLPATH%\lib
set EXT=%INSTALLPATH%\lib\ext

rem #######################
rem #Move to InstallPath so relative paths are correct
rem #######################
cd %INSTALLPATH%


rem #####################
rem #system properties
rem #####################
set PROPS=-Djava.endorsed.dirs=%LIB%\endorsed
set PROPS=%PROPS% -Djava.protocol.handler.pkgs=org.ten60.netkernel.protocolhandler
set PROPS=%PROPS% -Dsun.net.client.defaultConnectTimeout=20000
set PROPS=%PROPS% -Dsun.net.client.defaultReadTimeout=20000

rem #####################
rem #Kernel ClassPath
rem #####################
set CP=%BOOTLOADER_JAR%

rem #####################
rem #Start Kernel
rem #####################

:BOOT

rem #####################
rem #Read bootjar.cnf in case externally so that we can replace bootloader with updates
rem #####################
set /p BOOTLOADER_JAR=<%INSTALLPATH%\bin\bootjar.cnf
set /p JVMSETTINGS=<%INSTALLPATH%\bin\jvmsettings.cnf

rem #####################
rem #Kernel ClassPath
rem #####################
set CP=%INSTALLPATH%\lib\%BOOTLOADER_JAR%

java %JVMSETTINGS% %PROPS% -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,suspend=n,server=y -cp %CP% BootLoader %INSTALLPATH%
IF ERRORLEVEL 100 GOTO BOOT
