/******************************************************************************
 * (c) Copyright 2002,2007, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile$
 * Version:       $Name$ $Revision$
 * Last Modified: $Date$
 *****************************************************************************/

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;

import org.netkernel.container.ILogger;
import org.netkernel.container.impl.Kernel;
import org.netkernel.layer0.boot.IModuleFactory;
import org.netkernel.layer0.boot.ModuleManager;

import com.ten60.netkernel.cache.se.representation2.ConcurrentCache;
import com.ten60.netkernel.cache.se.resolution.ResolutionCache;

import org.netkernel.layer0.logging.LogManager;
import org.netkernel.layer0.logging.KernelLog;
import org.netkernel.layer0.module.java.JavaModuleFactory;
import org.netkernel.layer0.tools.*;
import org.netkernel.layer0.util.FastSchematron;
import org.netkernel.layer0.util.PropertyConfiguration;
import org.netkernel.module.standard.StandardModuleFactory;
import org.netkernel.urii.*;

public class InnerBoot
{
	static final String HTTP_PROXY_HOST="http.proxyHost";
	static final String HTTP_PROXY_PORT="http.proxyPort";
	static final int REBOOT_EXIT_CODE=100;
	
	public InnerBoot(File aBasepath)
	{	Kernel k = new Kernel();
		ModuleManager mm=null;
		ConcurrentCache cache=null;
		boolean reboot=false;
		try
		{			
			// construct and set logger
			/*
			Logger logger = new Logger();
			k.setLogger(logger);
			k.addConfigurationListener(logger);
			new LogManager(k);
			*/
			ILogger logger=new LogManager(aBasepath.getCanonicalPath()).getKernelLogger();
			
			// construct and set kernel configuration provider
			PropertyConfiguration config = new PropertyConfiguration(InnerBoot.class.getClassLoader().getResource("etc/kernel.properties"),logger);
			config.setProperty("netkernel.install.path", aBasepath.toURI().toString());
			config.setProperty("netkernel.boot.time", Long.toString(System.currentTimeMillis()));
			k.setConfiguration(config);
			k.setLogger(logger);
			
			//Handle HTTP Proxy Settings
			String proxySetting=config.getString(HTTP_PROXY_HOST);
			if(!proxySetting.startsWith("%"))
			{	System.setProperty(HTTP_PROXY_HOST, proxySetting);				
			}
			proxySetting=config.getString(HTTP_PROXY_PORT);
			if(!proxySetting.startsWith("%"))
			{	System.setProperty(HTTP_PROXY_PORT, proxySetting);				
			}
			
			//initialise mimetype stuff
			ExtraMimeTypes emt =ExtraMimeTypes.getInstance();
			
			// construct and set cache implementation
			cache = new ConcurrentCache(k);
			k.setRepresentationCache(cache);
			k.addConfigurationListener(cache);
			ResolutionCache rcache = new ResolutionCache(k);
			k.setResolutionCache(rcache);
			k.addConfigurationListener(rcache);
			
			EndpointMonitor monitor = new EndpointMonitor(k);
			k.addConfigurationListener(monitor);
			k.setMonitor(monitor);
			
			FastSchematron.loadValidationCache();
						
			//create module manager with factories
			IModuleFactory[] factories = new IModuleFactory[] { new StandardModuleFactory(),  new JavaModuleFactory() };			
			mm = new ModuleManager(k,factories);
			mm.setPropertyConfiguration(config);
			mm.setRunLevel(0);
			
			// load the module deployment list
			URI base = aBasepath.toURI();
			InputStream is = InnerBoot.class.getClassLoader().getResourceAsStream(config.getString("netkernel.init.stem.modules"));
			BufferedReader r = new BufferedReader(new InputStreamReader(is));
			String line;
			while ((line=r.readLine())!=null)
			{	line=line.trim();
				if (!line.startsWith("#") && line.length()>0)
				{	URI source = base.resolve(line);
					mm.addModule(source,1);
				}
			}			
			mm.setRunLevel(1);
			mm.notifySyncListener();
			
			FastSchematron.saveValidationCache();
			
			ShutdownMonitor.waitForShutdownRequest();
			reboot=ShutdownMonitor.rebootFlag();
			
			mm.stop();
			
		}
		catch (Throwable e)
		{	System.out.println(e.toString());
			if (! (e instanceof INetKernelThrowable))
			{	e.printStackTrace();
			}
		}
		finally
		{	// stop kernel cleanly
			if (mm!=null)
			{	mm.stop();
			}
			if (cache!=null)
			{	cache.stop();
			}
			FastSchematron.saveValidationCache();
			if(reboot)
			{	Runtime.getRuntime().exit(REBOOT_EXIT_CODE);				
			}
		}
		
	}
	
}