@echo off
rem ######################################################
rem #NetKernel Startup Script
rem #v1.2.1
rem #(C) 2008, 1060 Research Limited
rem ######################################################
set INSTALLPATH="%INSTALL%"
set BOOTLOADER_JAR="%BOOTLOADER%"

rem #####################
rem #Get local path
rem #####################
set LIB=%INSTALLPATH%\lib
set EXT=%INSTALLPATH%\lib\ext

rem #######################
rem #Move to InstallPath so relative paths are correct
rem #######################
cd %INSTALLPATH%


rem #####################
rem #system properties
rem #####################
set PROPS=-Djava.endorsed.dirs=%LIB%\endorsed
set PROPS=%PROPS% -Djava.protocol.handler.pkgs=com.ten60.netkernel
set PROPS=%PROPS% -Dsun.net.client.defaultConnectTimeout=20000
set PROPS=%PROPS% -Dsun.net.client.defaultReadTimeout=20000

rem #####################
rem #Kernel ClassPath
rem #####################
set CP=%BOOTLOADER_JAR%

rem #####################
rem #Start Kernel
rem #####################

:BOOT
java -Xmx128m -Xms128m -XX:SoftRefLRUPolicyMSPerMB=100 %PROPS% -cp %CP% BootLoader %INSTALLPATH%
IF ERRORLEVEL 100 GOTO BOOT
