.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP ROLE" "" "2007-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP ROLE \- remove a database role

.SH SYNOPSIS
.sp
.nf
DROP ROLE \fIname\fR [, ...]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP ROLE\fR removes the specified role(s).
To drop a superuser role, you must be a superuser yourself;
to drop non-superuser roles, you must have CREATEROLE
privilege.
.PP
A role cannot be removed if it is still referenced in any database
of the cluster; an error will be raised if so. Before dropping the role,
you must drop all the objects it owns (or reassign their ownership)
and revoke any privileges the role has been granted.
.PP
However, it is not necessary to remove role memberships involving
the role; \fBDROP ROLE\fR automatically revokes any memberships
of the target role in other roles, and of other roles in the target role.
The other roles are not dropped nor otherwise affected.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the role to remove.
.SH "NOTES"
.PP
PostgreSQL includes a program dropuser [\fBdropuser\fR(1)] that has the
same functionality as this command (in fact, it calls this command)
but can be run from the command shell.
.SH "EXAMPLES"
.PP
To drop a role:
.sp
.nf
DROP ROLE jonathan;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL standard defines \fBDROP ROLE\fR, but it allows
only one role to be dropped at a time, and it specifies different
privilege requirements than PostgreSQL uses.
.SH "SEE ALSO"
CREATE ROLE [\fBcreate_role\fR(l)], ALTER ROLE [\fBalter_role\fR(l)], SET ROLE [\fBset_role\fR(l)]
