/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_REFERENCE = 290,
     SQL_RETURNED_LENGTH = 291,
     SQL_RETURNED_OCTET_LENGTH = 292,
     SQL_SCALE = 293,
     SQL_SECTION = 294,
     SQL_SHORT = 295,
     SQL_SIGNED = 296,
     SQL_SQL = 297,
     SQL_SQLERROR = 298,
     SQL_SQLPRINT = 299,
     SQL_SQLWARNING = 300,
     SQL_START = 301,
     SQL_STOP = 302,
     SQL_STRUCT = 303,
     SQL_UNSIGNED = 304,
     SQL_VALUE = 305,
     SQL_VAR = 306,
     SQL_WHENEVER = 307,
     S_ADD = 308,
     S_AND = 309,
     S_ANYTHING = 310,
     S_AUTO = 311,
     S_CONST = 312,
     S_DEC = 313,
     S_DIV = 314,
     S_DOTPOINT = 315,
     S_EQUAL = 316,
     S_EXTERN = 317,
     S_INC = 318,
     S_LSHIFT = 319,
     S_MEMPOINT = 320,
     S_MEMBER = 321,
     S_MOD = 322,
     S_MUL = 323,
     S_NEQUAL = 324,
     S_OR = 325,
     S_REGISTER = 326,
     S_RSHIFT = 327,
     S_STATIC = 328,
     S_SUB = 329,
     S_VOLATILE = 330,
     S_TYPEDEF = 331,
     TYPECAST = 332,
     ABORT_P = 333,
     ABSOLUTE_P = 334,
     ACCESS = 335,
     ACTION = 336,
     ADD = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CSV = 393,
     CURRENT_DATE = 394,
     CURRENT_TIME = 395,
     CURRENT_TIMESTAMP = 396,
     CURRENT_USER = 397,
     CURSOR = 398,
     CYCLE = 399,
     DATABASE = 400,
     DAY_P = 401,
     DEALLOCATE = 402,
     DEC = 403,
     DECIMAL_P = 404,
     DECLARE = 405,
     DEFAULT = 406,
     DEFAULTS = 407,
     DEFERRABLE = 408,
     DEFERRED = 409,
     DEFINER = 410,
     DELETE_P = 411,
     DELIMITER = 412,
     DELIMITERS = 413,
     DESC = 414,
     DISTINCT = 415,
     DO = 416,
     DOMAIN_P = 417,
     DOUBLE_P = 418,
     DROP = 419,
     EACH = 420,
     ELSE = 421,
     ENCODING = 422,
     ENCRYPTED = 423,
     END_P = 424,
     ESCAPE = 425,
     EXCEPT = 426,
     EXCLUSIVE = 427,
     EXCLUDING = 428,
     EXECUTE = 429,
     EXISTS = 430,
     EXPLAIN = 431,
     EXTERNAL = 432,
     EXTRACT = 433,
     FALSE_P = 434,
     FETCH = 435,
     FIRST_P = 436,
     FLOAT_P = 437,
     FOR = 438,
     FORCE = 439,
     FOREIGN = 440,
     FORWARD = 441,
     FREEZE = 442,
     FROM = 443,
     FULL = 444,
     FUNCTION = 445,
     GET = 446,
     GLOBAL = 447,
     GRANT = 448,
     GROUP_P = 449,
     HANDLER = 450,
     HAVING = 451,
     HOLD = 452,
     HOUR_P = 453,
     ILIKE = 454,
     IMMEDIATE = 455,
     IMMUTABLE = 456,
     IMPLICIT_P = 457,
     IN_P = 458,
     INCLUDING = 459,
     INCREMENT = 460,
     INDEX = 461,
     INHERITS = 462,
     INITIALLY = 463,
     INNER_P = 464,
     INOUT = 465,
     INPUT_P = 466,
     INSENSITIVE = 467,
     INSERT = 468,
     INSTEAD = 469,
     INT_P = 470,
     INTEGER = 471,
     INTERSECT = 472,
     INTERVAL = 473,
     INTO = 474,
     INVOKER = 475,
     IS = 476,
     ISNULL = 477,
     ISOLATION = 478,
     JOIN = 479,
     KEY = 480,
     LANCOMPILER = 481,
     LANGUAGE = 482,
     LARGE_P = 483,
     LAST_P = 484,
     LEADING = 485,
     LEFT = 486,
     LEVEL = 487,
     LIKE = 488,
     LIMIT = 489,
     LISTEN = 490,
     LOAD = 491,
     LOCAL = 492,
     LOCATION = 493,
     LOCK_P = 494,
     MATCH = 495,
     MAXVALUE = 496,
     MINUTE_P = 497,
     MINVALUE = 498,
     MODE = 499,
     MONTH_P = 500,
     MOVE = 501,
     NAMES = 502,
     NATIONAL = 503,
     NATURAL = 504,
     NCHAR = 505,
     NEW = 506,
     NEXT = 507,
     NO = 508,
     NOCREATEDB = 509,
     NOCREATEUSER = 510,
     NONE = 511,
     NOT = 512,
     NOTHING = 513,
     NOTIFY = 514,
     NOTNULL = 515,
     NOWAIT = 516,
     NULL_P = 517,
     NULLIF = 518,
     NUMERIC = 519,
     OBJECT_P = 520,
     OF = 521,
     OFF = 522,
     OFFSET = 523,
     OIDS = 524,
     OLD = 525,
     ON = 526,
     ONLY = 527,
     OPERATOR = 528,
     OPTION = 529,
     OR = 530,
     ORDER = 531,
     OUT_P = 532,
     OUTER_P = 533,
     OVERLAPS = 534,
     OVERLAY = 535,
     OWNER = 536,
     PARTIAL = 537,
     PASSWORD = 538,
     PLACING = 539,
     POSITION = 540,
     PRECISION = 541,
     PRESERVE = 542,
     PREPARE = 543,
     PRIMARY = 544,
     PRIOR = 545,
     PRIVILEGES = 546,
     PROCEDURAL = 547,
     PROCEDURE = 548,
     QUOTE = 549,
     READ = 550,
     REAL = 551,
     RECHECK = 552,
     REFERENCES = 553,
     REINDEX = 554,
     RELATIVE_P = 555,
     RELEASE = 556,
     RENAME = 557,
     REPEATABLE = 558,
     REPLACE = 559,
     RESET = 560,
     RESTART = 561,
     RESTRICT = 562,
     RETURNS = 563,
     REVOKE = 564,
     RIGHT = 565,
     ROLLBACK = 566,
     ROW = 567,
     ROWS = 568,
     RULE = 569,
     SAVEPOINT = 570,
     SCHEMA = 571,
     SCROLL = 572,
     SECOND_P = 573,
     SECURITY = 574,
     SELECT = 575,
     SEQUENCE = 576,
     SERIALIZABLE = 577,
     SESSION = 578,
     SESSION_USER = 579,
     SET = 580,
     SETOF = 581,
     SHARE = 582,
     SHOW = 583,
     SIMILAR = 584,
     SIMPLE = 585,
     SMALLINT = 586,
     SOME = 587,
     STABLE = 588,
     START = 589,
     STATEMENT = 590,
     STATISTICS = 591,
     STDIN = 592,
     STDOUT = 593,
     STORAGE = 594,
     STRICT_P = 595,
     SUBSTRING = 596,
     SYSID = 597,
     TABLE = 598,
     TABLESPACE = 599,
     TEMP = 600,
     TEMPLATE = 601,
     TEMPORARY = 602,
     THEN = 603,
     TIME = 604,
     TIMESTAMP = 605,
     TO = 606,
     TOAST = 607,
     TRAILING = 608,
     TRANSACTION = 609,
     TREAT = 610,
     TRIGGER = 611,
     TRIM = 612,
     TRUE_P = 613,
     TRUNCATE = 614,
     TRUSTED = 615,
     TYPE_P = 616,
     UNCOMMITTED = 617,
     UNENCRYPTED = 618,
     UNION = 619,
     UNIQUE = 620,
     UNKNOWN = 621,
     UNLISTEN = 622,
     UNTIL = 623,
     UPDATE = 624,
     USAGE = 625,
     USER = 626,
     USING = 627,
     VACUUM = 628,
     VALID = 629,
     VALUES = 630,
     VARCHAR = 631,
     VARYING = 632,
     VERBOSE = 633,
     VIEW = 634,
     VOLATILE = 635,
     WHEN = 636,
     WHERE = 637,
     WITH = 638,
     WITHOUT = 639,
     WORK = 640,
     WRITE = 641,
     YEAR_P = 642,
     ZONE = 643,
     UNIONJOIN = 644,
     IDENT = 645,
     SCONST = 646,
     Op = 647,
     CSTRING = 648,
     CVARIABLE = 649,
     CPP_LINE = 650,
     IP = 651,
     BCONST = 652,
     XCONST = 653,
     ICONST = 654,
     PARAM = 655,
     FCONST = 656,
     POSTFIXOP = 657,
     UMINUS = 658
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_REFERENCE 290
#define SQL_RETURNED_LENGTH 291
#define SQL_RETURNED_OCTET_LENGTH 292
#define SQL_SCALE 293
#define SQL_SECTION 294
#define SQL_SHORT 295
#define SQL_SIGNED 296
#define SQL_SQL 297
#define SQL_SQLERROR 298
#define SQL_SQLPRINT 299
#define SQL_SQLWARNING 300
#define SQL_START 301
#define SQL_STOP 302
#define SQL_STRUCT 303
#define SQL_UNSIGNED 304
#define SQL_VALUE 305
#define SQL_VAR 306
#define SQL_WHENEVER 307
#define S_ADD 308
#define S_AND 309
#define S_ANYTHING 310
#define S_AUTO 311
#define S_CONST 312
#define S_DEC 313
#define S_DIV 314
#define S_DOTPOINT 315
#define S_EQUAL 316
#define S_EXTERN 317
#define S_INC 318
#define S_LSHIFT 319
#define S_MEMPOINT 320
#define S_MEMBER 321
#define S_MOD 322
#define S_MUL 323
#define S_NEQUAL 324
#define S_OR 325
#define S_REGISTER 326
#define S_RSHIFT 327
#define S_STATIC 328
#define S_SUB 329
#define S_VOLATILE 330
#define S_TYPEDEF 331
#define TYPECAST 332
#define ABORT_P 333
#define ABSOLUTE_P 334
#define ACCESS 335
#define ACTION 336
#define ADD 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CSV 393
#define CURRENT_DATE 394
#define CURRENT_TIME 395
#define CURRENT_TIMESTAMP 396
#define CURRENT_USER 397
#define CURSOR 398
#define CYCLE 399
#define DATABASE 400
#define DAY_P 401
#define DEALLOCATE 402
#define DEC 403
#define DECIMAL_P 404
#define DECLARE 405
#define DEFAULT 406
#define DEFAULTS 407
#define DEFERRABLE 408
#define DEFERRED 409
#define DEFINER 410
#define DELETE_P 411
#define DELIMITER 412
#define DELIMITERS 413
#define DESC 414
#define DISTINCT 415
#define DO 416
#define DOMAIN_P 417
#define DOUBLE_P 418
#define DROP 419
#define EACH 420
#define ELSE 421
#define ENCODING 422
#define ENCRYPTED 423
#define END_P 424
#define ESCAPE 425
#define EXCEPT 426
#define EXCLUSIVE 427
#define EXCLUDING 428
#define EXECUTE 429
#define EXISTS 430
#define EXPLAIN 431
#define EXTERNAL 432
#define EXTRACT 433
#define FALSE_P 434
#define FETCH 435
#define FIRST_P 436
#define FLOAT_P 437
#define FOR 438
#define FORCE 439
#define FOREIGN 440
#define FORWARD 441
#define FREEZE 442
#define FROM 443
#define FULL 444
#define FUNCTION 445
#define GET 446
#define GLOBAL 447
#define GRANT 448
#define GROUP_P 449
#define HANDLER 450
#define HAVING 451
#define HOLD 452
#define HOUR_P 453
#define ILIKE 454
#define IMMEDIATE 455
#define IMMUTABLE 456
#define IMPLICIT_P 457
#define IN_P 458
#define INCLUDING 459
#define INCREMENT 460
#define INDEX 461
#define INHERITS 462
#define INITIALLY 463
#define INNER_P 464
#define INOUT 465
#define INPUT_P 466
#define INSENSITIVE 467
#define INSERT 468
#define INSTEAD 469
#define INT_P 470
#define INTEGER 471
#define INTERSECT 472
#define INTERVAL 473
#define INTO 474
#define INVOKER 475
#define IS 476
#define ISNULL 477
#define ISOLATION 478
#define JOIN 479
#define KEY 480
#define LANCOMPILER 481
#define LANGUAGE 482
#define LARGE_P 483
#define LAST_P 484
#define LEADING 485
#define LEFT 486
#define LEVEL 487
#define LIKE 488
#define LIMIT 489
#define LISTEN 490
#define LOAD 491
#define LOCAL 492
#define LOCATION 493
#define LOCK_P 494
#define MATCH 495
#define MAXVALUE 496
#define MINUTE_P 497
#define MINVALUE 498
#define MODE 499
#define MONTH_P 500
#define MOVE 501
#define NAMES 502
#define NATIONAL 503
#define NATURAL 504
#define NCHAR 505
#define NEW 506
#define NEXT 507
#define NO 508
#define NOCREATEDB 509
#define NOCREATEUSER 510
#define NONE 511
#define NOT 512
#define NOTHING 513
#define NOTIFY 514
#define NOTNULL 515
#define NOWAIT 516
#define NULL_P 517
#define NULLIF 518
#define NUMERIC 519
#define OBJECT_P 520
#define OF 521
#define OFF 522
#define OFFSET 523
#define OIDS 524
#define OLD 525
#define ON 526
#define ONLY 527
#define OPERATOR 528
#define OPTION 529
#define OR 530
#define ORDER 531
#define OUT_P 532
#define OUTER_P 533
#define OVERLAPS 534
#define OVERLAY 535
#define OWNER 536
#define PARTIAL 537
#define PASSWORD 538
#define PLACING 539
#define POSITION 540
#define PRECISION 541
#define PRESERVE 542
#define PREPARE 543
#define PRIMARY 544
#define PRIOR 545
#define PRIVILEGES 546
#define PROCEDURAL 547
#define PROCEDURE 548
#define QUOTE 549
#define READ 550
#define REAL 551
#define RECHECK 552
#define REFERENCES 553
#define REINDEX 554
#define RELATIVE_P 555
#define RELEASE 556
#define RENAME 557
#define REPEATABLE 558
#define REPLACE 559
#define RESET 560
#define RESTART 561
#define RESTRICT 562
#define RETURNS 563
#define REVOKE 564
#define RIGHT 565
#define ROLLBACK 566
#define ROW 567
#define ROWS 568
#define RULE 569
#define SAVEPOINT 570
#define SCHEMA 571
#define SCROLL 572
#define SECOND_P 573
#define SECURITY 574
#define SELECT 575
#define SEQUENCE 576
#define SERIALIZABLE 577
#define SESSION 578
#define SESSION_USER 579
#define SET 580
#define SETOF 581
#define SHARE 582
#define SHOW 583
#define SIMILAR 584
#define SIMPLE 585
#define SMALLINT 586
#define SOME 587
#define STABLE 588
#define START 589
#define STATEMENT 590
#define STATISTICS 591
#define STDIN 592
#define STDOUT 593
#define STORAGE 594
#define STRICT_P 595
#define SUBSTRING 596
#define SYSID 597
#define TABLE 598
#define TABLESPACE 599
#define TEMP 600
#define TEMPLATE 601
#define TEMPORARY 602
#define THEN 603
#define TIME 604
#define TIMESTAMP 605
#define TO 606
#define TOAST 607
#define TRAILING 608
#define TRANSACTION 609
#define TREAT 610
#define TRIGGER 611
#define TRIM 612
#define TRUE_P 613
#define TRUNCATE 614
#define TRUSTED 615
#define TYPE_P 616
#define UNCOMMITTED 617
#define UNENCRYPTED 618
#define UNION 619
#define UNIQUE 620
#define UNKNOWN 621
#define UNLISTEN 622
#define UNTIL 623
#define UPDATE 624
#define USAGE 625
#define USER 626
#define USING 627
#define VACUUM 628
#define VALID 629
#define VALUES 630
#define VARCHAR 631
#define VARYING 632
#define VERBOSE 633
#define VIEW 634
#define VOLATILE 635
#define WHEN 636
#define WHERE 637
#define WITH 638
#define WITHOUT 639
#define WORK 640
#define WRITE 641
#define YEAR_P 642
#define ZONE 643
#define UNIONJOIN 644
#define IDENT 645
#define SCONST 646
#define Op 647
#define CSTRING 648
#define CVARIABLE 649
#define CPP_LINE 650
#define IP 651
#define BCONST 652
#define XCONST 653
#define ICONST 654
#define PARAM 655
#define FCONST 656
#define POSTFIXOP 657
#define UMINUS 658




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 311 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1202 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1214 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   51447

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  424
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  514
/* YYNRULES -- Number of rules. */
#define YYNRULES  1941
/* YYNRULES -- Number of states. */
#define YYNSTATES  3189

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   659

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   410,     2,     2,
     415,   416,   408,   406,   421,   407,   417,   409,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   423,   418,
     403,   402,   404,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   413,     2,   414,   411,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   419,     2,   420,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   405,   412,   422
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   224,   226,   227,
     232,   238,   244,   249,   253,   256,   257,   260,   263,   265,
     267,   269,   271,   275,   279,   283,   285,   290,   296,   299,
     300,   303,   306,   313,   320,   324,   331,   336,   338,   339,
     342,   343,   345,   347,   349,   351,   353,   355,   358,   362,
     366,   370,   374,   378,   381,   387,   390,   394,   398,   400,
     404,   406,   408,   410,   414,   417,   420,   423,   425,   427,
     429,   431,   433,   435,   437,   439,   441,   443,   447,   454,
     456,   458,   460,   462,   463,   465,   467,   470,   474,   479,
     483,   486,   489,   493,   498,   502,   505,   510,   512,   514,
     516,   518,   520,   525,   530,   532,   536,   540,   545,   552,
     559,   566,   573,   578,   585,   588,   593,   597,   601,   605,
     609,   611,   615,   619,   623,   627,   630,   632,   634,   635,
     638,   639,   642,   652,   654,   656,   658,   660,   662,   665,
     666,   668,   670,   674,   678,   680,   684,   688,   692,   697,
     699,   700,   703,   704,   708,   709,   711,   712,   724,   737,
     739,   741,   744,   747,   750,   753,   754,   756,   757,   759,
     763,   765,   767,   769,   773,   776,   777,   781,   783,   785,
     788,   790,   793,   797,   802,   805,   811,   813,   816,   819,
     822,   826,   829,   832,   833,   837,   839,   844,   850,   857,
     869,   873,   874,   878,   880,   882,   885,   888,   889,   891,
     893,   896,   899,   900,   904,   908,   911,   913,   915,   918,
     921,   926,   927,   930,   933,   934,   938,   943,   948,   949,
     952,   953,   958,   959,   960,   969,   973,   977,   979,   983,
     984,   988,   990,   992,   998,  1003,  1006,  1007,  1010,  1012,
    1015,  1019,  1022,  1025,  1028,  1031,  1035,  1039,  1041,  1042,
    1051,  1053,  1054,  1056,  1059,  1062,  1063,  1069,  1071,  1072,
    1079,  1082,  1083,  1087,  1102,  1122,  1124,  1126,  1128,  1132,
    1138,  1140,  1142,  1144,  1148,  1149,  1151,  1152,  1154,  1156,
    1158,  1162,  1163,  1165,  1167,  1168,  1171,  1173,  1176,  1178,
    1181,  1184,  1186,  1189,  1192,  1199,  1208,  1212,  1217,  1222,
    1227,  1233,  1237,  1241,  1243,  1247,  1251,  1253,  1255,  1257,
    1259,  1272,  1274,  1278,  1283,  1291,  1296,  1299,  1301,  1302,
    1304,  1305,  1313,  1318,  1320,  1322,  1324,  1326,  1328,  1330,
    1332,  1334,  1336,  1340,  1342,  1345,  1348,  1352,  1356,  1362,
    1367,  1372,  1376,  1381,  1385,  1389,  1392,  1397,  1400,  1402,
    1404,  1406,  1408,  1411,  1414,  1416,  1418,  1420,  1423,  1426,
    1428,  1431,  1434,  1436,  1438,  1440,  1447,  1457,  1465,  1475,
    1484,  1493,  1500,  1510,  1518,  1529,  1537,  1539,  1541,  1543,
    1545,  1547,  1549,  1551,  1553,  1555,  1557,  1559,  1561,  1569,
    1578,  1581,  1583,  1585,  1587,  1591,  1593,  1595,  1597,  1599,
    1601,  1603,  1605,  1607,  1609,  1611,  1613,  1615,  1617,  1620,
    1623,  1626,  1629,  1632,  1635,  1637,  1641,  1643,  1646,  1650,
    1651,  1655,  1656,  1658,  1662,  1665,  1678,  1680,  1681,  1684,
    1685,  1687,  1691,  1694,  1697,  1702,  1704,  1707,  1708,  1718,
    1721,  1722,  1726,  1729,  1731,  1735,  1739,  1742,  1744,  1746,
    1748,  1749,  1751,  1755,  1757,  1759,  1761,  1766,  1768,  1771,
    1774,  1777,  1779,  1781,  1783,  1788,  1794,  1796,  1800,  1804,
    1807,  1810,  1813,  1814,  1820,  1828,  1830,  1832,  1840,  1842,
    1846,  1850,  1854,  1856,  1860,  1872,  1883,  1886,  1887,  1896,
    1901,  1906,  1908,  1910,  1912,  1913,  1923,  1930,  1937,  1945,
    1952,  1959,  1969,  1976,  1983,  1990,  1999,  2008,  2015,  2022,
    2024,  2025,  2035,  2042,  2049,  2056,  2064,  2074,  2084,  2091,
    2098,  2105,  2106,  2121,  2123,  2125,  2129,  2133,  2135,  2137,
    2139,  2141,  2143,  2145,  2147,  2148,  2150,  2152,  2154,  2156,
    2158,  2160,  2161,  2168,  2171,  2174,  2177,  2180,  2183,  2187,
    2191,  2194,  2197,  2200,  2203,  2207,  2210,  2216,  2221,  2223,
    2225,  2226,  2230,  2233,  2236,  2238,  2242,  2245,  2247,  2248,
    2256,  2259,  2265,  2269,  2271,  2274,  2278,  2282,  2286,  2290,
    2294,  2298,  2302,  2306,  2310,  2314,  2316,  2317,  2323,  2328,
    2332,  2339,  2344,  2351,  2358,  2364,  2372,  2374,  2375,  2386,
    2391,  2394,  2396,  2401,  2407,  2413,  2416,  2421,  2423,  2425,
    2427,  2428,  2430,  2431,  2433,  2434,  2438,  2439,  2444,  2446,
    2448,  2450,  2452,  2454,  2456,  2457,  2462,  2467,  2470,  2472,
    2480,  2485,  2489,  2491,  2494,  2499,  2505,  2509,  2510,  2513,
    2516,  2519,  2523,  2525,  2529,  2531,  2534,  2536,  2537,  2544,
    2552,  2553,  2556,  2559,  2562,  2566,  2567,  2570,  2573,  2575,
    2577,  2581,  2585,  2587,  2590,  2595,  2600,  2602,  2604,  2613,
    2618,  2623,  2628,  2631,  2633,  2634,  2638,  2642,  2647,  2652,
    2657,  2662,  2665,  2667,  2669,  2670,  2672,  2673,  2675,  2681,
    2683,  2684,  2686,  2687,  2691,  2693,  2697,  2701,  2704,  2707,
    2709,  2714,  2719,  2722,  2725,  2730,  2732,  2733,  2735,  2737,
    2739,  2743,  2744,  2747,  2748,  2752,  2756,  2758,  2759,  2762,
    2763,  2766,  2767,  2771,  2773,  2775,  2778,  2780,  2783,  2789,
    2796,  2802,  2804,  2807,  2809,  2814,  2818,  2823,  2827,  2833,
    2838,  2844,  2849,  2855,  2858,  2863,  2865,  2868,  2871,  2874,
    2876,  2878,  2879,  2884,  2887,  2889,  2892,  2895,  2900,  2902,
    2905,  2906,  2908,  2912,  2915,  2918,  2922,  2928,  2935,  2939,
    2944,  2945,  2947,  2951,  2955,  2959,  2963,  2967,  2971,  2973,
    2975,  2977,  2979,  2981,  2983,  2985,  2988,  2994,  2997,  2999,
    3001,  3003,  3005,  3007,  3009,  3011,  3013,  3015,  3017,  3019,
    3022,  3025,  3028,  3031,  3034,  3036,  3040,  3041,  3047,  3051,
    3052,  3058,  3062,  3063,  3065,  3067,  3069,  3071,  3077,  3080,
    3082,  3084,  3086,  3088,  3094,  3097,  3100,  3103,  3105,  3109,
    3113,  3116,  3118,  3119,  3123,  3124,  3130,  3133,  3139,  3142,
    3144,  3148,  3152,  3153,  3155,  3157,  3159,  3161,  3163,  3165,
    3169,  3173,  3177,  3181,  3185,  3189,  3193,  3194,  3196,  3200,
    3206,  3209,  3212,  3215,  3218,  3221,  3224,  3228,  3232,  3236,
    3240,  3244,  3248,  3252,  3256,  3260,  3264,  3267,  3270,  3274,
    3278,  3281,  3285,  3291,  3296,  3303,  3307,  3313,  3318,  3325,
    3330,  3337,  3343,  3351,  3354,  3358,  3361,  3366,  3370,  3375,
    3379,  3384,  3388,  3393,  3399,  3406,  3414,  3420,  3427,  3431,
    3436,  3441,  3448,  3451,  3453,  3457,  3460,  3463,  3466,  3469,
    3472,  3476,  3480,  3484,  3488,  3492,  3496,  3500,  3504,  3508,
    3512,  3515,  3518,  3524,  3531,  3539,  3541,  3543,  3546,  3551,
    3553,  3555,  3557,  3560,  3563,  3566,  3568,  3572,  3577,  3583,
    3589,  3594,  3596,  3599,  3604,  3607,  3612,  3615,  3618,  3621,
    3628,  3633,  3638,  3643,  3648,  3655,  3661,  3667,  3673,  3678,
    3685,  3690,  3697,  3702,  3707,  3711,  3717,  3719,  3721,  3723,
    3725,  3727,  3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,
    3745,  3747,  3752,  3754,  3759,  3761,  3766,  3768,  3771,  3773,
    3776,  3778,  3782,  3786,  3787,  3791,  3793,  3795,  3799,  3803,
    3807,  3809,  3811,  3813,  3815,  3817,  3819,  3821,  3823,  3828,
    3832,  3835,  3839,  3840,  3844,  3848,  3851,  3854,  3856,  3857,
    3860,  3863,  3867,  3870,  3872,  3874,  3878,  3884,  3887,  3889,
    3894,  3897,  3898,  3900,  3901,  3903,  3906,  3909,  3912,  3916,
    3922,  3924,  3927,  3928,  3931,  3934,  3935,  3939,  3941,  3945,
    3947,  3949,  3953,  3961,  3963,  3966,  3971,  3973,  3977,  3982,
    3987,  3991,  3993,  3995,  3997,  3999,  4001,  4003,  4007,  4009,
    4012,  4014,  4018,  4020,  4022,  4024,  4026,  4028,  4030,  4032,
    4035,  4037,  4040,  4044,  4051,  4053,  4055,  4057,  4059,  4061,
    4063,  4065,  4067,  4069,  4071,  4073,  4075,  4078,  4080,  4082,
    4084,  4086,  4089,  4092,  4094,  4096,  4098,  4100,  4102,  4104,
    4106,  4108,  4111,  4114,  4116,  4118,  4120,  4122,  4124,  4126,
    4128,  4130,  4132,  4134,  4136,  4138,  4144,  4148,  4151,  4154,
    4158,  4166,  4168,  4170,  4173,  4176,  4178,  4179,  4181,  4185,
    4187,  4190,  4191,  4194,  4195,  4198,  4199,  4201,  4205,  4210,
    4214,  4216,  4218,  4220,  4223,  4224,  4232,  4236,  4239,  4241,
    4243,  4245,  4246,  4252,  4253,  4258,  4261,  4263,  4266,  4267,
    4269,  4273,  4277,  4281,  4285,  4286,  4291,  4297,  4303,  4304,
    4306,  4308,  4310,  4313,  4316,  4318,  4321,  4322,  4330,  4331,
    4337,  4338,  4343,  4346,  4349,  4351,  4353,  4355,  4357,  4359,
    4361,  4363,  4365,  4367,  4369,  4371,  4377,  4380,  4382,  4386,
    4389,  4392,  4396,  4397,  4403,  4405,  4406,  4412,  4415,  4418,
    4420,  4422,  4424,  4427,  4430,  4434,  4436,  4439,  4442,  4446,
    4450,  4455,  4458,  4460,  4463,  4465,  4467,  4470,  4473,  4477,
    4479,  4481,  4483,  4485,  4486,  4488,  4492,  4497,  4498,  4501,
    4502,  4504,  4507,  4511,  4514,  4516,  4518,  4520,  4521,  4523,
    4525,  4529,  4530,  4535,  4538,  4541,  4543,  4545,  4546,  4548,
    4550,  4552,  4554,  4557,  4561,  4562,  4564,  4567,  4569,  4574,
    4579,  4580,  4582,  4585,  4587,  4589,  4593,  4595,  4597,  4602,
    4607,  4612,  4617,  4619,  4620,  4624,  4628,  4633,  4635,  4639,
    4643,  4648,  4650,  4654,  4658,  4660,  4667,  4669,  4673,  4677,
    4684,  4686,  4690,  4694,  4696,  4698,  4700,  4702,  4704,  4706,
    4708,  4710,  4712,  4714,  4716,  4718,  4720,  4722,  4724,  4729,
    4734,  4736,  4738,  4743,  4748,  4752,  4753,  4761,  4763,  4764,
    4765,  4773,  4777,  4782,  4786,  4788,  4790,  4792,  4795,  4799,
    4805,  4808,  4814,  4817,  4819,  4821,  4823,  4825,  4827,  4829,
    4831,  4833,  4835,  4837,  4839,  4841,  4843,  4845,  4847,  4849,
    4851,  4853,  4855,  4857,  4859,  4861,  4863,  4865,  4867,  4869,
    4871,  4873,  4875,  4877,  4879,  4881,  4883,  4885,  4887,  4889,
    4891,  4893,  4895,  4897,  4899,  4901,  4903,  4905,  4907,  4909,
    4911,  4913,  4915,  4917,  4919,  4921,  4923,  4925,  4927,  4929,
    4931,  4933,  4935,  4937,  4939,  4941,  4943,  4945,  4947,  4949,
    4951,  4953,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,
    4971,  4973,  4975,  4977,  4979,  4981,  4983,  4985,  4987,  4989,
    4991,  4993,  4995,  4997,  4999,  5001,  5003,  5005,  5007,  5009,
    5011,  5013,  5015,  5017,  5019,  5021,  5023,  5025,  5027,  5029,
    5031,  5033,  5035,  5037,  5039,  5041,  5043,  5045,  5047,  5049,
    5051,  5053,  5055,  5057,  5059,  5061,  5063,  5065,  5067,  5069,
    5071,  5073,  5075,  5077,  5079,  5081,  5083,  5085,  5087,  5089,
    5091,  5093,  5095,  5097,  5099,  5101,  5103,  5105,  5107,  5109,
    5111,  5113,  5115,  5117,  5119,  5121,  5123,  5125,  5127,  5129,
    5131,  5133,  5135,  5137,  5139,  5141,  5143,  5145,  5147,  5149,
    5151,  5153,  5155,  5157,  5159,  5161,  5163,  5165,  5167,  5169,
    5171,  5173,  5175,  5177,  5179,  5181,  5183,  5185,  5187,  5189,
    5191,  5193,  5195,  5197,  5199,  5201,  5203,  5205,  5207,  5209,
    5211,  5213,  5215,  5217,  5219,  5221,  5223,  5225,  5227,  5229,
    5231,  5233,  5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,
    5251,  5253,  5255,  5257,  5259,  5261,  5263,  5265,  5267,  5269,
    5271,  5273,  5275,  5277,  5279,  5281,  5283,  5285,  5287,  5289,
    5291,  5293,  5295,  5297,  5299,  5301,  5303,  5305,  5307,  5309,
    5311,  5313,  5315,  5317,  5319,  5321,  5323,  5325,  5327,  5329,
    5331,  5333,  5335,  5337,  5339,  5341,  5343,  5345,  5347,  5349,
    5351,  5353,  5355,  5357,  5359,  5361,  5363,  5365,  5367,  5369,
    5371,  5373,  5375,  5377,  5379,  5381,  5383,  5385,  5387,  5389,
    5391,  5393,  5395,  5397,  5399,  5401,  5403,  5405,  5407,  5409,
    5411,  5413,  5415,  5417,  5419,  5421,  5423,  5425,  5427,  5429,
    5431,  5433,  5435,  5437,  5439,  5441,  5443,  5445,  5447,  5449,
    5451,  5453,  5455,  5457,  5459,  5461,  5463,  5465,  5467,  5469,
    5471,  5473,  5475,  5477,  5479,  5481,  5483,  5485,  5487,  5489,
    5491,  5493,  5495,  5497,  5499,  5501,  5503,  5505,  5507,  5509,
    5511,  5513,  5515,  5517,  5519,  5521,  5523,  5525,  5527,  5529,
    5531,  5533,  5535,  5537,  5539,  5541,  5543,  5545,  5547,  5549,
    5551,  5553,  5555,  5557,  5559,  5561,  5563,  5565,  5567,  5569,
    5571,  5573,  5575,  5577,  5579,  5581,  5583,  5587,  5589,  5590,
    5592,  5595,  5597,  5600,  5602,  5604,  5607,  5610,  5612,  5614,
    5616,  5618,  5620,  5622,  5625,  5629,  5631,  5634,  5636,  5640,
    5642,  5646,  5648,  5650,  5652,  5654,  5656,  5658,  5660,  5662,
    5664,  5666,  5668,  5670,  5672,  5674,  5676,  5678,  5680,  5682,
    5684,  5686,  5688,  5690,  5692,  5694,  5696,  5698,  5700,  5702,
    5704,  5706,  5708,  5710,  5712,  5714,  5716,  5718,  5720,  5722,
    5724,  5726,  5728,  5730,  5732,  5734,  5736,  5738,  5740,  5742,
    5744,  5746,  5748,  5750,  5752,  5754,  5756,  5758,  5760,  5762,
    5764,  5766
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     425,     0,    -1,   426,    -1,    -1,   426,   427,    -1,   923,
     428,   429,   418,    -1,   923,   429,   418,    -1,   923,   816,
      -1,   824,    -1,   936,    -1,   395,    -1,   419,    -1,   420,
      -1,    97,   802,    -1,   639,    -1,   642,    -1,   441,    -1,
     615,    -1,   516,    -1,   464,    -1,   433,    -1,   432,    -1,
     647,    -1,   463,    -1,   472,    -1,   645,    -1,   567,    -1,
     460,    -1,   473,    -1,   509,    -1,   543,    -1,   607,    -1,
     644,    -1,   641,    -1,   588,    -1,   438,    -1,   520,    -1,
     551,    -1,   443,    -1,   515,    -1,   482,    -1,   529,    -1,
     526,    -1,   430,    -1,   635,    -1,   666,    -1,   545,    -1,
     660,    -1,   544,    -1,   609,    -1,   442,    -1,   556,    -1,
     524,    -1,   624,    -1,   557,    -1,   528,    -1,   542,    -1,
     434,    -1,   640,    -1,   653,    -1,   563,    -1,   570,    -1,
     582,    -1,   656,    -1,   626,    -1,   634,    -1,   661,    -1,
     625,    -1,   610,    -1,   602,    -1,   604,    -1,   601,    -1,
     613,    -1,   571,    -1,   616,    -1,   669,    -1,   628,    -1,
     562,    -1,   627,    -1,   665,    -1,   646,    -1,   447,    -1,
     458,    -1,   459,    -1,   633,    -1,   878,    -1,   801,    -1,
     814,    -1,   815,    -1,   879,    -1,   856,    -1,   876,    -1,
     857,    -1,   860,    -1,   865,    -1,   887,    -1,   880,    -1,
     866,    -1,   875,    -1,   894,    -1,   896,    -1,   890,    -1,
     883,    -1,   897,    -1,   900,    -1,   902,    -1,   134,   371,
     799,   431,   435,    -1,   383,    -1,    -1,    87,   371,   799,
     435,    -1,    87,   371,   799,   383,   435,    -1,    87,   371,
     799,   325,   448,    -1,    87,   371,   799,   459,    -1,   164,
     371,   437,    -1,   435,   436,    -1,    -1,   283,   789,    -1,
     342,   790,    -1,   135,    -1,   254,    -1,   136,    -1,   255,
      -1,   203,   194,   437,    -1,   374,   368,   789,    -1,   437,
     421,   799,    -1,   799,    -1,   134,   194,   799,   439,    -1,
     134,   194,   799,   383,   439,    -1,   439,   440,    -1,    -1,
     371,   437,    -1,   342,   790,    -1,    87,   194,   799,    82,
     371,   437,    -1,    87,   194,   799,   164,   371,   437,    -1,
     164,   194,   799,    -1,   134,   316,   444,    98,   799,   445,
      -1,   134,   316,   909,   445,    -1,   909,    -1,    -1,   445,
     446,    -1,    -1,   482,    -1,   582,    -1,   515,    -1,   529,
      -1,   570,    -1,   633,    -1,   325,   448,    -1,   325,   237,
     448,    -1,   325,   323,   448,    -1,   449,   351,   450,    -1,
     449,   422,   450,    -1,   349,   388,   455,    -1,   354,   631,
      -1,   323,   117,    93,   354,   631,    -1,   247,   456,    -1,
     323,    98,   457,    -1,   323,    98,   151,    -1,   909,    -1,
     449,   417,   909,    -1,   451,    -1,   151,    -1,   453,    -1,
     451,   421,   453,    -1,   295,   362,    -1,   295,   128,    -1,
     303,   295,    -1,   322,    -1,   454,    -1,   797,    -1,   909,
      -1,   358,    -1,   179,    -1,   271,    -1,   267,    -1,   797,
      -1,   930,    -1,   727,   794,   729,    -1,   727,   415,   790,
     416,   794,   729,    -1,   151,    -1,   237,    -1,   794,    -1,
     151,    -1,    -1,   909,    -1,   794,    -1,   328,   909,    -1,
     328,   349,   388,    -1,   328,   354,   223,   232,    -1,   328,
     323,    98,    -1,   328,    85,    -1,   305,   909,    -1,   305,
     349,   388,    -1,   305,   354,   223,   232,    -1,   305,   323,
      98,    -1,   305,    85,    -1,   325,   130,   461,   462,    -1,
      85,    -1,   776,    -1,   154,    -1,   200,    -1,   119,    -1,
      87,   343,   700,   465,    -1,    87,   206,   700,   467,    -1,
     466,    -1,   465,   421,   466,    -1,    82,   614,   487,    -1,
      87,   614,   909,   469,    -1,    87,   614,   909,   164,   257,
     262,    -1,    87,   614,   909,   325,   257,   262,    -1,    87,
     614,   909,   325,   336,   790,    -1,    87,   614,   909,   325,
     339,   909,    -1,   164,   614,   909,   470,    -1,    87,   614,
     909,   361,   705,   471,    -1,    82,   494,    -1,   164,   129,
     777,   470,    -1,   325,   384,   269,    -1,   134,   352,   343,
      -1,   122,   271,   777,    -1,   325,   384,   122,    -1,   468,
      -1,   467,   421,   468,    -1,   281,   351,   799,    -1,   325,
     344,   777,    -1,   325,   151,   730,    -1,   164,   151,    -1,
     111,    -1,   307,    -1,    -1,   372,   730,    -1,    -1,   121,
     777,    -1,   133,   478,   775,   479,   474,   475,   480,   431,
     476,    -1,   351,    -1,   188,    -1,   794,    -1,   337,    -1,
     338,    -1,   476,   477,    -1,    -1,   104,    -1,   269,    -1,
     157,   643,   794,    -1,   262,   643,   794,    -1,   138,    -1,
     294,   643,   789,    -1,   170,   643,   789,    -1,   184,   294,
     497,    -1,   184,   257,   262,   497,    -1,   104,    -1,    -1,
     383,   269,    -1,    -1,   481,   158,   794,    -1,    -1,   372,
      -1,    -1,   134,   483,   343,   775,   415,   484,   416,   504,
     505,   506,   507,    -1,   134,   483,   343,   775,   266,   775,
     415,   484,   416,   505,   506,   507,    -1,   347,    -1,   345,
      -1,   237,   347,    -1,   237,   345,    -1,   192,   347,    -1,
     192,   345,    -1,    -1,   485,    -1,    -1,   486,    -1,   485,
     421,   486,    -1,   487,    -1,   492,    -1,   494,    -1,   909,
     705,   488,    -1,   488,   489,    -1,    -1,   129,   777,   490,
      -1,   490,    -1,   491,    -1,   257,   262,    -1,   262,    -1,
     365,   508,    -1,   289,   225,   508,    -1,   118,   415,   730,
     416,    -1,   151,   731,    -1,   298,   775,   496,   499,   500,
      -1,   153,    -1,   257,   153,    -1,   208,   154,    -1,   208,
     200,    -1,   233,   775,   493,    -1,   204,   152,    -1,   173,
     152,    -1,    -1,   129,   777,   495,    -1,   495,    -1,   118,
     415,   730,   416,    -1,   365,   415,   497,   416,   508,    -1,
     289,   225,   415,   497,   416,   508,    -1,   185,   225,   415,
     497,   416,   298,   775,   496,   499,   500,   539,    -1,   415,
     497,   416,    -1,    -1,   497,   421,   498,    -1,   498,    -1,
     909,    -1,   240,   189,    -1,   240,   282,    -1,    -1,   501,
      -1,   502,    -1,   501,   502,    -1,   502,   501,    -1,    -1,
     271,   156,   503,    -1,   271,   369,   503,    -1,   253,    81,
      -1,   307,    -1,   111,    -1,   325,   151,    -1,   325,   262,
      -1,   207,   415,   774,   416,    -1,    -1,   383,   269,    -1,
     384,   269,    -1,    -1,   271,   127,   164,    -1,   271,   127,
     156,   313,    -1,   271,   127,   287,   313,    -1,    -1,   344,
     777,    -1,    -1,   372,   206,   344,   777,    -1,    -1,    -1,
     134,   483,   343,   775,   512,   511,   510,   669,    -1,   383,
     269,    93,    -1,   384,   269,    93,    -1,    93,    -1,   415,
     513,   416,    -1,    -1,   513,   421,   514,    -1,   514,    -1,
     909,    -1,   134,   483,   321,   775,   517,    -1,    87,   321,
     775,   517,    -1,   517,   518,    -1,    -1,   109,   796,    -1,
     144,    -1,   253,   144,    -1,   205,   519,   796,    -1,   241,
     796,    -1,   243,   796,    -1,   253,   241,    -1,   253,   243,
      -1,   334,   431,   796,    -1,   306,   431,   796,    -1,   108,
      -1,    -1,   134,   521,   525,   227,   457,   195,   522,   523,
      -1,   360,    -1,    -1,   777,    -1,   777,   561,    -1,   226,
     794,    -1,    -1,   164,   525,   227,   794,   470,    -1,   292,
      -1,    -1,   134,   344,   777,   527,   238,   789,    -1,   281,
     777,    -1,    -1,   164,   344,   777,    -1,   134,   356,   777,
     530,   531,   271,   775,   533,   174,   293,   777,   415,   536,
     416,    -1,   134,   129,   356,   777,    83,   531,   271,   775,
     538,   539,   183,   165,   312,   174,   293,   783,   415,   536,
     416,    -1,   100,    -1,    83,    -1,   532,    -1,   532,   275,
     532,    -1,   532,   275,   532,   275,   532,    -1,   213,    -1,
     156,    -1,   369,    -1,   183,   534,   535,    -1,    -1,   165,
      -1,    -1,   312,    -1,   335,    -1,   537,    -1,   536,   421,
     537,    -1,    -1,   798,    -1,   909,    -1,    -1,   188,   775,
      -1,   540,    -1,   540,   541,    -1,   541,    -1,   541,   540,
      -1,   257,   153,    -1,   153,    -1,   208,   200,    -1,   208,
     154,    -1,   164,   356,   777,   271,   775,   470,    -1,   134,
      95,   777,   118,   415,   730,   416,   539,    -1,   164,    95,
     777,    -1,   134,    84,   783,   547,    -1,   134,   273,   736,
     547,    -1,   134,   361,   560,   547,    -1,   134,   361,   560,
      93,   546,    -1,   415,   703,   416,    -1,   415,   548,   416,
      -1,   549,    -1,   548,   421,   549,    -1,   912,   402,   550,
      -1,   912,    -1,   596,    -1,   739,    -1,   797,    -1,   134,
     273,   120,   560,   554,   183,   361,   705,   372,   779,    93,
     552,    -1,   553,    -1,   552,   421,   553,    -1,   273,   790,
     606,   555,    -1,   273,   790,   606,   415,   605,   416,   555,
      -1,   190,   790,   783,   590,    -1,   339,   705,    -1,   151,
      -1,    -1,   297,    -1,    -1,   164,   273,   120,   560,   372,
     779,   470,    -1,   164,   558,   559,   470,    -1,   343,    -1,
     321,    -1,   379,    -1,   206,    -1,   361,    -1,   162,    -1,
     131,    -1,   316,    -1,   560,    -1,   559,   421,   560,    -1,
     909,    -1,   909,   561,    -1,   417,   780,    -1,   561,   417,
     780,    -1,   359,   676,   775,    -1,   180,   564,   566,   777,
     872,    -1,   180,   564,   777,   872,    -1,   180,   566,   777,
     872,    -1,   180,   777,   872,    -1,   180,   564,   566,   777,
      -1,   180,   564,   777,    -1,   180,   566,   777,    -1,   180,
     777,    -1,   246,   564,   566,   777,    -1,   246,   777,    -1,
     252,    -1,   290,    -1,   181,    -1,   229,    -1,    79,   565,
      -1,   300,   565,    -1,   565,    -1,    85,    -1,   186,    -1,
     186,   565,    -1,   186,    85,    -1,    99,    -1,    99,   565,
      -1,    99,    85,    -1,   791,    -1,   203,    -1,   188,    -1,
     126,   271,   568,   777,   221,   569,    -1,   126,   271,    84,
     783,   415,   603,   416,   221,   569,    -1,   126,   271,   190,
     783,   590,   221,   569,    -1,   126,   271,   273,   736,   415,
     605,   416,   221,   569,    -1,   126,   271,   356,   777,   271,
     560,   221,   569,    -1,   126,   271,   314,   777,   271,   560,
     221,   569,    -1,   126,   271,   314,   777,   221,   569,    -1,
     126,   271,   273,   120,   560,   372,   779,   221,   569,    -1,
     126,   271,   228,   265,   796,   221,   569,    -1,   126,   271,
     113,   415,   705,    93,   705,   416,   221,   569,    -1,   126,
     271,   525,   227,   560,   221,   569,    -1,   125,    -1,   145,
      -1,   316,    -1,   206,    -1,   321,    -1,   343,    -1,   162,
      -1,   361,    -1,   379,    -1,   131,    -1,   794,    -1,   262,
      -1,   193,   572,   271,   575,   351,   576,   578,    -1,   309,
     579,   572,   271,   575,   188,   576,   470,    -1,    85,   291,
      -1,    85,    -1,   573,    -1,   574,    -1,   573,   421,   574,
      -1,   320,    -1,   213,    -1,   369,    -1,   156,    -1,   314,
      -1,   298,    -1,   356,    -1,   174,    -1,   370,    -1,   134,
      -1,   347,    -1,   345,    -1,   774,    -1,   343,   774,    -1,
     190,   580,    -1,   145,   776,    -1,   227,   776,    -1,   316,
     776,    -1,   344,   776,    -1,   577,    -1,   576,   421,   577,
      -1,   909,    -1,   194,   909,    -1,   383,   193,   274,    -1,
      -1,   193,   274,   183,    -1,    -1,   581,    -1,   580,   421,
     581,    -1,   783,   590,    -1,   134,   583,   206,   781,   271,
     775,   584,   415,   585,   416,   507,   702,    -1,   365,    -1,
      -1,   372,   779,    -1,    -1,   586,    -1,   585,   421,   586,
      -1,   909,   587,    -1,   733,   587,    -1,   415,   730,   416,
     587,    -1,   560,    -1,   372,   560,    -1,    -1,   134,   589,
     190,   783,   590,   308,   596,   598,   600,    -1,   275,   304,
      -1,    -1,   415,   591,   416,    -1,   415,   416,    -1,   592,
      -1,   591,   421,   592,    -1,   593,   595,   597,    -1,   593,
     597,    -1,   203,    -1,   277,    -1,   210,    -1,    -1,   794,
      -1,   794,   421,   794,    -1,   911,    -1,   597,    -1,   705,
      -1,   910,   561,   410,   361,    -1,   599,    -1,   598,   599,
      -1,    93,   594,    -1,   227,   457,    -1,   201,    -1,   333,
      -1,   380,    -1,   110,   271,   262,   211,    -1,   308,   262,
     271,   262,   211,    -1,   340,    -1,   177,   319,   155,    -1,
     177,   319,   220,    -1,   319,   155,    -1,   319,   220,    -1,
     383,   547,    -1,    -1,   164,   190,   783,   590,   470,    -1,
     164,    84,   783,   415,   603,   416,   470,    -1,   705,    -1,
     408,    -1,   164,   273,   736,   415,   605,   416,   470,    -1,
     705,    -1,   705,   421,   705,    -1,   256,   421,   705,    -1,
     705,   421,   256,    -1,   736,    -1,   909,   417,   606,    -1,
     134,   113,   415,   705,    93,   705,   416,   383,   190,   581,
     608,    -1,   134,   113,   415,   705,    93,   705,   416,   384,
     190,   608,    -1,    93,    96,    -1,    -1,   164,   113,   415,
     705,    93,   705,   416,   470,    -1,   299,   611,   775,   612,
      -1,   299,   145,   777,   612,    -1,   206,    -1,   343,    -1,
     184,    -1,    -1,    87,    84,   783,   415,   603,   416,   302,
     351,   777,    -1,    87,   131,   560,   302,   351,   777,    -1,
      87,   145,   778,   302,   351,   778,    -1,    87,   190,   783,
     590,   302,   351,   777,    -1,    87,   194,   799,   302,   351,
     799,    -1,    87,   227,   777,   302,   351,   777,    -1,    87,
     273,   120,   560,   372,   779,   302,   351,   777,    -1,    87,
     316,   777,   302,   351,   777,    -1,    87,   343,   700,   302,
     351,   777,    -1,    87,   206,   700,   302,   351,   777,    -1,
      87,   343,   700,   302,   614,   777,   351,   777,    -1,    87,
     356,   777,   271,   700,   302,   351,   777,    -1,    87,   371,
     799,   302,   351,   799,    -1,    87,   344,   777,   302,   351,
     777,    -1,   125,    -1,    -1,    87,    84,   783,   415,   603,
     416,   281,   351,   799,    -1,    87,   131,   560,   281,   351,
     799,    -1,    87,   145,   778,   281,   351,   799,    -1,    87,
     162,   778,   281,   351,   799,    -1,    87,   190,   783,   590,
     281,   351,   799,    -1,    87,   273,   606,   415,   605,   416,
     281,   351,   799,    -1,    87,   273,   120,   560,   372,   779,
     281,   351,   799,    -1,    87,   316,   777,   281,   351,   799,
      -1,    87,   361,   560,   281,   351,   799,    -1,    87,   344,
     777,   281,   351,   799,    -1,    -1,   134,   589,   314,   777,
      93,   617,   271,   622,   351,   775,   702,   161,   623,   618,
      -1,   258,    -1,   620,    -1,   415,   619,   416,    -1,   619,
     418,   621,    -1,   621,    -1,   669,    -1,   656,    -1,   665,
      -1,   660,    -1,   625,    -1,   620,    -1,    -1,   320,    -1,
     369,    -1,   156,    -1,   213,    -1,   214,    -1,    86,    -1,
      -1,   164,   314,   777,   271,   775,   470,    -1,   259,   775,
      -1,   235,   775,    -1,   367,   775,    -1,   367,   408,    -1,
      78,   629,    -1,   101,   629,   632,    -1,   334,   354,   632,
      -1,   127,   629,    -1,   169,   629,    -1,   311,   629,    -1,
     315,   909,    -1,   301,   315,   909,    -1,   301,   909,    -1,
     311,   629,   351,   315,   909,    -1,   311,   629,   351,   909,
      -1,   385,    -1,   354,    -1,    -1,   223,   232,   452,    -1,
     295,   272,    -1,   295,   386,    -1,   630,    -1,   631,   421,
     630,    -1,   631,   630,    -1,   631,    -1,    -1,   134,   589,
     379,   775,   496,    93,   669,    -1,   236,   782,    -1,   134,
     145,   778,   383,   636,    -1,   134,   145,   778,    -1,   637,
      -1,   636,   637,    -1,   344,   638,   777,    -1,   344,   638,
     151,    -1,   238,   638,   794,    -1,   238,   638,   151,    -1,
     346,   638,   777,    -1,   346,   638,   151,    -1,   167,   638,
     795,    -1,   167,   638,   151,    -1,   281,   638,   777,    -1,
     281,   638,   151,    -1,   402,    -1,    -1,    87,   145,   778,
     325,   448,    -1,    87,   145,   778,   459,    -1,   164,   145,
     778,    -1,   134,   162,   560,   643,   705,   488,    -1,    87,
     162,   560,   469,    -1,    87,   162,   560,   164,   257,   262,
      -1,    87,   162,   560,   325,   257,   262,    -1,    87,   162,
     560,    82,   494,    -1,    87,   162,   560,   164,   129,   777,
     470,    -1,    93,    -1,    -1,   134,   554,   131,   560,   183,
     794,   351,   794,   188,   560,    -1,   122,   781,   271,   775,
      -1,   122,   775,    -1,   122,    -1,   373,   650,   651,   649,
      -1,   373,   650,   651,   649,   775,    -1,   373,   650,   651,
     649,   647,    -1,   648,   649,    -1,   648,   649,   775,   652,
      -1,    89,    -1,    88,    -1,   378,    -1,    -1,   189,    -1,
      -1,   187,    -1,    -1,   415,   776,   416,    -1,    -1,   176,
     655,   649,   654,    -1,   669,    -1,   656,    -1,   665,    -1,
     660,    -1,   666,    -1,   648,    -1,    -1,   213,   219,   775,
     657,    -1,   375,   415,   771,   416,    -1,   151,   375,    -1,
     669,    -1,   415,   658,   416,   375,   415,   771,   416,    -1,
     415,   658,   416,   669,    -1,   658,   421,   659,    -1,   659,
      -1,   909,   763,    -1,   156,   188,   700,   702,    -1,   239,
     676,   774,   662,   664,    -1,   203,   663,   244,    -1,    -1,
      80,   327,    -1,   312,   327,    -1,   312,   172,    -1,   327,
     369,   172,    -1,   327,    -1,   327,   312,   172,    -1,   172,
      -1,    80,   172,    -1,   261,    -1,    -1,   369,   700,   325,
     767,   692,   702,    -1,   150,   777,   667,   143,   668,   183,
     669,    -1,    -1,   667,   104,    -1,   667,   212,    -1,   667,
     317,    -1,   667,   253,   317,    -1,    -1,   383,   197,    -1,
     384,   197,    -1,   671,    -1,   670,    -1,   415,   671,   416,
      -1,   415,   670,   416,    -1,   673,    -1,   672,   680,    -1,
     672,   679,   689,   684,    -1,   672,   679,   683,   690,    -1,
     673,    -1,   670,    -1,   320,   678,   765,   674,   692,   702,
     687,   688,    -1,   672,   364,   677,   672,    -1,   672,   217,
     677,   672,    -1,   672,   171,   677,   672,    -1,   219,   675,
      -1,   872,    -1,    -1,   347,   676,   775,    -1,   345,   676,
     775,    -1,   237,   347,   676,   775,    -1,   237,   345,   676,
     775,    -1,   192,   347,   676,   775,    -1,   192,   345,   676,
     775,    -1,   343,   775,    -1,   775,    -1,   343,    -1,    -1,
      85,    -1,    -1,   160,    -1,   160,   271,   415,   741,   416,
      -1,    85,    -1,    -1,   680,    -1,    -1,   276,   108,   681,
      -1,   682,    -1,   681,   421,   682,    -1,   730,   372,   739,
      -1,   730,    94,    -1,   730,   159,    -1,   730,    -1,   234,
     685,   268,   686,    -1,   268,   686,   234,   685,    -1,   234,
     685,    -1,   268,   686,    -1,   234,   685,   421,   686,    -1,
     683,    -1,    -1,   730,    -1,    85,    -1,   730,    -1,   194,
     108,   741,    -1,    -1,   196,   730,    -1,    -1,   183,   369,
     691,    -1,   183,   295,   272,    -1,   689,    -1,    -1,   266,
     776,    -1,    -1,   188,   693,    -1,    -1,   693,   421,   694,
      -1,   694,    -1,   700,    -1,   700,   696,    -1,   701,    -1,
     701,   696,    -1,   701,    93,   415,   703,   416,    -1,   701,
      93,   909,   415,   703,   416,    -1,   701,   909,   415,   703,
     416,    -1,   670,    -1,   670,   696,    -1,   695,    -1,   415,
     695,   416,   696,    -1,   415,   695,   416,    -1,   694,   137,
     224,   694,    -1,   694,   389,   694,    -1,   694,   697,   224,
     694,   699,    -1,   694,   224,   694,   699,    -1,   694,   249,
     697,   224,   694,    -1,   694,   249,   224,   694,    -1,    93,
     909,   415,   776,   416,    -1,    93,   909,    -1,   909,   415,
     776,   416,    -1,   909,    -1,   189,   698,    -1,   231,   698,
      -1,   310,   698,    -1,   209,    -1,   278,    -1,    -1,   372,
     415,   776,   416,    -1,   271,   730,    -1,   775,    -1,   775,
     408,    -1,   272,   775,    -1,   272,   415,   775,   416,    -1,
     733,    -1,   382,   730,    -1,    -1,   704,    -1,   703,   421,
     704,    -1,   909,   705,    -1,   708,   706,    -1,   326,   708,
     706,    -1,   708,    92,   413,   790,   414,    -1,   326,   708,
      92,   413,   790,   414,    -1,   413,   414,   706,    -1,   413,
     707,   414,   706,    -1,    -1,   790,    -1,   415,   707,   416,
      -1,   707,   406,   707,    -1,   707,   407,   707,    -1,   707,
     408,   707,    -1,   707,   409,   707,    -1,   707,   410,   707,
      -1,   789,    -1,   909,    -1,   710,    -1,   726,    -1,   711,
      -1,   715,    -1,   719,    -1,   727,   729,    -1,   727,   415,
     790,   416,   729,    -1,   910,   561,    -1,   710,    -1,   726,
      -1,   711,    -1,   716,    -1,   720,    -1,   910,    -1,   215,
      -1,   216,    -1,   331,    -1,   103,    -1,   296,    -1,   182,
     712,    -1,   163,   286,    -1,   149,   714,    -1,   148,   714,
      -1,   264,   713,    -1,   106,    -1,   415,   790,   416,    -1,
      -1,   415,   790,   421,   790,   416,    -1,   415,   790,   416,
      -1,    -1,   415,   790,   421,   790,   416,    -1,   415,   790,
     416,    -1,    -1,   717,    -1,   718,    -1,   717,    -1,   718,
      -1,   105,   724,   415,   790,   416,    -1,   105,   724,    -1,
     721,    -1,   722,    -1,   721,    -1,   722,    -1,   723,   415,
     790,   416,   725,    -1,   723,   725,    -1,   116,   724,    -1,
     115,   724,    -1,   376,    -1,   248,   116,   724,    -1,   248,
     115,   724,    -1,   250,   724,    -1,   377,    -1,    -1,   116,
     325,   909,    -1,    -1,   350,   415,   790,   416,   728,    -1,
     350,   728,    -1,   349,   415,   790,   416,   728,    -1,   349,
     728,    -1,   218,    -1,   383,   349,   388,    -1,   384,   349,
     388,    -1,    -1,   387,    -1,   245,    -1,   146,    -1,   198,
      -1,   242,    -1,   318,    -1,   387,   351,   245,    -1,   146,
     351,   198,    -1,   146,   351,   242,    -1,   146,   351,   318,
      -1,   198,   351,   242,    -1,   242,   351,   318,    -1,   198,
     351,   318,    -1,    -1,   732,    -1,   730,    77,   705,    -1,
     730,    97,   349,   388,   732,    -1,   406,   730,    -1,   407,
     730,    -1,   410,   730,    -1,   411,   730,    -1,   730,   410,
      -1,   730,   411,    -1,   730,   406,   730,    -1,   730,   407,
     730,    -1,   730,   408,   730,    -1,   730,   409,   730,    -1,
     730,   410,   730,    -1,   730,   411,   730,    -1,   730,   403,
     730,    -1,   730,   404,   730,    -1,   730,   402,   730,    -1,
     730,   738,   730,    -1,   738,   730,    -1,   730,   738,    -1,
     730,    90,   730,    -1,   730,   275,   730,    -1,   257,   730,
      -1,   730,   233,   730,    -1,   730,   233,   730,   170,   730,
      -1,   730,   257,   233,   730,    -1,   730,   257,   233,   730,
     170,   730,    -1,   730,   199,   730,    -1,   730,   199,   730,
     170,   730,    -1,   730,   257,   199,   730,    -1,   730,   257,
     199,   730,   170,   730,    -1,   730,   329,   351,   730,    -1,
     730,   329,   351,   730,   170,   730,    -1,   730,   257,   329,
     351,   730,    -1,   730,   257,   329,   351,   730,   170,   730,
      -1,   730,   222,    -1,   730,   221,   262,    -1,   730,   260,
      -1,   730,   221,   257,   262,    -1,   730,   221,   358,    -1,
     730,   221,   257,   358,    -1,   730,   221,   179,    -1,   730,
     221,   257,   179,    -1,   730,   221,   366,    -1,   730,   221,
     257,   366,    -1,   730,   221,   160,   188,   730,    -1,   730,
     221,   266,   415,   743,   416,    -1,   730,   221,   257,   266,
     415,   743,   416,    -1,   730,   102,   731,    90,   731,    -1,
     730,   257,   102,   731,    90,   731,    -1,   730,   203,   754,
      -1,   730,   257,   203,   754,    -1,   730,   740,   735,   670,
      -1,   730,   740,   735,   415,   730,   416,    -1,   365,   670,
      -1,   732,    -1,   731,    77,   705,    -1,   407,   731,    -1,
     410,   731,    -1,   411,   731,    -1,   731,   410,    -1,   731,
     411,    -1,   731,   406,   731,    -1,   731,   407,   731,    -1,
     731,   408,   731,    -1,   731,   409,   731,    -1,   731,   410,
     731,    -1,   731,   411,   731,    -1,   731,   403,   731,    -1,
     731,   404,   731,    -1,   731,   402,   731,    -1,   731,   392,
     731,    -1,   738,   731,    -1,   731,   738,    -1,   731,   221,
     160,   188,   731,    -1,   731,   221,   266,   415,   731,   416,
      -1,   731,   221,   257,   266,   415,   731,   416,    -1,   760,
      -1,   784,    -1,   400,   763,    -1,   415,   730,   416,   763,
      -1,   755,    -1,   733,    -1,   670,    -1,   175,   670,    -1,
      92,   670,    -1,    92,   745,    -1,   734,    -1,   783,   415,
     416,    -1,   783,   415,   741,   416,    -1,   783,   415,    85,
     741,   416,    -1,   783,   415,   160,   741,   416,    -1,   783,
     415,   408,   416,    -1,   139,    -1,   140,   764,    -1,   140,
     415,   790,   416,    -1,   141,   764,    -1,   141,   415,   790,
     416,    -1,   142,   764,    -1,   324,   764,    -1,   371,   764,
      -1,   113,   415,   730,    93,   705,   416,    -1,   178,   415,
     742,   416,    -1,   280,   415,   747,   416,    -1,   285,   415,
     749,   416,    -1,   341,   415,   750,   416,    -1,   355,   415,
     730,    93,   705,   416,    -1,   357,   415,   107,   753,   416,
      -1,   357,   415,   230,   753,   416,    -1,   357,   415,   353,
     753,   416,    -1,   357,   415,   753,   416,    -1,   132,   415,
     730,   372,   560,   416,    -1,   132,   415,   741,   416,    -1,
     263,   415,   730,   421,   730,   416,    -1,   123,   415,   741,
     416,    -1,   312,   415,   741,   416,    -1,   312,   415,   416,
      -1,   415,   741,   421,   730,   416,    -1,    91,    -1,   332,
      -1,    85,    -1,   392,    -1,   737,    -1,   406,    -1,   407,
      -1,   408,    -1,   410,    -1,   411,    -1,   409,    -1,   403,
      -1,   404,    -1,   402,    -1,   392,    -1,   273,   415,   606,
     416,    -1,   736,    -1,   273,   415,   606,   416,    -1,   736,
      -1,   273,   415,   606,   416,    -1,   233,    -1,   257,   233,
      -1,   199,    -1,   257,   199,    -1,   730,    -1,   741,   421,
     730,    -1,   746,   188,   730,    -1,    -1,   743,   421,   705,
      -1,   705,    -1,   745,    -1,   744,   421,   745,    -1,   413,
     741,   414,    -1,   413,   744,   414,    -1,   930,    -1,   387,
      -1,   245,    -1,   146,    -1,   198,    -1,   242,    -1,   318,
      -1,   794,    -1,   730,   748,   751,   752,    -1,   730,   748,
     751,    -1,   284,   730,    -1,   731,   203,   731,    -1,    -1,
     730,   751,   752,    -1,   730,   752,   751,    -1,   730,   751,
      -1,   730,   752,    -1,   741,    -1,    -1,   188,   730,    -1,
     183,   730,    -1,   730,   188,   741,    -1,   188,   741,    -1,
     741,    -1,   670,    -1,   415,   741,   416,    -1,   112,   759,
     756,   758,   169,    -1,   756,   757,    -1,   757,    -1,   381,
     730,   348,   730,    -1,   166,   730,    -1,    -1,   730,    -1,
      -1,   773,    -1,   773,   762,    -1,   417,   780,    -1,   417,
     408,    -1,   413,   730,   414,    -1,   413,   730,   423,   730,
     414,    -1,   761,    -1,   762,   761,    -1,    -1,   763,   761,
      -1,   415,   416,    -1,    -1,   765,   421,   766,    -1,   766,
      -1,   730,    93,   912,    -1,   730,    -1,   408,    -1,   767,
     421,   770,    -1,   415,   768,   416,   402,   415,   769,   416,
      -1,   770,    -1,   909,   763,    -1,   909,   763,   421,   768,
      -1,   730,    -1,   730,   421,   769,    -1,   909,   763,   402,
     730,    -1,   909,   763,   402,   151,    -1,   771,   421,   772,
      -1,   772,    -1,   730,    -1,   151,    -1,   800,    -1,   909,
      -1,   775,    -1,   774,   421,   775,    -1,   773,    -1,   773,
     762,    -1,   777,    -1,   776,   421,   777,    -1,   909,    -1,
     909,    -1,   909,    -1,   912,    -1,   909,    -1,   794,    -1,
     911,    -1,   773,   762,    -1,   798,    -1,   709,   794,    -1,
     727,   794,   729,    -1,   727,   415,   790,   416,   794,   729,
      -1,   358,    -1,   179,    -1,   262,    -1,   926,    -1,   399,
      -1,   401,    -1,   397,    -1,   398,    -1,   391,    -1,   785,
      -1,   927,    -1,   790,    -1,   407,   790,    -1,   785,    -1,
     929,    -1,   786,    -1,   792,    -1,   407,   786,    -1,   407,
     785,    -1,   789,    -1,   789,    -1,   927,    -1,   785,    -1,
     789,    -1,   927,    -1,   786,    -1,   785,    -1,   407,   786,
      -1,   407,   785,    -1,   927,    -1,   789,    -1,   796,    -1,
     789,    -1,   786,    -1,   785,    -1,   787,    -1,   788,    -1,
     927,    -1,   909,    -1,   270,    -1,   251,    -1,     9,   351,
     802,   808,   809,    -1,     9,   351,   151,    -1,     9,   810,
      -1,   145,   802,    -1,   778,   805,   807,    -1,   803,   423,
     804,   807,   409,   778,   813,    -1,   789,    -1,   812,    -1,
     930,   929,    -1,   392,   806,    -1,   804,    -1,    -1,   909,
      -1,   909,   417,   806,    -1,   396,    -1,   423,   790,    -1,
      -1,    93,   802,    -1,    -1,   371,   810,    -1,    -1,   811,
      -1,   811,   409,   811,    -1,   811,    25,   108,   811,    -1,
     811,   372,   811,    -1,   799,    -1,   794,    -1,   929,    -1,
     392,   909,    -1,    -1,   150,   777,   667,   143,   668,   183,
     864,    -1,   147,   288,   864,    -1,   147,   864,    -1,   817,
      -1,   831,    -1,   818,    -1,    -1,   836,   839,   819,   852,
     418,    -1,    -1,   839,   820,   852,   418,    -1,   842,   418,
      -1,   796,    -1,   421,   796,    -1,    -1,   729,    -1,   387,
     351,   242,    -1,   387,   351,   318,    -1,   146,   351,   146,
      -1,   245,   351,   245,    -1,    -1,   826,   825,   828,   827,
      -1,   923,   101,   150,    39,   418,    -1,   923,   169,   150,
      39,   418,    -1,    -1,   829,    -1,   833,    -1,   831,    -1,
     829,   833,    -1,   829,   831,    -1,   833,    -1,   830,   833,
      -1,    -1,    76,   832,   839,   855,   913,   706,   418,    -1,
      -1,   836,   839,   834,   852,   418,    -1,    -1,   839,   835,
     852,   418,    -1,   842,   418,    -1,   837,   838,    -1,   837,
      -1,   838,    -1,    62,    -1,    73,    -1,    71,    -1,    56,
      -1,    57,    -1,    75,    -1,   848,    -1,   844,    -1,   840,
      -1,   913,   415,   821,   822,   416,    -1,   913,   823,    -1,
     846,    -1,    20,   908,   841,    -1,    20,   841,    -1,    20,
     908,    -1,   419,   934,   420,    -1,    -1,   846,   843,   419,
     830,   420,    -1,   842,    -1,    -1,   847,   845,   419,   830,
     420,    -1,    48,   908,    -1,   364,   908,    -1,    48,    -1,
     364,    -1,   849,    -1,   851,   850,    -1,    49,    40,    -1,
      49,    40,   215,    -1,    49,    -1,    49,   215,    -1,    49,
      29,    -1,    49,    29,   215,    -1,    49,    29,    29,    -1,
      49,    29,    29,   215,    -1,    49,   115,    -1,    40,    -1,
      40,   215,    -1,   215,    -1,    29,    -1,    29,   215,    -1,
      29,    29,    -1,    29,    29,   215,    -1,     5,    -1,   115,
      -1,   163,    -1,    41,    -1,    -1,   853,    -1,   852,   421,
     853,    -1,   855,   914,   706,   854,    -1,    -1,   402,   935,
      -1,    -1,   408,    -1,   408,   408,    -1,   150,   335,   930,
      -1,    19,   858,    -1,   859,    -1,    13,    -1,    85,    -1,
      -1,   802,    -1,   151,    -1,   174,   200,   863,    -1,    -1,
     174,   864,   861,   862,    -1,   868,   872,    -1,   872,   868,
      -1,   868,    -1,   872,    -1,    -1,   812,    -1,   393,    -1,
     777,    -1,   812,    -1,    22,   777,    -1,    33,   777,   867,
      -1,    -1,   868,    -1,   372,   873,    -1,   869,    -1,   372,
     871,    18,   931,    -1,   219,   871,    18,   931,    -1,    -1,
      42,    -1,   219,   922,    -1,   870,    -1,   874,    -1,   874,
     421,   873,    -1,   797,    -1,   926,    -1,   288,   864,   188,
     863,    -1,    17,   211,   777,   869,    -1,    17,   877,   777,
     869,    -1,    17,   877,   777,   870,    -1,    34,    -1,    -1,
       3,    18,   931,    -1,   147,    18,   931,    -1,   191,    18,
     931,   881,    -1,   882,    -1,   881,   421,   882,    -1,   929,
     402,   886,    -1,   325,    18,   931,   884,    -1,   885,    -1,
     884,   421,   885,    -1,   886,   402,   792,    -1,    12,    -1,
     191,    18,   931,    50,   792,   888,    -1,   889,    -1,   888,
     421,   889,    -1,   929,   402,   893,    -1,   325,    18,   931,
      50,   792,   891,    -1,   892,    -1,   891,   421,   892,    -1,
     893,   402,   793,    -1,     8,    -1,    14,    -1,    15,    -1,
      16,    -1,    26,    -1,    27,    -1,    28,    -1,    30,    -1,
      31,    -1,    32,    -1,   286,    -1,    36,    -1,    37,    -1,
      38,    -1,   361,    -1,   325,     4,   402,   895,    -1,   325,
       4,   351,   895,    -1,   271,    -1,   267,    -1,   325,    10,
     351,   859,    -1,   325,    10,   402,   859,    -1,   325,    10,
     859,    -1,    -1,   361,   898,   913,   221,   839,   706,   899,
      -1,    35,    -1,    -1,    -1,    51,   901,   912,   221,   839,
     706,   899,    -1,    52,    43,   903,    -1,    52,   257,    21,
     903,    -1,    52,    45,   903,    -1,    11,    -1,    44,    -1,
      47,    -1,    24,   777,    -1,    23,   351,   777,    -1,   161,
     777,   415,   924,   416,    -1,   161,     6,    -1,     7,   777,
     415,   924,   416,    -1,     7,   777,    -1,   905,    -1,   906,
      -1,     6,    -1,     7,    -1,     8,    -1,    11,    -1,    12,
      -1,    14,    -1,    15,    -1,    16,    -1,    21,    -1,    23,
      -1,    24,    -1,    25,    -1,    26,    -1,    27,    -1,    28,
      -1,    30,    -1,    31,    -1,    32,    -1,    36,    -1,    37,
      -1,    38,    -1,    39,    -1,    43,    -1,    44,    -1,    45,
      -1,    47,    -1,    50,    -1,     9,    -1,    17,    -1,    19,
      -1,    33,    -1,    51,    -1,    52,    -1,     5,    -1,    29,
      -1,    34,    -1,    40,    -1,    48,    -1,    41,    -1,    49,
      -1,   912,    -1,   930,    -1,   916,    -1,   919,    -1,   904,
      -1,   915,    -1,   115,    -1,   930,    -1,   916,    -1,   904,
      -1,   907,    -1,   915,    -1,   930,    -1,   916,    -1,   920,
      -1,   904,    -1,   915,    -1,   914,    -1,   907,    -1,   115,
      -1,   211,    -1,   215,    -1,   364,    -1,   351,    -1,   915,
      -1,   917,    -1,   930,    -1,   919,    -1,   920,    -1,   905,
      -1,   913,    -1,   921,    -1,   918,    -1,   906,    -1,    56,
      -1,    57,    -1,    62,    -1,    71,    -1,    73,    -1,    76,
      -1,    75,    -1,   917,    -1,   918,    -1,   146,    -1,   198,
      -1,   242,    -1,   245,    -1,   318,    -1,   387,    -1,    78,
      -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,    83,
      -1,    84,    -1,    86,    -1,    87,    -1,    95,    -1,    96,
      -1,    97,    -1,    99,    -1,   100,    -1,   101,    -1,   108,
      -1,   109,    -1,   111,    -1,   114,    -1,   117,    -1,   119,
      -1,   120,    -1,   121,    -1,   122,    -1,   126,    -1,   127,
      -1,   128,    -1,   130,    -1,   131,    -1,   133,    -1,   135,
      -1,   136,    -1,   138,    -1,   143,    -1,   144,    -1,   145,
      -1,   147,    -1,   150,    -1,   152,    -1,   154,    -1,   156,
      -1,   157,    -1,   158,    -1,   162,    -1,   163,    -1,   164,
      -1,   165,    -1,   167,    -1,   168,    -1,   170,    -1,   173,
      -1,   172,    -1,   174,    -1,   176,    -1,   180,    -1,   181,
      -1,   184,    -1,   186,    -1,   190,    -1,   192,    -1,   195,
      -1,   197,    -1,   200,    -1,   201,    -1,   202,    -1,   204,
      -1,   205,    -1,   206,    -1,   207,    -1,   212,    -1,   213,
      -1,   214,    -1,   223,    -1,   225,    -1,   226,    -1,   227,
      -1,   228,    -1,   229,    -1,   232,    -1,   235,    -1,   236,
      -1,   237,    -1,   238,    -1,   239,    -1,   240,    -1,   241,
      -1,   243,    -1,   244,    -1,   246,    -1,   247,    -1,   252,
      -1,   253,    -1,   254,    -1,   255,    -1,   258,    -1,   259,
      -1,   261,    -1,   265,    -1,   266,    -1,   269,    -1,   273,
      -1,   274,    -1,   281,    -1,   282,    -1,   283,    -1,   288,
      -1,   287,    -1,   290,    -1,   291,    -1,   292,    -1,   293,
      -1,   294,    -1,   295,    -1,   297,    -1,   299,    -1,   300,
      -1,   301,    -1,   302,    -1,   303,    -1,   304,    -1,   305,
      -1,   306,    -1,   307,    -1,   308,    -1,   309,    -1,   311,
      -1,   313,    -1,   314,    -1,   315,    -1,   316,    -1,   317,
      -1,   321,    -1,   322,    -1,   323,    -1,   325,    -1,   327,
      -1,   328,    -1,   330,    -1,   333,    -1,   334,    -1,   335,
      -1,   336,    -1,   337,    -1,   338,    -1,   339,    -1,   340,
      -1,   342,    -1,   344,    -1,   345,    -1,   346,    -1,   347,
      -1,   352,    -1,   354,    -1,   356,    -1,   359,    -1,   360,
      -1,   361,    -1,   362,    -1,   363,    -1,   366,    -1,   367,
      -1,   368,    -1,   369,    -1,   370,    -1,   373,    -1,   374,
      -1,   375,    -1,   377,    -1,   379,    -1,   383,    -1,   384,
      -1,   385,    -1,   386,    -1,   388,    -1,   103,    -1,   105,
      -1,   116,    -1,   123,    -1,   132,    -1,   148,    -1,   149,
      -1,   175,    -1,   178,    -1,   182,    -1,   210,    -1,   216,
      -1,   218,    -1,   248,    -1,   250,    -1,   256,    -1,   263,
      -1,   264,    -1,   277,    -1,   280,    -1,   285,    -1,   286,
      -1,   296,    -1,   312,    -1,   326,    -1,   331,    -1,   341,
      -1,   349,    -1,   350,    -1,   355,    -1,   357,    -1,   376,
      -1,    98,    -1,   102,    -1,   104,    -1,   137,    -1,   187,
      -1,   189,    -1,   199,    -1,   209,    -1,   221,    -1,   222,
      -1,   224,    -1,   231,    -1,   233,    -1,   249,    -1,   260,
      -1,   278,    -1,   279,    -1,   310,    -1,   329,    -1,   378,
      -1,    85,    -1,    88,    -1,    89,    -1,    90,    -1,    91,
      -1,    92,    -1,    93,    -1,    94,    -1,   107,    -1,   112,
      -1,   113,    -1,   118,    -1,   124,    -1,   125,    -1,   129,
      -1,   134,    -1,   139,    -1,   140,    -1,   141,    -1,   142,
      -1,   151,    -1,   153,    -1,   159,    -1,   160,    -1,   161,
      -1,   166,    -1,   169,    -1,   171,    -1,   179,    -1,   183,
      -1,   185,    -1,   188,    -1,   193,    -1,   194,    -1,   196,
      -1,   203,    -1,   208,    -1,   217,    -1,   219,    -1,   230,
      -1,   234,    -1,   251,    -1,   257,    -1,   262,    -1,   267,
      -1,   268,    -1,   270,    -1,   271,    -1,   272,    -1,   275,
      -1,   276,    -1,   289,    -1,   298,    -1,   320,    -1,   324,
      -1,   332,    -1,   343,    -1,   348,    -1,   353,    -1,   358,
      -1,   365,    -1,   371,    -1,   372,    -1,   381,    -1,   382,
      -1,   925,    -1,   922,   421,   925,    -1,    46,    -1,    -1,
     934,    -1,   929,   928,    -1,   929,    -1,   929,   928,    -1,
     929,    -1,   929,    -1,    26,   929,    -1,    26,   777,    -1,
     394,    -1,   390,    -1,   393,    -1,   777,    -1,   812,    -1,
     937,    -1,   415,   416,    -1,   415,   933,   416,    -1,   932,
      -1,   933,   932,    -1,   935,    -1,   934,   421,   935,    -1,
     933,    -1,   419,   934,   420,    -1,   937,    -1,   415,    -1,
     416,    -1,   421,    -1,   418,    -1,   390,    -1,   393,    -1,
     785,    -1,   786,    -1,   789,    -1,   408,    -1,   406,    -1,
     407,    -1,   409,    -1,   410,    -1,   262,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      59,    -1,    60,    -1,    61,    -1,    62,    -1,    63,    -1,
      64,    -1,    66,    -1,    65,    -1,    67,    -1,    68,    -1,
      69,    -1,    70,    -1,    71,    -1,    72,    -1,    73,    -1,
      74,    -1,    76,    -1,    75,    -1,     5,    -1,    20,    -1,
     198,    -1,   215,    -1,    29,    -1,   242,    -1,   245,    -1,
     318,    -1,    40,    -1,    41,    -1,    48,    -1,    49,    -1,
     387,    -1,   115,    -1,   182,    -1,   351,    -1,   364,    -1,
     376,    -1,   413,    -1,   414,    -1,   402,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   591,   591,   593,   594,   597,   598,   599,   605,   606,
     607,   608,   609,   612,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   656,   657,   658,   659,   660,
     661,   662,   663,   664,   665,   666,   667,   668,   669,   670,
     671,   672,   673,   674,   675,   677,   678,   679,   680,   681,
     682,   683,   684,   685,   686,   687,   688,   689,   690,   691,
     693,   694,   695,   696,   697,   698,   699,   700,   702,   703,
     704,   705,   706,   707,   708,   709,   710,   716,   717,   718,
     719,   720,   721,   722,   723,   724,   730,   740,   744,   752,
     760,   764,   775,   785,   789,   796,   803,   809,   817,   827,
     833,   842,   849,   855,   864,   871,   892,   896,   897,   908,
     910,   914,   916,   926,   933,   934,   937,   939,   941,   943,
     945,   947,   949,   951,   955,   957,   967,   969,   976,   977,
     980,   982,   993,   995,  1005,  1016,  1018,  1022,  1023,  1026,
    1027,  1034,  1035,  1036,  1037,  1038,  1039,  1052,  1054,  1056,
    1060,  1062,  1064,  1066,  1068,  1070,  1072,  1074,  1078,  1079,
    1083,  1085,  1089,  1091,  1095,  1096,  1097,  1098,  1101,  1102,
    1103,  1106,  1107,  1108,  1109,  1119,  1120,  1121,  1123,  1125,
    1127,  1131,  1132,  1133,  1136,  1137,  1140,  1142,  1144,  1146,
    1148,  1152,  1154,  1156,  1158,  1160,  1164,  1168,  1170,  1174,
    1175,  1181,  1192,  1194,  1200,  1201,  1205,  1209,  1212,  1215,
    1218,  1221,  1224,  1227,  1230,  1233,  1236,  1239,  1242,  1245,
    1249,  1250,  1256,  1259,  1264,  1265,  1268,  1269,  1270,  1273,
    1274,  1284,  1298,  1303,  1304,  1312,  1313,  1314,  1317,  1318,
    1321,  1322,  1323,  1325,  1327,  1328,  1330,  1332,  1334,  1339,
    1340,  1343,  1344,  1351,  1354,  1357,  1358,  1368,  1371,  1381,
    1382,  1383,  1384,  1385,  1386,  1387,  1391,  1394,  1396,  1398,
    1402,  1403,  1404,  1407,  1413,  1414,  1417,  1419,  1420,  1434,
    1436,  1438,  1440,  1442,  1444,  1446,  1461,  1462,  1463,  1464,
    1467,  1474,  1475,  1476,  1483,  1485,  1489,  1491,  1493,  1495,
    1500,  1501,  1504,  1506,  1510,  1513,  1515,  1521,  1524,  1525,
    1526,  1527,  1528,  1531,  1535,  1539,  1540,  1541,  1542,  1543,
    1546,  1549,  1552,  1553,  1554,  1557,  1558,  1559,  1560,  1563,
    1564,  1567,  1568,  1577,  1576,  1594,  1595,  1596,  1600,  1603,
    1606,  1608,  1612,  1623,  1627,  1631,  1632,  1635,  1637,  1639,
    1641,  1643,  1645,  1647,  1649,  1651,  1653,  1657,  1658,  1669,
    1674,  1675,  1682,  1683,  1686,  1689,  1692,  1696,  1697,  1707,
    1711,  1712,  1726,  1737,  1742,  1750,  1751,  1754,  1756,  1758,
    1762,  1763,  1764,  1767,  1770,  1773,  1774,  1777,  1778,  1781,
    1783,  1786,  1789,  1790,  1793,  1794,  1797,  1798,  1805,  1806,
    1815,  1817,  1821,  1823,  1827,  1838,  1846,  1861,  1863,  1865,
    1867,  1871,  1875,  1879,  1880,  1883,  1884,  1888,  1889,  1890,
    1893,  1900,  1901,  1904,  1906,  1908,  1910,  1914,  1915,  1918,
    1919,  1922,  1934,  1938,  1939,  1940,  1941,  1942,  1943,  1944,
    1945,  1948,  1950,  1954,  1955,  1958,  1959,  1968,  1983,  1988,
    1993,  1998,  2003,  2008,  2013,  2018,  2023,  2025,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2045,  2048,  2049,  2052,  2054,  2056,  2058,  2060,
    2062,  2064,  2066,  2068,  2070,  2072,  2076,  2077,  2078,  2079,
    2080,  2081,  2082,  2083,  2084,  2085,  2088,  2089,  2099,  2103,
    2110,  2111,  2112,  2115,  2117,  2121,  2122,  2123,  2124,  2125,
    2126,  2127,  2128,  2129,  2130,  2131,  2132,  2135,  2137,  2139,
    2141,  2143,  2145,  2147,  2151,  2153,  2157,  2158,  2161,  2166,
    2169,  2174,  2177,  2179,  2183,  2194,  2199,  2200,  2203,  2206,
    2209,  2210,  2213,  2215,  2217,  2221,  2222,  2223,  2226,  2231,
    2232,  2235,  2237,  2241,  2243,  2247,  2248,  2251,  2252,  2258,
    2265,  2268,  2270,  2274,  2276,  2286,  2288,  2293,  2295,  2299,
    2301,  2303,  2305,  2307,  2309,  2311,  2313,  2315,  2317,  2319,
    2321,  2325,  2326,  2339,  2343,  2347,  2348,  2352,  2356,  2358,
    2360,  2362,  2367,  2369,  2373,  2376,  2381,  2382,  2386,  2397,
    2399,  2403,  2404,  2407,  2408,  2419,  2421,  2423,  2425,  2427,
    2429,  2431,  2433,  2435,  2437,  2439,  2441,  2443,  2445,  2449,
    2450,  2459,  2461,  2463,  2465,  2467,  2469,  2471,  2473,  2475,
    2477,  2489,  2488,  2498,  2499,  2500,  2504,  2506,  2510,  2511,
    2512,  2513,  2514,  2517,  2518,  2522,  2523,  2524,  2525,  2528,
    2529,  2530,  2533,  2545,  2549,  2553,  2555,  2568,  2569,  2570,
    2571,  2572,  2573,  2574,  2575,  2576,  2577,  2578,  2582,  2583,
    2584,  2588,  2590,  2591,  2595,  2596,  2597,  2601,  2602,  2612,
    2624,  2636,  2638,  2642,  2644,  2648,  2650,  2652,  2654,  2656,
    2658,  2660,  2662,  2664,  2666,  2670,  2671,  2682,  2684,  2695,
    2706,  2713,  2715,  2717,  2719,  2721,  2725,  2726,  2730,  2744,
    2746,  2748,  2761,  2763,  2765,  2769,  2771,  2775,  2776,  2779,
    2780,  2783,  2784,  2787,  2788,  2791,  2794,  2805,  2810,  2811,
    2812,  2813,  2814,  2818,  2819,  2868,  2872,  2874,  2876,  2878,
    2880,  2884,  2886,  2890,  2902,  2906,  2910,  2913,  2916,  2917,
    2918,  2919,  2920,  2921,  2922,  2923,  2926,  2927,  2937,  2951,
    2982,  2983,  2984,  2985,  2986,  2989,  2993,  2994,  3004,  3006,
    3010,  3012,  3016,  3018,  3020,  3022,  3026,  3027,  3030,  3034,
    3036,  3038,  3042,  3047,  3048,  3058,  3060,  3062,  3064,  3066,
    3068,  3070,  3072,  3076,  3077,  3080,  3081,  3084,  3086,  3088,
    3091,  3094,  3095,  3098,  3102,  3103,  3106,  3108,  3110,  3112,
    3116,  3118,  3120,  3122,  3124,  3128,  3129,  3132,  3133,  3136,
    3146,  3149,  3152,  3155,  3158,  3160,  3164,  3165,  3168,  3169,
    3180,  3181,  3184,  3185,  3195,  3197,  3199,  3201,  3203,  3205,
    3207,  3209,  3211,  3213,  3215,  3236,  3238,  3240,  3242,  3244,
    3246,  3248,  3252,  3254,  3256,  3258,  3262,  3263,  3264,  3265,
    3269,  3270,  3280,  3282,  3286,  3288,  3290,  3292,  3296,  3299,
    3300,  3303,  3305,  3309,  3322,  3324,  3326,  3328,  3333,  3339,
    3346,  3353,  3354,  3355,  3356,  3357,  3358,  3359,  3360,  3361,
    3364,  3365,  3366,  3367,  3368,  3369,  3371,  3373,  3377,  3378,
    3379,  3380,  3381,  3384,  3392,  3394,  3396,  3398,  3400,  3402,
    3404,  3406,  3408,  3410,  3412,  3416,  3419,  3422,  3424,  3427,
    3430,  3432,  3435,  3443,  3444,  3447,  3448,  3451,  3455,  3464,
    3465,  3468,  3469,  3472,  3476,  3480,  3482,  3484,  3486,  3488,
    3490,  3494,  3497,  3500,  3503,  3506,  3508,  3510,  3512,  3516,
    3520,  3522,  3525,  3528,  3529,  3530,  3531,  3532,  3533,  3534,
    3535,  3536,  3537,  3538,  3539,  3540,  3541,  3567,  3569,  3571,
    3582,  3584,  3586,  3588,  3590,  3592,  3594,  3596,  3598,  3600,
    3602,  3604,  3606,  3608,  3610,  3612,  3614,  3616,  3618,  3620,
    3622,  3624,  3626,  3628,  3630,  3632,  3634,  3636,  3638,  3640,
    3642,  3644,  3646,  3648,  3650,  3652,  3654,  3665,  3667,  3669,
    3671,  3673,  3675,  3677,  3679,  3681,  3683,  3685,  3687,  3689,
    3691,  3693,  3695,  3707,  3709,  3711,  3713,  3715,  3717,  3719,
    3721,  3723,  3725,  3727,  3729,  3731,  3733,  3735,  3737,  3739,
    3741,  3743,  3745,  3747,  3749,  3761,  3763,  3765,  3767,  3769,
    3771,  3773,  3775,  3777,  3779,  3781,  3793,  3795,  3797,  3799,
    3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3817,  3819,
    3821,  3823,  3825,  3827,  3829,  3832,  3834,  3836,  3838,  3840,
    3842,  3844,  3846,  3851,  3853,  3855,  3859,  3860,  3861,  3864,
    3865,  3868,  3869,  3870,  3871,  3872,  3873,  3874,  3875,  3876,
    3879,  3880,  3883,  3884,  3887,  3888,  3889,  3890,  3891,  3892,
    3895,  3897,  3901,  3904,  3907,  3909,  3913,  3914,  3918,  3919,
    3925,  3926,  3927,  3928,  3929,  3930,  3931,  3932,  3936,  3938,
    3943,  3947,  3950,  3953,  3955,  3957,  3959,  3961,  3964,  3967,
    3971,  3975,  3977,  3979,  3983,  3985,  3992,  3996,  3998,  4002,
    4006,  4009,  4012,  4013,  4016,  4017,  4021,  4022,  4023,  4024,
    4027,  4028,  4032,  4033,  4036,  4037,  4047,  4049,  4054,  4056,
    4058,  4063,  4065,  4089,  4093,  4102,  4113,  4121,  4131,  4133,
    4137,  4139,  4143,  4144,  4154,  4155,  4158,  4160,  4164,  4166,
    4170,  4172,  4177,  4178,  4179,  4180,  4181,  4183,  4185,  4187,
    4195,  4197,  4199,  4201,  4203,  4205,  4207,  4209,  4213,  4214,
    4215,  4216,  4217,  4228,  4229,  4232,  4233,  4236,  4244,  4247,
    4255,  4256,  4265,  4274,  4286,  4287,  4290,  4291,  4292,  4295,
    4296,  4297,  4298,  4299,  4302,  4303,  4306,  4307,  4308,  4309,
    4310,  4311,  4314,  4316,  4323,  4339,  4341,  4344,  4346,  4350,
    4358,  4374,  4381,  4387,  4399,  4408,  4409,  4412,  4413,  4414,
    4417,  4418,  4421,  4422,  4425,  4426,  4429,  4431,  4433,  4435,
    4439,  4446,  4469,  4501,  4511,  4518,  4558,  4560,  4567,  4569,
    4570,  4575,  4573,  4588,  4587,  4600,  4606,  4608,  4609,  4612,
    4613,  4614,  4615,  4616,  4623,  4622,  4632,  4634,  4636,  4637,
    4640,  4641,  4642,  4643,  4646,  4647,  4651,  4650,  4711,  4709,
    4724,  4723,  4736,  4742,  4746,  4750,  4756,  4757,  4758,  4759,
    4762,  4763,  4766,  4774,  4791,  4799,  4822,  4916,  4950,  4952,
    4954,  4958,  4962,  4961,  5012,  5014,  5013,  5028,  5034,  5041,
    5046,  5049,  5050,  5053,  5054,  5055,  5056,  5057,  5058,  5059,
    5067,  5075,  5078,  5079,  5080,  5081,  5082,  5083,  5091,  5099,
    5100,  5101,  5104,  5105,  5108,  5110,  5114,  5184,  5185,  5192,
    5193,  5194,  5200,  5209,  5212,  5213,  5214,  5215,  5218,  5219,
    5225,  5239,  5238,  5256,  5257,  5258,  5259,  5260,  5263,  5265,
    5269,  5270,  5277,  5282,  5284,  5285,  5288,  5289,  5292,  5299,
    5306,  5306,  5308,  5309,  5312,  5312,  5314,  5324,  5333,  5339,
    5345,  5351,  5359,  5360,  5372,  5382,  5393,  5397,  5398,  5401,
    5406,  5410,  5411,  5414,  5421,  5428,  5432,  5433,  5436,  5439,
    5443,  5444,  5447,  5454,  5455,  5456,  5457,  5458,  5459,  5460,
    5461,  5462,  5463,  5464,  5465,  5466,  5467,  5468,  5498,  5499,
    5502,  5503,  5510,  5511,  5512,  5519,  5518,  5577,  5578,  5585,
    5584,  5653,  5659,  5665,  5673,  5679,  5685,  5691,  5697,  5703,
    5709,  5715,  5721,  5732,  5733,  5736,  5737,  5738,  5739,  5740,
    5741,  5742,  5743,  5744,  5745,  5746,  5747,  5748,  5749,  5750,
    5751,  5752,  5753,  5754,  5755,  5756,  5757,  5758,  5759,  5760,
    5761,  5762,  5765,  5766,  5767,  5768,  5769,  5770,  5774,  5775,
    5776,  5777,  5778,  5779,  5780,  5783,  5799,  5800,  5801,  5802,
    5803,  5804,  5809,  5810,  5811,  5812,  5813,  5818,  5819,  5820,
    5821,  5822,  5828,  5829,  5830,  5831,  5832,  5833,  5834,  5835,
    5836,  5839,  5840,  5841,  5842,  5845,  5846,  5847,  5848,  5851,
    5852,  5853,  5854,  5855,  5856,  5857,  5875,  5875,  5877,  5878,
    5879,  5880,  5881,  5882,  5885,  5886,  5887,  5888,  5889,  5890,
    5891,  5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5900,
    5901,  5902,  5903,  5904,  5905,  5906,  5907,  5908,  5909,  5910,
    5911,  5912,  5913,  5914,  5915,  5916,  5917,  5918,  5919,  5920,
    5922,  5923,  5924,  5925,  5926,  5927,  5928,  5929,  5930,  5931,
    5932,  5933,  5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,
    5942,  5943,  5944,  5945,  5946,  5947,  5949,  5950,  5951,  5952,
    5953,  5954,  5955,  5956,  5957,  5958,  5959,  5960,  5961,  5962,
    5963,  5964,  5965,  5966,  5967,  5968,  5969,  5970,  5971,  5972,
    5974,  5975,  5977,  5978,  5979,  5980,  5981,  5982,  5983,  5984,
    5985,  5986,  5987,  5988,  5989,  5990,  5991,  5992,  5993,  5994,
    5995,  5996,  5997,  5998,  5999,  6000,  6001,  6002,  6003,  6004,
    6005,  6006,  6007,  6008,  6009,  6010,  6011,  6012,  6013,  6014,
    6015,  6016,  6017,  6018,  6019,  6021,  6022,  6023,  6024,  6025,
    6026,  6027,  6028,  6029,  6030,  6031,  6032,  6033,  6034,  6035,
    6036,  6037,  6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,
    6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,
    6056,  6057,  6058,  6059,  6060,  6061,  6062,  6064,  6078,  6079,
    6083,  6084,  6085,  6086,  6087,  6088,  6089,  6090,  6091,  6095,
    6096,  6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,
    6106,  6107,  6108,  6109,  6110,  6111,  6112,  6113,  6114,  6115,
    6129,  6130,  6131,  6132,  6133,  6134,  6135,  6136,  6137,  6138,
    6139,  6140,  6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,
    6158,  6159,  6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,
    6168,  6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,
    6178,  6179,  6180,  6181,  6182,  6183,  6184,  6185,  6186,  6187,
    6188,  6189,  6190,  6191,  6192,  6193,  6194,  6195,  6196,  6197,
    6198,  6199,  6200,  6201,  6202,  6203,  6204,  6205,  6206,  6207,
    6208,  6209,  6210,  6211,  6212,  6213,  6214,  6215,  6219,  6220,
    6224,  6225,  6226,  6227,  6228,  6232,  6232,  6235,  6238,  6239,
    6242,  6244,  6249,  6259,  6266,  6267,  6268,  6271,  6300,  6301,
    6304,  6306,  6314,  6315,  6316,  6320,  6321,  6325,  6326,  6329,
    6330,  6333,  6334,  6335,  6336,  6337,  6340,  6341,  6342,  6343,
    6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6353,
    6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,
    6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,  6372,  6373,
    6374,  6375,  6376,  6377,  6378,  6379,  6380,  6381,  6382,  6383,
    6384,  6385,  6386,  6387,  6388,  6389,  6390,  6391,  6392,  6393,
    6394,  6395
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", 
  "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", 
  "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", 
  "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", 
  "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", "SQL_WHENEVER", "S_ADD", 
  "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", "S_DEC", "S_DIV", 
  "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", "S_LSHIFT", "S_MEMPOINT", 
  "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", "S_OR", "S_REGISTER", 
  "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", "S_TYPEDEF", "TYPECAST", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", 
  "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONSTRAINT", "CONSTRAINTS", 
  "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", 
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", 
  "GRANT", "GROUP_P", "HANDLER", "HAVING", "HOLD", "HOUR_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", "RECHECK", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", 
  "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "SUBSTRING", "SYSID", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", 
  "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", 
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", 
  "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", 
  "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", "USING", 
  "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", 
  "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", 
  "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", 
  "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "','", "\"=\"", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateUserStmt", "opt_with", 
  "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", "OptUserList", 
  "OptUserElem", "user_list", "CreateGroupStmt", "OptGroupList", 
  "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "OptTableSpace", 
  "OptConsTableSpace", "CreateAsStmt", "@1", "WithOidsAs", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", 
  "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_Trusted", 
  "handler_name", "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "createfunc_opt_item", 
  "opt_definition", "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", 
  "RemoveOperStmt", "oper_argtypes", "any_operator", "CreateCastStmt", 
  "cast_context", "DropCastStmt", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "AlterOwnerStmt", "RuleStmt", 
  "@2", "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_update_clause", "opt_for_update_clause", 
  "update_list", "from_clause", "from_list", "table_ref", "joined_table", 
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr", 
  "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "UserId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "db_prefix", "server", "opt_server", 
  "server_name", "opt_port", "opt_connection_name", "opt_user", 
  "ora_user", "user_name", "char_variable", "opt_options", 
  "ECPGCursorStmt", "ECPGDeallocate", "ECPGVarDeclaration", 
  "single_vt_declaration", "single_var_declaration", "@3", "@4", 
  "precision", "opt_scale", "ecpg_interval", "ECPGDeclaration", "@5", 
  "sql_startdeclare", "sql_enddeclare", "var_type_declarations", 
  "vt_declarations", "variable_declarations", "type_declaration", "@6", 
  "var_declaration", "@7", "@8", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,    61,    60,    62,   657,    43,    45,    42,    47,
      37,    94,   658,    91,    93,    40,    41,    46,    59,   123,
     125,    44,   659,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   424,   425,   426,   426,   427,   427,   427,   427,   427,
     427,   427,   427,   428,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   430,   431,   431,   432,
     432,   433,   433,   434,   435,   435,   436,   436,   436,   436,
     436,   436,   436,   436,   437,   437,   438,   438,   439,   439,
     440,   440,   441,   441,   442,   443,   443,   444,   444,   445,
     445,   446,   446,   446,   446,   446,   446,   447,   447,   447,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   449,
     450,   450,   451,   451,   452,   452,   452,   452,   453,   453,
     453,   454,   454,   454,   454,   455,   455,   455,   455,   455,
     455,   456,   456,   456,   457,   457,   458,   458,   458,   458,
     458,   459,   459,   459,   459,   459,   460,   461,   461,   462,
     462,   463,   464,   464,   465,   465,   466,   466,   466,   466,
     466,   466,   466,   466,   466,   466,   466,   466,   466,   466,
     467,   467,   468,   468,   469,   469,   470,   470,   470,   471,
     471,   472,   473,   474,   474,   475,   475,   475,   476,   476,
     477,   477,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   479,   479,   480,   480,   481,   481,   482,   482,   483,
     483,   483,   483,   483,   483,   483,   484,   484,   485,   485,
     486,   486,   486,   487,   488,   488,   489,   489,   489,   490,
     490,   490,   490,   490,   490,   490,   491,   491,   491,   491,
     492,   493,   493,   493,   494,   494,   495,   495,   495,   495,
     496,   496,   497,   497,   498,   499,   499,   499,   500,   500,
     500,   500,   500,   501,   502,   503,   503,   503,   503,   503,
     504,   504,   505,   505,   505,   506,   506,   506,   506,   507,
     507,   508,   508,   510,   509,   511,   511,   511,   512,   512,
     513,   513,   514,   515,   516,   517,   517,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   519,   520,
     521,   521,   522,   522,   523,   523,   524,   525,   525,   526,
     527,   527,   528,   529,   529,   530,   530,   531,   531,   531,
     532,   532,   532,   533,   533,   534,   534,   535,   535,   536,
     536,   536,   537,   537,   538,   538,   539,   539,   539,   539,
     540,   540,   541,   541,   542,   543,   544,   545,   545,   545,
     545,   546,   547,   548,   548,   549,   549,   550,   550,   550,
     551,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   556,   557,   558,   558,   558,   558,   558,   558,   558,
     558,   559,   559,   560,   560,   561,   561,   562,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   564,   564,
     564,   564,   564,   564,   564,   564,   564,   564,   564,   564,
     564,   564,   565,   566,   566,   567,   567,   567,   567,   567,
     567,   567,   567,   567,   567,   567,   568,   568,   568,   568,
     568,   568,   568,   568,   568,   568,   569,   569,   570,   571,
     572,   572,   572,   573,   573,   574,   574,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   575,   575,   575,
     575,   575,   575,   575,   576,   576,   577,   577,   578,   578,
     579,   579,   580,   580,   581,   582,   583,   583,   584,   584,
     585,   585,   586,   586,   586,   587,   587,   587,   588,   589,
     589,   590,   590,   591,   591,   592,   592,   593,   593,   593,
     593,   594,   594,   595,   596,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   601,   602,   603,   603,   604,   605,   605,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     610,   611,   611,   612,   612,   613,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   613,   613,   614,
     614,   615,   615,   615,   615,   615,   615,   615,   615,   615,
     615,   617,   616,   618,   618,   618,   619,   619,   620,   620,
     620,   620,   620,   621,   621,   622,   622,   622,   622,   623,
     623,   623,   624,   625,   626,   627,   627,   628,   628,   628,
     628,   628,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   630,   630,   630,   631,   631,   631,   632,   632,   633,
     634,   635,   635,   636,   636,   637,   637,   637,   637,   637,
     637,   637,   637,   637,   637,   638,   638,   639,   639,   640,
     641,   642,   642,   642,   642,   642,   643,   643,   644,   645,
     645,   645,   646,   646,   646,   647,   647,   648,   648,   649,
     649,   650,   650,   651,   651,   652,   652,   653,   654,   654,
     654,   654,   654,   655,   655,   656,   657,   657,   657,   657,
     657,   658,   658,   659,   660,   661,   662,   662,   663,   663,
     663,   663,   663,   663,   663,   663,   664,   664,   665,   666,
     667,   667,   667,   667,   667,   668,   668,   668,   669,   669,
     670,   670,   671,   671,   671,   671,   672,   672,   673,   673,
     673,   673,   674,   674,   674,   675,   675,   675,   675,   675,
     675,   675,   675,   676,   676,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   681,   682,   682,   682,   682,
     683,   683,   683,   683,   683,   684,   684,   685,   685,   686,
     687,   687,   688,   688,   689,   689,   690,   690,   691,   691,
     692,   692,   693,   693,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   696,   696,   696,   696,   697,   697,   697,   697,
     698,   698,   699,   699,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   705,   705,   705,   705,   706,   706,
     706,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   709,   709,
     709,   709,   709,   710,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   712,   712,   713,   713,   713,
     714,   714,   714,   715,   715,   716,   716,   717,   718,   719,
     719,   720,   720,   721,   722,   723,   723,   723,   723,   723,
     723,   724,   724,   725,   725,   726,   726,   726,   726,   727,
     728,   728,   728,   729,   729,   729,   729,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   734,   734,   734,   735,   735,   735,   736,
     736,   737,   737,   737,   737,   737,   737,   737,   737,   737,
     738,   738,   739,   739,   740,   740,   740,   740,   740,   740,
     741,   741,   742,   742,   743,   743,   744,   744,   745,   745,
     746,   746,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   749,   749,   750,   750,   750,   750,   750,   750,   751,
     752,   753,   753,   753,   754,   754,   755,   756,   756,   757,
     758,   758,   759,   759,   760,   760,   761,   761,   761,   761,
     762,   762,   763,   763,   764,   764,   765,   765,   766,   766,
     766,   767,   767,   767,   768,   768,   769,   769,   770,   770,
     771,   771,   772,   772,   773,   773,   774,   774,   775,   775,
     776,   776,   777,   778,   779,   780,   781,   782,   783,   783,
     784,   784,   784,   784,   784,   784,   784,   784,   785,   786,
     787,   788,   789,   790,   790,   791,   791,   792,   792,   793,
     793,   793,   793,   793,   794,   794,   795,   795,   795,   796,
     796,   796,   796,   796,   797,   797,   798,   798,   798,   798,
     798,   798,   799,   800,   800,   801,   801,   801,   801,   802,
     802,   802,   802,   803,   804,   805,   805,   806,   806,   806,
     807,   807,   808,   808,   809,   809,   810,   810,   810,   810,
     811,   811,   812,   813,   813,   814,   815,   815,   816,   817,
     817,   819,   818,   820,   818,   818,   821,   822,   822,   823,
     823,   823,   823,   823,   825,   824,   826,   827,   828,   828,
     829,   829,   829,   829,   830,   830,   832,   831,   834,   833,
     835,   833,   833,   836,   836,   836,   837,   837,   837,   837,
     838,   838,   839,   839,   839,   839,   839,   839,   840,   840,
     840,   841,   843,   842,   844,   845,   844,   846,   846,   847,
     847,   848,   848,   849,   849,   849,   849,   849,   849,   849,
     849,   849,   850,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   851,   851,   852,   852,   853,   854,   854,   855,
     855,   855,   856,   857,   858,   858,   858,   858,   859,   859,
     860,   861,   860,   862,   862,   862,   862,   862,   863,   863,
     864,   864,   865,   866,   867,   867,   868,   868,   869,   870,
     871,   871,   872,   872,   873,   873,   874,   874,   875,   876,
     876,   876,   877,   877,   878,   879,   880,   881,   881,   882,
     883,   884,   884,   885,   886,   887,   888,   888,   889,   890,
     891,   891,   892,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   894,   894,
     895,   895,   896,   896,   896,   898,   897,   899,   899,   901,
     900,   902,   902,   902,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   904,   904,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   906,   906,   906,   906,   906,   906,   907,   907,
     907,   907,   907,   907,   907,   908,   909,   909,   909,   909,
     909,   909,   910,   910,   910,   910,   910,   911,   911,   911,
     911,   911,   912,   912,   912,   912,   912,   912,   912,   912,
     912,   913,   913,   913,   913,   914,   914,   914,   914,   915,
     915,   915,   915,   915,   915,   915,   916,   916,   917,   917,
     917,   917,   917,   917,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   922,   922,   923,   924,   924,
     925,   925,   926,   927,   928,   928,   928,   929,   930,   930,
     931,   931,   932,   932,   932,   933,   933,   934,   934,   935,
     935,   936,   936,   936,   936,   936,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     4,
       5,     5,     4,     3,     2,     0,     2,     2,     1,     1,
       1,     1,     3,     3,     3,     1,     4,     5,     2,     0,
       2,     2,     6,     6,     3,     6,     4,     1,     0,     2,
       0,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     2,     5,     2,     3,     3,     1,     3,
       1,     1,     1,     3,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     0,     1,     1,     2,     3,     4,     3,
       2,     2,     3,     4,     3,     2,     4,     1,     1,     1,
       1,     1,     4,     4,     1,     3,     3,     4,     6,     6,
       6,     6,     4,     6,     2,     4,     3,     3,     3,     3,
       1,     3,     3,     3,     3,     2,     1,     1,     0,     2,
       0,     2,     9,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     3,     3,     1,     3,     3,     3,     4,     1,
       0,     2,     0,     3,     0,     1,     0,    11,    12,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     1,     3,
       1,     1,     1,     3,     2,     0,     3,     1,     1,     2,
       1,     2,     3,     4,     2,     5,     1,     2,     2,     2,
       3,     2,     2,     0,     3,     1,     4,     5,     6,    11,
       3,     0,     3,     1,     1,     2,     2,     0,     1,     1,
       2,     2,     0,     3,     3,     2,     1,     1,     2,     2,
       4,     0,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     0,     8,     3,     3,     1,     3,     0,
       3,     1,     1,     5,     4,     2,     0,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     0,     8,
       1,     0,     1,     2,     2,     0,     5,     1,     0,     6,
       2,     0,     3,    14,    19,     1,     1,     1,     3,     5,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     1,
       3,     0,     1,     1,     0,     2,     1,     2,     1,     2,
       2,     1,     2,     2,     6,     8,     3,     4,     4,     4,
       5,     3,     3,     1,     3,     3,     1,     1,     1,     1,
      12,     1,     3,     4,     7,     4,     2,     1,     0,     1,
       0,     7,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     2,     2,     3,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     9,     7,    10,     7,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     7,     8,
       2,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       3,     0,     1,     3,     2,    12,     1,     0,     2,     0,
       1,     3,     2,     2,     4,     1,     2,     0,     9,     2,
       0,     3,     2,     1,     3,     3,     2,     1,     1,     1,
       0,     1,     3,     1,     1,     1,     4,     1,     2,     2,
       2,     1,     1,     1,     4,     5,     1,     3,     3,     2,
       2,     2,     0,     5,     7,     1,     1,     7,     1,     3,
       3,     3,     1,     3,    11,    10,     2,     0,     8,     4,
       4,     1,     1,     1,     0,     9,     6,     6,     7,     6,
       6,     9,     6,     6,     6,     8,     8,     6,     6,     1,
       0,     9,     6,     6,     6,     7,     9,     9,     6,     6,
       6,     0,    14,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     1,     1,
       0,     3,     2,     2,     1,     3,     2,     1,     0,     7,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     0,     5,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     4,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     6,     7,
       0,     2,     2,     2,     3,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     1,     1,     8,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     3,     3,     1,     0,     2,     0,
       2,     0,     3,     1,     1,     2,     1,     2,     5,     6,
       5,     1,     2,     1,     4,     3,     4,     3,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     2,
       0,     1,     3,     2,     2,     3,     5,     6,     3,     4,
       0,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     5,     3,     0,
       5,     3,     0,     1,     1,     1,     1,     5,     2,     1,
       1,     1,     1,     5,     2,     2,     2,     1,     3,     3,
       2,     1,     0,     3,     0,     5,     2,     5,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     0,     1,     3,     5,
       2,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     3,     3,
       2,     3,     5,     4,     6,     3,     5,     4,     6,     4,
       6,     5,     7,     2,     3,     2,     4,     3,     4,     3,
       4,     3,     4,     5,     6,     7,     5,     6,     3,     4,
       4,     6,     2,     1,     3,     2,     2,     2,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     5,     6,     7,     1,     1,     2,     4,     1,
       1,     1,     2,     2,     2,     1,     3,     4,     5,     5,
       4,     1,     2,     4,     2,     4,     2,     2,     2,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     6,     4,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     3,     1,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     2,     0,     3,     1,     3,     1,
       1,     3,     7,     1,     2,     4,     1,     3,     4,     4,
       3,     1,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     3,     2,     2,     3,
       7,     1,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     0,     4,     5,     5,     0,     1,
       1,     1,     2,     2,     1,     2,     0,     7,     0,     5,
       0,     4,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     4,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       3,     0,     4,     2,     2,     1,     1,     0,     1,     1,
       1,     1,     2,     3,     0,     1,     2,     1,     4,     4,
       0,     1,     2,     1,     1,     3,     1,     1,     4,     4,
       4,     4,     1,     0,     3,     3,     4,     1,     3,     3,
       4,     1,     3,     3,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1921,  1922,  1925,  1929,  1930,  1857,
    1931,  1932,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1910,  1909,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1920,  1919,  1934,  1935,  1923,  1924,
    1926,  1927,  1896,  1928,  1936,  1937,  1938,  1933,  1886,  1212,
    1887,    10,  1208,  1209,  1941,  1892,  1893,  1891,  1894,  1895,
    1939,  1940,  1882,  1883,  1885,    11,    12,  1884,     4,  1888,
    1889,  1890,     8,  1294,  1363,     9,  1881,  1363,     0,  1475,
    1476,  1477,     0,  1478,  1479,  1480,  1481,  1482,  1413,  1377,
       0,  1483,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,  1492,     0,  1493,  1494,  1495,  1496,  1362,  1497,  1498,
    1499,  1500,  1339,  1345,  1501,  1459,     0,  1319,  1320,  1316,
    1318,  1317,  1321,  1306,   670,     0,   718,   717,     0,  1770,
     670,  1771,  1738,  1772,  1739,  1740,   201,     0,   711,  1741,
       0,   670,  1742,   250,   550,  1773,     0,     0,  1743,  1744,
       0,     0,   368,   670,     0,  1745,   734,  1746,     0,  1747,
    1774,  1775,     0,     0,  1776,  1777,  1748,     0,  1749,  1750,
    1778,  1779,  1780,  1781,  1782,     0,     0,   794,     0,  1751,
    1783,  1752,  1753,     0,  1784,  1754,  1755,  1756,  1785,  1786,
    1757,  1758,  1759,     0,  1760,     0,     0,     0,   531,  1787,
     670,  1761,     0,   800,     0,  1762,     0,  1788,  1763,     0,
    1764,  1765,  1766,  1767,  1768,   794,  1455,  1340,     0,     0,
     722,  1769,  1789,  1868,  1869,     0,     0,     0,    43,    21,
      20,    57,    35,    16,    50,    38,    81,    82,    83,    27,
      23,    19,    24,    28,    40,    29,    39,    18,    36,    52,
      42,    55,    41,    56,    30,    48,    46,    37,    51,    54,
      77,    60,    26,    61,    73,    62,    34,    71,    69,    70,
      31,    49,    68,    72,    17,    74,    53,    67,    64,    78,
      76,    84,    65,    44,    14,    58,    33,    15,    32,    25,
      80,    22,   720,    59,    63,    47,    66,    79,    45,    75,
     777,   768,   802,   776,    86,    87,    88,     7,  1278,  1280,
    1279,  1363,  1314,  1315,  1283,  1324,  1334,  1323,  1327,  1335,
    1322,  1341,     0,    90,    92,    93,    94,    97,    98,    91,
      85,    89,    96,   102,    95,   101,    99,   100,   103,   104,
     105,  1544,   966,  1542,  1543,  1541,     0,  1363,  1301,  1300,
    1363,  1310,  1334,     0,  1502,  1503,  1504,  1505,  1506,  1507,
    1549,  1550,  1551,  1552,  1553,  1555,  1554,  1564,  1565,  1566,
    1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,  1578,  1579,  1580,  1581,  1582,  1521,  1583,  1584,  1585,
    1586,  1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1599,  1558,  1600,  1601,  1602,  1603,  1604,
    1605,  1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1615,
    1614,  1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  1624,
    1625,  1559,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,
    1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1560,  1650,  1651,  1561,
    1652,  1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,
    1662,  1663,  1664,  1665,  1666,  1667,  1668,  1670,  1669,  1671,
    1672,  1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,
    1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,  1562,  1695,  1696,  1697,  1698,  1699,  1700,
    1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,
    1711,  1712,  1713,  1714,     0,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1563,  1737,  1867,
    1224,  1271,  1270,  1247,  1266,  1519,  1473,  1474,  1242,  1520,
    1517,  1556,  1557,  1518,  1225,  1863,  1516,  1412,     0,     0,
    1375,  1376,  1379,  1256,  1251,  1378,     0,  1252,  1373,  1374,
    1193,  1272,  1516,  1508,  1509,  1510,  1511,  1513,  1512,  1514,
    1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,
    1800,  1534,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
    1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,  1818,
    1819,  1820,  1821,  1822,  1823,  1824,  1825,  1826,  1535,  1536,
    1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,  1836,
    1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,  1846,
    1847,  1538,  1848,  1849,  1537,  1850,  1851,  1852,  1853,  1854,
       0,  1329,  1548,  1533,  1330,  1515,  1545,  1532,  1539,  1540,
    1547,  1546,  1392,  1192,  1394,  1337,  1347,  1343,  1351,  1346,
       0,     0,     0,     0,  1363,   669,   668,   657,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    13,     0,   678,   231,  1244,  1243,
    1188,   710,     0,  1184,  1185,   368,   660,   249,     0,     0,
       0,     0,     0,     0,   427,     0,     0,     0,     0,     0,
       0,   138,     0,   260,   259,     0,   360,     0,   536,     0,
       0,   368,     0,     0,     0,  1248,     0,  1669,  1390,  1391,
    1277,  1704,   760,     0,     0,     0,     0,   439,     0,   438,
       0,     0,   436,     0,   367,     0,   440,   434,   433,     0,
       0,   437,     0,   435,     0,     0,   661,  1626,  1381,   733,
     720,  1565,   465,   469,   460,   466,   474,   473,   461,   458,
     459,  1679,     0,     0,   464,     0,   455,  1213,  1215,   472,
    1214,     0,   501,   514,   508,   512,   506,   510,   509,   505,
     516,   515,   511,   507,   513,     0,   502,   503,     0,   654,
    1185,   680,  1197,   793,     0,     0,   457,   653,     0,     0,
     601,   602,     0,  1692,   665,   195,  1697,  1765,  1716,   191,
       0,     0,   662,   663,   799,   797,     0,     0,     0,     0,
    1591,  1645,  1653,  1697,  1765,  1716,   147,     0,   158,   190,
    1697,  1765,  1716,   186,   678,     0,     0,  1338,   656,   655,
       0,     0,   864,   721,   724,   777,     0,   670,     0,     6,
     719,   715,   796,   796,     0,   796,     0,   773,  1281,  1334,
    1313,  1369,  1285,     0,     0,  1359,  1355,  1352,  1360,  1361,
    1354,  1342,   955,   956,   957,   954,   958,   953,     0,  1289,
    1326,  1295,     0,  1303,  1302,  1308,  1369,  1312,  1870,  1871,
    1414,  1246,  1263,     0,     0,     0,     0,     0,     0,  1255,
    1261,     0,  1253,     0,     0,  1875,  1879,     0,  1877,  1872,
    1328,  1400,  1393,  1395,  1397,  1349,  1348,  1344,     0,     0,
    1464,     0,     0,  1465,  1466,     0,  1461,  1463,     0,  1369,
       0,     0,  1519,  1198,  1520,  1517,  1529,  1516,     0,   443,
       0,     0,     0,   443,     0,     0,     0,     0,  1585,  1089,
    1099,  1097,  1098,  1091,  1092,  1093,  1096,  1094,  1095,     0,
     592,  1090,     0,     0,   346,     0,     0,     0,     0,   115,
       0,     0,     0,   674,   677,   658,     0,     0,  1160,  1189,
       0,     0,     0,   486,   495,   487,   492,     0,   489,     0,
       0,     0,   488,   490,   491,     0,   493,   494,     0,     0,
     252,     0,     0,     0,     0,   682,   707,   264,   263,   129,
     262,   261,     0,     0,   549,     0,   140,   371,     0,     0,
     108,     0,     0,     0,     0,     0,     0,     0,     0,  1415,
    1276,  1372,     0,   870,     0,   406,     0,   699,     0,   134,
       0,     0,     0,   372,     0,   113,   125,     0,   228,   441,
    1389,  1388,  1380,  1387,     0,   462,   471,   470,   468,   467,
     463,  1216,     0,   453,   454,  1400,  1403,   451,     0,   500,
       0,     0,     0,   747,  1186,     0,     0,   604,   604,   664,
     194,   192,     0,     0,     0,     0,     0,     0,  1738,  1739,
     914,  1153,     0,  1521,  1740,  1741,  1742,  1061,  1165,  1165,
    1165,  1743,  1744,  1608,  1745,  1746,  1205,  1747,   904,  1749,
    1750,  1751,  1752,     0,  1206,  1754,  1755,  1664,  1757,  1758,
    1760,  1761,  1165,  1763,  1764,  1765,  1766,  1767,  1768,  1204,
       0,  1165,  1769,  1100,  1210,  1211,  1162,     0,     0,  1170,
       0,     0,     0,  1051,     0,   898,   900,   901,   925,   926,
     902,   931,   932,   944,   899,     0,  1169,   967,  1050,  1055,
       0,  1049,  1045,   784,  1167,  1154,     0,  1046,  1238,  1237,
    1239,  1240,  1236,  1200,  1519,  1525,   903,  1520,  1517,  1207,
    1241,  1863,  1516,     0,     0,     0,     0,  1454,     0,   197,
       0,   198,  1190,  1697,   148,   182,   155,   181,     0,  1583,
     149,     0,   153,     0,     0,     0,   189,   187,     0,   659,
     447,     0,     0,   866,     0,   865,   723,   720,   771,   770,
       5,   726,   795,     0,     0,     0,     0,     0,     0,     0,
     827,   816,  1369,  1370,     0,  1364,     0,  1363,  1363,  1357,
    1356,  1353,     0,     0,     0,     0,     0,     0,  1230,  1229,
    1286,  1288,  1233,     0,  1369,     0,     0,  1265,     0,  1269,
    1267,  1400,  1409,  1400,  1410,  1411,  1259,  1254,  1257,     0,
    1249,  1261,  1873,     0,     0,  1876,  1331,     0,  1401,  1234,
    1235,  1406,     0,  1396,  1404,  1407,  1350,  1363,  1472,     0,
    1467,  1470,     0,  1462,     0,  1199,     0,     0,     0,     0,
     444,     0,     0,     0,   698,     0,     0,     0,   701,     0,
     560,     0,     0,     0,     0,     0,     0,     0,   203,   220,
       0,     0,     0,     0,     0,     0,   344,   620,   620,     0,
       0,   620,   620,     0,   202,   204,     0,     0,     0,     0,
       0,     0,   115,   109,   112,  1296,     0,   672,   673,     0,
     676,     0,  1157,  1156,  1195,  1161,   709,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     407,     0,   907,   942,   942,   942,   922,   922,   916,   905,
     949,     0,   942,   919,   908,     0,   906,   952,   952,   937,
       0,   880,   890,   892,   893,   923,   924,   894,   929,   930,
     891,   966,  1524,   903,  1526,  1523,  1522,     0,     0,   706,
       0,   129,   126,   428,   408,     0,   136,     0,     0,   376,
     375,     0,     0,   409,   107,   115,   346,   339,     0,     0,
       0,  1196,     0,     0,   301,   761,   765,   762,     0,   763,
       0,   744,     0,     0,   228,     0,     0,     0,     0,     0,
     228,   226,   227,     0,   432,  1382,  1385,  1386,     0,   727,
     729,   731,   730,   732,   728,   452,   449,   450,     0,  1402,
    1855,  1861,     0,  1416,  1417,     0,  1599,  1622,  1639,  1693,
       0,  1711,     0,   517,   504,     0,     0,     0,   735,   738,
       0,     0,   757,   456,  1408,   603,   600,   599,   193,   530,
       0,  1692,   667,     0,     0,  1053,  1054,   941,   928,  1152,
       0,     0,   936,   935,     0,     0,     0,  1062,     0,  1064,
       0,  1066,     0,   912,   911,   910,  1052,  1113,     0,   909,
     942,   942,   940,   990,     0,     0,   913,     0,     0,  1132,
       0,  1067,  1138,     0,     0,     0,   948,     0,   946,     0,
       0,  1022,  1068,  1047,   970,   971,   972,   973,  1051,  1110,
       0,  1201,     0,     0,   934,     0,   966,     0,     0,     0,
       0,     0,  1108,     0,     0,  1003,  1106,     0,  1005,     0,
       0,     0,  1100,  1099,  1097,  1098,  1091,  1092,  1093,  1096,
     974,   975,  1104,   987,     0,   986,  1400,     0,   831,   783,
    1155,     0,     0,  1862,  1864,  1451,  1450,  1449,  1448,  1452,
    1453,  1424,     0,  1420,  1421,     0,   199,   200,   196,     0,
       0,   157,   156,   185,   184,     0,   179,   180,   152,     0,
     175,   176,   161,   172,   174,   173,   171,   150,   160,   162,
     168,   169,   170,   159,   151,   188,  1363,     0,     0,   831,
    1173,  1162,   712,     0,   716,   777,   781,   776,   780,   803,
     804,   809,   779,     0,   829,   818,   812,   817,   813,   819,
     826,   775,   815,   774,     0,  1371,  1284,  1369,   880,  1363,
    1304,  1363,  1358,  1292,   960,   961,   962,   963,   965,   964,
    1293,  1290,   959,  1291,  1232,  1231,     0,     0,     0,     0,
    1311,  1262,     0,  1245,  1268,     0,  1260,     0,  1874,  1880,
    1878,     0,     0,   880,  1858,  1468,  1858,   880,   586,     0,
     585,     0,     0,   445,     0,     0,     0,   697,     0,     0,
       0,     0,     0,   704,   295,     0,   225,     0,     0,     0,
       0,   557,   559,   558,   552,     0,   553,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   588,   593,     0,     0,     0,   348,   358,     0,     0,
       0,   108,   108,   345,   619,   214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   111,   110,   118,   120,     0,   119,   121,     0,     0,
       0,   114,     0,     0,   167,   671,   675,  1158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     251,   234,   233,     0,     0,   413,   416,     0,   880,     0,
       0,     0,   874,   955,   954,   953,     0,   895,   897,     0,
     696,   696,   696,   696,   696,   681,   683,   275,   127,     0,
       0,   128,     0,   140,   265,   139,   141,   143,   144,   145,
     142,   146,   370,     0,   381,   380,   382,     0,   377,     0,
     410,   106,   343,     0,   267,     0,     0,     0,     0,     0,
     631,     0,     0,     0,     0,     0,   764,   869,     0,     0,
     583,     0,     0,   228,   228,   124,   366,   442,  1383,  1384,
     760,   448,     0,     0,  1860,  1217,     0,  1218,     0,     0,
     520,   519,   532,     0,   521,   522,   518,   523,     0,   737,
       0,     0,   742,  1162,     0,   754,     0,   752,     0,  1187,
     756,   745,     0,   666,  1110,     0,     0,     0,  1116,     0,
       0,  1151,  1148,     0,     0,  1110,     0,  1164,     0,     0,
       0,  1123,  1124,  1125,  1122,  1126,  1121,     0,     0,  1127,
    1120,     0,   939,   938,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1023,     0,     0,  1084,     0,  1110,  1137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1110,  1143,     0,  1163,  1162,     0,     0,     0,     0,  1202,
     968,   988,  1168,     0,     0,   995,     0,  1144,  1018,     0,
    1009,     0,  1004,     0,  1007,  1011,   991,     0,  1109,     0,
    1107,     0,     0,   989,     0,   984,   982,   983,   976,   977,
     978,   979,   980,   981,   985,  1088,  1086,  1087,     0,  1623,
    1645,     0,   794,   794,   782,   792,  1166,     0,   870,     0,
       0,     0,  1056,     0,  1866,  1865,     0,     0,     0,  1191,
       0,     0,   966,     0,   880,   867,     0,  1162,     0,   870,
       0,   714,   713,     0,     0,   807,   808,     0,   825,     0,
     824,     0,     0,     0,  1282,  1365,  1367,  1333,  1305,  1336,
    1287,  1325,     0,  1309,  1264,  1258,     0,  1398,  1405,  1458,
       0,  1859,     0,     0,     0,   622,   606,   446,   623,   607,
       0,     0,     0,     0,     0,   228,   702,   224,   703,   624,
     551,   560,     0,   556,   565,  1530,   903,   563,  1531,  1528,
    1527,     0,     0,   132,   133,   609,   222,   614,   223,   221,
     610,     0,  1194,     0,     0,     0,   628,   612,   347,   357,
       0,   351,   352,   349,   353,   354,     0,     0,   206,     0,
       0,   218,   217,   228,   228,   613,     0,   219,   216,   205,
     630,   618,     0,   629,   617,     0,   116,   117,     0,   165,
     164,   166,     0,     0,     0,     0,     0,     0,     0,   497,
     481,   496,     0,     0,     0,   475,   236,   237,   254,   235,
     412,     0,     0,     0,     0,   875,     0,     0,   880,     0,
       0,   888,   881,   889,     0,     0,     0,     0,   695,     0,
       0,     0,     0,     0,   684,   700,   131,   130,     0,   135,
       0,     0,   369,     0,     0,     0,   871,     0,     0,     0,
       0,   266,   268,   270,   271,   272,     0,   341,   342,   337,
       0,     0,   333,     0,     0,   539,     0,     0,     0,   303,
     304,     0,   766,   767,     0,   228,     0,   228,   228,   652,
     404,     0,  1399,  1856,  1425,  1426,     0,  1418,  1419,     0,
     534,     0,   529,   524,   526,  1183,  1182,     0,  1181,     0,
       0,   743,   755,   748,   750,   749,     0,     0,   746,     0,
     798,     0,  1118,  1119,     0,     0,     0,     0,  1147,     0,
       0,  1082,     0,  1080,  1063,  1065,   921,     0,  1070,     0,
     915,     0,   918,     0,  1101,     0,     0,  1071,  1025,  1026,
    1027,     0,     0,     0,     0,  1100,     0,     0,     0,     0,
       0,     0,     0,  1028,  1029,  1041,  1040,  1072,  1083,     0,
       0,  1135,  1136,  1073,   950,   951,   952,   952,     0,     0,
    1142,     0,     0,     0,  1078,  1048,  1111,   943,   944,     0,
       0,     0,     0,     0,     0,  1010,  1006,     0,  1008,  1012,
       0,     0,     0,   997,  1019,   993,     0,     0,   999,     0,
    1020,   794,   794,   794,   794,   791,     0,     0,     0,   841,
     830,   833,   843,   834,   836,   868,  1188,   821,     0,     0,
    1060,  1057,  1433,  1434,  1435,  1436,  1437,  1438,  1439,  1440,
    1441,  1442,  1444,  1445,  1446,  1443,  1447,  1429,  1430,     0,
    1422,  1423,   154,     0,   177,   163,  1458,     0,  1174,  1171,
     758,     0,   725,   805,     0,  1102,   806,   828,   810,   814,
     811,     0,  1366,  1297,  1274,  1457,  1460,  1471,  1469,  1307,
       0,     0,     0,   294,     0,     0,     0,   705,   554,   555,
     897,   625,   608,     0,     0,   590,     0,   591,   589,   350,
     356,   355,   275,     0,     0,     0,   207,   215,   212,     0,
       0,   122,   123,  1159,     0,     0,   477,   483,     0,     0,
       0,     0,   485,   255,   108,     0,   414,  1664,  1092,   415,
     417,   564,   418,   419,     0,     0,     0,     0,   878,     0,
       0,     0,     0,     0,     0,   880,   966,     0,   692,  1226,
    1227,   691,  1228,   688,   687,   694,   693,   686,   685,   690,
     689,     0,     0,     0,   286,     0,     0,   280,     0,     0,
     332,   274,   277,   278,     0,     0,   384,   378,   411,     0,
     873,   267,   293,   321,     0,   338,     0,     0,     0,     0,
     365,   362,     0,     0,     0,     0,     0,   300,     0,   679,
     759,  1275,   584,   228,   431,   587,   765,     0,     0,   533,
     527,     0,     0,   498,   736,     0,     0,   740,   741,   753,
     751,   228,  1111,  1117,   927,     0,  1150,  1146,     0,     0,
       0,  1112,     0,     0,  1130,  1129,  1024,  1131,     0,     0,
       0,  1039,  1038,  1036,  1037,  1030,  1031,  1032,  1033,  1034,
    1035,  1140,  1139,  1133,  1134,   947,   945,     0,  1075,  1076,
    1077,  1141,  1085,   933,   966,   969,  1016,   996,  1145,  1013,
       0,  1115,     0,   992,     0,     0,     0,  1001,  1101,     0,
       0,     0,     0,     0,     0,   786,   785,   841,     0,   843,
       0,   842,   855,     0,     0,   861,   859,     0,   861,     0,
     861,     0,     0,   835,     0,   837,   855,  1189,     0,   823,
    1058,  1059,     0,     0,     0,  1456,     0,     0,  1179,  1178,
       0,  1368,     0,  1250,     0,     0,   296,     0,     0,   332,
       0,     0,     0,     0,   273,     0,     0,     0,     0,   230,
     615,   616,     0,     0,     0,     0,   480,   479,   239,     0,
     401,     0,     0,   405,   396,   398,     0,     0,     0,   876,
     882,   883,   884,   885,   886,   887,   879,   896,   394,     0,
       0,   284,   288,   289,   287,   279,   332,   301,     0,   281,
       0,     0,   386,     0,     0,   872,     0,     0,     0,   290,
       0,   324,   269,   340,   342,   335,   336,   334,     0,   359,
     363,     0,   538,     0,     0,     0,     0,   571,     0,     0,
       0,   572,   576,   573,   582,   567,   647,   648,   645,   646,
       0,   302,   598,     0,  1427,  1428,     0,   525,  1180,     0,
     499,  1149,  1069,  1079,   920,  1081,   917,  1128,     0,     0,
       0,  1074,  1203,     0,  1014,     0,  1017,   998,   994,     0,
    1000,  1021,   790,   789,   788,   787,   845,   853,     0,   832,
       0,   860,   856,     0,   857,     0,     0,   858,   847,     0,
       0,   853,     0,     0,     0,   778,  1431,     0,  1219,  1223,
    1220,  1432,   966,     0,  1175,     0,  1273,   621,   605,     0,
     332,   297,   566,   627,   611,   626,   208,   209,   210,   211,
       0,   213,   476,     0,   482,   478,   232,   253,   403,   402,
     400,   397,   399,   877,     0,   597,     0,     0,     0,     0,
     276,   282,   307,     0,     0,   267,   385,     0,     0,   379,
     324,   292,   291,     0,     0,     0,   328,   364,     0,     0,
       0,   540,   547,   547,   569,   561,     0,     0,   570,     0,
     579,   580,     0,   568,   548,     0,     0,   528,     0,  1042,
       0,     0,  1015,  1114,  1002,   844,     0,     0,   846,     0,
       0,   849,   851,     0,     0,     0,     0,     0,  1192,   820,
     822,  1222,  1221,   178,  1176,     0,  1103,     0,   298,   229,
     484,   240,   244,   707,   707,     0,   707,   241,   707,   238,
     597,     0,   595,   395,     0,   283,     0,   312,     0,     0,
     387,   388,   383,     0,   328,     0,   322,   323,     0,   330,
     708,     0,   330,     0,     0,   545,   543,   542,     0,     0,
     577,   578,     0,   581,   870,   739,     0,  1043,     0,   854,
     863,     0,   850,   848,   838,     0,   840,     0,  1172,   301,
       0,     0,     0,     0,     0,     0,   594,   596,     0,   305,
     306,     0,   285,   308,   309,   331,     0,     0,   330,   320,
       0,     0,   257,   547,   870,   541,   546,   562,   574,     0,
       0,  1044,   852,     0,   839,  1177,   307,   242,   246,     0,
     247,   243,   245,     0,     0,     0,     0,   310,     0,   311,
       0,     0,     0,   420,   421,   391,   258,     0,   325,     0,
     329,   544,   535,   575,   651,   862,   312,   248,     0,   317,
       0,   316,     0,   313,   314,     0,     0,   426,     0,     0,
     389,   392,   393,   326,   327,   650,   649,     0,     0,     0,
     315,   318,   319,     0,   430,   422,   373,     0,   633,   644,
     632,   634,   642,   639,   641,   640,   638,   299,     0,   425,
     429,     0,   423,   390,     0,   643,   637,   777,   768,     0,
       0,   635,   644,   391,   430,   636,     0,   424,   374
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   226,   227,   228,  1455,   229,   230,
     231,  1373,  1831,  1075,   232,  1442,  1881,   233,   234,   235,
    1045,  1446,  1885,   236,   856,   857,  1667,  1668,  1835,  1669,
    1670,  1658,  1226,  1652,   237,   238,   239,  1220,  1648,   240,
     241,  1364,  1365,  1348,  1349,  1338,  1484,  2911,   242,   243,
    1853,  2228,  2916,  3009,   718,  1398,  2534,  2535,   244,   740,
    2270,  2271,  2272,  2273,  2255,  2581,  2582,  2583,  2274,  2799,
    2275,  1764,  1912,  2288,  2289,  3017,  3072,  3073,  3074,  3133,
    2801,  2946,  3029,  3082,  2789,   245,  2599,  2282,  1905,  2276,
    2277,   246,   247,  1356,  1803,  2180,   248,   741,  2600,  2809,
     249,   774,   250,  1448,   251,   252,  1451,  1897,  1898,  2793,
    2937,  3022,  3139,  3140,  2927,  2763,  2764,  2765,   253,   254,
     255,   256,  1900,  1400,  1854,  1855,  2539,   257,  3113,  3114,
     742,  3172,   258,   259,   775,  1078,  3035,  1330,   260,   261,
     793,   794,   795,   262,  1029,  2220,   263,   264,   815,   816,
     817,  1512,  2312,  2313,  2623,   841,  1941,  1942,   265,   743,
    2604,  2950,  2951,  3036,   266,   744,  1341,  1775,  1776,  1777,
    2954,  2152,  2540,  2541,  2824,  2825,  2964,   267,   268,  1749,
     269,  1790,   989,   270,  3012,   271,   272,   832,  1526,   273,
    1806,   274,   275,  2287,  3160,  3174,  3175,  3176,  2830,  3147,
     276,  3162,   278,   279,   280,   706,  1003,  1004,  1005,   281,
     282,   283,  1875,  1876,  2249,   284,   285,   286,   287,  1440,
     288,   289,   290,   291,   292,   881,   874,  1247,  1684,   293,
    1489,   780,  3163,  1518,  1951,  1952,  3164,   296,  1522,  1958,
    1961,  3165,   298,  1062,  1915,  3166,  1173,   301,   302,   303,
    1628,  2074,   824,  1253,   846,   886,   887,  1689,  1690,  1260,
    1703,  1696,  1698,  2719,  2885,  1261,  1701,  2110,  2078,  2430,
    2431,  2432,  2701,  2712,  2872,  2981,  2433,  2434,  1471,  2265,
    2266,  1791,  1862,  2240,  1421,  1174,  1175,  1176,  1559,  1566,
    1553,  1424,  1177,  1178,  1179,  1427,  1180,  1181,  1182,  1183,
    1538,  1594,  1184,  1185,  1576,   909,  1964,  2002,  1187,  1188,
    1189,  2068,  1622,   991,  1190,  2476,  1624,  2021,  1987,  2682,
    1967,  1536,  1988,  1998,  2356,  2005,  2010,  2381,  2382,  2022,
    2038,  1191,  1971,  1972,  2339,  1540,  1192,  2023,  1009,  1583,
    1547,  1193,  1194,  1679,  2096,  2995,  1680,  2317,  2318,  1195,
    1513,   872,  2977,  1222,   573,  2171,  1383,   712,   821,  1196,
    1197,  1198,  1199,  1200,  1201,  1202,  2242,   799,  1936,  2891,
    2221,  2561,  1310,  1671,  1203,   552,   713,   304,   575,   576,
     929,   930,  1297,  1300,  1287,  1733,   553,   554,   577,  2733,
     305,   306,   307,   308,   309,  1262,   891,  1281,  1727,   910,
      72,    77,    73,   911,   346,   347,  1709,   310,   684,  1710,
    1284,   916,   350,   312,   313,   351,   315,   661,   352,   893,
     317,   894,   318,   319,   320,   321,   901,   322,  1264,  1265,
    2482,  1266,   323,   324,   578,   579,   325,  1083,  1485,  1082,
     750,   326,   327,   942,   943,   944,  1096,  1498,  1097,  1313,
    1314,   328,   329,   569,   330,   331,   332,  1503,  1504,   333,
    1643,  1644,  1645,   334,  2304,  2305,   335,  2457,  2458,  2459,
     336,  1637,   337,   338,   866,  2486,   339,   680,   340,   956,
     555,   556,   557,  1205,   664,   820,  1206,   963,   665,   342,
     667,   559,   560,   561,   562,   563,   966,   671,  1499,    74,
    2130,  1500,  1209,  1210,  1633,  1211,   566,   920,   935,   936,
    2131,   938,    75,   939
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2745
static const int yypact[] =
{
   -2745,   226,  3233, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, 14030, -2745, -2745, 49541,   536, -2745,
   -2745, -2745, 35173, -2745, -2745, -2745, -2745, -2745,   239, 34395,
   12880, -2745, 47213, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, 47213, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, 33618,   840, -2745, -2745,   243, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745,   705,  3049, -2745, -2745, 36729, -2745,
     149, -2745, -2745, -2745, -2745, -2745, -2745, 47213, 42169, -2745,
     311,   705, -2745,   196,  8528, -2745, 36729, 37118, -2745, -2745,
   47601,   528,  3938,   705, 37507, -2745,  1245, -2745, 31275, -2745,
   -2745, -2745,   600,  2106, -2745, -2745, -2745,   563, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, 42169,   895,   491, 31664, -2745,
   -2745, -2745, -2745, 42169, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, 37896, -2745,   159, 47989, 42945,   654, -2745,
     705, -2745, 47213,   137, 33229, -2745, 43333, -2745, -2745,   520,
   -2745, -2745, -2745, -2745, -2745,   491, -2745, 33618, 30093, 41393,
     733, -2745, -2745, -2745, -2745,   296, 14359,   567, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745,   568, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
      62, -2745,   482,   175, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, 50681,   979, -2745, -2745, -2745,   580, -2745,   537, -2745,
   -2745, -2745,   809, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745,   641, -2745, -2745, -2745,   925, 49921, -2745, -2745,
   50681, -2745,   593, 37896, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, 35562, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745,    88, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, 47213, 47213,
   -2745, -2745, -2745,   668, -2745, -2745,   728, -2745, -2745, -2745,
   -2745, -2745,   749, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   12047, -2745, -2745, -2745,   743, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745,   837, -2745,   148,   971, -2745, -2745,
   33618,  1370,  1370,  1205, 50681, -2745, -2745, -2745, 40229, 47213,
   47213, 47213, 40229, 47213, 41393, 47213, 28502, 47213, 42169, 41393,
   47213, 47213, 47213, 47213, -2745,  1237,   557, -2745, -2745, -2745,
     942, -2745,  1016, -2745,  1027,  1792, -2745, -2745, 42169, 40229,
   47213,   894,   986, 47213, -2745, 47213,   907, 47213,  1071,   858,
    1087, 47213, 47213, -2745, -2745, 47213, -2745, 47213, -2745, 47213,
     397,  1060,  1234,  1282,   443, -2745, 37896, 37896, -2745, -2745,
   -2745,   712, -2745, 41393, 40229, 47213,  1053, -2745, 47213, -2745,
   40229, 47213, -2745,  1522, -2745, 47213, -2745, -2745, -2745, 47213,
   47213, -2745, 47213, -2745,  1281, 47213, -2745,   735, -2745, -2745,
     568,  1012, -2745,   125,   -30,   207, -2745, -2745,     2,    25,
      61,  1012,   931, 42557, -2745, 47213,  1276, -2745, -2745, -2745,
   -2745, 37896,  1213, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745,  1301,  1127, -2745, 42169, -2745,
   -2745, -2745, -2745, -2745, 42169,  1033, -2745, -2745,  1391, 47213,
   -2745, -2745, 42169, 47213, -2745, -2745,  1494,  1223,  1401, -2745,
    1386,  2106,  1313, -2745, -2745,  1400, 16826,   351, 32053, 37896,
   43721, 48377,   184, 44109,  1287,   557, -2745,   -89, -2745, -2745,
    1596,  1316,  1524, -2745,   557, 42169, 51054, -2745, -2745, -2745,
   26131,  1412,  1394, -2745,  1567,  1413,  1417,   705,  1398, -2745,
   -2745, 42169,  1733,  1733,  1737,  1733,   653,   711, -2745, -2745,
   -2745,  1439, -2745,  1429,  1431, -2745,   166,  1634, -2745, -2745,
   -2745, -2745,  1501,  1502,  1505,  1506, -2745,  1509,  1021, -2745,
   -2745, -2745,  1694, -2745, -2745, -2745,  1439, -2745, -2745, -2745,
   -2745, -2745,  1772,  1758, 36729, 36729,  1495,   -38, 32838, -2745,
    1445,   668, -2745, 15926, 12047, -2745, 23737,  1165, -2745, -2745,
   -2745,   100, -2745, -2745, -2745,  1654, -2745, -2745,  1650, 47213,
   -2745,  1521, 47213, -2745, -2745, 48765, -2745, -2745,  1370,  1439,
     942,  1458,  1459, -2745,  1460,  1463, -2745,  1465,   -15,  1464,
     789,   132,  1602,   -88,  1469,   462,   899,  1584, 47213, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,  1473,
   -2745, -2745,  1474,   921, -2745,  1024,   923,  1619,  1611,   -60,
    1475,  1662,   323, -2745,   317, -2745, 19703, 29315, -2745,   942,
   42169, 40229,  1481, -2745, -2745, -2745, -2745, 40229, -2745,  1632,
    1790, 47213, -2745, -2745, -2745, 47213, -2745, -2745,  1671, 47213,
    1516,  1485,  1783, 39064, 47213,  1519,  1813, -2745, -2745,  1528,
   -2745, -2745, 47213,  1485, -2745,  1809,  1815,  1637,   201,    48,
    1532, 42169, 42169,  1693, 47213, 47213, 40229, 47213, 42169, -2745,
   -2745, -2745,   460,  1539,  1512, -2745, 39064, -2745,  1469, -2745,
   47213,  1525,  1665, -2745,  1668,  1520, -2745,   895,    14, -2745,
   -2745, -2745, -2745,   -33,    18, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, 47213,  1276,  1276,    78, -2745, -2745,    71, -2745,
   41781,  2792,    22,   -54, -2745, 47213,   735,  1759,  1759, -2745,
   -2745, -2745,  1712,  1762,  1676, 49153,  1533,  1063,  1135,  1018,
   -2745, 19703,  1534,    37,    37,  1535,  1537, -2745,  1538,  1541,
    1542,  -101,  -101,  1675,  1551,  1553, -2745,   702, -2745,  1139,
     799,  1311,    37, 19703, -2745,  1554,   905,  1556,  1559,  1560,
    1145,  1561,  1542,  1224,  1562,   928,  1006,  1564,  1565, -2745,
    1551,  1542,   314, -2745, -2745, -2745, -2745, 19703, 19703, -2745,
   19703, 19703, 17237, -2745,   895, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745,    23, -2745,  1048,  6624, -2745, -2745, -2745,
   19703, -2745, -2745,   -49, -2745,   942,  1566, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745,  1130, -2745, -2745,  1134,  1174, -2745,
   -2745,    90,  1183,  1100,  1100, 35951, 35951, -2745,   915, -2745,
      89,  1568, -2745,  1039, -2745, -2745, -2745, -2745, 36340,  1897,
   -2745,   901,   317, 30481, 47213, 30481, -2745, -2745,  1760, -2745,
   -2745,  1770, 42169, -2745, 27310, -2745, -2745,   568, -2745, -2745,
   -2745,  1578, -2745,   296,   296, 19703,   296,   -26, 17648, 19703,
    1811,   542,  1439,  1587,   952, -2745, 39841, 50301, 50301,  1781,
   -2745, -2745,   488,   326,  1681,  1756,   672,  1035, -2745, -2745,
   -2745,  1581, -2745,  1853,  1439,   987, 36729,  1633, 36729, -2745,
   -2745,  1963, -2745,  1963, -2745, -2745, -2745, -2745,  1590,   931,
   -2745,  1445, -2745, 16003,  1298, -2745, -2745, 12047, -2745, -2745,
   -2745, -2745,  1990, -2745,  1588, -2745, -2745, 50681,  1595, 47213,
   -2745,  1597,  1598, -2745, 51054,   942, 29705,  1666,  1667, 33618,
    1599,  1670,  1672, 48377, -2745,   177,   627,   117, -2745,  1673,
     -31,   937,  1648,  1655,  1674,  1677,  1678,  1686,  1610, -2745,
    1682,  1660, 38286, 28908,  1683,  1687,  1260,   753,  1912,  1768,
    1688,  1337,    35,  1659,  1623, -2745,  1695,  1696, 41393,  1697,
    1698, 48377, -2745,  1545, -2745, -2745,   800, -2745, -2745,   557,
   -2745,   421, -2745, -2745, -2745, -2745, -2745,  1635, 39064,  1469,
    1021, 47213,  1639,   689,  1791, 47213,  1840,  1794,    -4, 33618,
   -2745,  1651, -2745,  1690,  1690,  1690,  1653,  1653,  1657, -2745,
   -2745,  1311,  1690,  1658, -2745, 39453, -2745,   651,   715, -2745,
    1971,    32, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745,   670, -2745,  1464, -2745, -2745, -2745,  1986,   859, -2745,
   39064, -2745,   -63,  1919, -2745, 47213,   699, 47213,  1847, -2745,
   -2745,    10,  1679, -2745, -2745, -2745, -2745,   -66, 36729,  1904,
    1817, -2745,  1469,  1997,  1680, -2745,  1402, -2745,  1775, -2745,
   19703, -2745, 29705,  2000,   102,  1724, 38286, 42169, 42169, 47213,
     102, -2745, -2745, 47213, -2745, -2745,  1276,   837, 47213, -2745,
   -2745, -2745, -2745, -2745, -2745,  1276, -2745, -2745,  2079,  1691,
   -2745,    90,   931,  1704, -2745,  1700, 47213, 40229, 47213, 47213,
   42169, 47213,  1747,  1705, -2745,  1725,  1684, 26917, -2745, -2745,
      91, 42169,  1842, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   41781, 47213, -2745, 19703, 18059, -2745, -2745, -2745,  1689,  9299,
    1726, 19703, -2745, -2745, 19703, 19703,   745, -2745,   745, -2745,
    1702, -2745,   931, -2745, -2745, -2745, -2745,   970,   931, -2745,
    1690,  1690, -2745,  2213, 19703,   931, -2745, 28908, 19703, 20114,
   15140, -2745, 19703,  1765,  1778,   931, -2745,   931, -2745, 19703,
   16415, -2745, -2745,   942,  2032,  2032,    53,   940,     7,  2812,
    1707, -2745,  1786,   931, -2745,   931,  1105, 39064, 19703, 33618,
    1787, 20114, 19703,  1717,   538, -2745, 19703,   408, -2745,  1722,
   19703,  1788,    73, 19703, 19703, 19703, 19703, 19703, 19703, 19703,
   21744, 22155, -2745, 20525,    76,   179, 34784, 16826,  1950, -2745,
    1392, 14728, 37896, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745,   931,  1720, -2745,  1740, -2745, -2745, -2745, 47213,
    1897, -2745, -2745, -2745, -2745,  1789, -2745, -2745, -2745,  1187,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,  1723, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, 50681,  1738, 47213,   -62,
   -2745, -2745, 41005, 47213, -2745, -2745,  1938, -2745, -2745,  1735,
   -2745,  6429,  1938,  1888,  1895, -2745,    52,  9299,  1928,  9299,
   -2745, -2745, -2745, -2745,  1285, -2745, -2745,  1439,  1753, 13270,
   -2745, 13650, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745,  1021,  1751,  2129,  1380,
   -2745, -2745, 36729, -2745, -2745, 32838, -2745,  1761, -2745, -2745,
   -2745, 37896,   922,  1753, 12047, -2745, 12047,  1753, -2745,  1763,
   -2745, 47213, 47213, -2745, 33618, 47213, 47213, -2745,  1754, 47213,
    1947,  1951,  1766, -2745, -2745, 47213, -2745,  1913, 19703,  1915,
   47213, -2745, -2745, -2745, -2745,   932, -2745, 34007,  1829,  1832,
   47213, 47213, 47213, 47213, 47213, 47213,   -14, 47213, 47213,  1767,
    1771,  1769, -2745, 47213, 47213,  1021, -2745,  2078,  1021,  1021,
     553,  1532,  1532, -2745, -2745, -2745, 47213, 47213, 47213,  1846,
   47213, 47213, 47213, 47213,    47,   190, 47213, 47213,  1901, 47213,
   47213, -2745,  1545, -2745, -2745,  2013, -2745, -2745,  1818,   931,
    1843, -2745,    20,  1920, -2745, -2745, -2745, -2745, 19703, 29705,
    2117,  1993,  1996,  1849, 38286,   357, 47213, 47213,  1998,   357,
   -2745, -2745, -2745,   657,  1014, -2745,  1822, 19703,    54, 39064,
    1814, 25326, -2745,  1875, -2745,  1877,   931, -2745,  1599,    10,
    1827,  1827,  1827,  1827,  1827,   859, -2745, -2745,   -63,   931,
   47213, -2745,  2048, -2745,   808, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745,  1818, -2745, -2745, -2745,  1965,  1966, 47213,
   -2745,  1545,  1260, 42169, 40617,    87,  2043,   895, 42169,  1936,
   -2745, 47213,  2153,  2059,  2061,  2076, -2745,  9299,  1844, 39064,
   -2745, 47213,  1848,   102,   102, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, 37896,   749, -2745, -2745,   749, -2745,   749,  2254,
    1568,  1850, -2745,  1469,  1568,  1568,  1705,  1568, 44497, -2745,
   18470,  1040, -2745, -2745,    19, -2745,    29,   334,  2025, -2745,
   -2745, -2745,  2082, -2745,  9299,  1058,   307,   775, -2745,   931,
   19703,    -1, -2745,  6843,  1061,  7401,  1073, -2745,  1857,  1859,
    1075, -2745, -2745, -2745, -2745, -2745, -2745,  1860,  2089, -2745,
   -2745,  1862, -2745, -2745,  1713,  1081,  1863,  7860,  1868, 20114,
   20114, 20114,  1151, -2745, 20114,  1869, -2745,  1095,  6192,  1866,
    1872,  1903,  1905,  1873,  1876,  8106, 18881, 19703, 18881, 18881,
    8372,  1866,  1878, -2745, -2745, 19703, 47213,  1879,  1880, -2745,
   -2745,  2213, -2745,  1909,   363,  3513, 17237, -2745, -2745,  2111,
   -2745,   754, -2745,  1885, -2745, -2745,  3559, 20114, 19703,  1717,
   19703,  1953, 28908,  3962, 19703,  2184,  2746,  2746,   142,   142,
      53,    53,    53,   940,   179, -2745, -2745, -2745,  1887,  1108,
    1175, 42169,  4463,  6954, -2745, -2745, -2745, 24540,  1539, 19703,
   19703,  1889, -2745,  1121, -2745, -2745,   222,  2254,   931, -2745,
     557,   931,  1105, 30878,  1753, -2745,  1891, -2745, 47213,  1539,
     949, -2745, -2745,  1131, 19703, -2745, -2745,  1961, -2745, 47213,
   -2745, 19703, 19703, 17648, -2745, -2745,  1906, -2745, -2745, -2745,
   -2745, -2745,  1893, -2745, -2745, -2745, 47213, -2745, -2745,  2277,
    1900,  1892,  1902,  1899,   941, -2745, -2745, -2745, -2745, -2745,
   19703,   438,  1907,  1908, 47213,   102, -2745,  9299, -2745, -2745,
   -2745,   794, 39064, -2745, -2745,    96,  1464, -2745,   235,   253,
     272, 47213, 47213,  1520,  1520, -2745, -2745, -2745, -2745, -2745,
   -2745,  1004, -2745, 39064,  2039, 38675, -2745, -2745, -2745, -2745,
    1021, -2745, -2745, -2745, -2745, -2745,  1021,  1021, -2745, 39064,
      28, -2745, -2745,   102,   102, -2745,  1973, -2745, -2745, -2745,
   -2745, -2745,  1975, -2745, -2745, 47213, -2745, -2745,  1818, -2745,
   -2745, -2745,  5320,  1911, 39064,   357,   357, 47213,  1914, -2745,
   -2745, -2745,  2107,  2108,   357, -2745, -2745, -2745,     4, -2745,
   -2745, 33618, 28096,  3464,  1918, -2745,  1917,   931,  1753, 25736,
    1343, -2745, -2745, -2745,   721,  2090,  1921,  2063, -2745,   131,
     206, 44885, 45273, 45661, -2745,  1278, -2745,  1520,  1979,   699,
     678,  1957, -2745, 42169,    10,  1148, -2745, 39064,  1926, 42169,
    1927,  1923, -2745, -2745, -2745, -2745,  1166, -2745, 39064, -2745,
    2073,  2080, -2745, 47213,  1999,  1980, 39064,  2083,  1191, -2745,
   -2745,   296, -2745, -2745, 26524,   102,  1931,   102,   102, -2745,
   -2745,   708, -2745, -2745,  1934, -2745,  1958, -2745, -2745, 40229,
   -2745, 47213,   484, -2745, -2745, -2745,  9299,  1193, -2745,   384,
   47213,   942, -2745, -2745, -2745, -2745,  2187,  2189, -2745, 44497,
   -2745, 19703, -2745, -2745,  1949,  1960,  9778, 19703, -2745,  2205,
   39064, -2745, 47213, -2745, -2745, -2745, -2745,   931, -2745, 19703,
   -2745, 19703, -2745,   931, -2745, 19703,  2190, -2745,  2303,    57,
    2303, 39064, 20114,   783,  1556, 21333, 20114, 20114, 20114, 20114,
   20114, 20114, 20114, 22552, 22963, -2745,   325, -2745, -2745, 19703,
   19703,  2198,  2190, -2745, -2745, -2745,  1408,  1408, 39064,  1969,
    1866,  1970,  1974, 19703, -2745,   942,  4203, -2745,  2266,   895,
   20936, 20114, 19703,  1201, 19703, -2745, -2745,  1976, -2745, -2745,
   39064, 19703,  1649,  4568, -2745,  4720, 19703,  1978,  5040, 17237,
   -2745,   491,   491,   491,   491, -2745, 42169, 42169, 24147, 46049,
    1968,   855, -2745, 46049, 46437, -2745,   942,  2203,  1225,  1238,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745,  1977, -2745,  2005,
   -2745, -2745,   317,  1983, -2745, -2745,  2277,  2006,   746, -2745,
   -2745, 19292, -2745, -2745,  1985, -2745, -2745,  1568, -2745, -2745,
   -2745, 12047, -2745, -2745,  2009, -2745, -2745, -2745, -2745, -2745,
    2041,  2060,  4501, -2745, 47213, 47213,  1247, -2745, -2745, -2745,
     897, -2745, -2745,  2064,  2068, -2745,  2070, -2745, -2745, -2745,
   -2745, -2745, -2745,   430,   504, 39064, -2745, -2745, -2745, 47213,
   47213,  1520, -2745, -2745,  2193,  1994, -2745, -2745,  2201,  2202,
     357,   357, -2745, -2745,  1532,  2267, -2745,  1985,  1035, -2745,
   -2745, -2745, -2745, -2745,   633,   931,  1430,  2014, -2745,  1228,
   25736, 25736, 25736, 25736, 25736,  1753,  1105, 42169, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745,  2012, 47213, 20114, -2745,   585,   405, -2745,  2204, 42169,
    2058, -2745, -2745, -2745, 39064, 42169,  2249,  2170, -2745, 47213,
   -2745, 40617,   909,  2242, 40617, -2745, 47213,  2357,  2359,   296,
    2230,  1464,   895, 47213,  2044,  2263,   598, -2745, 47213, -2745,
   -2745, -2745, -2745,   102, -2745, -2745,  1402,   749,   222, -2745,
   -2745,  2265, 44497, -2745, -2745, 18470,  2045, -2745, -2745, -2745,
   -2745,    33,  9299, -2745, -2745, 19703,  9299, -2745,  2047,  2049,
    2050,  9299,  5123,  2051,  9299,  2198, -2745,  1428,  2280,  2206,
    2054,   325,  1428,   599,   599,   152,   152,    57,    57,    57,
    2303,  9299,  9299, -2745, -2745, -2745, -2745,  2055, -2745, -2745,
   -2745,  1866, -2745, -2745,  1105, -2745,   768,  2969, -2745,   221,
   39064, -2745,  1258,  2969, 20114, 19703, 19703,  5834,   112, 19703,
    5668, 42169, 42169, 42169, 42169, -2745, -2745, 23360,   855,  2062,
   47213, -2745,  2065, 24540,  2250,  2199, -2745, 24540,  2199,   720,
    2199, 24540,  2257, -2745, 27703, -2745,  2067,  1392,  2375,  2292,
   -2745, -2745,   222,  1189,   895, -2745,  2074, 47213, -2745,  9299,
   28908, -2745, 47213, -2745, 47213, 47213, -2745,  1262,  1277,  2058,
    2131, 47213, 47213, 47213,  1278,  2231,  2232,   931, 47213,  2123,
   -2745, -2745,   357,  2275,   357,   357, -2745, -2745, -2745,   895,
   -2745,   664,  2345, -2745,  2291,   423,  2086,  2311,  2312, -2745,
   -2745,  1319,  1319, -2745, -2745, -2745, -2745, -2745,  2315, 19703,
    1186,  1428, -2745, -2745, -2745, -2745,  2058,  1680,  2298, -2745,
    2133,   224,  2341,  2333,    10, -2745,  2092,  2358,  2360, -2745,
    2094,  1442, -2745, -2745, -2745, -2745, -2745, -2745,   895, -2745,
    1599,  2323, -2745, 24933,   895,  2243,  2196, -2745, 36729,  2255,
     425, -2745, -2745, -2745,   873, -2745, -2745, -2745, -2745, -2745,
    2165, -2745, -2745,  2335, -2745, -2745,  2245, -2745, -2745, 18470,
   -2745,  9299, -2745, -2745, -2745, -2745, -2745, -2745, 20114,  2105,
   20114, -2745, -2745,  1314, -2745, 39064,   768,  2969,  2969, 19703,
    2969, -2745, -2745, -2745, -2745, -2745, 46049,  2112, 47213,   855,
   24540, -2745, -2745,   838, -2745, 24540,  2297, -2745, -2745, 24540,
   47213,  2114, 47213, 19703, 19703, -2745, -2745,  1035, -2745, -2745,
   -2745, -2745,  1105, 19703, -2745,  2110, -2745, -2745, -2745,  2224,
    2058, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   19703, -2745, -2745,   357, -2745, -2745,  1062, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, 40229,  2430, 42169,   633,  5694,  2270,
   -2745, -2745,  2294,  2191, 47213, 40617, -2745,   282,  2244, -2745,
    1442, -2745, -2745, 42169,  2269,  2271,  2268, -2745, 47213, 19703,
    1320, -2745, 46825, 15551, -2745,  2120,  2282,   693, -2745,  2274,
   -2745, -2745,  1485, -2745, -2745, 42169,   296, -2745,  1322,   336,
   20114,   163, -2745, -2745,  2969, -2745, 47213,  1339, -2745, 19703,
    2132, -2745, -2745, 24540,   838,  1345, 47213,  1346, 39064,  1866,
    9299, -2745, -2745, -2745,  2567,  2130, -2745, 42169, -2745,  9299,
   -2745, -2745, -2745,  1813,  1813,    21,  1813, -2745,  1813, -2745,
    2430,  2457, -2745, -2745,  2371, -2745,    68,  2284, 47213,  2463,
   -2745, -2745, -2745, 47213,  2268,  1348, -2745, -2745,  2431,  2216,
   -2745,  6126,  2216, 24933, 47213, -2745, -2745, -2745,   895,  2350,
   -2745, -2745,  2301, -2745,  1539, -2745,   976, -2745,  1352, -2745,
    9299, 47213, -2745, -2745, -2745,  1354, -2745, 19703, -2745,  1680,
     895,  1818,  2302, 47213,   895,  1818, -2745, -2745,  2402, -2745,
   -2745,   105, -2745,  2304,  2306, -2745,    12,  2154,  2216, -2745,
     515, 47213, -2745, 46825,  1539, -2745, -2745, -2745, -2745,  2362,
    2407, -2745, -2745,  1356, -2745, -2745,  2294, -2745, -2745, 47213,
    2157, -2745, -2745,  2262,   385,   385,  2211, -2745,  2425, -2745,
     931,   931, 39064,  2162, -2745, 32442, -2745,  2272, -2745,  2276,
   -2745, -2745, -2745, -2745,   118, -2745,  2284,  2157,  2410, -2745,
    2516, -2745,   388, -2745, -2745, 40229, 28908, -2745,    12,  1366,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745,   448,   633,  2305,
   -2745, -2745, -2745,  1469,   -98, -2745, -2745, 32442, -2745,   501,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, 40229, -2745,
   -2745, 38286, -2745, -2745,  1268, -2745, -2745,  1274,  1417,  2185,
    2183, -2745,   501, 32442,  2307, -2745,  1373, -2745, -2745
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2745, -2745, -2745, -2745, -2745,  2376, -2745, -1726, -2745, -2745,
   -2745, -1164, -2745, -1674, -2745,  1160, -2745, -2745, -2745, -2745,
   -2745,   723, -2745, -2745,  -756, -2745,  1372, -2745, -2745,   516,
   -2745, -2745, -2745, -1419, -2745,   122, -2745, -2745, -2745, -2745,
   -2745, -2745,   795, -2745,   825,   422, -1396, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -1384,   734,
      34, -2745,    36,   820,   115, -2745,  -152, -2745, -2745, -2745,
    -210,   490, -2644, -2070,    26,  -467,  -493,  -439,  -436,  -464,
   -2745,  -302,  -382, -2125, -2552, -2745, -2745, -2745, -2745, -2745,
      49, -1378, -2745,  1190, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745,  -434, -2745, -2745, -2745, -1366, -2745,   778, -2173, -2745,
   -2745, -2745,  -535,  -508, -2745, -2744,  -115,  -113, -2745, -2745,
   -2745, -2745, -2745, -1024, -2745,   424, -2745, -2745, -2745,  -486,
    1210,  -530, -2745, -2745, -2745, -2745,  -676, -1381, -2745, -2745,
    2478,   814,   157, -2745, -2745, -1768, -1364, -2745,  1819, -2745,
    1558,  1133,   332,    44, -2745, -2745, -2745, -2223, -1359, -2745,
   -2745, -2745,  -366, -2742, -2745,   784, -1052, -2745,   519, -2745,
   -2745, -2745,   386, -1675, -2745,  -151, -2745, -2745, -2745, -1358,
   -2745, -1454, -1332, -2745,  -336, -2745, -2745, -2745,  1569, -2745,
    -163, -2745, -2745, -2745, -2745, -2745,  -471,  -504, -2745, -2745,
   -2745,   442, -2745, -2745, -2745,   823,  -981,  -808,  1816, -1356,
   -2745, -2745, -2745,   813,   -50, -2745, -2745, -2745, -2745, -1292,
   -2745, -2745, -2745,  1001,  2528,  -688, -2745, -2745, -2745, -2745,
   -2745, -2745,   -19, -2745, -2745,   370,   -11, -2745, -2745, -2745,
   -2745,    -9,  1607,   762,    77,   -69,   -71,  -224,   -16,   347,
   -2745, -2745,  -169,   891, -2745, -2745, -2745, -2745,   592,  1437,
   -2745,   586,  -271, -2745, -2745,  1441, -2745, -2745,  1023, -2745,
   -2334,   275, -2329,    -5,  -902,  -279,  -161, -2745, -2006, -2089,
     119,  2784, -1625, -1828,  1291, -2745,  3393,  4733, -2745, -2745,
    -995, -2745, -2745,  6279,  6885, -2745, -2745,  7046,  8281, -2745,
   -1013,   309,  8444,  2584, -1113, -1402,  8985,  -291, -1512, -1902,
   -2745, -2745,  -694, -2745,  9852,   477, -2745, -1138, -2745,    39,
   -2745, -1468, -2745, -2745, -2745, -2745, -2745, -1420, -2218,  -371,
     667, -2745, -2745,   751, -2745, -2745, -2745,  -690,  -924, -1583,
     129, -2745,  1093, -2745,     0,  -332,   628,  -111,   104,  1514,
    -810,  1433,  -846,  6913,  -646, -1862, -1233,  1703, -2745,  -681,
   -2745,    -2,   216, -2745, -2745,  4407,  -108, -2745, -1582, -2745,
      56, -2745,  -841,  -900, -2187,  -310, -2745, -2745,   -75, -2745,
    1799, -2745,   996,  1434, -2745, -2745,  1000,  -793,  -137, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745,  1466,    75, -2745,   -53,
   -2745, -2745,  2665, -2745,  2432,   -47, -2745,  2084,   -37, -2745,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,  -801,  1046,
   -2745,  1796, -2745, -2745, -2745,  -740, -2745, -2745, -2745,  1656,
    -142, -2745, -2745, -2745,  -983,   916,  1830,  -832,  -966,  1019,
   -2745, -2745, -2745, -2745, -2745, -2745, -2745, -2745,   822, -2745,
   -2745,   677,   826, -2745, -2745,   150, -2745, -2745,    46,   151,
   -2745,  1557, -2745, -2745, -2745,   306, -2745, -2745, -2745,  -542,
    7411,    11,   -72,   -84,    93,   930,  8614,   997,  -647,   -82,
    1507,  5164,  8808,   -81,   -58,   108,   135, -2745, -2745,  2429,
    1032,   846,  -877,  6188,  1283,  2605,  3458,  -698,  -817,  1852,
    -513, -1265, -2745,  2780
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1715
static const short yytable[] =
{
      69,   876,   990,   300,  1221,   299,   663,   961,   666,   669,
     749,   974,   778,   968,  1103,   971,  1474,   749,   662,  1444,
    1008,  1792,  1922,  1380,   349,  1453,   998,   314,   663,  1867,
     666,   669,   670,   948,  1590,  1043,  1325,   316,  1031,  1906,
     662,  1311,  1740,  1578,   970,   972,   865,  1232,  1059,  1036,
     798,   828,  1868,   704,   670,   294,   749,  2003,   871,  2297,
    2086,  1049,  1886,   295,  1315,   297,  1968,  1280,  1887,  1071,
     798,   745,  2437,  1064,  2496,  2186,  2187,  1035,  1920,  1068,
    1888,  2225,  1889,  2116,  1926,   341,  2619,  1890,   341,  2003,
    1891,  2587,  1084,  2470,  2698,  1224,  1753,  1230,  2100,  1079,
    1486,   341,  2153,  1098,  2713,  2715,  2163,  2164,  1217,  1312,
    1542,  1543,  1067,   923,  1918,  1285,  1632,  1487,  2129,  1305,
    1308,  1502,  2133,   341,  1860,  1481,  2077,  1496,  1497,  1562,
    1597,  1289,  1290,   663,  2361,   666,   669,  1554,   551,  1592,
     957,  1452,  1308,  2932,  1481,   662,  2234,   937,  2209,  1520,
    1600,  1218,   348,  -942,   875,   300,   797,   299, -1089,   670,
    1804,  2065,  -256,  2663, -1089,  2337,  1894,  2066,  1488,  2197,
    1626,  1954,  1771,  1515,   151,  2435,   797,   945,  -777,  1772,
    2279,  1293,   343,  3014,  1851,   343,  1095,  2901, -1524, -1619,
    -777,  2322,  2513, -1193,  2029,  1269,  -769, -1105,   343,  3170,
    1903,  2324,  3110, -1105,  3145,   675,  2257,   294,  1822,   344,
    1086,  3037,   344,  1481,  1335,   295,   919,   297,    70,  1597,
     343, -1641,   844,  1895,  -777,   344,     3,  1629,   341,  2361,
    2442,   167,   822,  2235,  2931,  1996,  2443,  2444,  2445,  1600,
    2361,  -777,  1370,  1646, -1654,   197,  1773,   344,  2446,  2447,
    2448,  1380,  2449,  2450,  2451,  -769,  1597,  3069,  2452,  2453,
    2454,  3104,  1233,  1955,   888,  1371,  1327,  1345,  1768,  1693,
    1008,  1630,  1357,   567,   889,  -777,  1600,  1358,  3062,  1879,
   -1671,  1028,  2558,  -777,  1449,  3111,   681,  1328,   682,  1647,
    -922,  1901,  1088,  -922,   914,  1758,  1336,   845,  1597,   705,
     717,  1450,  1351,   915,   829,  1578,  1759,  1053,  1880,  -772,
     867,  1347,  1359,   889,  1552,  3063,  2198,  3171,  1600,  1385,
    2111,  1482,   341,  1372,  1360,   343,  1392, -1526,  1234,  1329,
    1387,  1660,  3146,  1235,  1291,  1225,  1389,  1841,   203,   941,
    1482,  3121,   203,  1694, -1576, -1523,  2323,  1852,  2998,  1904,
    3070,  3112,   344,  2514,  1361,  2528,  2325,  2563,   341,  2098,
    1384,   341,  1760,   946, -1522,   830,  1443,  1521,  -772,  2869,
    2321,  -777,  1627,  2873,  1769,  1462,  2533,  2878,  1459,  1896,
    1970,  1270,  2210,   975,  2363,  1774,  1812,   219, -1619,  2515,
    2218,  1542,  1543,   999,  1475,  1965,  1966,  1516,  1836,  1562,
    1604,  1605,  2361,  1956,  3167, -1089,  1974,  1976,  2067,  1482,
    1909,  2549,  1554,  2361,  1537,  3096,  1323,  1039,  1957,   343,
   -1641,  1304,   913,  1248,  2737,  2738, -1621,  2847,  -942,  1050,
    -937,  -942,  2007,   225,  2009,  1483,  2364,  1517,  1593,  1608,
    2361,  2395, -1715, -1654, -1105,  1861,   344,  2526,  2527,   922,
     568,  1069,  -942,  2401,  2622,   343,  2532,  1337,   343,  1312,
     924,  1704,  1076,  1399,  1621,   549,  1761,  1861,  2374,  2466,
    2280,  2281,   549,  2112,  3105,  1639,  1640,  2499,  -769, -1671,
    -769,  2213,   344,  1729,   549,   344,  1305,  2003,  2003,  2003,
    1903,    49,  2003,  2083,   549,  1734,  3129,   925,  1597,    52,
     683,    53,   831,   685,  1929,  1008,  2461,  1277,  2455, -1524,
    2047,  1598, -1524, -1524,  2468,  1363,   277, -1524,  1600,   549,
    1928,  2137,    49,  1601,    52,   549,  2435,  2299,  2300,  1931,
      52,  2521,   792,   976,   686,  2003,  2978,  2975,   995,  3151,
    1001,  2982,  1762, -1576,  1342,  2984,  2363,  1992,  1993,  1842,
    1618,  1619,  1620,  1621,   353,  2365,  1758, -1715,  2784,  1682,
    2371,  2372,  2373,  2374,  1465,  2366,  2367,  2368,  1717,  2369,
    2370,  2371,  2372,  2373,  2374,    49,  2760,  1757,   549,  3047,
    2960,  1766,   715,  2456,  2363,  1616,  1617,  1618,  1619,  1620,
    1621,  -772,  1063,  -772,  3020,  1377,   663,    49,   666,   669,
     549,   549,  -183,  1466,   151,  1060,    52,  2048,   662,   919,
     749,  2049,  1002,  2548,   792,  1821,   203,  3021,   801,  2219,
    1602,  2939,   670,  1760,  1603, -1621,  1343,  1616,  1617,  1618,
    1619,  1620,  1621,  1056,  1713,  1385,  2364,   959,  3130,  2935,
    1081,  2050,  1604,  1605,  1718,  2961,  2326,   889, -1526,  3052,
    3152, -1526, -1526,   882,  1606,  1768, -1526,   151,    69,   990,
    1940,   167,  1944,  1945,   919,  1947, -1523,  2785,   277, -1523,
   -1523,  3117,  1467,   798, -1523,   798,  2361,   798,  1607,  3118,
    2762,  1608,  1384,   798,  1091, -1522,  1714,  2745, -1522, -1522,
    2464,   341,  3131, -1522,  1609,   341,  1610,  2183,  2039,   883,
    1946,  3010,  1213,  2327,   203,  -937,  3158,   183,  -937,  1378,
    3132,   225,   919,  1468,   167,  1843,   753,  2040,  1051,  1848,
    2417,  2332,  2771,  2772,  2773,  2774,  2775,  1761,  2331,  -937,
    1715,  2369,  2370,  2371,  2372,  2373,  2374,  2051,  1379,  2782,
    1052,  2812,  2369,  2370,  2371,  2372,  2373,  2374,    49,  2497,
    1611,   549,  1856,  1214,  2826,  2365,  1765,  1057,   884,  2626,
     183,  2746,  2756,  2757,  1344,  2366,  2367,  2368,   203,  2369,
    2370,  2371,  2372,  2373,  2374,  2500,  1258,  1469,  1766,   797,
    1001,   797,   818,   797,  1241,  2783,  2760,   902,   343,   797,
     797,  2985,   343,  2987,  2184,  2041,  2185,  2517,  2518,   225,
    2042,  2435,  3119,  1762,  2043,  2435,  1716,  1927,  2758,  2435,
    1259,  2827,  1465,  1612,   895,   344,  1863,   219,  2918,   344,
    2363,   203,  1058,  1613,  1614,  1615,  1943,  1616,  1617,  1618,
    1619,  1620,  1621,  1884,   823,  1837,  1257,  2103,   896,   903,
    2747,  2761,  1311,  2748,  1838,  2361,   885,   840,  3040,   897,
    2003,  2616,  1002,  2003,  2003,  2003,  2003,  2003,  2003,  2003,
    2003,  2003,  2003,  3159,  2919,  1315,  2633,  2621,   903,   676,
     219,  1758,  2364,   990,   864,  1886,    70,   341,  1804,  2390,
     677,  1887,  1759,   904,  1767,  2120,   905,  1258,  2675,  2003,
    2762,  2310,   163,  1888,  -801,  1889,  2044,  3055,  2403,  2612,
    1890,  2614,  2615,  1891,  2045,  2622,  1278,  3084,  1227,  2705,
    1845,  2952,   904,  3041,  1721,  1864,   225,  1722,  2828,  1714,
    1467,  1259,   873,   663,   898,   666,   669,  1641,  3141,  2706,
    2776,    69,    69,  2405,    69,   662,  2645,   722,  1760,  1278,
    1385,  2438,  2439,  2648,  2875,  -801,   880,   687,   876,   670,
    1092,  2708,  2032,  3116,  2178,   678, -1332,  2181,  2182,   906,
    1846,  1468,  2664,  1715,   716,  1642,  2814,  2829,  2435,  1081,
    3141,     9,   899,  2435,   343,  2704,   776,  2435,  1042,  -801,
     551,   551,  1105,  2815,  2912,   879,  2914,  2915,   906,  2363,
    1723,  2365,  2704,  3100,  2226,  2227,  3141,  1771,   892,  1051,
     726,   344, -1715, -1715,  1772,  2369,  2370,  2371,  2372,  2373,
    2374,   917,   558,   300,  -537,  1494,  2406,  1597,   341,   580,
    2407,  2585,   673,   842,   900,  1469,  1870,  2705,   907,  3127,
    2710,   300,   673,  1519,  1573,  1574,   118,  1600,  3090,  1716,
    2649,  2364,  1761,  2127,  2705,   728,  1535,  2706,    49,  2650,
    2816,   549,  1656,  2361,   122,   679,   908,  1865,   580,   685,
     928,  2003,  2707,  1556,  2706,  1490,  1575,   673,   714,  2708,
    1331,  1773,  3019,  1491,  2817,  1492,   580,   673,  3122,  2707,
     673,  2435,  2797,   730,   673,  1866,  2708,  2709,   673,  1581,
     686,  1332,  1334,  -916,   197,  1832,  -916,  1871,  1573,  1574,
    2818,  1588,   223,  1833,  2709,   224,  1357,  1384,   673,  2979,
    2139,  1358,  2408,  2798,  1333,   343,  1981,  1558,  1762,  1410,
    2409,  1374,  1834,   673,  1279,  1763,   834,   839,  1080,   549,
    1577,  2952,   843,  1480,   858,  1883,   863,  1228,  1657,   549,
    1872,  2890,   344,   549,    52,  3000,  1359,  1805,  2710,    70,
      70,   931,    70,   733,  2777,   734,  1650,  1279,  1360,  1006,
    2365,  1977,   660,  1007,   735,  2710,  3001,  2727,  1982,  1925,
    2222,  2223,  2003,   738,  2369,  2370,  2371,  2372,  2373,  2374,
    1345,  2819,  1685,  1685,   666,  1685,   947,  -550,  1361,  2333,
    -949,  1736,  2820,  -949,   662,  1807,  2334,  2363,  1811,  1813,
    3002,  1346,  1354,  1873,  1366,  1874,  2821,  1818,   670,   941,
    2980,  1731,  1983,  2822,  -949,  1984,  2731,  2832,  1778,  3003,
    2810,   786,  2490,  1355,  1347,  1367,   958,  2711,  2361,  1278,
    1591,  1278,  3004,  1278,  2302,  2840,   787,  1686,  1688,  1779,
    1692,  1596,  1747,  2491,  2711,   663,  3005,   666,   669,  2364,
     979,  1863,  1037,  2823,  1038,  2671,  2962,   662,  1549,  1551,
     980,   981,   982,  2477,   983,   984,   985,   986,   987,   988,
    1743,   670,  2852,  2665,  2666,  1724,  1000,   341,   341,   341,
     889,  1571,  2462,   673,  1653,  2503,    49,  1010,  1985,   549,
    1582,   223,    49,   876,   224,   549,  -919,   797, -1196,  -919,
      52,    69,    53,   903,  2571,    69,  2504,  2740,  1277,  1033,
    2034,  1573,  1574,    49,  1754,   663,   549,   666,   669,  -952,
    1565,    52,  -952,    53,  3006,   549,  1362,   662,   341,  1277,
      52,  3007,  2543,   126,   127,   341,  2003,  2573,  2003,  2509,
     341,   670,  1034,  1575,   551,  2510,  2511,   904,  2150,  1363,
    1864,  2471,   764,  2151,  2362,  1006,  3008,  1986,   990,  1007,
     223,    49,  1006,   224,   549,  1054,  1007,  1635,  2365,  1795,
    1706,  1636,  2363,  1707,   343,   343,   343,   949,  2366,  2367,
    2368,   950,  2369,  2370,  2371,  2372,  2373,  2374,  1278,  1573,
    1574,  1044,  3091,   951,   952,  1537,  2571,  -952,  2895,  2958,
    -952,   344,   344,   344,  1796,  1730,   549,  2572,  1707,  -942,
     341,    52,  -942,  2475,   953,   549,  1040,   954,  1041,   792,
      52,  1577,    53,   906,  2364,   343,  1560,  1561,  1277,  2573,
    2230,  2574,   343,  -942,    52,  2231,    53,   343,  1978,    49,
    1979,  2135,   549,  2929,  1980,  2138,   875,  1279,  2577,  1279,
    1991,  1279,   344,  2421,   580,  2422,  2319,  1995,  2003,   344,
    2149,  2320,  1804,  1595,   344,  1797,  1810,  2013,  1066,  2014,
    1076,  1076,  2165,  2166,  2330,  2578,  1534,  2341,   225,  2331,
    2484,  1380,  2331,  2176,  2579,  2027,  2575,  2028,  1055,  2343,
    2993,  2346,  1865,  1725,  2331,  1095,  2347,  2352,   673,   673,
    1935,  1798,  2353,  1799,  1099,  2361,  2200,   343,  1077,  2203,
    2204,  2378,  2717,  1800,  1653,   663,  2331,   666,   669,    70,
    2423, -1524,  2424,    70, -1524, -1526,  -907,   662, -1526,  -907,
    -905,   955,  2037,  -905,   344,  2576,  -908,  2441,  2475,  -908,
    2577,   670,  2331,  2365,   797, -1530,   797,  2472,  1101, -1531,
     797,  2580,  1649,  2366,  2367,  2368,   797,  2369,  2370,  2371,
    2372,  2373,  2374,   797,  2588, -1523,  1801,  2578, -1523,  2589,
    1076,   711,  1100,   797, -1522,   797,  2579, -1522,    49,  1106,
      49,   549,  2595,   549,  1856,  1306,  1307,  2596,    52, -1528,
      53,   797,  1110,   797,  1802,  1085,  2887,  1087, -1527,  1089,
    1687,  1687,  2091,  1687,   919,  1090,  1279,  2607,   819,  2624,
     341,  1111,  2608,  1989,  2625,  -906,   827,  2678,  -906,   969,
     580,   973,  2331,   558,  1112,   673,   992,   673,  1943,  2094,
     673,   673,   969,   558,  2550,  2551,  2552,  2553,  2554,   889,
    1935,  2720,  1070,  2580,  2770,  2389,  2331,  2391,  2392,  2363,
     673,   869,   710,   580,  2721,   969,  2118,   558,  2118,  2331,
    1113,  1046,   673,  2739,  1115,   673,  2639,   969,  2608,   558,
     663,  1116,   666,   669,  2854,  1231,   673,   673,  2899,  2855,
    1823,  1824,   662,  2608,  3181,   673,  3182,   341,   580,   710,
    1248,   558,  -769,  2900,  1236,   673,   670,   710,  2608,   673,
     673,  2364,   558,  2114,  1237,   969,  1707,   343,  2358,  2359,
    2360,  3060,  3061,  2376,  3064,  2092,  3065,  3180,  1739,  1307,
     341,  2207,   341,   673,  1278,   673,  2361,  2552,  2553,  2554,
    2972,   673,   710,   710,   344,  2855,  3032,  1244,  3045,  2684,
    1278,  3033,    69,  2625,    69,  2989,  1008,  1238,  1825,  2550,
    2551,  2552,  2553,  2554,  1246,  3049,  2412,  2555,  2246,   673,
    1649,  3054,  3056,  1109,  3079,   341,  2589,  2589,  3092,  1521,
    3094,  2256,  3125,  1649,  1254,  2589,  1256,  1649,   580,   673,
     673,   858,  3156,   858,   343,  1913,  1914,  3157,   551,  3188,
    1597,  1573,  1574,  1278,  3157,   919,  1278,  1278,  2123,  1826,
    1827,  1707,  1245,  1598,  3154,  1006,  2874, -1199,  2877,  1007,
    1600,   344,   876,  2767,  2768,  1601,  1250,   343,  1252,   343,
    2365,  2250,  2251,  2252,  2253,  2944,  2945,   797,  1828,  1248,
    2366,  2367,  2368,  1249,  2369,  2370,  2371,  2372,  2373,  2374,
    2478,  2479,  1292,  1294,   344,  1255,   344,  1263,  1267,  1271,
    1268,  2501,  1272,  1273,   558,   558,  1274,  1275,  1298,   797,
    1276,  2335,   343,  1283,   797,  1286,  1288,  1291,  1299,  1316,
    2363,  1317,  1319,  1326, -1530, -1531,  1011,   797, -1528,   673,
   -1527,  1329,   673,  1339,  1340,   673,  1350,  1829,  1352,   344,
    1368,  1353,  1369,  1375,  1376,  1076,  1388,  1390,  1395,  1397,
    1399,  1401,  1438,  2426,  2427,  1012,  1439,  1445,   969,  2229,
    1391,  1441,  1602,  -137,   979,  1454,  1603,  1013,  1447,  1830,
    1458,  1470,  2364,  1014,   980,   981,   982,  1472,   983,   984,
     985,   986,   987,   988,  1604,  1605,  1477,  1015,  3043,  1478,
    1476,  1479,  1279,  1525,  1528,  1529,  1606,  1530,  1533,  1541,
    1544,   673,  1545,  1546,  1016,   673,  1548,  1550,  1279,   673,
      70,  1555,    70,  2284,   673,  1588,   225,   797,  1557,  1564,
    1607,  1567,   969,  1608,  1568,  1569,  1570,  1572,  2037,  1579,
    1580,  1631,  1017,  2463,   969,  1461,  1609,   673,  1610,  1649,
    1655,  1676,  1675,  1683,  1257,  1705,  1712,  2420,  1018,  1719,
     969,  1720,  1726,  1728,  1732,  1308,  2429,  1735,  1741,  1742,
    1744,  1279, -1475,  1746,  1279,  1279,  1754,  1751,  1752,  1780,
    1019,  1755,   673,  1756,  1770,  1782,  1781,  1385,  1783,  1784,
    1785,  1786,  1788,  1787,  1793,   673,   990,  1804,  1794,  1808,
    1809,  2365,  1611,  1814,  1815,  1532,  1816,  1817,  1819,  1820,
    1839,  2366,  2367,  2368,  1844,  2369,  2370,  2371,  2372,  2373,
    2374,  1849,  1847,  1850,  1859,  1020,  1857,  1537,  1552,  1869,
     724,  2647,  1558,  1565,  2651,  2652,  2653,  2654,  2655,  2656,
    2657,  2658,  2659,  2660,   764,  1893,  1935,  1907,  1908,   797,
    1910,  1278,  1916,  1919,  1899,  1911,  1921,  1932,  1948,  1950,
    1949,  3169,  1939,  1960,  1969,  1612,  1021,  1970,  1022,  1597,
    2676,  2026,  1933,  1023,  2011,  1613,  1614,  1615,  1977,  1616,
    1617,  1618,  1619,  1620,  1621,  1938,  1521,  2012,  2025,  2547,
    3048,   994,  2036,  3025,  2351,  1024,  2033,  2052,  2077,  2054,
    3048,  2087,  2088,  2090,  2093,   580,   580,   663,  1025,   666,
     669,  1030,  2611,  1026,  2095,   883,  2104,   749,  1654,   662,
    2108,  2109,  2113,  1672,  1673,  1672,  1861,  2121,  2122,  2140,
    2126,  1027,  2142,   670,  1681,  2146,  2143,  2148,  1278,  2134,
    2161,  2144,   979,  2162,  1278,  1278,  2179,  2174,  2173,  2192,
    2175,   802,   980,   981,   982,   876,   983,   984,   985,   986,
     987,   988,   960,  2202,   876,  3093,   960,  2205,   710,    49,
    2214,  2208,   710,   710,  2215,  2211,   580,  2216,   558,  2224,
     300,  2217,  2609,   300,  2232,  2610,  2244,  2237,  2245,  2248,
    1278,  2258,   710,   960,  2474,   797,  2263,   797,  2283,  2640,
     803,  2264,   341,  1943,  2286,  2643,  2291,  2559,   300,   673,
    2627,  1102,  2691,  2692,  2693,  2694,  2292,  1104,  2293,  2294,
    2295,  1597,   804,   858,  2298,  1108,  1641,   710,   960,  2328,
    2329,  2309,  3030,  2344,   960,  2345,  2348,  2349,  2350,  2354,
     805,  1600,  2781,   992,  2357,  2377,  1601,  2331,  2383,  2386,
    1597,  2384,  2387,  2385,  2394,  2398,  2399,  2400,  1240,  2404,
    2410,   858,  2419,  1243,  2416,  2440,  2564,  2467,  2481,  1279,
    1600,  2483,  2485,  1307,  1251,  1601,  2487,  2489,  2488,   806,
    2506,   969,  2494,  2495,  2519,   969,  2520,  2524,  2530,  2531,
    2529,  2545,   710,  2546,  2557,  1722,  1058,  2556,   710,   343,
    2584,  2591,  2597,  2593,  2594,   797,   710,  2613,  1588,  2598,
    2602,   797,  2603,   979,  2606,  2617,  2814,  2697,  3086,  2629,
    2618,  2630,  1534,   980,   981,   982,   344,   983,   984,   985,
     986,   987,   988,  2815,  2637,   558,  2634,   673,  2380,   710,
    2361,  2379,  1592,  1602,   710,  2668,  2669,  1603,  1654,  2703,
    2670,  2680,  2734,  2856,  2688,   710,  1279,  2718,  2722,  2724,
    2730,  2732,  1279,  1279,   807,  1604,  1605,  2723,  2726,   558,
    2753,  2735,  1602,   969,  2752,  2741,  1603,  1606,   673,  2742,
     808,  2743,  2754,  2755,  2897,  2759,   809,  2779,  2769,  2786,
    2788,  2903,  2792,  2905,  1604,  1605,   673,  2766,   673,   673,
    2816,   673,   990,  1386,  1608,  2794,  1606,  1953,  1279,  2800,
    2805,   810,  2806,   811,  3153,  2674,  2808,  1609,  2836,  2813,
    2839,  1963,   812,  2842,  2817,  2843,  2844,  2846,  2848,  2850,
    1607,  2851,  2849,  1608,  2870,   813,   814,  2871,  2866,    69,
    2868,  2879,  2882,  2883,  1456,  1457,  1609,  3179,  2884,  2893,
    2818,  1464,  2902,  2906,  2907,  2910,  2913,   992,  2920,  2761,
    2923,  2924,  2925,  2926,  2933,  2934,  2936,  2938,  2940,  2943,
    2941,  2948,  2942,  1611,  2956,  2957,  2965,  2959,  2966,  2967,
    2970,  2983,  2997,  3011,   710,   960,  2996,  2976,   300,  2986,
    2807,   960,  2785,  1104,  3016,  3018,  1724,  3023,  3026,  3028,
    3027,  3038,  1611,   797,  3039,  3042,  3058,  3051,   797,   797,
     797,   797,   797,  3067,  3068,  3071,  3076,  2969,  3080,  2971,
    3081,  3088,   673,  3089,  3099,   710,   710,  3103,  3124,  3115,
     960,  2819,   710,  3123,  3128,  3106,  1612,  3108,  2608,   673,
    3105,  3104,  2820,  3138,  3149,  3143,  1613,  1614,  1615,  3144,
    1616,  1617,  1618,  1619,  1620,  1621,  2821,  3150,  3168,  3184,
    3183,  1878,   878,  2822,  3170,  1612,  2259,  1674,  2097,  2465,
    2199,  2169,  2516,   673,   710,  1613,  1614,  1615,  2260,  1616,
    1617,  1618,  1619,  1620,  1621,  2796,  2188,  2744,  2930,  3126,
    2802,  2493,  2429,  3148,  2831,  3109,  2429,  3107,  3024,  2908,
    2429,  3134,  3078,  2823,  1597,  2803,  1902,  2247,  3186,  3173,
    2922,  2921,  3155,  1882,  3187,  2536,   825,  1598,  2811,  1514,
    1114,  2631,   558,  1962,  1600,  1298,  2837,  3085,  2261,  1601,
    2498,   673,  2605,  2963,  3066,  1677,  3161,  1527,  3185,  3046,
    1239,   558,   673,  2101,   779,   558,   580,   565,  2254,   673,
    2628,  1493,  2301,  2833,   581,   673,  2473,    70,  1702,  2480,
     558,  1700,  2099,  2699,  2876,  3053,  1858,  2673,  2795,  2542,
     558,   558,   558,   558,   673,   673,  2414,   673,  2172,  2853,
    2076,  1935,  2338,   558,   673,  3095,  2469,  2894,  2968,  2838,
    1301,  2125,  2124,   581,  1711,  1737,  2189,  2190,   673,   311,
     673,  2194,   673,   673,   890,   797,   558,   673,   940,   558,
     558,   581,   581,  2115,  1725,  1324,   710,  1295,  1460,   581,
    2307,  2128,  1524,   565,  2460,  2308,  1602,  2834,  2886,  2835,
    1603,  1638,  2725,  1708,  2157,   912,   969,   969,  2132,  2303,
    2892,   565,    76,   565,  1934,  1303,     0,     0,  1604,  1605,
       0,  2243,     0,     0,     0,     0,     0,     0,   581,  2429,
    1606,     0,     0,     0,  2429,     0,     0,     0,  2429,     0,
     558,     0,     0,     0,     0,  2917,     0,     0,     0,     0,
       0,     0,     0,  1597,  1607,     0,     0,  1608,     0,  2267,
       0,     0,     0,     0,  2278,     0,     0,     0,     0,     0,
    1609,  2290,  1610,  1600,     0,     0,     0,     0,  1601,     0,
       0,  2172,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   673,     0,  2947,     0,     0,     0,     0,     0,
    2955,     0,     0,     0,  1653,     0,     0,     0,  2314,     0,
       0,     0,   710,     0,     0,  2991,     0,     0,     0,  1597,
       0,     0,     0,     0,     0,   300,  1611,  2610,     0,     0,
       0,     0,  1598,     0,     0,     0,     0,     0,     0,  1600,
    1923,  1924,  2429,     0,  1601,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,     0,     0,     0,
       0,     0,     0,     0,     0,  3178,     0,     0,     0,  2888,
       0,     0,     0,  1104,     0,  1602,     0,     0,   804,  1603,
       0,     0,     0,     0,  1959,     0,  2397,     0,   581,  1612,
       0,     0,     0,  1104,     0,     0,   805,  1604,  1605,  1613,
    1614,  1615,     0,  1616,  1617,  1618,  1619,  1620,  1621,  1606,
       0,     0,   992,     0,     0,     0,     0,     0,  3057,     0,
       0,   710,   710,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3135,  3136,     0,   806,  1608,     0,     0,     0,
       0,  1602,     0,     0,     0,  1603,     0,     0,     0,  1609,
       0,   960,     0,  1672,   710,     0,     0,     0,  1681,     0,
       0,     0,     0,  1604,  1605,   710,     0,     0,     0,   673,
       0,     0,     0,     0,   710,  1606,  1597,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   580,     0,     0,  2075,
       0,     0,     0,     0,     0,     0,  1600,     0,     0,  1607,
       0,  1601,  1608,     0,  2290,  1611,   300,     0,     0,     0,
       0,     0,     0,     0,     0,  1609,     0,  1610,  3177,     0,
     807,   558,   673,     0,  3087,     0,     0,     0,     0,     0,
       0,     0,     0,  2992,     0,     0,   808,     0,   797,   797,
       0,   300,   809,     0,     0,  2102,  3097,     0,     0,     0,
    3101,     0,     0,     0,     0,     0,     0,     0,     0,   581,
       0,     0,     0,   688,     0,   558,     0,   810,  1612,   811,
     710,  1611,     0,     0,     0,     0,     0,  2172,   812, -1715,
   -1715,     0,  1616,  1617,  1618,  1619,  1620,  1621,     0,     0,
       0,   813,   814,     0,     0,     0,     0,     0,     0,  2243,
       0,     0,  1603,     0,     0,     0,     0,     0,     0,     0,
     689,   673,   673,   673,     0,     0,     0,   932,     0,     0,
    1604,  1605,     0,     0,   690,     0,   710,     0,     0,     0,
       0,     0,     0,     0,  1612,     0,     0,     0,     0,     0,
       0,   691,     0,   673,  1613,  1614,  1615,     0,  1616,  1617,
    1618,  1619,  1620,  1621,   673,     0,     0,     0,  2024,  1608,
       0,     0,     0,     0,     0,     0,     0,     0,     4,   692,
       0,  2620,  1609,   693,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     5,     0,   694,     0,     0,     0,  2314,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   969,     7,     8,     0,   695,     0,     0,     9,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   696,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2268,     0,     0,     0,
       0,  2285,     0,     0,     0,     0,     0,     0,    36,     0,
       0,   581,   581,     0,     0,     0,     0,     0,     0,  2702,
       0,  1612,     0,  2702,  2716,   697,     0,     0,     0,     0,
     698,     0,     0,     0,     0,  1616,  1617,  1618,  1619,  1620,
    1621,     0,   581,     0,     0,     0,   565,     0,   565,     0,
     565,     0,   699,   700,     0,     0,   565,   565,     0,     0,
       0,     0,     0,     0,     0,   701,   581,     0,     0,     0,
     702,     0,     0,     0,     0,    37,     0,   710,     0,     0,
     703,     0,   710,     0,  2290,  2290,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,   673,
     673,     0,     0,   581,   581,     0,     0,   565,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
    2243,  2243,  2243,  2243,  2243,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,     0,
       0,     0,   673,     0,  2425,     0,     0,     0,     0,     0,
       0,     0,     0,   565,     0,     0,     0,     0,     0,  2267,
       0,  2189,     0,     0,  2189,     0,  2804,     0,     0,   565,
     565,     0,   345,  2172,     0,   345,     0,     0,  2290,     0,
       0,  1597,     0,     0,     0,     0,     0,   582,   345,     0,
       0,    43,  2314,     0,  1598,     0,     0,     0,     0,     0,
       0,  1600,     0,     0,     0,     0,  1601,     0,     0,     0,
     345,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,   710,   582,     0,     0,     0,
    1597,  2436,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,   582,     0,     0,     0,     0,    46,
    1600,     0,     0,     0,     0,  1601,     0,  1431,     0,     0,
      47,     0,     0,    48,    49,     0,    50,  2702,    51,     0,
    2867,     0,    52,     0,    53,    54,  1597,     0,     0,    55,
      56,    57,    58,    59,  2881,     0,    60,    61,    62,    63,
    1431,    64,    65,    66,    67,     0,  1600,  2097,     0,     0,
     992,  1601,  2896,  1602,   558,   673,     0,  1603,     0,     0,
       0,   558,   673,   558,     0,   345,     0,     0,  2909,     0,
       0,     0,   565,  2402,     0,  1604,  1605,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2586,  1606,     0,     0,
    1501,     0,  2592,  1505,     0,     0,     0,     0,     0,     0,
       0,   581, -1715,     0,     0,     0,  1603,     0,     0,     0,
       0,  1607,     0,     0,  1608,     0,     0,     0,     0,  2411,
       0,     0,     0,     0,  1604,  1605,     0,  1609,     0,  1610,
       0,     0,     0,  2953,     0,     0, -1715,     0,  1654,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1715,     0,
       0,     0,  1603,     0,     0,     0,     0,     0,     0,   345,
       0,     0,     0,  1608,     0,     0,     0,   710,     0,   565,
    1604,  1605,     0,   710,     0,     0,  1609,     0,     0,     0,
     565,     0, -1715,  1611,     0,     0,  2702,     0,   673,     0,
       0,     0,     0,     0,     0,   345,     0,     0,   345,     0,
    2267,     0,  2988,     0,     0,  1659,  1634,  1420,     0,  1608,
     581,   581,     0,   960,     0,     0,     0,     0,     0,     0,
       0,     0,  1609,   565,     0,     0,   565,     0,   565,     0,
     565,     0, -1715,     0,     0,     0,     0,     0,     0,     0,
    1473,     0,     0,     0,     0,     0,  1612,     0,     0,  2695,
    2696,     0,     0,     0,  2172,  2189,  1613,  1614,  1615,     0,
    1616,  1617,  1618,  1619,  1620,  1621,     0,     0,   969,     0,
    2544,     0,   969,   969,     0,     0,     0,     0, -1715,     0,
       0,   581,     0,   565,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   565,  1612,   673,     0,     0,     0,
    1431,     0,     0,     0,     0,     0,  2988,     0,     0,  1616,
    1617,  1618,  1619,  1620,  1621,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1431,     0,     0,     0,
     710,   710,  2436,     0,     0,     0,     0,     0,   673,     0,
       0,  1612,     0,   673,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2953,   969,  1616,  1617,  1618,  1619,  1620,
    1621,     0,  1431,     0,     0,     0,     0,     0,     0,     0,
       0,   673,   582,     0,     0,     0,     0,     0,     0,     0,
    2778,     0,     0,  2290,     0,   565,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   673,  2787,   969,     0,     0,     0,     0,  2791,     0,
       0,     0,   754,     0,  1431,     0,     0,     0,     0,  2290,
       0,     0,     0,   755,     0,     0,     0,     0,     0,  1597,
       0,     0,     0,     0,     0,  3142,     0,     0,     0,     0,
       0,   756,  1598,     0,     0,     0,  1431,     0,     0,  1600,
    1431,     0,     0,   565,  1601,     0,   992,     0,     0,   757,
       0,   710,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   758,     0,     0,     0,  3142,     0,     0,
       0,     0,     0,   710,     0,     0,     0,     0,     0,   710,
     759,     0,     0,     0,     0,     0,  1634,  1937,     0,     0,
    1750,     0,     0,  3142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2862,  2863,  2864,  2865,   760,     0,
       0,     0,   761,     0,     0,     0,     0,     0,   345,     0,
       0,     0,   345,     0,   762,     0,   967,     0,     0,     0,
     967,   565,     0,   565,     0,     0,     0,   565,     0,     0,
       0,  1602,   565,   565,     0,  1603,     0,     0,     0,     0,
     565,     0,  1840,     0,     0,     0,     0,   967,     0,     0,
     565,  1431,   565,  1604,  1605,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1606,     0,     0,   565,     0,
     565,     0,     0,     0,     0,   710,   710,   710,   710,  1061,
       0,   763,   967,     0,     0,     0,     0,  2436,   967,  1607,
       0,  2436,  1608,     0,  1877,  2436,     0,     0,     0,     0,
     764,  1501,     0,     0,     0,  1609,     0,  2085,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1937,     0,     0,
       0,     0,   765,     0,   766,     0,  1750,     0,     0,   767,
       0,     0,     0,     0,   565,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1597,   768,   769,     0,     0,     0,     0,     0,     0,     0,
       0,  1611,     0,  1598,   770,     0,     0,     0,     0,   771,
    1600,     0,     0,     0,  1212,  1601,   582,     0,     0,   772,
       0,     0,     0,     0,     0,     0,     0,   773,     0,     0,
       0,     0,     0,     0,   345,     0,     0,   960,     0,     0,
       0,   565,     0,     0,     0,     0,     0,   565,     0,     0,
       0,     0,     0,     0,     0,     0,   581,     0,     0,     0,
       0,     0,     0,     0,  1612,     0,     0,     0,     0,  3013,
       0,  1431,     0,     0,  1613,  1614,  1615,     0,  1616,  1617,
    1618,  1619,  1620,  1621,     0,     0,  1104,     0,     0,     0,
       0,  2030,     0,     0,  2436,     0,     0,     0,     0,  2436,
       0,     0,     0,  2436,     0,     0,     0,     0,  3044,     0,
     565,     0,  1602,   565,   565,     0,  1603,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1431,  1604,  1605,  1422,     0,  1431,     0,
    3059,     0,     0,     0,   565,     0,  1606,     0,   960,     0,
     710,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
     565,     0,     0,     0,   565,     0,     0,   710,   565,  1422,
    1607,     0,     0,  1608,  1212,   345,   565,     0,     0,   967,
       0,   565,     0,     0,     0,   967,  1609,     0,  1610,   710,
       0,     0,     0,     0,   565,     0,     0,     0,     0,   550,
       0,  1436,     0,     0,     0,     0,   574,  2436,     0,     0,
       0,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,   710,   565,     0,   967,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1436,     0,     0,     0,     0,     0,
       0,     0,  1611,     0,     0,   574,     0,   581,  1501,     0,
       0,  2306,     0,  1505,     0,     0,     0,   960,     0,     0,
       0,     0,     0,   574,     0,     0,     0,     0,     0,     0,
       0,  2154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   565,     0,     0,     0,  1597,  1212,
       0,     0,     0,   550,     0,     0,     0,     0,     0,     0,
       0,  1598,     0,     0,     0,  1612,     0, -1712,  1600,     0,
       0,  1212,     0,  1601,     0,  1613,  1614,  1615,     0,  1616,
    1617,  1618,  1619,  1620,  1621,     0,     0,     0,     0,  2672,
       0,     0,     0,  1750,     0,  1212,  1212,     0,  1212,  1212,
    1212,     0,     0,     0, -1712,     0,     0,     0,     0,     0,
       0,     0,     0,  2236,     0,  1597, -1712,     0,  1212,   960,
       0, -1712,     0,     0,     0,     0, -1712, -1712,     0, -1712,
       0,     0,     0,     0,     0,  1600,     0,     0,     0,     0,
    1601,     0,     0,   582,   582,     0,     0,     0,     0,     0,
   -1712,     0,   960,     0,     0,     0,     0,     0,     0,  1661,
       0,     0,     0,  1937,     0,     0,   565, -1712,   565,     0,
    1602,     0,     0,  2296,  1603,     0,     0,     0,     0,     0,
       0,     0,     0,  1212,     0,     0,  1212,  1212,     0,  1422,
       0,     0,  1604,  1605,   345,   345,   345,     0,     0,     0,
       0, -1712,     0,     0,  1606,     0,  1431,     0,  2685, -1712,
       0,     0,     0,     0,   582,  1422,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1431,  1607,  1431,
       0,  1608,     0,     0,     0,     0,     0, -1715,     0,     0,
       0,  1603,     0,  1431,  1609,   345,  1610,     0,     0,     0,
       0,  1422,   345,     0,  1436,   565,     0,   345,     0,  1604,
    1605,   565,   565,     0,     0,     0,     0,  1597,  1431,     0,
       0, -1715,     0,     0,     0,     0,   823,     0,  1422,     0,
    1436,     0,     0,     0,     0,     0,  1431,  1600,     0,     0,
     565,   565,  1601,     0,     0,     0,     0, -1712,  1608,   565,
    1611,     0,     0,  1422,     0,     0,     0,   565,     0,     0,
       0,  1609,   565,     0,   565, -1712,  1436,     0,     0,     0,
       0,  1431,     0,     0,   565,   565,     0,   345,     0,     0,
       0,     0,  1431,     0,     0,  1422,     0,     0,     0,  1422,
    1431,     0,     0,  1436,     0,     0, -1712,     0,     0, -1712,
   -1712, -1712,     0,     0,     0,     0,     0,     0,     0,     0,
    2686,     0,     0,  1612,     0,     0,     0, -1715,  1436,   581,
       0,     0,     0,  1613,  1614,  1615,     0,  1616,  1617,  1618,
    1619,  1620,  1621,     0,     0,     0,     0,  2736,     0, -1715,
       0,     0,     0,  1603,  1431,     0,     0,     0,  1212,     0,
    1436,   574,     0,     0,  1436,     0,  2154,     0,     0,     0,
       0,  1604,  1605,     0,     0,  1431,     0,     0,     0,     0,
       0,     0,   565, -1715,     0,     0,     0,  2505,   565,  2508,
    1612,     0,     0,     0,     0,   967,     0,     0,     0,     0,
       0,     0,  1431,  2512,  1616,  1617,  1618,  1619,  1620,  1621,
    1608,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1422,  1212,  1212,  1609,  1431,     0,     0,     0,  2525,  1212,
       0,     0,  1212,  1212,   565,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,  2154,     0,     0,     0,
       0,     0,  1212,     0,     0,     0,  1212,  1212,  1212,     0,
    1212,     0,     0,     0,     0,     0,     0,  1212,  1212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1715,
       0,  2590,     0,     0,     0,  1436,  1212,   345,     0,  1212,
    1212,     0,  2512,     0,  1212,     0,     0,    71,  1212,     0,
    2154,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,
       0,  1212,     0,     0,     0,  1212,     0,     0,     0,  1212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1612,     0,     0,     0,     0,  1597,     0,     0,
       0,     0,     0,     0,  2638,     0,  1616,  1617,  1618,  1619,
    1620,  1621,     0,     0,   345,   565,   565,  1600,     0,     0,
       0,     0,  1601,     0,     0,  2646,     0,     0,     0,     0,
     565,     0,     0,     0,     0,   565,   565,   565,   565,   565,
       0,     0,     0,     0,     0,     0,     0,   345,  1431,   345,
    1422,     0,  2667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2681,     0,     0,     0,     0,     0,
    1597,     0,     0,     0,     0,     0,     0,   565,     0,     0,
    2689,     0,   345,  1598,     0,     0,     0,     0,     0,     0,
    1600,     0,  2306,     0,     0,  1601,  1212,     0,     0,     0,
       0,     0,  1422,     0,     0,  2160,     0,  1422,     0, -1715,
       0,     0,     0,  1603,     0,     0,     0,     0,     0,     0,
       0,     0,  1422,     0,   668,   574,     0,     0,     0,   550,
       0,  1604,  1605,     0,  1431,     0,     0,     0,     0,     0,
       0,     0,     0, -1715,     0,     0,   668,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1212,  1436,     0,  2749,
    1608,     0,  1436,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1422,  1609,     0,  1212,     0,  1436,     0,     0,
       0,     0,  1602,     0,     0,     0,  1603,     0,  1937,   565,
       0,   550,   550,     0,     0,     0,     0,     0,     0,     0,
      71,    71,     0,    71,  1604,  1605,     0,     0,  1309,     0,
       0,     0,   565,     0,     0,     0,  1606,   565,     0,   565,
     565,     0,     0,     0,   565,     0,     0,     0,  2790, -1715,
       0,     0,     0,     0,     0,     0,     0,  1436,     0,     0,
    1607,   668,     0,  1608,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1609,  1597,  1610,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1212,     0,
    1598,     0,     0,   565,     0,     0,     0,  1600,     0,   565,
       0,     0,  1601,   565,     0,     0,     0,     0,  1212,     0,
       0,     0,  1612,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,  1616,  1617,  1618,  1619,
    1620,  1621,  1611,     0,     0,     0,     0,  1212,  1212,  1212,
       0,     0,  1212,     0,  2681,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1212,  1212,  1212,  1212,     0,     0,
       0,     0,     0,  1212,   550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1212,  1212,     0,  1212,     0,
       0,     0,  1212,     0,     0,  1612,     0,     0,   565,  1602,
       0,     0,     0,  1603,     0,  1613,  1614,  1615,     0,  1616,
    1617,  1618,  1619,  1620,  1621,   967,     0,  1212,  1212,  2845,
       0,  1604,  1605,     0,     0,  1422,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,     0,     0,     0,     0,     0,
       0,     0,  1212,     0,     0,     0,  1422,     0,  1422,  1212,
    1212,  1212,  1431,     0,     0,     0,     0,  1607,     0,     0,
    1608,   550,  1422,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   550,  1609,     0,  1610,     0,     0,  1212,     0,
       0,     0,     0,     0,     0,     0,     0,  1422,     0,     0,
    1436,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   574,   574,     0,  1422,     0,     0,     0,     0,
       0,  1436,     0,  1436,     0,   550,     0,     0,  1309,  2973,
    1309,     0,  1309,   565,     0,     0,     0,  1436,     0,  1611,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1422,     0,     0,     0,     0,   565,     0,     0,     0,   565,
       0,  1422,  1436,     0,     0,     0,     0,     0,     0,  1422,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   345,
    1436,     0,     0,   574,     0,   550,  1431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      71,     0,  1612,     0,    71,   565,   565,     0,     0,     0,
     565,     0,  1613,  1614,  1615,  1436,  1616,  1617,  1618,  1619,
    1620,  1621,     0,  1422,  2523,     0,  1436,     0,     0,     0,
       0,     0,     0,     0,  1436,  1597,     0,     0,     0,     0,
       0,     0,     0,     0,  1422,  1431,     0,     0,  1598,     0,
       0,     0,   565,     0,     0,  1600,  1423,   967,     0,     0,
    1601,  1597,  2590,     0,     0,     0,     0,     0,     0,     0,
       0,  1422,     0,     0,  1598,     0,     0,     0,   565,  1212,
       0,  1600,     0,     0,     0,  1212,  1601,     0,  1436,  1423,
       0,     0,     0,  1422,     0,     0,     0,  1212,     0,  1212,
       0,     0,     0,  1212,     0,     0,     0,     0,     0,  1436,
    1212,     0,     0,  1212,  1212,  1212,  1212,  1212,  1212,  1212,
    1212,  1212,  1212,     0,     0,     0,     0,  1212,  1212,     0,
       0,     0,     0,     0,   668,     0,  1436,     0,     0,     0,
       0,  1212,   964,     0,     0,     0,   964,     0,  1212,  1212,
    1212,     0,  1212,     0,     0,   550,     0,  1602,  1436,  1212,
       0,  1603,     0,     0,  1212,     0,     0,  1212,     0,     0,
       0,     0,     0,   964,     0,     0,   967,     0,     0,  1604,
    1605,     0,     0,  1602,     0,     0,  3137,  1603,     0,     0,
       0,  1606,     0,     0,     0,     0,     0,     0,  1422,     0,
       0,  1597,     0,     0,     0,  1604,  1605,     0,   964,     0,
       0,     0,     0,     0,   964,  1607,     0,  1606,  1608,  1212,
       0,  1600,     0,     0,     0,     0,  1601,     0,     0,     0,
       0,  1609,     0,  1610,     0,     0,     0,     0,     0,     0,
       0,  1607,     0,     0,  1608,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   550,     0,     0,  1609,     0,  1610,
       0,     0,     0,  1436,     0,     0,     0,  1422,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1611,     0,     0,
       0,     0,     0,     0,  2859,     0,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1611,     0,     0,     0,     0,     0,     0,
       0,  1212,     0, -1715,     0,     0,     0,  1603,     0,     0,
       0,     0,  1436,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1604,  1605,     0,     0,  1423,
    1612,     0,     0,     0,     0,     0,   550, -1715,     0,     0,
    1613,  1614,  1615,  1422,  1616,  1617,  1618,  1619,  1620,  1621,
       0,     0,     0,  1212,  2861,  1423,  1612,     0,     0,     0,
       0,     0,     0,  1212,  1608,     0,  1613,  1614,  1615,     0,
    1616,  1617,  1618,  1619,  1620,  1621,     0,  1609,     0,     0,
    3015,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1423,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1436,   550,
       0,     0,  1212,  1212,  1212,     0,     0,  1212,  1423,  1309,
       0,    71,     0,    71,     0,     0,     0,     0,     0,     0,
       0,   967,     0, -1715,     0,   967,     0,     0,     0,   967,
    1207,   668,     0,  1423,     0,   964,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1434,     0,     0,
       0,     0,     0,  1597,     0,  1423,     0,     0,     0,  1423,
       0,     0,     0,     0,     0,     0,  1598,     0,     0,     0,
     964,     0,     0,  1600,     0,     0,  1612,     0,  1601,     0,
    1434,     0,     0,     0,     0,  2206,     0,  1212,     0,     0,
    1616,  1617,  1618,  1619,  1620,  1621,     0,     0,  1422,     0,
       0,     0,   550,     0,     0,     0,   550,     0,     0,     0,
     550,     0,     0,     0,     0,     0,     0,     0,  2241,  1597,
     564,   967,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1598,     0,     0,  1207,     0,     0,     0,  1600,
       0,     0,     0,     0,  1601,     0,     0,  1212,     0,     0,
    2262,     0,     0,     0,     0,     0,  1212,  1207,  1212,     0,
       0,     0,     0,  1436,   550,     0,     0,  1212,     0,     0,
       0,     0,     0,     0,     0,  1602,     0,     0,   967,  1603,
    1423,  1207,  1207,   967,  1207,  1207,  1207,   967,     0,     0,
       0,  1212,  1212,     0,     0,     0,   800,  1604,  1605,     0,
       0,  1212,     0,     0,  1207,     0,     0,     0,     0,  1606,
       0,     0,     0,     0,   564,     0,   800,     0,  1212,     0,
       0,     0,     0,     0,     0,  2379,     0,     0,     0,     0,
    2380,  1422,   967,  1607,     0,     0,  1608,     0,     0,     0,
       0,  1602,     0,     0,     0,  1603,     0,     0,     0,  1609,
       0,  1610,     0,     0,     0,     0,     0,  1212,     0,     0,
       0,     0,     0,  1604,  1605,     0,     0,     0,     0,  1207,
       0,     0,  1207,  1207,     0,  1606,     0,     0,  1212,     0,
       0,     0,     0,     0,     0,     0,     0,  1212,     0,     0,
       0,   967,     0,     0,     0,     0,  1436,     0,     0,  1607,
       0,     0,  1608,     0,     0,  1611,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1609,     0,  1610,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1434,   967,     0,   668,     0,     0,     0,     0,     0,     0,
    1309,     0,     0,     0,     0,  1422,  1597,     0,     0,     0,
    1423,     0,     0,     0,     0,  1212,  1434,     0,  1612,  1598,
       0,  1611,     0,  2105,     0,     0,  1600,     0,  1613,  1614,
    1615,  1601,  1616,  1617,  1618,  1619,  1620,  1621,     0,     0,
       0,     0,  3083,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   668,  1422,     0,     0,     0,     0,     0,
    1436,     0,  1423,     0,     0,     0,     0,  1423,     0,  1434,
       0,     0,     0,     0,  1612,     0,     0,     0,  2106,     0,
       0,     0,  1423,   967,  1613,  1614,  1615,     0,  1616,  1617,
    1618,  1619,  1620,  1621,  1434,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2522,     0,     0,     0,     0,
       0,     0,   550,   550,     0,     0,   967,     0,  1602,  1436,
       0,   550,  1603,     0,  1207,     0,  1434,     0,     0,  1309,
    1434,     0,     0,     0,     0,     0,  2241,     0,     0,     0,
    1604,  1605,  1423,     0,     0,     0,  2560,   550,     0,     0,
       0,     0,  1606,     0,     0,     0,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1607,     0,     0,  1608,
       0,     0,     0,     0,     0,     0,     0,  1207,  1207,     0,
       0,  1597,  1609,     0,  1610,  1207,     0,     0,  1207,  1207,
       0,     0,     0,     0,  1598,     0,     0,  1599,     0,     0,
       0,  1600,     0,     0,     0,     0,  1601,     0,  1207,     0,
       0,     0,  1207,  1207,  1207,     0,  1207,     0,     0,     0,
       0,     0,     0,  1207,  1207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1611,     0,
       0,  1434,  1207,   668,     0,  1207,  1207,     0,     0,     0,
    1207,     0,     0,     0,  1207,     0,     0,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,     0,  1207,     0,     0,
       0,  1207,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,  2107,     0,     0,     0,     0,   550,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1612,     0,  1602,     0,     0,     0,  1603,     0,     0,
       0,  1613,  1614,  1615,     0,  1616,  1617,  1618,  1619,  1620,
    1621,     0,     0,     0,     0,  1604,  1605,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1606,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1607,     0,     0,  1608,  1423,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,  1609,     0,  1610,
       0,     0,     0,     0,     0,     0,  1423,     0,  1423,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   668,     0,
    1597,     0,  1423,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1207,  1598,     0,     0,  2340,   550,   550,     0,
    1600,  2158,     0,     0,     0,  1601,     0,  1423,     0,     0,
       0,     0,     0,  1611,     0,     0,     0,  2241,  2241,  2241,
    2241,  2241,     0,     0,     0,  1423,     0,     0,     0,   800,
       0,   800,     0,   800,     0,     0,     0,     0,     0,   800,
     800,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1423,     0,  1207,  1434,     0,   672,     0,     0,  1434,   550,
       0,  1423,     0,     0,     0,   674,  1612,     0,     0,  1423,
       0,  1207,     0,  1434,     0,     0,  1613,  1614,  1615,     0,
    1616,  1617,  1618,  1619,  1620,  1621,     0,     0,     0,     0,
     564,     0,  1602,     0,     0,     0,  1603,     0,     0,     0,
     707,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     748,     0,     0,   752,  1604,  1605,     0,   748,     0,     0,
       0,   796,     0,  1423,     0,     0,  1606,     0,     0,     0,
       0,     0,     0,  1434,     0,     0,     0,     0, -1714,     0,
       0,   826,     0,     0,  1423,     0,  1282,     0,     0,     0,
    1607,     0,     0,  1608,     0,     0,   748,     0,     0,     0,
       0,     0,   564,   564,  1207,     0,  1609,     0,  1610,     0,
       0,  1423,     0,     0,     0, -1714,     0,     0,     0,  1282,
    2889,   550,     0,     0,  1207,     0,     0, -1714,     0,     0,
       0,     0, -1714,  1423,     0,     0,     0, -1714, -1714,     0,
   -1714,     0,     0,     0,     0,     0,     0,     0,     0,   550,
       0,   550,   550,  1207,  1207,  1207,   550,     0,  1207,     0,
       0, -1714,  1611,     0,     0,     0,     0,     0,     0,     0,
    1207,  1207,  1207,  1207,     0,     0,     0,     0, -1714,  1207,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1207,  1207,     0,  1207,   550,     0,     0,  1207,     0,
       0,   550, -1714,     0,     0,   550,     0,     0,     0,     0,
   -1714,     0,     0,     0,     0,  1612,     0,     0,     0,     0,
       0,   964,     0,  1207,  1207,  1613,  1614,  1615,  1423,  1616,
    1617,  1618,  1619,  1620,  1621,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   564,   918,     0,  1207,     0,
       0,     0,     0,     0,     0,  1207,  1207,  1207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   823,     0,     0,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,     0,
       0,     0,  1425,     0,     0,     0,  1434,  1423, -1714,     0,
     550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1714,  1434,     0,  1434,
       0,     0,     0,     0,     0,  1425,     0,     0,     0,     0,
       0,     0,     0,  1434,     0,     0,     0,     0,     0,     0,
       0,     0,   564,     0,     0,     0,     0, -1714,     0,     0,
   -1714, -1714, -1714,   564,     0,     0,     0,     0,  1434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   668,  1434,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1423,     0,     0,   564,     0,     0,  1282,
       0,  1282,     0,  1282,     0,     0,     0,     0,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,   550,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   550,  3098,     0,
       0,   550,  3102,   964,     0,     0,   564,     0,  1597,     0,
       0,   926,   927,     0,     0,     0,     0,   800,     0,     0,
       0,  1598,     0,     0,     0,  1207,     0,     0,  1600,     0,
       0,  1207,     0,  1601,  1434,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,     0,  1207,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,  1434,  1207,     0,     0,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,     0,
       0,     0,     0,  1207,  1207,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,     0,  1207,  1207,  1207,     0,  1207,     0,
       0,     0,     0,     0,  1434,  1207,     0,     0,  1282,     0,
    1207,     0,     0,  1207,     0,     0,     0,     0,  1423,     0,
       0,     0,   964,     0,     0,     0,     0,     0,     0,     0,
    1602,     0,     0,     0,  1603,  1425,     0,     0,   977,     0,
     993,     0,     0,   996,   997,     0,     0,     0,     0,     0,
       0,     0,  1604,  1605,     0,     0,     0,     0,     0,     0,
       0,  1425,     0,  1032,  1606,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1047,   564,     0,  1048,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1607,   918,
     748,  1608,     0,     0,     0,     0,     0,  1425,  1065,     0,
       0,     0,     0,     0,  1609,     0,  1610,     0,  1072,  1434,
       0,     0,  1073,  1074,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1425,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1093,     0,  1094,     0,
       0,     0,     0,     0,   918,     0,     0,     0,     0,  1425,
       0,  1423,     0,     0,     0,     0,     0,     0,     0,     0,
    1611,     0,     0,     0,   800,     0,   800,  1207,     0,     0,
     800,     0,  1107,     0,     0,   564,   800,     0,  1434,     0,
       0,  1425,     0,   800,     0,  1425,     0,     0,     0,     0,
       0,     0,   918,   800,     0,   800,     0,     0,     0,     0,
       0,     0,     0,  2342,     0,     0,     0,     0,     0,     0,
       0,   800,     0,   800,     0,     0,     0,     0,     0,  1207,
       0,     0,     0,  1612,     0,     0,     0,     0,     0,  1207,
       0,     0,     0,  1613,  1614,  1615,     0,  1616,  1617,  1618,
    1619,  1620,  1621,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1434,  1423,     0,   564,  1207,  1207,
    1207,     0,     0,  1207,     0,     0,     0,     0,     0,     0,
       0,     0,  1318,     0,     0,  1320,     0,   964,  1322,     0,
       0,   964,     0,     0,     0,   964,  1425,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1423,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1282,     0,     0,     0,  1426,     0,
     564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1282,     0,     0,     0,  1393,     0,     0,  1597,  1394,     0,
       0,     0,  1396,  1207,     0,     0,     0,  1437,     0,     0,
    1598,  1426,     0,     0,     0,     0,     0,  1600,     0,     0,
       0,     0,  1601,     0,     0,     0,     0,     0,     0,     0,
    1463,     0,     0,     0,     0,     0,     0,   964,     0,     0,
       0,     0,     0,  1282,     0,     0,  1282,  1282,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,     0,  1495,     0,     0,     0,     0,
       0,     0,  1207,     0,  1207,     0,     0,   800,  1523,  1434,
       0,     0,     0,  1207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   564,   964,     0,     0,   564,     0,   964,
       0,   564,     0,   964,     0,     0,     0,  1207,  1207,   800,
       0,     0,     0,     0,   800,     0,  1425,  1207,     0,  1602,
       0,     0,     0,  1603,     0,     0,     0,   800,     0,     0,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,  1428,
       0,  1604,  1605,     0,     0,     0,     0,     0,   964,     0,
       0,     0,     0,  1606,     0,   564,     0,     0,     0,   962,
       0,     0,     0,   962,     0,     0,     0,     0,     0,     0,
       0,     0,  1428,  1207,     0,     0,     0,  1607,  1425,     0,
    1608,     0,     0,  1425,     0,     0,     0,     0,     0,     0,
     962,     0,     0,  1609,  1207,  1610,     0,     0,  1425,     0,
       0,     0,     0,  1207,  2355,     0,     0,   964,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,   800,     0,     0,
       0,     0,     0,     0,     0,   962,     0,     0,     0,     0,
       0,   962,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1597,     0,     0,     0,     0,     0,  1611,
       0,     0,     0,     0,     0,     0,  1598,   964,  1425,  2388,
       0,     0,     0,  1600,     0,     0,     0,     0,  1601,     0,
       0,  1426,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1745,     0,     0,     0,     0,  1426,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1612,     0,     0,     0,     0,  1204,     0,     0,
       0,     0,  1613,  1614,  1615,     0,  1616,  1617,  1618,  1619,
    1620,  1621,     0,  1426,     0,     0,  1434,     0,     0,   800,
       0,  1282,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   964,
    1426,     0,     0,     0,     0,  1602,     0,     0,     0,  1603,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1426,     0,  1604,  1605,     0,
       0,     0,   964,     0,     0,  1434,     0,     0,     0,  1606,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1426,     0,     0,
    1892,  1426,     0,  1607,     0,     0,  1608,     0,  1282,     0,
       0,     0,  1428,     0,  1282,  1282,     0,     0,     0,  1609,
       0,  1610,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1428,     0,
       0,  1930,     0,   564,   564,     0,     0,     0,     0,     0,
       0,     0,   564,     0,     0,     0,     0,  1204,     0,     0,
    1282,     0,   962,     0,     0,   800,     0,   800,   962,     0,
       0,  1425,     0,     0,  1428,  1611,     0,  2562,   564,     0,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,  1597,
       0,     0,  1425,     0,  1425,     0,     0,     0,     0,     0,
       0,  1428,  1598,     0,     0,     0,     0,   962,  1425,  1600,
       0,     0,     0,     0,  1601,     0,     0,  1432,     0,     0,
       0,     0,  1426,     0,     0,     0,  1428,     0,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,     0,  1612,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1613,  1614,
    1615,  1425,  1616,  1617,  1618,  1619,  1620,  1621,  1428,     0,
       0,     0,  1428,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1204,     0,     0,   800,     0,     0,     0,     0,
       0,   800,     0,     0,     0,  2084,  1425,     0,     0,     0,
       0,     0,     0,     0,  1204,     0,     0,  1425,     0,     0,
    2393,     0,  2089,     0,     0,  1425,     0,     0,     0,     0,
       0,  1602,     0,     0,     0,  1603,     0,     0,  1204,  1204,
       0,  1204,  1204,  1204,     0,     0,     0,   564,     0,     0,
       0,     0,     0,  1604,  1605,     0,     0,     0,     0,     0,
       0,  1204,     0,     0,     0,  1606,     0,     0,     0,     0,
       0,     0,   719,     0,     0,     0,     0,     0,     0,  1425,
       0,     0,     0,   720,     0,     0,     0,     0,     0,  1607,
       0,     0,  1608,     0,     0,     0,     0,     0,     0,     0,
    1425,   721,     0,  1428,     0,  1609,     0,  1610,     0,     0,
       0,     0,     0,     0,   918,     0,     0,   722,     0,  -428,
       0,     0,  1426,     0,     0,  2136,  1204,  1425,     0,  1204,
    1204,     0,  2141,   723,     0,     0,     0,     0,  2145,   724,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1425,
     725,     0,     0,     0,     0,     0,     0,  2167,  2168,     0,
    2170,  1611,     0,     0,     0,     0,     0,  2177,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   564,   564,
     726,  2191,   727,  2193,  1426,  2195,  2196,     0,     0,  1426,
    2201,     0,     0,   800,  -537,     0,     0,  1432,   800,   800,
     800,   800,   800,     0,  1426,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -361,     0,     0,     0,     0,
       0,     0,     0,  1432,  1612,   728,     0,     0,     0,     0,
       0,     0,     0,     0,  1613,  1614,  1615,     0,  1616,  1617,
    1618,  1619,  1620,  1621,     0,     0,     0,     0,     0,     0,
     564,     0,     0,     0,  1425,     0,     0,     0,     0,  1432,
       0,   729,     0,   730,  1426,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -361,     0,     0,  1428,     0,     0,  1432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   731,   918,     0,     0,     0,  -265,
       0,  1432,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,     0,     0,     0,
       0,  -265,   732,   733,     0,   734,     0,     0,     0,     0,
       0,  1204,     0,  1432,   735,  1428,     0,  1432,   736,   737,
    1428,     0,     0,   738,     0,     0,     0,     0,     0,   739,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,   564,     0,     0,     0,     0,     0,   962,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   800,     0,     0,     0,     0,
     564,     0,   564,   564,  1204,  1204,     0,   564,     0,     0,
       0,     0,  1204,     0,     0,  1204,  1204,     0,     0,  1425,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1204,     0,     0,     0,  1204,
    1204,  1204,     0,  1204,     0,     0,     0,     0,     0,     0,
    1204,  1204,     0,     0,     0,     0,   564,     0,     0,     0,
       0,     0,   564,     0,     0,     0,   564,     0,  1432,  1204,
       0,     0,  1204,  1204,     0,     0,     0,  1204,     0,     0,
       0,  1204,     0,     0,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,     0,  1204,     0,     0,  1426,  1204,     0,
       0,     0,  1204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1426,     0,
    1426,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1426,  2502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1426,
       0,   564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1426,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1425,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1426,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1426,  2566,  2568,  2570,     0,     0,     0,
       0,  1426,     0,     0,     0,     0,     0,     0,     0,  1204,
       0,     0,     0,     0,     0,     0,     0,     0,  2155,     0,
       0,     0,     0,     0,     0,     0,  2601,     0,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,   748,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1428,
       0,  1428,     0,     0,     0,  1426,   564,     0,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1426,     0,   564,  1204,
    1432,     0,   564,     0,     0,  1432,     0,     0,     0,     0,
    1428,     0,     0,     0,     0,     0,     0,  1425,  1204,     0,
    1432,     0,     0,  1426,     0,     0,     0,     0,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1426,     0,     0,   800,   800,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1428,  1429,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1428,     0,     0,     0,     0,     0,
    1432,     0,  1428,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1429,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1597,     0,     0,     0,
       0,  1204,     0,     0,     0,     0,  1428,     0,     0,  1598,
       0,  1425,     0,     0,     0,     0,  1600,     0,     0,     0,
    1426,  1601,     0,     0,     0,     0,     0,  1428,     0,     0,
    1204,  1204,  1204,     0,     0,  1204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1204,  1204,  1204,
    1204,     0,  2750,  2751,  1428,     0,  1204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1204,     0,     0,
    1425,     0,     0,     0,     0,     0,  1428,     0,  1204,  1204,
       0,  1204,     0,     0,     0,  1204,     0,     0,     0,  1426,
       0,     0,     0,     0,     0,     0,     0,  1430,     0,     0,
       0,     0,     0,     0,     0,  2780,     0,     0,   962,     0,
    1204,  1204,     0,     0,     0,     0,   965,     0,  1602,     0,
     965,     0,  1603,     0,     0,     0,     0,     0,     0,     0,
    1430,     0,     0,     0,     0,  1204,     0,     0,     0,     0,
    1604,  1605,  1204,  1204,  1204,     0,     0,   965,     0,     0,
       0,     0,  1606,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1204,     0,     0,     0,     0,  1607,     0,     0,  1608,
       0,  1428,   965,  1432,     0,  1426,     0,     0,   965,     0,
       0,     0,  1609,     0,  1610,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1432,     0,  1432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1432,     0,     0,     0,     0,     0,     0,  1429,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1432,     0,     0,  1611,     0,
    1428,     0,     0,  1429,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1432,     0,     0,     0,  1433,  2898,     0,
       0,     0,     0,     0,  1208,  2904,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1429,
       0,     0,     0,     0,     0,     0,     0,     0,  1432,     0,
    1433,     0,     0,     0,     0,     0,     0,     0,     0,  1432,
       0,  1612,     0,     0,     0,     0,  1429,  1432,     0,     0,
       0,  1613,  1614,  1615,     0,  1616,  1617,  1618,  1619,  1620,
    1621,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     962,  1429,     0,     0,     0,     0,  1428,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1426,     0,  1204,     0,     0,     0,     0,     0,  1204,     0,
       0,  1432,     0,  1429,     0,     0,     0,  1429,     0,     0,
    1204,     0,  1204,     0,     0,     0,  1204,     0,     0,     0,
    1430,     0,  1432,  1204,     0,     0,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,     0,     0,     0,     0,
    1204,  1204,     0,     0,     0,     0,  1430,     0,     0,  1432,
       0,     0,     0,     0,  1204,     0,     0,     0,     0,     0,
       0,  1204,  1204,  1204,  1208,  1204,     0,     0,     0,   965,
       0,  1432,  1204,     0,     0,   965,     0,  1204,     0,     0,
    1204,  1186,  1430,     0,     0,     0,     0,     0,     0,   962,
       0,  1435,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1597,     0,     0,     0,  1430,
       0,     0,     0,     0,   965,     0,     0,     0,  1598,     0,
       0,     0,     0,  1426,  1435,  1600,     0,     0,  1429,     0,
    1601,     0,  1204,     0,  1430,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1428,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1430,     0,     0,     0,
    1430,     0,     0,     0,     0,     0,  1432,     0,     0,  1208,
       0,  3075,     0,     0,     0,     0,  3077,     0,     0,     0,
    1433,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1433,     0,     0,     0,
       0,     0,     0,     0,     0,  1208,  1208,  1602,  1208,  1208,
    1208,  1603,     0,     0,  1204,     0,     0,     0,     0,     0,
       0,  1381,     0,     0,  3120,  1432,     0,  1426,  1208,  1604,
    1605,     0,  1433,     0,     0,     0,     0,     0,     0,     0,
       0,  1606,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1433,
       0,     0,     0,     0,  1428,  1607,  1204,     0,  1608,     0,
       0,  1430,     0,     0,     0,     0,  1204,     0,     0,     0,
       0,  1609,     0,  1610,  1433,     0,  1426,     0,  1429,     0,
       0,     0,     0,  1208,     0,     0,  1208,  1208,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1433,     0,     0,     0,
    1433,  1432,     0,     0,     0,  1204,  1204,  1204,     0,     0,
    1204,     0,     0,     0,     0,     0,  1539,  1611,     0,     0,
       0,     0,     0,     0,   962,     0,     0,     0,   962,     0,
    1429,     0,   962,     0,     0,  1429,  2635,     0,  1563,     0,
       0,     0,     0,     0,  1435,     0,     0,     0,     0,     0,
    1429,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1584,  1585,     0,  1586,  1587,  1589,  1428,     0,
    1435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1612,     0,     0,     0,     0,  1625,     0,     0,     0,     0,
    1613,  1614,  1615,     0,  1616,  1617,  1618,  1619,  1620,  1621,
    1204,     0,     0,     0,     0,     0,  1435,     0,     0,     0,
    1429,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1433,     0,     0,     0,     0,     0,  1428,     0,     0,
       0,  1430,     0,  1435,   962,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1691,     0,     0,  1697,  1699,     0,     0,     0,  1435,     0,
    1204,     0,     0,     0,     0,     0,     0,     0,     0,  1204,
       0,  1204,     0,     0,     0,     0,  1432,     0,     0,     0,
    1204,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
    1435,   962,     0,  1430,  1435,     0,   962,     0,  1430,     0,
     962,     0,     0,     0,  1204,  1204,     0,     0,     0,     0,
       0,     0,     0,  1430,  1204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   965,     0,     0,     0,     0,
       0,  1204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   962,     0,     0,     0,     0,
       0,  1208,  1208,     0,     0,     0,     0,     0,     0,  1208,
       0,     0,  1208,  1208,     0,     0,     0,     0,     0,     0,
    1204,     0,     0,  1430,     0,     0,     0,     0,     0,     0,
       0,     0,  1208,     0,     0,     0,  1208,  1208,  1208,     0,
    1208,  1204,     0,     0,     0,     0,     0,  1208,  1208,     0,
    1204,  2156,     0,     0,   962,     0,     0,     0,     0,  1432,
       0,     0,     0,     0,     0,  1435,  1208,     0,     0,  1208,
    1208,     0,     0,     0,  1208,     0,     0,     0,  1208,     0,
       0,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
       0,  1208,     0,  1429,     0,  1208,     0,     0,     0,  1208,
       0,     0,     0,     0,   962,     0,     0,     0,     0,     0,
       0,     0,     0,  1433,  1429,  1917,  1429,     0,  1433,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1204,     0,
    1429,     0,     0,  1433,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1429,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1429,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1432,     0,     0,  1973,     0,     0,     0,
    1975,     0,     0,  1433,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   962,     0,  1429,  1994,
       0,     0,     0,  1997,     0,     0,     0,  2008,     0,  1429,
       0,     0,     0,     0,  2015,  2020,     0,  1429,     0,     0,
       0,     0,     0,     0,     0,     0,  1208,     0,     0,   962,
       0,     0,  1432,  2031,     0,  2159,     0,  2035,     0,     0,
       0,  2046,     0,     0,     0,  2053,  1430,     0,  2055,  2056,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,     0,  2064,     0,
       0,     0,  1186,     0,     0,     0,     0,  1430,     0,  1430,
       0,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1430,     0,     0,     0,     0,     0,     0,
       0,     0,  1429,     0,     0,     0,  1208,  1435,     0,     0,
       0,     0,  1435,     0,     0,     0,     0,     0,  1430,     0,
       0,     0,     0,     0,     0,  1208,     0,  1435,     0,  1429,
       0,     0,     0,     0,     0,     0,  1430,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1430,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1430,     0,     0,     0,     0,  1435,     0,     0,
    1430,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2147,     0,     0,     0,     0,  1208,     0,
       0,     0,     0,     0,     0,     0,  2156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
       0,     0,     0,     0,  1430,     0,     0,  1433,     0,  1433,
       0,     0,     0,     0,     0,     0,  1429,     0,     0,     0,
       0,     0,     0,  1433,     0,  1430,     0,  1208,  1208,  1208,
       0,     0,  1208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2212,  1208,  1208,  1208,  1208,  1433,     0,
       0,     0,  1430,  1208,     0,     0,     0,     0,     0,     0,
       0,     0,  2233,     0,  1208,     0,  2156,     0,     0,     0,
       0,     0,     0,     0,  1430,  1208,  1208,     0,  1208,     0,
       0,     0,  1208,     0,     0,  1429,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1433,     0,     0,     0,   965,     0,  1208,  1208,     0,
       0,     0,  1433,     0,     0,     0,     0,     0,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1208,     0,     0,     0,     0,     0,     0,  1208,
    1208,  1208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
       0,     0,     0,     0,  1433,  2336,     0,     0,     0,  1430,
    1435,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1433,     0,     0,     0,     0,
       0,  1435,     0,  1435,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1435,     0,     0,
       0,  2020,  1433,  2020,  2020,     0,     0,     0,     0,     0,
    2396,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1435,     0,  1433,     0,     0,     0,  1430,     0,
       0,     0,     0,  2413,     0,  2415,     0,     0,  1623,  2418,
    1435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1435,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1435,     0,     0,  1691,
       0,     0,     0,     0,  1435,     0,  1699,  1699,  1697,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   965,     0,     0,
       0,     0,     0,     0,  1430,  2492,     0,     0,     0,  1433,
       0,     0,     0,     0,     0,     0,  1429,     0,     0,  1208,
       0,     0,     0,     0,     0,  1208,     0,     0,  1435,     0,
       0,     0,     0,     0,     0,     0,     0,  1208,     0,  1208,
       0,     0,     0,  1208,     0,     0,     0,     0,     0,  1435,
    1208,     0,     0,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,     0,     0,     0,     0,  1208,  1208,     0,
       0,     0,     0,     0,     0,     0,  1435,     0,  1433,     0,
       0,  1208,     0,     0,     0,     0,     0,     0,  1208,  1208,
    1208,     0,  1208,     0,     0,     0,     0,     0,  1435,  1208,
       0,     0,     0,     0,  1208,     0,     0,  1208,     0,     0,
       0,     0,     0,  1623,     0,     0,   965,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1429,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1433,     0,     0,     0,     0,  1430,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2632,     0,     0,     0,
       0,     0,  2636,  1435,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2641,     0,  2642,     0,     0,     0,
    2644,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2661,  2662,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1208,     0,     0,     0,     0,     0,  2677,     0,  2679,
       0,  1623,  1435,  1429,     0,     0,  2683,     0,     0,     0,
       0,  2687,     0,     0,  2690,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1623,     0,     0,     0,     0,
       0,  2004,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1430,  1208,     0,     0,  1623,  1623,  1623,  1623,
       0,  1623,     0,  1208,     0,     0,     0,     0,     0,     0,
       0,     0,  1429,  2004,     0,     0,  2729,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1433,
       0,     0,     0,     0,     0,     0,     0,  1623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1435,     0,
       0,     0,  1208,  1208,  1208,     0,     0,  1208,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   965,     0,     0,     0,   965,     0,     0,     0,   965,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1623,     0,     0,     0,     0,     0,  1623,
       0,  1623,     0,     0,     0,     0,  1430,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1208,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1433,     0,     0,     0,     0,     0,     0,     0,
    2316,     0,     0,     0,     0,  1430,     0,     0,     0,     0,
    2841,   965,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1208,     0,     0,
       0,     0,     0,     0,     0,     0,  1208,     0,  1208,     0,
       0,     0,     0,  1435,     0,     0,     0,  1208,     0,     0,
    2857,  2858,     0,     0,  2860,     0,     0,     0,   965,     0,
       0,     0,     0,   965,     0,     0,     0,   965,     0,     0,
       0,  1208,  1208,     0,     0,     0,     0,     0,     0,     0,
       0,  1208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
       0,     0,     0,     0,     0,     0,  1433,     0,     0,     0,
       0,     0,   965,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1208,     0,     0,
       0,     0,     0,     0,  2928,     0,     0,     0,     0,  1623,
       0,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
       0,     0,     0,     0,     0,  1433,     0,  1208,     0,     0,
       0,   965,     0,     0,     0,     0,  1435,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1623,     0,     0,     0,
       0,     0,     0,     0,  2316,  1623,     0,  1623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   965,     0,     0,  2974,     0,  1623,     0,     0,  1623,
       0,  2004,  2004,  2004,  2375,     0,  2004,     0,     0,     0,
    1623,     0,     0,     0,     0,  1208,     0,  1623,     0,  2990,
       0,     0,  1623,     0,     0,     0,     0,     0,  2994,     0,
       0,     0,     0,  1623,     0,     0,  2375,  1623,     0,     0,
       0,     0,     0,     0,     0,  2999,     0,     0,  1623,  2004,
       0,     0,     0,     0,     0,  1623,     0,  1623,  1623,  1623,
    1623,  1623,  1623,  1623,  1623,  1623,  1623,     0,     0,     0,
    1435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3031,     0,     0,     0,     0,     0,
       0,     0,     0,   965,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3050,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   965,     0,     0,  1435,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1623,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2994,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1623,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,  1623,     0,     7,     8,     0,
       0,     0,     0,     0,     0,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,  1623,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1623,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2375,  2375,  2375,     0,  2004,     0,     0,  2004,  2004,  2004,
    2004,  2004,  2004,  2004,  2004,  2004,  2004,     0,  2375,    37,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,  1623,     0,
       0,     0,     0,  2004,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,  2375,  1623,     0,  1623,     0,     0,
    1623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,  2004,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,     0,    53,    54,
       0,     0,     0,    55,    56,    57,    58,    59,     0,     0,
      60,    61,   933,     0,     0,     0,   934,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1623,     0,     0,     0,  1623,     0,
       0,     0,     0,  1623,  1623,     0,  1623,     0,     0,  2375,
       0,     0,     0,  2375,  2375,  2375,  2375,  2375,  2375,  2375,
    2375,  2375,  2375,  1623,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2375,  1623,
       0,  1623,     0,     0,     0,  1623,  2004,     0,     0,  1623,
       0,     0,  1623,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1623,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2375,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1623,     0,     0,     0,     0,     0,     0,
    2004,     0,  2004,     0,     0,     0,     0,     0,  2375,  1623,
    1623,     0,  1623,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2375,  2004,  2375,     0,     0,  1623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1623,     0,     0,     0,  1623,     0,     0,     0,
       0,  1623,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1623,     0,   583,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,  2375,   356,
       0,    91,  1623,    93,    94,    95,    96,    97,    98,   584,
      99,   100,   101,   357,   585,     0,   103,   104,   105,   106,
     586,   587,     0,   108,   109,   110,     0,   111,   588,   589,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   590,   374,   375,   591,   592,
     593,   594,   595,   596,   597,   376,   377,   378,   129,   379,
     380,   381,   131,   132,   133,   134,     0,   598,   382,   383,
       0,   384,   599,   600,   385,   601,   135,   387,   602,   388,
     389,   390,   391,   139,   603,   604,   392,   393,   394,   605,
     395,   396,   142,   397,   606,   398,   399,   145,   400,   607,
     608,   609,   610,   401,   402,   403,   404,   405,   148,   149,
     406,   611,   407,   612,   408,     0,   409,   410,   411,   613,
     614,   615,   412,   413,   414,   415,   616,   416,   417,   617,
     418,   618,   419,   420,   421,   155,   422,     0,   157,   619,
     423,   424,   159,   620,   425,   621,   426,   160,   622,   161,
     427,     0,   428,   623,   624,   429,   625,   430,   431,   164,
     432,   433,   434,   626,   435,   436,   437,   438,   627,   165,
     166,   628,   439,   440,   441,   629,   168,   630,   169,   631,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
     632,   173,   448,   174,   633,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,   180,
     181,   634,   462,   463,   464,   465,   182,   635,   466,   467,
     184,   468,   636,   185,   186,   469,   470,   637,   638,   471,
     639,   640,   641,   472,   473,   642,   643,   187,   188,   189,
     190,   474,   475,   476,     0,   191,   192,   477,   478,   644,
     479,   480,   481,   482,   483,   484,   194,   485,   645,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,   201,   498,   499,   500,   501,   502,   503,     0,
     646,   504,   505,   506,   647,   507,   205,   508,   509,   207,
     510,   208,   648,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,   649,   520,   521,   522,   523,   650,   211,
     212,   651,   525,   652,   526,   213,   527,   214,   653,   528,
     529,   530,   531,   532,   654,   655,   533,   534,   535,   536,
     537,   656,   657,   538,   539,   540,   221,   541,   222,   542,
       0,   658,   659,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,    79,    80,    81,     0,
       0,    83,    84,     0,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,   660,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
       0,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,     0,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,   139,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,     0,     0,   157,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
     166,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       0,   173,     0,   174,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,     0,     0,   182,     0,     0,     0,
     184,     0,     0,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
     190,     0,     0,     0,     0,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   207,
       0,   208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,     0,     0,     0,     0,     0,   211,
     212,     0,     0,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,   217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   221,     0,   222,     0,
       0,     0,     0,     0,     0,     0,    79,    80,    81,     0,
     223,    83,    84,   224,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
    2117,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,     0,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,   139,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,     0,     0,   157,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
     166,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       0,   173,     0,   174,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,     0,     0,   182,     0,     0,     0,
     184,     0,     0,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
     190,     0,     0,     0,     0,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   207,
       0,   208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,     0,     0,     0,     0,     0,   211,
     212,     0,     0,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,   217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   221,     0,   222,     0,
       0,     0,     0,    78,     0,     0,    79,    80,    81,    82,
     223,    83,    84,   224,    85,    86,    87,    88,     0,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   102,     0,     0,   103,   104,   105,   106,
    2119,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,   115,   116,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,   123,     0,   124,     0,
       0,     0,     0,     0,     0,     0,     0,   125,   126,   127,
       0,     0,     0,     0,     0,     0,     0,   128,   129,     0,
       0,   130,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,   136,
       0,   137,   138,   139,     0,     0,   140,   141,     0,     0,
       0,     0,   142,   143,   144,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,   146,     0,   147,   148,   149,
     150,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,   153,
       0,     0,     0,     0,   154,   155,   156,     0,   157,     0,
     158,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,   162,     0,   163,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
     166,     0,     0,   167,     0,     0,   168,     0,   169,     0,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       0,   173,     0,   174,     0,   175,   176,     0,     0,   177,
       0,     0,     0,     0,     0,     0,   178,     0,   179,   180,
     181,     0,     0,     0,     0,     0,   182,     0,     0,   183,
     184,     0,     0,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
     190,     0,     0,     0,     0,   191,   192,     0,   193,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,   195,
       0,   196,     0,     0,     0,   197,     0,     0,     0,   198,
     199,   200,   201,     0,     0,   202,     0,     0,     0,     0,
     203,     0,     0,     0,     0,   204,   205,     0,   206,   207,
       0,   208,    78,     0,   209,     0,     0,     0,    82,     0,
       0,   210,     0,     0,     0,     0,    88,     0,    89,   211,
     212,    92,     0,     0,     0,   213,     0,   214,     0,   215,
       0,   216,   102,     0,   217,     0,     0,   218,     0,   219,
       0,     0,     0,   220,     0,     0,   221,     0,   222,     0,
     115,   116,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,   224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,     0,
       0,     0,     0,     0,     0,   225,   125,   126,   127,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   136,     0,
     137,   138,     0,     0,     0,   140,   141,     0,     0,     0,
       0,     0,   143,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   146,     0,   147,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,   153,     0,
       0,     0,     0,   154,     0,   156,     0,     0,     0,   158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,   163,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   175,   176,     0,     0,   177,     0,
       0,     0,     0,     0,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   183,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   193,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,     0,
     196,     0,     0,     0,   197,     0,     0,     0,   198,     0,
     200,     0,     0,     0,   202,     0,     0,     0,     0,   203,
       0,     0,     0,     0,   204,     0,     0,   206,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
     216,     0,     0,     0,     0,     0,   218,     0,   219,     0,
       0,     0,   220,   583,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   584,    99,   100,
     101,   357,   585,     0,   103,   104,   105,   106,   586,   587,
       0,   108,   109,   110,   225,   111,   588,   589,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,  2079,   374,   375,     0,     0,     0,     0,
    1117,     0,     0,   376,   377,   378,   129,   379,   380,   381,
     131,  1118,   133,  1119,  1120,     0,   382,   383,     0,   384,
    1121,  1122,   385,  1123,  1124,   387,     0,   388,   389,   390,
     391,  1125,     0,     0,   392,   393,   394,     0,   395,   396,
    1126,   397,     0,   398,   399,   145,   400,  1127,  1128,  1129,
    1130,   401,   402,   403,   404,   405,  1131,  1132,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,  2080,     0,
     412,  1133,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,  1134,   422,     0,  1135,  1136,   423,   424,
    1137,     0,   425,     0,   426,   160,     0,   161,   427,     0,
     428,     0,     0,   429,     0,   430,   431,   164,   432,   433,
     434,     0,   435,   436,   437,   438,     0,   165,   166,     0,
     439,   440,   441,  1138,  1139,     0,  1140,     0,     0,   170,
     171,   442,   172,   443,   444,   445,   446,   447,     0,   173,
     448,   174,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,  1141,   180,  1142,   708,
     462,   463,   464,   465,   182,  1143,   466,   467,   184,   468,
    1144,  1145,  1146,   469,   470,     0,     0,   471,   709,     0,
       0,  1147,   473,     0,     0,   187,   188,   189,  1148,   474,
     475,   476,     0,  1149,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,  1150,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   199,   497,
    1151,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,  1152,   507,   205,   508,   509,   207,   510,  1153,
       0,   511,   512,   513,   514,   515,   516,   517,   518,  1154,
     519,     0,   520,   521,   522,   523,     0,  1155,  1156,     0,
     525,     0,   526,  1157,   527,  1158,  1159,   528,   529,   530,
     531,   532,     0,  1160,   533,   534,   535,   536,   537,  1161,
       0,   538,   539,   540,  1162,   541,   222,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,    49,
    1163,   224,   549,     0,     0,  1164,  1165,    52,  1166,    53,
       0,     0,     0,     0,  1167,  1168,  2081,     0,  1170,  1171,
       0,     0,     0,  1172,  2082,   583,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   584,
      99,   100,   101,   357,   585,     0,   103,   104,   105,   106,
     586,   587,     0,   108,   109,   110,     0,   111,   588,   589,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,  1117,     0,     0,   376,   377,   378,   129,   379,
     380,   381,   131,  1118,   133,  1119,  1120,     0,   382,   383,
       0,   384,  1121,  1122,   385,  1123,  1124,   387,     0,   388,
     389,   390,   391,  1125,     0,     0,   392,   393,   394,     0,
     395,   396,  1126,   397,     0,   398,   399,   145,   400,  1127,
    1128,  1129,  1130,   401,   402,   403,   404,   405,  1131,  1132,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1133,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,  1134,   422,     0,  1135,  1136,
     423,   424,  1137,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,   164,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,  1138,  1139,     0,  1140,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,   174,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1141,   180,
    1142,   708,   462,   463,   464,   465,   182,  1143,   466,   467,
     184,   468,  1144,  1145,  1146,   469,   470,     0,     0,   471,
     709,     0,     0,  1147,   473,     0,     0,   187,   188,   189,
    1148,   474,   475,   476,     0,  1149,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1150,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,  1151,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1152,   507,   205,   508,   509,   207,
     510,  1153,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1154,   519,     0,   520,   521,   522,   523,     0,  1155,
    1156,     0,   525,     0,   526,  1157,   527,  1158,  1159,   528,
     529,   530,   531,   532,     0,  1160,   533,   534,   535,   536,
     537,  1161,     0,   538,   539,   540,  1162,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,  1163,   224,   549,     0,     0,  1164,  1165,    52,
    1166,    53,     0,     0,     0,     0,  1167,  1168,     0,     0,
    1170,  1171,     0,     0,     0,  1172,  2006,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,  3034,   538,   539,   540,   221,   541,     0,
     542,     4,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
       0,     0,     0,     0, -1185,     0,     7,     8, -1185,     0,
       0,     0,     0,     0,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,     7,     8,     0,     0,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    40,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,    49,     0,    50,
       0,    43,     0,     0,     0,    52,     0,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   933,  1302,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,     0,     0,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   933,  1738,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,  1117,     0,     0,
     376,   377,   378,   129,   379,   380,   381,   131,  1118,   133,
    1119,  1120,  2016,   382,   383,     0,   384,  1121,  1122,   385,
    1123,  1124,   387,     0,   388,   389,   390,   391,  1125,     0,
       0,   392,   393,   394,     0,   395,   396,  1126,   397,     0,
     398,   399,   145,   400,  1127,  1128,  1129,  1130,   401,   402,
     403,   404,   405,  1131,  1132,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1133,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
    1134,   422,     0,  1135,  1136,   423,   424,  1137,     0,   425,
       0,   426,   160,  2017,   161,   427,     0,   428,     0,     0,
     429,     0,   430,   431,   164,   432,   433,   434,     0,   435,
     436,   437,   438,     0,   165,   166,     0,   439,   440,   441,
    1138,  1139,     0,  1140,     0,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,  2018,   173,   448,   174,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1141,   180,  1142,   708,   462,   463,   464,
     465,   182,  1143,   466,   467,   184,   468,  1144,  1145,  1146,
     469,   470,     0,     0,   471,   709,     0,     0,  1147,   473,
       0,     0,   187,   188,   189,  1148,   474,   475,   476,     0,
    1149,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1150,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,  1151,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,  1152,
     507,   205,   508,   509,   207,   510,  1153,     0,   511,   512,
     513,   514,   515,   516,   517,   518,  1154,   519,     0,   520,
     521,   522,   523,     0,  1155,  1156,     0,   525,  2019,   526,
    1157,   527,  1158,  1159,   528,   529,   530,   531,   532,     0,
    1160,   533,   534,   535,   536,   537,  1161,     0,   538,   539,
     540,  1162,   541,   222,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,  1163,   224,   549,
       0,     0,  1164,  1165,    52,  1166,    53,     0,     0,     0,
       0,  1167,  1168,     0,     0,  1170,  1171,     0,     0,     0,
    1172,   583,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   584,    99,   100,   101,   357,
     585,     0,   103,   104,   105,   106,   586,   587,     0,   108,
     109,   110,     0,   111,   588,   589,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,  1117,     0,
       0,   376,   377,   378,   129,   379,   380,   381,   131,  1118,
     133,  1119,  1120,     0,   382,   383,     0,   384,  1121,  1122,
     385,  1123,  1124,   387,     0,   388,   389,   390,   391,  1125,
       0,     0,   392,   393,   394,     0,   395,   396,  1126,   397,
       0,   398,   399,   145,   400,  1127,  1128,  1129,  1130,   401,
     402,   403,   404,   405,  1131,  1132,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,  1133,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,  1134,   422,     0,  1135,  1136,   423,   424,  1137,     0,
     425,     0,   426,   160,     0,   161,   427,     0,   428,     0,
       0,   429,     0,   430,   431,   164,   432,   433,   434,     0,
     435,   436,   437,   438,     0,   165,   166,     0,   439,   440,
     441,  1138,  1139,     0,  1140,     0,     0,   170,   171,   442,
     172,   443,   444,   445,   446,   447,     0,   173,   448,   174,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,  1141,   180,  1142,   708,   462,   463,
     464,   465,   182,  1143,   466,   467,   184,   468,  1144,  1145,
    1146,   469,   470,     0,     0,   471,   709,     0,     0,  1147,
     473,     0,     0,   187,   188,   189,  1148,   474,   475,   476,
       0,  1149,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,  1150,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   199,   497,  1151,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
    1152,   507,   205,   508,   509,   207,   510,  1153,     0,   511,
     512,   513,   514,   515,   516,   517,   518,  1154,   519,     0,
     520,   521,   522,   523,     0,  1155,  1156,     0,   525,     0,
     526,  1157,   527,  1158,  1159,   528,   529,   530,   531,   532,
       0,  1160,   533,   534,   535,   536,   537,  1161,     0,   538,
     539,   540,  1162,   541,   222,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,  1163,   224,
     549,     0,     0,  1164,  1165,    52,  1166,    53,     0,     0,
       0,     0,  1167,  1168,  1169,     0,  1170,  1171,     0,     0,
       0,  1172,   583,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   584,    99,   100,   101,
     357,   585,     0,   103,   104,   105,   106,   586,   587,     0,
     108,   109,   110,     0,   111,   588,   589,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,  1117,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
    1118,   133,  1119,  1120,     0,   382,   383,     0,   384,  1121,
    1122,   385,  1123,  1124,   387,     0,   388,   389,   390,   391,
    1125,     0,     0,   392,   393,   394,     0,   395,   396,  1126,
     397,     0,   398,   399,   145,   400,  1127,  1128,  1129,  1130,
     401,   402,   403,   404,   405,  1131,  1132,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
    1133,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,  1134,   422,     0,  1135,  1136,   423,   424,  1137,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,   166,     0,   439,
     440,   441,  1138,  1139,     0,  1140,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,  1141,   180,  1142,   708,   462,
     463,   464,   465,   182,  1143,   466,   467,   184,   468,  1144,
    1145,  1146,   469,   470,     0,     0,   471,   709,     0,     0,
    1147,   473,     0,     0,   187,   188,   189,  1148,   474,   475,
     476,     0,  1149,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,  1150,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,  1151,
     498,   499,   500,   501,   502,   503,     0,   203,   504,   505,
     506,  1152,   507,   205,   508,   509,   207,   510,  1153,     0,
     511,   512,   513,   514,   515,   516,   517,   518,  1154,   519,
       0,   520,   521,   522,   523,     0,  1155,  1156,     0,   525,
       0,   526,  1157,   527,  1158,  1159,   528,   529,   530,   531,
     532,     0,  1160,   533,   534,   535,   536,   537,  1161,     0,
     538,   539,   540,  1162,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,    49,  1163,
     224,   549,     0,     0,  1164,  1165,    52,  1166,    53,     0,
       0,     0,     0,  1167,  1168,     0,     0,  1170,  1171,     0,
       0,     0,  1172,   583,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   584,    99,   100,
     101,   357,   585,     0,   103,   104,   105,   106,   586,   587,
       0,   108,   109,   110,     0,   111,   588,   589,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,  1695,   374,   375,     0,     0,     0,     0,
    1117,     0,     0,   376,   377,   378,   129,   379,   380,   381,
     131,  1118,   133,  1119,  1120,     0,   382,   383,     0,   384,
    1121,  1122,   385,  1123,  1124,   387,     0,   388,   389,   390,
     391,  1125,     0,     0,   392,   393,   394,     0,   395,   396,
    1126,   397,     0,   398,   399,   145,   400,  1127,  1128,  1129,
    1130,   401,   402,   403,   404,   405,  1131,  1132,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,  1133,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,  1134,   422,     0,  1135,  1136,   423,   424,
    1137,     0,   425,     0,   426,   160,     0,   161,   427,     0,
     428,     0,     0,   429,     0,   430,   431,   164,   432,   433,
     434,     0,   435,   436,   437,   438,     0,   165,   166,     0,
     439,   440,   441,  1138,  1139,     0,  1140,     0,     0,   170,
     171,   442,   172,   443,   444,   445,   446,   447,     0,   173,
     448,   174,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,  1141,   180,  1142,   708,
     462,   463,   464,   465,   182,  1143,   466,   467,   184,   468,
    1144,  1145,  1146,   469,   470,     0,     0,   471,   709,     0,
       0,  1147,   473,     0,     0,   187,   188,   189,  1148,   474,
     475,   476,     0,  1149,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,  1150,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   199,   497,
    1151,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,  1152,   507,   205,   508,   509,   207,   510,  1153,
       0,   511,   512,   513,   514,   515,   516,   517,   518,  1154,
     519,     0,   520,   521,   522,   523,     0,  1155,  1156,     0,
     525,     0,   526,  1157,   527,  1158,  1159,   528,   529,   530,
     531,   532,     0,  1160,   533,   534,   535,   536,   537,  1161,
       0,   538,   539,   540,  1162,   541,   222,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,    49,
    1163,   224,   549,     0,     0,  1164,  1165,    52,  1166,    53,
       0,     0,     0,     0,  1167,  1168,     0,     0,  1170,  1171,
       0,     0,     0,  1172,   583,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   584,    99,
     100,   101,   357,   585,     0,   103,   104,   105,   106,   586,
     587,     0,   108,   109,   110,     0,   111,   588,   589,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,  1117,     0,     0,   376,   377,   378,   129,   379,   380,
     381,   131,  1118,   133,  1119,  1120,     0,   382,   383,     0,
     384,  1121,  1122,   385,  1123,  1124,   387,     0,   388,   389,
     390,   391,  1125,     0,     0,   392,   393,   394,     0,   395,
     396,  1126,   397,     0,   398,   399,   145,   400,  1127,  1128,
    1129,  1130,   401,   402,   403,   404,   405,  1131,  1132,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,  1133,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,  1134,   422,     0,  1135,  1136,   423,
     424,  1137,     0,   425,     0,   426,   160,     0,   161,   427,
       0,   428,     0,     0,   429,     0,   430,   431,   164,   432,
     433,   434,     0,   435,   436,   437,   438,     0,   165,   166,
       0,   439,   440,   441,  1138,  1139,     0,  1140,     0,     0,
     170,   171,   442,   172,   443,   444,   445,   446,   447,     0,
     173,   448,   174,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,  1141,   180,  1142,
     708,   462,   463,   464,   465,   182,  1143,   466,   467,   184,
     468,  1144,  1145,  1146,   469,   470,     0,     0,   471,   709,
       0,     0,  1147,   473,     0,     0,   187,   188,   189,  1148,
     474,   475,   476,     0,  1149,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,  1150,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   199,
     497,  1151,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,  1152,   507,   205,   508,   509,   207,   510,
    1153,     0,   511,   512,   513,   514,   515,   516,   517,   518,
    1154,   519,     0,   520,   521,   522,   523,     0,  1155,  1156,
       0,   525,     0,   526,  1157,   527,  1158,  1159,   528,   529,
     530,   531,   532,     0,  1160,   533,   534,   535,   536,   537,
    1161,     0,   538,   539,   540,  1162,   541,   222,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,  1163,   224,   549,     0,     0,  1164,  1165,    52,  1166,
      53,     0,     0,     0,     0,  1167,  1168,     0,     0,  1170,
    1171,     0,  1534,     0,  1172,   583,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   584,
      99,   100,   101,   357,   585,     0,   103,   104,   105,   106,
     586,   587,     0,   108,   109,   110,     0,   111,   588,   589,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,  1117,     0,     0,   376,   377,   378,   129,   379,
     380,   381,   131,  1118,   133,  1119,  1120,     0,   382,   383,
       0,   384,  1121,  1122,   385,  1123,  1124,   387,     0,   388,
     389,   390,   391,  1125,     0,     0,   392,   393,   394,     0,
     395,   396,  1126,   397,     0,   398,   399,   145,   400,  1127,
    1128,  1129,  1130,   401,   402,   403,   404,   405,  1131,  1132,
     406,  2315,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1133,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,  1134,   422,     0,  1135,  1136,
     423,   424,  1137,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,   164,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,  1138,  1139,     0,  1140,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,   174,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1141,   180,
    1142,   708,   462,   463,   464,   465,   182,  1143,   466,   467,
     184,   468,  1144,  1145,  1146,   469,   470,     0,     0,   471,
     709,     0,     0,  1147,   473,     0,     0,   187,   188,   189,
    1148,   474,   475,   476,     0,  1149,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1150,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,  1151,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1152,   507,   205,   508,   509,   207,
     510,  1153,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1154,   519,     0,   520,   521,   522,   523,     0,  1155,
    1156,     0,   525,     0,   526,  1157,   527,  1158,  1159,   528,
     529,   530,   531,   532,     0,  1160,   533,   534,   535,   536,
     537,  1161,     0,   538,   539,   540,  1162,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,  1163,   224,   549,     0,     0,  1164,  1165,    52,
    1166,    53,     0,     0,     0,     0,  1167,  1168,     0,     0,
    1170,  1171,     0,     0,     0,  1172,   583,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     584,    99,   100,   101,   357,   585,     0,   103,   104,   105,
     106,   586,   587,     0,   108,   109,   110,     0,   111,   588,
     589,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,  1117,     0,     0,   376,   377,   378,   129,
     379,   380,   381,   131,  1118,   133,  1119,  1120,     0,   382,
     383,     0,   384,  1121,  1122,   385,  1123,  1124,   387,     0,
     388,   389,   390,   391,  1125,     0,     0,   392,   393,   394,
       0,   395,   396,  1126,   397,     0,   398,   399,   145,   400,
    1127,  1128,  1129,  1130,   401,   402,   403,   404,   405,  1131,
    1132,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,  1133,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,  1134,   422,     0,  1135,
    1136,   423,   424,  1137,     0,   425,     0,   426,   160,  2017,
     161,   427,     0,   428,     0,     0,   429,     0,   430,   431,
     164,   432,   433,   434,     0,   435,   436,   437,   438,     0,
     165,   166,     0,   439,   440,   441,  1138,  1139,     0,  1140,
       0,     0,   170,   171,   442,   172,   443,   444,   445,   446,
     447,     0,   173,   448,   174,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,  1141,
     180,  1142,   708,   462,   463,   464,   465,   182,  1143,   466,
     467,   184,   468,  1144,  1145,  1146,   469,   470,     0,     0,
     471,   709,     0,     0,  1147,   473,     0,     0,   187,   188,
     189,  1148,   474,   475,   476,     0,  1149,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,  1150,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   199,   497,  1151,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,  1152,   507,   205,   508,   509,
     207,   510,  1153,     0,   511,   512,   513,   514,   515,   516,
     517,   518,  1154,   519,     0,   520,   521,   522,   523,     0,
    1155,  1156,     0,   525,     0,   526,  1157,   527,  1158,  1159,
     528,   529,   530,   531,   532,     0,  1160,   533,   534,   535,
     536,   537,  1161,     0,   538,   539,   540,  1162,   541,   222,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,    49,  1163,   224,   549,     0,     0,  1164,  1165,
      52,  1166,    53,     0,     0,     0,     0,  1167,  1168,     0,
       0,  1170,  1171,     0,     0,     0,  1172,   583,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   584,    99,   100,   101,   357,   585,     0,   103,   104,
     105,   106,   586,   587,     0,   108,   109,   110,     0,   111,
     588,   589,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,  1117,     0,     0,   376,   377,   378,
     129,   379,   380,   381,   131,  1118,   133,  1119,  1120,     0,
     382,   383,     0,   384,  1121,  1122,   385,  1123,  1124,   387,
       0,   388,   389,   390,   391,  1125,     0,     0,   392,   393,
     394,     0,   395,   396,  1126,   397,     0,   398,   399,   145,
     400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,   405,
    1131,  1132,   406,  2728,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1133,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,  1134,   422,     0,
    1135,  1136,   423,   424,  1137,     0,   425,     0,   426,   160,
       0,   161,   427,     0,   428,     0,     0,   429,     0,   430,
     431,   164,   432,   433,   434,     0,   435,   436,   437,   438,
       0,   165,   166,     0,   439,   440,   441,  1138,  1139,     0,
    1140,     0,     0,   170,   171,   442,   172,   443,   444,   445,
     446,   447,     0,   173,   448,   174,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1141,   180,  1142,   708,   462,   463,   464,   465,   182,  1143,
     466,   467,   184,   468,  1144,  1145,  1146,   469,   470,     0,
       0,   471,   709,     0,     0,  1147,   473,     0,     0,   187,
     188,   189,  1148,   474,   475,   476,     0,  1149,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1150,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,  1151,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,  1152,   507,   205,   508,
     509,   207,   510,  1153,     0,   511,   512,   513,   514,   515,
     516,   517,   518,  1154,   519,     0,   520,   521,   522,   523,
       0,  1155,  1156,     0,   525,     0,   526,  1157,   527,  1158,
    1159,   528,   529,   530,   531,   532,     0,  1160,   533,   534,
     535,   536,   537,  1161,     0,   538,   539,   540,  1162,   541,
     222,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,  1163,   224,   549,     0,     0,  1164,
    1165,    52,  1166,    53,     0,     0,     0,     0,  1167,  1168,
       0,     0,  1170,  1171,     0,     0,     0,  1172,   583,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   584,    99,   100,   101,   357,   585,     0,   103,
     104,   105,   106,   586,   587,     0,   108,   109,   110,     0,
     111,   588,   589,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,  1117,     0,     0,   376,   377,
     378,   129,   379,   380,   381,   131,  1118,   133,  1119,  1120,
       0,   382,   383,     0,   384,  1121,  1122,   385,  1123,  1124,
     387,     0,   388,   389,   390,   391,  1125,     0,     0,   392,
     393,   394,     0,   395,   396,  1126,   397,     0,   398,   399,
     145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,
     405,  1131,  1132,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1133,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,  1134,   422,
       0,  1135,  1136,   423,   424,  1137,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,   164,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,  1138,  1139,
       0,  1140,     0,     0,   170,   171,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,   174,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1141,   180,  1142,   708,   462,   463,   464,   465,   182,
    1143,   466,   467,   184,   468,  1144,  1145,  1146,   469,   470,
       0,     0,   471,   709,     0,     0,  1147,   473,     0,     0,
     187,   188,   189,  1148,   474,   475,   476,     0,  1149,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1150,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,  1151,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1152,   507,   205,
     508,   509,   207,   510,  1153,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1154,   519,     0,   520,   521,   522,
     523,     0,  1155,  1156,     0,   525,     0,   526,  1157,   527,
    1158,  1159,   528,   529,   530,   531,   532,     0,  1160,   533,
     534,   535,   536,   537,  1161,     0,   538,   539,   540,  1162,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,  1163,   224,   549,     0,     0,
    1164,  1165,    52,  1166,    53,     0,     0,     0,     0,  1167,
    1168,     0,     0,  1170,  1171,     0,     0,     0,  1172,   583,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   584,    99,   100,   101,   357,   585,     0,
     103,   104,   105,   106,   586,   587,     0,   108,   109,   110,
       0,   111,   588,   589,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,  1117,     0,     0,   376,
     377,   378,   129,   379,   380,   381,   131,  1118,   133,  1119,
    1120,     0,   382,   383,     0,   384,  1121,  1122,   385,  1123,
    1124,   387,     0,   388,   389,   390,   391,  1125,     0,     0,
     392,   393,   394,     0,   395,   396,  1126,   397,     0,   398,
     399,   145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,
     404,   405,  1131,  1132,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,  1133,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,  1134,
     422,     0,  1135,  1136,   423,   424,  1137,     0,   425,     0,
     426,   160,     0,   161,   427,     0,   428,     0,     0,   429,
       0,   430,   431,   164,   432,   433,   434,     0,   435,   436,
     437,   438,     0,   165,   166,     0,   439,   440,   441,  1138,
    1139,     0,  1140,     0,     0,   170,   171,   442,   172,   443,
     444,   445,   446,   447,     0,   173,   448,   174,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,  1141,   180,  1142,   708,   462,   463,   464,   465,
     182,     0,   466,   467,   184,   468,  1144,  1145,  1146,   469,
     470,     0,     0,   471,   709,     0,     0,  1147,   473,     0,
       0,   187,   188,   189,  1148,   474,   475,   476,     0,  1149,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
    1150,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   199,   497,  1151,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,  1152,   507,
     205,   508,   509,   207,   510,  1153,     0,   511,   512,   513,
     514,   515,   516,   517,   518,  1154,   519,     0,   520,   521,
     522,   523,     0,  1155,  1156,     0,   525,     0,   526,  1157,
     527,  1158,  1159,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,  1161,     0,   538,   539,   540,
    1162,   541,   222,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,    49,  1163,   224,   549,     0,
       0,  1164,  1165,    52,  1166,    53,     0,     0,     0,     0,
       0,  1999,     0,     0,  2000,  2001,     0,     0,     0,  1172,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,  1117,     0,     0,
     376,   377,   378,   129,   379,   380,   381,     0,  1118,   133,
    1119,  1120,     0,   382,   383,     0,   384,  1121,  1122,   385,
    1123,  1124,   387,     0,   388,   389,   390,   391,  1125,     0,
       0,   392,   393,   394,     0,   395,   396,  1126,   397,     0,
     398,   399,   145,   400,  1127,  1128,  1129,  1130,   401,   402,
     403,   404,   405,  1131,  1132,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1133,   414,
     415,     0,   416,   417,     0,     0,     0,   419,   420,   421,
    1134,   422,     0,  1135,  1136,   423,   424,  1137,     0,   425,
       0,   426,   160,     0,   161,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,   165,   166,     0,   439,   440,   441,
    1138,  1139,     0,  1140,     0,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,     0,   173,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1141,   180,  1142,   708,   462,   463,   464,
     465,   182,     0,   466,   467,   184,   468,  1144,  1145,  1146,
     469,   470,     0,     0,   471,   709,     0,     0,  1147,   473,
       0,     0,   187,   188,   189,  1148,   474,   475,   476,     0,
    1149,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1150,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,  1151,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,  1152,
     507,   205,   508,   509,     0,   510,  1153,     0,   511,   512,
     513,   514,   515,   516,   517,   518,  1154,   519,     0,   520,
     521,   522,   523,     0,  1155,  1156,     0,   525,     0,   526,
    1157,   527,  1158,  1159,   528,   529,   530,   531,   532,     0,
    1160,   533,   534,   535,   536,   537,  1161,     0,   538,   539,
     540,  1162,   541,   222,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,  1163,   224,   549,
       0,     0,  1164,  1165,    52,  1166,    53,     0,     0,     0,
       0,  1167,  1168,     0,     0,  1170,  1171,     0,     0,     0,
    1172,   583,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   584,    99,   100,   101,   357,
     585,     0,   103,   104,   105,   106,   586,   587,     0,   108,
     109,   110,     0,   111,   588,   589,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,  1117,     0,
       0,   376,   377,   378,   129,   379,   380,   381,   131,  1118,
     133,  1119,  1120,     0,   382,   383,     0,   384,  1121,  1122,
     385,  1123,  1124,   387,     0,   388,   389,   390,   391,  1125,
       0,     0,   392,   393,   394,     0,   395,   396,  1126,   397,
       0,   398,   399,   145,   400,  1127,  1128,  1129,  1130,   401,
     402,   403,   404,   405,  1131,  1132,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,  1133,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,  1134,   422,     0,  1135,  1136,   423,   424,  1137,     0,
     425,     0,   426,   160,     0,   161,   427,     0,   428,     0,
       0,   429,     0,   430,   431,   164,   432,   433,   434,     0,
     435,   436,   437,   438,     0,   165,   166,     0,   439,   440,
     441,  1138,  1139,     0,  1140,     0,     0,   170,   171,   442,
     172,   443,   444,   445,   446,   447,     0,   173,   448,   174,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,  1141,   180,  1142,   708,   462,   463,
     464,   465,   182,     0,   466,   467,   184,   468,  1144,  1145,
    1146,   469,   470,     0,     0,   471,   709,     0,     0,   472,
     473,     0,     0,   187,   188,   189,  1148,   474,   475,   476,
       0,  1149,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,  1150,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   199,   497,  1151,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
    1152,   507,   205,   508,   509,   207,   510,  1153,     0,   511,
     512,   513,   514,   515,   516,   517,   518,  1154,   519,     0,
     520,   521,   522,   523,     0,  1155,  1156,     0,   525,     0,
     526,  1157,   527,  1158,  1159,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,  1161,     0,   538,
     539,   540,  1162,   541,   222,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,     0,   224,
     549,     0,     0,  1164,  1165,    52,  1166,    53,   583,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,  1172,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   584,    99,   100,   101,   357,   585,     0,   103,
     104,   105,   106,   586,   587,     0,   108,   109,   110,     0,
     111,   588,   589,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,  1117,     0,     0,   376,   377,
     378,   129,   379,   380,   381,     0,  1118,   133,  1119,  1120,
       0,   382,   383,     0,   384,  1121,  1122,   385,  1123,  1124,
     387,     0,   388,   389,   390,   391,  1125,     0,     0,   392,
     393,   394,     0,   395,   396,  1126,   397,     0,   398,   399,
     145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,
     405,  1131,  1132,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1133,   414,   415,     0,
     416,   417,     0,     0,     0,   419,   420,   421,  1134,   422,
       0,  1135,  1136,   423,   424,  1137,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,  1138,  1139,
       0,  1140,     0,     0,   170,   171,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1141,   180,  1142,   708,   462,   463,   464,   465,   182,
       0,   466,   467,   184,   468,  1144,  1145,  1146,   469,   470,
       0,     0,   471,   709,     0,     0,     0,   473,     0,     0,
     187,   188,   189,  1148,   474,   475,   476,     0,  1149,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1150,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,  1151,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1152,   507,   205,
     508,   509,     0,   510,  1153,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1154,   519,     0,   520,   521,   522,
     523,     0,  1155,  1156,     0,   525,     0,   526,  1157,   527,
    1158,  1159,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,  1161,     0,   538,   539,   540,  1162,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,     0,     0,
    1164,  1165,    52,  1166,    53,     0,     0,     0,     0,     0,
    1999,     0,     0,  2000,  2001,     0,     0,     0,  1172,   583,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   584,    99,   100,   101,   357,   585,     0,
     103,   104,   105,   106,   586,   587,     0,   108,   109,   110,
       0,   111,   588,   589,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373, -1094,
     374,   375,     0,     0,     0, -1094,  1117,     0,     0,   376,
     377,   378,   129,   379,   380,   381,     0,  1118,   133,  1119,
    1120,     0,   382,   383,     0,   384,  1121,  1122,   385,  1123,
    1124,   387,     0,   388,   389,   390,   391,  1125,     0,     0,
     392,   393,   394,     0,   395,   396,  1126,   397,     0,   398,
     399,   145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,
     404,   405,  1131,  1132,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,  1133,   414,   415,
       0,   416,   417,     0,     0,     0,   419,   420,   421,  1134,
     422,     0,  1135,  1136,   423,   424,  1137,     0,   425,     0,
     426,   160,     0,   161,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,   165,   166,     0,   439,   440,   441,  1138,
    1139,     0,  1140,     0,     0,     0,     0,   442,   172,   443,
     444,   445,   446,   447,     0,   173,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,  1141,   180,  1142,   708,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,  1144,  1145,  1146,   469,
     470,     0,     0,   471,   709,     0,     0,     0,   473,     0,
       0,   187,   188,   189,  1148,   474,   475,   476,     0,  1149,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
    1150,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   199,   497,  1151,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,  1152,   507,
     205,   508,   509,     0,   510,  1153, -1094,   511,   512,   513,
     514,   515,   516,   517,   518,  1154,   519,     0,   520,   521,
     522,   523,     0,  1155,  1156,     0,   525,     0,   526,  1157,
     527,  1158,  1159,   528,   529,   530,   531,   532,     0,  1160,
     533,   534,   535,   536,   537,  1161,     0,   538,   539,   540,
    1162,   541,   222,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,    49,     0,   224,   549,     0,
       0,  1164,  1165,    52,  1166,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1171,     0,     0,     0,  1172,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
   -1095,   374,   375,     0,     0,     0, -1095,  1117,     0,     0,
     376,   377,   378,   129,   379,   380,   381,     0,  1118,   133,
    1119,  1120,     0,   382,   383,     0,   384,  1121,  1122,   385,
    1123,  1124,   387,     0,   388,   389,   390,   391,  1125,     0,
       0,   392,   393,   394,     0,   395,   396,  1126,   397,     0,
     398,   399,   145,   400,  1127,  1128,  1129,  1130,   401,   402,
     403,   404,   405,  1131,  1132,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1133,   414,
     415,     0,   416,   417,     0,     0,     0,   419,   420,   421,
    1134,   422,     0,  1135,  1136,   423,   424,  1137,     0,   425,
       0,   426,   160,     0,   161,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,   165,   166,     0,   439,   440,   441,
    1138,  1139,     0,  1140,     0,     0,     0,     0,   442,   172,
     443,   444,   445,   446,   447,     0,   173,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1141,   180,  1142,   708,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,  1144,  1145,  1146,
     469,   470,     0,     0,   471,   709,     0,     0,     0,   473,
       0,     0,   187,   188,   189,  1148,   474,   475,   476,     0,
    1149,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1150,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,  1151,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,  1152,
     507,   205,   508,   509,     0,   510,  1153, -1095,   511,   512,
     513,   514,   515,   516,   517,   518,  1154,   519,     0,   520,
     521,   522,   523,     0,  1155,  1156,     0,   525,     0,   526,
    1157,   527,  1158,  1159,   528,   529,   530,   531,   532,     0,
    1160,   533,   534,   535,   536,   537,  1161,     0,   538,   539,
     540,  1162,   541,   222,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,     0,   224,   549,
       0,     0,  1164,  1165,    52,  1166,    53,   583,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
    1172,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   584,    99,   100,   101,   357,   585,     0,   103,   104,
     105,   106,   586,   587,     0,   108,   109,   110,     0,   111,
     588,   589,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,  1117,     0,     0,   376,   377,   378,
     129,   379,   380,   381,     0,  1118,   133,  1119,  1120,     0,
     382,   383,     0,   384,  1121,  1122,   385,  1123,  1124,   387,
       0,   388,   389,   390,   391,  1125,     0,     0,   392,   393,
     394,     0,   395,   396,  1126,   397,     0,   398,   399,   145,
     400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,   405,
    1131,  1132,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1133,   414,   415,     0,   416,
     417,     0,     0,     0,   419,   420,   421,  1134,   422,     0,
    1135,  1136,   423,   424,  1137,     0,   425,     0,   426,   160,
       0,   161,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,   165,   166,     0,   439,   440,   441,  1138,  1139,     0,
    1140,     0,     0,     0,     0,   442,   172,   443,   444,   445,
     446,   447,     0,   173,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1141,   180,  1142,   708,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,  1145,  1146,   469,   470,     0,
       0,   471,   709,     0,     0,     0,   473,     0,     0,   187,
     188,   189,  1148,   474,   475,   476,     0,  1149,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1150,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,  1151,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,  1152,   507,   205,   508,
     509,     0,   510,  1153,     0,   511,   512,   513,   514,   515,
     516,   517,   518,  1154,   519,     0,   520,   521,   522,   523,
       0,  1155,  1156,     0,   525,     0,   526,  1157,   527,  1158,
    1159,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,  1161,     0,   538,   539,   540,  1162,   541,
     222,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,     0,   224,   549,     0,     0,  1164,
    1165,    52,  1166,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2001,     0,     0,     0,  1172,   583,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   584,    99,   100,   101,   357,   585,     0,   103,
     104,   105,   106,   586,   587,     0,   108,   109,   110,     0,
     111,   588,   589,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,  1117,     0,     0,   376,   377,
     378,   129,   379,   380,   381,     0,  1118,   133,  1119,  1120,
       0,   382,   383,     0,   384,  1121,  1122,   385,  1123,  1124,
     387,     0,   388,   389,   390,   391,  1125,     0,     0,   392,
     393,   394,     0,   395,   396,  1126,   397,     0,   398,   399,
     145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,
     405,  1131,  1132,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1133,   414,   415,     0,
     416,   417,     0,     0,     0,   419,   420,   421,  1134,   422,
       0,  1135,  1136,   423,   424,  1137,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,  1138,  1139,
       0,  1140,     0,     0,     0,     0,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1141,   180,  1142,   708,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,  1145,  1146,   469,   470,
       0,     0,   471,   709,     0,     0,     0,   473,     0,     0,
     187,   188,   189,  1148,   474,   475,   476,     0,  1149,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1150,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,  1151,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1152,   507,   205,
     508,   509,     0,   510,  1153,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1154,   519,     0,   520,   521,   522,
     523,     0,  1155,  1156,     0,   525,     0,   526,  1157,   527,
    1158,  1159,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,  1161,     0,   538,   539,   540,  1162,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,     0,     0,
    1164,  1165,    52,  1166,    53,     0,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,  1172,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,  2700,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,  -777,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,  -777,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,  -777,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,  -777,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,  -777,   471,
       0,     0,     0,   472,   473,     0,  -777,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,  -777,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     4,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1248,     7,     8,     0,
       0,     0,     0,     0,     0,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,     0,    53,    54,
       0,     0,     0,    55,    56,    57,    58,    59,     0,     0,
      60,    61,   933,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
     132,   133,   134,     0,     0,   382,   383,     0,   384,     0,
    1122,   385,   386,   135,   387,     0,   388,   389,   390,   391,
    1125,     0,     0,   392,   393,   394,     0,   395,   396,  1126,
     397,     0,   398,   399,   145,   400,  1127,  1128,  1129,  1130,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,  1135,     0,   423,   424,   159,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,   180,   181,   708,   462,
     463,   464,   465,   182,     0,   466,   467,   184,   468,     0,
    1145,   186,   469,   470,     0,     0,   471,   709,     0,   870,
     472,   473,     0,     0,   187,   188,   189,  1148,   474,   475,
     476,     0,  1149,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,   201,
     498,   499,   500,   501,   502,   503,     0,   203,   504,   505,
     506,  1152,   507,   205,   508,   509,   207,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,  1154,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,  1157,   527,  1158,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,  1161,     0,
     538,   539,   540,   221,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,     0,     0,     0,     0,     0,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,  2428,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,   129,   379,
     380,   381,   131,   132,   133,   134,     0,     0,   382,   383,
       0,   384,     0,  1122,   385,   386,   135,   387,     0,   388,
     389,   390,   391,  1125,     0,     0,   392,   393,   394,     0,
     395,   396,  1126,   397,     0,   398,   399,   145,   400,  1127,
    1128,  1129,  1130,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,  1135,     0,
     423,   424,   159,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,   164,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,   174,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,   180,
     181,   708,   462,   463,   464,   465,   182,     0,   466,   467,
     184,   468,     0,  1145,   186,   469,   470,     0,     0,   471,
     709,     0,   870,   472,   473,     0,     0,   187,   188,   189,
    1148,   474,   475,   476,     0,  1149,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1152,   507,   205,   508,   509,   207,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1154,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,  1157,   527,  1158,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,  1161,     0,   538,   539,   540,   221,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,     0,     0,     0,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,  2428,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,   129,   379,   380,   381,   131,   132,   133,   134,     0,
       0,   382,   383,     0,   384,     0,  1122,   385,   386,   135,
     387,     0,   388,   389,   390,   391,  1125,     0,     0,   392,
     393,   394,     0,   395,   396,  1126,   397,     0,   398,   399,
     145,   400,  1127,  1128,  1129,  1130,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,  1135,     0,   423,   424,   159,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,   164,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,   170,   171,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,   174,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,   180,   181,   708,   462,   463,   464,   465,   182,
       0,   466,   467,   184,   468,     0,  1145,   186,   469,   470,
       0,     0,   471,   709,     0,     0,   472,   473,     0,     0,
     187,   188,   189,  1148,   474,   475,   476,     0,  1149,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1152,   507,   205,
     508,   509,   207,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1154,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,  1157,   527,
    1158,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,  1161,     0,   538,   539,   540,   221,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,     0,     0,     0,
       0,     0,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,  2949,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,     0,   224,
     549,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2238,  2239,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,     0,   224,
     549,     0,     0,     0,     0,    52,     0,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,  2239,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,   708,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,   709,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,     0,     0,     0,     0,     0,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,  1242,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,   203,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,   549,     0,
       0,     0,     0,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,   225,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,   203,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,     0,     0,     0,     0,     0,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,   225,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,     0,     0,     0,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,  1678,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,     0,     0,     0,
       0,   583,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,  2880,    93,
      94,    95,    96,    97,    98,   584,    99,   100,   101,   357,
     585,     0,   103,   104,   105,   106,   586,   587,     0,   108,
     109,   110,     0,   111,   588,   589,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,  1402,
       0,  1403,  1120,     0,   382,   383,     0,   384,     0,     0,
     385,  1404,  1405,   387,     0,   388,   389,   390,   391,     0,
       0,     0,   392,   393,   394,     0,   395,   396,     0,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,  1406,  1407,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,  1133,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,     0,   422,     0,     0,     0,   423,   424,  1408,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,     0,     0,   439,   440,
     441,  1138,  1409,     0,  1410,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,  1411,     0,  1412,     0,   462,   463,
     464,   465,     0,     0,   466,   467,     0,   468,     0,     0,
    1413,   469,   470,     0,     0,   471,     0,     0,     0,  2537,
     473,     0,     0,     0,     0,     0,     0,   474,   475,   476,
       0,     0,     0,   477,   478,     0,   479,   480,   481,   482,
     483,   484,  1414,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,     0,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,  1415,   508,   509,     0,   510,  1416,     0,   511,
     512,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     520,   521,   522,   523,     0,  1417,  1418,     0,   525,     0,
     526,     0,   527,     0,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,  1419,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,   979,   224,
     549,     0,     0,     0,     0,    52,     0,    53,   980,   981,
     982,     0,   983,  2538,   985,   986,   987,   988,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   978,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,   979,   224,     0,     0,     0,     0,
       0,     0,     0,     0,   980,   981,   982,     0,   983,   984,
     985,   986,   987,   988,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
     979,   224,     0,     0,     0,     0,     0,     0,     0,     0,
     980,   981,   982,     0,   983,   984,   985,   986,   987,   988,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     590,   374,   375,   591,   592,   593,   594,   595,   596,   597,
     376,   377,   378,   129,   379,   380,   381,   131,   132,   133,
     134,     0,   598,   382,   383,     0,   384,   599,   600,   385,
     601,   135,   387,   602,   388,   389,   390,   391,   139,   603,
     604,   392,   393,   394,   605,   395,   396,   142,   397,   606,
     398,   399,   145,   400,   607,   608,   609,   610,   401,   402,
     403,   404,   405,   148,   149,   406,   611,   407,   612,   408,
       0,   409,   410,   411,   613,   614,   615,   412,   413,   414,
     415,   616,   416,   417,   617,   418,   618,   419,   420,   421,
     155,   422,     0,   157,   619,   423,   424,   159,   620,   425,
     621,   426,   160,   622,   161,   427,     0,   428,   623,   624,
     429,   625,   430,   431,   164,   432,   433,   434,   626,   435,
     436,   437,   438,   627,   165,   166,   628,   439,   440,   441,
     629,   168,   630,   169,   631,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,   632,   173,   448,   174,   633,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,   180,   181,   634,   462,   463,   464,
     465,   182,   635,   466,   467,   184,   468,   636,   185,   186,
     469,   470,   637,   638,   471,   639,   640,   641,   472,   473,
     642,   643,   187,   188,   189,   190,   474,   475,   476,     0,
     191,   192,   477,   478,   644,   479,   480,   481,   482,   483,
     484,   194,   485,   645,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,   201,   498,   499,
     500,   501,   502,   503,     0,   646,   504,   505,   506,   647,
     507,   205,   508,   509,   207,   510,   208,   648,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,   649,   520,
     521,   522,   523,   650,   211,   212,   651,   525,   652,   526,
     213,   527,   214,   653,   528,   529,   530,   531,   532,   654,
     655,   533,   534,   535,   536,   537,   656,   657,   538,   539,
     540,   221,   541,   222,   542,     0,   658,   659,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,     0,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,  1382,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,  1402,     0,
    1403,  1120,     0,   382,   383,     0,   384,     0,     0,   385,
    1404,  1405,   387,     0,   388,   389,   390,   391,     0,     0,
       0,   392,   393,   394,     0,   395,   396,     0,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,  1406,  1407,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1133,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
       0,   422,     0,     0,     0,   423,   424,  1408,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,     0,     0,   439,   440,   441,
    1138,  1409,     0,  1410,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1411,     0,  1412,     0,   462,   463,   464,
     465,     0,     0,   466,   467,     0,   468,     0,     0,  1413,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,     0,     0,     0,     0,   474,   475,   476,     0,
       0,     0,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1414,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,     0,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,  1415,   508,   509,     0,   510,  1416,     0,   511,   512,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   520,
     521,   522,   523,     0,  1417,  1418,     0,   525,     0,   526,
       0,   527,     0,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,  1419,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,  1748,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,   708,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,   709,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,   868,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,  1662,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
    1663,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,  1664,     0,
     471,     0,  1665,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,  1666,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,    49,     0,   224,   549,     0,     0,     0,     0,
      52,     0,    53,     0,    79,    80,    81,   354,  1277,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,  1663,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,  1664,     0,   471,     0,  1665,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,  1666,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,    49,
       0,   224,   549,     0,     0,     0,     0,    52,     0,    53,
       0,    79,    80,    81,   354,  1277,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   781,   369,   370,   371,   372,   373,
     782,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   783,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   784,   159,     0,   425,
       0,   785,     0,   786,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,   787,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   788,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   789,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   790,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   791,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,   549,
      79,    80,    81,   354,    52,    83,    84,     0,    85,    86,
      87,   355,   792,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   781,   369,   370,   371,   372,   373,   782,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   783,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   784,   159,     0,   425,     0,
     785,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   788,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   789,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   790,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   791,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,   549,    79,
      80,    81,   354,    52,    83,    84,     0,    85,    86,    87,
     355,   792,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,   572,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,  1215,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,    79,    80,
      81,   354,     0,    83,    84,  1216,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,     0,   224,   549,     0,     0,  1164,
    1165,    52,     0,    53,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,     0,   847,  1296,    79,    80,    81,   354,   848,
      83,    84,     0,    85,    86,    87,   355,   849,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   850,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   851,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   852,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   853,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   854,   212,
       0,   525,     0,   855,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,   583,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   584,    99,   100,
     101,   357,   585,     0,   103,   104,   105,   106,   586,   587,
       0,   108,   109,   110,     0,   111,   588,   589,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   590,   374,   375,   591,   592,   593,   594,
     595,   596,   597,   376,   377,   378,   129,   379,   380,   381,
     131,   132,   133,   134,     0,   598,   382,   383,     0,   384,
     599,   600,   385,   601,   135,   387,   602,   388,   389,   390,
     391,   139,   603,   604,   392,   393,   394,   605,   395,   396,
     142,   397,   606,   398,   399,   145,   400,   607,   608,   609,
     610,   401,   402,   403,   404,   405,   148,   149,   406,   611,
     407,   612,   408,     0,   409,   410,   411,   613,   614,   615,
     412,   413,   414,   415,   616,   416,   417,   617,   418,   618,
     419,   420,   421,   155,   422,     0,   157,   619,   423,   424,
     159,   620,   425,   621,   426,   160,   622,   161,   427,     0,
     428,   623,   624,   429,   625,   430,   431,   164,   432,   433,
     434,   626,   435,   436,   437,   438,   627,   165,   166,   628,
     439,   440,   441,   629,   168,   630,   169,   631,     0,   170,
     171,   442,   172,   443,   444,   445,   446,   447,   632,   173,
     448,   174,   633,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,   180,   181,   634,
     462,   463,   464,   465,   182,   635,   466,   467,   184,   468,
     636,   185,   186,   469,   470,   637,   638,   471,   639,   640,
     641,   472,   473,   642,   643,   187,   188,   189,   190,   474,
     475,   476,     0,   191,   192,   477,   478,   644,   479,   480,
     481,   482,   483,   484,   194,   485,   645,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   199,   497,
     201,   498,   499,   500,   501,   502,   503,     0,   646,   504,
     505,   506,   647,   507,   205,   508,   509,   207,   510,   208,
     648,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,   649,   520,   521,   522,   523,   650,   211,   212,   651,
     525,   652,   526,   213,   527,   214,   653,   528,   529,   530,
     531,   532,   654,   655,   533,   534,   535,   536,   537,   656,
     657,   538,   539,   540,   221,   541,   222,   542,     0,   658,
     659,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,   583,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   584,    99,   100,   101,
     357,   585,     0,   103,   104,   105,   106,   586,   587,     0,
     108,   109,   110,     0,   111,   588,   589,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
    1402,   133,  1403,  1120,     0,   382,   383,     0,   384,     0,
       0,   385,  1404,  1405,   387,     0,   388,   389,   390,   391,
       0,     0,     0,   392,   393,   394,     0,   395,   396,     0,
     397,     0,   398,   399,   145,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,  1406,  1407,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
    1133,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,     0,   422,     0,     0,     0,   423,   424,  1408,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,     0,     0,   439,
     440,   441,  1138,  1409,     0,  1410,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,  1411,   180,  1412,     0,   462,
     463,   464,   465,     0,     0,   466,   467,   184,   468,     0,
       0,  1413,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,     0,   188,   189,     0,   474,   475,
     476,     0,     0,     0,   477,   478,     0,   479,   480,   481,
     482,   483,   484,  1414,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,     0,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,  1415,   508,   509,   207,   510,  1416,     0,
     511,   512,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   520,   521,   522,   523,     0,  1417,  1418,     0,   525,
       0,   526,     0,   527,     0,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,  1419,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,    79,    80,    81,   354,     0,    83,    84,   570,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     571,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,   572,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,     0,   224,   549,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,  1308,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,  2069,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,  2070,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,   708,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,   709,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,  2071,   520,  2072,
     522,  2073,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,   549,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,   524,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,   921,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,     0,   224,   549,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,   572,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,    49,     0,   224,   549,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,  1651,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,     0,   224,   549,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,     0,   224,   549,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,   746,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   747,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,   549,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   777,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,   549,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
     549,   583,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   584,    99,   100,   101,   357,
     585,     0,   103,   104,   105,   106,   586,   587,     0,   108,
     109,   110,     0,   111,   588,   589,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,  1402,
       0,  1403,  1120,     0,   382,   383,     0,   384,     0,     0,
     385,  1404,  1405,   387,     0,   388,   389,   390,   391,     0,
       0,     0,   392,   393,   394,     0,   395,   396,     0,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,  1406,  1407,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,  1133,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,     0,   422,     0,     0,     0,   423,   424,  1408,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,     0,     0,   439,   440,
     441,  1138,  1409,     0,  1410,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,  1411,     0,  1412,     0,   462,   463,
     464,   465,  1789,     0,   466,   467,     0,   468,     0,     0,
    1413,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,     0,     0,     0,     0,   474,   475,   476,
       0,     0,     0,   477,   478,     0,   479,   480,   481,   482,
     483,   484,  1414,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,     0,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,  1415,   508,   509,     0,   510,  1416,     0,   511,
     512,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     520,   521,   522,   523,     0,  1417,  1418,     0,   525,     0,
     526,     0,   527,     0,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,  1419,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
     583,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   584,    99,   100,   101,   357,   585,
       0,   103,   104,   105,   106,   586,   587,     0,   108,   109,
     110,     0,   111,   588,   589,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,  1402,     0,
    1403,  1120,     0,   382,   383,     0,   384,     0,     0,   385,
    1404,  1405,   387,     0,   388,   389,   390,   391,     0,     0,
       0,   392,   393,   394,     0,   395,   396,     0,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,  1406,  1407,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1133,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
       0,   422,     0,     0,     0,   423,   424,  1408,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,     0,     0,   439,   440,   441,
    1138,  1409,     0,  1410,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1411,     0,  1412,     0,   462,   463,   464,
     465,  2507,     0,   466,   467,     0,   468,     0,     0,  1413,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,     0,     0,     0,     0,   474,   475,   476,     0,
       0,     0,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1414,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,     0,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,  1415,   508,   509,     0,   510,  1416,     0,   511,   512,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   520,
     521,   522,   523,     0,  1417,  1418,     0,   525,     0,   526,
       0,   527,     0,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,  1419,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,   583,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   584,    99,   100,   101,   357,   585,     0,
     103,   104,   105,   106,   586,   587,     0,   108,   109,   110,
       0,   111,   588,   589,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,  1402,     0,  1403,
    1120,     0,   382,   383,     0,   384,     0,     0,   385,  1404,
    1405,   387,     0,   388,   389,   390,   391,     0,     0,     0,
     392,   393,   394,     0,   395,   396,     0,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,  1406,  1407,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,  1133,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,     0,
     422,     0,     0,     0,   423,   424,  1408,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,     0,     0,   439,   440,   441,  1138,
    1409,     0,  1410,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,  1411,     0,  1412,     0,   462,   463,   464,   465,
       0,     0,   466,   467,     0,   468,     0,     0,  1413,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,     0,     0,     0,     0,   474,   475,   476,     0,     0,
       0,   477,   478,     0,   479,   480,   481,   482,   483,   484,
    1414,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,     0,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
    1415,   508,   509,     0,   510,  1416,     0,   511,   512,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   520,   521,
     522,   523,     0,  1417,  1418,     0,   525,     0,   526,     0,
     527,     0,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
    1419,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,   583,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   584,    99,   100,   101,   357,   585,     0,   103,
     104,   105,   106,   586,   587,     0,   108,   109,   110,     0,
     111,   588,   589,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,  1402,     0,  1403,  1120,
       0,   382,   383,     0,   384,     0,     0,   385,  1404,  1405,
     387,     0,   388,   389,   390,   391,     0,     0,     0,   392,
     393,   394,     0,   395,   396,     0,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,  1406,  1407,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1133,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,     0,   422,
       0,     0,     0,   423,   424,  1408,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,     0,     0,   439,   440,   441,  1138,  1409,
       0,  1410,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1411,     0,  1412,     0,   462,   463,   464,   465,     0,
       0,   466,   467,     0,   468,     0,     0,  1413,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
       0,     0,     0,     0,   474,   475,   476,     0,     0,     0,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1414,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,     0,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,     0,
     508,   509,     0,   510,  1416,     0,   511,   512,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   520,   521,   522,
     523,     0,  1417,  1418,     0,   525,     0,   526,     0,   527,
       0,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,  1419,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   367,
     368,   369,   370,   371,   372,   373,   590,   374,   375,   591,
     592,   593,   594,   595,   596,   597,   376,   377,   378,   129,
     379,   380,   381,   131,   132,   133,   134,     0,   598,   382,
     383,     0,   384,   599,   600,   385,     0,   135,   387,   602,
     388,   389,   390,   391,   139,   603,   604,   392,   393,   394,
     605,   395,   396,   142,   397,   606,   398,   399,   145,   400,
     607,   608,   609,   610,   401,   402,   403,     0,   405,   148,
     149,   406,   611,   407,   612,   408,     0,   409,   410,   411,
     613,   614,   615,   412,   413,   414,   415,   616,   416,   417,
     617,   418,   618,   419,   420,   421,   155,   422,     0,   157,
     619,   423,   424,   159,   620,   425,   621,   426,   160,   622,
     161,   427,     0,   428,   623,   624,   429,   625,   430,     0,
     164,   432,   433,   434,   626,   435,   436,   437,   438,   627,
     165,   166,     0,   439,   440,   441,     0,   168,   630,   169,
     631,     0,   170,   171,   442,   172,   443,   444,   445,   446,
     447,   632,   173,   448,   174,   633,   449,   450,   451,   452,
     453,   454,   455,     0,   457,   458,     0,   460,   461,   179,
     180,   181,   634,   462,   463,   464,   465,   182,   635,   466,
     467,   184,   468,   636,   185,   186,   469,   470,   637,   638,
     471,   639,   640,   641,   472,   473,   642,   643,   187,   188,
     189,   190,   474,   475,   476,     0,   191,   192,   477,   478,
     644,   479,   480,   481,   482,   483,   484,   194,   485,   645,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   199,   497,   201,   498,   499,   500,   501,   502,     0,
       0,   646,   504,   505,   506,   647,   507,   205,   508,   509,
     207,   510,   208,   648,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,   649,   520,   521,   522,   523,   650,
     211,   212,     0,   525,   652,   526,   213,   527,   214,   653,
     528,   529,   530,   531,   532,     0,   655,   533,   534,   535,
     536,   537,   656,   657,   538,   539,   540,   221,   541,   222,
     542,     0,   658,   659,   543,   544,   545,   546,     0,   548,
       0,   223,     0,     0,   224,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,   129,   379,   380,
     381,   131,   132,   133,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,   145,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,   160,     0,   161,   427,
       0,   428,     0,     0,   429,     0,   430,   431,   164,   432,
     433,   434,     0,   435,   436,   437,   438,     0,   165,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
     170,   171,   442,   172,   443,   444,   445,   446,   447,     0,
     173,   448,   174,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,   180,   181,
     708,   462,   463,   464,   465,   182,     0,   466,   467,   184,
     468,     0,   185,   186,   469,   470,     0,     0,   471,   709,
       0,     0,   472,   473,     0,     0,   187,   188,   189,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   199,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,   207,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,   222,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,  1758,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,  1759,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,  1760,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
    2269,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,  1761,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,  1762,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,   126,   127,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,   708,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,   709,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,   708,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,   709,     0,   870,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,  1506,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,  1507,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,  1508,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,   708,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,   709,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,  1509,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,  1510,  1511,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
     708,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,   709,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,   786,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
     787,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     835,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   836,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   837,   212,     0,   525,     0,   838,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   859,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   860,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   861,   212,     0,   525,     0,   862,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,  1219,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,  1228,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,  1229,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   852,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,  1223,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   854,   212,
       0,   525,     0,   855,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,  2311,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,  2565,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,  2567,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,  2569,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,  2700,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
    2714,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,  3034,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   751,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   833,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,     0,   224,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   852,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
    1223,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   854,   212,     0,   525,
       0,   855,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,  1321,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,  1531,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,    79,    80,    81,
       0,     0,    83,    84,     0,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110, -1298,   111,   112,
     113,   114,     0,     0,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,   208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
     211,   212,     0,     0,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,   217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   221,     0,   222,
       0,     0,     0,     0,     0,     0,     0,    79,    80,    81,
       0,   223,    83,    84,   224,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110, -1299,   111,   112,
     113,   114,     0,     0,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,   208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
     211,   212,     0,     0,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,   217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   221,     0,   222,
       0,     0,     0,     0,     0,     0,     0,    79,    80,    81,
       0,   223,    83,    84,   224,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110,     0,   111,   112,
     113,   114,     0,     0,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,   208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
     211,   212,     0,     0,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,   217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   221,     0,   222,
       0,     0,     0,     0,     0,     0,     0,    79,    80,    81,
       0,   223,    83,    84,   224,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110,     0,   111,   112,
     113,   114,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,   208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
     211,   212,     0,     0,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,   217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   221,     0,   222,
      79,    80,    81,     0,     0,    83,    84,     0,    85,    86,
      87,   223,     0,     0,   224,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,     0,   142,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   148,   149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,   157,     0,     0,     0,   159,     0,     0,     0,
       0,   160,     0,   161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   165,   166,     0,     0,     0,     0,     0,
     168,     0,   169,     0,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,     0,   173,     0,   174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,     0,     0,
     182,     0,     0,     0,   184,     0,     0,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   187,   188,   189,   190,     0,     0,     0,     0,   191,
     192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   199,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,   208,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,     0,     0,
       0,     0,     0,   211,   212,     0,     0,     0,     0,   213,
       0,   214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     221,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,     0,   224
};

static const short yycheck[] =
{
       2,   225,   696,    74,   850,    74,    90,   688,    90,    90,
     147,   692,   154,   689,   824,   691,  1068,   154,    90,  1043,
     710,  1353,  1476,  1004,    77,  1049,   702,    74,   112,  1431,
     112,   112,    90,   680,  1172,   729,   960,    74,   719,  1458,
     112,   941,  1307,  1156,   690,   691,   215,   855,   746,   725,
     158,   193,  1433,   128,   112,    74,   193,  1569,   219,  1921,
    1642,   737,  1446,    74,   941,    74,  1534,   908,  1446,   763,
     178,   146,  2078,   754,  2144,  1801,  1802,   723,  1474,   760,
    1446,  1849,  1446,  1708,  1480,    74,  2309,  1446,    77,  1601,
    1446,  2264,   780,  2099,  2428,   851,  1329,   853,  1681,   775,
    1083,    90,  1777,   801,  2433,  2434,  1780,  1781,   848,   941,
    1123,  1124,   758,    25,  1472,   916,    26,  1083,  1743,   936,
      42,    50,  1747,   112,    92,   111,   188,  1093,  1094,  1142,
      77,   924,   925,   217,    77,   217,   217,  1132,    82,   116,
     682,    93,    42,  2787,   111,   217,    92,   660,   128,   203,
      97,   849,    77,   116,   225,   226,   158,   226,    85,   217,
     125,    85,   158,  2381,    91,   166,   156,    91,   150,   122,
     219,    80,   203,   151,   156,  2077,   178,    29,   171,   210,
      93,   219,    74,  2927,   188,    77,   219,  2739,    92,   219,
     183,   172,   164,   281,  1596,    29,   134,    85,    90,   297,
     266,   172,   190,    91,    86,   112,  1880,   226,  1372,    74,
      85,  2953,    77,   111,    82,   226,   353,   226,     2,    77,
     112,   219,    85,   213,   217,    90,     0,  1193,   217,    77,
       8,   213,   176,  1858,  2786,  1567,    14,    15,    16,    97,
      77,   234,   302,   154,   219,   305,   277,   112,    26,    27,
      28,  1232,    30,    31,    32,   193,    77,   189,    36,    37,
      38,   156,   351,   172,   311,   325,   281,   281,   151,   295,
     960,  1195,    82,    34,   311,   268,    97,    87,   257,   342,
     219,   715,   151,   276,    83,   273,    43,   302,    45,   200,
     391,  1455,    85,   394,   347,   118,   164,   160,    77,   150,
     104,   100,   978,   350,   145,  1418,   129,   741,   371,   134,
     217,   325,   122,   350,   415,   294,   269,   415,    97,  1009,
     268,   307,   311,   383,   134,   217,  1020,    92,   417,   417,
    1011,  1231,   214,   422,   372,   151,  1017,  1389,   320,   372,
     307,  3083,   320,   369,   219,    92,   327,   351,  2900,   415,
     282,   339,   217,   325,   164,  2217,   327,   151,   347,   421,
    1007,   350,   185,   215,    92,   206,  1042,   421,   193,  2703,
    1953,   364,   421,  2707,   257,  1056,   372,  2711,  1054,   369,
     381,   215,   362,   693,   221,   416,   351,   369,   418,   361,
    1844,  1404,  1405,   703,  1070,  1533,  1534,   375,  1379,  1412,
     221,   222,    77,   312,  3148,   332,  1544,  1545,   332,   307,
    1462,  2239,  1407,    77,   377,  3059,   958,   727,   327,   311,
     418,   934,   347,   416,  2494,  2495,   219,  2645,   391,   739,
     116,   394,  1570,   415,  1572,   421,   273,   415,   415,   260,
      77,  2024,   221,   418,   332,   413,   311,  2215,  2216,   524,
     211,   761,   415,    90,   421,   347,  2224,   325,   350,  1291,
     372,  1262,   772,   415,   411,   394,   289,   413,   411,  2094,
     383,   384,   394,   421,   369,  1215,  1216,  2152,   416,   418,
     418,  1839,   347,  1284,   394,   350,  1303,  1999,  2000,  2001,
     266,   391,  2004,  1631,   394,  1288,   111,   409,    77,   399,
     257,   401,   343,   354,  1487,  1195,  2088,   407,   286,   413,
     102,    90,   416,   417,  2097,   325,    74,   421,    97,   394,
    1486,  1754,   391,   102,   399,   394,  2428,  1923,  1924,  1495,
     399,  2205,   407,   694,   385,  2047,  2870,  2866,   699,   151,
     223,  2875,   365,   418,    82,  2879,   221,  1560,  1561,  1390,
     408,   409,   410,   411,    18,   392,   118,   221,   153,  1247,
     408,   409,   410,   411,   104,   402,   403,   404,   242,   406,
     407,   408,   409,   410,   411,   391,   153,  1333,   394,   416,
     155,   151,   271,   361,   221,   406,   407,   408,   409,   410,
     411,   416,   753,   418,   312,   272,   680,   391,   680,   680,
     394,   394,   418,   143,   156,   747,   399,   199,   680,   746,
     747,   203,   295,  2238,   407,  1371,   320,   335,    18,   262,
     199,  2794,   680,   185,   203,   418,   164,   406,   407,   408,
     409,   410,   411,   190,   146,  1325,   273,   684,   253,   415,
     777,   233,   221,   222,   318,   220,   312,   684,   413,  2983,
     262,   416,   417,   171,   233,   151,   421,   156,   660,  1353,
    1506,   213,  1508,  1509,   801,  1511,   413,   262,   226,   416,
     417,   156,   212,   781,   421,   783,    77,   785,   257,   164,
     257,   260,  1329,   791,   792,   413,   198,   257,   416,   417,
    2092,   680,   307,   421,   273,   684,   275,   144,   160,   217,
    1510,  2924,   351,   369,   320,   391,   258,   259,   394,   386,
     325,   415,   849,   253,   213,  1391,   188,   179,   321,  1395,
    2052,   414,  2550,  2551,  2552,  2553,  2554,   289,   421,   415,
     242,   406,   407,   408,   409,   410,   411,   329,   421,   154,
     343,  2603,   406,   407,   408,   409,   410,   411,   391,  2145,
     329,   394,  1399,   402,   156,   392,   129,   314,   276,   375,
     259,   257,  2530,  2531,   302,   402,   403,   404,   320,   406,
     407,   408,   409,   410,   411,  2156,   234,   317,   151,   781,
     223,   783,   219,   785,   866,   200,   153,   146,   680,   791,
     792,  2880,   684,  2882,   241,   257,   243,  2193,  2194,   415,
     262,  2703,   287,   365,   266,  2707,   318,  1483,  2534,  2711,
     268,   213,   104,   392,     5,   680,   146,   369,   154,   684,
     221,   320,   379,   402,   403,   404,  1507,   406,   407,   408,
     409,   410,   411,   134,   343,   414,   183,  1683,    29,   198,
     336,   208,  1742,   339,   423,    77,   364,   193,   155,    40,
    2362,   143,   295,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,  2374,   415,   200,  1742,  2334,   383,   198,    29,
     369,   118,   273,  1567,   354,  2259,   660,   866,   125,  2017,
      40,  2259,   129,   242,   257,  1726,   245,   234,  2400,  2401,
     257,  1943,   193,  2259,   183,  2259,   358,  2986,  2036,  2295,
    2259,  2297,  2298,  2259,   366,   421,   908,  3032,   852,   189,
     221,  2813,   242,   220,   242,   245,   415,   245,   320,   198,
     212,   268,   189,  1007,   115,  1007,  1007,    12,  3115,   209,
    2555,   933,   934,   179,   936,  1007,  2356,   129,   185,   941,
    1630,  2079,  2080,   160,   224,   234,   378,   124,  1172,  1007,
     793,   231,  1599,  3078,  1795,   115,   419,  1798,  1799,   318,
     271,   253,  2382,   242,   141,    50,    93,   369,  2870,  1106,
    3157,    46,   163,  2875,   866,   137,   153,  2879,   120,   268,
     924,   925,   825,   110,  2752,   418,  2754,  2755,   318,   221,
     318,   392,   137,  3063,   337,   338,  3183,   203,   418,   321,
     192,   866,   403,   404,   210,   406,   407,   408,   409,   410,
     411,   418,    82,  1084,   206,  1084,   262,    77,  1007,    89,
     266,   343,    92,   200,   215,   317,   167,   189,   387,  3099,
     310,  1102,   102,  1102,   383,   384,    57,    97,  3044,   318,
     257,   273,   289,  1741,   189,   237,  1117,   209,   391,   266,
     177,   394,   151,    77,    75,   215,   415,   387,   128,   354,
     392,  2573,   224,  1134,   209,  1084,   415,   137,   138,   231,
     281,   277,  2934,  1084,   201,  1084,   146,   147,  3084,   224,
     150,  2983,   173,   275,   154,   415,   231,   249,   158,  1160,
     385,   302,   970,   391,   305,   295,   394,   238,   383,   384,
     227,  1172,   390,   303,   249,   393,    82,  1754,   178,   271,
    1756,    87,   358,   204,   325,  1007,   146,   415,   365,   218,
     366,   999,   322,   193,   908,  1335,   196,   197,   393,   394,
     415,  3033,   202,  1077,   204,  1445,   206,    98,   237,   394,
     281,  2723,  1007,   394,   399,  2913,   122,  1357,   310,   933,
     934,   423,   936,   345,  2556,   347,   117,   941,   134,   413,
     392,   416,   419,   417,   356,   310,   104,   421,   198,  1479,
    1846,  1847,  2684,   365,   406,   407,   408,   409,   410,   411,
     281,   308,  1253,  1254,  1266,  1256,   215,   379,   164,   414,
     391,  1299,   319,   394,  1266,  1358,   421,   221,  1361,  1362,
     138,   302,   281,   344,   281,   346,   333,  1368,  1266,   372,
     372,  1286,   242,   340,   415,   245,  2481,  2613,   281,   157,
    2601,   188,   281,   302,   325,   302,    21,   389,    77,  1231,
    1174,  1233,   170,  1235,  1932,  2631,   203,  1253,  1254,   302,
    1256,  1185,  1324,   302,   389,  1329,   184,  1329,  1329,   273,
     392,   146,   345,   380,   347,  2393,   383,  1329,  1129,  1130,
     402,   403,   404,  2109,   406,   407,   408,   409,   410,   411,
    1317,  1329,  2674,  2386,  2387,  1277,    39,  1266,  1267,  1268,
    1317,  1152,  2090,   353,  1228,   281,   391,   271,   318,   394,
    1161,   390,   391,  1517,   393,   394,   391,  1299,   271,   394,
     399,  1303,   401,   198,   118,  1307,   302,   410,   407,   415,
    1601,   383,   384,   391,   417,  1399,   394,  1399,  1399,   391,
     415,   399,   394,   401,   262,   394,   302,  1399,  1317,   407,
     399,   269,  2232,    88,    89,  1324,  2848,   151,  2850,  2180,
    1329,  1399,   356,   415,  1288,  2186,  2187,   242,   416,   325,
     245,   402,   292,   421,   203,   413,   294,   387,  2052,   417,
     390,   391,   413,   393,   394,   131,   417,   267,   392,   109,
     418,   271,   221,   421,  1266,  1267,  1268,     7,   402,   403,
     404,    11,   406,   407,   408,   409,   410,   411,  1390,   383,
     384,   304,   416,    23,    24,   377,   118,   391,  2730,  2818,
     394,  1266,  1267,  1268,   144,   418,   394,   129,   421,   391,
    1399,   399,   394,  2107,    44,   394,   345,    47,   347,   407,
     399,   415,   401,   318,   273,  1317,   115,   116,   407,   151,
     416,   153,  1324,   415,   399,   421,   401,  1329,  1546,   391,
    1548,  1751,   394,   257,  1552,  1755,  1517,  1231,   262,  1233,
    1558,  1235,  1317,   345,   524,   347,   416,  1565,  2970,  1324,
    1770,   421,   125,   415,  1329,   205,   129,  1575,   415,  1577,
    1780,  1781,  1782,  1783,   416,   289,   413,   416,   415,   421,
    2126,  2462,   421,  1793,   298,  1593,   208,  1595,   206,   416,
    2892,   416,   387,  1277,   421,   219,   421,   416,   568,   569,
    1502,   241,   421,   243,   291,    77,  1816,  1399,   227,  1819,
    1820,   416,  2436,   253,  1458,  1599,   421,  1599,  1599,  1303,
     345,   391,   347,  1307,   394,   391,   391,  1599,   394,   394,
     391,   161,  1603,   394,  1399,   257,   391,   416,  2232,   394,
     262,  1599,   421,   392,  1546,   415,  1548,   416,   421,   415,
    1552,   365,   421,   402,   403,   404,  1558,   406,   407,   408,
     409,   410,   411,  1565,   416,   391,   306,   289,   394,   421,
    1880,   138,   271,  1575,   391,  1577,   298,   394,   391,   188,
     391,   394,   416,   394,  2231,   420,   421,   421,   399,   415,
     401,  1593,    98,  1595,   334,   781,   407,   783,   415,   785,
    1253,  1254,   415,  1256,  1741,   791,  1390,   416,   175,   416,
    1599,   388,   421,  1557,   421,   391,   183,   416,   394,   689,
     690,   691,   421,   693,   223,   695,   696,   697,  2309,  1676,
     700,   701,   702,   703,   406,   407,   408,   409,   410,  1676,
    1642,   416,   120,   365,   416,  2016,   421,  2018,  2019,   221,
     720,   218,   138,   723,   416,   725,  1709,   727,  1711,   421,
     274,   731,   732,   416,   351,   735,  2342,   737,   421,   739,
    1754,   271,  1754,  1754,   416,   388,   746,   747,   416,   421,
     135,   136,  1754,   421,   416,   755,   418,  1676,   758,   175,
     416,   761,   418,   416,    98,   765,  1754,   183,   421,   769,
     770,   273,   772,   418,   388,   775,   421,  1599,  1999,  2000,
    2001,  3003,  3004,  2004,  3006,  1659,  3008,  3171,   420,   421,
    1709,  1829,  1711,   793,  1726,   795,    77,   408,   409,   410,
     416,   801,   218,   219,  1599,   421,   416,   325,   416,    90,
    1742,   421,  1744,   421,  1746,  2883,  2436,   223,   203,   406,
     407,   408,   409,   410,   187,   416,  2047,   414,  1866,   829,
     421,   416,   416,   833,   416,  1754,   421,   421,   416,   421,
     416,  1879,   416,   421,   883,   421,   885,   421,   848,   849,
     850,   851,   416,   853,  1676,   383,   384,   421,  1732,   416,
      77,   383,   384,  1795,   421,  1932,  1798,  1799,   418,   254,
     255,   421,   408,    90,  3136,   413,  2708,   415,  2710,   417,
      97,  1676,  2036,   383,   384,   102,   418,  1709,    85,  1711,
     392,  1871,  1872,  1873,  1874,   383,   384,  1829,   283,   416,
     402,   403,   404,   416,   406,   407,   408,   409,   410,   411,
    2111,  2112,   926,   927,  1709,   108,  1711,   408,   419,   215,
     419,  2161,   351,   351,   924,   925,   351,   351,   928,  1861,
     351,  1969,  1754,   169,  1866,    93,   108,   372,   423,   215,
     221,   221,   351,   415,   415,   415,    84,  1879,   415,   949,
     415,   417,   952,   281,   415,   955,   302,   342,   415,  1754,
     271,   417,   281,   418,   232,  2205,   415,   265,   227,   383,
     415,   118,   383,  2072,  2073,   113,    93,    98,   978,  1853,
     120,   383,   199,    98,   392,   383,   203,   125,   281,   374,
     227,   382,   273,   131,   402,   403,   404,   415,   406,   407,
     408,   409,   410,   411,   221,   222,   271,   145,  2962,   271,
     415,   421,  1726,   184,   232,   183,   233,   271,   415,   415,
     415,  1021,   415,   415,   162,  1025,   415,   415,  1742,  1029,
    1744,   286,  1746,  1907,  1034,  2036,   415,  1969,   415,   415,
     257,   415,  1042,   260,   415,   415,   415,   415,  2049,   415,
     415,   415,   190,  2091,  1054,  1055,   273,  1057,   275,   421,
      93,   221,   232,   415,   183,   408,   215,  2068,   206,   318,
    1070,   245,   421,   150,   371,    42,  2077,   417,    18,   421,
     415,  1795,   415,   415,  1798,  1799,   417,   351,   351,   371,
     228,   351,  1092,   351,   351,   351,   371,  2717,   351,   351,
     344,   421,   372,   351,   351,  1105,  2730,   125,   351,   271,
     352,   392,   329,   384,   421,  1115,   351,   351,   351,   351,
     415,   402,   403,   404,   415,   406,   407,   408,   409,   410,
     411,   221,   271,   269,    93,   273,   415,   377,   415,    83,
     151,  2362,   415,   415,  2365,  2366,  2367,  2368,  2369,  2370,
    2371,  2372,  2373,  2374,   292,   238,  2088,   183,   271,  2091,
      93,  2093,   317,    93,   415,   415,   372,    18,   351,   415,
     375,  3153,   402,   261,   415,   392,   314,   381,   316,    77,
    2401,   325,   421,   321,   349,   402,   403,   404,   416,   406,
     407,   408,   409,   410,   411,   421,   421,   349,   421,  2237,
    2976,   698,   415,  2943,   421,   343,   349,   415,   188,   351,
    2986,   421,   402,   354,   421,  1215,  1216,  2231,   356,  2231,
    2231,   718,  2294,   361,   416,   217,   421,  2294,  1228,  2231,
     272,   266,   234,  1233,  1234,  1235,   413,   416,    39,   415,
     409,   379,   225,  2231,  1244,   262,   225,   262,  2180,   416,
     351,   415,   392,   351,  2186,  2187,   108,   416,   421,   343,
     421,    85,   402,   403,   404,  2419,   406,   407,   408,   409,
     410,   411,   688,   302,  2428,  3051,   692,   194,   694,   391,
      93,   368,   698,   699,   221,   295,  1286,   221,  1288,   221,
    2291,   372,  2291,  2294,   402,  2294,   351,   413,   351,   402,
    2232,   183,   718,   719,   273,  2237,   271,  2239,   195,  2347,
     134,   275,  2231,  2924,   308,  2353,    93,  2249,  2319,  1319,
    2319,   818,  2421,  2422,  2423,  2424,   197,   824,   197,   183,
     416,    77,   156,  1333,   416,   832,    12,   753,   754,   244,
     188,   421,  2948,   416,   760,   416,   416,   188,   416,   416,
     174,    97,  2573,  1353,   416,   416,   102,   421,   416,   416,
      77,   388,   416,   388,   416,   416,   416,   388,   865,   188,
     415,  1371,   415,   870,   351,   416,  2250,   416,   402,  2093,
      97,   418,    35,   421,   881,   102,   416,   418,   416,   213,
     281,  1391,   415,   415,   351,  1395,   351,   416,   221,   221,
     416,   413,   818,   416,   271,   245,   379,   416,   824,  2231,
     361,   415,   269,   416,   421,  2347,   832,   416,  2419,   269,
     351,  2353,   372,   392,   271,   421,    93,  2428,  3034,   172,
     402,   172,   413,   402,   403,   404,  2231,   406,   407,   408,
     409,   410,   411,   110,   169,  1445,   416,  1447,   188,   865,
      77,   183,   116,   199,   870,   416,   416,   203,  1458,   421,
     416,   415,   351,  2684,   416,   881,  2180,   194,   421,   416,
     415,   392,  2186,  2187,   298,   221,   222,   402,   402,  1479,
     416,   351,   199,  1483,   221,   351,   203,   233,  1488,   351,
     314,   351,   221,   221,  2734,   158,   320,   415,   414,   225,
     372,  2741,   183,  2743,   221,   222,  1506,  2545,  1508,  1509,
     177,  1511,  3136,  1010,   260,   275,   233,  1517,  2232,   207,
      93,   345,    93,   347,  3135,  2399,   226,   273,   193,   415,
     415,  1531,   356,   416,   201,   416,   416,   416,   188,   415,
     257,   416,   266,   260,   224,   369,   370,   278,   416,  2481,
     415,   224,   415,   108,  1051,  1052,   273,  3168,   196,   415,
     227,  1058,   361,   262,   262,   372,   221,  1567,   153,   208,
     414,   190,   190,   188,   206,   372,   165,   174,   416,   415,
     152,   188,   152,   329,   271,   319,   351,   262,   183,   274,
     415,   224,   298,    93,  1010,  1011,   416,   415,  2599,   415,
    2599,  1017,   262,  1100,   240,   344,  2538,   293,   269,   271,
     269,   421,   329,  2545,   262,   271,   416,   415,  2550,  2551,
    2552,  2553,  2554,    96,   183,   271,    93,  2848,   127,  2850,
     344,   211,  1632,   262,   262,  1051,  1052,   165,   161,   415,
    1056,   308,  1058,   211,   312,   271,   392,   271,   421,  1649,
     369,   156,   319,   421,   174,   313,   402,   403,   404,   313,
     406,   407,   408,   409,   410,   411,   333,    81,   293,   416,
     415,  1441,   226,   340,   297,   392,  1883,  1235,  1678,  2093,
    1815,  1786,  2190,  1683,  1100,   402,   403,   404,  1884,   406,
     407,   408,   409,   410,   411,  2591,  1806,  2512,  2780,  3096,
    2594,  2141,  2703,  3126,  2608,  3074,  2707,  3073,  2940,  2747,
    2711,  3105,  3024,   380,    77,  2596,  1456,  1869,  3183,  3157,
    2765,  2764,  3138,  1443,  3184,  2231,   178,    90,  2602,  1101,
     841,  2329,  1732,  1530,    97,  1735,  2622,  3033,  1884,   102,
    2151,  1741,  2286,  2824,  3010,  1242,  3147,  1108,  3182,  2970,
     864,  1751,  1752,  1682,   156,  1755,  1756,    82,  1875,  1759,
    2320,  1084,  1930,  2616,    89,  1765,  2104,  2481,  1261,  2113,
    1770,  1260,  1679,  2428,  2709,  2984,  1415,  2398,  2589,  2232,
    1780,  1781,  1782,  1783,  1784,  1785,  2049,  1787,  1788,  2680,
    1627,  2723,  1971,  1793,  1794,  3057,  2098,  2727,  2839,  2625,
     931,  1735,  1732,   128,  1268,  1301,  1806,  1807,  1808,    74,
    1810,  1811,  1812,  1813,   312,  2747,  1816,  1817,   664,  1819,
    1820,   146,   147,  1707,  2538,   959,  1242,   927,  1055,   154,
    1938,  1742,  1106,   158,  2087,  1939,   199,  2617,  2722,  2618,
     203,  1214,  2466,  1266,  1777,   346,  1846,  1847,  1746,  1933,
    2724,   176,     2,   178,  1501,   933,    -1,    -1,   221,   222,
      -1,  1861,    -1,    -1,    -1,    -1,    -1,    -1,   193,  2870,
     233,    -1,    -1,    -1,  2875,    -1,    -1,    -1,  2879,    -1,
    1880,    -1,    -1,    -1,    -1,  2759,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,   257,    -1,    -1,   260,    -1,  1899,
      -1,    -1,    -1,    -1,  1904,    -1,    -1,    -1,    -1,    -1,
     273,  1911,   275,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1932,    -1,  2808,    -1,    -1,    -1,    -1,    -1,
    2814,    -1,    -1,    -1,  2818,    -1,    -1,    -1,  1948,    -1,
      -1,    -1,  1368,    -1,    -1,  2887,    -1,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,  2966,   329,  2966,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
    1477,  1478,  2983,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3159,    -1,    -1,    -1,  2723,
      -1,    -1,    -1,  1510,    -1,   199,    -1,    -1,   156,   203,
      -1,    -1,    -1,    -1,  1521,    -1,  2026,    -1,   353,   392,
      -1,    -1,    -1,  1530,    -1,    -1,   174,   221,   222,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,   233,
      -1,    -1,  2052,    -1,    -1,    -1,    -1,    -1,   421,    -1,
      -1,  1477,  1478,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3110,  3111,    -1,   213,   260,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,   273,
      -1,  1507,    -1,  2093,  1510,    -1,    -1,    -1,  2098,    -1,
      -1,    -1,    -1,   221,   222,  1521,    -1,    -1,    -1,  2109,
      -1,    -1,    -1,    -1,  1530,   233,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,  1626,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,   257,
      -1,   102,   260,    -1,  2144,   329,  3147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,    -1,   275,  3159,    -1,
     298,  2161,  2162,    -1,  3038,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2887,    -1,    -1,   314,    -1,  3110,  3111,
      -1,  3182,   320,    -1,    -1,  1682,  3060,    -1,    -1,    -1,
    3064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   524,
      -1,    -1,    -1,    84,    -1,  2205,    -1,   345,   392,   347,
    1626,   329,    -1,    -1,    -1,    -1,    -1,  2217,   356,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,  2239,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,  2251,  2252,  2253,    -1,    -1,    -1,   582,    -1,    -1,
     221,   222,    -1,    -1,   145,    -1,  1682,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
      -1,   162,    -1,  2283,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,  2294,    -1,    -1,    -1,   416,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,   190,
      -1,  2311,   273,   194,    -1,    -1,    -1,    -1,    -1,    -1,
    2320,    -1,    -1,    20,    -1,   206,    -1,    -1,    -1,  2329,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2342,    40,    41,    -1,   227,    -1,    -1,    46,
      -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1903,    -1,    -1,    -1,
      -1,  1908,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,   746,   747,    -1,    -1,    -1,    -1,    -1,    -1,  2429,
      -1,   392,    -1,  2433,  2434,   316,    -1,    -1,    -1,    -1,
     321,    -1,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   777,    -1,    -1,    -1,   781,    -1,   783,    -1,
     785,    -1,   343,   344,    -1,    -1,   791,   792,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,   801,    -1,    -1,    -1,
     361,    -1,    -1,    -1,    -1,   182,    -1,  1903,    -1,    -1,
     371,    -1,  1908,    -1,  2494,  2495,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,  2519,
    2520,    -1,    -1,   848,   849,    -1,    -1,   852,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   242,    -1,    -1,   245,    -1,
    2550,  2551,  2552,  2553,  2554,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,  2572,    -1,  2071,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,  2589,
      -1,  2591,    -1,    -1,  2594,    -1,  2596,    -1,    -1,   924,
     925,    -1,    74,  2603,    -1,    77,    -1,    -1,  2608,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    89,    90,    -1,
      -1,   318,  2622,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,  2071,   128,    -1,    -1,    -1,
      77,  2077,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,   146,    -1,    -1,    -1,    -1,   376,
      97,    -1,    -1,    -1,    -1,   102,    -1,  1033,    -1,    -1,
     387,    -1,    -1,   390,   391,    -1,   393,  2697,   395,    -1,
    2700,    -1,   399,    -1,   401,   402,    77,    -1,    -1,   406,
     407,   408,   409,   410,  2714,    -1,   413,   414,   415,   416,
    1066,   418,   419,   420,   421,    -1,    97,  2727,    -1,    -1,
    2730,   102,  2732,   199,  2734,  2735,    -1,   203,    -1,    -1,
      -1,  2741,  2742,  2743,    -1,   217,    -1,    -1,  2748,    -1,
      -1,    -1,  1077,   170,    -1,   221,   222,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2263,   233,    -1,    -1,
    1095,    -1,  2269,  1098,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1106,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,   170,
      -1,    -1,    -1,    -1,   221,   222,    -1,   273,    -1,   275,
      -1,    -1,    -1,  2813,    -1,    -1,   233,    -1,  2818,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,   311,
      -1,    -1,    -1,   260,    -1,    -1,    -1,  2263,    -1,  1174,
     221,   222,    -1,  2269,    -1,    -1,   273,    -1,    -1,    -1,
    1185,    -1,   233,   329,    -1,    -1,  2866,    -1,  2868,    -1,
      -1,    -1,    -1,    -1,    -1,   347,    -1,    -1,   350,    -1,
    2880,    -1,  2882,    -1,    -1,  1231,  1211,  1033,    -1,   260,
    1215,  1216,    -1,  2309,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,  1228,    -1,    -1,  1231,    -1,  1233,    -1,
    1235,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1066,    -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,  2426,
    2427,    -1,    -1,    -1,  2934,  2935,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,  2948,    -1,
     416,    -1,  2952,  2953,    -1,    -1,    -1,    -1,   329,    -1,
      -1,  1286,    -1,  1288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1299,   392,  2976,    -1,    -1,    -1,
    1326,    -1,    -1,    -1,    -1,    -1,  2986,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,    -1,    -1,
    2426,  2427,  2428,    -1,    -1,    -1,    -1,    -1,  3018,    -1,
      -1,   392,    -1,  3023,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3033,  3034,   406,   407,   408,   409,   410,
     411,    -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3051,   524,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2557,    -1,    -1,  3063,    -1,  1390,    -1,    -1,    -1,  1415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3081,  2579,  3083,    -1,    -1,    -1,    -1,  2585,    -1,
      -1,    -1,    84,    -1,  1440,    -1,    -1,    -1,    -1,  3099,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,  3115,    -1,    -1,    -1,    -1,
      -1,   113,    90,    -1,    -1,    -1,  1472,    -1,    -1,    97,
    1476,    -1,    -1,  1458,   102,    -1,  3136,    -1,    -1,   131,
      -1,  2557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   145,    -1,    -1,    -1,  3157,    -1,    -1,
      -1,    -1,    -1,  2579,    -1,    -1,    -1,    -1,    -1,  2585,
     162,    -1,    -1,    -1,    -1,    -1,  1501,  1502,    -1,    -1,
    1326,    -1,    -1,  3183,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2691,  2692,  2693,  2694,   190,    -1,
      -1,    -1,   194,    -1,    -1,    -1,    -1,    -1,   680,    -1,
      -1,    -1,   684,    -1,   206,    -1,   688,    -1,    -1,    -1,
     692,  1546,    -1,  1548,    -1,    -1,    -1,  1552,    -1,    -1,
      -1,   199,  1557,  1558,    -1,   203,    -1,    -1,    -1,    -1,
    1565,    -1,  1388,    -1,    -1,    -1,    -1,   719,    -1,    -1,
    1575,  1597,  1577,   221,   222,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,  1593,    -1,
    1595,    -1,    -1,    -1,    -1,  2691,  2692,  2693,  2694,   751,
      -1,   273,   754,    -1,    -1,    -1,    -1,  2703,   760,   257,
      -1,  2707,   260,    -1,  1440,  2711,    -1,    -1,    -1,    -1,
     292,  1626,    -1,    -1,    -1,   273,    -1,  1632,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1642,    -1,    -1,
      -1,    -1,   314,    -1,   316,    -1,  1472,    -1,    -1,   321,
      -1,    -1,    -1,    -1,  1659,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,   343,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   329,    -1,    90,   356,    -1,    -1,    -1,    -1,   361,
      97,    -1,    -1,    -1,   846,   102,   848,    -1,    -1,   371,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,
      -1,    -1,    -1,    -1,   866,    -1,    -1,  2813,    -1,    -1,
      -1,  1726,    -1,    -1,    -1,    -1,    -1,  1732,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1741,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,  2926,
      -1,  1777,    -1,    -1,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,    -1,    -1,  2943,    -1,    -1,    -1,
      -1,  1597,    -1,    -1,  2870,    -1,    -1,    -1,    -1,  2875,
      -1,    -1,    -1,  2879,    -1,    -1,    -1,    -1,  2965,    -1,
    1795,    -1,   199,  1798,  1799,    -1,   203,    -1,    -1,     2,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1839,   221,   222,  1033,    -1,  1844,    -1,
    2997,    -1,    -1,    -1,  1829,    -1,   233,    -1,  2924,    -1,
    2926,    -1,    -1,  1859,    -1,    -1,    -1,    -1,    -1,    -1,
    1845,    -1,    -1,    -1,  1849,    -1,    -1,  2943,  1853,  1066,
     257,    -1,    -1,   260,  1006,  1007,  1861,    -1,    -1,  1011,
      -1,  1866,    -1,    -1,    -1,  1017,   273,    -1,   275,  2965,
      -1,    -1,    -1,    -1,  1879,    -1,    -1,    -1,    -1,    82,
      -1,  1033,    -1,    -1,    -1,    -1,    89,  2983,    -1,    -1,
      -1,    -1,    -1,  1919,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2997,  1907,    -1,  1056,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1066,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   329,    -1,    -1,   128,    -1,  1932,  1933,    -1,
      -1,  1936,    -1,  1938,    -1,    -1,    -1,  3033,    -1,    -1,
      -1,    -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1777,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1969,    -1,    -1,    -1,    77,  1121,
      -1,    -1,    -1,   176,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    -1,   392,    -1,   134,    97,    -1,
      -1,  1143,    -1,   102,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,   416,
      -1,    -1,    -1,  1839,    -1,  1167,  1168,    -1,  1170,  1171,
    1172,    -1,    -1,    -1,   171,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1859,    -1,    77,   183,    -1,  1190,  3135,
      -1,   188,    -1,    -1,    -1,    -1,   193,   194,    -1,   196,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,  1215,  1216,    -1,    -1,    -1,    -1,    -1,
     217,    -1,  3168,    -1,    -1,    -1,    -1,    -1,    -1,  1231,
      -1,    -1,    -1,  2088,    -1,    -1,  2091,   234,  2093,    -1,
     199,    -1,    -1,  1919,   203,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1255,    -1,    -1,  1258,  1259,    -1,  1326,
      -1,    -1,   221,   222,  1266,  1267,  1268,    -1,    -1,    -1,
      -1,   268,    -1,    -1,   233,    -1,  2152,    -1,   170,   276,
      -1,    -1,    -1,    -1,  1286,  1352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,   257,  2175,
      -1,   260,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,   203,    -1,  2189,   273,  1317,   275,    -1,    -1,    -1,
      -1,  1388,  1324,    -1,  1326,  2180,    -1,  1329,    -1,   221,
     222,  2186,  2187,    -1,    -1,    -1,    -1,    77,  2214,    -1,
      -1,   233,    -1,    -1,    -1,    -1,   343,    -1,  1415,    -1,
    1352,    -1,    -1,    -1,    -1,    -1,  2232,    97,    -1,    -1,
    2215,  2216,   102,    -1,    -1,    -1,    -1,   364,   260,  2224,
     329,    -1,    -1,  1440,    -1,    -1,    -1,  2232,    -1,    -1,
      -1,   273,  2237,    -1,  2239,   382,  1388,    -1,    -1,    -1,
      -1,  2267,    -1,    -1,  2249,  2250,    -1,  1399,    -1,    -1,
      -1,    -1,  2278,    -1,    -1,  1472,    -1,    -1,    -1,  1476,
    2286,    -1,    -1,  1415,    -1,    -1,   413,    -1,    -1,   416,
     417,   418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     170,    -1,    -1,   392,    -1,    -1,    -1,   329,  1440,  2294,
      -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,    -1,    -1,   416,    -1,   199,
      -1,    -1,    -1,   203,  2340,    -1,    -1,    -1,  1470,    -1,
    1472,   524,    -1,    -1,  1476,    -1,  2152,    -1,    -1,    -1,
      -1,   221,   222,    -1,    -1,  2361,    -1,    -1,    -1,    -1,
      -1,    -1,  2347,   233,    -1,    -1,    -1,  2173,  2353,  2175,
     392,    -1,    -1,    -1,    -1,  1507,    -1,    -1,    -1,    -1,
      -1,    -1,  2388,  2189,   406,   407,   408,   409,   410,   411,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1597,  1533,  1534,   273,  2410,    -1,    -1,    -1,  2214,  1541,
      -1,    -1,  1544,  1545,  2399,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1557,  2232,    -1,    -1,    -1,
      -1,    -1,  1564,    -1,    -1,    -1,  1568,  1569,  1570,    -1,
    1572,    -1,    -1,    -1,    -1,    -1,    -1,  1579,  1580,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,
      -1,  2267,    -1,    -1,    -1,  1597,  1598,  1599,    -1,  1601,
    1602,    -1,  2278,    -1,  1606,    -1,    -1,   660,  1610,    -1,
    2286,  1613,  1614,  1615,  1616,  1617,  1618,  1619,  1620,  1621,
      -1,  1623,    -1,    -1,    -1,  1627,    -1,    -1,    -1,  1631,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,  2340,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,  1676,  2530,  2531,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,  2361,    -1,    -1,    -1,    -1,
    2545,    -1,    -1,    -1,    -1,  2550,  2551,  2552,  2553,  2554,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1709,  2584,  1711,
    1777,    -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2410,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,  2602,    -1,    -1,
     170,    -1,  1754,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,  2617,    -1,    -1,   102,  1768,    -1,    -1,    -1,
      -1,    -1,  1839,    -1,    -1,  1777,    -1,  1844,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1859,    -1,    90,   848,    -1,    -1,    -1,   852,
      -1,   221,   222,    -1,  2680,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1838,  1839,    -1,  2515,
     260,    -1,  1844,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1919,   273,    -1,  1857,    -1,  1859,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,   203,    -1,  2723,  2724,
      -1,   924,   925,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     933,   934,    -1,   936,   221,   222,    -1,    -1,   941,    -1,
      -1,    -1,  2747,    -1,    -1,    -1,   233,  2752,    -1,  2754,
    2755,    -1,    -1,    -1,  2759,    -1,    -1,    -1,  2584,   329,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1919,    -1,    -1,
     257,   217,    -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,    77,   275,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1950,    -1,
      90,    -1,    -1,  2808,    -1,    -1,    -1,    97,    -1,  2814,
      -1,    -1,   102,  2818,    -1,    -1,    -1,    -1,  1970,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,  2855,
      -1,    -1,    -1,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,   329,    -1,    -1,    -1,    -1,  1999,  2000,  2001,
      -1,    -1,  2004,    -1,  2680,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2016,  2017,  2018,  2019,    -1,    -1,
      -1,    -1,    -1,  2025,  1077,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2036,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2047,  2048,    -1,  2050,    -1,
      -1,    -1,  2054,    -1,    -1,   392,    -1,    -1,  2913,   199,
      -1,    -1,    -1,   203,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,  2077,    -1,  2079,  2080,   416,
      -1,   221,   222,    -1,    -1,  2152,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2104,    -1,    -1,    -1,  2173,    -1,  2175,  2111,
    2112,  2113,  2988,    -1,    -1,    -1,    -1,   257,    -1,    -1,
     260,  1174,  2189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1185,   273,    -1,   275,    -1,    -1,  2140,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2214,    -1,    -1,
    2152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1215,  1216,    -1,  2232,    -1,    -1,    -1,    -1,
      -1,  2173,    -1,  2175,    -1,  1228,    -1,    -1,  1231,  2855,
    1233,    -1,  1235,  3038,    -1,    -1,    -1,  2189,    -1,   329,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2267,    -1,    -1,    -1,    -1,  3060,    -1,    -1,    -1,  3064,
      -1,  2278,  2214,    -1,    -1,    -1,    -1,    -1,    -1,  2286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2231,
    2232,    -1,    -1,  1286,    -1,  1288,  3112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1303,    -1,   392,    -1,  1307,  3110,  3111,    -1,    -1,    -1,
    3115,    -1,   402,   403,   404,  2267,   406,   407,   408,   409,
     410,   411,    -1,  2340,   414,    -1,  2278,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2286,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2361,  3171,    -1,    -1,    90,    -1,
      -1,    -1,  3157,    -1,    -1,    97,  1033,  2309,    -1,    -1,
     102,    77,  2988,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2388,    -1,    -1,    90,    -1,    -1,    -1,  3183,  2331,
      -1,    97,    -1,    -1,    -1,  2337,   102,    -1,  2340,  1066,
      -1,    -1,    -1,  2410,    -1,    -1,    -1,  2349,    -1,  2351,
      -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,  2361,
    2362,    -1,    -1,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,  2374,    -1,    -1,    -1,    -1,  2379,  2380,    -1,
      -1,    -1,    -1,    -1,   680,    -1,  2388,    -1,    -1,    -1,
      -1,  2393,   688,    -1,    -1,    -1,   692,    -1,  2400,  2401,
    2402,    -1,  2404,    -1,    -1,  1458,    -1,   199,  2410,  2411,
      -1,   203,    -1,    -1,  2416,    -1,    -1,  2419,    -1,    -1,
      -1,    -1,    -1,   719,    -1,    -1,  2428,    -1,    -1,   221,
     222,    -1,    -1,   199,    -1,    -1,  3112,   203,    -1,    -1,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,  2515,    -1,
      -1,    77,    -1,    -1,    -1,   221,   222,    -1,   754,    -1,
      -1,    -1,    -1,    -1,   760,   257,    -1,   233,   260,  2471,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1557,    -1,    -1,   273,    -1,   275,
      -1,    -1,    -1,  2515,    -1,    -1,    -1,  2584,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,    -1,    -1,   170,    -1,    -1,    -1,    -1,    -1,
     846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2573,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
      -1,    -1,  2584,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,  1326,
     392,    -1,    -1,    -1,    -1,    -1,  1659,   233,    -1,    -1,
     402,   403,   404,  2680,   406,   407,   408,   409,   410,   411,
      -1,    -1,    -1,  2625,   416,  1352,   392,    -1,    -1,    -1,
      -1,    -1,    -1,  2635,   260,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,   273,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2680,  1732,
      -1,    -1,  2684,  2685,  2686,    -1,    -1,  2689,  1415,  1742,
      -1,  1744,    -1,  1746,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2703,    -1,   329,    -1,  2707,    -1,    -1,    -1,  2711,
    1006,  1007,    -1,  1440,    -1,  1011,    -1,    -1,    -1,    -1,
      -1,  1017,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1033,    -1,    -1,
      -1,    -1,    -1,    77,    -1,  1472,    -1,    -1,    -1,  1476,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
    1056,    -1,    -1,    97,    -1,    -1,   392,    -1,   102,    -1,
    1066,    -1,    -1,    -1,    -1,  1828,    -1,  2779,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,  2855,    -1,
      -1,    -1,  1845,    -1,    -1,    -1,  1849,    -1,    -1,    -1,
    1853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1861,    77,
      82,  2813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,  1121,    -1,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,  2839,    -1,    -1,
    1893,    -1,    -1,    -1,    -1,    -1,  2848,  1143,  2850,    -1,
      -1,    -1,    -1,  2855,  1907,    -1,    -1,  2859,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,  2870,   203,
    1597,  1167,  1168,  2875,  1170,  1171,  1172,  2879,    -1,    -1,
      -1,  2883,  2884,    -1,    -1,    -1,   158,   221,   222,    -1,
      -1,  2893,    -1,    -1,  1190,    -1,    -1,    -1,    -1,   233,
      -1,    -1,    -1,    -1,   176,    -1,   178,    -1,  2910,    -1,
      -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,
     188,  2988,  2924,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,  2949,    -1,    -1,
      -1,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,  1255,
      -1,    -1,  1258,  1259,    -1,   233,    -1,    -1,  2970,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2979,    -1,    -1,
      -1,  2983,    -1,    -1,    -1,    -1,  2988,    -1,    -1,   257,
      -1,    -1,   260,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,    -1,   275,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1326,  3033,    -1,  1329,    -1,    -1,    -1,    -1,    -1,    -1,
    2093,    -1,    -1,    -1,    -1,  3112,    77,    -1,    -1,    -1,
    1777,    -1,    -1,    -1,    -1,  3057,  1352,    -1,   392,    90,
      -1,   329,    -1,    94,    -1,    -1,    97,    -1,   402,   403,
     404,   102,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1399,  3171,    -1,    -1,    -1,    -1,    -1,
    3112,    -1,  1839,    -1,    -1,    -1,    -1,  1844,    -1,  1415,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,   159,    -1,
      -1,    -1,  1859,  3135,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,  1440,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2208,    -1,    -1,    -1,    -1,
      -1,    -1,  2215,  2216,    -1,    -1,  3168,    -1,   199,  3171,
      -1,  2224,   203,    -1,  1470,    -1,  1472,    -1,    -1,  2232,
    1476,    -1,    -1,    -1,    -1,    -1,  2239,    -1,    -1,    -1,
     221,   222,  1919,    -1,    -1,    -1,  2249,  2250,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1533,  1534,    -1,
      -1,    77,   273,    -1,   275,  1541,    -1,    -1,  1544,  1545,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,  1564,    -1,
      -1,    -1,  1568,  1569,  1570,    -1,  1572,    -1,    -1,    -1,
      -1,    -1,    -1,  1579,  1580,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,  1597,  1598,  1599,    -1,  1601,  1602,    -1,    -1,    -1,
    1606,    -1,    -1,    -1,  1610,    -1,    -1,  1613,  1614,  1615,
    1616,  1617,  1618,  1619,  1620,  1621,    -1,  1623,    -1,    -1,
      -1,  1627,    -1,    -1,    -1,  1631,    -1,    -1,    -1,    -1,
      -1,   372,    -1,    -1,    -1,    -1,  2399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,  2152,    -1,    -1,  2481,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,  2173,    -1,  2175,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,    -1,
      77,    -1,  2189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1768,    90,    -1,    -1,    93,  2530,  2531,    -1,
      97,  1777,    -1,    -1,    -1,   102,    -1,  2214,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,  2550,  2551,  2552,
    2553,  2554,    -1,    -1,    -1,  2232,    -1,    -1,    -1,   781,
      -1,   783,    -1,   785,    -1,    -1,    -1,    -1,    -1,   791,
     792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2267,    -1,  1838,  1839,    -1,    92,    -1,    -1,  1844,  2602,
      -1,  2278,    -1,    -1,    -1,   102,   392,    -1,    -1,  2286,
      -1,  1857,    -1,  1859,    -1,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,
     852,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     147,    -1,    -1,   150,   221,   222,    -1,   154,    -1,    -1,
      -1,   158,    -1,  2340,    -1,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,  1919,    -1,    -1,    -1,    -1,   134,    -1,
      -1,   178,    -1,    -1,  2361,    -1,   908,    -1,    -1,    -1,
     257,    -1,    -1,   260,    -1,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   924,   925,  1950,    -1,   273,    -1,   275,    -1,
      -1,  2388,    -1,    -1,    -1,   171,    -1,    -1,    -1,   941,
    2723,  2724,    -1,    -1,  1970,    -1,    -1,   183,    -1,    -1,
      -1,    -1,   188,  2410,    -1,    -1,    -1,   193,   194,    -1,
     196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2752,
      -1,  2754,  2755,  1999,  2000,  2001,  2759,    -1,  2004,    -1,
      -1,   217,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2016,  2017,  2018,  2019,    -1,    -1,    -1,    -1,   234,  2025,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2036,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2047,  2048,    -1,  2050,  2808,    -1,    -1,  2054,    -1,
      -1,  2814,   268,    -1,    -1,  2818,    -1,    -1,    -1,    -1,
     276,    -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,
      -1,  2077,    -1,  2079,  2080,   402,   403,   404,  2515,   406,
     407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1077,   353,    -1,  2104,    -1,
      -1,    -1,    -1,    -1,    -1,  2111,  2112,  2113,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   343,    -1,    -1,
      -1,    -1,    -1,    -1,  2140,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1033,    -1,    -1,    -1,  2152,  2584,   364,    -1,
    2913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,  2173,    -1,  2175,
      -1,    -1,    -1,    -1,    -1,  1066,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1174,    -1,    -1,    -1,    -1,   413,    -1,    -1,
     416,   417,   418,  1185,    -1,    -1,    -1,    -1,  2214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2231,  2232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2680,    -1,    -1,  1228,    -1,    -1,  1231,
      -1,  1233,    -1,  1235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2267,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2278,    -1,    -1,  3038,    -1,    -1,    -1,    -1,
    2286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3060,  3061,    -1,
      -1,  3064,  3065,  2309,    -1,    -1,  1288,    -1,    77,    -1,
      -1,   568,   569,    -1,    -1,    -1,    -1,  1299,    -1,    -1,
      -1,    90,    -1,    -1,    -1,  2331,    -1,    -1,    97,    -1,
      -1,  2337,    -1,   102,  2340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2349,    -1,  2351,    -1,    -1,    -1,  2355,
      -1,    -1,    -1,    -1,    -1,  2361,  2362,    -1,    -1,  2365,
    2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,    -1,
      -1,    -1,    -1,  2379,  2380,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2388,    -1,    -1,    -1,    -1,  2393,    -1,    -1,
      -1,    -1,    -1,    -1,  2400,  2401,  2402,    -1,  2404,    -1,
      -1,    -1,    -1,    -1,  2410,  2411,    -1,    -1,  1390,    -1,
    2416,    -1,    -1,  2419,    -1,    -1,    -1,    -1,  2855,    -1,
      -1,    -1,  2428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,   203,  1326,    -1,    -1,   695,    -1,
     697,    -1,    -1,   700,   701,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1352,    -1,   720,   233,  2471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   732,  1458,    -1,   735,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,   746,
     747,   260,    -1,    -1,    -1,    -1,    -1,  1388,   755,    -1,
      -1,    -1,    -1,    -1,   273,    -1,   275,    -1,   765,  2515,
      -1,    -1,   769,   770,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   793,    -1,   795,    -1,
      -1,    -1,    -1,    -1,   801,    -1,    -1,    -1,    -1,  1440,
      -1,  2988,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,    -1,  1546,    -1,  1548,  2573,    -1,    -1,
    1552,    -1,   829,    -1,    -1,  1557,  1558,    -1,  2584,    -1,
      -1,  1472,    -1,  1565,    -1,  1476,    -1,    -1,    -1,    -1,
      -1,    -1,   849,  1575,    -1,  1577,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   372,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1593,    -1,  1595,    -1,    -1,    -1,    -1,    -1,  2625,
      -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,  2635,
      -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2680,  3112,    -1,  1659,  2684,  2685,
    2686,    -1,    -1,  2689,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   949,    -1,    -1,   952,    -1,  2703,   955,    -1,
      -1,  2707,    -1,    -1,    -1,  2711,  1597,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3171,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1726,    -1,    -1,    -1,  1033,    -1,
    1732,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1742,    -1,    -1,    -1,  1021,    -1,    -1,    77,  1025,    -1,
      -1,    -1,  1029,  2779,    -1,    -1,    -1,  1034,    -1,    -1,
      90,  1066,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1057,    -1,    -1,    -1,    -1,    -1,    -1,  2813,    -1,    -1,
      -1,    -1,    -1,  1795,    -1,    -1,  1798,  1799,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2839,    -1,  1092,    -1,    -1,    -1,    -1,
      -1,    -1,  2848,    -1,  2850,    -1,    -1,  1829,  1105,  2855,
      -1,    -1,    -1,  2859,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1845,  2870,    -1,    -1,  1849,    -1,  2875,
      -1,  1853,    -1,  2879,    -1,    -1,    -1,  2883,  2884,  1861,
      -1,    -1,    -1,    -1,  1866,    -1,  1777,  2893,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,    -1,  1879,    -1,    -1,
      -1,    -1,    -1,    -1,  2910,    -1,    -1,    -1,    -1,  1033,
      -1,   221,   222,    -1,    -1,    -1,    -1,    -1,  2924,    -1,
      -1,    -1,    -1,   233,    -1,  1907,    -1,    -1,    -1,   688,
      -1,    -1,    -1,   692,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1066,  2949,    -1,    -1,    -1,   257,  1839,    -1,
     260,    -1,    -1,  1844,    -1,    -1,    -1,    -1,    -1,    -1,
     719,    -1,    -1,   273,  2970,   275,    -1,    -1,  1859,    -1,
      -1,    -1,    -1,  2979,   284,    -1,    -1,  2983,    -1,    -1,
      -1,    -1,  2988,    -1,    -1,    -1,    -1,  1969,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   754,    -1,    -1,    -1,    -1,
      -1,   760,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,    -1,    90,  3033,  1919,    93,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,  1326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3057,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1319,    -1,    -1,    -1,    -1,  1352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,   846,    -1,    -1,
      -1,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,  1388,    -1,    -1,  3112,    -1,    -1,  2091,
      -1,  2093,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3135,
    1415,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,   203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1440,    -1,   221,   222,    -1,
      -1,    -1,  3168,    -1,    -1,  3171,    -1,    -1,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1472,    -1,    -1,
    1447,  1476,    -1,   257,    -1,    -1,   260,    -1,  2180,    -1,
      -1,    -1,  1326,    -1,  2186,  2187,    -1,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,
      -1,  1488,    -1,  2215,  2216,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2224,    -1,    -1,    -1,    -1,  1006,    -1,    -1,
    2232,    -1,  1011,    -1,    -1,  2237,    -1,  2239,  1017,    -1,
      -1,  2152,    -1,    -1,  1388,   329,    -1,  2249,  2250,    -1,
      -1,    -1,    -1,    -1,  1033,    -1,    -1,    -1,    -1,    77,
      -1,    -1,  2173,    -1,  2175,    -1,    -1,    -1,    -1,    -1,
      -1,  1415,    90,    -1,    -1,    -1,    -1,  1056,  2189,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,  1066,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,    -1,  1440,    -1,    -1,    -1,
      -1,    -1,    -1,  2214,    -1,    -1,    -1,    -1,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,
     404,  2232,   406,   407,   408,   409,   410,   411,  1472,    -1,
      -1,    -1,  1476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1121,    -1,    -1,  2347,    -1,    -1,    -1,    -1,
      -1,  2353,    -1,    -1,    -1,  1632,  2267,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1143,    -1,    -1,  2278,    -1,    -1,
     188,    -1,  1649,    -1,    -1,  2286,    -1,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,   203,    -1,    -1,  1167,  1168,
      -1,  1170,  1171,  1172,    -1,    -1,    -1,  2399,    -1,    -1,
      -1,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,    -1,
      -1,  1190,    -1,    -1,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,  2340,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2361,   113,    -1,  1597,    -1,   273,    -1,   275,    -1,    -1,
      -1,    -1,    -1,    -1,  1741,    -1,    -1,   129,    -1,   131,
      -1,    -1,  1777,    -1,    -1,  1752,  1255,  2388,    -1,  1258,
    1259,    -1,  1759,   145,    -1,    -1,    -1,    -1,  1765,   151,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2410,
     162,    -1,    -1,    -1,    -1,    -1,    -1,  1784,  1785,    -1,
    1787,   329,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2530,  2531,
     192,  1808,   194,  1810,  1839,  1812,  1813,    -1,    -1,  1844,
    1817,    -1,    -1,  2545,   206,    -1,    -1,  1326,  2550,  2551,
    2552,  2553,  2554,    -1,  1859,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   227,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1352,   392,   237,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,
    2602,    -1,    -1,    -1,  2515,    -1,    -1,    -1,    -1,  1388,
      -1,   273,    -1,   275,  1919,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     292,    -1,    -1,  1777,    -1,    -1,  1415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   316,  1932,    -1,    -1,    -1,   321,
      -1,  1440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2584,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   343,   344,   345,    -1,   347,    -1,    -1,    -1,    -1,
      -1,  1470,    -1,  1472,   356,  1839,    -1,  1476,   360,   361,
    1844,    -1,    -1,   365,    -1,    -1,    -1,    -1,    -1,   371,
      -1,    -1,    -1,    -1,    -1,  1859,    -1,    -1,    -1,    -1,
      -1,    -1,  2724,    -1,    -1,    -1,    -1,    -1,  1507,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2747,    -1,    -1,    -1,    -1,
    2752,    -1,  2754,  2755,  1533,  1534,    -1,  2759,    -1,    -1,
      -1,    -1,  1541,    -1,    -1,  1544,  1545,    -1,    -1,  2680,
      -1,    -1,    -1,    -1,    -1,  1919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1564,    -1,    -1,    -1,  1568,
    1569,  1570,    -1,  1572,    -1,    -1,    -1,    -1,    -1,    -1,
    1579,  1580,    -1,    -1,    -1,    -1,  2808,    -1,    -1,    -1,
      -1,    -1,  2814,    -1,    -1,    -1,  2818,    -1,  1597,  1598,
      -1,    -1,  1601,  1602,    -1,    -1,    -1,  1606,    -1,    -1,
      -1,  1610,    -1,    -1,  1613,  1614,  1615,  1616,  1617,  1618,
    1619,  1620,  1621,    -1,  1623,    -1,    -1,  2152,  1627,    -1,
      -1,    -1,  1631,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,    -1,
    2175,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2189,  2162,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2214,
      -1,  2913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2855,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2267,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2278,  2251,  2252,  2253,    -1,    -1,    -1,
      -1,  2286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1768,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1777,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2283,    -1,  2152,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2294,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,
      -1,  2175,    -1,    -1,    -1,  2340,  3038,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2189,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2361,    -1,  3060,  1838,
    1839,    -1,  3064,    -1,    -1,  1844,    -1,    -1,    -1,    -1,
    2214,    -1,    -1,    -1,    -1,    -1,    -1,  2988,  1857,    -1,
    1859,    -1,    -1,  2388,    -1,    -1,    -1,    -1,  2232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2410,    -1,    -1,  3110,  3111,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2267,  1033,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2278,    -1,    -1,    -1,    -1,    -1,
    1919,    -1,  2286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1066,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      -1,  1970,    -1,    -1,    -1,    -1,  2340,    -1,    -1,    90,
      -1,  3112,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,
    2515,   102,    -1,    -1,    -1,    -1,    -1,  2361,    -1,    -1,
    1999,  2000,  2001,    -1,    -1,  2004,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2016,  2017,  2018,
    2019,    -1,  2519,  2520,  2388,    -1,  2025,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2036,    -1,    -1,
    3171,    -1,    -1,    -1,    -1,    -1,  2410,    -1,  2047,  2048,
      -1,  2050,    -1,    -1,    -1,  2054,    -1,    -1,    -1,  2584,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1033,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2572,    -1,    -1,  2077,    -1,
    2079,  2080,    -1,    -1,    -1,    -1,   688,    -1,   199,    -1,
     692,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1066,    -1,    -1,    -1,    -1,  2104,    -1,    -1,    -1,    -1,
     221,   222,  2111,  2112,  2113,    -1,    -1,   719,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2140,    -1,    -1,    -1,    -1,   257,    -1,    -1,   260,
      -1,  2515,   754,  2152,    -1,  2680,    -1,    -1,   760,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2173,    -1,  2175,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2189,    -1,    -1,    -1,    -1,    -1,    -1,  1326,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2214,    -1,    -1,   329,    -1,
    2584,    -1,    -1,  1352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2232,    -1,    -1,    -1,  1033,  2735,    -1,
      -1,    -1,    -1,    -1,   846,  2742,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1388,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2267,    -1,
    1066,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2278,
      -1,   392,    -1,    -1,    -1,    -1,  1415,  2286,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2309,  1440,    -1,    -1,    -1,    -1,  2680,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2855,    -1,  2331,    -1,    -1,    -1,    -1,    -1,  2337,    -1,
      -1,  2340,    -1,  1472,    -1,    -1,    -1,  1476,    -1,    -1,
    2349,    -1,  2351,    -1,    -1,    -1,  2355,    -1,    -1,    -1,
    1326,    -1,  2361,  2362,    -1,    -1,  2365,  2366,  2367,  2368,
    2369,  2370,  2371,  2372,  2373,  2374,    -1,    -1,    -1,    -1,
    2379,  2380,    -1,    -1,    -1,    -1,  1352,    -1,    -1,  2388,
      -1,    -1,    -1,    -1,  2393,    -1,    -1,    -1,    -1,    -1,
      -1,  2400,  2401,  2402,  1006,  2404,    -1,    -1,    -1,  1011,
      -1,  2410,  2411,    -1,    -1,  1017,    -1,  2416,    -1,    -1,
    2419,   846,  1388,    -1,    -1,    -1,    -1,    -1,    -1,  2428,
      -1,  1033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,  1415,
      -1,    -1,    -1,    -1,  1056,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,  2988,  1066,    97,    -1,    -1,  1597,    -1,
     102,    -1,  2471,    -1,  1440,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2855,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1472,    -1,    -1,    -1,
    1476,    -1,    -1,    -1,    -1,    -1,  2515,    -1,    -1,  1121,
      -1,  3018,    -1,    -1,    -1,    -1,  3023,    -1,    -1,    -1,
    1326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1167,  1168,   199,  1170,  1171,
    1172,   203,    -1,    -1,  2573,    -1,    -1,    -1,    -1,    -1,
      -1,  1006,    -1,    -1,  3081,  2584,    -1,  3112,  1190,   221,
     222,    -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1415,
      -1,    -1,    -1,    -1,  2988,   257,  2625,    -1,   260,    -1,
      -1,  1597,    -1,    -1,    -1,    -1,  2635,    -1,    -1,    -1,
      -1,   273,    -1,   275,  1440,    -1,  3171,    -1,  1777,    -1,
      -1,    -1,    -1,  1255,    -1,    -1,  1258,  1259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1472,    -1,    -1,    -1,
    1476,  2680,    -1,    -1,    -1,  2684,  2685,  2686,    -1,    -1,
    2689,    -1,    -1,    -1,    -1,    -1,  1121,   329,    -1,    -1,
      -1,    -1,    -1,    -1,  2703,    -1,    -1,    -1,  2707,    -1,
    1839,    -1,  2711,    -1,    -1,  1844,   348,    -1,  1143,    -1,
      -1,    -1,    -1,    -1,  1326,    -1,    -1,    -1,    -1,    -1,
    1859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1167,  1168,    -1,  1170,  1171,  1172,  3112,    -1,
    1352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,    -1,    -1,    -1,    -1,  1190,    -1,    -1,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
    2779,    -1,    -1,    -1,    -1,    -1,  1388,    -1,    -1,    -1,
    1919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1597,    -1,    -1,    -1,    -1,    -1,  3171,    -1,    -1,
      -1,  1777,    -1,  1415,  2813,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1255,    -1,    -1,  1258,  1259,    -1,    -1,    -1,  1440,    -1,
    2839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2848,
      -1,  2850,    -1,    -1,    -1,    -1,  2855,    -1,    -1,    -1,
    2859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1470,    -1,
    1472,  2870,    -1,  1839,  1476,    -1,  2875,    -1,  1844,    -1,
    2879,    -1,    -1,    -1,  2883,  2884,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1859,  2893,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1507,    -1,    -1,    -1,    -1,
      -1,  2910,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2924,    -1,    -1,    -1,    -1,
      -1,  1533,  1534,    -1,    -1,    -1,    -1,    -1,    -1,  1541,
      -1,    -1,  1544,  1545,    -1,    -1,    -1,    -1,    -1,    -1,
    2949,    -1,    -1,  1919,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1564,    -1,    -1,    -1,  1568,  1569,  1570,    -1,
    1572,  2970,    -1,    -1,    -1,    -1,    -1,  1579,  1580,    -1,
    2979,  1777,    -1,    -1,  2983,    -1,    -1,    -1,    -1,  2988,
      -1,    -1,    -1,    -1,    -1,  1597,  1598,    -1,    -1,  1601,
    1602,    -1,    -1,    -1,  1606,    -1,    -1,    -1,  1610,    -1,
      -1,  1613,  1614,  1615,  1616,  1617,  1618,  1619,  1620,  1621,
      -1,  1623,    -1,  2152,    -1,  1627,    -1,    -1,    -1,  1631,
      -1,    -1,    -1,    -1,  3033,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1839,  2173,  1470,  2175,    -1,  1844,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3057,    -1,
    2189,    -1,    -1,  1859,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2214,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3112,    -1,    -1,  1541,    -1,    -1,    -1,
    1545,    -1,    -1,  1919,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3135,    -1,  2267,  1564,
      -1,    -1,    -1,  1568,    -1,    -1,    -1,  1572,    -1,  2278,
      -1,    -1,    -1,    -1,  1579,  1580,    -1,  2286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1768,    -1,    -1,  3168,
      -1,    -1,  3171,  1598,    -1,  1777,    -1,  1602,    -1,    -1,
      -1,  1606,    -1,    -1,    -1,  1610,  2152,    -1,  1613,  1614,
    1615,  1616,  1617,  1618,  1619,  1620,  1621,    -1,  1623,    -1,
      -1,    -1,  1627,    -1,    -1,    -1,    -1,  2173,    -1,  2175,
      -1,  2340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2361,    -1,    -1,    -1,  1838,  1839,    -1,    -1,
      -1,    -1,  1844,    -1,    -1,    -1,    -1,    -1,  2214,    -1,
      -1,    -1,    -1,    -1,    -1,  1857,    -1,  1859,    -1,  2388,
      -1,    -1,    -1,    -1,    -1,    -1,  2232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2267,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2278,    -1,    -1,    -1,    -1,  1919,    -1,    -1,
    2286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1768,    -1,    -1,    -1,    -1,  1950,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2152,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1970,    -1,
      -1,    -1,    -1,    -1,  2340,    -1,    -1,  2173,    -1,  2175,
      -1,    -1,    -1,    -1,    -1,    -1,  2515,    -1,    -1,    -1,
      -1,    -1,    -1,  2189,    -1,  2361,    -1,  1999,  2000,  2001,
      -1,    -1,  2004,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1838,  2016,  2017,  2018,  2019,  2214,    -1,
      -1,    -1,  2388,  2025,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1857,    -1,  2036,    -1,  2232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2410,  2047,  2048,    -1,  2050,    -1,
      -1,    -1,  2054,    -1,    -1,  2584,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2267,    -1,    -1,    -1,  2077,    -1,  2079,  2080,    -1,
      -1,    -1,  2278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2104,    -1,    -1,    -1,    -1,    -1,    -1,  2111,
    2112,  2113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1950,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2140,    -1,
      -1,    -1,    -1,    -1,  2340,  1970,    -1,    -1,    -1,  2515,
    2152,  2680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2361,    -1,    -1,    -1,    -1,
      -1,  2173,    -1,  2175,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2189,    -1,    -1,
      -1,  2016,  2388,  2018,  2019,    -1,    -1,    -1,    -1,    -1,
    2025,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2214,    -1,  2410,    -1,    -1,    -1,  2584,    -1,
      -1,    -1,    -1,  2048,    -1,  2050,    -1,    -1,  1186,  2054,
    2232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2267,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2278,    -1,    -1,  2104,
      -1,    -1,    -1,    -1,  2286,    -1,  2111,  2112,  2113,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2309,    -1,    -1,
      -1,    -1,    -1,    -1,  2680,  2140,    -1,    -1,    -1,  2515,
      -1,    -1,    -1,    -1,    -1,    -1,  2855,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,  2337,    -1,    -1,  2340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2349,    -1,  2351,
      -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,  2361,
    2362,    -1,    -1,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,  2374,    -1,    -1,    -1,    -1,  2379,  2380,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,  2584,    -1,
      -1,  2393,    -1,    -1,    -1,    -1,    -1,    -1,  2400,  2401,
    2402,    -1,  2404,    -1,    -1,    -1,    -1,    -1,  2410,  2411,
      -1,    -1,    -1,    -1,  2416,    -1,    -1,  2419,    -1,    -1,
      -1,    -1,    -1,  1381,    -1,    -1,  2428,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2988,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2471,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2680,    -1,    -1,    -1,    -1,  2855,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,  2337,  2515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2349,    -1,  2351,    -1,    -1,    -1,
    2355,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2379,  2380,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2573,    -1,    -1,    -1,    -1,    -1,  2402,    -1,  2404,
      -1,  1539,  2584,  3112,    -1,    -1,  2411,    -1,    -1,    -1,
      -1,  2416,    -1,    -1,  2419,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1563,    -1,    -1,    -1,    -1,
      -1,  1569,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2988,  2625,    -1,    -1,  1584,  1585,  1586,  1587,
      -1,  1589,    -1,  2635,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3171,  1601,    -1,    -1,  2471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2855,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1625,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2680,    -1,
      -1,    -1,  2684,  2685,  2686,    -1,    -1,  2689,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2703,    -1,    -1,    -1,  2707,    -1,    -1,    -1,  2711,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1691,    -1,    -1,    -1,    -1,    -1,  1697,
      -1,  1699,    -1,    -1,    -1,    -1,  3112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2779,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2988,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2625,    -1,    -1,    -1,    -1,  3171,    -1,    -1,    -1,    -1,
    2635,  2813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2839,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2848,    -1,  2850,    -1,
      -1,    -1,    -1,  2855,    -1,    -1,    -1,  2859,    -1,    -1,
    2685,  2686,    -1,    -1,  2689,    -1,    -1,    -1,  2870,    -1,
      -1,    -1,    -1,  2875,    -1,    -1,    -1,  2879,    -1,    -1,
      -1,  2883,  2884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2910,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3112,    -1,    -1,    -1,
      -1,    -1,  2924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2949,    -1,    -1,
      -1,    -1,    -1,    -1,  2779,    -1,    -1,    -1,    -1,  1917,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2970,    -1,
      -1,    -1,    -1,    -1,    -1,  3171,    -1,  2979,    -1,    -1,
      -1,  2983,    -1,    -1,    -1,    -1,  2988,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1964,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2839,  1973,    -1,  1975,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3033,    -1,    -1,  2859,    -1,  1994,    -1,    -1,  1997,
      -1,  1999,  2000,  2001,  2002,    -1,  2004,    -1,    -1,    -1,
    2008,    -1,    -1,    -1,    -1,  3057,    -1,  2015,    -1,  2884,
      -1,    -1,  2020,    -1,    -1,    -1,    -1,    -1,  2893,    -1,
      -1,    -1,    -1,  2031,    -1,    -1,  2034,  2035,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2910,    -1,    -1,  2046,  2047,
      -1,    -1,    -1,    -1,    -1,  2053,    -1,  2055,  2056,  2057,
    2058,  2059,  2060,  2061,  2062,  2063,  2064,    -1,    -1,    -1,
    3112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2949,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3135,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2979,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3168,    -1,    -1,  3171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2147,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3057,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2212,    -1,    -1,    20,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2233,    -1,    40,    41,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,  2316,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2336,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2358,  2359,  2360,    -1,  2362,    -1,    -1,  2365,  2366,  2367,
    2368,  2369,  2370,  2371,  2372,  2373,  2374,    -1,  2376,   182,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,  2396,    -1,
      -1,    -1,    -1,  2401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   215,    -1,  2412,  2413,    -1,  2415,    -1,    -1,
    2418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   242,
      -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2492,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   376,    -1,  2573,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,   390,   391,    -1,
     393,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,    -1,    -1,
     413,   414,   415,    -1,    -1,    -1,   419,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2632,    -1,    -1,    -1,  2636,    -1,
      -1,    -1,    -1,  2641,  2642,    -1,  2644,    -1,    -1,  2647,
      -1,    -1,    -1,  2651,  2652,  2653,  2654,  2655,  2656,  2657,
    2658,  2659,  2660,  2661,  2662,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2676,  2677,
      -1,  2679,    -1,    -1,    -1,  2683,  2684,    -1,    -1,  2687,
      -1,    -1,  2690,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2781,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2841,    -1,    -1,    -1,    -1,    -1,    -1,
    2848,    -1,  2850,    -1,    -1,    -1,    -1,    -1,  2856,  2857,
    2858,    -1,  2860,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2928,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2969,  2970,  2971,    -1,    -1,  2974,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2990,    -1,    -1,    -1,  2994,    -1,    -1,    -1,
      -1,  2999,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3031,    -1,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,  3046,    19,
      -1,    21,  3050,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,   107,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
      -1,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,     6,     7,     8,    -1,
      -1,    11,    12,    -1,    14,    15,    16,    -1,    -1,    -1,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,   419,
      30,    31,    32,    -1,    -1,    -1,    36,    37,    38,    39,
      -1,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,    -1,
      -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
     210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,   279,
     280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,   329,
      -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,
     350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,    -1,
      -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,    -1,
     390,    11,    12,   393,    14,    15,    16,    -1,    -1,    -1,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    -1,    -1,    -1,    36,    37,    38,    39,
     420,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,    -1,
      -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
     210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,   279,
     280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,   329,
      -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,
     350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,    -1,
      -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,    -1,
      -1,    -1,    -1,     3,    -1,    -1,     6,     7,     8,     9,
     390,    11,    12,   393,    14,    15,    16,    17,    -1,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
     420,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,
      -1,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,   119,
      -1,   121,   122,   123,    -1,    -1,   126,   127,    -1,    -1,
      -1,    -1,   132,   133,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   145,    -1,   147,   148,   149,
     150,    -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
      -1,    -1,    -1,    -1,   174,   175,   176,    -1,   178,    -1,
     180,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
     210,    -1,    -1,   213,    -1,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,   235,   236,    -1,    -1,   239,
      -1,    -1,    -1,    -1,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,   279,
     280,    -1,    -1,    -1,    -1,   285,   286,    -1,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,   299,
      -1,   301,    -1,    -1,    -1,   305,    -1,    -1,    -1,   309,
     310,   311,   312,    -1,    -1,   315,    -1,    -1,    -1,    -1,
     320,    -1,    -1,    -1,    -1,   325,   326,    -1,   328,   329,
      -1,   331,     3,    -1,   334,    -1,    -1,    -1,     9,    -1,
      -1,   341,    -1,    -1,    -1,    -1,    17,    -1,    19,   349,
     350,    22,    -1,    -1,    -1,   355,    -1,   357,    -1,   359,
      -1,   361,    33,    -1,   364,    -1,    -1,   367,    -1,   369,
      -1,    -1,    -1,   373,    -1,    -1,   376,    -1,   378,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   415,    87,    88,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
     121,   122,    -1,    -1,    -1,   126,   127,    -1,    -1,    -1,
      -1,    -1,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   145,    -1,   147,    -1,    -1,   150,
      -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,    -1,
      -1,    -1,    -1,   174,    -1,   176,    -1,    -1,    -1,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,   246,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   259,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,    -1,
     301,    -1,    -1,    -1,   305,    -1,    -1,    -1,   309,    -1,
     311,    -1,    -1,    -1,   315,    -1,    -1,    -1,    -1,   320,
      -1,    -1,    -1,    -1,   325,    -1,    -1,   328,    -1,    -1,
      -1,    -1,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   359,    -1,
     361,    -1,    -1,    -1,    -1,    -1,   367,    -1,   369,    -1,
      -1,    -1,   373,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,   415,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,   160,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,   408,    -1,   410,   411,
      -1,    -1,    -1,   415,   416,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,
     410,   411,    -1,    -1,    -1,   415,   416,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,   375,   376,   377,    -1,
     379,     5,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    20,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   413,    -1,    40,    41,   417,    -1,
      -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    40,    41,    -1,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   242,    -1,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,   262,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   318,   242,    -1,    -1,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   387,    -1,    -1,   390,   391,    -1,   393,
      -1,   318,    -1,    -1,    -1,   399,    -1,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,   390,   391,    -1,   393,    -1,    -1,    -1,
      -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,    -1,    -1,   413,   414,   415,   416,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,   408,    -1,   410,   411,    -1,    -1,
      -1,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,    -1,
      -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,
      -1,    -1,   415,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,
      -1,    -1,    -1,   415,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,   392,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,
     411,    -1,   413,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,
     410,   411,    -1,    -1,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,
      -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,
     407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
      -1,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,   415,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,    -1,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,    -1,
     407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,    -1,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
     415,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,    -1,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,    -1,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,   415,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,   171,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,   268,   269,
      -1,    -1,    -1,   273,   274,    -1,   276,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,     5,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    20,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   416,    40,    41,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   242,
      -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,   390,   391,    -1,
     393,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,    -1,    -1,
     413,   414,   415,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,    -1,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,   272,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   415,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
     260,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,   272,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   415,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,   260,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   415,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,    -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     414,   415,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,    -1,    -1,    -1,    -1,   399,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,   415,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   415,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   415,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,   320,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   415,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   415,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   415,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,    -1,    -1,   258,   259,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,
      -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,    -1,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,    -1,   356,    -1,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,    -1,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,    -1,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,   408,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
      -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,    -1,    -1,   258,   259,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,    -1,
      -1,    -1,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,    -1,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
      -1,   356,    -1,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,   408,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,   408,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,    -1,    -1,    -1,    -1,
     399,    -1,   401,    -1,     6,     7,     8,     9,   407,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,    -1,    -1,    -1,    -1,   399,    -1,   401,
      -1,     6,     7,     8,     9,   407,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,   188,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,   203,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
       6,     7,     8,     9,   399,    11,    12,    -1,    14,    15,
      16,    17,   407,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,     6,
       7,     8,     9,   399,    11,    12,    -1,    14,    15,    16,
      17,   407,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,   351,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,     6,     7,
       8,     9,    -1,    11,    12,   402,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,     4,   396,     6,     7,     8,     9,    10,
      11,    12,    -1,    14,    15,    16,    17,    18,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,   107,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,    -1,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,    -1,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
      -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,
     133,    -1,   135,   136,   137,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,    -1,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,    -1,   252,
     253,   254,   255,    -1,    -1,   258,   259,   260,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,    -1,   278,   279,    -1,   281,   282,
     283,    -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,    -1,   356,    -1,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    13,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    42,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,   351,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    18,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,
      -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,    -1,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,    -1,   356,    -1,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
      -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,    -1,
      -1,    -1,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,    -1,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
      -1,   356,    -1,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
     106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,
     126,   127,   128,    -1,   130,   131,    -1,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,    -1,
     176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,    -1,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
      -1,    -1,   258,   259,    -1,   261,    -1,    -1,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,   281,   282,   283,    -1,    -1,
      -1,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,    -1,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,
     356,    -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,    -1,   176,
      -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,    -1,
      -1,   258,   259,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,    -1,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,    -1,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,   107,   108,
     109,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,    -1,   192,   193,   194,   195,   196,   197,    -1,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,    -1,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
      -1,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,    -1,   381,   382,   383,   384,   385,   386,    -1,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,   260,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,   185,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,   272,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
     203,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      93,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
      -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,    -1,
      -1,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
      39,    -1,    41,    -1,    43,    44,    45,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,
     279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,
      -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
      -1,   390,    11,    12,   393,    14,    15,    16,    -1,    -1,
      -1,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
      39,    -1,    41,    -1,    43,    44,    45,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,
     279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,
      -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
      -1,   390,    11,    12,   393,    14,    15,    16,    -1,    -1,
      -1,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
      39,    -1,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,
     279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,
      -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
      -1,   390,    11,    12,   393,    14,    15,    16,    -1,    -1,
      -1,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
      39,    -1,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,
     279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,
      -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,
       6,     7,     8,    -1,    -1,    11,    12,    -1,    14,    15,
      16,   390,    -1,    -1,   393,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    -1,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,
      -1,    -1,   178,    -1,    -1,    -1,   182,    -1,    -1,    -1,
      -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   209,   210,    -1,    -1,    -1,    -1,    -1,
     216,    -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,
      -1,    -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,
     286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   310,    -1,   312,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     326,    -1,    -1,   329,    -1,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     376,    -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,    -1,    -1,   393
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   425,   426,     0,     5,    20,    29,    40,    41,    46,
      48,    49,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   115,   182,   198,   215,
     242,   245,   262,   318,   351,   364,   376,   387,   390,   391,
     393,   395,   399,   401,   402,   406,   407,   408,   409,   410,
     413,   414,   415,   416,   418,   419,   420,   421,   427,   785,
     786,   789,   824,   826,   923,   936,   937,   825,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    36,    37,    38,    39,    41,    43,    44,
      45,    47,    48,    49,    50,    51,    52,    56,    57,    62,
      71,    73,    75,    76,    78,    87,    88,    89,    97,    98,
     101,   102,   103,   104,   105,   116,   119,   121,   122,   123,
     126,   127,   132,   133,   134,   137,   145,   147,   148,   149,
     150,   156,   164,   169,   174,   175,   176,   178,   180,   182,
     187,   189,   191,   193,   199,   209,   210,   213,   216,   218,
     221,   222,   224,   231,   233,   235,   236,   239,   246,   248,
     249,   250,   256,   259,   260,   263,   264,   277,   278,   279,
     280,   285,   286,   288,   296,   299,   301,   305,   309,   310,
     311,   312,   315,   320,   325,   326,   328,   329,   331,   334,
     341,   349,   350,   355,   357,   359,   361,   364,   367,   369,
     373,   376,   378,   390,   393,   415,   428,   429,   430,   432,
     433,   434,   438,   441,   442,   443,   447,   458,   459,   460,
     463,   464,   472,   473,   482,   509,   515,   516,   520,   524,
     526,   528,   529,   542,   543,   544,   545,   551,   556,   557,
     562,   563,   567,   570,   571,   582,   588,   601,   602,   604,
     607,   609,   610,   613,   615,   616,   624,   625,   626,   627,
     628,   633,   634,   635,   639,   640,   641,   642,   644,   645,
     646,   647,   648,   653,   656,   660,   661,   665,   666,   669,
     670,   671,   672,   673,   801,   814,   815,   816,   817,   818,
     831,   836,   837,   838,   839,   840,   842,   844,   846,   847,
     848,   849,   851,   856,   857,   860,   865,   866,   875,   876,
     878,   879,   880,   883,   887,   890,   894,   896,   897,   900,
     902,   905,   913,   919,   920,   930,   828,   829,   831,   833,
     836,   839,   842,    18,     9,    17,    19,    33,    51,    52,
      56,    57,    62,    71,    73,    75,    76,    78,    79,    80,
      81,    82,    83,    84,    86,    87,    95,    96,    97,    99,
     100,   101,   108,   109,   111,   114,   115,   117,   119,   120,
     121,   122,   126,   127,   128,   130,   131,   133,   135,   136,
     138,   143,   144,   145,   146,   147,   150,   152,   154,   156,
     157,   158,   162,   163,   164,   165,   167,   168,   170,   172,
     173,   174,   176,   180,   181,   184,   186,   190,   192,   195,
     197,   198,   200,   201,   202,   204,   205,   206,   207,   212,
     213,   214,   223,   225,   226,   227,   228,   229,   232,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   252,   253,   254,   255,   258,   259,   261,   265,
     266,   269,   273,   274,   281,   282,   283,   287,   288,   290,
     291,   292,   293,   294,   295,   297,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   311,   313,   314,
     315,   316,   317,   318,   321,   322,   323,   325,   327,   328,
     330,   333,   334,   335,   336,   337,   338,   339,   340,   342,
     344,   345,   346,   347,   351,   352,   354,   356,   359,   360,
     361,   362,   363,   366,   367,   368,   369,   370,   373,   374,
     375,   377,   379,   383,   384,   385,   386,   387,   388,   394,
     789,   794,   799,   810,   811,   904,   905,   906,   909,   915,
     916,   917,   918,   919,   927,   929,   930,    34,   211,   877,
      13,    85,   151,   778,   789,   802,   803,   812,   858,   859,
     909,   929,   930,     5,    29,    34,    40,    41,    48,    49,
      85,    88,    89,    90,    91,    92,    93,    94,   107,   112,
     113,   115,   118,   124,   125,   129,   134,   139,   140,   141,
     142,   151,   153,   159,   160,   161,   166,   169,   171,   179,
     183,   185,   188,   193,   194,   196,   203,   208,   211,   215,
     217,   219,   230,   234,   251,   257,   262,   267,   268,   270,
     271,   272,   275,   276,   289,   298,   320,   324,   332,   343,
     348,   351,   353,   358,   364,   365,   371,   372,   381,   382,
     419,   841,   906,   907,   908,   912,   913,   914,   915,   917,
     918,   921,   777,   909,   777,   908,    29,    40,   115,   215,
     901,    43,    45,   257,   832,   354,   385,   629,    84,   131,
     145,   162,   190,   194,   206,   227,   273,   316,   321,   343,
     344,   356,   361,   371,   802,   150,   629,   777,   251,   270,
     773,   775,   781,   800,   909,   271,   629,   104,   478,    84,
      95,   113,   129,   145,   151,   162,   192,   194,   237,   273,
     275,   316,   344,   345,   347,   356,   360,   361,   365,   371,
     483,   521,   554,   583,   589,   802,    18,   288,   777,   812,
     864,   335,   777,   188,    84,    95,   113,   131,   145,   162,
     190,   194,   206,   273,   292,   314,   316,   321,   343,   344,
     356,   361,   371,   379,   525,   558,   629,   200,   864,   648,
     655,    79,    85,    99,   181,   186,   188,   203,   229,   252,
     290,   300,   407,   564,   565,   566,   777,   785,   790,   791,
     927,    18,    85,   134,   156,   174,   213,   298,   314,   320,
     345,   347,   356,   369,   370,   572,   573,   574,   219,   775,
     909,   782,   794,   343,   676,   564,   777,   775,   864,   145,
     206,   343,   611,   315,   909,    85,   323,   349,   354,   909,
     193,   579,   629,   909,    85,   160,   678,     4,    10,    18,
     130,   237,   247,   323,   349,   354,   448,   449,   909,    85,
     323,   349,   354,   909,   354,   676,   898,   908,   408,   775,
     272,   700,   775,   189,   650,   670,   671,   101,   429,   418,
     378,   649,   171,   217,   276,   364,   679,   680,   839,   842,
     838,   820,   418,   843,   845,     5,    29,    40,   115,   163,
     215,   850,   146,   198,   242,   245,   318,   387,   415,   729,
     823,   827,   923,   831,   833,   839,   835,   418,   777,   812,
     931,   151,   802,    25,   372,   409,   777,   777,   392,   804,
     805,   423,   929,   415,   419,   932,   933,   934,   935,   937,
     841,   372,   867,   868,   869,    29,   215,   215,   912,     7,
      11,    23,    24,    44,    47,   161,   903,   903,    21,   839,
     773,   783,   904,   911,   915,   916,   920,   930,   560,   909,
     778,   560,   778,   909,   783,   799,   700,   777,   120,   392,
     402,   403,   404,   406,   407,   408,   409,   410,   411,   606,
     736,   737,   909,   777,   775,   700,   777,   777,   560,   799,
      39,   223,   295,   630,   631,   632,   413,   417,   761,   762,
     271,    84,   113,   125,   131,   145,   162,   190,   206,   228,
     273,   314,   316,   321,   343,   356,   361,   379,   525,   568,
     775,   783,   777,   415,   356,   778,   560,   345,   347,   799,
     345,   347,   120,   736,   304,   444,   909,   777,   777,   560,
     799,   321,   343,   525,   131,   206,   190,   314,   379,   931,
     864,   930,   667,   700,   783,   777,   415,   778,   783,   799,
     120,   736,   777,   777,   777,   437,   799,   227,   559,   560,
     393,   812,   863,   861,   649,   565,    85,   565,    85,   565,
     565,   790,   566,   777,   777,   219,   870,   872,   931,   291,
     271,   421,   775,   774,   775,   566,   188,   777,   775,   909,
      98,   388,   223,   274,   572,   351,   271,    92,   103,   105,
     106,   112,   113,   115,   116,   123,   132,   139,   140,   141,
     142,   148,   149,   163,   175,   178,   179,   182,   215,   216,
     218,   248,   250,   257,   262,   263,   264,   273,   280,   285,
     296,   312,   324,   331,   341,   349,   350,   355,   357,   358,
     365,   371,   376,   392,   397,   398,   400,   406,   407,   408,
     410,   411,   415,   670,   709,   710,   711,   716,   717,   718,
     720,   721,   722,   723,   726,   727,   730,   732,   733,   734,
     738,   755,   760,   765,   766,   773,   783,   784,   785,   786,
     787,   788,   789,   798,   904,   907,   910,   915,   916,   926,
     927,   929,   930,   351,   402,   351,   402,   859,   931,    85,
     461,   776,   777,   323,   448,   151,   456,   794,    98,   117,
     448,   388,   631,   351,   417,   422,    98,   388,   223,   632,
     775,   913,   415,   775,   325,   408,   187,   651,   416,   416,
     418,   775,    85,   677,   677,   108,   677,   183,   234,   268,
     683,   689,   819,   408,   852,   853,   855,   419,   419,    29,
     215,   215,   351,   351,   351,   351,   351,   407,   785,   786,
     796,   821,   927,   169,   834,   852,    93,   808,   108,   811,
     811,   372,   869,   219,   869,   870,   396,   806,   909,   423,
     807,   804,   416,   933,   934,   932,   420,   421,    42,   789,
     796,   797,   871,   873,   874,   926,   215,   221,   777,   351,
     777,     6,   777,   903,   855,   762,   415,   281,   302,   417,
     561,   281,   302,   325,   459,    82,   164,   325,   469,   281,
     415,   590,    82,   164,   302,   281,   302,   325,   467,   468,
     302,   560,   415,   417,   281,   302,   517,    82,    87,   122,
     134,   164,   302,   325,   465,   466,   281,   302,   271,   281,
     302,   325,   383,   435,   459,   418,   232,   272,   386,   421,
     630,   730,   408,   780,   912,   761,   775,   783,   415,   783,
     265,   120,   736,   777,   777,   227,   777,   383,   479,   415,
     547,   118,   103,   105,   115,   116,   148,   149,   182,   216,
     218,   248,   250,   264,   296,   326,   331,   349,   350,   376,
     705,   708,   710,   711,   715,   717,   718,   719,   721,   722,
     726,   727,   904,   910,   915,   916,   930,   777,   383,    93,
     643,   383,   439,   560,   547,    98,   445,   281,   527,    83,
     100,   530,    93,   547,   383,   431,   775,   775,   227,   560,
     781,   909,   783,   777,   775,   104,   143,   212,   253,   317,
     382,   702,   415,   705,   590,   560,   415,   271,   271,   421,
     794,   111,   307,   421,   470,   862,   868,   872,   150,   654,
     656,   660,   665,   666,   669,   777,   872,   872,   871,   922,
     925,   929,    50,   881,   882,   929,   145,   190,   227,   316,
     343,   344,   575,   774,   574,   151,   375,   415,   657,   669,
     203,   421,   662,   777,   863,   184,   612,   612,   232,   183,
     271,   315,   909,   415,   413,   670,   745,   377,   724,   730,
     759,   415,   724,   724,   415,   415,   415,   764,   415,   764,
     415,   764,   415,   714,   714,   286,   670,   415,   415,   712,
     115,   116,   724,   730,   415,   415,   713,   415,   415,   415,
     415,   764,   415,   383,   384,   415,   728,   415,   728,   415,
     415,   670,   764,   763,   730,   730,   730,   730,   670,   730,
     741,   794,   116,   415,   725,   415,   794,    77,    90,    93,
      97,   102,   199,   203,   221,   222,   233,   257,   260,   273,
     275,   329,   392,   402,   403,   404,   406,   407,   408,   409,
     410,   411,   736,   738,   740,   730,   219,   421,   674,   872,
     762,   415,    26,   928,   929,   267,   271,   895,   895,   859,
     859,    12,    50,   884,   885,   886,   154,   200,   462,   421,
     117,   151,   457,   794,   909,    93,   151,   237,   455,   727,
     797,   930,   151,   179,   267,   271,   358,   450,   451,   453,
     454,   797,   909,   909,   450,   232,   221,   775,   415,   767,
     770,   909,   649,   415,   652,   670,   672,   673,   672,   681,
     682,   730,   672,   295,   369,    85,   685,   730,   686,   730,
     689,   690,   683,   684,   852,   408,   418,   421,   914,   830,
     833,   830,   215,   146,   198,   242,   318,   242,   318,   318,
     245,   242,   245,   318,   785,   786,   421,   822,   150,   852,
     418,   802,   371,   809,   811,   417,   790,   807,   416,   420,
     935,    18,   421,   839,   415,   777,   415,   913,   408,   603,
     705,   351,   351,   780,   417,   351,   351,   448,   118,   129,
     185,   289,   365,   494,   495,   129,   151,   257,   151,   257,
     351,   203,   210,   277,   416,   591,   592,   593,   281,   302,
     371,   371,   351,   351,   351,   344,   421,   351,   372,   256,
     605,   705,   606,   351,   351,   109,   144,   205,   241,   243,
     253,   306,   334,   518,   125,   494,   614,   614,   271,   352,
     129,   614,   351,   614,   384,   421,   351,   351,   700,   351,
     351,   448,   435,   135,   136,   203,   254,   255,   283,   342,
     374,   436,   295,   303,   322,   452,   630,   414,   423,   415,
     705,   590,   796,   560,   415,   221,   271,   271,   560,   221,
     269,   188,   351,   474,   548,   549,   912,   415,   708,    93,
      92,   413,   706,   146,   245,   387,   415,   729,   561,    83,
     167,   238,   281,   344,   346,   636,   637,   705,   439,   342,
     371,   440,   554,   799,   134,   446,   482,   515,   529,   570,
     582,   633,   777,   238,   156,   213,   369,   531,   532,   415,
     546,   435,   517,   266,   415,   512,   457,   183,   271,   590,
      93,   415,   496,   383,   384,   668,   317,   730,   603,    93,
     470,   372,   605,   775,   775,   799,   470,   560,   872,   868,
     777,   872,    18,   421,   928,   785,   792,   929,   421,   402,
     776,   580,   581,   783,   776,   776,   774,   776,   351,   375,
     415,   658,   659,   909,    80,   172,   312,   327,   663,   775,
     261,   664,   575,   909,   730,   741,   741,   744,   745,   415,
     381,   756,   757,   730,   741,   730,   741,   416,   790,   790,
     790,   146,   198,   242,   245,   318,   387,   742,   746,   794,
     930,   790,   724,   724,   730,   790,   606,   730,   747,   407,
     410,   411,   731,   732,   738,   749,   416,   741,   730,   741,
     750,   349,   349,   790,   790,   730,   107,   188,   230,   353,
     730,   741,   753,   761,   416,   421,   325,   790,   790,   729,
     705,   730,   912,   349,   731,   730,   415,   670,   754,   160,
     179,   257,   262,   266,   358,   366,   730,   102,   199,   203,
     233,   329,   415,   730,   351,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,    85,    91,   332,   735,   192,
     237,   343,   345,   347,   675,   775,   766,   188,   692,    85,
     160,   408,   416,   741,   777,   929,   792,   421,   402,   777,
     354,   415,   794,   421,   839,   416,   768,   909,   421,   692,
     763,   647,   775,   776,   421,    94,   159,   372,   272,   266,
     691,   268,   421,   234,   418,   853,   706,   420,   833,   420,
     796,   416,    39,   418,   810,   806,   409,   931,   873,   706,
     924,   934,   924,   706,   416,   799,   777,   780,   799,   778,
     415,   777,   225,   225,   415,   777,   262,   730,   262,   799,
     416,   421,   595,   597,   705,   904,   910,   911,   915,   916,
     930,   351,   351,   437,   437,   799,   799,   777,   777,   468,
     777,   779,   909,   421,   416,   421,   799,   777,   796,   108,
     519,   796,   796,   144,   241,   243,   431,   431,   487,   909,
     909,   777,   343,   777,   909,   777,   777,   122,   269,   466,
     799,   777,   302,   799,   799,   194,   789,   790,   368,   128,
     362,   295,   730,   603,    93,   221,   221,   372,   605,   262,
     569,   794,   560,   560,   221,   569,   337,   338,   475,   794,
     416,   421,   402,   730,    92,   706,   705,   413,   414,   415,
     707,   789,   790,   909,   351,   351,   790,   531,   402,   638,
     638,   638,   638,   638,   637,   488,   790,   437,   183,   445,
     483,   589,   789,   271,   275,   703,   704,   909,   775,   233,
     484,   485,   486,   487,   492,   494,   513,   514,   909,    93,
     383,   384,   511,   195,   794,   775,   308,   617,   497,   498,
     909,    93,   197,   197,   183,   416,   705,   779,   416,   470,
     470,   667,   931,   925,   888,   889,   929,   882,   886,   421,
     590,   194,   576,   577,   909,   151,   730,   771,   772,   416,
     421,   763,   172,   327,   172,   327,   312,   369,   244,   188,
     416,   421,   414,   414,   421,   790,   730,   166,   757,   758,
      93,   416,   372,   416,   416,   416,   416,   421,   416,   188,
     416,   421,   416,   421,   416,   284,   748,   416,   731,   731,
     731,    77,   203,   221,   273,   392,   402,   403,   404,   406,
     407,   408,   409,   410,   411,   738,   731,   416,   416,   183,
     188,   751,   752,   416,   388,   388,   416,   416,    93,   753,
     741,   753,   753,   188,   416,   763,   730,   909,   416,   416,
     388,    90,   170,   741,   188,   179,   262,   266,   358,   366,
     415,   170,   731,   730,   754,   730,   351,   606,   730,   415,
     670,   345,   347,   345,   347,   775,   676,   676,   415,   670,
     693,   694,   695,   700,   701,   733,   773,   702,   741,   741,
     416,   416,     8,    14,    15,    16,    26,    27,    28,    30,
      31,    32,    36,    37,    38,   286,   361,   891,   892,   893,
     885,   792,   631,   790,   729,   453,   706,   416,   763,   770,
     702,   402,   416,   682,   273,   736,   739,   776,   686,   686,
     685,   402,   854,   418,   778,    35,   899,   416,   416,   418,
     281,   302,   730,   495,   415,   415,   497,   470,   592,   597,
     561,   799,   777,   281,   302,   705,   281,   256,   705,   796,
     796,   796,   705,   164,   325,   361,   469,   470,   470,   351,
     351,   437,   789,   414,   416,   705,   569,   569,   779,   416,
     221,   221,   569,   372,   480,   481,   549,   273,   407,   550,
     596,   597,   739,   797,   416,   413,   416,   790,   706,   707,
     406,   407,   408,   409,   410,   414,   416,   271,   151,   785,
     789,   795,   927,   151,   794,   151,   777,   151,   777,   151,
     777,   118,   129,   151,   153,   208,   257,   262,   289,   298,
     365,   489,   490,   491,   361,   343,   775,   532,   416,   421,
     705,   415,   775,   416,   421,   416,   421,   269,   269,   510,
     522,   777,   351,   372,   584,   596,   271,   416,   421,   669,
     669,   864,   470,   416,   470,   470,   143,   421,   402,   581,
     909,   383,   421,   578,   416,   421,   375,   669,   659,   172,
     172,   576,   730,   745,   416,   348,   730,   169,   705,   560,
     790,   730,   730,   790,   730,   751,   705,   731,   160,   257,
     266,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   730,   730,   752,   751,   728,   728,   705,   416,   416,
     416,   741,   416,   725,   794,   732,   731,   730,   416,   730,
     415,   705,   743,   730,    90,   170,   170,   730,   416,   170,
     730,   676,   676,   676,   676,   775,   775,   670,   694,   695,
      93,   696,   909,   421,   137,   189,   209,   224,   231,   249,
     310,   389,   697,   696,    93,   696,   909,   762,   194,   687,
     416,   416,   421,   402,   416,   899,   402,   421,   151,   730,
     415,   935,   392,   813,   351,   351,   416,   497,   497,   416,
     410,   351,   351,   351,   488,   257,   257,   336,   339,   705,
     777,   777,   221,   416,   221,   221,   569,   569,   431,   158,
     153,   208,   257,   539,   540,   541,   790,   383,   384,   414,
     416,   707,   707,   707,   707,   707,   706,   729,   775,   415,
     777,   731,   154,   200,   153,   262,   225,   775,   372,   508,
     705,   775,   183,   533,   275,   704,   484,   173,   204,   493,
     207,   504,   486,   514,   909,    93,    93,   669,   226,   523,
     561,   794,   779,   415,    93,   110,   177,   201,   227,   308,
     319,   333,   340,   380,   598,   599,   156,   213,   320,   369,
     622,   498,   470,   668,   889,   893,   193,   577,   772,   415,
     470,   730,   416,   416,   416,   416,   416,   752,   188,   266,
     415,   416,   729,   743,   416,   421,   731,   730,   730,   170,
     730,   416,   775,   775,   775,   775,   416,   909,   415,   694,
     224,   278,   698,   694,   698,   224,   697,   698,   694,   224,
     415,   909,   415,   108,   196,   688,   892,   407,   786,   789,
     792,   793,   794,   415,   768,   606,   909,   799,   777,   416,
     416,   508,   361,   799,   777,   799,   262,   262,   790,   909,
     372,   471,   569,   221,   569,   569,   476,   794,   154,   200,
     153,   541,   540,   414,   190,   190,   188,   538,   730,   257,
     490,   508,   496,   206,   372,   415,   165,   534,   174,   532,
     416,   152,   152,   415,   383,   384,   505,   794,   188,   415,
     585,   586,   733,   909,   594,   794,   271,   319,   457,   262,
     155,   220,   383,   599,   600,   351,   183,   274,   771,   731,
     415,   731,   416,   705,   730,   696,   415,   776,   694,   271,
     372,   699,   694,   224,   694,   703,   415,   703,   909,   741,
     730,   785,   786,   729,   730,   769,   416,   298,   508,   730,
     569,   104,   138,   157,   170,   184,   262,   269,   294,   477,
     581,    93,   608,   775,   539,   416,   240,   499,   344,   779,
     312,   335,   535,   293,   505,   774,   269,   269,   271,   506,
     560,   730,   416,   421,   372,   560,   587,   587,   421,   262,
     155,   220,   271,   547,   775,   416,   731,   416,   776,   416,
     730,   415,   694,   699,   416,   703,   416,   421,   416,   775,
     643,   643,   257,   294,   643,   643,   608,    96,   183,   189,
     282,   271,   500,   501,   502,   777,    93,   777,   506,   416,
     127,   344,   507,   416,   507,   586,   560,   794,   211,   262,
     702,   416,   416,   776,   416,   769,   496,   794,   789,   262,
     497,   794,   789,   165,   156,   369,   271,   502,   271,   501,
     190,   273,   339,   552,   553,   415,   507,   156,   164,   287,
     777,   587,   702,   211,   161,   416,   499,   497,   312,   111,
     253,   307,   325,   503,   503,   790,   790,   705,   421,   536,
     537,   798,   909,   313,   313,    86,   214,   623,   500,   174,
      81,   151,   262,   783,   606,   553,   416,   421,   258,   415,
     618,   620,   625,   656,   660,   665,   669,   539,   293,   590,
     297,   415,   555,   537,   619,   620,   621,   670,   671,   783,
     605,   416,   418,   415,   416,   621,   536,   555,   416
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 597 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 600 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 606 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 607 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 608 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 609 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 613 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 628 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 629 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 630 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 631 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 632 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 633 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 24:
#line 635 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (pg_strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 25:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 658 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 667 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, c