/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_RELEASE = 290,
     SQL_REFERENCE = 291,
     SQL_RETURNED_LENGTH = 292,
     SQL_RETURNED_OCTET_LENGTH = 293,
     SQL_SCALE = 294,
     SQL_SECTION = 295,
     SQL_SHORT = 296,
     SQL_SIGNED = 297,
     SQL_SQL = 298,
     SQL_SQLERROR = 299,
     SQL_SQLPRINT = 300,
     SQL_SQLWARNING = 301,
     SQL_START = 302,
     SQL_STOP = 303,
     SQL_STRUCT = 304,
     SQL_UNSIGNED = 305,
     SQL_VALUE = 306,
     SQL_VAR = 307,
     SQL_WHENEVER = 308,
     S_ADD = 309,
     S_AND = 310,
     S_ANYTHING = 311,
     S_AUTO = 312,
     S_CONST = 313,
     S_DEC = 314,
     S_DIV = 315,
     S_DOTPOINT = 316,
     S_EQUAL = 317,
     S_EXTERN = 318,
     S_INC = 319,
     S_LSHIFT = 320,
     S_MEMPOINT = 321,
     S_MEMBER = 322,
     S_MOD = 323,
     S_MUL = 324,
     S_NEQUAL = 325,
     S_OR = 326,
     S_REGISTER = 327,
     S_RSHIFT = 328,
     S_STATIC = 329,
     S_SUB = 330,
     S_VOLATILE = 331,
     S_TYPEDEF = 332,
     TYPECAST = 333,
     ABORT_P = 334,
     ABSOLUTE_P = 335,
     ACCESS = 336,
     ACTION = 337,
     ADD = 338,
     AFTER = 339,
     AGGREGATE = 340,
     ALL = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CURRENT_DATE = 393,
     CURRENT_TIME = 394,
     CURRENT_TIMESTAMP = 395,
     CURRENT_USER = 396,
     CURSOR = 397,
     CYCLE = 398,
     DATABASE = 399,
     DAY_P = 400,
     DEALLOCATE = 401,
     DEC = 402,
     DECIMAL_P = 403,
     DECLARE = 404,
     DEFAULT = 405,
     DEFAULTS = 406,
     DEFERRABLE = 407,
     DEFERRED = 408,
     DEFINER = 409,
     DELETE_P = 410,
     DELIMITER = 411,
     DELIMITERS = 412,
     DESC = 413,
     DISTINCT = 414,
     DO = 415,
     DOMAIN_P = 416,
     DOUBLE_P = 417,
     DROP = 418,
     EACH = 419,
     ELSE = 420,
     ENCODING = 421,
     ENCRYPTED = 422,
     END_P = 423,
     ESCAPE = 424,
     EXCEPT = 425,
     EXCLUSIVE = 426,
     EXCLUDING = 427,
     EXECUTE = 428,
     EXISTS = 429,
     EXPLAIN = 430,
     EXTERNAL = 431,
     EXTRACT = 432,
     FALSE_P = 433,
     FETCH = 434,
     FIRST_P = 435,
     FLOAT_P = 436,
     FOR = 437,
     FORCE = 438,
     FOREIGN = 439,
     FORWARD = 440,
     FREEZE = 441,
     FROM = 442,
     FULL = 443,
     FUNCTION = 444,
     GET = 445,
     GLOBAL = 446,
     GRANT = 447,
     GROUP_P = 448,
     HANDLER = 449,
     HAVING = 450,
     HOLD = 451,
     HOUR_P = 452,
     ILIKE = 453,
     IMMEDIATE = 454,
     IMMUTABLE = 455,
     IMPLICIT_P = 456,
     IN_P = 457,
     INCLUDING = 458,
     INCREMENT = 459,
     INDEX = 460,
     INHERITS = 461,
     INITIALLY = 462,
     INNER_P = 463,
     INOUT = 464,
     INPUT_P = 465,
     INSENSITIVE = 466,
     INSERT = 467,
     INSTEAD = 468,
     INT_P = 469,
     INTEGER = 470,
     INTERSECT = 471,
     INTERVAL = 472,
     INTO = 473,
     INVOKER = 474,
     IS = 475,
     ISNULL = 476,
     ISOLATION = 477,
     JOIN = 478,
     KEY = 479,
     LANCOMPILER = 480,
     LANGUAGE = 481,
     LAST_P = 482,
     LEADING = 483,
     LEFT = 484,
     LEVEL = 485,
     LIKE = 486,
     LIMIT = 487,
     LISTEN = 488,
     LOAD = 489,
     LOCAL = 490,
     LOCATION = 491,
     LOCK_P = 492,
     MATCH = 493,
     MAXVALUE = 494,
     MINUTE_P = 495,
     MINVALUE = 496,
     MODE = 497,
     MONTH_P = 498,
     MOVE = 499,
     NAMES = 500,
     NATIONAL = 501,
     NATURAL = 502,
     NCHAR = 503,
     NEW = 504,
     NEXT = 505,
     NO = 506,
     NOCREATEDB = 507,
     NOCREATEUSER = 508,
     NONE = 509,
     NOT = 510,
     NOTHING = 511,
     NOTIFY = 512,
     NOTNULL = 513,
     NULL_P = 514,
     NULLIF = 515,
     NUMERIC = 516,
     OF = 517,
     OFF = 518,
     OFFSET = 519,
     OIDS = 520,
     OLD = 521,
     ON = 522,
     ONLY = 523,
     OPERATOR = 524,
     OPTION = 525,
     OR = 526,
     ORDER = 527,
     OUT_P = 528,
     OUTER_P = 529,
     OVERLAPS = 530,
     OVERLAY = 531,
     OWNER = 532,
     PARTIAL = 533,
     PASSWORD = 534,
     PATH_P = 535,
     PENDANT = 536,
     PLACING = 537,
     POSITION = 538,
     PRECISION = 539,
     PRESERVE = 540,
     PREPARE = 541,
     PRIMARY = 542,
     PRIOR = 543,
     PRIVILEGES = 544,
     PROCEDURAL = 545,
     PROCEDURE = 546,
     READ = 547,
     REAL = 548,
     RECHECK = 549,
     REFERENCES = 550,
     REINDEX = 551,
     RELATIVE_P = 552,
     RENAME = 553,
     REPLACE = 554,
     RESET = 555,
     RESTART = 556,
     RESTRICT = 557,
     RETURNS = 558,
     REVOKE = 559,
     RIGHT = 560,
     ROLLBACK = 561,
     ROW = 562,
     ROWS = 563,
     RULE = 564,
     SCHEMA = 565,
     SCROLL = 566,
     SECOND_P = 567,
     SECURITY = 568,
     SELECT = 569,
     SEQUENCE = 570,
     SERIALIZABLE = 571,
     SESSION = 572,
     SESSION_USER = 573,
     SET = 574,
     SETOF = 575,
     SHARE = 576,
     SHOW = 577,
     SIMILAR = 578,
     SIMPLE = 579,
     SMALLINT = 580,
     SOME = 581,
     STABLE = 582,
     START = 583,
     STATEMENT = 584,
     STATISTICS = 585,
     STDIN = 586,
     STDOUT = 587,
     STORAGE = 588,
     STRICT_P = 589,
     SUBSTRING = 590,
     SYSID = 591,
     TABLE = 592,
     TEMP = 593,
     TEMPLATE = 594,
     TEMPORARY = 595,
     THEN = 596,
     TIME = 597,
     TIMESTAMP = 598,
     TO = 599,
     TOAST = 600,
     TRAILING = 601,
     TRANSACTION = 602,
     TREAT = 603,
     TRIGGER = 604,
     TRIM = 605,
     TRUE_P = 606,
     TRUNCATE = 607,
     TRUSTED = 608,
     TYPE_P = 609,
     UNENCRYPTED = 610,
     UNION = 611,
     UNIQUE = 612,
     UNKNOWN = 613,
     UNLISTEN = 614,
     UNTIL = 615,
     UPDATE = 616,
     USAGE = 617,
     USER = 618,
     USING = 619,
     VACUUM = 620,
     VALID = 621,
     VALUES = 622,
     VARCHAR = 623,
     VARYING = 624,
     VERBOSE = 625,
     VERSION = 626,
     VIEW = 627,
     VOLATILE = 628,
     WHEN = 629,
     WHERE = 630,
     WITH = 631,
     WITHOUT = 632,
     WORK = 633,
     WRITE = 634,
     YEAR_P = 635,
     ZONE = 636,
     UNIONJOIN = 637,
     IDENT = 638,
     SCONST = 639,
     Op = 640,
     CSTRING = 641,
     CVARIABLE = 642,
     CPP_LINE = 643,
     IP = 644,
     BCONST = 645,
     XCONST = 646,
     ICONST = 647,
     PARAM = 648,
     FCONST = 649,
     POSTFIXOP = 650,
     UMINUS = 651
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_RELEASE 290
#define SQL_REFERENCE 291
#define SQL_RETURNED_LENGTH 292
#define SQL_RETURNED_OCTET_LENGTH 293
#define SQL_SCALE 294
#define SQL_SECTION 295
#define SQL_SHORT 296
#define SQL_SIGNED 297
#define SQL_SQL 298
#define SQL_SQLERROR 299
#define SQL_SQLPRINT 300
#define SQL_SQLWARNING 301
#define SQL_START 302
#define SQL_STOP 303
#define SQL_STRUCT 304
#define SQL_UNSIGNED 305
#define SQL_VALUE 306
#define SQL_VAR 307
#define SQL_WHENEVER 308
#define S_ADD 309
#define S_AND 310
#define S_ANYTHING 311
#define S_AUTO 312
#define S_CONST 313
#define S_DEC 314
#define S_DIV 315
#define S_DOTPOINT 316
#define S_EQUAL 317
#define S_EXTERN 318
#define S_INC 319
#define S_LSHIFT 320
#define S_MEMPOINT 321
#define S_MEMBER 322
#define S_MOD 323
#define S_MUL 324
#define S_NEQUAL 325
#define S_OR 326
#define S_REGISTER 327
#define S_RSHIFT 328
#define S_STATIC 329
#define S_SUB 330
#define S_VOLATILE 331
#define S_TYPEDEF 332
#define TYPECAST 333
#define ABORT_P 334
#define ABSOLUTE_P 335
#define ACCESS 336
#define ACTION 337
#define ADD 338
#define AFTER 339
#define AGGREGATE 340
#define ALL 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CURRENT_DATE 393
#define CURRENT_TIME 394
#define CURRENT_TIMESTAMP 395
#define CURRENT_USER 396
#define CURSOR 397
#define CYCLE 398
#define DATABASE 399
#define DAY_P 400
#define DEALLOCATE 401
#define DEC 402
#define DECIMAL_P 403
#define DECLARE 404
#define DEFAULT 405
#define DEFAULTS 406
#define DEFERRABLE 407
#define DEFERRED 408
#define DEFINER 409
#define DELETE_P 410
#define DELIMITER 411
#define DELIMITERS 412
#define DESC 413
#define DISTINCT 414
#define DO 415
#define DOMAIN_P 416
#define DOUBLE_P 417
#define DROP 418
#define EACH 419
#define ELSE 420
#define ENCODING 421
#define ENCRYPTED 422
#define END_P 423
#define ESCAPE 424
#define EXCEPT 425
#define EXCLUSIVE 426
#define EXCLUDING 427
#define EXECUTE 428
#define EXISTS 429
#define EXPLAIN 430
#define EXTERNAL 431
#define EXTRACT 432
#define FALSE_P 433
#define FETCH 434
#define FIRST_P 435
#define FLOAT_P 436
#define FOR 437
#define FORCE 438
#define FOREIGN 439
#define FORWARD 440
#define FREEZE 441
#define FROM 442
#define FULL 443
#define FUNCTION 444
#define GET 445
#define GLOBAL 446
#define GRANT 447
#define GROUP_P 448
#define HANDLER 449
#define HAVING 450
#define HOLD 451
#define HOUR_P 452
#define ILIKE 453
#define IMMEDIATE 454
#define IMMUTABLE 455
#define IMPLICIT_P 456
#define IN_P 457
#define INCLUDING 458
#define INCREMENT 459
#define INDEX 460
#define INHERITS 461
#define INITIALLY 462
#define INNER_P 463
#define INOUT 464
#define INPUT_P 465
#define INSENSITIVE 466
#define INSERT 467
#define INSTEAD 468
#define INT_P 469
#define INTEGER 470
#define INTERSECT 471
#define INTERVAL 472
#define INTO 473
#define INVOKER 474
#define IS 475
#define ISNULL 476
#define ISOLATION 477
#define JOIN 478
#define KEY 479
#define LANCOMPILER 480
#define LANGUAGE 481
#define LAST_P 482
#define LEADING 483
#define LEFT 484
#define LEVEL 485
#define LIKE 486
#define LIMIT 487
#define LISTEN 488
#define LOAD 489
#define LOCAL 490
#define LOCATION 491
#define LOCK_P 492
#define MATCH 493
#define MAXVALUE 494
#define MINUTE_P 495
#define MINVALUE 496
#define MODE 497
#define MONTH_P 498
#define MOVE 499
#define NAMES 500
#define NATIONAL 501
#define NATURAL 502
#define NCHAR 503
#define NEW 504
#define NEXT 505
#define NO 506
#define NOCREATEDB 507
#define NOCREATEUSER 508
#define NONE 509
#define NOT 510
#define NOTHING 511
#define NOTIFY 512
#define NOTNULL 513
#define NULL_P 514
#define NULLIF 515
#define NUMERIC 516
#define OF 517
#define OFF 518
#define OFFSET 519
#define OIDS 520
#define OLD 521
#define ON 522
#define ONLY 523
#define OPERATOR 524
#define OPTION 525
#define OR 526
#define ORDER 527
#define OUT_P 528
#define OUTER_P 529
#define OVERLAPS 530
#define OVERLAY 531
#define OWNER 532
#define PARTIAL 533
#define PASSWORD 534
#define PATH_P 535
#define PENDANT 536
#define PLACING 537
#define POSITION 538
#define PRECISION 539
#define PRESERVE 540
#define PREPARE 541
#define PRIMARY 542
#define PRIOR 543
#define PRIVILEGES 544
#define PROCEDURAL 545
#define PROCEDURE 546
#define READ 547
#define REAL 548
#define RECHECK 549
#define REFERENCES 550
#define REINDEX 551
#define RELATIVE_P 552
#define RENAME 553
#define REPLACE 554
#define RESET 555
#define RESTART 556
#define RESTRICT 557
#define RETURNS 558
#define REVOKE 559
#define RIGHT 560
#define ROLLBACK 561
#define ROW 562
#define ROWS 563
#define RULE 564
#define SCHEMA 565
#define SCROLL 566
#define SECOND_P 567
#define SECURITY 568
#define SELECT 569
#define SEQUENCE 570
#define SERIALIZABLE 571
#define SESSION 572
#define SESSION_USER 573
#define SET 574
#define SETOF 575
#define SHARE 576
#define SHOW 577
#define SIMILAR 578
#define SIMPLE 579
#define SMALLINT 580
#define SOME 581
#define STABLE 582
#define START 583
#define STATEMENT 584
#define STATISTICS 585
#define STDIN 586
#define STDOUT 587
#define STORAGE 588
#define STRICT_P 589
#define SUBSTRING 590
#define SYSID 591
#define TABLE 592
#define TEMP 593
#define TEMPLATE 594
#define TEMPORARY 595
#define THEN 596
#define TIME 597
#define TIMESTAMP 598
#define TO 599
#define TOAST 600
#define TRAILING 601
#define TRANSACTION 602
#define TREAT 603
#define TRIGGER 604
#define TRIM 605
#define TRUE_P 606
#define TRUNCATE 607
#define TRUSTED 608
#define TYPE_P 609
#define UNENCRYPTED 610
#define UNION 611
#define UNIQUE 612
#define UNKNOWN 613
#define UNLISTEN 614
#define UNTIL 615
#define UPDATE 616
#define USAGE 617
#define USER 618
#define USING 619
#define VACUUM 620
#define VALID 621
#define VALUES 622
#define VARCHAR 623
#define VARYING 624
#define VERBOSE 625
#define VERSION 626
#define VIEW 627
#define VOLATILE 628
#define WHEN 629
#define WHERE 630
#define WITH 631
#define WITHOUT 632
#define WORK 633
#define WRITE 634
#define YEAR_P 635
#define ZONE 636
#define UNIONJOIN 637
#define IDENT 638
#define SCONST 639
#define Op 640
#define CSTRING 641
#define CVARIABLE 642
#define CPP_LINE 643
#define IP 644
#define BCONST 645
#define XCONST 646
#define ICONST 647
#define PARAM 648
#define FCONST 649
#define POSTFIXOP 650
#define UMINUS 651




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	errortext[128];
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_storage[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error)
{
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "%s:%d: WARNING: %s\n", input_filename, yylineno, error);
			break;
		case ET_ERROR:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			ret_value = error_code;
			break;
		case ET_FATAL:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if (atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		snprintf(errortext, sizeof(errortext), "trying to access an undeclared cursor %s\n", name);
		mmerror(PARSE_ERROR, ET_ERROR, errortext);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 285 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1162 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1174 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   48052

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  417
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  491
/* YYNRULES -- Number of rules. */
#define YYNRULES  1844
/* YYNRULES -- Number of states. */
#define YYNSTATES  3016

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   652

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   403,     2,     2,
     408,   409,   401,   399,   414,   400,   410,   402,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   416,   411,
     396,   395,   397,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   406,     2,   407,   404,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   412,     2,   413,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     398,   405,   415
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   216,   218,   219,   224,   230,   236,   241,
     245,   248,   249,   252,   255,   257,   259,   261,   263,   267,
     271,   275,   277,   282,   288,   291,   292,   295,   298,   305,
     312,   316,   324,   329,   331,   332,   335,   336,   338,   340,
     342,   345,   349,   353,   357,   361,   365,   368,   374,   377,
     381,   385,   387,   389,   391,   395,   398,   400,   402,   404,
     406,   408,   410,   412,   414,   416,   418,   422,   429,   431,
     433,   435,   437,   438,   440,   442,   445,   449,   454,   458,
     461,   464,   468,   473,   477,   480,   485,   487,   489,   491,
     493,   495,   502,   510,   520,   530,   540,   550,   558,   564,
     572,   579,   586,   593,   600,   604,   607,   609,   611,   612,
     615,   625,   627,   629,   631,   633,   635,   638,   639,   641,
     643,   647,   651,   653,   654,   657,   658,   662,   663,   665,
     666,   677,   689,   691,   693,   696,   699,   702,   705,   706,
     708,   709,   711,   715,   717,   719,   721,   725,   728,   729,
     733,   735,   737,   740,   742,   744,   747,   752,   755,   761,
     763,   766,   769,   772,   776,   779,   782,   783,   787,   789,
     794,   799,   805,   817,   821,   822,   826,   828,   830,   833,
     836,   837,   839,   841,   844,   847,   848,   852,   856,   859,
     861,   863,   866,   869,   874,   875,   878,   881,   882,   886,
     891,   896,   897,   898,   907,   911,   912,   916,   918,   920,
     926,   931,   934,   935,   938,   940,   943,   947,   950,   953,
     956,   959,   963,   967,   969,   970,   979,   981,   982,   984,
     986,   989,   990,   996,   998,   999,  1014,  1034,  1036,  1038,
    1040,  1044,  1050,  1052,  1054,  1056,  1060,  1061,  1063,  1064,
    1066,  1068,  1070,  1074,  1075,  1077,  1079,  1080,  1083,  1085,
    1088,  1090,  1093,  1096,  1098,  1101,  1104,  1111,  1120,  1124,
    1129,  1134,  1139,  1145,  1149,  1153,  1155,  1159,  1163,  1165,
    1167,  1169,  1171,  1184,  1186,  1190,  1195,  1203,  1208,  1211,
    1213,  1214,  1216,  1217,  1225,  1230,  1232,  1234,  1236,  1238,
    1240,  1242,  1244,  1246,  1248,  1252,  1254,  1256,  1260,  1266,
    1271,  1276,  1280,  1285,  1289,  1293,  1296,  1301,  1304,  1306,
    1308,  1310,  1312,  1315,  1318,  1320,  1322,  1324,  1327,  1330,
    1332,  1335,  1338,  1340,  1342,  1344,  1351,  1361,  1369,  1379,
    1388,  1397,  1404,  1406,  1408,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1434,  1443,  1446,  1448,  1450,  1452,
    1456,  1458,  1460,  1462,  1464,  1466,  1468,  1470,  1472,  1474,
    1476,  1478,  1480,  1482,  1485,  1488,  1491,  1494,  1497,  1499,
    1503,  1505,  1508,  1512,  1513,  1517,  1518,  1520,  1524,  1527,
    1539,  1541,  1542,  1545,  1546,  1548,  1552,  1555,  1561,  1566,
    1568,  1571,  1572,  1582,  1585,  1586,  1590,  1593,  1595,  1599,
    1602,  1604,  1606,  1608,  1610,  1612,  1616,  1618,  1620,  1625,
    1627,  1630,  1633,  1636,  1638,  1640,  1642,  1647,  1653,  1655,
    1659,  1663,  1666,  1669,  1672,  1673,  1679,  1687,  1689,  1691,
    1699,  1701,  1705,  1709,  1713,  1715,  1719,  1731,  1742,  1745,
    1746,  1755,  1760,  1765,  1767,  1769,  1771,  1772,  1782,  1789,
    1796,  1804,  1811,  1818,  1828,  1835,  1844,  1853,  1860,  1862,
    1863,  1865,  1866,  1867,  1882,  1884,  1886,  1890,  1894,  1896,
    1898,  1900,  1902,  1904,  1906,  1908,  1909,  1911,  1913,  1915,
    1917,  1919,  1920,  1927,  1930,  1933,  1936,  1939,  1942,  1945,
    1949,  1952,  1955,  1958,  1960,  1962,  1963,  1967,  1969,  1974,
    1979,  1981,  1982,  1985,  1988,  1996,  1999,  2005,  2009,  2011,
    2014,  2018,  2022,  2026,  2030,  2034,  2038,  2042,  2046,  2048,
    2049,  2055,  2060,  2064,  2071,  2076,  2083,  2090,  2096,  2104,
    2111,  2113,  2114,  2125,  2130,  2133,  2135,  2140,  2146,  2152,
    2155,  2160,  2162,  2164,  2166,  2167,  2169,  2170,  2172,  2173,
    2177,  2178,  2183,  2185,  2187,  2189,  2191,  2193,  2195,  2196,
    2201,  2206,  2209,  2211,  2219,  2224,  2228,  2230,  2233,  2238,
    2243,  2247,  2248,  2251,  2254,  2257,  2261,  2263,  2267,  2269,
    2272,  2279,  2287,  2288,  2291,  2294,  2297,  2301,  2302,  2305,
    2308,  2310,  2312,  2316,  2320,  2322,  2325,  2330,  2335,  2337,
    2339,  2348,  2353,  2358,  2363,  2366,  2368,  2369,  2373,  2377,
    2382,  2387,  2392,  2397,  2400,  2402,  2404,  2405,  2407,  2408,
    2410,  2416,  2418,  2419,  2421,  2422,  2426,  2428,  2432,  2436,
    2439,  2442,  2444,  2449,  2454,  2457,  2460,  2465,  2467,  2468,
    2470,  2472,  2474,  2478,  2479,  2482,  2483,  2487,  2491,  2493,
    2494,  2497,  2498,  2501,  2502,  2506,  2508,  2510,  2513,  2515,
    2518,  2524,  2531,  2537,  2539,  2542,  2544,  2549,  2553,  2558,
    2562,  2568,  2573,  2579,  2584,  2590,  2593,  2598,  2600,  2603,
    2606,  2609,  2611,  2613,  2614,  2619,  2622,  2624,  2627,  2630,
    2635,  2639,  2644,  2647,  2648,  2650,  2654,  2657,  2660,  2664,
    2670,  2677,  2681,  2686,  2687,  2689,  2693,  2697,  2701,  2705,
    2709,  2713,  2715,  2717,  2719,  2721,  2723,  2725,  2727,  2730,
    2736,  2739,  2741,  2743,  2745,  2747,  2749,  2751,  2753,  2755,
    2757,  2759,  2761,  2764,  2767,  2770,  2773,  2776,  2778,  2782,
    2783,  2789,  2793,  2794,  2800,  2804,  2805,  2807,  2809,  2811,
    2813,  2819,  2822,  2824,  2826,  2828,  2830,  2836,  2839,  2842,
    2845,  2847,  2851,  2855,  2858,  2860,  2861,  2865,  2866,  2872,
    2875,  2881,  2884,  2886,  2890,  2894,  2895,  2897,  2899,  2901,
    2903,  2905,  2907,  2911,  2915,  2919,  2923,  2927,  2931,  2935,
    2936,  2940,  2945,  2950,  2954,  2958,  2962,  2967,  2971,  2977,
    2982,  2987,  2991,  2995,  2999,  3001,  3003,  3005,  3007,  3009,
    3011,  3013,  3015,  3017,  3019,  3021,  3023,  3025,  3027,  3029,
    3034,  3036,  3041,  3043,  3047,  3053,  3056,  3059,  3062,  3065,
    3068,  3071,  3075,  3079,  3083,  3087,  3091,  3095,  3099,  3103,
    3107,  3111,  3114,  3117,  3121,  3125,  3128,  3132,  3138,  3143,
    3150,  3154,  3160,  3165,  3172,  3177,  3184,  3190,  3198,  3201,
    3205,  3208,  3213,  3217,  3222,  3226,  3231,  3235,  3240,  3246,
    3253,  3261,  3267,  3274,  3278,  3283,  3288,  3295,  3298,  3300,
    3302,  3306,  3309,  3312,  3315,  3318,  3321,  3325,  3329,  3333,
    3337,  3341,  3345,  3349,  3353,  3357,  3361,  3364,  3367,  3373,
    3380,  3388,  3390,  3392,  3396,  3402,  3407,  3409,  3413,  3418,
    3424,  3430,  3435,  3437,  3440,  3445,  3448,  3453,  3456,  3459,
    3462,  3469,  3474,  3479,  3484,  3489,  3496,  3502,  3508,  3514,
    3519,  3526,  3531,  3533,  3536,  3539,  3542,  3547,  3554,  3555,
    3557,  3561,  3565,  3566,  3570,  3572,  3574,  3578,  3582,  3586,
    3588,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3607,  3611,
    3614,  3618,  3619,  3623,  3627,  3630,  3633,  3635,  3636,  3639,
    3642,  3646,  3649,  3651,  3653,  3657,  3663,  3670,  3675,  3678,
    3680,  3685,  3688,  3689,  3691,  3692,  3695,  3698,  3701,  3704,
    3707,  3711,  3714,  3715,  3719,  3721,  3725,  3727,  3729,  3733,
    3741,  3743,  3746,  3751,  3753,  3757,  3762,  3767,  3771,  3773,
    3775,  3777,  3779,  3781,  3783,  3787,  3789,  3791,  3793,  3797,
    3799,  3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3818,
    3822,  3829,  3832,  3834,  3836,  3838,  3840,  3842,  3844,  3846,
    3848,  3850,  3852,  3854,  3856,  3859,  3861,  3863,  3865,  3867,
    3869,  3871,  3873,  3876,  3879,  3881,  3883,  3885,  3887,  3889,
    3891,  3893,  3895,  3897,  3899,  3901,  3903,  3909,  3913,  3916,
    3919,  3923,  3931,  3933,  3936,  3939,  3941,  3942,  3944,  3948,
    3950,  3953,  3954,  3957,  3958,  3961,  3962,  3964,  3968,  3973,
    3977,  3979,  3981,  3983,  3986,  3987,  3995,  3999,  4002,  4004,
    4006,  4008,  4009,  4015,  4016,  4021,  4024,  4026,  4029,  4030,
    4032,  4036,  4040,  4044,  4048,  4050,  4052,  4055,  4057,  4058,
    4063,  4069,  4075,  4076,  4078,  4080,  4082,  4085,  4088,  4090,
    4093,  4094,  4102,  4103,  4109,  4110,  4115,  4118,  4121,  4123,
    4125,  4127,  4129,  4131,  4133,  4135,  4137,  4139,  4141,  4143,
    4149,  4151,  4154,  4156,  4160,  4163,  4166,  4170,  4171,  4177,
    4179,  4180,  4186,  4189,  4192,  4194,  4196,  4198,  4201,  4204,
    4208,  4210,  4213,  4216,  4220,  4224,  4229,  4232,  4234,  4237,
    4239,  4241,  4244,  4247,  4251,  4253,  4255,  4257,  4258,  4260,
    4264,  4269,  4270,  4273,  4274,  4276,  4279,  4283,  4286,  4288,
    4290,  4292,  4293,  4295,  4297,  4301,  4302,  4307,  4310,  4313,
    4315,  4317,  4318,  4320,  4322,  4324,  4326,  4329,  4333,  4334,
    4336,  4339,  4344,  4349,  4350,  4352,  4354,  4356,  4359,  4361,
    4363,  4367,  4369,  4374,  4379,  4384,  4389,  4391,  4392,  4396,
    4400,  4404,  4406,  4410,  4412,  4414,  4416,  4418,  4420,  4422,
    4424,  4426,  4428,  4430,  4432,  4434,  4436,  4438,  4440,  4442,
    4446,  4448,  4452,  4457,  4464,  4471,  4474,  4479,  4484,  4486,
    4488,  4493,  4498,  4502,  4503,  4511,  4513,  4514,  4515,  4523,
    4527,  4532,  4536,  4538,  4540,  4542,  4545,  4549,  4555,  4558,
    4564,  4567,  4569,  4571,  4573,  4575,  4577,  4579,  4581,  4583,
    4585,  4587,  4589,  4591,  4593,  4595,  4597,  4599,  4601,  4603,
    4605,  4607,  4609,  4611,  4613,  4615,  4617,  4619,  4621,  4623,
    4625,  4627,  4629,  4631,  4633,  4635,  4637,  4639,  4641,  4643,
    4645,  4647,  4649,  4651,  4653,  4655,  4657,  4659,  4661,  4663,
    4665,  4667,  4669,  4671,  4673,  4675,  4677,  4679,  4681,  4683,
    4685,  4687,  4689,  4691,  4693,  4695,  4697,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4715,  4717,  4719,  4721,  4723,
    4725,  4727,  4729,  4731,  4733,  4735,  4737,  4739,  4741,  4743,
    4745,  4747,  4749,  4751,  4753,  4755,  4757,  4759,  4761,  4763,
    4765,  4767,  4769,  4771,  4773,  4775,  4777,  4779,  4781,  4783,
    4785,  4787,  4789,  4791,  4793,  4795,  4797,  4799,  4801,  4803,
    4805,  4807,  4809,  4811,  4813,  4815,  4817,  4819,  4821,  4823,
    4825,  4827,  4829,  4831,  4833,  4835,  4837,  4839,  4841,  4843,
    4845,  4847,  4849,  4851,  4853,  4855,  4857,  4859,  4861,  4863,
    4865,  4867,  4869,  4871,  4873,  4875,  4877,  4879,  4881,  4883,
    4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,
    4905,  4907,  4909,  4911,  4913,  4915,  4917,  4919,  4921,  4923,
    4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,
    4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,  4961,  4963,
    4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,  4981,  4983,
    4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5003,
    5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,  5021,  5023,
    5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,  5081,  5083,
    5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,  5103,
    5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,  5141,  5143,
    5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,  5161,  5163,
    5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,  5181,  5183,
    5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5241,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,  5261,  5263,
    5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,  5281,  5283,
    5285,  5287,  5291,  5293,  5294,  5296,  5299,  5301,  5304,  5306,
    5308,  5311,  5314,  5316,  5318,  5320,  5322,  5324,  5327,  5331,
    5333,  5336,  5338,  5342,  5344,  5348,  5350,  5352,  5354,  5356,
    5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     418,     0,    -1,   419,    -1,    -1,   419,   420,    -1,   894,
     421,   422,   411,    -1,   894,   422,   411,    -1,   894,   792,
      -1,   801,    -1,   906,    -1,   388,    -1,   412,    -1,   413,
      -1,    97,   778,    -1,   618,    -1,   621,    -1,   434,    -1,
     500,    -1,   456,    -1,   426,    -1,   425,    -1,   626,    -1,
     455,    -1,   459,    -1,   624,    -1,   547,    -1,   452,    -1,
     460,    -1,   494,    -1,   524,    -1,   586,    -1,   623,    -1,
     620,    -1,   568,    -1,   431,    -1,   504,    -1,   532,    -1,
     436,    -1,   499,    -1,   469,    -1,   510,    -1,   423,    -1,
     614,    -1,   644,    -1,   526,    -1,   639,    -1,   525,    -1,
     588,    -1,   435,    -1,   537,    -1,   508,    -1,   603,    -1,
     538,    -1,   523,    -1,   427,    -1,   619,    -1,   632,    -1,
     543,    -1,   550,    -1,   562,    -1,   635,    -1,   605,    -1,
     613,    -1,   640,    -1,   604,    -1,   589,    -1,   581,    -1,
     583,    -1,   580,    -1,   592,    -1,   551,    -1,   595,    -1,
     647,    -1,   607,    -1,   542,    -1,   606,    -1,   643,    -1,
     625,    -1,   440,    -1,   450,    -1,   451,    -1,   612,    -1,
     858,    -1,   777,    -1,   790,    -1,   791,    -1,   857,    -1,
     834,    -1,   855,    -1,   835,    -1,   838,    -1,   843,    -1,
     866,    -1,   865,    -1,   844,    -1,   854,    -1,   867,    -1,
     868,    -1,   870,    -1,   871,    -1,   874,    -1,   876,    -1,
     134,   363,   775,   424,   428,    -1,   376,    -1,    -1,    87,
     363,   775,   428,    -1,    87,   363,   775,   376,   428,    -1,
      87,   363,   775,   319,   441,    -1,    87,   363,   775,   451,
      -1,   163,   363,   430,    -1,   428,   429,    -1,    -1,   279,
     767,    -1,   336,   768,    -1,   135,    -1,   252,    -1,   136,
      -1,   253,    -1,   202,   193,   430,    -1,   366,   360,   767,
      -1,   430,   414,   775,    -1,   775,    -1,   134,   193,   775,
     432,    -1,   134,   193,   775,   376,   432,    -1,   432,   433,
      -1,    -1,   363,   430,    -1,   336,   768,    -1,    87,   193,
     775,    83,   363,   430,    -1,    87,   193,   775,   163,   363,
     430,    -1,   163,   193,   775,    -1,   134,   310,   775,   437,
      98,   775,   438,    -1,   134,   310,   883,   438,    -1,   883,
      -1,    -1,   438,   439,    -1,    -1,   469,    -1,   550,    -1,
     612,    -1,   319,   441,    -1,   319,   235,   441,    -1,   319,
     317,   441,    -1,   883,   344,   442,    -1,   883,   415,   442,
      -1,   342,   381,   447,    -1,   347,   609,    -1,   317,   117,
      93,   347,   609,    -1,   245,   448,    -1,   317,    98,   449,
      -1,   317,    98,   150,    -1,   443,    -1,   150,    -1,   445,
      -1,   443,   414,   445,    -1,   292,   128,    -1,   316,    -1,
     446,    -1,   773,    -1,   883,    -1,   351,    -1,   178,    -1,
     267,    -1,   263,    -1,   773,    -1,   900,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   150,
      -1,   235,    -1,   770,    -1,   150,    -1,    -1,   883,    -1,
     770,    -1,   322,   883,    -1,   322,   342,   381,    -1,   322,
     347,   222,   230,    -1,   322,   317,    98,    -1,   322,    86,
      -1,   300,   883,    -1,   300,   342,   381,    -1,   300,   347,
     222,   230,    -1,   300,   317,    98,    -1,   300,    86,    -1,
     319,   130,   453,   454,    -1,    86,    -1,   754,    -1,   153,
      -1,   199,    -1,   119,    -1,    87,   337,   678,    83,   594,
     474,    -1,    87,   337,   678,    87,   594,   883,   457,    -1,
      87,   337,   678,    87,   594,   883,   163,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   330,   768,    -1,
      87,   337,   678,    87,   594,   883,   319,   333,   883,    -1,
      87,   337,   678,   163,   594,   883,   458,    -1,    87,   337,
     678,    83,   481,    -1,    87,   337,   678,   163,   129,   755,
     458,    -1,    87,   337,   678,   319,   377,   265,    -1,    87,
     337,   753,   134,   345,   337,    -1,    87,   337,   753,   277,
     344,   775,    -1,    87,   337,   753,   122,   267,   755,    -1,
     319,   150,   716,    -1,   163,   150,    -1,   111,    -1,   302,
      -1,    -1,   121,   755,    -1,   133,   465,   753,   466,   461,
     462,   467,   424,   463,    -1,   344,    -1,   187,    -1,   770,
      -1,   331,    -1,   332,    -1,   463,   464,    -1,    -1,   104,
      -1,   265,    -1,   156,   622,   770,    -1,   259,   622,   770,
      -1,   104,    -1,    -1,   376,   265,    -1,    -1,   468,   157,
     770,    -1,    -1,   364,    -1,    -1,   134,   470,   337,   753,
     408,   471,   409,   491,   492,   493,    -1,   134,   470,   337,
     753,   262,   753,   408,   471,   409,   492,   493,    -1,   340,
      -1,   338,    -1,   235,   340,    -1,   235,   338,    -1,   191,
     340,    -1,   191,   338,    -1,    -1,   472,    -1,    -1,   473,
      -1,   472,   414,   473,    -1,   474,    -1,   479,    -1,   481,
      -1,   883,   683,   475,    -1,   475,   476,    -1,    -1,   129,
     755,   477,    -1,   477,    -1,   478,    -1,   255,   259,    -1,
     259,    -1,   357,    -1,   287,   224,    -1,   118,   408,   716,
     409,    -1,   150,   717,    -1,   295,   753,   483,   486,   487,
      -1,   152,    -1,   255,   152,    -1,   207,   153,    -1,   207,
     199,    -1,   231,   753,   480,    -1,   203,   151,    -1,   172,
     151,    -1,    -1,   129,   755,   482,    -1,   482,    -1,   118,
     408,   716,   409,    -1,   357,   408,   484,   409,    -1,   287,
     224,   408,   484,   409,    -1,   184,   224,   408,   484,   409,
     295,   753,   483,   486,   487,   520,    -1,   408,   484,   409,
      -1,    -1,   484,   414,   485,    -1,   485,    -1,   883,    -1,
     238,   188,    -1,   238,   278,    -1,    -1,   488,    -1,   489,
      -1,   488,   489,    -1,   489,   488,    -1,    -1,   267,   155,
     490,    -1,   267,   361,   490,    -1,   251,    82,    -1,   302,
      -1,   111,    -1,   319,   150,    -1,   319,   259,    -1,   206,
     408,   752,   409,    -1,    -1,   376,   265,    -1,   377,   265,
      -1,    -1,   267,   127,   163,    -1,   267,   127,   155,   308,
      -1,   267,   127,   285,   308,    -1,    -1,    -1,   134,   470,
     337,   753,   496,    93,   495,   647,    -1,   408,   497,   409,
      -1,    -1,   497,   414,   498,    -1,   498,    -1,   883,    -1,
     134,   470,   315,   753,   501,    -1,    87,   315,   753,   501,
      -1,   501,   502,    -1,    -1,   109,   772,    -1,   143,    -1,
     251,   143,    -1,   204,   503,   772,    -1,   239,   772,    -1,
     241,   772,    -1,   251,   239,    -1,   251,   241,    -1,   328,
     424,   772,    -1,   301,   424,   772,    -1,   108,    -1,    -1,
     134,   505,   509,   226,   449,   194,   506,   507,    -1,   353,
      -1,    -1,   755,    -1,   740,    -1,   225,   770,    -1,    -1,
     163,   509,   226,   770,   458,    -1,   290,    -1,    -1,   134,
     349,   755,   511,   512,   267,   753,   514,   173,   291,   755,
     408,   517,   409,    -1,   134,   129,   349,   755,    84,   512,
     267,   753,   519,   520,   182,   164,   307,   173,   291,   761,
     408,   517,   409,    -1,   100,    -1,    84,    -1,   513,    -1,
     513,   271,   513,    -1,   513,   271,   513,   271,   513,    -1,
     212,    -1,   155,    -1,   361,    -1,   182,   515,   516,    -1,
      -1,   164,    -1,    -1,   307,    -1,   329,    -1,   518,    -1,
     517,   414,   518,    -1,    -1,   774,    -1,   883,    -1,    -1,
     187,   753,    -1,   521,    -1,   521,   522,    -1,   522,    -1,
     522,   521,    -1,   255,   152,    -1,   152,    -1,   207,   199,
      -1,   207,   153,    -1,   163,   349,   755,   267,   753,   458,
      -1,   134,    95,   755,   118,   408,   716,   409,   520,    -1,
     163,    95,   755,    -1,   134,    85,   761,   528,    -1,   134,
     269,   712,   528,    -1,   134,   354,   541,   528,    -1,   134,
     354,   541,    93,   527,    -1,   408,   681,   409,    -1,   408,
     529,   409,    -1,   530,    -1,   529,   414,   530,    -1,   886,
     395,   531,    -1,   886,    -1,   575,    -1,   715,    -1,   773,
      -1,   134,   269,   120,   541,   535,   182,   354,   683,   364,
     757,    93,   533,    -1,   534,    -1,   533,   414,   534,    -1,
     269,   768,   585,   536,    -1,   269,   768,   585,   408,   584,
     409,   536,    -1,   189,   768,   761,   570,    -1,   333,   683,
      -1,   150,    -1,    -1,   294,    -1,    -1,   163,   269,   120,
     541,   364,   757,   458,    -1,   163,   539,   540,   458,    -1,
     337,    -1,   315,    -1,   372,    -1,   205,    -1,   354,    -1,
     161,    -1,   131,    -1,   310,    -1,   541,    -1,   540,   414,
     541,    -1,   883,    -1,   740,    -1,   352,   654,   753,    -1,
     179,   544,   546,   755,   850,    -1,   179,   544,   755,   850,
      -1,   179,   546,   755,   850,    -1,   179,   755,   850,    -1,
     179,   544,   546,   755,    -1,   179,   544,   755,    -1,   179,
     546,   755,    -1,   179,   755,    -1,   244,   544,   546,   755,
      -1,   244,   755,    -1,   250,    -1,   288,    -1,   180,    -1,
     227,    -1,    80,   545,    -1,   297,   545,    -1,   545,    -1,
      86,    -1,   185,    -1,   185,   545,    -1,   185,    86,    -1,
      99,    -1,    99,   545,    -1,    99,    86,    -1,   769,    -1,
     202,    -1,   187,    -1,   126,   267,   548,   755,   220,   549,
      -1,   126,   267,    85,   761,   408,   582,   409,   220,   549,
      -1,   126,   267,   189,   761,   570,   220,   549,    -1,   126,
     267,   269,   712,   408,   584,   409,   220,   549,    -1,   126,
     267,   349,   755,   267,   541,   220,   549,    -1,   126,   267,
     309,   755,   267,   541,   220,   549,    -1,   126,   267,   309,
     755,   220,   549,    -1,   125,    -1,   144,    -1,   310,    -1,
     205,    -1,   315,    -1,   337,    -1,   161,    -1,   354,    -1,
     372,    -1,   770,    -1,   259,    -1,   192,   552,   267,   555,
     344,   556,   558,    -1,   304,   559,   552,   267,   555,   187,
     556,   458,    -1,    86,   289,    -1,    86,    -1,   553,    -1,
     554,    -1,   553,   414,   554,    -1,   314,    -1,   212,    -1,
     361,    -1,   155,    -1,   309,    -1,   295,    -1,   349,    -1,
     173,    -1,   362,    -1,   134,    -1,   340,    -1,   338,    -1,
     752,    -1,   337,   752,    -1,   189,   560,    -1,   144,   754,
      -1,   226,   754,    -1,   310,   754,    -1,   557,    -1,   556,
     414,   557,    -1,   883,    -1,   193,   883,    -1,   376,   192,
     270,    -1,    -1,   192,   270,   182,    -1,    -1,   561,    -1,
     560,   414,   561,    -1,   761,   570,    -1,   134,   563,   205,
     759,   267,   753,   564,   408,   565,   409,   680,    -1,   357,
      -1,    -1,   364,   757,    -1,    -1,   566,    -1,   565,   414,
     566,    -1,   758,   567,    -1,   761,   408,   720,   409,   567,
      -1,   408,   716,   409,   567,    -1,   541,    -1,   364,   541,
      -1,    -1,   134,   569,   189,   761,   570,   303,   575,   577,
     579,    -1,   271,   299,    -1,    -1,   408,   571,   409,    -1,
     408,   409,    -1,   572,    -1,   571,   414,   572,    -1,   573,
     576,    -1,   576,    -1,   202,    -1,   273,    -1,   209,    -1,
     770,    -1,   770,   414,   770,    -1,   576,    -1,   683,    -1,
     884,   741,   403,   354,    -1,   578,    -1,   577,   578,    -1,
      93,   574,    -1,   226,   449,    -1,   200,    -1,   327,    -1,
     373,    -1,   110,   267,   259,   210,    -1,   303,   259,   267,
     259,   210,    -1,   334,    -1,   176,   313,   154,    -1,   176,
     313,   219,    -1,   313,   154,    -1,   313,   219,    -1,   376,
     528,    -1,    -1,   163,   189,   761,   570,   458,    -1,   163,
      85,   761,   408,   582,   409,   458,    -1,   683,    -1,   401,
      -1,   163,   269,   712,   408,   584,   409,   458,    -1,   683,
      -1,   683,   414,   683,    -1,   254,   414,   683,    -1,   683,
     414,   254,    -1,   712,    -1,   883,   410,   585,    -1,   134,
     113,   408,   683,    93,   683,   409,   376,   189,   561,   587,
      -1,   134,   113,   408,   683,    93,   683,   409,   377,   189,
     587,    -1,    93,    96,    -1,    -1,   163,   113,   408,   683,
      93,   683,   409,   458,    -1,   296,   590,   753,   591,    -1,
     296,   144,   755,   591,    -1,   205,    -1,   337,    -1,   183,
      -1,    -1,    87,    85,   761,   408,   582,   409,   298,   344,
     755,    -1,    87,   131,   541,   298,   344,   755,    -1,    87,
     144,   756,   298,   344,   756,    -1,    87,   189,   761,   570,
     298,   344,   755,    -1,    87,   193,   775,   298,   344,   775,
      -1,    87,   226,   755,   298,   344,   755,    -1,    87,   269,
     120,   541,   364,   757,   298,   344,   755,    -1,    87,   310,
     755,   298,   344,   755,    -1,    87,   337,   678,   298,   594,
     593,   344,   755,    -1,    87,   349,   755,   267,   678,   298,
     344,   755,    -1,    87,   363,   775,   298,   344,   775,    -1,
     755,    -1,    -1,   125,    -1,    -1,    -1,   134,   569,   309,
     755,    93,   596,   267,   601,   344,   753,   680,   160,   602,
     597,    -1,   256,    -1,   599,    -1,   408,   598,   409,    -1,
     598,   411,   600,    -1,   600,    -1,   647,    -1,   635,    -1,
     643,    -1,   639,    -1,   604,    -1,   599,    -1,    -1,   314,
      -1,   361,    -1,   155,    -1,   212,    -1,   213,    -1,    -1,
     163,   309,   755,   267,   753,   458,    -1,   257,   753,    -1,
     233,   753,    -1,   359,   753,    -1,   359,   401,    -1,    79,
     608,    -1,   101,   608,    -1,   328,   347,   610,    -1,   127,
     608,    -1,   168,   608,    -1,   306,   608,    -1,   378,    -1,
     347,    -1,    -1,   222,   230,   444,    -1,   611,    -1,   222,
     230,   444,   611,    -1,   611,   222,   230,   444,    -1,   609,
      -1,    -1,   292,   268,    -1,   292,   379,    -1,   134,   569,
     372,   753,   483,    93,   647,    -1,   234,   760,    -1,   134,
     144,   756,   376,   615,    -1,   134,   144,   756,    -1,   616,
      -1,   615,   616,    -1,   236,   617,   770,    -1,   236,   617,
     150,    -1,   339,   617,   755,    -1,   339,   617,   150,    -1,
     166,   617,   771,    -1,   166,   617,   150,    -1,   277,   617,
     755,    -1,   277,   617,   150,    -1,   395,    -1,    -1,    87,
     144,   756,   319,   441,    -1,    87,   144,   756,   451,    -1,
     163,   144,   756,    -1,   134,   161,   541,   622,   683,   475,
      -1,    87,   161,   541,   457,    -1,    87,   161,   541,   163,
     255,   259,    -1,    87,   161,   541,   319,   255,   259,    -1,
      87,   161,   541,    83,   481,    -1,    87,   161,   541,   163,
     129,   755,   458,    -1,    87,   161,   541,   277,   344,   775,
      -1,    93,    -1,    -1,   134,   535,   131,   541,   182,   770,
     344,   770,   187,   541,    -1,   122,   759,   267,   753,    -1,
     122,   753,    -1,   122,    -1,   365,   629,   630,   628,    -1,
     365,   629,   630,   628,   753,    -1,   365,   629,   630,   628,
     626,    -1,   627,   628,    -1,   627,   628,   753,   631,    -1,
      89,    -1,    88,    -1,   370,    -1,    -1,   188,    -1,    -1,
     186,    -1,    -1,   408,   754,   409,    -1,    -1,   175,   634,
     628,   633,    -1,   647,    -1,   635,    -1,   643,    -1,   639,
      -1,   644,    -1,   627,    -1,    -1,   212,   218,   753,   636,
      -1,   367,   408,   749,   409,    -1,   150,   367,    -1,   647,
      -1,   408,   637,   409,   367,   408,   749,   409,    -1,   408,
     637,   409,   647,    -1,   637,   414,   638,    -1,   638,    -1,
     883,   719,    -1,   155,   187,   678,   680,    -1,   237,   654,
     752,   641,    -1,   202,   642,   242,    -1,    -1,    81,   321,
      -1,   307,   321,    -1,   307,   171,    -1,   321,   361,   171,
      -1,   321,    -1,   321,   307,   171,    -1,   171,    -1,    81,
     171,    -1,   361,   678,   319,   745,   670,   680,    -1,   149,
     755,   645,   142,   646,   182,   647,    -1,    -1,   645,   104,
      -1,   645,   211,    -1,   645,   311,    -1,   645,   251,   311,
      -1,    -1,   376,   196,    -1,   377,   196,    -1,   649,    -1,
     648,    -1,   408,   649,   409,    -1,   408,   648,   409,    -1,
     651,    -1,   650,   658,    -1,   650,   657,   667,   662,    -1,
     650,   657,   661,   668,    -1,   651,    -1,   648,    -1,   314,
     656,   743,   652,   670,   680,   665,   666,    -1,   650,   356,
     655,   650,    -1,   650,   216,   655,   650,    -1,   650,   170,
     655,   650,    -1,   218,   653,    -1,   850,    -1,    -1,   340,
     654,   753,    -1,   338,   654,   753,    -1,   235,   340,   654,
     753,    -1,   235,   338,   654,   753,    -1,   191,   340,   654,
     753,    -1,   191,   338,   654,   753,    -1,   337,   753,    -1,
     753,    -1,   337,    -1,    -1,    86,    -1,    -1,   159,    -1,
     159,   267,   408,   720,   409,    -1,    86,    -1,    -1,   658,
      -1,    -1,   272,   108,   659,    -1,   660,    -1,   659,   414,
     660,    -1,   716,   364,   715,    -1,   716,    94,    -1,   716,
     158,    -1,   716,    -1,   232,   663,   264,   664,    -1,   264,
     664,   232,   663,    -1,   232,   663,    -1,   264,   664,    -1,
     232,   663,   414,   664,    -1,   661,    -1,    -1,   716,    -1,
      86,    -1,   716,    -1,   193,   108,   720,    -1,    -1,   195,
     716,    -1,    -1,   182,   361,   669,    -1,   182,   292,   268,
      -1,   667,    -1,    -1,   262,   754,    -1,    -1,   187,   671,
      -1,    -1,   671,   414,   672,    -1,   672,    -1,   678,    -1,
     678,   674,    -1,   679,    -1,   679,   674,    -1,   679,    93,
     408,   681,   409,    -1,   679,    93,   883,   408,   681,   409,
      -1,   679,   883,   408,   681,   409,    -1,   648,    -1,   648,
     674,    -1,   673,    -1,   408,   673,   409,   674,    -1,   408,
     673,   409,    -1,   672,   137,   223,   672,    -1,   672,   382,
     672,    -1,   672,   675,   223,   672,   677,    -1,   672,   223,
     672,   677,    -1,   672,   247,   675,   223,   672,    -1,   672,
     247,   223,   672,    -1,    93,   883,   408,   754,   409,    -1,
      93,   883,    -1,   883,   408,   754,   409,    -1,   883,    -1,
     188,   676,    -1,   229,   676,    -1,   305,   676,    -1,   208,
      -1,   274,    -1,    -1,   364,   408,   754,   409,    -1,   267,
     716,    -1,   753,    -1,   753,   401,    -1,   268,   753,    -1,
     268,   408,   753,   409,    -1,   761,   408,   409,    -1,   761,
     408,   720,   409,    -1,   375,   716,    -1,    -1,   682,    -1,
     681,   414,   682,    -1,   883,   683,    -1,   686,   684,    -1,
     320,   686,   684,    -1,   686,    92,   406,   768,   407,    -1,
     320,   686,    92,   406,   768,   407,    -1,   406,   407,   684,
      -1,   406,   685,   407,   684,    -1,    -1,   768,    -1,   408,
     685,   409,    -1,   685,   399,   685,    -1,   685,   400,   685,
      -1,   685,   401,   685,    -1,   685,   402,   685,    -1,   685,
     403,   685,    -1,   767,    -1,   883,    -1,   688,    -1,   704,
      -1,   689,    -1,   693,    -1,   697,    -1,   705,   707,    -1,
     705,   408,   768,   409,   707,    -1,   884,   741,    -1,   688,
      -1,   704,    -1,   689,    -1,   694,    -1,   698,    -1,   884,
      -1,   214,    -1,   215,    -1,   325,    -1,   103,    -1,   293,
      -1,   181,   690,    -1,   162,   284,    -1,   148,   692,    -1,
     147,   692,    -1,   261,   691,    -1,   106,    -1,   408,   768,
     409,    -1,    -1,   408,   768,   414,   768,   409,    -1,   408,
     768,   409,    -1,    -1,   408,   768,   414,   768,   409,    -1,
     408,   768,   409,    -1,    -1,   695,    -1,   696,    -1,   695,
      -1,   696,    -1,   105,   702,   408,   768,   409,    -1,   105,
     702,    -1,   699,    -1,   700,    -1,   699,    -1,   700,    -1,
     701,   408,   768,   409,   703,    -1,   701,   703,    -1,   116,
     702,    -1,   115,   702,    -1,   368,    -1,   246,   116,   702,
      -1,   246,   115,   702,    -1,   248,   702,    -1,   369,    -1,
      -1,   116,   319,   883,    -1,    -1,   343,   408,   768,   409,
     706,    -1,   343,   706,    -1,   342,   408,   768,   409,   706,
      -1,   342,   706,    -1,   217,    -1,   376,   342,   381,    -1,
     377,   342,   381,    -1,    -1,   380,    -1,   243,    -1,   145,
      -1,   197,    -1,   240,    -1,   312,    -1,   380,   344,   243,
      -1,   145,   344,   197,    -1,   145,   344,   240,    -1,   145,
     344,   312,    -1,   197,   344,   240,    -1,   240,   344,   312,
      -1,   197,   344,   312,    -1,    -1,   709,   202,   648,    -1,
     709,   255,   202,   648,    -1,   709,   715,   711,   648,    -1,
     709,   715,   648,    -1,   709,   715,   709,    -1,   709,   220,
     259,    -1,   709,   220,   255,   259,    -1,   709,   275,   709,
      -1,   709,   220,   159,   187,   709,    -1,   307,   408,   710,
     409,    -1,   307,   408,   716,   409,    -1,   307,   408,   409,
      -1,   408,   710,   409,    -1,   720,   414,   716,    -1,    91,
      -1,   326,    -1,    86,    -1,   385,    -1,   713,    -1,   399,
      -1,   400,    -1,   401,    -1,   403,    -1,   404,    -1,   402,
      -1,   396,    -1,   397,    -1,   395,    -1,   385,    -1,   269,
     408,   585,   409,    -1,   712,    -1,   269,   408,   585,   409,
      -1,   718,    -1,   716,    78,   683,    -1,   716,    97,   342,
     381,   718,    -1,   399,   716,    -1,   400,   716,    -1,   403,
     716,    -1,   404,   716,    -1,   716,   403,    -1,   716,   404,
      -1,   716,   399,   716,    -1,   716,   400,   716,    -1,   716,
     401,   716,    -1,   716,   402,   716,    -1,   716,   403,   716,
      -1,   716,   404,   716,    -1,   716,   396,   716,    -1,   716,
     397,   716,    -1,   716,   395,   716,    -1,   716,   714,   716,
      -1,   714,   716,    -1,   716,   714,    -1,   716,    90,   716,
      -1,   716,   271,   716,    -1,   255,   716,    -1,   716,   231,
     716,    -1,   716,   231,   716,   169,   716,    -1,   716,   255,
     231,   716,    -1,   716,   255,   231,   716,   169,   716,    -1,
     716,   198,   716,    -1,   716,   198,   716,   169,   716,    -1,
     716,   255,   198,   716,    -1,   716,   255,   198,   716,   169,
     716,    -1,   716,   323,   344,   716,    -1,   716,   323,   344,
     716,   169,   716,    -1,   716,   255,   323,   344,   716,    -1,
     716,   255,   323,   344,   716,   169,   716,    -1,   716,   221,
      -1,   716,   220,   259,    -1,   716,   258,    -1,   716,   220,
     255,   259,    -1,   716,   220,   351,    -1,   716,   220,   255,
     351,    -1,   716,   220,   178,    -1,   716,   220,   255,   178,
      -1,   716,   220,   358,    -1,   716,   220,   255,   358,    -1,
     716,   220,   159,   187,   716,    -1,   716,   220,   262,   408,
     722,   409,    -1,   716,   220,   255,   262,   408,   722,   409,
      -1,   716,   102,   717,    90,   717,    -1,   716,   255,   102,
     717,    90,   717,    -1,   716,   202,   733,    -1,   716,   255,
     202,   733,    -1,   716,   715,   711,   648,    -1,   716,   715,
     711,   408,   716,   409,    -1,   357,   648,    -1,   708,    -1,
     718,    -1,   717,    78,   683,    -1,   400,   717,    -1,   403,
     717,    -1,   404,   717,    -1,   717,   403,    -1,   717,   404,
      -1,   717,   399,   717,    -1,   717,   400,   717,    -1,   717,
     401,   717,    -1,   717,   402,   717,    -1,   717,   403,   717,
      -1,   717,   404,   717,    -1,   717,   396,   717,    -1,   717,
     397,   717,    -1,   717,   395,   717,    -1,   717,   385,   717,
      -1,   714,   717,    -1,   717,   714,    -1,   717,   220,   159,
     187,   717,    -1,   717,   220,   262,   408,   717,   409,    -1,
     717,   220,   255,   262,   408,   717,   409,    -1,   739,    -1,
     762,    -1,   393,   741,   719,    -1,   408,   716,   409,   741,
     719,    -1,   408,   716,   409,   719,    -1,   734,    -1,   761,
     408,   409,    -1,   761,   408,   720,   409,    -1,   761,   408,
      86,   720,   409,    -1,   761,   408,   159,   720,   409,    -1,
     761,   408,   401,   409,    -1,   138,    -1,   139,   742,    -1,
     139,   408,   768,   409,    -1,   140,   742,    -1,   140,   408,
     768,   409,    -1,   141,   742,    -1,   318,   742,    -1,   363,
     742,    -1,   113,   408,   716,    93,   683,   409,    -1,   177,
     408,   721,   409,    -1,   276,   408,   726,   409,    -1,   283,
     408,   728,   409,    -1,   335,   408,   729,   409,    -1,   348,
     408,   716,    93,   683,   409,    -1,   350,   408,   107,   732,
     409,    -1,   350,   408,   228,   732,   409,    -1,   350,   408,
     346,   732,   409,    -1,   350,   408,   732,   409,    -1,   132,
     408,   716,   364,   541,   409,    -1,   132,   408,   720,   409,
      -1,   648,    -1,   174,   648,    -1,    92,   648,    -1,    92,
     724,    -1,   406,   716,   407,   719,    -1,   406,   716,   416,
     716,   407,   719,    -1,    -1,   716,    -1,   720,   414,   716,
      -1,   725,   187,   716,    -1,    -1,   722,   414,   683,    -1,
     683,    -1,   724,    -1,   723,   414,   724,    -1,   406,   720,
     407,    -1,   406,   723,   407,    -1,   900,    -1,   380,    -1,
     243,    -1,   145,    -1,   197,    -1,   240,    -1,   312,    -1,
     770,    -1,   716,   727,   730,   731,    -1,   716,   727,   730,
      -1,   282,   716,    -1,   717,   202,   717,    -1,    -1,   716,
     730,   731,    -1,   716,   731,   730,    -1,   716,   730,    -1,
     716,   731,    -1,   720,    -1,    -1,   187,   716,    -1,   182,
     716,    -1,   716,   187,   720,    -1,   187,   720,    -1,   720,
      -1,   648,    -1,   408,   720,   409,    -1,   112,   738,   735,
     737,   168,    -1,   260,   408,   716,   414,   716,   409,    -1,
     123,   408,   720,   409,    -1,   735,   736,    -1,   736,    -1,
     374,   716,   341,   716,    -1,   165,   716,    -1,    -1,   716,
      -1,    -1,   751,   719,    -1,   740,   719,    -1,   751,   741,
      -1,   410,   758,    -1,   410,   401,    -1,   410,   758,   741,
      -1,   408,   409,    -1,    -1,   743,   414,   744,    -1,   744,
      -1,   716,    93,   886,    -1,   716,    -1,   401,    -1,   745,
     414,   748,    -1,   408,   746,   409,   395,   408,   747,   409,
      -1,   748,    -1,   883,   719,    -1,   883,   719,   414,   746,
      -1,   716,    -1,   716,   414,   747,    -1,   883,   719,   395,
     716,    -1,   883,   719,   395,   150,    -1,   749,   414,   750,
      -1,   750,    -1,   744,    -1,   150,    -1,   776,    -1,   883,
      -1,   753,    -1,   752,   414,   753,    -1,   751,    -1,   740,
      -1,   755,    -1,   754,   414,   755,    -1,   883,    -1,   883,
      -1,   883,    -1,   883,    -1,   883,    -1,   770,    -1,   885,
      -1,   740,    -1,   774,    -1,   687,   770,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   393,
     719,    -1,   351,    -1,   178,    -1,   259,    -1,   897,    -1,
     392,    -1,   394,    -1,   390,    -1,   391,    -1,   384,    -1,
     763,    -1,   898,    -1,   768,    -1,   400,   768,    -1,   767,
      -1,   898,    -1,   763,    -1,   767,    -1,   898,    -1,   764,
      -1,   763,    -1,   400,   764,    -1,   400,   763,    -1,   898,
      -1,   767,    -1,   772,    -1,   767,    -1,   764,    -1,   763,
      -1,   765,    -1,   766,    -1,   898,    -1,   883,    -1,   266,
      -1,   249,    -1,     9,   344,   778,   784,   785,    -1,     9,
     344,   150,    -1,     9,   786,    -1,   144,   778,    -1,   756,
     781,   783,    -1,   779,   416,   780,   783,   402,   756,   789,
      -1,   770,    -1,   900,   387,    -1,   385,   782,    -1,   780,
      -1,    -1,   883,    -1,   883,   410,   782,    -1,   389,    -1,
     416,   768,    -1,    -1,    93,   778,    -1,    -1,   363,   786,
      -1,    -1,   787,    -1,   787,   402,   787,    -1,   787,    25,
     108,   787,    -1,   787,   364,   787,    -1,   775,    -1,   770,
      -1,   387,    -1,   385,   883,    -1,    -1,   149,   755,   645,
     142,   646,   182,   842,    -1,   146,   286,   842,    -1,   146,
     842,    -1,   793,    -1,   808,    -1,   794,    -1,    -1,   813,
     800,   795,   830,   411,    -1,    -1,   800,   796,   830,   411,
      -1,   820,   411,    -1,   772,    -1,   414,   772,    -1,    -1,
     707,    -1,   380,   344,   240,    -1,   380,   344,   312,    -1,
     145,   344,   145,    -1,   243,   344,   243,    -1,   816,    -1,
     162,    -1,   887,   799,    -1,   824,    -1,    -1,   803,   802,
     805,   804,    -1,   894,   101,   149,    40,   411,    -1,   894,
     168,   149,    40,   411,    -1,    -1,   806,    -1,   810,    -1,
     808,    -1,   806,   810,    -1,   806,   808,    -1,   810,    -1,
     807,   810,    -1,    -1,    77,   809,   817,   833,   887,   684,
     411,    -1,    -1,   813,   817,   811,   830,   411,    -1,    -1,
     817,   812,   830,   411,    -1,   820,   411,    -1,   814,   815,
      -1,   814,    -1,   815,    -1,    63,    -1,    74,    -1,    72,
      -1,    57,    -1,    58,    -1,    76,    -1,   826,    -1,   822,
      -1,   818,    -1,   887,   408,   797,   798,   409,    -1,   816,
      -1,   888,   799,    -1,   824,    -1,    20,   882,   819,    -1,
      20,   819,    -1,    20,   882,    -1,   412,   904,   413,    -1,
      -1,   824,   821,   412,   807,   413,    -1,   820,    -1,    -1,
     825,   823,   412,   807,   413,    -1,    49,   882,    -1,   356,
     882,    -1,    49,    -1,   356,    -1,   827,    -1,   829,   828,
      -1,    50,    41,    -1,    50,    41,   214,    -1,    50,    -1,
      50,   214,    -1,    50,    29,    -1,    50,    29,   214,    -1,
      50,    29,    29,    -1,    50,    29,    29,   214,    -1,    50,
     115,    -1,    41,    -1,    41,   214,    -1,   214,    -1,    29,
      -1,    29,   214,    -1,    29,    29,    -1,    29,    29,   214,
      -1,     5,    -1,   115,    -1,    42,    -1,    -1,   831,    -1,
     830,   414,   831,    -1,   833,   887,   684,   832,    -1,    -1,
     395,   905,    -1,    -1,   401,    -1,   401,   401,    -1,   149,
     329,   900,    -1,    19,   836,    -1,   837,    -1,    13,    -1,
      86,    -1,    -1,   778,    -1,   150,    -1,   173,   199,   841,
      -1,    -1,   173,   842,   839,   840,    -1,   846,   851,    -1,
     851,   846,    -1,   846,    -1,   851,    -1,    -1,   788,    -1,
     386,    -1,   755,    -1,   788,    -1,    22,   755,    -1,    33,
     755,   845,    -1,    -1,   846,    -1,   364,   852,    -1,   364,
     849,    18,   901,    -1,   218,   849,    18,   901,    -1,    -1,
      43,    -1,   851,    -1,   847,    -1,   218,   893,    -1,   848,
      -1,   853,    -1,   853,   414,   852,    -1,   773,    -1,   286,
     842,   187,   841,    -1,    17,   210,   755,   847,    -1,    17,
     856,   755,   847,    -1,    17,   856,   755,   848,    -1,    34,
      -1,    -1,   146,    18,   901,    -1,     3,    18,   901,    -1,
     387,   395,   860,    -1,    12,    -1,   387,   395,   862,    -1,
       8,    -1,    14,    -1,    15,    -1,    16,    -1,    26,    -1,
      27,    -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,
     284,    -1,    37,    -1,    38,    -1,    39,    -1,   354,    -1,
     859,    -1,   863,   414,   859,    -1,   861,    -1,   864,   414,
     861,    -1,   190,    18,   901,   863,    -1,   190,    18,   901,
      51,   387,   864,    -1,   190,    18,   901,    51,   763,   864,
      -1,   607,    35,    -1,   319,     4,   395,   869,    -1,   319,
       4,   344,   869,    -1,   267,    -1,   263,    -1,   319,    10,
     344,   837,    -1,   319,    10,   395,   837,    -1,   319,    10,
     837,    -1,    -1,   354,   872,   886,   220,   817,   684,   873,
      -1,    36,    -1,    -1,    -1,    52,   875,   886,   220,   817,
     684,   873,    -1,    53,    44,   877,    -1,    53,   255,    21,
     877,    -1,    53,    46,   877,    -1,    11,    -1,    45,    -1,
      48,    -1,    24,   755,    -1,    23,   344,   755,    -1,   160,
     755,   408,   895,   409,    -1,   160,     6,    -1,     7,   755,
     408,   895,   409,    -1,     7,   755,    -1,   879,    -1,   880,
      -1,     6,    -1,     7,    -1,     8,    -1,    11,    -1,    12,
      -1,    14,    -1,    15,    -1,    16,    -1,    21,    -1,    23,
      -1,    24,    -1,    25,    -1,    26,    -1,    27,    -1,    28,
      -1,    30,    -1,    31,    -1,    32,    -1,    35,    -1,    37,
      -1,    38,    -1,    39,    -1,    40,    -1,    44,    -1,    45,
      -1,    46,    -1,    48,    -1,     9,    -1,    17,    -1,    19,
      -1,    33,    -1,    52,    -1,    53,    -1,     5,    -1,    29,
      -1,    34,    -1,    41,    -1,    49,    -1,    42,    -1,    50,
      -1,   886,    -1,   900,    -1,   889,    -1,   890,    -1,   878,
      -1,   115,    -1,   900,    -1,   889,    -1,   878,    -1,   881,
      -1,   900,    -1,   889,    -1,   891,    -1,   878,    -1,   888,
      -1,   881,    -1,   115,    -1,   210,    -1,   214,    -1,   356,
      -1,   900,    -1,   890,    -1,   891,    -1,   879,    -1,   887,
      -1,   889,    -1,   892,    -1,   880,    -1,    79,    -1,    80,
      -1,    81,    -1,    82,    -1,    83,    -1,    84,    -1,    85,
      -1,    87,    -1,    95,    -1,    96,    -1,    97,    -1,    99,
      -1,   100,    -1,   101,    -1,   108,    -1,   109,    -1,   111,
      -1,   114,    -1,   117,    -1,   119,    -1,   120,    -1,   121,
      -1,   122,    -1,   126,    -1,   127,    -1,   128,    -1,   130,
      -1,   131,    -1,   133,    -1,   135,    -1,   136,    -1,   142,
      -1,   143,    -1,   144,    -1,   145,    -1,   146,    -1,   149,
      -1,   151,    -1,   153,    -1,   155,    -1,   156,    -1,   157,
      -1,   161,    -1,   162,    -1,   163,    -1,   164,    -1,   166,
      -1,   167,    -1,   169,    -1,   172,    -1,   171,    -1,   173,
      -1,   175,    -1,   179,    -1,   180,    -1,   183,    -1,   185,
      -1,   189,    -1,   191,    -1,   194,    -1,   196,    -1,   197,
      -1,   199,    -1,   200,    -1,   201,    -1,   203,    -1,   204,
      -1,   205,    -1,   206,    -1,   209,    -1,   211,    -1,   212,
      -1,   213,    -1,   222,    -1,   224,    -1,   225,    -1,   226,
      -1,   227,    -1,   230,    -1,   233,    -1,   234,    -1,   235,
      -1,   236,    -1,   237,    -1,   238,    -1,   239,    -1,   240,
      -1,   241,    -1,   242,    -1,   243,    -1,   244,    -1,   245,
      -1,   246,    -1,   250,    -1,   251,    -1,   252,    -1,   253,
      -1,   256,    -1,   257,    -1,   262,    -1,   265,    -1,   269,
      -1,   270,    -1,   273,    -1,   277,    -1,   278,    -1,   279,
      -1,   280,    -1,   281,    -1,   284,    -1,   286,    -1,   285,
      -1,   288,    -1,   289,    -1,   290,    -1,   291,    -1,   292,
      -1,   294,    -1,   296,    -1,   297,    -1,   298,    -1,   299,
      -1,   300,    -1,   301,    -1,   302,    -1,   303,    -1,   304,
      -1,   306,    -1,   308,    -1,   309,    -1,   310,    -1,   311,
      -1,   312,    -1,   315,    -1,   316,    -1,   317,    -1,   319,
      -1,   321,    -1,   322,    -1,   324,    -1,   327,    -1,   328,
      -1,   329,    -1,   330,    -1,   331,    -1,   332,    -1,   333,
      -1,   334,    -1,   336,    -1,   338,    -1,   339,    -1,   340,
      -1,   345,    -1,   347,    -1,   349,    -1,   352,    -1,   353,
      -1,   354,    -1,   355,    -1,   358,    -1,   359,    -1,   360,
      -1,   361,    -1,   362,    -1,   365,    -1,   366,    -1,   367,
      -1,   369,    -1,   371,    -1,   372,    -1,   376,    -1,   377,
      -1,   378,    -1,   379,    -1,   380,    -1,   381,    -1,   103,
      -1,   105,    -1,   116,    -1,   123,    -1,   132,    -1,   147,
      -1,   148,    -1,   174,    -1,   177,    -1,   181,    -1,   215,
      -1,   217,    -1,   248,    -1,   254,    -1,   260,    -1,   261,
      -1,   283,    -1,   293,    -1,   307,    -1,   320,    -1,   325,
      -1,   335,    -1,   342,    -1,   343,    -1,   348,    -1,   350,
      -1,   368,    -1,    98,    -1,   102,    -1,   104,    -1,   137,
      -1,   186,    -1,   188,    -1,   198,    -1,   202,    -1,   208,
      -1,   220,    -1,   221,    -1,   223,    -1,   229,    -1,   231,
      -1,   247,    -1,   258,    -1,   274,    -1,   275,    -1,   305,
      -1,   323,    -1,   370,    -1,    86,    -1,    88,    -1,    89,
      -1,    90,    -1,    91,    -1,    92,    -1,    93,    -1,    94,
      -1,   107,    -1,   112,    -1,   113,    -1,   118,    -1,   124,
      -1,   125,    -1,   129,    -1,   134,    -1,   138,    -1,   139,
      -1,   140,    -1,   141,    -1,   150,    -1,   152,    -1,   158,
      -1,   159,    -1,   160,    -1,   165,    -1,   168,    -1,   170,
      -1,   178,    -1,   182,    -1,   184,    -1,   187,    -1,   192,
      -1,   193,    -1,   195,    -1,   207,    -1,   216,    -1,   218,
      -1,   228,    -1,   232,    -1,   249,    -1,   255,    -1,   259,
      -1,   263,    -1,   264,    -1,   266,    -1,   267,    -1,   268,
      -1,   271,    -1,   272,    -1,   287,    -1,   295,    -1,   314,
      -1,   318,    -1,   326,    -1,   337,    -1,   341,    -1,   344,
      -1,   346,    -1,   351,    -1,   357,    -1,   363,    -1,   364,
      -1,   374,    -1,   375,    -1,   896,    -1,   893,   414,   896,
      -1,    47,    -1,    -1,   904,    -1,   387,   899,    -1,   387,
      -1,   387,   899,    -1,   387,    -1,   387,    -1,    26,   387,
      -1,    26,   755,    -1,   383,    -1,   386,    -1,   755,    -1,
     788,    -1,   907,    -1,   408,   409,    -1,   408,   903,   409,
      -1,   902,    -1,   903,   902,    -1,   905,    -1,   904,   414,
     905,    -1,   903,    -1,   412,   904,   413,    -1,   907,    -1,
     408,    -1,   409,    -1,   414,    -1,   411,    -1,   383,    -1,
     386,    -1,   763,    -1,   764,    -1,   767,    -1,   401,    -1,
     399,    -1,   400,    -1,   402,    -1,   403,    -1,   259,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      59,    -1,    60,    -1,    61,    -1,    62,    -1,    63,    -1,
      64,    -1,    65,    -1,    67,    -1,    66,    -1,    68,    -1,
      69,    -1,    70,    -1,    71,    -1,    72,    -1,    73,    -1,
      74,    -1,    75,    -1,    77,    -1,     5,    -1,    20,    -1,
     197,    -1,   214,    -1,    29,    -1,   240,    -1,   243,    -1,
     312,    -1,    41,    -1,    42,    -1,    49,    -1,    50,    -1,
     380,    -1,   115,    -1,   181,    -1,   344,    -1,   356,    -1,
     368,    -1,   406,    -1,   407,    -1,   395,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   560,   560,   562,   563,   566,   567,   568,   574,   575,
     576,   577,   578,   581,   593,   594,   595,   596,   597,   598,
     599,   600,   601,   602,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,   637,   638,   639,
     640,   641,   642,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   654,   655,   656,   657,   659,   660,   661,
     662,   663,   664,   665,   666,   668,   669,   670,   671,   672,
     673,   674,   675,   676,   682,   683,   684,   685,   686,   687,
     688,   689,   690,   696,   706,   710,   718,   726,   730,   741,
     751,   755,   762,   769,   775,   782,   791,   792,   798,   807,
     816,   823,   844,   848,   849,   860,   862,   866,   868,   878,
     885,   886,   889,   891,   893,   895,   897,   899,   901,   903,
     907,   909,   919,   921,   928,   929,   932,   934,   945,   947,
     957,   968,   970,   974,   975,   978,   979,   986,   987,   988,
    1001,  1003,  1005,  1009,  1011,  1013,  1015,  1017,  1019,  1021,
    1023,  1027,  1029,  1033,  1035,  1039,  1040,  1043,  1044,  1045,
    1048,  1049,  1050,  1051,  1061,  1062,  1063,  1065,  1067,  1069,
    1073,  1074,  1075,  1078,  1079,  1082,  1084,  1086,  1088,  1090,
    1094,  1096,  1098,  1100,  1102,  1106,  1110,  1112,  1116,  1117,
    1123,  1135,  1138,  1141,  1144,  1147,  1150,  1153,  1156,  1159,
    1162,  1165,  1168,  1171,  1176,  1177,  1180,  1181,  1182,  1192,
    1206,  1211,  1212,  1220,  1221,  1222,  1225,  1226,  1229,  1230,
    1231,  1233,  1237,  1238,  1241,  1242,  1249,  1252,  1255,  1256,
    1266,  1269,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1289,
    1292,  1294,  1296,  1300,  1301,  1302,  1305,  1311,  1312,  1315,
    1317,  1318,  1332,  1334,  1336,  1338,  1340,  1342,  1344,  1359,
    1360,  1361,  1362,  1365,  1372,  1373,  1374,  1381,  1383,  1387,
    1389,  1391,  1393,  1398,  1399,  1402,  1404,  1408,  1411,  1413,
    1419,  1422,  1423,  1424,  1425,  1426,  1429,  1433,  1437,  1438,
    1439,  1440,  1441,  1444,  1447,  1450,  1451,  1452,  1455,  1456,
    1457,  1458,  1468,  1467,  1478,  1481,  1484,  1486,  1490,  1501,
    1505,  1509,  1510,  1513,  1515,  1517,  1519,  1521,  1523,  1525,
    1527,  1529,  1531,  1535,  1536,  1547,  1552,  1553,  1560,  1562,
    1566,  1569,  1572,  1576,  1577,  1588,  1593,  1601,  1602,  1605,
    1607,  1609,  1613,  1614,  1615,  1618,  1621,  1624,  1625,  1628,
    1629,  1632,  1634,  1637,  1640,  1641,  1644,  1645,  1648,  1649,
    1656,  1657,  1666,  1668,  1672,  1674,  1678,  1689,  1697,  1712,
    1714,  1716,  1718,  1722,  1726,  1730,  1731,  1734,  1735,  1739,
    1740,  1741,  1744,  1751,  1752,  1755,  1757,  1759,  1761,  1765,
    1766,  1769,  1770,  1773,  1785,  1789,  1790,  1791,  1792,  1793,
    1794,  1795,  1796,  1799,  1801,  1805,  1807,  1816,  1831,  1836,
    1841,  1846,  1851,  1856,  1861,  1866,  1871,  1873,  1877,  1878,
    1879,  1880,  1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,
    1889,  1890,  1893,  1896,  1897,  1912,  1914,  1916,  1918,  1920,
    1922,  1924,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,
    1936,  1939,  1940,  1950,  1954,  1961,  1962,  1963,  1966,  1968,
    1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,
    1982,  1983,  1986,  1988,  1990,  1992,  1994,  1996,  2000,  2002,
    2006,  2007,  2010,  2015,  2018,  2023,  2026,  2028,  2032,  2043,
    2048,  2049,  2052,  2055,  2058,  2059,  2062,  2064,  2066,  2070,
    2071,  2072,  2075,  2080,  2081,  2084,  2086,  2090,  2092,  2096,
    2104,  2107,  2108,  2114,  2122,  2124,  2128,  2138,  2140,  2145,
    2147,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2165,  2167,
    2169,  2171,  2173,  2177,  2178,  2191,  2195,  2199,  2200,  2204,
    2208,  2210,  2212,  2214,  2219,  2221,  2225,  2228,  2233,  2234,
    2238,  2249,  2251,  2255,  2256,  2259,  2260,  2271,  2273,  2275,
    2277,  2279,  2281,  2283,  2285,  2287,  2289,  2291,  2295,  2296,
    2299,  2300,  2311,  2310,  2320,  2321,  2322,  2326,  2328,  2332,
    2333,  2334,  2335,  2336,  2339,  2340,  2344,  2345,  2346,  2347,
    2350,  2351,  2354,  2366,  2370,  2374,  2376,  2389,  2390,  2391,
    2392,  2393,  2394,  2397,  2398,  2399,  2403,  2405,  2407,  2409,
    2414,  2415,  2419,  2420,  2430,  2442,  2454,  2456,  2460,  2462,
    2466,  2468,  2470,  2472,  2474,  2476,  2478,  2480,  2484,  2485,
    2496,  2498,  2509,  2520,  2527,  2529,  2531,  2533,  2535,  2537,
    2541,  2542,  2546,  2560,  2562,  2564,  2577,  2579,  2581,  2585,
    2587,  2591,  2592,  2595,  2596,  2599,  2600,  2603,  2604,  2607,
    2610,  2621,  2626,  2627,  2628,  2629,  2630,  2634,  2635,  2684,
    2688,  2690,  2692,  2694,  2696,  2700,  2702,  2706,  2718,  2722,
    2726,  2729,  2732,  2733,  2734,  2735,  2736,  2737,  2738,  2739,
    2749,  2763,  2796,  2797,  2798,  2799,  2800,  2803,  2807,  2808,
    2818,  2820,  2824,  2826,  2830,  2832,  2834,  2836,  2840,  2841,
    2844,  2848,  2850,  2852,  2856,  2861,  2862,  2872,  2874,  2876,
    2878,  2880,  2882,  2884,  2886,  2890,  2891,  2894,  2895,  2898,
    2900,  2902,  2905,  2908,  2909,  2912,  2916,  2917,  2920,  2922,
    2924,  2926,  2930,  2932,  2934,  2936,  2938,  2942,  2943,  2946,
    2947,  2950,  2960,  2963,  2966,  2969,  2972,  2974,  2978,  2979,
    2982,  2983,  2994,  2995,  2998,  2999,  3009,  3011,  3013,  3015,
    3017,  3019,  3021,  3023,  3025,  3027,  3029,  3050,  3052,  3054,
    3056,  3058,  3060,  3062,  3066,  3068,  3070,  3072,  3076,  3077,
    3078,  3079,  3083,  3084,  3094,  3096,  3100,  3102,  3104,  3106,
    3110,  3112,  3116,  3117,  3120,  3122,  3126,  3139,  3141,  3143,
    3145,  3150,  3156,  3163,  3170,  3171,  3172,  3173,  3174,  3175,
    3176,  3177,  3178,  3181,  3182,  3183,  3184,  3185,  3186,  3188,
    3190,  3194,  3195,  3196,  3197,  3198,  3201,  3209,  3211,  3213,
    3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,  3233,  3236,
    3239,  3241,  3244,  3247,  3249,  3252,  3260,  3261,  3264,  3265,
    3268,  3272,  3281,  3282,  3285,  3286,  3289,  3293,  3297,  3299,
    3301,  3303,  3305,  3307,  3311,  3314,  3317,  3320,  3323,  3325,
    3327,  3329,  3333,  3337,  3339,  3342,  3345,  3346,  3347,  3348,
    3349,  3350,  3351,  3352,  3353,  3354,  3355,  3356,  3357,  3358,
    3372,  3374,  3376,  3378,  3380,  3382,  3384,  3386,  3388,  3392,
    3394,  3396,  3398,  3402,  3406,  3407,  3408,  3411,  3412,  3415,
    3416,  3417,  3418,  3419,  3420,  3421,  3422,  3423,  3426,  3427,
    3430,  3431,  3450,  3452,  3454,  3465,  3467,  3469,  3471,  3473,
    3475,  3477,  3479,  3481,  3483,  3485,  3487,  3489,  3491,  3493,
    3495,  3497,  3499,  3501,  3503,  3505,  3507,  3509,  3511,  3513,
    3515,  3517,  3519,  3521,  3523,  3525,  3527,  3529,  3531,  3533,
    3535,  3537,  3548,  3550,  3552,  3554,  3556,  3558,  3560,  3562,
    3564,  3566,  3568,  3570,  3572,  3574,  3576,  3578,  3580,  3592,
    3594,  3596,  3598,  3600,  3602,  3604,  3606,  3608,  3610,  3612,
    3614,  3616,  3618,  3620,  3622,  3624,  3626,  3628,  3630,  3632,
    3634,  3646,  3648,  3650,  3652,  3654,  3656,  3658,  3660,  3662,
    3664,  3666,  3668,  3670,  3672,  3674,  3676,  3678,  3680,  3682,
    3684,  3686,  3688,  3690,  3692,  3694,  3697,  3699,  3701,  3703,
    3705,  3707,  3709,  3711,  3713,  3715,  3722,  3724,  3727,  3730,
    3732,  3736,  3739,  3742,  3744,  3748,  3749,  3753,  3754,  3760,
    3761,  3762,  3763,  3764,  3765,  3766,  3767,  3771,  3773,  3778,
    3782,  3785,  3788,  3790,  3792,  3794,  3796,  3799,  3802,  3806,
    3810,  3812,  3814,  3818,  3820,  3839,  3841,  3843,  3847,  3849,
    3853,  3857,  3860,  3863,  3864,  3867,  3869,  3873,  3877,  3879,
    3881,  3885,  3886,  3897,  3899,  3904,  3906,  3908,  3913,  3915,
    3939,  3943,  3952,  3963,  3971,  3981,  3983,  3987,  3989,  3993,
    3994,  4004,  4005,  4008,  4010,  4014,  4016,  4020,  4022,  4027,
    4028,  4029,  4030,  4031,  4033,  4043,  4045,  4053,  4055,  4057,
    4059,  4061,  4063,  4065,  4067,  4069,  4073,  4074,  4075,  4076,
    4077,  4088,  4089,  4092,  4093,  4096,  4097,  4100,  4101,  4102,
    4105,  4106,  4107,  4108,  4109,  4112,  4113,  4116,  4117,  4118,
    4119,  4120,  4121,  4124,  4126,  4133,  4149,  4151,  4154,  4156,
    4160,  4172,  4197,  4220,  4238,  4250,  4251,  4254,  4255,  4256,
    4259,  4260,  4263,  4264,  4267,  4268,  4271,  4273,  4275,  4277,
    4281,  4288,  4311,  4337,  4350,  4357,  4400,  4402,  4409,  4411,
    4412,  4417,  4415,  4428,  4427,  4441,  4447,  4449,  4450,  4453,
    4454,  4455,  4456,  4457,  4460,  4461,  4469,  4555,  4593,  4592,
    4602,  4604,  4606,  4607,  4610,  4611,  4612,  4613,  4616,  4617,
    4621,  4620,  4685,  4683,  4696,  4695,  4709,  4715,  4720,  4725,
    4732,  4733,  4734,  4735,  4738,  4739,  4742,  4750,  4767,  4775,
    4800,  4801,  4895,  4929,  4931,  4933,  4937,  4941,  4940,  4993,
    4995,  4994,  5009,  5015,  5022,  5027,  5030,  5031,  5034,  5035,
    5036,  5037,  5038,  5039,  5040,  5048,  5056,  5059,  5060,  5061,
    5062,  5063,  5064,  5072,  5080,  5081,  5084,  5085,  5088,  5090,
    5094,  5164,  5165,  5172,  5173,  5174,  5180,  5189,  5192,  5193,
    5194,  5195,  5198,  5199,  5205,  5219,  5218,  5236,  5237,  5238,
    5239,  5240,  5243,  5245,  5249,  5250,  5257,  5262,  5264,  5265,
    5268,  5271,  5278,  5285,  5285,  5287,  5288,  5291,  5292,  5295,
    5295,  5297,  5315,  5321,  5327,  5333,  5341,  5342,  5353,  5363,
    5373,  5377,  5380,  5382,  5383,  5384,  5385,  5386,  5387,  5388,
    5389,  5390,  5391,  5392,  5393,  5394,  5395,  5396,  5399,  5400,
    5403,  5404,  5407,  5412,  5414,  5423,  5442,  5443,  5446,  5447,
    5454,  5455,  5456,  5463,  5462,  5523,  5524,  5531,  5530,  5599,
    5605,  5611,  5619,  5625,  5631,  5637,  5643,  5649,  5655,  5661,
    5667,  5678,  5679,  5682,  5683,  5684,  5685,  5686,  5687,  5688,
    5689,  5690,  5691,  5692,  5693,  5694,  5695,  5696,  5697,  5698,
    5699,  5700,  5701,  5702,  5703,  5704,  5705,  5706,  5707,  5708,
    5711,  5712,  5713,  5714,  5715,  5716,  5720,  5721,  5722,  5723,
    5724,  5725,  5726,  5729,  5745,  5746,  5747,  5748,  5749,  5754,
    5755,  5756,  5757,  5762,  5763,  5764,  5765,  5771,  5772,  5773,
    5774,  5775,  5776,  5779,  5780,  5781,  5782,  5785,  5786,  5787,
    5788,  5803,  5804,  5805,  5806,  5807,  5808,  5809,  5810,  5811,
    5812,  5813,  5814,  5815,  5816,  5817,  5818,  5819,  5820,  5821,
    5822,  5823,  5824,  5825,  5826,  5827,  5828,  5829,  5830,  5831,
    5832,  5833,  5834,  5835,  5836,  5837,  5838,  5839,  5840,  5841,
    5842,  5843,  5844,  5845,  5846,  5847,  5848,  5849,  5850,  5851,
    5852,  5853,  5854,  5855,  5856,  5857,  5858,  5859,  5860,  5861,
    5862,  5863,  5864,  5865,  5866,  5867,  5868,  5869,  5870,  5871,
    5872,  5873,  5874,  5875,  5876,  5877,  5878,  5879,  5880,  5881,
    5882,  5883,  5884,  5885,  5886,  5887,  5888,  5889,  5890,  5891,
    5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5900,  5901,
    5902,  5903,  5904,  5905,  5906,  5907,  5908,  5909,  5910,  5911,
    5912,  5913,  5914,  5915,  5916,  5917,  5918,  5919,  5920,  5921,
    5922,  5923,  5924,  5925,  5926,  5927,  5928,  5929,  5930,  5931,
    5932,  5933,  5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,
    5942,  5943,  5944,  5945,  5946,  5947,  5948,  5949,  5950,  5951,
    5952,  5953,  5954,  5955,  5956,  5957,  5958,  5959,  5960,  5961,
    5962,  5963,  5964,  5965,  5966,  5967,  5968,  5969,  5970,  5971,
    5972,  5973,  5974,  5975,  5976,  5977,  5978,  5992,  5993,  5997,
    5998,  5999,  6000,  6001,  6002,  6003,  6004,  6008,  6009,  6010,
    6011,  6012,  6013,  6014,  6015,  6016,  6017,  6018,  6019,  6020,
    6021,  6022,  6023,  6024,  6038,  6039,  6040,  6041,  6042,  6043,
    6044,  6045,  6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,
    6054,  6055,  6056,  6057,  6058,  6068,  6069,  6070,  6071,  6072,
    6073,  6074,  6075,  6076,  6077,  6078,  6079,  6080,  6081,  6082,
    6083,  6084,  6085,  6086,  6087,  6088,  6089,  6090,  6091,  6092,
    6093,  6094,  6095,  6096,  6097,  6098,  6099,  6100,  6101,  6102,
    6103,  6104,  6105,  6106,  6107,  6108,  6109,  6110,  6111,  6112,
    6113,  6114,  6115,  6116,  6117,  6118,  6119,  6120,  6121,  6122,
    6123,  6124,  6125,  6126,  6127,  6131,  6132,  6133,  6134,  6135,
    6139,  6139,  6142,  6145,  6146,  6149,  6151,  6156,  6166,  6173,
    6174,  6175,  6178,  6179,  6182,  6184,  6192,  6193,  6194,  6198,
    6199,  6203,  6204,  6207,  6208,  6211,  6212,  6213,  6214,  6215,
    6218,  6219,  6220,  6221,  6222,  6223,  6224,  6225,  6226,  6227,
    6228,  6229,  6230,  6231,  6232,  6233,  6234,  6235,  6236,  6237,
    6238,  6239,  6240,  6241,  6242,  6243,  6244,  6245,  6246,  6247,
    6248,  6249,  6250,  6251,  6252,  6253,  6254,  6255,  6256,  6257,
    6258,  6259,  6260,  6261,  6262,  6263,  6264,  6265,  6266,  6267,
    6268,  6269,  6270,  6271,  6272
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_RELEASE", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "AFTER", "AGGREGATE", "ALL", "ALTER", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", 
  "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CURRENT_DATE", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", 
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISTINCT", "DO", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENCODING", "ENCRYPTED", "END_P", 
  "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", 
  "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", 
  "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", "GROUP_P", "HANDLER", 
  "HAVING", "HOLD", "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", 
  "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INHERITS", 
  "INITIALLY", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", 
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", 
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", 
  "LANGUAGE", "LAST_P", "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", 
  "LISTEN", "LOAD", "LOCAL", "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", 
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", 
  "NATURAL", "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", 
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NULL_P", "NULLIF", 
  "NUMERIC", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PATH_P", "PENDANT", 
  "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", 
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RENAME", "REPLACE", 
  "RESET", "RESTART", "RESTRICT", "RETURNS", "REVOKE", "RIGHT", 
  "ROLLBACK", "ROW", "ROWS", "RULE", "SCHEMA", "SCROLL", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", 
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", 
  "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", "STATISTICS", 
  "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", "SYSID", "TABLE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TOAST", "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", 
  "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", 
  "USING", "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", 
  "VERSION", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", 
  "CSTRING", "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", 
  "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "';'", "'{'", "'}'", "','", "\"=\"", "':'", "$accept", "prog", 
  "statements", "statement", "opt_at", "stmt", "CreateUserStmt", 
  "opt_with", "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", 
  "OptUserList", "OptUserElem", "user_list", "CreateGroupStmt", 
  "OptGroupList", "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_list_or_default", "var_list", 
  "iso_level", "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_column_default", 
  "opt_drop_behavior", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_Trusted", "handler_name", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "rowdefinition", 
  "definition", "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "opt_arg", "func_as", "func_return", "func_type", 
  "createfunc_opt_list", "createfunc_opt_item", "opt_definition", 
  "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_name", "opt_column", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "transaction_access_mode", "ViewStmt", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "UpdateStmt", "DeclareCursorStmt", 
  "cursor_options", "opt_hold", "SelectStmt", "select_with_parens", 
  "select_no_parens", "select_clause", "simple_select", "into_clause", 
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct", 
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby", 
  "select_limit", "opt_select_limit", "select_limit_value", 
  "select_offset_value", "group_clause", "having_clause", 
  "for_update_clause", "opt_for_update_clause", "update_list", 
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause", 
  "join_type", "join_outer", "join_qual", "relation_expr", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "r_expr", "row", 
  "row_descriptor", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "a_expr", "b_expr", "c_expr", "opt_indirection", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "dotted_name", "attrs", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "UserId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", "single_vt_type", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", 
  "common_type", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into_using", "ecpg_into", "using_list", "UsingConst", 
  "ECPGPrepare", "ECPGDescribe", "opt_output", "ECPGDeallocateDescr", 
  "ECPGAllocateDescr", "ECPGGetDescHeaderItem", "desc_header_item", 
  "ECPGGetDescItem", "descriptor_item", "ECPGGetDescHeaderItems", 
  "ECPGGetDescItems", "ECPGGetDescriptorHeader", "ECPGGetDescriptor", 
  "ECPGRelease", "ECPGSetAutocommit", "on_off", "ECPGSetConnection", 
  "ECPGTypedef", "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", 
  "action", "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "unreserved_keyword", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,    61,    60,    62,   650,    43,
      45,    42,    47,    37,    94,   651,    91,    93,    40,    41,
      46,    59,   123,   125,    44,   652,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   417,   418,   419,   419,   420,   420,   420,   420,   420,
     420,   420,   420,   421,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   423,   424,   424,   425,   425,   426,   426,   427,
     428,   428,   429,   429,   429,   429,   429,   429,   429,   429,
     430,   430,   431,   431,   432,   432,   433,   433,   434,   434,
     435,   436,   436,   437,   437,   438,   438,   439,   439,   439,
     440,   440,   440,   441,   441,   441,   441,   441,   441,   441,
     441,   442,   442,   443,   443,   444,   444,   445,   445,   445,
     446,   446,   446,   446,   447,   447,   447,   447,   447,   447,
     448,   448,   448,   449,   449,   450,   450,   450,   450,   450,
     451,   451,   451,   451,   451,   452,   453,   453,   454,   454,
     455,   456,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   457,   457,   458,   458,   458,   459,
     460,   461,   461,   462,   462,   462,   463,   463,   464,   464,
     464,   464,   465,   465,   466,   466,   467,   467,   468,   468,
     469,   469,   470,   470,   470,   470,   470,   470,   470,   471,
     471,   472,   472,   473,   473,   473,   474,   475,   475,   476,
     476,   476,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   478,   478,   479,   480,   480,   480,   481,   481,   482,
     482,   482,   482,   483,   483,   484,   484,   485,   486,   486,
     486,   487,   487,   487,   487,   487,   488,   489,   490,   490,
     490,   490,   490,   491,   491,   492,   492,   492,   493,   493,
     493,   493,   495,   494,   496,   496,   497,   497,   498,   499,
     500,   501,   501,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   508,   509,   509,   510,   510,   511,   511,   512,
     512,   512,   513,   513,   513,   514,   514,   515,   515,   516,
     516,   517,   517,   517,   518,   518,   519,   519,   520,   520,
     520,   520,   521,   521,   522,   522,   523,   524,   525,   526,
     526,   526,   526,   527,   528,   529,   529,   530,   530,   531,
     531,   531,   532,   533,   533,   534,   534,   534,   534,   535,
     535,   536,   536,   537,   538,   539,   539,   539,   539,   539,
     539,   539,   539,   540,   540,   541,   541,   542,   543,   543,
     543,   543,   543,   543,   543,   543,   543,   543,   544,   544,
     544,   544,   544,   544,   544,   544,   544,   544,   544,   544,
     544,   544,   545,   546,   546,   547,   547,   547,   547,   547,
     547,   547,   548,   548,   548,   548,   548,   548,   548,   548,
     548,   549,   549,   550,   551,   552,   552,   552,   553,   553,
     554,   554,   554,   554,   554,   554,   554,   554,   554,   554,
     554,   554,   555,   555,   555,   555,   555,   555,   556,   556,
     557,   557,   558,   558,   559,   559,   560,   560,   561,   562,
     563,   563,   564,   564,   565,   565,   566,   566,   566,   567,
     567,   567,   568,   569,   569,   570,   570,   571,   571,   572,
     572,   573,   573,   573,   574,   574,   575,   576,   576,   577,
     577,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   579,   579,   580,   581,   582,   582,   583,
     584,   584,   584,   584,   585,   585,   586,   586,   587,   587,
     588,   589,   589,   590,   590,   591,   591,   592,   592,   592,
     592,   592,   592,   592,   592,   592,   592,   592,   593,   593,
     594,   594,   596,   595,   597,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   600,   600,   601,   601,   601,   601,
     602,   602,   603,   604,   605,   606,   606,   607,   607,   607,
     607,   607,   607,   608,   608,   608,   609,   609,   609,   609,
     610,   610,   611,   611,   612,   613,   614,   614,   615,   615,
     616,   616,   616,   616,   616,   616,   616,   616,   617,   617,
     618,   618,   619,   620,   621,   621,   621,   621,   621,   621,
     622,   622,   623,   624,   624,   624,   625,   625,   625,   626,
     626,   627,   627,   628,   628,   629,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   633,   634,   634,   635,
     636,   636,   636,   636,   636,   637,   637,   638,   639,   640,
     641,   641,   642,   642,   642,   642,   642,   642,   642,   642,
     643,   644,   645,   645,   645,   645,   645,   646,   646,   646,
     647,   647,   648,   648,   649,   649,   649,   649,   650,   650,
     651,   651,   651,   651,   652,   652,   652,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   654,   655,   655,   656,
     656,   656,   656,   657,   657,   658,   659,   659,   660,   660,
     660,   660,   661,   661,   661,   661,   661,   662,   662,   663,
     663,   664,   665,   665,   666,   666,   667,   667,   668,   668,
     669,   669,   670,   670,   671,   671,   672,   672,   672,   672,
     672,   672,   672,   672,   672,   672,   672,   673,   673,   673,
     673,   673,   673,   673,   674,   674,   674,   674,   675,   675,
     675,   675,   676,   676,   677,   677,   678,   678,   678,   678,
     679,   679,   680,   680,   681,   681,   682,   683,   683,   683,
     683,   684,   684,   684,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   686,   686,   686,   686,   686,
     686,   687,   687,   687,   687,   687,   688,   689,   689,   689,
     689,   689,   689,   689,   689,   689,   689,   689,   690,   690,
     691,   691,   691,   692,   692,   692,   693,   693,   694,   694,
     695,   696,   697,   697,   698,   698,   699,   700,   701,   701,
     701,   701,   701,   701,   702,   702,   703,   703,   704,   704,
     704,   704,   705,   706,   706,   706,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   709,
     709,   709,   709,   710,   711,   711,   711,   712,   712,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   714,   714,
     715,   715,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   719,   719,   719,   720,
     720,   721,   721,   722,   722,   723,   723,   724,   724,   725,
     725,   725,   725,   725,   725,   725,   725,   726,   726,   727,
     728,   728,   729,   729,   729,   729,   729,   729,   730,   731,
     732,   732,   732,   733,   733,   734,   734,   734,   735,   735,
     736,   737,   737,   738,   738,   739,   739,   740,   741,   741,
     741,   742,   742,   743,   743,   744,   744,   744,   745,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   750,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     756,   757,   758,   759,   760,   761,   761,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   763,   764,   765,   766,
     767,   768,   768,   769,   769,   770,   770,   771,   771,   771,
     772,   772,   772,   772,   772,   773,   773,   774,   774,   774,
     774,   774,   774,   775,   776,   776,   777,   777,   777,   777,
     778,   778,   778,   779,   780,   781,   781,   782,   782,   782,
     783,   783,   784,   784,   785,   785,   786,   786,   786,   786,
     787,   787,   788,   789,   789,   790,   791,   791,   792,   793,
     793,   795,   794,   796,   794,   794,   797,   798,   798,   799,
     799,   799,   799,   799,   800,   800,   800,   800,   802,   801,
     803,   804,   805,   805,   806,   806,   806,   806,   807,   807,
     809,   808,   811,   810,   812,   810,   810,   813,   813,   813,
     814,   814,   814,   814,   815,   815,   816,   816,   816,   816,
     817,   817,   817,   818,   818,   818,   819,   821,   820,   822,
     823,   822,   824,   824,   825,   825,   826,   826,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   828,   828,   828,
     828,   828,   828,   828,   828,   828,   829,   829,   830,   830,
     831,   832,   832,   833,   833,   833,   834,   835,   836,   836,
     836,   836,   837,   837,   838,   839,   838,   840,   840,   840,
     840,   840,   841,   841,   842,   842,   843,   844,   845,   845,
     846,   847,   848,   849,   849,   850,   850,   851,   851,   852,
     852,   853,   854,   855,   855,   855,   856,   856,   857,   858,
     859,   860,   861,   862,   862,   862,   862,   862,   862,   862,
     862,   862,   862,   862,   862,   862,   862,   862,   863,   863,
     864,   864,   865,   866,   866,   867,   868,   868,   869,   869,
     870,   870,   870,   872,   871,   873,   873,   875,   874,   876,
     876,   876,   877,   877,   877,   877,   877,   877,   877,   877,
     877,   878,   878,   879,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     880,   880,   880,   880,   880,   880,   881,   881,   881,   881,
     881,   881,   881,   882,   883,   883,   883,   883,   883,   884,
     884,   884,   884,   885,   885,   885,   885,   886,   886,   886,
     886,   886,   886,   887,   887,   887,   887,   888,   888,   888,
     888,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     893,   893,   894,   895,   895,   896,   896,   897,   898,   899,
     899,   899,   900,   900,   901,   901,   902,   902,   902,   903,
     903,   904,   904,   905,   905,   906,   906,   906,   906,   906,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     1,     0,     4,     5,     5,     4,     3,
       2,     0,     2,     2,     1,     1,     1,     1,     3,     3,
       3,     1,     4,     5,     2,     0,     2,     2,     6,     6,
       3,     7,     4,     1,     0,     2,     0,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     3,
       3,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     6,     1,     1,
       1,     1,     0,     1,     1,     2,     3,     4,     3,     2,
       2,     3,     4,     3,     2,     4,     1,     1,     1,     1,
       1,     6,     7,     9,     9,     9,     9,     7,     5,     7,
       6,     6,     6,     6,     3,     2,     1,     1,     0,     2,
       9,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       3,     3,     1,     0,     2,     0,     3,     0,     1,     0,
      10,    11,     1,     1,     2,     2,     2,     2,     0,     1,
       0,     1,     3,     1,     1,     1,     3,     2,     0,     3,
       1,     1,     2,     1,     1,     2,     4,     2,     5,     1,
       2,     2,     2,     3,     2,     2,     0,     3,     1,     4,
       4,     5,    11,     3,     0,     3,     1,     1,     2,     2,
       0,     1,     1,     2,     2,     0,     3,     3,     2,     1,
       1,     2,     2,     4,     0,     2,     2,     0,     3,     4,
       4,     0,     0,     8,     3,     0,     3,     1,     1,     5,
       4,     2,     0,     2,     1,     2,     3,     2,     2,     2,
       2,     3,     3,     1,     0,     8,     1,     0,     1,     1,
       2,     0,     5,     1,     0,    14,    19,     1,     1,     1,
       3,     5,     1,     1,     1,     3,     0,     1,     0,     1,
       1,     1,     3,     0,     1,     1,     0,     2,     1,     2,
       1,     2,     2,     1,     2,     2,     6,     8,     3,     4,
       4,     4,     5,     3,     3,     1,     3,     3,     1,     1,
       1,     1,    12,     1,     3,     4,     7,     4,     2,     1,
       0,     1,     0,     7,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     7,     8,     2,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       1,     2,     3,     0,     3,     0,     1,     3,     2,    11,
       1,     0,     2,     0,     1,     3,     2,     5,     4,     1,
       2,     0,     9,     2,     0,     3,     2,     1,     3,     2,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     2,     2,     1,     1,     1,     4,     5,     1,     3,
       3,     2,     2,     2,     0,     5,     7,     1,     1,     7,
       1,     3,     3,     3,     1,     3,    11,    10,     2,     0,
       8,     4,     4,     1,     1,     1,     0,     9,     6,     6,
       7,     6,     6,     9,     6,     8,     8,     6,     1,     0,
       1,     0,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     2,     3,
       2,     2,     2,     1,     1,     0,     3,     1,     4,     4,
       1,     0,     2,     2,     7,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     0,
       5,     4,     3,     6,     4,     6,     6,     5,     7,     6,
       1,     0,    10,     4,     2,     1,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     0,     4,
       4,     2,     1,     7,     4,     3,     1,     2,     4,     4,
       3,     0,     2,     2,     2,     3,     1,     3,     1,     2,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     3,     3,     1,     0,
       2,     0,     2,     0,     3,     1,     1,     2,     1,     2,
       5,     6,     5,     1,     2,     1,     4,     3,     4,     3,
       5,     4,     5,     4,     5,     2,     4,     1,     2,     2,
       2,     1,     1,     0,     4,     2,     1,     2,     2,     4,
       3,     4,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       3,     4,     4,     3,     3,     3,     4,     3,     5,     4,
       4,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     3,     5,     2,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     2,     3,
       2,     4,     3,     4,     3,     4,     3,     4,     5,     6,
       7,     5,     6,     3,     4,     4,     6,     2,     1,     1,
       3,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       7,     1,     1,     3,     5,     4,     1,     3,     4,     5,
       5,     4,     1,     2,     4,     2,     4,     2,     2,     2,
       6,     4,     4,     4,     4,     6,     5,     5,     5,     4,
       6,     4,     1,     2,     2,     2,     4,     6,     0,     1,
       3,     3,     0,     3,     1,     1,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     2,
       3,     0,     3,     3,     2,     2,     1,     0,     2,     2,
       3,     2,     1,     1,     3,     5,     6,     4,     2,     1,
       4,     2,     0,     1,     0,     2,     2,     2,     2,     2,
       3,     2,     0,     3,     1,     3,     1,     1,     3,     7,
       1,     2,     4,     1,     3,     4,     4,     3,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     3,     2,     2,
       3,     7,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     1,     1,     2,     1,     0,     4,
       5,     5,     0,     1,     1,     1,     2,     2,     1,     2,
       0,     7,     0,     5,     0,     4,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       1,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     0,     1,     3,
       4,     0,     2,     0,     1,     2,     3,     2,     1,     1,
       1,     0,     1,     1,     3,     0,     4,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     2,     3,     0,     1,
       2,     4,     4,     0,     1,     1,     1,     2,     1,     1,
       3,     1,     4,     4,     4,     4,     1,     0,     3,     3,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     3,     4,     6,     6,     2,     4,     4,     1,     1,
       4,     4,     3,     0,     7,     1,     0,     0,     7,     3,
       4,     3,     1,     1,     1,     2,     3,     5,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1824,  1825,  1828,  1832,  1833,  1762,
    1834,  1835,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
    1809,  1810,  1811,  1812,  1814,  1813,  1815,  1816,  1817,  1818,
    1819,  1820,  1821,  1822,  1823,  1837,  1838,  1826,  1827,  1829,
    1830,  1800,  1831,  1839,  1840,  1841,  1836,  1790,  1150,  1791,
      10,  1146,  1147,  1844,  1796,  1797,  1795,  1798,  1799,  1842,
    1843,  1786,  1787,  1789,    11,    12,  1788,     4,  1792,  1793,
    1794,     8,  1228,  1297,     9,  1785,  1297,     0,  1403,  1404,
    1405,     0,  1406,  1407,  1408,  1409,  1410,  1347,  1311,     0,
    1411,     0,  1412,  1413,  1414,  1415,  1416,  1417,  1418,  1419,
    1420,     0,  1421,  1422,  1423,  1424,  1425,  1296,  1426,  1427,
    1428,  1429,  1274,  1280,  1387,     0,  1253,  1254,  1250,  1252,
    1251,  1255,  1240,   605,     0,   652,   651,     0,  1674,   605,
    1675,  1647,  1676,  1648,  1649,   190,     0,   645,  1650,     0,
     605,  1651,   223,   504,  1677,     0,     0,  1652,  1653,     0,
       0,  1225,   334,   605,     0,  1654,   668,  1655,     0,  1656,
    1678,  1679,     0,     0,  1680,  1681,  1682,     0,  1657,  1658,
    1683,  1684,  1685,  1686,  1687,     0,     0,   726,     0,  1688,
    1659,  1660,     0,  1689,  1661,  1662,  1690,  1691,  1663,     0,
    1664,     0,     0,   485,  1692,   605,  1665,   732,     0,  1666,
       0,  1693,  1667,     0,  1668,  1669,  1670,  1671,  1672,   726,
    1383,  1275,     0,     0,   656,  1673,  1694,  1772,  1773,     0,
       0,     0,    41,    20,    19,    54,    34,    16,    48,    37,
      78,    79,    80,    26,    22,    18,    23,    27,    39,    28,
      38,    17,    35,    50,    40,    53,    29,    46,    44,    36,
      49,    52,    74,    57,    25,    58,    70,    59,    33,    68,
      66,    67,    30,    47,    65,    69,    71,    51,    64,    61,
      75,    73,    81,    62,    42,    14,    55,    32,    15,    31,
      24,    77,    21,   654,    56,    60,    45,    63,    76,    43,
      72,   709,   700,   734,   708,    83,    84,    85,     7,  1208,
    1210,  1213,  1209,  1297,  1248,  1249,  1224,  1258,  1269,  1257,
    1227,  1270,  1256,  1276,     0,    87,    89,    90,    91,    94,
      95,    88,    86,    82,    93,    92,    96,    97,    98,    99,
     100,   101,  1466,   899,  1464,  1465,  1463,  1430,  1431,  1432,
    1433,  1434,  1435,  1471,  1472,  1473,  1474,  1475,  1476,  1477,
    1695,  1478,  1696,  1697,  1698,  1699,  1700,  1701,  1702,  1479,
    1480,  1481,  1482,  1483,  1484,  1703,  1485,  1486,  1487,  1704,
    1705,  1488,  1489,  1706,  1490,  1491,  1492,  1493,  1707,  1708,
    1494,  1495,  1496,  1709,  1497,  1498,  1499,  1710,  1500,  1501,
    1711,  1712,  1713,  1714,  1502,  1503,  1504,  1505,  1506,  1507,
    1715,  1508,  1716,  1509,  1510,  1511,  1512,  1717,  1718,  1719,
    1513,  1514,  1515,  1516,  1720,  1517,  1518,  1721,  1519,  1722,
    1521,  1520,  1522,  1523,  1723,  1524,  1525,  1724,  1526,  1725,
    1527,  1726,  1528,  1529,  1727,  1728,  1530,  1729,  1531,  1532,
    1533,  1534,  1535,  1536,  1537,  1538,  1539,  1730,  1540,  1541,
    1542,  1543,  1731,  1732,  1544,  1545,  1546,  1547,  1548,  1733,
    1549,  1734,  1550,  1551,  1552,  1553,  1554,  1555,  1556,  1557,
    1558,  1559,  1560,  1561,  1562,  1563,  1735,  1564,  1565,  1566,
    1567,  1736,  1568,  1569,  1737,  1570,  1738,  1739,  1571,  1740,
    1741,  1742,  1572,  1573,  1743,  1744,  1574,  1575,  1576,  1577,
    1578,  1579,  1580,  1582,  1581,  1745,  1583,  1584,  1585,  1586,
    1587,  1588,  1746,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1599,  1600,  1601,  1602,  1603,  1747,  1604,
    1605,  1606,  1748,  1607,  1608,  1609,  1610,  1749,  1611,  1612,
    1613,  1614,  1615,  1616,  1617,  1618,  1619,  1750,  1620,  1621,
    1622,  1751,  1752,  1623,  1753,  1624,  1625,  1754,  1626,  1627,
    1628,  1629,  1755,  1630,  1631,  1632,  1633,  1634,  1756,  1757,
    1635,  1636,  1637,  1638,  1639,  1640,  1758,  1759,  1641,  1642,
    1643,  1644,  1645,  1646,     0,  1297,  1235,  1234,  1297,  1260,
    1244,  1269,  1262,  1470,  1467,   899,  1468,  1469,     0,  1448,
       0,  1768,  1155,  1201,  1200,  1178,  1196,  1447,  1401,  1402,
    1173,  1445,  1446,  1156,  1444,  1346,     0,     0,  1309,  1310,
    1313,  1186,  1182,  1312,     0,  1307,  1308,  1130,  1444,  1436,
    1437,  1438,  1439,  1441,  1440,  1442,  1459,  1460,  1461,  1462,
       0,  1264,  1458,  1265,  1443,  1467,  1457,  1326,  1129,  1328,
    1272,  1282,  1278,  1286,  1281,     0,     0,     0,     0,  1297,
     604,   603,   597,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   598,   209,
    1175,  1174,  1126,  1125,   644,     0,  1121,  1122,     0,   600,
     222,     0,     0,     0,     0,     0,     0,   389,     0,     0,
       0,     0,     0,     0,     0,   233,   232,     0,   326,     0,
     490,     0,     0,   334,     0,     0,     0,  1179,     0,  1581,
    1202,  1324,  1325,  1207,  1613,   692,     0,     0,     0,     0,
     401,     0,   400,     0,     0,   398,     0,   333,     0,   402,
     396,   395,     0,   399,     0,   397,     0,     0,   601,  1533,
    1315,   667,   654,  1472,   425,   429,   420,   426,   434,   433,
     421,   418,   419,  1590,     0,     0,   424,     0,   415,  1151,
    1153,   432,  1152,     0,   456,   469,   463,   467,   461,   465,
     464,   460,   471,   470,   466,   462,   468,     0,   457,   458,
       0,   594,  1122,   615,  1134,   725,     0,     0,   417,   593,
       0,     0,   553,   554,     0,   184,  1606,  1669,  1624,   180,
       0,     0,   602,   731,   729,     0,     0,     0,  1497,  1552,
    1562,  1606,  1669,  1624,   140,     0,   179,  1606,  1669,  1624,
     175,   611,     0,     0,  1273,   596,   595,     0,     0,   796,
     655,   658,   709,     0,   605,     0,     6,  1375,   653,   649,
     728,   728,     0,   728,     0,   705,  1303,  1211,  1269,  1247,
    1215,     0,     0,  1294,  1290,  1287,  1295,  1289,  1277,   888,
     889,   890,   887,   891,   886,     0,  1219,  1226,  1229,     0,
    1237,  1236,  1242,  1303,  1246,  1261,  1774,  1775,  1349,  1177,
    1193,     0,     0,     0,     0,     0,     0,  1185,  1191,     0,
    1183,     0,     0,  1779,  1783,     0,  1781,  1776,  1263,     0,
    1327,  1329,  1284,  1283,  1279,     0,     0,  1392,     0,     0,
    1393,  1394,     0,  1389,  1391,     0,  1303,  1136,     0,     0,
    1447,  1135,  1445,  1455,  1444,     0,   406,   405,     0,     0,
       0,     0,     0,     0,     0,   312,     0,   796,     0,   111,
       0,     0,  1097,     0,     0,   442,   443,   448,     0,   445,
       0,     0,   444,   446,   447,     0,   449,   450,     0,   225,
       0,     0,     0,     0,   617,   641,   237,   236,   125,   235,
     234,     0,   917,   927,   925,   926,   919,   920,   921,   924,
     922,   923,     0,   918,   503,   134,  1173,     0,     0,   104,
       0,     0,     0,     0,     0,     0,     0,     0,  1348,  1206,
    1306,     0,   803,     0,   368,     0,   632,     0,   130,     0,
       0,     0,     0,   109,   121,     0,   208,   403,  1323,  1322,
    1314,  1321,     0,   422,   431,   430,   428,   427,   423,  1154,
       0,   413,   414,  1333,  1333,  1336,  1338,   411,  1335,     0,
     455,     0,     0,     0,   681,  1123,     0,     0,   556,   556,
     183,   181,     0,     0,     0,     0,     0,  1647,  1648,   847,
    1094,     0,  1448,  1649,  1650,  1651,  1022,  1102,  1102,  1102,
    1652,  1653,  1514,  1654,  1655,  1143,  1656,   837,  1657,  1658,
    1563,  1659,     0,  1144,  1661,  1662,  1572,     0,  1663,  1664,
    1665,  1102,  1667,  1668,  1669,  1670,  1671,  1672,  1142,     0,
    1102,  1673,   928,  1768,  1148,  1149,  1048,     0,     0,  1107,
       0,     0,     0,  1042,     0,   831,   833,   834,   858,   859,
     835,   864,   865,   877,   832,     0,   988,     0,     0,  1106,
     932,  1016,  1011,  1048,   716,  1104,  1048,     0,  1012,  1169,
    1168,  1170,  1171,  1167,  1137,  1447,  1452,   836,  1445,  1145,
    1172,  1444,     0,     0,     0,     0,  1382,   186,     0,   187,
    1127,  1606,   141,   171,   148,   170,     0,  1489,   142,     0,
       0,     0,   146,   607,     0,     0,   178,   176,     0,   610,
     599,   407,     0,     0,   798,     0,   797,   657,   654,   703,
     702,     5,   660,   727,     0,     0,     0,     0,     0,     0,
       0,   759,   748,  1304,     0,  1298,     0,  1303,  1297,  1297,
    1292,  1291,  1288,     0,     0,     0,     0,     0,     0,  1161,
    1160,  1216,  1218,  1164,     0,  1303,     0,     0,  1195,     0,
    1199,  1197,  1343,  1333,  1344,  1345,  1189,  1184,  1187,     0,
    1180,  1191,  1777,     0,     0,  1780,  1266,     0,  1165,  1166,
    1341,  1330,  1339,  1285,  1297,  1400,     0,  1395,  1398,     0,
    1390,     0,     0,     0,     0,     0,   631,     0,     0,     0,
       0,   634,     0,     0,     0,     0,     0,     0,     0,     0,
     310,   571,   571,   571,   571,     0,     0,     0,     0,     0,
       0,     0,   111,   105,   108,  1230,  1099,  1098,  1132,   643,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   369,
       0,   840,   875,   875,   875,   855,   855,   849,   838,   882,
     875,   852,   841,     0,   839,   885,   885,   870,     0,   813,
     823,   825,   826,   856,   857,   827,   862,   863,   824,   899,
    1451,   836,  1450,  1449,     0,     0,   640,     0,   125,   122,
     390,   370,     0,   133,   132,   338,   337,     0,     0,   371,
     103,   111,   312,   305,     0,     0,     0,  1133,     0,     0,
     274,   693,   697,   694,     0,   695,     0,   678,     0,     0,
     208,     0,     0,     0,     0,     0,   208,   206,   207,     0,
     394,  1316,  1319,  1320,     0,   661,   663,   665,   664,   666,
     662,   412,   409,   410,  1334,  1766,     0,  1337,  1760,     0,
       0,     0,  1368,  1372,  1504,  1528,  1547,  1601,     0,     0,
     472,   459,     0,     0,     0,   669,   672,     0,     0,   679,
     416,  1342,   555,   552,   551,   182,   484,     0,     0,     0,
    1044,  1045,   874,   861,  1093,     0,     0,   869,   868,     0,
       0,     0,  1023,     0,  1025,     0,  1027,     0,   845,   844,
     843,  1043,  1052,     0,   842,   875,   875,   873,   955,     0,
       0,   846,     0,     0,  1071,     0,  1028,  1077,     0,     0,
       0,   881,     0,   879,     0,     0,   987,  1029,     0,  1769,
    1767,     0,  1141,  1048,   935,   936,   937,   938,  1042,     0,
    1049,     0,  1138,     0,     0,   867,     0,   899,     0,     0,
       0,     0,     0,   930,     0,   951,     0,     0,     0,     0,
       0,     0,     0,     0,   968,     0,     0,   970,     0,     0,
       0,   928,   927,   925,   926,   919,   920,   921,   924,   939,
     940,   952,     0,  1096,  1333,     0,   763,   715,  1095,     0,
    1379,  1378,  1377,  1376,  1380,  1381,   188,   189,   185,     0,
       0,   150,   149,   174,   173,     0,   168,   169,   145,     0,
     164,   165,     0,   612,   613,     0,   152,   161,   163,   162,
     160,   143,   151,   153,   157,   158,   159,   144,   177,  1297,
       0,     0,   763,  1110,  1048,   646,     0,   650,   709,   713,
     708,   712,   735,   736,   741,   711,     0,   761,   750,   744,
     749,   745,   751,   758,   707,   747,   706,  1305,  1214,  1303,
     813,     0,  1297,  1238,  1297,  1293,  1222,   893,   894,   895,
     896,   898,   897,  1223,  1220,   892,  1221,  1163,  1162,     0,
       0,     0,     0,  1245,  1192,     0,  1176,  1198,     0,  1190,
       0,  1778,  1784,  1782,     0,   813,  1763,  1396,  1763,   813,
     538,     0,   537,     0,     0,   630,     0,     0,     0,     0,
       0,   637,   268,     0,   205,     0,     0,     0,     0,   511,
     513,   512,   506,     0,   507,     0,   510,   517,   836,     0,
       0,     0,     0,     0,     0,     0,     0,   314,   324,     0,
       0,     0,   104,   104,   311,   570,   198,     0,     0,     0,
       0,   569,     0,     0,     0,     0,     0,     0,   107,   106,
     114,   116,     0,   115,   117,     0,     0,     0,   110,  1100,
       0,     0,     0,     0,     0,     0,     0,   224,   212,   211,
       0,     0,   375,   378,     0,   813,     0,     0,     0,   807,
     888,   887,   886,     0,   828,   830,     0,   629,   629,   629,
     629,   616,   618,   248,   123,     0,     0,   124,     0,     0,
     238,   135,   137,   138,   139,   343,   342,   344,     0,   339,
       0,   372,   102,   309,     0,   240,     0,     0,     0,     0,
       0,   572,     0,     0,     0,     0,     0,   696,   802,     0,
       0,   535,     0,     0,     0,   540,   208,   208,   120,   332,
     404,  1317,  1318,   692,   408,  1765,     0,     0,     0,     0,
       0,     0,     0,   475,   474,   486,     0,   476,   477,   473,
       0,   671,     0,     0,   676,  1048,     0,   688,     0,   686,
       0,  1124,     0,  1049,     0,     0,     0,  1055,     0,     0,
    1092,  1089,     0,     0,  1049,     0,  1101,     0,     0,     0,
    1062,  1063,  1064,  1061,  1065,  1060,     0,     0,  1066,  1059,
       0,   872,   871,     0,     0,     0,   544,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   989,     0,   911,     0,
    1049,  1049,  1076,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1049,  1082,     0,  1770,  1771,     0,  1013,
     912,  1048,     0,     0,     0,     0,  1139,   900,     0,     0,
     905,     0,     0,     0,     0,   907,   916,   914,   915,     0,
     903,   904,     0,   933,   953,  1105,     0,     0,   960,     0,
    1083,   983,     0,   974,     0,   969,     0,   972,   976,   956,
       0,     0,     0,     0,     0,     0,   954,     0,   949,   947,
     948,   941,   942,   943,   944,   945,   946,   950,     0,  1529,
    1552,     0,   726,   726,   714,   724,  1103,     0,   803,     0,
       0,     0,  1017,     0,  1128,     0,     0,   899,     0,   156,
     606,     0,     0,   813,   799,     0,  1048,     0,   803,     0,
     648,   647,     0,     0,   739,   740,     0,   757,     0,   756,
       0,     0,     0,  1299,  1301,  1212,  1268,  1239,  1271,  1217,
    1259,     0,  1243,  1194,  1188,     0,  1340,  1386,     0,  1764,
       0,     0,     0,   558,   559,     0,     0,     0,     0,     0,
     208,   635,   639,   204,   636,   505,     0,   509,   830,     0,
     128,   129,   561,   562,     0,  1131,   564,   313,   323,     0,
     317,   318,   315,   319,   320,     0,     0,   191,     0,     0,
     208,   208,     0,   568,   200,   203,   201,   202,     0,   567,
       0,   112,   113,     0,     0,     0,     0,   452,   441,   451,
       0,     0,   435,   214,   215,   227,   213,   374,     0,     0,
       0,     0,   808,     0,     0,   813,     0,     0,   821,   814,
     822,     0,     0,     0,     0,   628,     0,     0,     0,     0,
     619,   633,   127,   126,     0,   136,     0,     0,     0,     0,
       0,   804,     0,     0,     0,     0,   239,   241,   243,   244,
     245,     0,   307,   308,   302,     0,     0,   493,     0,     0,
       0,   276,   277,     0,   698,   699,     0,   208,     0,   208,
       0,   208,     0,   592,   366,     0,  1332,  1761,  1331,     0,
    1370,  1373,  1374,  1351,  1350,  1369,     0,   488,     0,   483,
     478,   480,  1120,  1119,     0,  1118,     0,     0,   677,   689,
     682,   684,   683,     0,     0,   680,     0,   730,     0,  1057,
    1058,     0,     0,     0,     0,  1088,     0,     0,  1087,     0,
    1041,  1024,  1026,   854,     0,  1031,     0,   848,     0,   851,
       0,   929,     0,     0,     0,  1032,   991,   992,   993,     0,
    1006,     0,     0,     0,     0,   928,     0,     0,     0,     0,
       0,     0,     0,   994,   995,  1007,  1033,   909,   910,     0,
       0,  1074,  1075,  1034,   883,   884,   885,   885,     0,     0,
    1081,     0,     0,     0,  1039,  1048,     0,  1015,  1048,   913,
     876,   877,     0,     0,   906,   901,     0,   902,     0,     0,
       0,     0,     0,   975,   971,     0,   973,   977,     0,     0,
       0,   962,   984,   958,     0,     0,   964,     0,   985,   726,
     726,   726,   726,   723,     0,     0,     0,   773,   762,   765,
     775,   766,   768,  1126,     0,   753,     0,     0,  1021,  1018,
     147,     0,   166,   155,   608,   609,   154,  1386,     0,  1111,
    1108,   690,     0,   659,   737,   738,   760,   742,   746,   743,
       0,  1300,  1231,  1204,  1385,  1388,  1399,  1397,  1241,     0,
       0,   267,     0,     0,     0,   638,   508,     0,   560,     0,
     316,   322,   321,   248,     0,     0,   192,   199,   197,     0,
       0,   118,   119,     0,   437,     0,     0,     0,   228,   104,
       0,   376,  1572,   920,   377,   379,   516,   380,   381,     0,
       0,     0,     0,   811,     0,     0,     0,     0,     0,     0,
     813,   899,     0,   625,  1157,  1158,   624,  1159,   621,   620,
     627,   626,   623,   622,     0,     0,     0,   259,     0,     0,
     253,     0,     0,   254,   247,   250,   251,     0,   131,     0,
     346,   340,   373,     0,   806,   240,   266,   294,     0,   304,
       0,     0,   331,   329,   328,  1129,     0,     0,     0,     0,
       0,   273,     0,   614,   691,  1205,   536,   208,   393,   542,
     539,   543,   541,   697,     0,     0,   487,   481,     0,     0,
     453,   670,     0,     0,   674,   675,   687,   685,   208,  1050,
    1056,   860,     0,  1091,  1085,     0,     0,     0,  1051,     0,
       0,   545,  1069,  1068,   990,  1070,     0,     0,     0,  1005,
    1004,  1002,  1003,   996,   997,   998,   999,  1000,  1001,  1079,
    1078,  1072,  1073,   880,   878,     0,  1036,  1037,  1038,  1080,
    1046,     0,  1014,   866,   899,   908,   931,   934,   981,   961,
    1084,   978,     0,  1054,     0,   957,     0,     0,     0,   966,
     929,     0,     0,     0,     0,     0,     0,   718,   717,   773,
       0,   775,     0,   774,   787,     0,     0,   793,   791,     0,
     793,     0,   793,     0,     0,   767,     0,   769,   787,     0,
       0,   755,  1019,  1020,     0,  1384,     0,     0,  1116,  1115,
    1302,     0,  1181,     0,   269,     0,     0,   270,   518,     0,
     246,     0,     0,     0,     0,   565,   566,     0,     0,   440,
     439,   217,     0,   363,     0,     0,   367,   358,   360,     0,
       0,     0,   809,   815,   816,   817,   818,   819,   820,   812,
     829,   356,     0,     0,   257,   261,   262,   260,   252,   255,
     274,     0,     0,   348,     0,     0,   805,     0,     0,     0,
     263,     0,   297,   242,   306,   308,   303,     0,   325,     0,
     492,     0,     0,     0,     0,   523,     0,     0,     0,   524,
     528,   525,   534,   519,   588,   589,   586,   587,     0,   275,
     550,     0,  1353,  1354,  1355,  1356,  1357,  1358,  1359,  1360,
    1361,  1362,  1364,  1365,  1366,  1363,  1367,  1352,  1371,     0,
     479,  1117,     0,   454,  1090,  1030,  1040,   853,  1086,   850,
    1067,     0,     0,     0,  1035,  1048,  1140,     0,   979,     0,
     982,   963,   959,     0,   965,   986,   722,   721,   720,   719,
     777,   785,     0,   764,     0,   792,   788,     0,   789,     0,
       0,   790,   779,     0,     0,   785,     0,   800,     0,     0,
       0,   710,   899,     0,  1112,  1203,   557,     0,   271,   563,
     193,   194,   195,   196,   436,   438,   210,   226,   365,   364,
     362,   359,   361,   810,     0,   549,     0,     0,     0,     0,
     249,   280,     0,   240,   347,     0,     0,   341,   297,   265,
     264,     0,     0,     0,   301,   330,     0,     0,     0,   494,
     501,     0,  1132,   521,   514,     0,     0,   522,     0,   531,
     532,     0,   520,   502,     0,     0,   482,     0,  1008,     0,
       0,  1047,   980,  1053,   967,   776,     0,     0,   778,     0,
       0,   781,   783,     0,     0,     0,     0,     0,  1129,   801,
     752,   754,   167,  1113,     0,     0,   218,   641,   641,   219,
     216,   549,     0,   547,   357,     0,   256,     0,   285,     0,
     349,   350,   345,     0,   301,     0,   295,   296,     0,   230,
     642,     0,   803,     0,     0,   499,   496,     0,     0,     0,
     529,   530,     0,   533,   803,   673,     0,  1009,     0,   786,
     795,     0,   782,   780,   770,     0,   772,     0,  1109,   274,
       0,     0,   546,   548,     0,   278,   279,     0,   258,   281,
     282,     0,     0,   231,   293,     0,   501,   489,   495,   500,
       0,   515,   526,     0,     0,  1010,   784,     0,   771,  1114,
     280,   220,   221,     0,     0,     0,     0,   283,     0,   284,
       0,     0,     0,   382,   383,   353,     0,   298,     0,   498,
     501,   527,   591,   794,   285,     0,   290,     0,   289,     0,
     286,   287,     0,     0,   388,     0,     0,   351,   354,   355,
     299,   300,   497,   590,     0,     0,     0,   288,   291,   292,
       0,   392,   384,   335,     0,   574,   585,   573,   575,   583,
     580,   582,   581,   579,   272,     0,   387,   391,     0,   385,
     352,     0,   584,   578,   709,   700,     0,     0,   576,   585,
     353,   392,   577,     0,   386,   336
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    67,   220,   221,   222,  1371,   223,   224,
     225,  1303,  1738,  1023,   226,  1359,  1777,   227,   228,   229,
    1362,  1364,  1781,   230,   824,  1591,  1592,  2000,  1593,  1594,
    1578,  1174,  1572,   231,   232,   233,  1168,  1568,   234,   235,
    1281,  1400,   236,   237,  1750,  2105,  2766,  2850,   691,  1317,
    2389,  2390,   238,   712,  2145,  2146,  2147,  2148,  2131,  2434,
    2435,  2436,  2149,  2650,  2150,  1682,  1803,  2160,  2161,  2858,
    2908,  2909,  2910,  2960,  2652,  2794,  2869,   239,  2451,  1796,
    2151,  2152,   240,   241,  1290,  1714,  2069,   242,   713,  2452,
    2658,   243,   746,   244,  1367,  1788,  1789,  2644,  2785,  2862,
    2966,  2967,  2777,  2616,  2617,  2618,   245,   246,   247,   248,
    1791,  1319,  1751,  1752,  2394,   249,  2943,  2944,   714,  2999,
     250,   251,   747,  1026,  2875,   252,   253,   765,   766,   767,
     254,   968,  2098,   255,   256,   787,   788,   789,  1429,  2189,
    2190,  2480,   811,  1834,  1835,   257,   715,  2458,  2798,  2799,
    2876,   258,   716,  1283,  1693,  1694,  1695,  2803,  2395,  1696,
    2672,  2673,  2813,   259,   260,  1671,   261,  1814,  1885,   262,
    2853,   263,   264,   804,  1443,   265,  2082,  1717,   266,  2159,
    2987,  3001,  3002,  3003,  2678,  2974,   267,  2989,   269,   270,
     271,   678,  1182,  1190,  1183,   272,   273,   274,  1771,  1772,
    2126,   275,   276,   277,   278,  1357,   279,   280,   281,   282,
     283,   849,   841,  1198,  1607,   284,  1405,   752,  2990,  1435,
    1843,  1844,  2991,   287,  1439,  1850,  2992,   289,  1011,  1806,
    2993,  1123,   292,   293,   294,  1556,  1984,   796,  1204,   815,
     854,   855,  1612,  1613,  1211,  1626,  1619,  1621,  2581,  2751,
    1212,  1624,  2019,  1988,  2318,  2319,  2320,  2563,  2574,  2736,
    2831,  2321,  2322,  1387,  2140,  2141,  1697,  1759,  2117,  1339,
    1124,  1125,  1126,  1474,  1481,  1468,  1342,  1127,  1128,  1129,
    1345,  1130,  1131,  1132,  1133,  1453,  1515,  1134,  1135,  1491,
     876,  1136,  1137,  1509,  1942,  1523,   993,  1138,  1552,  1853,
    1895,  1140,  1502,  1511,  1876,  2544,  1856,  1451,  1877,  1889,
    2234,  1897,  1903,  2261,  2262,  1915,  1951,  1141,  1860,  1861,
    2216,  1455,  1142,  1143,   952,  1462,  1144,  2193,  1602,  2005,
    2844,  1603,  2194,  2195,  1146,  1430,   839,  2827,  1170,   621,
    2064,  2800,   685,   793,  1147,  1148,  1149,  1150,  1151,  1152,
    1153,  2119,   771,   622,  2416,  1259,  1595,  1154,   604,   686,
     295,   623,   624,   897,   898,  1247,  1250,  1238,  1656,   605,
     606,   722,  2592,   296,   297,   298,   299,   300,  1217,   856,
    1232,  1650,   877,   301,    71,    76,    72,   878,   584,   585,
    1632,   302,   659,  1633,  1235,   883,   588,   304,   305,   589,
     590,   307,   641,   591,   861,   309,   862,   592,   311,   312,
     313,   868,   314,  1214,  1215,  2351,  1216,   315,   316,   625,
     626,   317,  1031,  1401,  1030,   723,   318,   319,   910,   911,
    1045,  1046,  1416,  1047,  1048,  1261,  1262,   320,   321,   617,
     322,   323,  1422,  2184,  2180,  2697,  1423,  2181,   324,   325,
     326,   327,  1562,   328,   329,   833,  2355,   330,   655,   331,
     923,   607,   608,   609,  1156,   643,   792,  1157,   931,   644,
     594,   595,   611,   612,   933,   597,  1417,    73,  2038,  1418,
    1159,  1160,  1500,   614,   888,   903,   904,  2039,   906,    74,
     907
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2690
static const int yypact[] =
{
   -2690,   279,  9994, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, 12038, -2690, -2690, 37775,   286, -2690, -2690,
   -2690, 32427, -2690, -2690, -2690, -2690, -2690,   176, 31663, 10887,
   -2690, 45776, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, 45776, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, 31282,   630, -2690,   256, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690,   523,  2146, -2690, -2690, 33955, -2690,   208,
   -2690, -2690, -2690, -2690, -2690, -2690, 45776, 41585, -2690,   317,
     523, -2690,   242,  4980, -2690, 33955, 34337, -2690, -2690, 46157,
     427, -2690,  2772,   523, 34719, -2690,   949, -2690, 28981, -2690,
   -2690, -2690,   647,  1944, -2690, -2690, -2690,   557, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, 41585,   989,   412, 29363, -2690,
   -2690, -2690, 41585, -2690, -2690, -2690, -2690, -2690, -2690, 35101,
   -2690,    57, 42347,   621, -2690,   523, -2690,   666, 30900, -2690,
   42728, -2690, -2690,   443, -2690, -2690, -2690, -2690, -2690,   412,
   -2690, 31282, 27439, 40442,   649, -2690, -2690, -2690, -2690,   -96,
   12365,   455, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690,   839, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690,   540, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690,    20, -2690,   576,    27, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, 47300,   935, -2690, -2690, -2690,   547, -2690,
     639, -2690, -2690, -2690,   600, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690,   467, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690,  1011, 38156, -2690, -2690, 38918, -2690,
   -2690,   662,   639, -2690,   704,   567, -2690, -2690, 35101, -2690,
   32809, -2690, -2690, -2690, -2690, -2690,    79, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, 45776, 45776, -2690, -2690,
   -2690,   717, -2690, -2690,   703, -2690, -2690, -2690,   739, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   10407, -2690, -2690,   721, -2690, -2690, -2690, -2690, -2690,   782,
   -2690,   312,   940, -2690, -2690, 31282,   972,   972,  1143, 38918,
   -2690, -2690, -2690, 39299, 41585, 45776, 41585, 39299, 45776, 45776,
    1051, 45776, 41585, 40442, 45776, 45776, -2690,  1161, -2690, -2690,
   -2690, -2690, -2690,   827, -2690,   911, -2690,   978,   970, -2690,
   -2690, 41585, 39299, 45776,   848,   917, 45776, -2690, 41585,   980,
   45776,  1094,  1501,   987, 45776, -2690, -2690, 45776, -2690, 41585,
   -2690, 45776,   -48,  1036,  1169,  1167,    25, -2690, 35101, 35101,
   -2690, -2690, -2690, -2690,   994, -2690, 40442, 39299, 45776,  1001,
   -2690, 45776, -2690, 39299, 45776, -2690,  1525, -2690, 45776, -2690,
   -2690, -2690, 45776, -2690, 45776, -2690,  1131, 41585, -2690,   495,
   -2690, -2690,   540,   793, -2690,   297,   169,   503, -2690, -2690,
     332,   347,   363,   793,   724, 41966, -2690, 45776,     3, -2690,
   -2690, -2690, -2690, 35101,  1136, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690,  1185,  1050, -2690,
   41585, -2690, -2690, -2690, -2690, -2690, 41585,   583, -2690, -2690,
    1323, 45776, -2690, -2690, 41585, -2690,  1429,  1162,  1291, -2690,
    1267,  1944, -2690, -2690,  1298, 15594,   -79, 29745, 43109, 46538,
      15, 43490,  1166,    70, -2690,  -104, -2690,  1476,  1226,  1416,
   -2690,    70, 41585, 31282, -2690, -2690, -2690, 24329,  1346,  1278,
   -2690,  1483,  1294,  1321,   523,  1331, -2690, -2690, -2690, 41585,
    1646,  1646,  1652,  1646,   730,   768,  1361, -2690, -2690, -2690,
   -2690,  1352,  1353, -2690,   321,  1549, -2690, -2690, -2690,  1423,
    1424,  1425,  1426, -2690,  1431,   916, -2690, -2690, -2690,  1611,
   -2690, -2690, -2690,  1361, -2690, -2690, -2690, -2690, -2690, -2690,
    1687,  1674, 33955, 33955,  1422,     8, 30516, -2690,  1374,   717,
   -2690, 14306, 10407, -2690, 21977,   778, -2690, -2690, -2690,   840,
   -2690, -2690,  1584, -2690, -2690,  1579, 45776, -2690,  1458, 45776,
   -2690, -2690, 46919, -2690, -2690,   972,  1361, -2690,   827,  1398,
    1400, -2690,  1405, -2690,  1414,  1530, -2690,  1419,   847,    87,
    1430,    95,  1532, 41585,  1534, -2690,   271,    18,  1566,   881,
    1434, 27820, -2690, 41585, 39299, -2690, -2690, -2690, 39299, -2690,
    1800, 45776, -2690, -2690, -2690, 45776, -2690, -2690, 45776,  1470,
    1439,  1732, 37012, 45776,  1475,  1759, -2690, -2690,  1478, -2690,
   -2690, 41585, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690,  1439, -2690, -2690, 45776,    49,   191,    50,  1481,
   41585, 41585,  1632, 41585, 45776, 39299, 45776, 41585, -2690, -2690,
   -2690,   919,  1484,  1452, -2690, 37012, -2690,  1430, -2690, 41585,
    1455,  1598,  1600,  1457, -2690,   989,    26, -2690, -2690, -2690,
   -2690,    11,   433, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   45776,     3,     3,    75,  1826, -2690, -2690, -2690, -2690,    74,
   -2690, 40823,  2425,    99,   -10, -2690, 45776,   495,  1691,  1691,
   -2690, -2690,  1647,  1701,  1620,  1480,  1152,  1016,   789, -2690,
   18018,  1482,   240,   240,  1486,  1487, -2690,  1491,  1500,  1503,
    -118,  -118,  1605,  1504,  1506, -2690,   876, -2690,  1023,   943,
    1223,   240, 18018, -2690,  1507,   963,  1508,  1511,  1515,  1097,
    1522,  1503,  1114,  1527,   991,  1043,  1536,  1537, -2690,  1504,
    1503,    55, -2690,    80, -2690, -2690,   257, 18018, 18018, -2690,
   18018, 18018, 15998, -2690,   989, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690,    33, -2690,  1099, -2690,  3014, 18018,  7808,
   -2690, -2690, -2690,  1156,   -22, -2690,   257,  1538, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690,  1142, -2690, -2690,  1151, -2690,
   -2690,  1158,   742,   742, 33191, 33191, -2690, -2690,    84,  1477,
   -2690,   964, -2690, -2690, -2690, -2690, 33573,  1848, -2690,  1931,
    1717,   408, -2690,  1726, 28201, 28201, -2690, -2690,  1719, -2690,
   -2690, -2690,  1730, 41585, -2690, 25487, -2690, -2690,   540, -2690,
   -2690, -2690,  1544, -2690,   -96,   -96, 18018,   -96,   -41, 16402,
   18018,  1771,   712,  1553,   835, -2690, 47666,  1361, 38537, 38537,
    1741, -2690, -2690,   483,   380,  1644,  1715,   758,  1184, -2690,
   -2690, -2690,  1545, -2690,  1811,  1361,  1272, 33955,  1599, 33955,
   -2690, -2690, -2690,  1826, -2690, -2690, -2690, -2690,  1555,   724,
   -2690,  1374, -2690, 14381,   939, -2690, -2690, 10407, -2690, -2690,
   -2690, -2690,  1557, -2690, 38918,  1559, 45776, -2690,  1561,  1565,
   -2690, 47666, 27058,  1619,  1634, 46538, -2690,    73,   531,  1637,
     110, -2690, 13941,  1678,  1622,  1627,  1639,  1648,  1629,  1653,
    1533,   862,  1866,  1203,  1866,  1621,  1734,  1658,  1660, 40442,
    1663, 46538, -2690,   733, -2690, -2690, -2690,   827, -2690, -2690,
    1601,  1430,  1603,   343,  1746,  1796,  1743,    22, 31282, -2690,
    1610, -2690,  1651,  1651,  1651,  1613,  1613,  1614, -2690, -2690,
    1651,  1615, -2690, 37394, -2690,   552,   598, -2690,  1932,    40,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,   553,
   -2690,   827, -2690, -2690,  1940,    62, -2690, 37012, -2690,   -81,
    1878, -2690,  1933, -2690,   524, -2690, -2690,   164,  1624, -2690,
   -2690, -2690, -2690,   -17, 33955,  1854,  1772, -2690,  1430,  1951,
    1638, -2690,  1068, -2690,  1738, -2690, 18018, -2690, 27058,  1952,
      96,  1686, 35866, 41585, 41585, 45776,    96, -2690, -2690, 41585,
   -2690, -2690,  1836,   782, 45776, -2690, -2690, -2690, -2690, -2690,
   -2690,     3, -2690, -2690, -2690,    80,  2038,  1645, -2690,  2040,
     816,  1665, -2690,  1649, 45776, 39299, 45776, 45776, 41585,  1718,
    1654, -2690,  1694,  1657, 25101, -2690, -2690,   116, 41585, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, 40823, 18018, 16806,
   -2690, -2690, -2690,  1662, 10473,  1697, 18018, -2690, -2690, 18018,
   18018,   685, -2690,   685, -2690,  1668, -2690,   724, -2690, -2690,
   -2690, -2690,  1495,   724, -2690,  1651,  1651, -2690,  3283, 18018,
     724, -2690, 26658, 18018, 18422, 13131, -2690, 18018,  1742,  1751,
     724, -2690,   724, -2690, 18018, 14786, -2690, -2690, 35483, -2690,
   -2690, 18018, -2690,  1666,  2002,  2002,    60,  1075,   897,  1679,
    2459,  1681, -2690,  1777,   724, -2690,   724,   845,  1504,   411,
    1903,  1698,   -84, -2690,    77,   419, 37012, 18018, 31282,  1766,
   18422, 18018,  1707,   863, -2690, 18018,    86, -2690,  1708, 18018,
    1765,   109, 18018, 18018, 18018, 18018, 18018, 18018, 18018, 20024,
   20428, 18826,   122, -2690, 32045, 15594,  1934, -2690, -2690, 12726,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, 45776,
    1848, -2690, -2690, -2690, -2690,  1775, -2690, -2690, -2690,  1165,
   -2690, -2690,   492, -2690, -2690,  1895, -2690, -2690, -2690, -2690,
   -2690, -2690,  1712, -2690, -2690, -2690, -2690, -2690, -2690, 38918,
    1720, 45776,   -14, -2690,  1666, 40061, 45776, -2690, -2690,  1912,
   -2690, -2690,  1721, -2690,  7915,  1912,  1868,  1875, -2690,   -33,
   10473,  1907, 10473, -2690, -2690, -2690, -2690, -2690, -2690,  1361,
    1736,  1274, 11270, -2690, 11654, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,   916,
    1731,  2103,  1286, -2690, -2690, 33955, -2690, -2690, 30516, -2690,
    1744, -2690, -2690, -2690,   840,  1736, 10407, -2690, 10407,  1736,
   -2690,  1735, -2690, 45776, 45776, -2690,  1739, 45776,  1926,  1927,
    1747, -2690, -2690, 45776, -2690,  1893, 45776, 18018,  1898, -2690,
     113,   138, -2690,   874, -2690, 37012, -2690, -2690,   827,  1815,
   45776, 45776, 45776, 45776, 45776, 45776,   916, -2690,  2054,   916,
     916,   672,  1481,  1481, -2690, -2690, -2690, 45776, 45776, 45776,
   45776, 45776,  1900, 45776,  1831, 45776,  1865, 45776, -2690,   733,
   -2690, -2690,  1976, -2690, -2690,  1786,   724,  1813, -2690, -2690,
   27058,  1954, 35866,   -13, 41585, 41585,   -13, -2690, -2690, -2690,
     820,   878, -2690,  1776, 18018,    47, 37012,  1769, 23538, -2690,
    1832, -2690,  1834,   724, -2690, -2690,   164,  1784,  1784,  1784,
    1784,    62, -2690, -2690,   -81,   724, 45776, -2690,  1998, 45776,
    1196, -2690, -2690, -2690, -2690, -2690, -2690, -2690,  1914,  1911,
   45776, -2690,   733,  1533, 41585, 39680,  2090,  1994,   989, 41585,
    1891, -2690, 45776,  2112,  2011,  2012,  2027, -2690, 10473,  1801,
   37012, -2690, 45776,  1798,  1804,  1803,    96,    96, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, 35101,  1827, 35101,  1828,
    1828,  2206,  1833,  1477,  1807, -2690,  1430,  1477,  1477,  1654,
   43871, -2690, 15190,   890, -2690,  1666,    68, -2690,   397,   535,
    1981, -2690,  2043, 10473,   900,   384,   545, -2690,   724, 18018,
      16, -2690,  8619,   952,  8645,   997, -2690,  1816,  1818,  1007,
   -2690, -2690, -2690, -2690, -2690, -2690,  1823,  2048, -2690, -2690,
    1835, -2690, -2690,  2219,  1019,  1837, -2690,  1830,  8830,  1841,
   18422, 18422, 18422, 15998, 18422,  1120, -2690,  1842, -2690,  1845,
    4493,  8143,  1829,  1846,  1861,  1876,  1847,  1850,  9247, 17210,
   18018, 17210, 17210,  9332,  1829,  1851, -2690, -2690,  2949, -2690,
   -2690,   257, 18018, 45776,  1852,  1855, -2690, -2690,  2058,  2006,
   -2690,  1504, 26658,  1522, 18018, -2690, -2690, -2690, -2690, 15998,
   -2690, -2690,  1504, -2690,  3283, -2690,  1885,  1351,   101, 15998,
   -2690, -2690,  2080, -2690,   694, -2690,  1862, -2690, -2690,  3761,
   18422, 18018,  1707, 18018,  1925, 26658,  5646, 18018,  1392,  2511,
    2511,    48,    48,    60,    60,    60,  1075,   419,  1867,  1270,
    1335, 41585,  2619,  3068, -2690, -2690, -2690, 22766,  1484, 18018,
   18018,  1869, -2690,  1029, -2690,    70,   724,   845,  2145, -2690,
    1987,   492, 28591,  1736, -2690,  1871,  1666, 45776,  1484,  1886,
   -2690, -2690,  1033, 18018, -2690, -2690,  1317, -2690, 45776, -2690,
   18018, 18018, 16402, -2690,  1888, -2690, -2690, -2690, -2690, -2690,
   -2690,  1874, -2690, -2690, -2690, 45776, -2690,  2250,  1880,  1877,
    1883,  1884,  1996, -2690, -2690, 18018,   414,  1890,  1892, 45776,
      96, -2690, -2690, 10473, -2690, -2690, 36248, -2690,  1896, 45776,
    1457,  1457, -2690, -2690,  2003, -2690, -2690, -2690, -2690,   916,
   -2690, -2690, -2690, -2690, -2690,   916,   916, -2690, 37012,    69,
      96,    96,  1958, -2690, -2690, -2690, -2690, -2690,  1959, -2690,
   45776, -2690, -2690,  1786,  1887,   -13,  1904, -2690, -2690, -2690,
    2084,  2092, -2690, -2690, -2690,    81, -2690, -2690, 31282, 26259,
    4757,  1913, -2690,  1917,   724,  1736, 23941,  1215, -2690, -2690,
   -2690,   460,  2077,  1918,  2055, -2690,    24,    72, 44252, 44633,
   -2690,  1788, -2690,  1457,  1974, -2690,  1993,  1962, 41585,   164,
    1039, -2690, 37012,  1929, 41585,  1936,  1924, -2690, -2690, -2690,
   -2690,  1082, -2690, 37012, -2690, 41585,  1997,  1978, 37012,  2073,
    1086, -2690, -2690,   -96, -2690, -2690, 24715,    96,  1937,    96,
   37012,    96, 36630, -2690, -2690,  1070, -2690, -2690, -2690,  1948,
   -2690,  1935,  1935, -2690, -2690, -2690, 39299, -2690, 45776,  -134,
   -2690, -2690, -2690, -2690,  1088, -2690,   689, 45776, -2690, -2690,
   -2690, -2690, -2690,  2176,  2179, -2690, 43871, -2690, 18018, -2690,
   -2690,  1945,  1943,  9358, 18018, -2690,  2185, 37012, -2690, 41585,
   -2690, -2690, -2690, -2690,   724, -2690, 18018, -2690, 18018, -2690,
     724, -2690, 26658, 18018,  2169, -2690,  2279,    53,  2279,  2459,
     484, 37012, 18422,   428,  1508, 19620, 18422, 18422, 18422, 18422,
   18422, 18422, 18422, 20818, 21222, -2690, -2690, -2690, -2690, 18018,
   18018,  2177,  2169, -2690, -2690, -2690,  1222,  1222, 37012,  1953,
    1829,  1955,  1956, 18018, -2690,  1666, 18018, -2690,  1666,  2974,
   -2690,  2242,   989,   -84, -2690, -2690,  1957, -2690, 19230, 18422,
   18018,  1119, 18018, -2690, -2690,  1960, -2690, -2690, 37012, 18018,
    1440,  4158, -2690,  4371, 18018,  1961,  4600, 15998, -2690,   412,
     412,   412,   412, -2690, 41585, 41585, 22380, 45014,  1946,  1227,
   -2690, 45014, 45395,  1963,  1967,  2168,  1132,  1163, -2690, -2690,
   -2690,  1969, -2690, -2690, -2690, -2690, -2690,  2250,  1968,  1970,
   -2690, -2690, 17614, -2690, -2690, -2690,  1477, -2690, -2690, -2690,
   10407, -2690, -2690,  1982, -2690, -2690, -2690, -2690, -2690,  2025,
    5369, -2690, 45776, 45776,  1171, -2690, -2690,  2022, -2690,  2039,
   -2690, -2690, -2690, -2690,   155,   727, -2690, -2690, -2690, 45776,
   45776,  1457, -2690,  2166, -2690,  2170,   -13,   -13, -2690,  1481,
    2232, -2690,  1698,  1184, -2690, -2690, -2690, -2690, -2690,   691,
     724,  1250,  1985, -2690,  1154, 23941, 23941, 23941, 23941, 23941,
    1736,   845, 41585, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690,  1988, 45776, 18422, -2690,   525,    59,
   -2690,  2171, 41585, -2690, -2690, -2690, -2690, 37012,   524, 41585,
    2215,  2128, -2690, 45776, -2690, 39680,   785,  2195, 39680, -2690,
   45776,   -96,  2184, -2690, -2690,  1419,   989, 45776,  2004,  1864,
     440, -2690, 45776, -2690, -2690, -2690, -2690,    96, -2690, -2690,
   -2690, -2690, -2690,  1068,   299,  1828, -2690, -2690,  2210, 43871,
   -2690, -2690, 15190,  2005, -2690, -2690, -2690, -2690,    61, 10473,
   -2690, -2690, 18018, 10473, -2690,  2007,  2009,  2010, 10473,  5704,
    2013, -2690, 10473,  2177, -2690,  1415,  2224,  2152,  2015,   484,
    1415,   334,   334,   137,   137,    53,    53,    53,  2279, 10473,
   10473, -2690, -2690, -2690, -2690,  2016, -2690, -2690, -2690,  1829,
   -2690,  7658, -2690, -2690,   845, -2690, -2690, -2690,   519,   175,
   -2690,    89, 37012, -2690,  1173,   175, 18422, 18018, 18018,  5529,
     187, 18018,  7079, 41585, 41585, 41585, 41585, -2690, -2690, 21612,
    1227,  2017, 45776, -2690,  2019, 22766,  2197,  2150, -2690, 22766,
    2150,   933,  2150, 22766,  2205, -2690, 25873, -2690,  2021, 13536,
    2322,  2236, -2690, -2690,   989, -2690,  2026, 45776, -2690, 10473,
   -2690, 45776, -2690, 45776, -2690,  1175,  1179, -2690, -2690, 45776,
    1788,  2178,  2182,   724, 45776, -2690, -2690,   -13,   -13, -2690,
   -2690, -2690,   989, -2690,   561,  2283, -2690,  2229,   399,  2031,
    2253,  2254, -2690, -2690,  1326,  1326, -2690, -2690, -2690, -2690,
   -2690,  2258, 18018,   650,  1415, -2690, -2690, -2690, -2690, -2690,
    1638,  2083,   287,  2285,  2278,   164, -2690,  2045,  2304,  2306,
   -2690,  2050,  1329, -2690, -2690, -2690, -2690,   989, -2690,  2272,
   -2690, 23152,   989,  2193,  2151, -2690, 33955,  2209,   382, -2690,
   -2690, -2690,  1010, -2690, -2690, -2690, -2690, -2690,  2121, -2690,
   -2690,  2287, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,  2200,
   -2690, -2690, 15190, -2690, 10473, -2690, -2690, -2690, -2690, -2690,
   -2690, 18422,  2064, 18422, -2690,  1666, -2690,  1182, -2690, 37012,
     519,   175,   175, 18018,   175, -2690, -2690, -2690, -2690, -2690,
   45014,  2065, 45776,  1227, 22766, -2690, -2690,  1684, -2690, 22766,
    2252, -2690, -2690, 22766, 45776,  2068, 45776, -2690,  1183, 18018,
   18018, -2690,   845, 18018, -2690, -2690, -2690,  2183, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, -2690,   546, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, 39299,  2386, 41585,   691,  7296,  2221,
   -2690,  2243, 45776, 39680, -2690,   706,  2191, -2690,  1329, -2690,
   -2690, 41585,  2220,  2222,  2217, -2690, 41585, 18018,  1186, -2690,
   41204,  2078,  1419, -2690,  2075,  2233,   453, -2690,  2226, -2690,
   -2690,  1439, -2690, -2690, 41585,   -96, -2690,  1197,   705, 18422,
     569, -2690, -2690, -2690,   175, -2690, 45776,  1210, -2690, 18018,
    2086, -2690, -2690, 22766,  1684,  1216, 45776,  1219, 37012, -2690,
    1829, 10473, -2690,  4018,  2082, 41585, -2690,  1759,  1759, -2690,
   -2690,  2386,  2401, -2690, -2690,  2316, -2690,   431,  2234,  2406,
   -2690, -2690, -2690, 45776,  2217,  1220, -2690, -2690,  2375, -2690,
   -2690,  7565,  1484, 23152, 41585, -2690, -2690, 18018,   989,  2293,
   -2690, -2690,  2247, -2690,  1484, -2690,   873, -2690,  1232, -2690,
   10473, 45776, -2690, -2690, -2690,  1235, -2690, 18018, -2690,  1638,
     989,   989, -2690, -2690,  2347, -2690, -2690,   126, -2690,  2245,
    2246,   735,  2106, -2690, -2690,   488, 41204, -2690, -2690, -2690,
    1242, -2690, -2690,  2305,  2356, -2690, -2690,  1245, -2690, -2690,
    2243, -2690, -2690,  2211,   294,   294,  2156, -2690,  2364, -2690,
     724,   724, 37012,  2107, -2690, 30127,  2212, -2690,  2214, -2690,
   41204, -2690,  2310, -2690,  2234,  2351, -2690,  2443, -2690,    93,
   -2690, -2690, 39299, 26658, -2690,   735,  1254, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690,   787,   691,  2235, -2690, -2690, -2690,
    1430,   -60, -2690, -2690, 30127, -2690,   359, -2690, -2690, -2690,
   -2690, -2690, -2690, -2690, -2690, 39299, -2690, -2690, 35866, -2690,
   -2690,  1246, -2690, -2690,  1280,  1321,  2119,  2120, -2690,   359,
   30127,  2239, -2690,  1273, -2690, -2690
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2690, -2690, -2690, -2690, -2690,  2308, -2690, -1633, -2690, -2690,
   -2690,  -749, -2690, -1591, -2690,  1172, -2690, -2690, -2690, -2690,
   -2690,   400, -2690, -2690,  -729,  1354, -2690,   537,   538, -2690,
   -2690, -2690, -1361, -2690,   133, -2690, -2690, -2690, -2690, -2690,
     462, -1142, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690, -1323,   764,   100, -2690,    98,   830,   177, -2690,
     -85, -2690, -2690, -2690,  -360,   505, -2471, -1883,    90,  -377,
    -400,  -355,  -349,  -373, -2690,  -224,  -299, -2690, -2690, -2690,
   -2690,   121, -2690, -2690,  1195, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690,  1857, -2690, -2690,   806, -2052, -2690, -2690, -2690,
    -437,  -409, -2690, -2593,   -42,   -40, -2690, -2690, -2690, -2690,
   -2690,  -980, -2690,   474, -2690, -2690, -2690,  -381,  1225,  -424,
   -2690, -2690, -2690, -2690,  -658, -2690, -2690,  2410,   635,   313,
   -2690, -2690, -1681, -1315, -2690,  1780, -2690,  1540,  1146,   388,
     118, -2690, -2690, -2690, -2112, -2690, -2690, -2690, -2690,  -278,
   -2689, -2690,   819, -1010, -2690,   544, -2690, -2690,   438, -1600,
   -2690,   -67, -2690, -2690, -2690, -1271, -2690, -1727, -1879, -2690,
    -248, -2690, -2690, -2690,  1547, -2690, -2690,   447, -2690, -2690,
   -2690, -2690,  -367,  -399, -2690, -2690, -2690,   120, -2690, -2690,
   -2690,  1138,  -811, -2690,   609, -1314, -2690, -2690, -2690,   841,
     -11, -2690, -2690, -2690, -2690, -1137, -2690, -2690, -2690,  1006,
    2468,  -655, -2690, -2690, -2690, -2690, -2690, -2690,   -30, -2690,
   -2690,   429,   -16, -2690, -2690, -2690,    -4,  1593,   804,   156,
     -43,   -69,  -216,   275,   304, -2690, -2690,  -178,   842, -2690,
   -2690, -2690, -2690,   615,  1418, -2690,   610,  -296, -2690, -2690,
    1420, -2690, -2690,  1032, -2690, -2222,   322, -2220,    76,  -871,
    -195,  -165, -2690, -1917, -1648,   197,  -666, -1549, -1772,  1308,
   -2690,  1364,  2516, -2690, -2690,  -919, -2690, -2690,  2799,  4019,
   -2690, -2690,  4282,  4724, -2690,  -945,   362,  5448,  1949, -1050,
   -1328, -2690, -1419,  1159,  1093,  -701, -2690,  8019, -1075,  6129,
   -1418, -1396, -1076, -1224, -2690,   106, -2690, -1372, -2690, -2690,
   -2690, -2690, -2690, -1966, -2081,  -518,   687, -2690, -2690,   790,
   -2690, -2690, -2690,  5663, -1043,   233, -2690,  -743, -2690,    64,
    -245,   646,   -46,   172,  6340,  -786,   243,  -809,   -25,  -638,
   -1758,  1709,  1655, -2690,  -585, -2690,    -2,   117, -2690, -2690,
    1209,  -132, -2690,   -76, -2690,  -847,  -886, -1751,  -636, -2690,
   -2690,   -82, -2690,  1763, -2690,  1000,  1413, -2690, -2690,  1013,
    -757,  -574, -2690, -2690, -2690, -2690, -2690, -2690, -2690, -2690,
   -2690, -2690,  2071,  2366, -2690, -2690, -2690, -2690, -2690, -2690,
    1454,     9, -2690,   -65, -2690, -2690,  2598, -2690,  2372,   114,
    -536, -2690,  2034,   -59, -2690, -2690, -2690,   203, -2690, -2690,
   -2690, -2690, -2690,  -770,  1049, -2690,  1757, -2690, -2690, -2690,
    -687, -2690, -2690, -2690,  1628,  -152, -2690, -2690, -2690,  -935,
     850,  1789,  1642,  -927,  -932,  1024, -2690, -2690, -2690, -2690,
   -2690, -2690,   855, -2690,   214, -2690, -2690,   861, -2690, -2690,
   -2690, -2690,  1535, -2690, -2690, -2690,   356, -2690, -2690, -2690,
    -510,  7143,   -51,   144,   -70,   445,  1268,  6639, -2690,  -639,
     -56,   -53,  3978,   -29,   221, -2690, -2690,  2115,  1028,   877,
   -2690,  4829,  1285,  2490,  -689,  -782,  1802,  -481, -1223, -2690,
    2703
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1623
static const short yytable[] =
{
      68,   992,   750,   843,   291,   603,   935,  1390,   939,  1169,
    1054,   587,  1361,  1797,   308,  2096,   915,   333,  1369,   642,
    1189,  1764,   332,  1260,   887,   332,   770,   938,  1231,  1008,
     290,   832,   941,   645,  1663,  1020,   646,   800,   332,   949,
     975,  1782,   642,   285,   334,   676,   770,   334,   838,  1783,
    1784,   998,   882,  2286,  2169,  1493,   645,   286,   974,   646,
     334,   332,  1524,   717,   978,  2102,   647,  1553,   995,   288,
    1558,  2325,  1145,  1503,  2476,   999,   649,  1857,   929,  2075,
    2076,  2024,   940,   334,  1049,   586,  2305,  2441,  1896,  1027,
    1172,  2341,  1178,  1016,  2560,  2057,  1402,  1032,  1018,  1403,
     794,  2575,  2577,  1935,   891,  1941,  1498,   970,  1024,  2060,
    2061,   679,  1947,  1236,  1412,  1413,  2037,  1809,  1414,    69,
    2041,   721,  1255,   926,   725,  1420,  1526,  1457,  1458,   721,
    1166,  2241,  1757,   768,  1896,  1240,  1241,  1397,  1526,  2111,
    1296,   642,  1013,  1368,   887,  1529,  1477,   924,  1017,  1513,
     842,   291,  1297,   798,  -701,   645,   769,  1529,   646,   905,
     332,  -704,  1469,  1936,   721,  1173,  2364,  1526,  1937,  2781,
    1277,  -870,  1397,  1987,  2413,  1029,   769,   290,  1284,  1526,
    2521,  2214,   334,  -136,  2855,  2133,  1529,   306,  1960,  1926,
     285,  1676,  1437,   268,  1192,  -917,  1554,  1846,  1529,   887,
    -917,   801,  1677,  1530,   286, -1540,  2112,  1397,  1936,  1748,
     615,  2637,  -701,  1937,  1005,  2241,   288,  1557,   197,  -704,
     593,  1043,  2418,  1933,  1854,  1855,  1243,  2949,  1767,  1043,
   -1574,  2020,  2374,   593,  2997,  1863,  1865,  1566,  -229,  2199,
    1184,  -136,  2478,  2978,   858,  1794,  2097,   333,  1811,  1432,
    1278,  1616,   332,  1526,  1819,  1775,   593,  1678,  1285,  1312,
    1687,  2972,   802,  1902,  1739,  1162,  -855,  1000,  2503,  -855,
    2290,  1914,  1529,  -931,   334,  1365,   310,  1530,  -931,     3,
    2479,  2934,  1776,  1567,  1961,  1288,  1493,  1847,  1962,  1001,
    1467,  1366,  1180,  1580,   335,  1298,  2522,   335,  1768, -1623,
     656,  1741,   657,  1532,   598,  1684,  1338,  2682,  1765, -1623,
     335,  1185,   219,  2683,  2684,  2685,  1163,  1963,  2638,  1785,
    1617,  1533,  1534,  1360,  1934,  2686,  2687,  2688,  1398,  2689,
    2690,  2691, -1623,   335,  1006,  1993,  2692,  2693,  2694,  1769,
     268,   912,  1044,  2733,  2404,  1375,   690,  2737,  2998,  1389,
    1220,  2742,  2979,  2501,  1291,   593,  -875,   677,  1292,  1537,
    1679,  1391,  1181,  1398,  1279,  1688,  1749,  1044,  1800,  1310,
    1538,    48,  1044,  1311,   601,   909,  1786,  1532,  1457,  1458,
     684,  2021,  2994,  1034,  1933,  1477,   616, -1525,  2375,  2200,
    1859,  1795,  1555,  1286,   803,  1533,  1534,  1007,  1398,    48,
    2007,  1770,   601,  1938,  1438,  2956,  1280,  1469,    48,  1964,
    2601,   601,  2241,   197,  2384,  1270,    51,   306,   791,  1196,
    1378,  1254,  2710,  1848, -1623,   799,  -172,  1919,  2930,  -701,
    1680,  -701,   335,  1537,  1293,  -917,  -704,  1849,  -704,  -870,
    1399,  1514,  -870,   892,  1538,  2388,  1758,  1631,  1938,  1547,
    1548,  1549,  1550,  1758,  2337,   836,    48,  2254,  1318,   601,
    -136,  1421,  1415,  -870,  1550,  1652,  1433,  1499,  1822,  2094,
    1821,  1255,  2236,  2237,  2238,  2479,  2240,  1564,  1565,  2595,
    2596,   893,  1657,  1029,  1824,  1939,  1541,  2935,  1545,  1546,
    1547,  1548,  1549,  1550,  1896,  1896,  1896,  1526,  1896,  2381,
    1545,  1546,  1547,  1548,  1549,  1550,   310,  1434,   946,  2396,
    2825,   658,  2828,  -931,   150, -1482,  1529,  2832,   890, -1540,
     881,  2834, -1540, -1540,   335,  1787,   913, -1540,  2009,   858,
    1881,  1882,  1676, -1525,   332,  1221,  2809,   332,  2251,  2252,
    2253,  2254,  2300,  1605, -1574,  2957,  1675, -1574, -1574,  1794,
   -1548,  2613, -1574,  1729,  2243,   660,   334,   650,  2396,   334,
    1541,  1012,  2241,  1743,  1896, -1564,  2403,  1009,  2201,  1294,
    1928,   167,  1728,   886,  1545,  1546,  1547,  1548,  1549,  1550,
   -1525, -1583,  1404,  2695,   688,   642,   661,  2506,   150,  1036,
    1295,   894,   895,  2787,   880,  2674,  2958,  2241,  1678,   645,
     858,  2810,   646,  2244,   332,   863,  1672,  2880,   332,  1452,
    1744,  2892,   869,  2959,   726,  1833,   182,  1837,  1838,  2905,
    1640,   770,  1792,   770,  -875,   770,   334,  -875,  1636,   864,
     334,   770,  1039,  2624,  2625,  2626,  2627,  2628,    68,  1533,
    1534,   865,  1839,  2946,   942,   167,   944,  2241,  -875,   948,
    2846,  2947,  2675,  2696,  2615,  2058,   834,  1637,  1780,   651,
    1683, -1482,  2851,  1501,   870,   773,  1929,   951,   971,  2332,
    1930,   652,  2881,   197,  2173,  2174,  1583,  1537,  2635,  1753,
    1637,  1684,   997,  2507,   601,  1914,  2270,  1914,  1914,    51,
    2508,  1773,  1641,   886,   721,  2783, -1548,   764,  1760,  2660,
    1638,  1679,  2847,  1014,  2243,  2609,  2610,   871, -1482,  2906,
     872, -1564,   869,  1021,  2768,   866,   163,  1022,  2202,  2245,
     213, -1527,  1672,  1638,  2636,  2291,  1815, -1583,  1665,   593,
   -1623, -1623,   593,  2249,  2250,  2251,  2252,  2253,  2254,  2243,
    1041,  1820,  1042, -1548,  1175,   653,   850,   197,   886,   795,
     870,   769,   813,   769,  2676,   769,  2611,    69, -1564,  1818,
    2769,   769,   769,   642,   870,  2326,  2327,   219,  2424,  2198,
     758,  1680,  1639,  2948, -1583,   790,  1058,   645,  1260,   873,
     646,  1886,   332,  2241,  1998,   759,  1685,  1584,  2244,  2243,
     831,  2209,   851,   871,   213,  1639,  1761,  2012,  2208,   593,
    2426,  2677,  2029,   593,   334,  2848,   335,   871,  1999,   335,
     872,  2849,  1986,   810,   867,  2072,   603,   603,  1545,  1546,
    1547,  1548,  1549,  1550,  2505,   814,  2187,  2509,  2510,  2511,
    2512,  2513,  2514,  2515,  2516,  2517,  2518,   840,  2244,  2490,
    1836,   219,  2203,  2613,   654,  2277,  1896,   874,   852,  1896,
    1896,  1896,  1896,  1896,  1896,  1896,  1896,  1896,  1896,  2067,
    1943,  2629,  2070,  2071,  2535,   873,   846, -1527,  1730,  1731,
     660,  2538,  2293,  1229,   847,   875,   335,  1687,  2278,   873,
     335,  1028,   720,  2249,  2250,  2251,  2252,  2253,  2254,  1945,
     601,  1265,  2537,  1896,  1267,    51,  2204,  1269,  2614,    68,
      68,   661,    68,   764,  2245,  2779,   843,  1229,  2365,  2430,
     848,  2073,  1208,  2074, -1527,   945,   947,  1681,  2249,  2250,
    2251,  2252,  2253,  2254,  2940, -1623,  2764,  2765,  1488,  1489,
    2339,  1716,   853,  1762,   969,  1732,  1313,  2431,  2377,  2378,
    1314,  2345,   150,  1315,  1209,  2432,  2615,   874,  1354,  1396,
    -733,  2241,  2210,  2294,  2245,  2917,  2295,  2648,   860,  2211,
    1490,  1763,  1209,   291,  2246,  2247,  2248,  2924,  2249,  2250,
    2251,  2252,  2253,  2254,  1488,  1489,  1210,   593,  2887,   916,
    1676,  1379,  2602,   917,   291,  1733,  1734,  1715,  2649,  1410,
    1760,  1677,  1230,   117,  1210,   918,   919,  1450,  1644,   167,
    -733,  1645,  1406,   197,  2941,  1560,  1492,  2433,  2634,  1561,
    1436,   121,  1735,  2860,  1471,  1411,  1407,   920,    69,    69,
     921,    69,  1952,  1381,  2859,  2466,  1230,  2468,  1408,  2470,
    1896,  1440,  -733,  1053,  2397,  2861,  2044,   125,   126,  1055,
    1496,  1953,   870,  2985,   182,  2296,  1678,  1059,  1512,  2529,
    2052, -1267,  2297,  1508,   335,   954,  2483,  2603,     9,  1517,
    2604,  1382,  1176,  2003,  1024,  1024,  2062,  -709,  2942,  1736,
    1646,  1276,   601,   884,  1672,  1191,  1815,    51,  1040,  -709,
    1194,  1570,  1304,  2630,  2981,   871,  2100,  2101,  1761,  2087,
    2113,  2089,  1202,  2243,  1866,   955,  2835,   219,  2837,  1737,
    1573,   197,   896,  2662,  2249,  2250,  2251,  2252,  2253,  2254,
    1056,   601,   875,  -709,   956,  1782,    51,  1659,  1954,   899,
    2663,  2567,  1955,  1783,  1784,  1956,   900,  2590,  2720,  -709,
    1383,   957,   922,   640,  1726,  1608,  1608,  2176,  1608,  2178,
    1024,  2568,  2244,  2135,  2168,  1274,   909,   192,   213,  1679,
    1896,  2103,  2104,  1526,   914,  1654,  2739,   873,  1452,   958,
    1630,  -709,  2570,   603,   925,   332,  1275,   332,   332,  -709,
    1384,   943,  1529,  -875,  1381,   959,  -875,  1229,   953,  1300,
     601,   192,  1229,  1229,  2330,    51,  2664,   334,  2895,   334,
     334,  1256,  1257,   764,  2968,  2986,  1309,  -875,  2241,  2530,
    1301,   950,  2532,  1829,    48,   858,  2716,   601,    51,  2346,
    2665,    70,  2473,   332,  1957,  1669,  2523,  2524,   843,  1680,
     332,  1958,  2370,  2398,    48,  1762,  1647,   601,  2371,  2372,
    1385,  1886,    51,  2968,    52,   334,  2666,   951,  2572,   960,
    1228,  1667,   334,  1372,  1373, -1133,  1628,   769,   642,  1629,
    1380,    68,   887,  -709,   887,    68,   972,  1302,  2245,  2968,
    -849,   662,   645,  -849,  1886,   646,   973,   332,  2246,  2247,
    2248,  3007,  2249,  2250,  2251,  2252,  2253,  2254,   689,   961,
     962,  1383,  2925,  2055,  1473,   963,   994,  2107,  2056,   334,
     602,   748,  2108,  2818,  1055,  2820,  1230,   602,  1573,  2196,
    1003,  1230,  1230,   601,  2197,  2807,  1199,   964,    51,  2207,
      52,  1464,  1466,  2667,  2208,  1896,  1228,  1896,   976,   965,
     977,  1384,  2242,  2668,   966,  2680,   737,  -882,  1715,  1867,
    -882,  1868,  1719,   812,  1486,  1869,   602,  2669,  1475,  1476,
    2243,  1880,   967,  1497,  2670,  1648,  2703,  -852,  1884,   610,
    -852,  -882,  1662,  1257,   602,  2748,   627,  1025,  1906,   648,
    1907,  2218,   593,   593,  2566,   842,  2208,  1488,  1489,   648,
      69,  1480,  1004,    48,    69,  -885,   601,   217,  -885,  1823,
     218,  1385,  1924,  2671,  1925,   602,  2811,   699,  1033,  2244,
    1035,  2269,  1037,  2271,  2272,   627,  1878,  2353,  1038,  1490,
    -840,  2886,  2324,  -840,   648,   687,  2220,  -838,   593,  1015,
    -838,  2208,  2373,   627,   648,  2567,  2223,   648,  1830,  1488,
    1489,  2224,   648,  1896,  2842,  1050,   648,  -885,  2229,  2241,
    -885,   701,   979,  2230,   980,  2568,  1600,   335,  2329,   335,
     335,  2289,  2343,  2208,  1804,  1805,   648,  1569,  2442,  1927,
    2569,  1492,  1051,  2443,  1024,  1940,  2570,   648,   642,   769,
     809,   769,   593,  1950,  1052,   769,   825,   703,   830,  1753,
    1526,   769,   645,  1917,  2571,   646,  2444,   332,   769,  1609,
    1611,  -841,  1615,    48,  -841,   335,   601,  2373,   769,  1529,
     769,  2449,   335,  2241,  1530,  2461,  2450,  2481,  -839,   334,
    2462,  -839,  2482,  1997,  2469,  2245,  2472,  1516,  1610,  1610,
    1057,  1610,   769,  1062,   769,  2246,  2247,  2248,  2241,  2249,
    2250,  2251,  2252,  2253,  2254,  2840, -1451,  1060,  2540, -1451,
    2546,  1886,  2572,  2208,   705, -1450,   706,  1063, -1450,   335,
     858,  2582, -1449,  1061,  1994, -1449,  2208,  1179,   332,    48,
   -1456,  2495,   601,  2405,  2406,  2407,  2408,  2409,  1449, -1454,
     219,  2496,  1501,  2623, -1136,  1065, -1453,  2027,  -504,  2027,
     334,  2243,  2583,  1996,  1186,  2504,    51,  2208,    52,   603,
    2597,   332,  2718,   332,  2757,  2462,  1521,  2719,  2758,  2462,
    1531,  2822,  2839,  2462,  1532,  2872,  2719,  2208,  1488,  1489,
    2873,  1836,  2525,   334,  2092,   334,  2885,  1187,  2309,  2573,
    2310,  2482,  1533,  1534,  2405,  2406,  2407,  2408,  2409,  2889,
    2244,   981,  2410,  1535,  1569,  2894,  2620,  2621,  2896,  2914,
    2443,  2123,  2543,  2443,  1438,  2243,  1816,  1817,  1188,  2821,
    1870,  2926,  1706,  2132,  2928,  1019,  1569,  1229,  2043,  2443,
    1537,  2950,  2046,  2920,  2953,  3008,  2208,  3009,  2050,  1569,
    2243,  1538,  1229,  2983,    68,  1195,    68,  2099,  2984,  1197,
    2099,  1055,   593,  2311,  2106,  2312,  1707,   843,  2063,  1196,
    2066,  1851,  3015,  1653,  2244,  2025,  1629,  2984,  1629,  1199,
    1055,  -701,  1871,  1205,  2080,  1207,  2083,  2032,  2085,  2738,
    1629,  2741,   982,  1199,  1229,  2792,  2793,  1229,  1229,  2244,
    2900,  2901,   983,   984,   985,  1540,   986,   987,   988,   989,
     990,   991,  2156,   843,  2347,  2348,  2212,  2407,  2408,  2409,
    1200,  2324,  1203,   843,   769,  1872,  2245,  1708,  1873,  1718,
    1720,  1721,  1201,   593,  1242,  1244,  2246,  2247,  2248,   335,
    2249,  2250,  2251,  2252,  2253,  2254,   769,  2127,  2128,  2129,
    1206,   769,  1213,  1222,  1218,  1219,  1230,  1223,  1224,  1225,
    1226,  2641,  1709,   769,  1710,  1227,   593,  1541,   593,  1234,
    1237,  1230,  1239,    69,  1711,    69,  1044,  1542,  1543,  1544,
    1249,  1545,  1546,  1547,  1548,  1549,  1550,  1985,  1263,  1264,
    2245,   886,  1266,   886,  2314,  2315,  1272,  1874, -1456,   602,
    2246,  2247,  2248, -1454,  2249,  2250,  2251,  2252,  2253,  2254,
     335,  2566, -1453,  1230,  1508,  2245,  1230,  1230,  1273, -1122,
    1287,  2883,  1289,  1299,  1712,  2246,  2247,  2248,  1282,  2249,
    2250,  2251,  2252,  2253,  2254,  1305,  1316,  1318,  2011,    70,
    1320,  1355,  1356,   335,  1358,   335,   769,  1370,  1374,  1386,
    1388,  1713,  2285,  1392,  2331,  1393,   648,  1394,   627,  1414,
    1508,  1395,  2567,  2287,  1442,  1875,  2543,  1445,   217,    48,
    1508,   218,   601,  1446,   648,   648,   982,  1447,  1448,  1470,
    1456,  1569,  2568,  1950,  1459,  1460,   983,   984,   985,  1461,
     986,   987,   988,   989,   990,   991,  2424,  2569,  1463,  2308,
     982,  1465,   219,  2570,  1472,  1479,  1482,  2425,  2317,  1483,
     983,   984,   985,  1484,   986,   987,   988,   989,   990,   991,
    1485,  2571,   937,   627,   937,  1487,   610,   648,  2426,   648,
    2427,  1575,   648,   610,  1494,  1495,  1559,  1582,  1585,  1598,
    1599,  2829,  1606,  1208,  1627,  1635,  1642,  2662,  1643,  1649,
    1651,   648,  1655,  1673,   627,  1658,   937,  1666,   610, -1403,
    2996,  1664,   996,  1668,  2663,   648,  1699,   937,  1674,   610,
    2324,  1686,  2402,  1702,  2324,  1700,   648,   648,  2324,  2572,
    1701,  1715,  1703,  1704,   769,  2428,   648,  1705,  1722,   627,
    1229,  1723,   610,  1724,  1725,  2865,   648,  1727,  1747,  1740,
     648,  1742,   610,  1745,  2465,   937,  1746,  2888,  1754,  2099,
    1452,  1467,  1473,  1480,  1766,  1756,   602,  2888,   697,   602,
     774,  1779,  1790,   648,  2368,   648,  1798,  2143,   642,  1799,
    2664,   648,  2157,  2429,  1801,  1810,  1802,  2430,  2830,  1807,
    1812,  2419,   645,  2823,  1043,   646,  1826,   332,  1828,  1827,
    1831,  1841,  1840,  1832,  2665,  1842,  2573,  1229,  1438,   648,
    1858,  1859,  1501,  1229,  1229,  2431,  2801,  1866,   775,   334,
    1526,  1576,  2927,  2432,  1904,   627,   648,   825,  1920,   825,
    2666,   843,  2497,  1905,   291,  1922,  1923,   291,  2500,   776,
     843,   602,   602,  2421,  2423,  1931,  1932,  1229,  1946,  1967,
      70,    70,   769,    70,   769,  1949,  1965,   777,  1258,  1230,
    2463,  1987,  1995,  2464,  2414,  2001,  2002,   291,   851,  2004,
    2454,  2553,  2554,  2555,  2556,  2013,  2017,  2018,  2870,  2022,
    2030,   721,  1758,  2031,  2042,  2433,  2035,  2045,  1329,  2324,
    2047,  2048,  2051,  2484,  2324,  2049,   778,  2054,  2324,  2059,
     610,   610,  2068,  2088,  1248,  2084,  1577,  2667,  2086,  2090,
      48,  2109,  2444,  2093,  2095,  2114,  2121,  2668,  2122,  2125,
    2134,  2138,  2139,  2154,   648,   982,  1230,   648,  2155,  1836,
     648,  2669,  1230,  1230,  2158,   983,   984,   985,  2670,   986,
     987,   988,   989,   990,   991,  2163,  2534,  2164,  2165,  2166,
    2167,   937,  2170,  2171,  1415,  2179,  2919,  2172,  2183,  1308,
    1421,  2186,   769,  2205,  2313,  2221,  1230,  2222,   769,   648,
    2206,   663,  2225,   648,   602,  2226,   648,  2671,  1508,   779,
    2232,   648,  2264,  2208,  2227,  2283,  2231,  2559,  2324,   937,
    2235,  2256,   593,   780,  2257,  2263,  2266,  2265,   781,  2267,
    2274,  2281,  1886,  1363,  2282,  2284,  2288,  2292,  2619,  2304,
    2298,   937,  1377,  2333,   648,  2307,  2964,   664,  2328,  1181,
    2338,  2342,   782,  2350,   783,  2352,  2354,   937,  2801,  2356,
     665,  1257,  2357,   784,  2359,  2358,  2383,  1526,  2362,  2367,
    2363,  2369,  2379,  2380,  2386,   785,   786,   666,   648,  1527,
    2099,  2099,  2387,  2385,   217,    48,  1529,   218,   601,  2400,
    1645,  1530,  2412,    51,   648,    52,  2401,  2411,  2437,   335,
    2439,  1228,  1815,   602,  1007,   667,  1340,  2445,  2448,   668,
    2460,  2456,  2457,  2474,   602,  2447,  2467,  2486,    68,  2475,
    2487,  1449,  2491,  2494,  2605,  2606,  2260,  2241,  1513,  2259,
    2565,  2580,  2526,  2586,  2527,  2528,  2536,  2591,  2542,  2593,
    2550, -1136,   669,   602,   602,  2579,  2598,  2980,  2584,  1340,
    2659,  2440,   291,  2599,  2587,   602,  2607,  2446,  1258,  2612,
    2608,  1647,  2622,  1258,  1258,  2639,  2632,  2643,   769,  2645,
    2633,  2651,  2699,   769,   769,   769,   769,   769,  2656,  2657,
    3006,  2711,  2661,  2702,  2712,   670,  2705,  1531,  2706,  2707,
    2734,  1532,  2709,  2713,  2735,  2714,  2730,  2732,  2743,  2746,
    2749,  2750,   627,   627,  2753,  2770,  2614,  2760,  2773,  1533,
    1534,  2761,  2774,  2775,  1574,  2776,   602,  2782,   602,  2784,
    1535,  2786,  1596,  1596,  2788,  2789,   671,  2790,  2791,  2796,
    2805,   672,    70,  1604,  2806,  2814,    70,    69,  2808,  2815,
    2816,  2762,  2819,  2826,  1536,  2833,  2836,  1537,  2845,  2852,
    2638,  2857,  2863,   673,  2868,  2866,  2877,  2867,  1538,  2878,
    1539,  2898,  2879,  2882,  2891,   674,  2317,  2903,  2904,  2911,
    2317,  2907,  2915,  2922,  2317,   627,  2923,   610,  2752,   675,
    1648,  2933,  2936,  2938,  2945,  2951,  2952,  2935,  2955,  2934,
    2970,  2965,  2971,  2973,  2976,  2977,  2995,  3010,   845,  3011,
    1774,  2099,  2099,  2997,   648,  2438,  2767,  1526,  2335,  1597,
    2336,  2376,  1540,   825,  2136,  2647,  2653,  2077,  2780,  1527,
    2600,  2361,  2679,  2954,  2975,  2939,  1529,  2557,  2558,   775,
    2937,  1530,  2961,   336,  2864,  2913,   336,  1793,  2756,   825,
    1002,  2654,  2124,  3013,  2759,  3000,  2772,  2771,   628,   336,
     776,  2795,  2391,   602,  2982,  1778,  2804,  3014,   797,  1526,
    1573,  1064,  1431,  1852,  2488,  2918,  2459,  2700,   777,  2137,
    2366,   769,   336,  2902,  1541,  2812,  1444,  2988,  1529,  2334,
    3012,  2010,  2130,  1530,  1542,  1543,  1544,   628,  1545,  1546,
    1547,  1548,  1549,  1550,   751,  1409,  2485,  2175,  2344,  2681,
    1625,  1623,  2349,  2228,  2008,   628,  1340,   778,  2561,  2893,
    2646,  1755,  1574,  2533,  1899,  1978,  1340,  2740,  2717,  2302,
    2215,  2754,  2929,  2340,  2701,  2631,  2817,  1531,  2034,  1376,
    1307,  1532,  1251,   610,  1660,  2317,   885,   937,  2033,   857,
    2317,   303,   648,  1634,  2317,  2640,   859,   908,  2023,  1533,
    1534,   602,  2642,  1271,  1245,  1441,  1419,  2185,  2036,  2698,
    1535,  2182,   648,  2585,   648,   648,  2040,  1340,  1563,   879,
    1825,   336,  1845,  1253,  2177,    75,     0,     0,     0,  1531,
       0,     0,     0,  1532,  1536,     0,     0,  1537,     0,     0,
     779,  1340,     0,     0,     0,     0,     0,     0,  1538,     0,
    1539,  1533,  1534,     0,   780,     0,     0,     0,     0,   781,
       0,     0,  1535,     0,     0,     0,   291,     0,     0,     0,
    1887,     0,  1340, -1620,     0,     0,  1340,     0,     0,     0,
       0,     0,     0,   782,  2317,   783,   648,     0,     0,  1537,
    3005,     0,  2464,     0,   784,     0,     0,     0,     0,     0,
    1538,     0,  1540,     0,     0,     0,   785,   786,   602, -1620,
       0,     0,     0,   336,     0,     0,  2726,  2727,  2728,  2729,
       0, -1620,  2921,     0,     0,     0, -1620,     0,  2962,  2963,
       0, -1620, -1620,     0, -1620,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2931,  2932,     0,     0,     0,     0,
       0,     0,     0,     0,  1540, -1620,     0,   648,  2912,     0,
       0,     0,     0,     0,  1541,     0,     0,     0,     0,     0,
       0, -1620,     0,     0,  1542,  1543,  1544,   727,  1545,  1546,
    1547,  1548,  1549,  1550,   602,     0,     0,   728,  1921,  2006,
       0,     0,     0,  1258,   648,    70,     0,    70,     0,     0,
       0,     0,     0, -1620,     0,   729,     0,     0,     0,     0,
    1340, -1620,     0,     0,     0,     0,  1541,     0,     0,     0,
       0,     0,     0,   730,     0,   291,     0, -1623, -1623,     0,
    1545,  1546,  1547,  1548,  1549,  1550,   731,  3004,     0,     0,
       0,  1349,     0,   610,     0,     0,  1248,     0,     0,     0,
       0,     0,     0,   732,     0,     0,     0,     0,   769,   769,
     291,   648,   627,     0,  2091,   648,     0,     0,     0,     0,
       0,   648,   602,     0,   610,   602,   795,     0,     0,   602,
       0,   733,     0,     0,  1349,   734,     0,  2118,   610,   610,
     610,   648,  2065,   648,     0, -1620,     0,   735,     0,     0,
       0,     0,     0,     0,     0,  2078,  2079,   648,  2081,   648,
       0,   648,     0,   610, -1620,   610,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   602,     0,     0,
       0,     0,   937,   937,     0,     0,     0,     0,     0,  2854,
       0,     0,     0,     0,     0,     0,  2120,  1526, -1620, -1620,
   -1620,     0,     0,     0,  1055,     0,     0,     0,     0,  1527,
       0,   736,     0,     0,   610,     0,  1529,   610,     0,     0,
       0,  1530,  1526,     0,     0,     0,     0,  2884,  2142,  1340,
       0,     0,   737,  2153,  1527,     0,     0,     0,     0,     0,
    2162,  1529,     0,     0,     0,   336,  1530,     0,   336,     0,
    2065,   738,   739,     0,     0,     0,     0,   740,  2899,     0,
     628,     0,     0,     0,   648,     0,   648,     0,     0,     0,
       0,     0,     0,     0,  1340,     0,  1340,     0,  2191,   741,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1340,   742,     0,     0,     0,     0,   743,     0,  1579,     0,
       0,     0,     0,     0,     0,   744,     0,     0,     0,     0,
       0,     0,     0,     0,   745,   336,     0,  1531,     0,   336,
       0,  1532,     0,   934,     0,     0,     0,   934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1533,
    1534,     0,  1531,     0,  1340,     0,  1532,     0,     0,     0,
    1535,     0,   934,     0,     0,     0,     0,     0,     0,     0,
       0,  2280,     0,     0,  1533,  1534,     0,     0,     0,     0,
    1887,     0, -1622,     0,  1536,  1535,     0,  1537,     0,     0,
       0,  1258,     0,     0,  1010,     0,  1518,   934,  1538,     0,
    1539,  1349,     0,   934,     0,     0,     0,     0,     0,  1536,
       0,  1349,  1537,  1887,  1519,     0,     0,     0, -1622,     0,
       0,     0,     0,  1538,     0,  1539,     0,     0,     0,     0,
   -1622,     0,     0,     0,     0, -1622,     0,     0,     0,     0,
   -1622, -1622,     0, -1622,     0,     0,     0,     0,     0,  1520,
    1596,     0,  1540,     0,     0,  1604,     0,     0,     0,     0,
       0,     0,  1349,  1521, -1622,     0,   648,     0,     0,  1522,
       0,     0,     0,     0,     0,     0,     0,  1540,     0,     0,
   -1622,     0,  2382,   627,   602,  1161,  1349,   628,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2162,  1258,     0,
       0,     0,     0,   336,     0,  2118,     0,   648,     0,     0,
       0,     0, -1622,     0,  1541,  2415,   602,  1349,     0,     0,
   -1622,  1349,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,
    1547,  1548,  1549,  1550,     0,     0,  2275,     0,   610,  1541,
       0,  1526,     0,     0,     0,  2276,     0,     0,     0,  1542,
    1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,     0,
    1529,     0,     0,     0,  2120,  1530,     0,     0, -1050,     0,
       0,     0,     0,     0,     0,     0,   648,   648,     0,   982,
       0,     0,     0,     0,     0,   795,     0,     0,     0,   983,
     984,   985,     0,   986,   987,   988,   989,   990,   991,     0,
    1340,     0,     0,  2455, -1622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   648,     0,     0,     0,     0,     0,
       0,     0,  1340, -1622,   934,     0,     0,     0,   934,     0,
       0,     0,     0,     0,     0,     0,  2477,     0,     0,     0,
       0,     0,  1353,     0,     0,  1845,     0,     0,     0,     0,
       0,     0,     0,  1340,  2191,  1349,     0, -1622, -1622, -1622,
       0,  1531,     0,     0,     0,  1532,     0,   937,  1341,     0,
       0,   602,     0,     0,     0,   934,     0,     0,     0,     0,
    1887,     0,     0,  1533,  1534,  1353,  1340,     0,     0,     0,
       0,     0,     0,     0,  1535,     0,     0,  1340,     0,     0,
       0,     0,  1340,     0,     0,     0,     0,     0,     0,     0,
       0,  1341,     0,     0,  1340,     0,  1340,     0,  1536,     0,
       0,  1537,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1538,     0,     0,     0,     0,     0,     0,    70,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1340,  1161,     0,     0,  2564,     0,     0,     0,  2564,
    2578,     0,     0,     0,     0,   602,   602,     0,     0,     0,
       0,     0,     0,     0,     0,  1340,  1540,  1161,  1161,     0,
    1161,  1161,  1161,     0,  2118,  2118,  2118,  2118,  2118,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
    2162,  2162,  1340,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1349,     0,     0,   648,   648,     0,
       0,     0,     0,     0,   628,   628,     0,     0,     0,     0,
       0,     0,  1340,     0,     0,   602,     0,     0,  1541,  1581,
       0,     0,     0,  2120,  2120,  2120,  2120,  2120,  1542,  1543,
    1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,     0,  1349,
       0,  1349,     0,   648,     0,     0,  1161,     0,     0,  1161,
    1161,     0,     0,     0,     0,  1349,   336,     0,   336,   336,
       0,  2142,     0,  2078,     0,     0,  2078,     0,  2655,     0,
       0,     0,     0,     0,     0,  2065,     0,   628,     0,     0,
    2162,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2191,     0,     0,
       0,     0,     0,     0,   336,     0,     0,     0,     0,  1349,
       0,   336,  1353,     0,     0,     0,     0,     0,     0,     0,
       0,  1343,  1353,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1341,     0,
       0,     0,     0,   602,     0,     0,     0,     0,  1341,     0,
       0,  1340,     0,     0,     0,     0,     0,     0,   336,     0,
       0,     0,     0,     0,  1343,     0,   602,   602,     0,     0,
       0,   602,     0,  1353,     0,     0,     0,  2564,     0,     0,
    2731,     0,     0,     0,     0,     0,     0,     0,     0,  1526,
       0,     0,     0,     0,  2745,     0,     0,  1353,     0,  1341,
       0,     0,     0,     0,     0,  2006,     0,     0,  1529,  2755,
       0,   648,     0,  1530,     0,     0,   602,   648,     0,     0,
       0,   602,  2763,  1341,     0,   602,  1161,     0,  1353,     0,
       0,     0,  1353,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1341,     0,  1340,     0,  1341,     0,
       0,     0,     0,     0,     0,   934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2802,
    2299,     0,     0,     0,  1574,     0,     0,     0,  1161,  1161,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,  1161,
    1161,     0,     0,     0,     0,     0,     0,     0,     0, -1623,
       0,     0,  1879,  1532,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,  1161,  1161,  1161,     0,  1161,     0,     0,
       0,  1533,  1534,     0,  1161,  1161,     0,     0,     0,     0,
       0,  1161, -1623,     0,     0,     0,     0,     0,  2564,     0,
     648,     0,     0,     0,     0,  1349,     0,     0,     0,     0,
       0,     0,  2142,     0,  2838,     0,  1353,  1161,   336,  1537,
    1161,  1161,     0,     0,     0,  1161,     0,  1349,     0,  1161,
    1538,     0,  1161,  1161,  1161,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1341,     0,     0,  1161,     0,     0,     0,  1161,
    2065,  2078,     0,     0,   596,     0,     0,     0,  1349,     0,
       0,     0,     0,     0,   937,     0,     0,   596,   937,     0,
       0,  1343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1343,     0,  1340, -1623,     0,     0,   602,     0,   336,
     596,  1349,     0,     0,   648,     0,  1526,     0,     0,     0,
       0,     0,  1349,     0,  2838,     0,     0,  1349,  1527,   602,
     602,     0,     0,     0,     0,  1529,     0,     0,     0,  1349,
    1530,  1349,   336,     0,   336,     0,     0,     0,     0,     0,
       0,   648,  1343,     0,     0,     0,     0,     0,     0,     0,
       0,  2802,   937,     0,     0,     0,  1541,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1343,     0,     0,   648,
    1545,  1546,  1547,  1548,  1549,  1550,  1349,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,   937,  1353,     0,  1343,     0,   596,
    1349,  1343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1340,     0,     0,     0,     0,     0,     0,     0,
       0,  1341,     0,  2969,     0,     0,  1531,  1349,   937,     0,
    1532,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1353,  1887,  1353,     0,     0,     0,  1526,     0,  1533,  1534,
       0,     0,     0,     0,  1161,     0,  1353,  1349,     0,  1535,
       0,     0,  2969,     0,     0,  1529,  1341,     0,  1341,     0,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1341,  1536,     0,     0,  1537,     0,  2969,     0,
       0,     0,     0,     0,     0,     0,     0,  1538,     0,  1539,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1353,     0,     0,     0,     0,     0,  1340,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1343,  1341,  2547,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,  1540,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0, -1623,     0,     0,     0,
    1532,     0,  1340,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1533,  1534,
    1161,  1161,  1161,  1161,  1161,     0,  1349,     0,     0, -1623,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
    1161,  1161,  1161,  1541,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,  1542,  1543,  1544,  1537,  1545,  1546,  1547,
    1548,  1549,  1550,     0,  1161,     0,     0,  1538,     0,  1161,
       0,     0,  2897,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1526,
    1161,  1161,     0,  1161,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1529,     0,
       0,     0,     0,  1530,     0,     0,     0,   934,     0,  1161,
    1161, -1623,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1349,     0,     0,  1343,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
    1161,  1161,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,  1343,
    2548,  1343,     0,  1541,     0,     0,  1353,     0,     0,     0,
       0,     0,     0,     0,     0,  1343,     0,  1545,  1546,  1547,
    1548,  1549,  1550,   596,     0,     0,   596,     0,  1353, -1623,
       0,  1526,  1341,  1532,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1527,     0,     0,     0,     0,     0,     0,
    1529,  1533,  1534,     0,  1341,  1530,     0,     0,   336,  1353,
       0,     0, -1623,     0,     0,     0,     0,     0,     0,  1343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1341,     0,     0,     0,  1537,
       0,     0,  1353,   596,     0,     0,     0,   596,     0,     0,
    1538,   932,     0,  1353,     0,   932,     0,     0,  1353,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1341,     0,
    1353,     0,  1353,     0,     0,     0,     0,     0,  1349,  1341,
     932,     0,     0,     0,  1341,     0,   934,     0,  1526,     0,
       0,     0,     0,     0,     0,     0,  1341,     0,  1341,     0,
       0,  1531,     0,     0, -1623,  1532,     0,  1529,  1161,     0,
       0,     0,  1530,     0,  1161,   932,     0,  1353,     0,     0,
       0,   932,     0,  1533,  1534,     0,  1161,     0,  1161,     0,
       0,     0,     0,  1161,  1535,     0,     0,     0,     0,     0,
       0,  1353,  1161,  1341,     0,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,  1161,     0,     0,     0,  1536,  1161,
    1161,  1537,     0,     0,     0,     0,  1541,  1341,  1353,     0,
       0,     0,  1538,  1161,  1539,     0,  1161,     0,     0,  2551,
    1545,  1546,  1547,  1548,  1549,  1550,     0,     0,  1161,  1161,
    1161,     0,  1161,     0,  1341,     0,     0,  1349,  1353,  1161,
       0,     0,     0,  1158,  1161,     0,     0,  1161, -1623,     0,
       0,     0,  1532,     0,     0,     0,   934,     0,     0,     0,
       0,   596,     0,     0,  1341,     0,  1540,     0,     0,     0,
    1533,  1534,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1623,  1161,     0,     0,  1526,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1527,     0,     0,
       0,     0,     0,     0,  1529,  1343,     0,     0,  1537,  1530,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1538,
       0,     0,     0,     0,     0,     0,     0,  1343,  1541,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1542,  1543,
    1544,  1349,  1545,  1546,  1547,  1548,  1549,  1550,     0,     0,
       0,     0,  2258,     0,     0,     0,     0,     0,  1343,     0,
     613,     0,     0,     0,     0,     0,  1161,   613,     0,     0,
       0,     0,     0, -1623,     0,     0,     0,  1353,     0,     0,
       0,     0,   932,     0,     0,     0,   932,     0,     0,     0,
       0,  1343,     0,     0,     0,     0,     0,  1349,     0,     0,
    1352,     0,  1343,  1341,     0,  1531,   613,  1343,     0,  1532,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1343,
       0,  1343,  1161,     0,   613,     0,     0,  1533,  1534,     0,
       0,     0,  1161,   932,     0,  1541,     0,   772,  1535,     0,
       0,  1344,     0,  1352,     0,     0,     0,     0,     0,  1545,
    1546,  1547,  1548,  1549,  1550,   613,     0,   772,     0,     0,
       0,     0,  1536,     0,     0,  1537,  1343,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1538,     0,  1539,     0,
       0,     0,  1353,     0,  1344,     0,  1161,  1161,  1161,     0,
    1343,  1161,     0,     0,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,     0,   934,     0,     0,  1341,   934,
       0,     0,     0,   934,     0,   692,     0,  1343,     0,  1161,
    1158,     0,     0,     0,     0,   693,     0,     0,     0,     0,
    1540,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   694,     0,  1158,  1158,  1343,  1158,  1158,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,   695,
       0,  -390,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,  1161,     0,   696,     0,     0,     0,     0,     0,
     697,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   698,  1541,     0,     0,     0,     0,     0,     0,     0,
       0,   934,  1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,
    1549,  1550,     0,     0,     0,     0,  2399,     0,     0,     0,
       0,   699,     0,   700,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,  -491,     0,  1158,  1158,     0,
       0,     0,  1161,     0,     0,     0,   596,   596,     0,     0,
       0,  1161,     0,  1161,     0,     0,  -327,     0,     0,  1353,
       0,     0,     0,  1161,     0,   701,     0,     0,     0,     0,
       0,     0,     0,     0,   934,     0,     0,     0,     0,   934,
       0,     0,     0,   934,     0,  1341,  1343,     0,     0,  1161,
    1161,     0,   596,  1161,     0,     0,     0,     0,     0,   702,
    1352,   703,     0,     0,  1346,     0,     0,     0,     0,     0,
    1352,     0,     0,     0,   934,     0,     0,     0,     0,     0,
    -327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
     704,  1344,     0,     0,     0,  -238,   596,  1346,     0,     0,
       0,  1344,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,  1352,     0,     0,     0,     0,     0,  -238,   705,  1161,
     706,     0,     0,   934,     0,     0,     0,     0,  1353,   707,
       0,     0,     0,   708,   709,  1352,     0,   710,     0,     0,
       0,  1343,     0,   711,     0,     0,     0,     0,     0,     0,
       0,     0,  1344,     0,  1341,     0,     0,     0,     0,     0,
       0,     0,     0,   934,  1158,     0,  1352,  1161,     0,     0,
    1352,     0,     0,     0,     0,     0,  1344,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   932,     0,     0,     0,  1344,     0,     0,
       0,  1344,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,  1158,     0,   613,
       0,     0,  1353,     0,  1158,     0,     0,  1158,  1158,     0,
       0,     0,     0,     0,     0,     0,     0,  1526,     0,     0,
       0,     0,   934,     0,     0,     0,     0,  1158,  1341,  1527,
       0,  1158,  1158,  1158,     0,  1158,  1529,     0,     0,     0,
       0,  1530,  1158,  1158,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,   934,     0,     0,  1353,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1352,  1158,   596,     0,  1158,  1158,
       0,     0,     0,  1158,  1341,     0,     0,  1158,  1343,     0,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
       0,     0,     0,  1158,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,     0,     0,  1344,     0,     0,     0,     0,
       0,     0,     0,     0,  1346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1346,     0,     0,  1531,     0,     0,
       0,  1532,     0,     0,     0,     0,     0,   596,     0,     0,
       0,     0,   772,     0,   772,     0,   772,     0,     0,  1533,
    1534,     0,   772,   772,     0,     0,     0,     0,     0,     0,
    1535,     0,     0,     0,     0,     0,     0,  1526,     0,     0,
     596,     0,   596,     0,     0,  1346,     0,     0,     0,     0,
       0,     0,     0,     0,  1536,     0,  1529,  1537,     0,     0,
       0,  1530,     0,     0,     0,     0,     0,  1343,  1538,  1346,
    1539,     0,     0,     0,     0,     0,   613,     0,     0,   613,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
    1346,     0,     0,  1352,  1346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1540,     0,     0,     0,  1347,     0,  2723,     0,
       0,     0,     0,     0,  1233,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1344,     0,     0,     0,  1352,     0,
    1352,   613,   613,     0,  1526,     0,     0, -1623,     0,     0,
       0,  1532,  1158,     0,  1352,     0,  1527,     0,  1233,  1347,
       0,  1343,     0,  1529,     0,     0,     0,     0,  1530,  1533,
    1534,     0,     0,     0,  1541,     0,     0,     0,     0,  1344,
   -1623,  1344,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,
    1547,  1548,  1549,  1550,     0,  1344,     0,     0,  2594,     0,
       0,     0,  1526,     0,     0,     0,     0,  1537,  1352,     0,
       0,     0,     0,     0,  1527,     0,     0,  1343,  1538,     0,
     682,  1529,     0,     0,     0,     0,  1530,     0,  1346,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,  1344,
       0,     0,     0,     0,     0,     0,     0,  1158,   682,     0,
       0,     0,     0,     0,  1531,   682,     0,     0,  1532,     0,
       0,     0, -1623,     0,   613,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1533,  1534,  1158,  1158,
    1158,  1158,  1158,     0,     0,   682,   682,  1535,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1158,  1158,  1158,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,  1536,  1531,     0,  1537,     0,  1532,     0,     0,     0,
       0,     0,  1158,     0,  1541,  1538,     0,  1158,     0,     0,
       0,     0,     0,     0,  1533,  1534,     0,  1158,  1545,  1546,
    1547,  1548,  1549,  1550,     0,  1535,     0,     0,  1158,  1158,
       0,  1158,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,   613,     0,     0,     0,     0,     0,  1536,
       0,     0,  1537,     0,   613,   932,     0,  1158,  1158,  1540,
       0,     0,     0,  1538,     0,  1539,     0,  1346,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,   613,   613,     0,  1347,     0,  1158,  1158,
    1158,     0,     0,     0,     0,   613,  1347,     0,  1233,     0,
       0,     0,     0,  1233,  1233,     0,     0,     0,     0,     0,
       0,     0,  1346,  1158,  1346,     0,     0,  1540,     0,     0,
       0,  1541,     0,     0,  1352,     0,     0,     0,  1346,     0,
       0,  1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,
    1550,     0,     0,     0,     0,     0,  1352,  1347,     0,     0,
       0,     0,     0,     0,     0,     0,   613,     0,   613,     0,
       0,     0,     0,     0,     0,  1344,     0,     0,   772,     0,
       0,  1347,     0,     0,     0,     0,   596,  1352,     0,  1541,
       0,     0,  1346,     0,     0,     0,     0,  1344,     0,  1542,
    1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,     0,
       0,     0,  1347,  2708,     0,     0,  1347,     0,     0,     0,
    1352,     0,     0,     0,     0,     0,     0,     0,  1344,     0,
       0,  1352,     0,     0,     0,     0,  1352,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1352,     0,
    1352,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1344,     0,     0,   932,     0,     0,     0,     0,     0,
       0,     0,  1344,     0,     0,     0,     0,  1344,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,  1344,
       0,  1344,  1158,     0,     0,  1352,     0,     0,     0,     0,
       0,     0,     0,   613,  1158,     0,  1158,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,  1352,
    1158,     0,     0,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,     0,     0,     0,  1344,  1158,  1158,     0,
       0,     0,     0,     0,     0,     0,  1352,     0,     0,     0,
    1347,  1158,     0,     0,  1158,     0,     0,     0,     0,     0,
    1344,     0,     0,     0,     0,     0,  1158,  1158,  1158,     0,
    1158,     0,     0,     0,     0,     0,  1352,  1158,     0,     0,
       0,     0,  1158,     0,     0,  1158,     0,  1344,     0,     0,
     772,     0,   772,     0,   932,     0,   772,     0,     0,     0,
       0,   613,   772,     0,     0,     0,     0,     0,     0,   772,
       0,     0,     0,     0,     0,     0,     0,  1344,     0,   772,
    1158,   772,     0,     0,     0,     0,   927,   936,     0,   936,
     927,     0,     0,     0,     0,   682,   682,     0,  1346,     0,
       0,     0,     0,   772,     0,   772,     0,     0,     0,     0,
       0,     0,     0,     0,   682,   927,     0,     0,     0,     0,
    1346,   936,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   936,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   682,
     927,  1346,     0,     0,     0,     0,   927,     0,     0,     0,
       0,     0,     0,     0,  1158,     0,     0,     0,   613,     0,
     936,     0,     0,     0,     0,  1352,     0,     0,     0,  1347,
    1348,     0,     0,     0,  1346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1346,     0,     0,     0,     0,
    1346,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1346,   682,  1346,     0,  1344,     0,     0,   682,
    1158,     0,     0,  1348,  1347,     0,  1347,   682,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,   683,  1233,     0,
    1347,     0,     0,     0,   613,     0,     0,     0,     0,     0,
       0,     0,     0,  1233,     0,   682,     0,     0,     0,  1346,
     682,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   682,     0,     0,   683,     0,     0,     0,     0,
    1352,     0,   683,  1346,  1158,  1158,  1158,     0,     0,  1158,
       0,     0,     0,     0,  1347,  1233,     0,     0,  1233,  1233,
       0,     0,     0,   932,     0,     0,     0,   932,     0,     0,
    1346,   932,   683,   683,     0,     0,     0,  1158,     0,     0,
       0,  1344,     0,     0,     0,   772,     0,     0,     0,     0,
       0,     0,   613,     0,     0,   613,     0,     0,     0,   613,
    1346,     0,     0,     0,     0,     0,     0,   772,     0,     0,
       0,     0,   772,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   772,     0,   936,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,   682,   927,     0,     0,
       0,   927,     0,     0,     0,     0,     0,   613,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   932,
       0,     0,     0,     0,   936,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   682,   682,     0,   936,     0,   927,     0,
     682,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,   936,     0,     0,     0,     0,   772,     0,  1158,
       0,  1158,     0,     0,     0,     0,     0,  1352,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   932,     0,   682,     0,     0,   932,     0,  1346,
    1348,   932,     0,     0,     0,     0,     0,  1158,  1158,     0,
    1348,  1158,     0,     0,     0,     0,     0,     0,  1344,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
    1347,  1348,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,  1347,     0,     0,  1348,     0,  1158,     0,     0,
       0,   932,     0,     0,     0,     0,  1352,     0,     0,     0,
       0,     0,     0,     0,  1346,   772,     0,     0,     0,     0,
       0,  1233,     0,  1347,     0,     0,  1348,     0,     0,     0,
    1348,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   932,     0,     0,     0,  1158,   682,  1344,     0,     0,
       0,     0,     0,     0,     0,     0,  1347,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,  1347,     0,     0,
       0,     0,  1347,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1347,     0,  1347,     0,  1233,     0,
       0,     0,     0,     0,  1233,  1233,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1352,     0,     0,     0,   613,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1233,     0,
     932,  1347,     0,   772,  1139,   772,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2417,   613,     0,     0,     0,
       0,  1344,   682,     0,     0,  1347,     0,     0,     0,     0,
       0,     0,     0,   932,  1348,     0,  1352,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1347,     0,     0,     0,     0,     0,     0,     0,
       0,  1346,     0,   928,   928,     0,   928,   928,     0,     0,
       0,     0,   683,   683,     0,     0,     0,  1344,     0,     0,
       0,     0,  1347,     0,     0,     0,     0,     0,     0,     0,
       0,   683,   928,     0,     0,     0,     0,     0,   928,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   928,
       0,     0,     0,   772,     0,     0,   682,   682,     0,   772,
       0,     0,   936,     0,     0,     0,   683,   928,     0,     0,
       0,     0,     0,   928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   928,   927,     0,
       0,   682,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   682,     0,     0,     0,     0,     0,     0,     0,     0,
     682,   613,     0,     0,     0,     0,     0,     0,     0,     0,
    1346,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     683,     0,     0,     0,     0,     0,   683,     0,     0,     0,
       0,     0,     0,  1348,   683,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1526,     0,     0,
       0,  1347,     0,     0,     0,     0,     0,     0,     0,  1527,
       0,     0,   683,     0,     0,     0,  1529,   683,     0,     0,
       0,  1530,     0,     0,     0,     0,     0,     0,  1348,   683,
    1348,     0,     0,     0,     0,     0,     0,     0,     0,  1454,
       0,     0,     0,     0,  1348,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   613,   613,   682,     0,     0,
       0,  1478,     0,     0,  1346,     0,     0,     0,     0,   772,
       0,     0,     0,     0,   772,   772,   772,   772,   772,     0,
       0,     0,     0,     0,     0,     0,  1504,  1505,     0,  1506,
    1507,  1510,     0,     0,     0,     0,     0,     0,  1348,     0,
       0,     0,     0,     0,     0,     0,  1347,  1525,   682,     0,
       0,     0,     0,     0,     0,     0,     0,  1531,     0,     0,
    1346,  1532,     0,   928,     0,   613,     0,     0,     0,     0,
       0,     0,     0,   683,   928,     0,     0,     0,   928,  1533,
    1534,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1535,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   928,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1536,  1614,     0,  1537,  1620,  1622,
     683,   683,     0,   928,     0,   928,     0,   683,  1538,     0,
    1539,     0,     0,     0,     0,     0,     0,     0,     0,   928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1526,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1527,     0,     0,     0,
       0,   683,     0,  1529,     0,     0,     0,     0,  1530,     0,
       0,     0,  1540,     0,     0,     0,     0,   936,   936,     0,
       0,     0,     0,   613,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   772,     0,     0,     0,   613,   613,     0,     0,
       0,   613,     0,  1347,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   682,     0,     0,
       0,     0,   682,     0,  1541,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,
    1547,  1548,  1549,  1550,     0,     0,   613,     0,  2725,     0,
       0,   613,     0,     0,  1531,   613,     0,     0,  1532,     0,
       0,     0,     0,     0,  1348,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,  1533,  1534,     0,     0,
       0,     0,     0,     0,     0,     0,  1348,  1535,     0,     0,
       0,     0,     0,   683,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1536,     0,     0,  1537,     0,     0,  1348,     0,     0,
       0,     0,  1347,     0,     0,  1538,     0,  1539,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,  1864,
    1348,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1348,     0,     0,     0,     0,  1348,     0,  1883,     0,
       0,  1351,  1888,     0,  1900,     0,  1901,     0,  1348,  1540,
    1348,     0,     0,  1908,  1913,     0,     0,     0,     0,     0,
    1918,     0,     0,     0,     0,     0,     0,     0,     0,   683,
       0,     0,     0,  1526,   682,     0,     0,     0,     0,     0,
    2323,     0,     0,     0,  1351,  1527,  1944,     0,     0,     0,
    1948,     0,  1529,     0,  1959,  1348,  1347,  1530,  1966,     0,
       0,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  1541,     0,     0,  1139,     0,     0,     0,     0,  1348,
       0,  1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,
    1550,     0,     0,     0,     0,  2856,     0,   613,     0,     0,
       0,     0,     0,     0,     0,     0,  1348,     0,     0,     0,
       0,     0,  1347,     0,     0,     0,     0,     0,     0,   613,
     613,     0,     0,   683,   683,     0,  1526,     0,     0,   928,
       0,     0,     0,     0,     0,     0,  1348,     0,  1527,     0,
       0,     0,     0,     0,     0,  1529,     0,     0,     0,     0,
    1530,     0,     0,  1531,     0,   928,     0,  1532,   683,   772,
     772,     0,     0,     0,     0,     0,     0,     0,   683,     0,
       0,     0,     0,     0,     0,  1533,  1534,   683,     0,     0,
       0,     0,     0,     0,     0,     0,  1535,     0,     0,     0,
       0,   682,     0,     0,     0,     0,   930,   682,     0,     0,
     930,     0,     0,     0,     0,     0,  2053,     0,  2453,     0,
    1536,     0,     0,  1537,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1538,   930,  1539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   927,
       0,     0,     0,     0,     0,     0,  1531,     0,     0,     0,
    1532,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     930,     0,     0,     0,     0,     0,   930,     0,  1533,  1534,
       0,     0,   936,  2110,     0,  1348,  1526,     0,  1540,  1535,
       0,     0,     0,     0,   683,     0,     0,     0,  1527,     0,
       0,  1528,     0,     0,     0,  1529,     0,     0,     0,     0,
    1530,  1351,     0,  1536,     0,     0,  1537,     0,     0,     0,
       0,  1698,     0,     0,     0,     0,     0,  1538,     0,  1539,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   683,     0,     0,     0,     0,
    1541,     0,     0,     0,     0,     0,     0,     0,  1155,     0,
    1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,
       0,  1139,  1351,     0,  2916,     0,     0,   682,   682,  2323,
       0,  1540,     0,     0,     0,     0,     0,     0,  2213,     0,
    1348,     0,     0,  1526,     0,     0,  1351,     0,     0,     0,
       0,     0,     0,     0,     0,  1527,  1531,     0,     0,  2014,
    1532,     0,  1529,     0,     0,     0,     0,  1530,     0,     0,
       0,     0,  2239,     0,     0,     0,     0,  1351,  1533,  1534,
       0,  1351,     0,     0,     0,     0,     0,     0,  1913,  1535,
    1913,  1913,     0,  1541,     0,     0,     0,     0,     0,     0,
       0,  2279,     0,  1542,  1543,  1544,     0,  1545,  1546,  1547,
    1548,  1549,  1550,  1536,     0,  2715,  1537,     0,     0,     0,
       0,     0,     0,  2015,     0,   682,     0,  1538,     0,  1539,
       0,     0,     0,     0,   928,   928,     0,     0,     0,     0,
    2301,     0,  2303,     0,     0,   682,  2306,   930,     0,     0,
       0,   930,   682,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1531,     0,  1350,     0,  1532,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1540,     0,     0,   683,  1533,  1534,     0,     0,   683,
       0,     0,  1614,     0,     0,     0,  1535,     0,   930,  1622,
    1622,  1620,     0,     0,     0,     0,     0,     0,  1350,     0,
       0,     0,     0,     0,     0,  1351,     0,  1348,     0,     0,
    1536,     0,     0,  1537,  2360,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1538,     0,  1539,     0,     0,     0,
       0,     0,     0,  1541,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,  1547,
    1548,  1549,  1550,  1155,     0,     0,   682,   682,   682,   682,
       0,  1526,     0,     0,     0,     0,     0,     0,  2323,     0,
       0,     0,  2323,  1527,     0,  1155,  2323,     0,  1540,     0,
    1529,     0,     0,     0,     0,  1530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1155,  1155,     0,  1155,  1155,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2016,
       0,  1155,     0,     0,     0,     0,  1348,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1541,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,
       0,   683,     0,     0,   927,  2259,     0,   683,     0,     0,
    2260,     0,     0,     0,  1698,     0,     0,  2489,     0,     0,
       0,  1531,     0,  2493,     0,  1532,     0,     0,     0,  1155,
       0,     0,  1155,  1155,     0,  2498,     0,  2499,     0,     0,
       0,     0,  2502,  1533,  1534,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1535,     0,     0,     0,     0,  1351,
       0,  1351,     0,     0,     0,     0,     0,     0,  2519,  2520,
    1348,     0,     0,     0,     0,  1351,     0,  2323,  1536,     0,
       0,  1537,  2323,     0,     0,  2531,  2323,     0,     0,     0,
       0,     0,  1538,     0,  1539,  1350,     0,     0,     0,  2539,
       0,  2541,     0,     0,     0,  1350,     0,     0,  2545,     0,
       0,     0,     0,  2549,     0,     0,  2552,   927,     0,   682,
       0,     0,     0,     0,     0,     0,  1348,     0,     0,  1351,
       0,     0,     0,     0,   682,     0,     0,     0,     0,   936,
       0,     0,     0,   936,     0,     0,  1540,     0,     0,     0,
       0,  2589,     0,     0,     0,     0,  1350,   682,   683,     0,
       0,     0,     0,     0,   683,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   928,  2323,     0,     0,     0,
    1350,     0,     0,     0,     0,     0,     0,     0,   682,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   928,     0,  1541,  1155,
       0,  1350,     0,     0,     0,  1350,   927,   936,  1542,  1543,
    1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   928,
       0,     0,     0,     0,     0,     0,     0,     0,   930,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   936,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1155,  1155,     0,     0,     0,     0,     0,     0,  1155,
       0,     0,  1155,  1155,     0,     0,     0,     0,     0,     0,
       0,  1139,     0,   936,     0,     0,     0,     0,     0,     0,
       0,  2704,  1155,     0,     0,   927,  1155,  1155,  1155,     0,
    1155,     0,     0,     0,     0,     0,     0,  1155,  1155,     0,
       0,     0,     0,     0,  1155,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   683,   683,   683,     0,   927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1350,
    1155,     0,     0,  1155,  1155,     0,  2721,  2722,  1155,     0,
    2724,     0,  1155,     0,     0,  1155,  1155,  1155,  1155,  1155,
    1155,  1155,  1155,  1155,  1155,  1698,     0,  1526,  1155,     0,
       0,     0,  1155,     0,     0,     0,     0,     0,     0,  1527,
       0,     0,  2217,     0,     0,     0,  1529,  1351,     0,     0,
       0,  1530,     0,  1526,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1527,     0,     0,     0,     0,
       0,     0,  1529,     0,     0,     0,     0,  1530,  1698,     0,
       0,     0,   683,     0,     0,     0,     0,     0,     0,     0,
       0,  2778,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   683,     0,     0,     0,     0,     0,     0,   683,
       0,  1351,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1351,     0,     0,     0,     0,  1698,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1351,
       0,  1351,     0,     0,     0,     0,     0,  1531,     0,     0,
       0,  1532,     0,     0,     0,     0,     0,     0,     0,     0,
    1155,  1139,     0,     0,     0,     0,     0,     0,  1350,  1533,
    1534,     0,     0,  1531,     0,     0,     0,  1532,     0,     0,
    1535,     0,  2824,     0,     0,     0,  1351,     0,     0,     0,
       0,     0,     0,     0,     0,  1533,  1534,     0,     0,     0,
       0,     0,     0,     0,  1536,     0,  1535,  1537,     0,  2841,
    1351,     0,  2843,  1350,     0,  1350,     0,     0,  1538,     0,
    1539,     0,     0,   683,   683,   683,   683,  1155,     0,  1350,
    1536,     0,     0,  1537,     0,   683,     0,  1351,  1526,   683,
       0,     0,     0,   683,  1538,     0,  1539,     0,     0,     0,
    1527,     0,     0,     0,     0,     0,  2871,  1529,     0,     0,
       0,     0,  1530,     0,     0,     0,     0,  1351,     0,     0,
       0,     0,  1540,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1350,     0,     0,     0,     0,  2890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1540,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   928,  1155,     0,  1541,     0,     0,     0,     0,  2219,
       0,     0,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,
    1547,  1548,  1549,  1550,     0,     0,  2843,     0,  1531,     0,
    1541,     0,  1532,  1155,  1155,  1155,  1155,  1155,     0,     0,
    1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,
    1533,  1534,  1155,  1155,  1155,  1155,     0,     0,     0,     0,
       0,  1535,     0,     0,     0,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,   683,     0,  1351,  1155,     0,   683,
       0,     0,  1155,   683,     0,  1536,     0,     0,  1537,     0,
       0,     0,  1155,     0,     0,     0,     0,     0,     0,  1538,
       0,  1539,     0,  1155,  1155,     0,  1155,     0,     0,     0,
    1155,     0,  2233,     0,   928,     0,   683,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     930,   683,  1155,  1155,     0,     0,   928,     0,     0,     0,
     928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1540,   683,     0,  1155,     0,  1551,     0,
       0,     0,     0,  1155,  1155,  1155,     0,     0,     0,     0,
       0,     0,     0,   683,     0,     0,     0,     0,     0,     0,
       0,  1351,     0,     0,     0,   683,     0,     0,  1155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1350,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   928,   928,  1541,     0,     0,     0,     0,
       0,  1350,     0,     0,     0,  1542,  1543,  1544,     0,  1545,
    1546,  1547,  1548,  1549,  1550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1350,     0,     0,     0,   928,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1350,     0,     0,     0,     0,
     928,     0,     0,     0,     0,     0,  1350,     0,     0,     0,
       0,  1350,   928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1350,     0,  1350,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1526,     0,     0,     0,   930,
       0,     0,     0,     0,     0,   928,     0,  1527,     0,     0,
    2268,     0,     0,     0,  1529,     0,     0,     0,     0,  1530,
       0,  1155,     0,     0,     0,     0,     0,  1155,  1351,     0,
    1350,     0,     0,     0,     0,     0,     0,     0,     0,  1155,
       0,  1155,     0,     0,     0,     0,  1155,     0,     0,     0,
       0,     0,     0,     0,  1350,  1155,     0,     0,  1155,  1155,
    1155,  1155,  1155,  1155,  1155,  1155,  1155,  1155,     0,     0,
       0,     0,  1155,  1155,     0,     0,     0,     0,     0,     0,
    1526,  1350,     0,     0,     0,     0,  1155,     0,     0,  1155,
       0,     0,  1527,     0,     0,     0,     0,     0,     0,  1529,
       0,  1155,  1155,  1155,  1530,  1155,  1526,     0,     0,     0,
       0,  1350,  1155,     0,     0,  1531,     0,  1155,  1527,  1532,
    1155,     0,     0,     0,     0,  1529,     0,     0,     0,   930,
    1530,     0,     0,     0,     0,     0,     0,  1533,  1534,     0,
       0,     0,     0,  1551,     0,     0,     0,  1351,  1535,     0,
       0,     0,     0,     0,     0,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,     0,     0,
       0,     0,  1536,  1894,     0,  1537,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1538,     0,  1539,  2273,
       0,     0,     0,  1551,  1551,  1551,  1551,     0,     0,  1551,
    1531,     0,     0,     0,  1532,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1551,     0,     0,     0,     0,  1894,
       0,     0,  1533,  1534,     0,     0,  1531,     0,     0,     0,
    1532,     0,     0,  1535,     0,     0,     0,     0,     0,  1155,
    1540,     0,     0,     0,     0,     0,     0,     0,  1533,  1534,
    1350,  1351,     0,     0,     0,     0,     0,  1536,     0,  1535,
    1537,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1538,     0,  1539,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1536,     0,     0,  1537,     0,     0,     0,
       0,     0,     0,     0,     0,  1155,     0,  1538,     0,  1539,
       0,     0,  1541,  1551,     0,  1155,     0,  1351,     0,  1551,
       0,  1551,  1542,  1543,  1544,     0,  1545,  1546,  1547,  1548,
    1549,  1550,     0,     0,     0,  1540,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1540,     0,     0,     0,  1350,     0,     0,     0,  1155,
    1155,  1155,     0,     0,  1155,     0,     0,     0,     0,  2492,
       0,     0,     0,     0,     0,     0,     0,     0,   930,     0,
       0,     0,   930,     0,     0,     0,   930,  1541,     0,     0,
       0,     0,  1155,     0,     0,     0,     0,  1542,  1543,  1544,
       0,  1545,  1546,  1547,  1548,  1549,  1550,     0,     0,     0,
       0,     0,     0,  1541,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1542,  1543,  1544,     0,  1545,  1546,  1547,
    1548,  1549,  1550,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   930,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1155,     0,     0,     0,     0,
       0,     0,     0,     0,  1155,     0,  1155,     0,     0,     0,
       0,     0,  1350,     0,     0,     0,  1155,     0,     0,     0,
       0,     0,  1551,     0,     0,     0,     0,   930,     0,     0,
       0,  1551,   930,  1551,     0,     0,   930,     0,     0,     0,
       0,     0,  1155,  1155,     0,     0,  1155,     0,     0,     0,
       0,     0,  1551,     0,     0,     0,     0,  1551,     0,  1894,
    1894,  1894,     0,  1894,  2255,     0,     0,   930,     0,  1551,
    1551,     0,     0,     0,     0,     0,     0,  1551,     0,     0,
       0,     0,  1551,     0,     0,     0,     0,  1551,     0,     0,
    1155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1155,  1551,     0,     0,  2255,  1551,     0,     0,
       0,     0,  1155,     0,     0,     0,   930,     0,  1551,  1894,
       0,  1350,     0,     0,     0,  1551,     0,  1551,  1551,  1551,
    1551,  1551,  1551,  1551,  1551,  1551,  1551,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,   930,     0,     0,     0,
    1155,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     8,     0,     0,     0,
    1155,     9,     0,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
       0,    34,  1551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1350,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   930,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
       0,     0,     0,     0,     0,     0,     0,     0,   930,     0,
       0,  1350,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,     0,    39,     0,     0,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,  2255,  2255,  2255,  1551,  2255,
       0,  1894,     0,     0,  1894,  1894,  1894,  1894,  1894,  1894,
    1894,  1894,  1894,  1894,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,     0,
       0,     0,     0,     0,     0,     0,    42,     0,  1894,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
    1551,     0,  1551,     0,     0,  1551,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,    47,    48,  1551,
      49,     0,    50,     0,     0,     0,    51,     0,    52,    53,
       0,     0,     0,    54,    55,    56,    57,    58,     0,     0,
      59,    60,    61,    62,     0,    63,    64,    65,    66,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,  1894,     0,     0,     7,     8,
       0,     0,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,     0,
       0,     0,  1551,     0,     0,     0,     0,  1551,  1551,     0,
       0,  1551,    35,     0,  2255,     0,     0,     0,  2255,  2255,
    2255,  2255,  2255,  2255,  2255,  2255,  2255,  2255,  1551,  1551,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,  1526,     0,     0,     0,     0,     0,  2255,  1551,     0,
    1551,     0,     0,  1527,  1551,  1894,     0,     0,  1551,     0,
    1529,  1551,     0,     0,     0,  1530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,  1551,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
      40,     0,     0,  2255,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,  1531,     0,     0,     0,  1532,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1533,  1534,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1535,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,  1551,     0,     0,     0,     0,  1536,     0,
    1894,  1537,  1894,     0,     0,     0,     0,     0,     0,  2255,
    1551,  1551,  1538,  1551,  1539,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
      47,    48,     0,    49,     0,     0,  1540,  1551,     0,    51,
       0,    52,    53,     0,     0,     0,    54,    55,    56,    57,
      58,     0,     0,    59,    60,   901,     0,     0,     0,   902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2255,  1894,  2255,
       0,     0,     0,  1551,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1541,     0,
    1551,     0,  1551,     0,     0,     0,     0,     0,  1542,  1543,
    1544,     0,  1545,  1546,  1547,  1548,  1549,  1550,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,     0,   629,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,  2255,   339,     0,    90,  1551,
      92,    93,    94,    95,    96,    97,   630,    98,    99,   100,
     340,   631,   102,     0,   103,   104,   105,   106,   632,   633,
       0,   108,   109,   110,     0,   111,   634,   635,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   128,   362,   363,   364,   130,
     131,   132,   133,     0,   365,   366,   367,     0,   368,   369,
     370,   371,   636,   134,   372,   373,   374,   375,   376,   377,
     138,   378,   379,   380,   381,   382,   383,   384,   385,   141,
     386,   387,   388,   389,   144,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   147,   148,   399,   400,   401,   402,
     403,     0,   404,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   155,   423,     0,   157,   424,   425,   426,   159,   427,
     428,   429,   430,   160,   431,   161,   432,     0,   433,   434,
     435,   436,   437,   438,   439,   164,   440,   441,   442,   165,
     443,   444,   445,   446,   447,   166,   448,   637,   449,   450,
     451,   638,   168,   452,   169,   453,     0,   170,   171,   454,
     172,   455,   456,   457,   458,   459,   173,   460,   174,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   179,   180,   476,   477,   478,   479,
     480,   181,   481,   482,   483,   183,   484,   184,   185,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   186,   187,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,   505,   506,   507,   508,   509,   510,
     190,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   194,   522,   196,   523,   524,   525,   526,   527,
       0,   528,   529,   530,   531,   532,   533,   199,   534,   535,
     201,   536,   202,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,   547,   548,   549,   550,   551,   205,
     206,   552,   553,   554,   555,   207,   556,   208,   557,   558,
     559,   560,   561,   639,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   215,   573,   216,   574,   575,
       0,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,     0,     0,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
      89,    90,     0,    92,    93,    94,    95,    96,    97,   640,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110,     0,   111,   112,
     113,     0,   341,   342,     0,     0,     0,   116,   117,     0,
       0,     0,     0,   118,     0,     0,     0,     0,     0,     0,
       0,     0,   119,     0,   120,     0,   121,     0,     0,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   128,   362,
     363,   364,   130,   131,   132,   133,     0,   365,   366,   367,
       0,   368,   369,   370,   371,     0,   134,   372,   373,   374,
     375,   376,   377,   138,   378,   379,   380,   381,   382,   383,
     384,   385,   141,   386,   387,   388,   389,   144,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   147,   148,   399,
     400,   401,   402,   403,     0,   404,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   155,   423,     0,   157,   424,   425,
     426,   159,   427,   428,   429,   430,   160,   431,   161,   432,
       0,   433,   434,   435,   436,   437,   438,   439,   164,   440,
     441,   442,   165,   443,   444,   445,   446,   447,   166,   448,
       0,   449,   450,   451,     0,   168,   452,   169,   453,     0,
     170,   171,   454,   172,   455,   456,   457,   458,   459,   173,
     460,   174,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   179,   180,   476,
     477,   478,   479,   480,   181,   481,   482,   483,   183,   484,
     184,   185,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   186,   187,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,   505,   506,   507,
     508,   509,   510,   190,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,   196,   523,   524,
     525,   526,   527,     0,   528,   529,   530,   531,   532,   533,
     199,   534,   535,   201,   536,   202,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,   547,   548,   549,
     550,   551,   205,   206,   552,   553,   554,   555,   207,   556,
     208,   557,   558,   559,   560,   561,   211,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   215,   573,
     216,   574,   575,     0,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,     0,     0,     0,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,    89,    90,     0,    92,    93,    94,
      95,    96,    97,  2026,    98,    99,   100,   340,     0,   102,
       0,   103,   104,   105,   106,     0,   107,     0,   108,   109,
     110,     0,   111,   112,   113,     0,   341,   342,     0,     0,
       0,   116,   117,     0,     0,     0,     0,   118,     0,     0,
       0,     0,     0,     0,     0,     0,   119,     0,   120,     0,
     121,     0,     0,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   128,   362,   363,   364,   130,   131,   132,   133,
       0,   365,   366,   367,     0,   368,   369,   370,   371,     0,
     134,   372,   373,   374,   375,   376,   377,   138,   378,   379,
     380,   381,   382,   383,   384,   385,   141,   386,   387,   388,
     389,   144,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   147,   148,   399,   400,   401,   402,   403,     0,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   155,   423,
       0,   157,   424,   425,   426,   159,   427,   428,   429,   430,
     160,   431,   161,   432,     0,   433,   434,   435,   436,   437,
     438,   439,   164,   440,   441,   442,   165,   443,   444,   445,
     446,   447,   166,   448,     0,   449,   450,   451,     0,   168,
     452,   169,   453,     0,   170,   171,   454,   172,   455,   456,
     457,   458,   459,   173,   460,   174,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   179,   180,   476,   477,   478,   479,   480,   181,   481,
     482,   483,   183,   484,   184,   185,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   186,   187,
       0,   497,   498,   499,   500,   501,     0,   188,   502,   503,
     504,   505,   506,   507,   508,   509,   510,   190,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   194,
     522,   196,   523,   524,   525,   526,   527,     0,   528,   529,
     530,   531,   532,   533,   199,   534,   535,   201,   536,   202,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   204,
     546,   547,   548,   549,   550,   551,   205,   206,   552,   553,
     554,   555,   207,   556,   208,   557,   558,   559,   560,   561,
     211,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   215,   573,   216,   574,   575,     0,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   217,     0,     0,
     218,    77,     0,     0,    78,    79,    80,    81,     0,    82,
      83,     0,    84,    85,    86,    87,     0,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,  2028,    98,    99,
     100,   101,     0,   102,     0,   103,   104,   105,   106,     0,
     107,     0,   108,   109,   110,     0,   111,   112,   113,     0,
     114,   115,     0,     0,     0,   116,   117,     0,     0,     0,
       0,   118,     0,     0,     0,     0,     0,     0,     0,     0,
     119,     0,   120,     0,   121,   122,     0,   123,     0,     0,
       0,     0,     0,     0,     0,   124,   125,   126,     0,     0,
       0,     0,     0,     0,     0,   127,   128,     0,     0,   129,
     130,   131,   132,   133,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   134,     0,     0,   135,     0,   136,
     137,   138,     0,     0,   139,   140,     0,     0,     0,     0,
     141,   142,   143,     0,     0,   144,     0,     0,     0,     0,
       0,     0,   145,     0,   146,   147,   148,   149,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,     0,
     151,   152,     0,     0,     0,     0,   153,     0,     0,     0,
       0,   154,   155,   156,     0,   157,     0,   158,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     165,     0,     0,     0,     0,     0,   166,     0,     0,     0,
     167,     0,     0,   168,     0,   169,     0,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   173,     0,   174,
       0,   175,   176,     0,     0,   177,     0,     0,     0,     0,
       0,     0,   178,     0,     0,   179,   180,     0,     0,     0,
       0,     0,   181,     0,     0,   182,   183,     0,   184,   185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,     0,     0,
       0,   188,     0,     0,   189,     0,     0,     0,     0,     0,
       0,   190,     0,     0,   191,     0,     0,     0,   192,     0,
       0,     0,   193,   194,   195,   196,     0,     0,     0,     0,
       0,     0,   197,     0,     0,     0,     0,   198,   199,     0,
     200,   201,     0,   202,     0,     0,   203,     0,    77,     0,
       0,     0,     0,   204,    81,     0,     0,     0,     0,     0,
     205,   206,    87,     0,    88,     0,   207,    91,   208,     0,
     209,     0,   210,     0,   211,     0,     0,   212,   101,   213,
       0,     0,     0,   214,     0,     0,   215,     0,   216,     0,
       0,     0,     0,     0,     0,     0,     0,   114,   115,     0,
       0,   217,     0,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   123,     0,   219,     0,     0,     0,
       0,     0,   124,   125,   126,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   844,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,   136,   137,     0,     0,
       0,   139,   140,     0,     0,     0,     0,     0,   142,   143,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   145,
       0,   146,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,   153,     0,     0,     0,     0,   154,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   175,   176,
       0,     0,   177,     0,     0,     0,     0,     0,     0,   178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   191,     0,     0,     0,   192,     0,     0,     0,   193,
       0,   195,     0,     0,     0,     0,     0,     0,     0,   197,
       0,     0,     0,     0,   198,     0,     0,   200,     0,     0,
       0,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,   210,
       0,     0,     0,     0,   212,     0,   213,     0,     0,     0,
     214,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,   219,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,  1989,   351,     0,     0,     0,     0,  1066,     0,
       0,   359,   360,   361,   128,   362,   363,   364,   130,  1067,
     132,  1068,  1069,     0,   366,   367,     0,   368,  1070,  1071,
     371,  1072,  1073,   372,     0,   374,   375,   376,   377,  1074,
       0,     0,   380,   381,   382,     0,   384,   385,  1075,   386,
       0,   388,   389,   144,  1076,  1077,  1078,  1079,   394,   395,
     396,   397,   398,  1080,  1081,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,  1990,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
    1083,   423,     0,  1084,  1085,   425,   426,  1086,     0,   428,
       0,   430,   160,     0,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
    1087,  1088,     0,  1089,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,     0,   173,   460,   174,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,   179,  1091,   680,   477,   478,   479,   480,
     181,  1092,   482,   483,   183,  1093,  1094,  1095,   485,     0,
       0,   488,   681,     0,     0,  1096,   493,     0,     0,   496,
     186,   187,  1097,   497,   498,   499,   500,   501,     0,  1098,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1099,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,  1100,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,  1101,   533,   199,   534,   535,   201,
     536,  1102,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1103,   546,     0,   548,   549,   550,     0,  1104,  1105,
       0,   553,     0,   555,  1106,   556,  1107,  1108,   558,   559,
     560,   561,     0,  1109,   563,   564,   565,   566,   567,  1110,
       0,   570,   571,   572,  1111,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
      48,  1112,   218,  1113,     0,     0,  1114,  1115,    51,  1116,
      52,     0,     0,     0,     0,  1117,  1118,  1991,     0,  1120,
    1121,     0,     0,     0,  1122,  1992,   629,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
     630,    98,    99,   100,   340,   631,   102,     0,   103,   104,
     105,   106,   632,   633,     0,   108,   109,   110,     0,   111,
     634,   635,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,  1066,     0,     0,   359,   360,   361,   128,
     362,   363,   364,   130,  1067,   132,  1068,  1069,     0,   366,
     367,     0,   368,  1070,  1071,   371,  1072,  1073,   372,     0,
     374,   375,   376,   377,  1074,     0,     0,   380,   381,   382,
       0,   384,   385,  1075,   386,     0,   388,   389,   144,  1076,
    1077,  1078,  1079,   394,   395,   396,   397,   398,  1080,  1081,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,  1082,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,  1083,   423,     0,  1084,  1085,
     425,   426,  1086,     0,   428,     0,   430,   160,     0,   161,
     432,     0,   433,     0,     0,   436,     0,   438,   439,   164,
     440,   441,   442,   165,   443,   444,   445,   446,     0,   166,
     448,     0,   449,   450,   451,  1087,  1088,     0,  1089,     0,
       0,   170,   171,   454,   172,   455,   456,   457,   458,     0,
     173,   460,   174,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,  1090,   179,  1091,
     680,   477,   478,   479,   480,   181,  1092,   482,   483,   183,
    1093,  1094,  1095,   485,     0,     0,   488,   681,     0,     0,
    1096,   493,     0,     0,   496,   186,   187,  1097,   497,   498,
     499,   500,   501,     0,  1098,   502,   503,   504,     0,   506,
     507,   508,   509,   510,  1099,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   194,   522,  1100,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,  1101,
     533,   199,   534,   535,   201,   536,  1102,     0,   538,   539,
     540,   541,   542,   543,   544,   545,  1103,   546,     0,   548,
     549,   550,     0,  1104,  1105,     0,   553,     0,   555,  1106,
     556,  1107,  1108,   558,   559,   560,   561,     0,  1109,   563,
     564,   565,   566,   567,  1110,     0,   570,   571,   572,  1111,
     573,   216,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,    48,  1112,   218,  1113,     0,
       0,  1114,  1115,    51,  1116,    52,     0,     0,     0,     0,
    1117,  1118,     0,     0,  1120,  1121,     0,     0,     0,  1122,
    1898,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,     0,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,  1066,     0,
       0,   359,   360,   361,   128,   362,   363,   364,   130,  1067,
     132,  1068,  1069,     0,   366,   367,     0,   368,  1070,  1071,
     371,  1072,  1073,   372,     0,   374,   375,   376,   377,  1074,
       0,     0,   380,   381,   382,     0,   384,   385,  1075,   386,
       0,   388,   389,   144,  1076,  1077,  1078,  1079,   394,   395,
     396,   397,   398,  1080,  1081,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
    1083,   423,     0,  1084,  1085,   425,   426,  1086,     0,   428,
       0,   430,   160,     0,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
    1087,  1088,     0,  1089,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,     0,   173,   460,   174,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,   179,  1091,   680,   477,   478,   479,   480,
     181,  1092,   482,   483,   183,  1093,  1094,  1095,   485,     0,
       0,   488,   681,     0,     0,  1096,   493,     0,     0,   496,
     186,   187,  1097,   497,   498,   499,   500,   501,     0,  1098,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1099,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,  1100,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,  1101,   533,   199,   534,   535,   201,
     536,  1102,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1103,   546,     0,   548,   549,   550,     0,  1104,  1105,
       0,   553,     0,   555,  1106,   556,  1107,  1108,   558,   559,
     560,   561,     0,  1109,   563,   564,   565,   566,   567,  1110,
       0,   570,   571,   572,  1111,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
      48,  1112,   218,  1113,     0,     0,  1114,  1115,    51,  1116,
      52,     0,     0,     0,     0,  1117,  1118,     0,     0,  1120,
    1121,     0,     0,     0,  1122,  2747,   629,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
     630,    98,    99,   100,   340,   631,   102,     0,   103,   104,
     105,   106,   632,   633,     0,   108,   109,   110,     0,   111,
     634,   635,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,  1321,     0,  1322,  1069,     0,   366,
     367,     0,   368,     0,     0,   371,  1323,  1324,   372,     0,
     374,   375,   376,   377,     0,     0,     0,   380,   381,   382,
       0,   384,   385,     0,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,  1325,  1326,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,  1082,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,     0,   423,     0,     0,     0,
     425,   426,  1327,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,  1689,   443,   444,   445,   446,     0,     0,
    1690,     0,   449,   450,   451,  1087,  1328,     0,  1329,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,  1090,     0,  1330,
       0,   477,   478,   479,   480,     0,     0,   482,   483,     0,
       0,     0,  1331,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,  1691,     0,     0,     0,   497,   498,
     499,   500,   501,     0,     0,   502,   503,   504,     0,   506,
     507,   508,   509,   510,  1332,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,     0,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,  1333,   534,   535,     0,   536,  1334,     0,   538,   539,
     540,   541,   542,   543,   544,   545,     0,   546,     0,   548,
     549,   550,     0,  1335,  1336,     0,   553,     0,   555,     0,
     556,     0,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,  1337,
     573,     4,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     5,   218,     0,     0,
       0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     8,     0,
    1692,     0,     0,     0,     0,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,     0,    34,     0,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     7,     8,     0,     0,     0,     0,     0,     0,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,     0,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,    39,     0,     0,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,    47,
      48,     0,    49,    42,     0,     0,     0,     0,    51,     0,
      52,    53,     0,     0,     0,    54,    55,    56,    57,    58,
       0,     0,    59,    60,   901,  1252,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,    47,    48,     0,    49,     0,     0,
       0,     0,     0,    51,     0,    52,    53,     0,     0,     0,
      54,    55,    56,    57,    58,     0,     0,    59,    60,   901,
    1661,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,     0,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,  1066,     0,
       0,   359,   360,   361,   128,   362,   363,   364,   130,  1067,
     132,  1068,  1069,  1909,   366,   367,     0,   368,  1070,  1071,
     371,  1072,  1073,   372,     0,   374,   375,   376,   377,  1074,
       0,     0,   380,   381,   382,     0,   384,   385,  1075,   386,
       0,   388,   389,   144,  1076,  1077,  1078,  1079,   394,   395,
     396,   397,   398,  1080,  1081,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
    1083,   423,     0,  1084,  1085,   425,   426,  1086,     0,   428,
       0,   430,   160,  1910,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
    1087,  1088,     0,  1089,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,  1911,   173,   460,   174,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,   179,  1091,   680,   477,   478,   479,   480,
     181,  1092,   482,   483,   183,  1093,  1094,  1095,   485,     0,
       0,   488,   681,     0,     0,  1096,   493,     0,     0,   496,
     186,   187,  1097,   497,   498,   499,   500,   501,     0,  1098,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1099,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,  1100,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,  1101,   533,   199,   534,   535,   201,
     536,  1102,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1103,   546,     0,   548,   549,   550,     0,  1104,  1105,
       0,   553,  1912,   555,  1106,   556,  1107,  1108,   558,   559,
     560,   561,     0,  1109,   563,   564,   565,   566,   567,  1110,
       0,   570,   571,   572,  1111,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
      48,  1112,   218,  1113,     0,     0,  1114,  1115,    51,  1116,
      52,     0,     0,     0,     0,  1117,  1118,     0,     0,  1120,
    1121,     0,     0,     0,  1122,   629,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,   630,
      98,    99,   100,   340,   631,   102,     0,   103,   104,   105,
     106,   632,   633,     0,   108,   109,   110,     0,   111,   634,
     635,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,  1066,     0,     0,   359,   360,   361,   128,   362,
     363,   364,   130,  1067,   132,  1068,  1069,     0,   366,   367,
       0,   368,  1070,  1071,   371,  1072,  1073,   372,     0,   374,
     375,   376,   377,  1074,     0,     0,   380,   381,   382,     0,
     384,   385,  1075,   386,     0,   388,   389,   144,  1076,  1077,
    1078,  1079,   394,   395,   396,   397,   398,  1080,  1081,   399,
    2192,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,  1082,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,  1083,   423,     0,  1084,  1085,   425,
     426,  1086,     0,   428,     0,   430,   160,     0,   161,   432,
       0,   433,     0,     0,   436,     0,   438,   439,   164,   440,
     441,   442,   165,   443,   444,   445,   446,     0,   166,   448,
       0,   449,   450,   451,  1087,  1088,     0,  1089,     0,     0,
     170,   171,   454,   172,   455,   456,   457,   458,     0,   173,
     460,   174,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,  1090,   179,  1091,   680,
     477,   478,   479,   480,   181,  1092,   482,   483,   183,  1093,
    1094,  1095,   485,     0,     0,   488,   681,     0,     0,  1096,
     493,     0,     0,   496,   186,   187,  1097,   497,   498,   499,
     500,   501,     0,  1098,   502,   503,   504,     0,   506,   507,
     508,   509,   510,  1099,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,  1100,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,  1101,   533,
     199,   534,   535,   201,   536,  1102,     0,   538,   539,   540,
     541,   542,   543,   544,   545,  1103,   546,     0,   548,   549,
     550,     0,  1104,  1105,     0,   553,     0,   555,  1106,   556,
    1107,  1108,   558,   559,   560,   561,     0,  1109,   563,   564,
     565,   566,   567,  1110,     0,   570,   571,   572,  1111,   573,
     216,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,    48,  1112,   218,  1113,     0,     0,
    1114,  1115,    51,  1116,    52,     0,     0,     0,     0,  1117,
    1118,  1119,     0,  1120,  1121,     0,     0,     0,  1122,   629,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,   630,    98,    99,   100,   340,   631,   102,
       0,   103,   104,   105,   106,   632,   633,     0,   108,   109,
     110,     0,   111,   634,   635,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
       0,   351,     0,     0,     0,     0,  1066,     0,     0,   359,
     360,   361,   128,   362,   363,   364,   130,  1067,   132,  1068,
    1069,     0,   366,   367,     0,   368,  1070,  1071,   371,  1072,
    1073,   372,     0,   374,   375,   376,   377,  1074,     0,     0,
     380,   381,   382,     0,   384,   385,  1075,   386,     0,   388,
     389,   144,  1076,  1077,  1078,  1079,   394,   395,   396,   397,
     398,  1080,  1081,   399,     0,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,  1082,   412,   413,     0,
     415,   416,     0,   418,     0,   420,   421,   422,  1083,   423,
       0,  1084,  1085,   425,   426,  1086,     0,   428,     0,   430,
     160,     0,   161,   432,     0,   433,     0,     0,   436,     0,
     438,   439,   164,   440,   441,   442,   165,   443,   444,   445,
     446,     0,   166,   448,     0,   449,   450,   451,  1087,  1088,
       0,  1089,     0,     0,   170,   171,   454,   172,   455,   456,
     457,   458,     0,   173,   460,   174,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
    1090,   179,  1091,   680,   477,   478,   479,   480,   181,  1092,
     482,   483,   183,  1093,  1094,  1095,   485,     0,     0,   488,
     681,     0,     0,  1096,   493,     0,     0,   496,   186,   187,
    1097,   497,   498,   499,   500,   501,     0,  1098,   502,   503,
     504,     0,   506,   507,   508,   509,   510,  1099,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   194,
     522,  1100,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,  1101,   533,   199,   534,   535,   201,   536,  1102,
       0,   538,   539,   540,   541,   542,   543,   544,   545,  1103,
     546,     0,   548,   549,   550,     0,  1104,  1105,     0,   553,
       0,   555,  1106,   556,  1107,  1108,   558,   559,   560,   561,
       0,  1109,   563,   564,   565,   566,   567,  1110,     0,   570,
     571,   572,  1111,   573,   216,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,    48,  1112,
     218,  1113,     0,     0,  1114,  1115,    51,  1116,    52,     0,
       0,     0,     0,  1117,  1118,  1119,     0,  1120,  1121,     0,
       0,     0,  1122,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
    1066,     0,     0,   359,   360,   361,   128,   362,   363,   364,
     130,  1067,   132,  1068,  1069,     0,   366,   367,     0,   368,
    1070,  1071,   371,  1072,  1073,   372,     0,   374,   375,   376,
     377,  1074,     0,     0,   380,   381,   382,     0,   384,   385,
    1075,   386,     0,   388,   389,   144,  1076,  1077,  1078,  1079,
     394,   395,   396,   397,   398,  1080,  1081,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,  1083,   423,     0,  1084,  1085,   425,   426,  1086,
       0,   428,     0,   430,   160,     0,   161,   432,     0,   433,
       0,     0,   436,     0,   438,   439,   164,   440,   441,   442,
     165,   443,   444,   445,   446,     0,   166,   448,     0,   449,
     450,   451,  1087,  1088,     0,  1089,     0,     0,   170,   171,
     454,   172,   455,   456,   457,   458,     0,   173,   460,   174,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,   179,  1091,   680,   477,   478,
     479,   480,   181,  1092,   482,   483,   183,  1093,  1094,  1095,
     485,     0,     0,   488,   681,     0,     0,  1096,   493,     0,
       0,   496,   186,   187,  1097,   497,   498,   499,   500,   501,
       0,  1098,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1099,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   194,   522,  1100,   523,   524,   525,   526,
     527,     0,   197,   529,   530,   531,  1101,   533,   199,   534,
     535,   201,   536,  1102,     0,   538,   539,   540,   541,   542,
     543,   544,   545,  1103,   546,     0,   548,   549,   550,     0,
    1104,  1105,     0,   553,     0,   555,  1106,   556,  1107,  1108,
     558,   559,   560,   561,     0,  1109,   563,   564,   565,   566,
     567,  1110,     0,   570,   571,   572,  1111,   573,   216,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,    48,  1112,   218,  1113,     0,     0,  1114,  1115,
      51,  1116,    52,     0,     0,     0,     0,  1117,  1118,     0,
       0,  1120,  1121,     0,     0,     0,  1122,   629,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,   630,    98,    99,   100,   340,   631,   102,     0,   103,
     104,   105,   106,   632,   633,     0,   108,   109,   110,     0,
     111,   634,   635,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,  1618,   351,
       0,     0,     0,     0,  1066,     0,     0,   359,   360,   361,
     128,   362,   363,   364,   130,  1067,   132,  1068,  1069,     0,
     366,   367,     0,   368,  1070,  1071,   371,  1072,  1073,   372,
       0,   374,   375,   376,   377,  1074,     0,     0,   380,   381,
     382,     0,   384,   385,  1075,   386,     0,   388,   389,   144,
    1076,  1077,  1078,  1079,   394,   395,   396,   397,   398,  1080,
    1081,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,  1082,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,  1083,   423,     0,  1084,
    1085,   425,   426,  1086,     0,   428,     0,   430,   160,     0,
     161,   432,     0,   433,     0,     0,   436,     0,   438,   439,
     164,   440,   441,   442,   165,   443,   444,   445,   446,     0,
     166,   448,     0,   449,   450,   451,  1087,  1088,     0,  1089,
       0,     0,   170,   171,   454,   172,   455,   456,   457,   458,
       0,   173,   460,   174,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,  1090,   179,
    1091,   680,   477,   478,   479,   480,   181,  1092,   482,   483,
     183,  1093,  1094,  1095,   485,     0,     0,   488,   681,     0,
       0,  1096,   493,     0,     0,   496,   186,   187,  1097,   497,
     498,   499,   500,   501,     0,  1098,   502,   503,   504,     0,
     506,   507,   508,   509,   510,  1099,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   194,   522,  1100,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
    1101,   533,   199,   534,   535,   201,   536,  1102,     0,   538,
     539,   540,   541,   542,   543,   544,   545,  1103,   546,     0,
     548,   549,   550,     0,  1104,  1105,     0,   553,     0,   555,
    1106,   556,  1107,  1108,   558,   559,   560,   561,     0,  1109,
     563,   564,   565,   566,   567,  1110,     0,   570,   571,   572,
    1111,   573,   216,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,    48,  1112,   218,  1113,
       0,     0,  1114,  1115,    51,  1116,    52,     0,     0,     0,
       0,  1117,  1118,     0,     0,  1120,  1121,     0,     0,     0,
    1122,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,     0,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,  1066,     0,
       0,   359,   360,   361,   128,   362,   363,   364,   130,  1067,
     132,  1068,  1069,     0,   366,   367,     0,   368,  1070,  1071,
     371,  1072,  1073,   372,     0,   374,   375,   376,   377,  1074,
       0,     0,   380,   381,   382,     0,   384,   385,  1075,   386,
       0,   388,   389,   144,  1076,  1077,  1078,  1079,   394,   395,
     396,   397,   398,  1080,  1081,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
    1083,   423,     0,  1084,  1085,   425,   426,  1086,     0,   428,
       0,   430,   160,     0,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
    1087,  1088,     0,  1089,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,     0,   173,   460,   174,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,   179,  1091,   680,   477,   478,   479,   480,
     181,  1092,   482,   483,   183,  1093,  1094,  1095,   485,     0,
       0,   488,   681,     0,     0,  1096,   493,     0,     0,   496,
     186,   187,  1097,   497,   498,   499,   500,   501,     0,  1098,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1099,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,  1100,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,  1101,   533,   199,   534,   535,   201,
     536,  1102,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1103,   546,     0,   548,   549,   550,     0,  1104,  1105,
       0,   553,     0,   555,  1106,   556,  1107,  1108,   558,   559,
     560,   561,     0,  1109,   563,   564,   565,   566,   567,  1110,
       0,   570,   571,   572,  1111,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
      48,  1112,   218,  1113,     0,     0,  1114,  1115,    51,  1116,
      52,     0,     0,     0,     0,  1117,  1118,     0,     0,  1120,
    1121,     0,  1449,     0,  1122,   629,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,   630,
      98,    99,   100,   340,   631,   102,     0,   103,   104,   105,
     106,   632,   633,     0,   108,   109,   110,     0,   111,   634,
     635,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,  1066,     0,     0,   359,   360,   361,   128,   362,
     363,   364,   130,  1067,   132,  1068,  1069,     0,   366,   367,
       0,   368,  1070,  1071,   371,  1072,  1073,   372,     0,   374,
     375,   376,   377,  1074,     0,     0,   380,   381,   382,     0,
     384,   385,  1075,   386,     0,   388,   389,   144,  1076,  1077,
    1078,  1079,   394,   395,   396,   397,   398,  1080,  1081,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,  1082,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,  1083,   423,     0,  1084,  1085,   425,
     426,  1086,     0,   428,     0,   430,   160,  1910,   161,   432,
       0,   433,     0,     0,   436,     0,   438,   439,   164,   440,
     441,   442,   165,   443,   444,   445,   446,     0,   166,   448,
       0,   449,   450,   451,  1087,  1088,     0,  1089,     0,     0,
     170,   171,   454,   172,   455,   456,   457,   458,     0,   173,
     460,   174,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,  1090,   179,  1091,   680,
     477,   478,   479,   480,   181,  1092,   482,   483,   183,  1093,
    1094,  1095,   485,     0,     0,   488,   681,     0,     0,  1096,
     493,     0,     0,   496,   186,   187,  1097,   497,   498,   499,
     500,   501,     0,  1098,   502,   503,   504,     0,   506,   507,
     508,   509,   510,  1099,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,  1100,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,  1101,   533,
     199,   534,   535,   201,   536,  1102,     0,   538,   539,   540,
     541,   542,   543,   544,   545,  1103,   546,     0,   548,   549,
     550,     0,  1104,  1105,     0,   553,     0,   555,  1106,   556,
    1107,  1108,   558,   559,   560,   561,     0,  1109,   563,   564,
     565,   566,   567,  1110,     0,   570,   571,   572,  1111,   573,
     216,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,    48,  1112,   218,  1113,     0,     0,
    1114,  1115,    51,  1116,    52,     0,     0,     0,     0,  1117,
    1118,     0,     0,  1120,  1121,     0,     0,     0,  1122,   629,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,   630,    98,    99,   100,   340,   631,   102,
       0,   103,   104,   105,   106,   632,   633,     0,   108,   109,
     110,     0,   111,   634,   635,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
       0,   351,     0,     0,     0,     0,  1066,     0,     0,   359,
     360,   361,   128,   362,   363,   364,   130,  1067,   132,  1068,
    1069,     0,   366,   367,     0,   368,  1070,  1071,   371,  1072,
    1073,   372,     0,   374,   375,   376,   377,  1074,     0,     0,
     380,   381,   382,     0,   384,   385,  1075,   386,     0,   388,
     389,   144,  1076,  1077,  1078,  1079,   394,   395,   396,   397,
     398,  1080,  1081,   399,  2588,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,  1082,   412,   413,     0,
     415,   416,     0,   418,     0,   420,   421,   422,  1083,   423,
       0,  1084,  1085,   425,   426,  1086,     0,   428,     0,   430,
     160,     0,   161,   432,     0,   433,     0,     0,   436,     0,
     438,   439,   164,   440,   441,   442,   165,   443,   444,   445,
     446,     0,   166,   448,     0,   449,   450,   451,  1087,  1088,
       0,  1089,     0,     0,   170,   171,   454,   172,   455,   456,
     457,   458,     0,   173,   460,   174,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
    1090,   179,  1091,   680,   477,   478,   479,   480,   181,  1092,
     482,   483,   183,  1093,  1094,  1095,   485,     0,     0,   488,
     681,     0,     0,  1096,   493,     0,     0,   496,   186,   187,
    1097,   497,   498,   499,   500,   501,     0,  1098,   502,   503,
     504,     0,   506,   507,   508,   509,   510,  1099,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   194,
     522,  1100,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,  1101,   533,   199,   534,   535,   201,   536,  1102,
       0,   538,   539,   540,   541,   542,   543,   544,   545,  1103,
     546,     0,   548,   549,   550,     0,  1104,  1105,     0,   553,
       0,   555,  1106,   556,  1107,  1108,   558,   559,   560,   561,
       0,  1109,   563,   564,   565,   566,   567,  1110,     0,   570,
     571,   572,  1111,   573,   216,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,    48,  1112,
     218,  1113,     0,     0,  1114,  1115,    51,  1116,    52,     0,
       0,     0,     0,  1117,  1118,     0,     0,  1120,  1121,     0,
       0,     0,  1122,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
    1066,     0,     0,   359,   360,   361,   128,   362,   363,   364,
     130,  1067,   132,  1068,  1069,     0,   366,   367,     0,   368,
    1070,  1071,   371,  1072,  1073,   372,     0,   374,   375,   376,
     377,  1074,     0,     0,   380,   381,   382,     0,   384,   385,
    1075,   386,     0,   388,   389,   144,  1076,  1077,  1078,  1079,
     394,   395,   396,   397,   398,  1080,  1081,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,  1083,   423,     0,  1084,  1085,   425,   426,  1086,
       0,   428,     0,   430,   160,     0,   161,   432,     0,   433,
       0,     0,   436,     0,   438,   439,   164,   440,   441,   442,
     165,   443,   444,   445,   446,     0,   166,   448,     0,   449,
     450,   451,  1087,  1088,     0,  1089,     0,     0,   170,   171,
     454,   172,   455,   456,   457,   458,     0,   173,   460,   174,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,   179,  1091,   680,   477,   478,
     479,   480,   181,  1092,   482,   483,   183,  1093,  1094,  1095,
     485,     0,     0,   488,   681,     0,     0,  1096,   493,     0,
       0,   496,   186,   187,  1097,   497,   498,   499,   500,   501,
       0,  1098,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1099,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   194,   522,  1100,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,  1101,   533,   199,   534,
     535,   201,   536,  1102,     0,   538,   539,   540,   541,   542,
     543,   544,   545,  1103,   546,     0,   548,   549,   550,     0,
    1104,  1105,     0,   553,     0,   555,  1106,   556,  1107,  1108,
     558,   559,   560,   561,     0,  1109,   563,   564,   565,   566,
     567,  1110,     0,   570,   571,   572,  1111,   573,   216,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,    48,  1112,   218,  1113,     0,     0,  1114,  1115,
      51,  1116,    52,     0,     0,     0,     0,  1117,  1118,     0,
       0,  1120,  1121,     0,     0,     0,  1122,   629,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,   630,    98,    99,   100,   340,   631,   102,     0,   103,
     104,   105,   106,   632,   633,     0,   108,   109,   110,     0,
     111,   634,   635,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,  1066,     0,     0,   359,   360,   361,
     128,   362,   363,   364,   130,  1067,   132,  1068,  1069,     0,
     366,   367,     0,   368,  1070,  1071,   371,  1072,  1073,   372,
       0,   374,   375,   376,   377,  1074,     0,     0,   380,   381,
     382,     0,   384,   385,  1075,   386,     0,   388,   389,   144,
    1076,  1077,  1078,  1079,   394,   395,   396,   397,   398,  1080,
    1081,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,  1082,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,  1083,   423,     0,  1084,
    1085,   425,   426,  1086,     0,   428,     0,   430,   160,     0,
     161,   432,     0,   433,     0,     0,   436,     0,   438,   439,
     164,   440,   441,   442,   165,   443,   444,   445,   446,     0,
     166,   448,     0,   449,   450,   451,  1087,  1088,     0,  1089,
       0,     0,   170,   171,   454,   172,   455,   456,   457,   458,
       0,   173,   460,   174,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,  1090,   179,
    1091,   680,   477,   478,   479,   480,   181,     0,   482,   483,
     183,  1093,  1094,  1095,   485,     0,     0,   488,   681,     0,
       0,  1096,   493,     0,     0,   496,   186,   187,  1097,   497,
     498,   499,   500,   501,     0,  1098,   502,   503,   504,     0,
     506,   507,   508,   509,   510,  1099,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   194,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
    1101,   533,   199,   534,   535,   201,   536,  1102,     0,   538,
     539,   540,   541,   542,   543,   544,   545,  1103,   546,     0,
     548,   549,   550,     0,  1104,  1105,     0,   553,     0,   555,
    1106,   556,  1107,  1108,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,  1110,     0,   570,   571,   572,
    1111,   573,   216,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,    48,  1112,   218,  1113,
       0,     0,  1114,  1115,    51,  1116,    52,     0,     0,     0,
       0,     0,  1890,     0,     0,  1891,  1892,     0,     0,     0,
    1893,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,     0,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,  1066,     0,
       0,   359,   360,   361,   128,   362,   363,   364,     0,  1067,
     132,  1068,  1069,     0,   366,   367,     0,   368,  1070,  1071,
     371,  1072,  1073,   372,     0,   374,   375,   376,   377,  1074,
       0,     0,   380,   381,   382,     0,   384,   385,  1075,   386,
       0,   388,   389,   144,  1076,  1077,  1078,  1079,   394,   395,
     396,   397,   398,  1080,  1081,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,     0,     0,   420,   421,   422,
    1083,   423,     0,  1084,  1085,   425,   426,  1086,     0,   428,
       0,   430,   160,     0,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,     0,   440,   441,   442,     0,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
    1087,  1088,     0,  1089,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,     0,   173,   460,     0,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,   179,  1091,   680,   477,   478,   479,   480,
     181,     0,   482,   483,   183,  1093,  1094,  1095,   485,     0,
       0,   488,   681,     0,     0,  1096,   493,     0,     0,   496,
     186,   187,  1097,   497,   498,   499,   500,   501,     0,  1098,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1099,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,  1100,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,  1101,   533,   199,   534,   535,     0,
     536,  1102,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1103,   546,     0,   548,   549,   550,     0,  1104,  1105,
       0,   553,     0,   555,  1106,   556,  1107,  1108,   558,   559,
     560,   561,     0,  1109,   563,   564,   565,   566,   567,  1110,
       0,   570,   571,   572,  1111,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
      48,  1112,   218,  1113,     0,     0,  1114,  1115,    51,  1116,
      52,     0,     0,     0,     0,  1117,  1118,     0,     0,  1120,
    1121,     0,     0,     0,  1122,   629,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,   630,
      98,    99,   100,   340,   631,   102,     0,   103,   104,   105,
     106,   632,   633,     0,   108,   109,   110,     0,   111,   634,
     635,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,  1066,     0,     0,   359,   360,   361,   128,   362,
     363,   364,   130,  1067,   132,  1068,  1069,     0,   366,   367,
       0,   368,  1070,  1071,   371,  1072,  1073,   372,     0,   374,
     375,   376,   377,  1074,     0,     0,   380,   381,   382,     0,
     384,   385,  1075,   386,     0,   388,   389,   144,  1076,  1077,
    1078,  1079,   394,   395,   396,   397,   398,  1080,  1081,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,  1082,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,  1083,   423,     0,  1084,  1085,   425,
     426,  1086,     0,   428,     0,   430,   160,     0,   161,   432,
       0,   433,     0,     0,   436,     0,   438,   439,   164,   440,
     441,   442,   165,   443,   444,   445,   446,     0,   166,   448,
       0,   449,   450,   451,  1087,  1088,     0,  1089,     0,     0,
     170,   171,   454,   172,   455,   456,   457,   458,     0,   173,
     460,   174,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,  1090,   179,  1091,   680,
     477,   478,   479,   480,   181,     0,   482,   483,   183,  1093,
    1094,  1095,   485,     0,     0,   488,   681,     0,     0,   492,
     493,     0,     0,   496,   186,   187,  1097,   497,   498,   499,
     500,   501,     0,  1098,   502,   503,   504,     0,   506,   507,
     508,   509,   510,  1099,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,  1101,   533,
     199,   534,   535,   201,   536,  1102,     0,   538,   539,   540,
     541,   542,   543,   544,   545,  1103,   546,     0,   548,   549,
     550,     0,  1104,  1105,     0,   553,     0,   555,  1106,   556,
    1107,  1108,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,  1110,     0,   570,   571,   572,  1111,   573,
     216,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,    48,     0,   218,  1113,     0,     0,
    1114,  1115,    51,  1116,    52,   629,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,  1893,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,   630,
      98,    99,   100,   340,   631,   102,     0,   103,   104,   105,
     106,   632,   633,     0,   108,   109,   110,     0,   111,   634,
     635,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,  1066,     0,     0,   359,   360,   361,   128,   362,
     363,   364,     0,  1067,   132,  1068,  1069,     0,   366,   367,
       0,   368,  1070,  1071,   371,  1072,  1073,   372,     0,   374,
     375,   376,   377,  1074,     0,     0,   380,   381,   382,     0,
     384,   385,  1075,   386,     0,   388,   389,   144,  1076,  1077,
    1078,  1079,   394,   395,   396,   397,   398,  1080,  1081,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,  1082,   412,   413,     0,   415,   416,     0,     0,
       0,   420,   421,   422,  1083,   423,     0,  1084,  1085,   425,
     426,  1086,     0,   428,     0,   430,   160,     0,   161,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,   166,   448,
       0,   449,   450,   451,  1087,  1088,     0,  1089,     0,     0,
     170,   171,   454,   172,   455,   456,   457,   458,     0,   173,
     460,     0,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,  1090,   179,  1091,   680,
     477,   478,   479,   480,   181,     0,   482,   483,   183,  1093,
    1094,  1095,   485,     0,     0,   488,   681,     0,     0,     0,
     493,     0,     0,   496,   186,   187,  1097,   497,   498,   499,
     500,   501,     0,  1098,   502,   503,   504,     0,   506,   507,
     508,   509,   510,  1099,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,  1101,   533,
     199,   534,   535,     0,   536,  1102,     0,   538,   539,   540,
     541,   542,   543,   544,   545,  1103,   546,     0,   548,   549,
     550,     0,  1104,  1105,     0,   553,     0,   555,  1106,   556,
    1107,  1108,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,  1110,     0,   570,   571,   572,  1111,   573,
     216,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,    48,     0,   218,  1113,     0,     0,
    1114,  1115,    51,  1116,    52,     0,     0,     0,     0,     0,
    1890,     0,     0,  1891,  1892,     0,     0,     0,  1893,   629,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,   630,    98,    99,   100,   340,   631,   102,
       0,   103,   104,   105,   106,   632,   633,     0,   108,   109,
     110,     0,   111,   634,   635,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
    -922,   351,     0,     0,     0,  -922,  1066,     0,     0,   359,
     360,   361,   128,   362,   363,   364,     0,  1067,   132,  1068,
    1069,     0,   366,   367,     0,   368,  1070,  1071,   371,  1072,
    1073,   372,     0,   374,   375,   376,   377,  1074,     0,     0,
     380,   381,   382,     0,   384,   385,  1075,   386,     0,   388,
     389,   144,  1076,  1077,  1078,  1079,   394,   395,   396,   397,
     398,  1080,  1081,   399,     0,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,  1082,   412,   413,     0,
     415,   416,     0,     0,     0,   420,   421,   422,  1083,   423,
       0,  1084,  1085,   425,   426,  1086,     0,   428,     0,   430,
     160,     0,   161,   432,     0,   433,     0,     0,   436,     0,
     438,   439,     0,   440,   441,   442,     0,   443,   444,   445,
     446,     0,   166,   448,     0,   449,   450,   451,  1087,  1088,
       0,  1089,     0,     0,     0,     0,   454,   172,   455,   456,
     457,   458,     0,   173,   460,     0,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
    1090,   179,  1091,   680,   477,   478,   479,   480,   181,     0,
     482,   483,     0,  1093,  1094,  1095,   485,     0,     0,   488,
     681,     0,     0,     0,   493,     0,     0,   496,   186,   187,
    1097,   497,   498,   499,   500,   501,     0,  1098,   502,   503,
     504,     0,   506,   507,   508,   509,   510,  1099,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   194,
     522,  1100,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,  1101,   533,   199,   534,   535,     0,   536,  1102,
    -922,   538,   539,   540,   541,   542,   543,   544,   545,  1103,
     546,     0,   548,   549,   550,     0,  1104,  1105,     0,   553,
       0,   555,  1106,   556,  1107,  1108,   558,   559,   560,   561,
       0,  1109,   563,   564,   565,   566,   567,  1110,     0,   570,
     571,   572,  1111,   573,   216,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,    48,     0,
     218,  1113,     0,     0,  1114,  1115,    51,  1116,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1121,     0,
       0,     0,  1122,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,  -923,   351,     0,     0,     0,  -923,
    1066,     0,     0,   359,   360,   361,   128,   362,   363,   364,
       0,  1067,   132,  1068,  1069,     0,   366,   367,     0,   368,
    1070,  1071,   371,  1072,  1073,   372,     0,   374,   375,   376,
     377,  1074,     0,     0,   380,   381,   382,     0,   384,   385,
    1075,   386,     0,   388,   389,   144,  1076,  1077,  1078,  1079,
     394,   395,   396,   397,   398,  1080,  1081,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,     0,     0,   420,
     421,   422,  1083,   423,     0,  1084,  1085,   425,   426,  1086,
       0,   428,     0,   430,   160,     0,   161,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,   166,   448,     0,   449,
     450,   451,  1087,  1088,     0,  1089,     0,     0,     0,     0,
     454,   172,   455,   456,   457,   458,     0,   173,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,   179,  1091,   680,   477,   478,
     479,   480,   181,     0,   482,   483,     0,  1093,  1094,  1095,
     485,     0,     0,   488,   681,     0,     0,     0,   493,     0,
       0,   496,   186,   187,  1097,   497,   498,   499,   500,   501,
       0,  1098,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1099,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   194,   522,  1100,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,  1101,   533,   199,   534,
     535,     0,   536,  1102,  -923,   538,   539,   540,   541,   542,
     543,   544,   545,  1103,   546,     0,   548,   549,   550,     0,
    1104,  1105,     0,   553,     0,   555,  1106,   556,  1107,  1108,
     558,   559,   560,   561,     0,  1109,   563,   564,   565,   566,
     567,  1110,     0,   570,   571,   572,  1111,   573,   216,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,    48,     0,   218,  1113,     0,     0,  1114,  1115,
      51,  1116,    52,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,  1122,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
    1066,     0,     0,   359,   360,   361,   128,   362,   363,   364,
       0,  1067,   132,  1068,  1069,     0,   366,   367,     0,   368,
    1070,  1071,   371,  1072,  1073,   372,     0,   374,   375,   376,
     377,  1074,     0,     0,   380,   381,   382,     0,   384,   385,
    1075,   386,     0,   388,   389,   144,  1076,  1077,  1078,  1079,
     394,   395,   396,   397,   398,  1080,  1081,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,     0,     0,   420,
     421,   422,  1083,   423,     0,  1084,  1085,   425,   426,  1086,
       0,   428,     0,   430,   160,     0,   161,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,   166,   448,     0,   449,
     450,   451,  1087,  1088,     0,  1089,     0,     0,     0,     0,
     454,   172,   455,   456,   457,   458,     0,   173,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,   179,  1091,   680,   477,   478,
     479,   480,   181,     0,   482,   483,     0,     0,  1094,  1095,
     485,     0,     0,   488,   681,     0,     0,     0,   493,     0,
       0,   496,   186,   187,  1097,   497,   498,   499,   500,   501,
       0,  1098,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1099,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   194,   522,   196,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,  1101,   533,   199,   534,
     535,     0,   536,  1102,     0,   538,   539,   540,   541,   542,
     543,   544,   545,  1103,   546,     0,   548,   549,   550,     0,
    1104,  1105,     0,   553,     0,   555,  1106,   556,  1107,  1108,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,  1110,     0,   570,   571,   572,  1111,   573,   216,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,    48,     0,   218,  1113,     0,     0,  1114,  1115,
      51,  1116,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,  1893,   629,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,   630,    98,    99,   100,   340,   631,   102,     0,   103,
     104,   105,   106,   632,   633,     0,   108,   109,   110,     0,
     111,   634,   635,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,  1066,     0,     0,   359,   360,   361,
     128,   362,   363,   364,     0,  1067,   132,  1068,  1069,     0,
     366,   367,     0,   368,  1070,  1071,   371,  1072,  1073,   372,
       0,   374,   375,   376,   377,  1074,     0,     0,   380,   381,
     382,     0,   384,   385,  1075,   386,     0,   388,   389,   144,
    1076,  1077,  1078,  1079,   394,   395,   396,   397,   398,  1080,
    1081,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,  1082,   412,   413,     0,   415,   416,
       0,     0,     0,   420,   421,   422,  1083,   423,     0,  1084,
    1085,   425,   426,  1086,     0,   428,     0,   430,   160,     0,
     161,   432,     0,   433,     0,     0,   436,     0,   438,   439,
       0,   440,   441,   442,     0,   443,   444,   445,   446,     0,
     166,   448,     0,   449,   450,   451,  1087,  1088,     0,  1089,
       0,     0,     0,     0,   454,   172,   455,   456,   457,   458,
       0,   173,   460,     0,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,  1090,   179,
    1091,   680,   477,   478,   479,   480,   181,     0,   482,   483,
       0,     0,  1094,  1095,   485,     0,     0,   488,   681,     0,
       0,     0,   493,     0,     0,   496,   186,   187,  1097,   497,
     498,   499,   500,   501,     0,  1098,   502,   503,   504,     0,
     506,   507,   508,   509,   510,  1099,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   194,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
    1101,   533,   199,   534,   535,     0,   536,  1102,     0,   538,
     539,   540,   541,   542,   543,   544,   545,  1103,   546,     0,
     548,   549,   550,     0,  1104,  1105,     0,   553,     0,   555,
    1106,   556,  1107,  1108,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,  1110,     0,   570,   571,   572,
    1111,   573,   216,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,    48,     0,   218,  1113,
       0,     0,  1114,  1115,    51,  1116,    52,     0,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
    1893,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,     0,    98,    99,   100,   340,     0,   102,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,     0,  2562,     0,   359,   360,   361,
       0,   362,   363,   364,     0,   131,     0,   133,     0,     0,
     366,   367,     0,   368,     0,     0,   371,   599,   134,   372,
       0,   374,   375,   376,   377,   138,     0,     0,   380,   381,
     382,     0,   384,   385,   141,   386,     0,   388,   389,     0,
       0,     0,     0,     0,   394,   395,   396,   397,   398,   147,
     148,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,   411,   412,   413,     0,   415,   416,
       0,   418,  -709,   420,   421,   422,   155,   423,     0,   157,
       0,   425,   426,   159,  -709,   428,     0,   430,     0,     0,
       0,   432,     0,   433,     0,     0,   436,     0,   438,   439,
       0,   440,   441,   442,     0,   443,   444,   445,   446,     0,
       0,   448,     0,   449,   450,   451,     0,   168,  -709,   169,
       0,     0,     0,     0,   454,     0,   455,   456,   457,   458,
       0,     0,   460,     0,  -709,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,     0,
     180,     0,   477,   478,   479,   480,   181,     0,   482,   483,
       0,     0,   184,   185,   485,     0,  -709,   488,     0,     0,
       0,   492,   493,     0,  -709,   496,     0,     0,     0,   497,
     498,   499,   500,   501,     0,   188,   502,   503,   504,     0,
     506,   507,   508,   509,   510,   190,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
       0,   533,   199,   534,   535,     0,   536,   202,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   204,   546,     0,
     548,   549,   550,     0,   205,   206,     0,   553,     0,   555,
     207,   556,   208,     0,   558,   559,   560,   561,  -709,     0,
     563,   564,   565,   566,   567,     0,     0,   570,   571,   572,
     215,   573,     4,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     5,   218,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,  1199,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
      47,    48,     0,    49,     0,     0,     0,     0,     0,    51,
       0,    52,    53,     0,     0,     0,    54,    55,    56,    57,
      58,     0,     0,    59,    60,   901,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,   128,   362,
     363,   364,   130,   131,   132,   133,     0,     0,   366,   367,
       0,   368,     0,     0,   371,   599,   134,   372,     0,   374,
     375,   376,   377,   138,     0,     0,   380,   381,   382,     0,
     384,   385,   141,   386,     0,   388,   389,   144,     0,     0,
       0,     0,   394,   395,   396,   397,   398,   147,   148,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,   411,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   425,
     426,   159,     0,   428,     0,   430,   160,     0,   161,   432,
       0,   433,     0,     0,   436,     0,   438,   439,   164,   440,
     441,   442,   165,   443,   444,   445,   446,     0,   166,   448,
       0,   449,   450,   451,     0,   168,     0,   169,     0,     0,
     170,   171,   454,   172,   455,   456,   457,   458,     0,   173,
     460,   174,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   179,   180,   680,
     477,   478,   479,   480,   181,     0,   482,   483,   183,     0,
     184,   185,   485,     0,     0,   488,   681,     0,   837,   492,
     493,     0,     0,   496,   186,   187,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,     0,   506,   507,
     508,   509,   510,   190,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   194,   522,   196,   523,   524,
     525,   526,   527,     0,   197,   529,   530,   531,     0,   533,
     199,   534,   535,   201,   536,   202,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,     0,   548,   549,
     550,     0,   205,   206,     0,   553,     0,   555,   207,   556,
     208,     0,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,   215,   573,
     216,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,     0,     0,     0,
       0,     0,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,  2316,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,   340,
       0,   102,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,     0,     0,
       0,   359,   360,   361,   128,   362,   363,   364,   130,   131,
     132,   133,     0,     0,   366,   367,     0,   368,     0,     0,
     371,   599,   134,   372,     0,   374,   375,   376,   377,   138,
       0,     0,   380,   381,   382,     0,   384,   385,   141,   386,
       0,   388,   389,   144,     0,     0,     0,     0,   394,   395,
     396,   397,   398,   147,   148,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,   411,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   425,   426,   159,     0,   428,
       0,   430,   160,     0,   161,   432,     0,   433,     0,     0,
     436,     0,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,     0,   166,   448,     0,   449,   450,   451,
       0,   168,     0,   169,     0,     0,   170,   171,   454,   172,
     455,   456,   457,   458,     0,   173,   460,   174,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   179,   180,   680,   477,   478,   479,   480,
     181,     0,   482,   483,   183,     0,   184,   185,   485,     0,
       0,   488,   681,     0,   837,   492,   493,     0,     0,   496,
     186,   187,     0,   497,   498,   499,   500,   501,     0,   188,
     502,   503,   504,     0,   506,   507,   508,   509,   510,   190,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,   196,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,     0,   533,   199,   534,   535,   201,
     536,   202,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   204,   546,     0,   548,   549,   550,     0,   205,   206,
       0,   553,     0,   555,   207,   556,   208,     0,   558,   559,
     560,   561,     0,     0,   563,   564,   565,   566,   567,     0,
       0,   570,   571,   572,   215,   573,   216,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,     0,     0,     0,     0,     0,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,  2316,    92,    93,    94,    95,    96,
      97,     0,    98,    99,   100,   340,     0,   102,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,     0,     0,     0,   359,   360,   361,
     128,   362,   363,   364,   130,   131,   132,   133,     0,     0,
     366,   367,     0,   368,     0,     0,   371,   599,   134,   372,
       0,   374,   375,   376,   377,   138,     0,     0,   380,   381,
     382,     0,   384,   385,   141,   386,     0,   388,   389,   144,
       0,     0,     0,     0,   394,   395,   396,   397,   398,   147,
     148,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,   411,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   425,   426,   159,     0,   428,     0,   430,   160,     0,
     161,   432,     0,   433,     0,     0,   436,     0,   438,   439,
     164,   440,   441,   442,   165,   443,   444,   445,   446,     0,
     166,   448,     0,   449,   450,   451,     0,   168,     0,   169,
       0,     0,   170,   171,   454,   172,   455,   456,   457,   458,
       0,   173,   460,   174,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   179,
     180,   680,   477,   478,   479,   480,   181,     0,   482,   483,
     183,     0,   184,   185,   485,     0,     0,   488,   681,     0,
       0,   492,   493,     0,     0,   496,   186,   187,     0,   497,
     498,   499,   500,   501,     0,   188,   502,   503,   504,     0,
     506,   507,   508,   509,   510,   190,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   194,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
       0,   533,   199,   534,   535,   201,   536,   202,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   204,   546,     0,
     548,   549,   550,     0,   205,   206,     0,   553,     0,   555,
     207,   556,   208,     0,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,     0,     0,   570,   571,   572,
     215,   573,   216,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     0,   218,     0,
       0,     0,     0,     0,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
    2797,    92,    93,    94,    95,    96,    97,     0,    98,    99,
     100,   340,     0,   102,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,   131,     0,   133,     0,     0,   366,   367,     0,   368,
       0,     0,   371,   599,   134,   372,     0,   374,   375,   376,
     377,   138,     0,     0,   380,   381,   382,     0,   384,   385,
     141,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,   147,   148,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
     411,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   425,   426,   159,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,     0,   448,     0,   449,
     450,   451,     0,   168,     0,   169,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,     0,   180,     0,   477,   478,
     479,   480,   181,     0,   482,   483,     0,     0,   184,   185,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,   496,     0,     0,     0,   497,   498,   499,   500,   501,
       0,   188,   502,   503,   504,     0,   506,   507,   508,   509,
     510,   190,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   196,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,     0,   533,   199,   534,
     535,     0,   536,   202,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   204,   546,     0,   548,   549,   550,     0,
     205,   206,     0,   553,     0,   555,   207,   556,   208,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,   215,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,    48,     0,   218,   601,     0,     0,     0,     0,
      51,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2115,  2116,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,    48,     0,   218,   601,     0,
       0,     0,     0,    51,     0,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,  2116,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,   680,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,   681,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,     0,     0,     0,     0,
       0,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,     0,    90,  1193,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,     0,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,     0,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,   433,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,     0,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,     0,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,   197,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,     0,   548,   549,   550,     0,   205,   206,     0,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,     0,
       0,   218,   720,     0,     0,     0,     0,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,   219,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,   197,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     0,   218,     0,     0,
       0,     0,     0,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,     0,   339,     0,    90,   219,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,     0,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   531,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   205,
     206,     0,   553,     0,   555,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,     0,     0,     0,     0,     0,    78,
      79,    80,   337,     0,    82,    83,     0,    84,    85,    86,
     338,     0,   339,     0,    90,  1601,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,     0,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,     0,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,     0,     0,   218,
       0,     0,     0,     0,   629,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,  2744,    92,    93,    94,    95,    96,    97,   630,    98,
      99,   100,   340,   631,   102,     0,   103,   104,   105,   106,
     632,   633,     0,   108,   109,   110,     0,   111,   634,   635,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,  1321,     0,  1322,  1069,     0,   366,   367,     0,
     368,     0,     0,   371,  1323,  1324,   372,     0,   374,   375,
     376,   377,     0,     0,     0,   380,   381,   382,     0,   384,
     385,     0,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,  1325,  1326,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,  1082,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,     0,   423,     0,     0,     0,   425,   426,
    1327,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,  1087,  1328,     0,  1329,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,  1090,     0,  1330,     0,   477,
     478,   479,   480,     0,     0,   482,   483,     0,     0,     0,
    1331,   485,     0,     0,   488,     0,     0,     0,  2392,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,     0,   502,   503,   504,     0,   506,   507,   508,
     509,   510,  1332,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,     0,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,  1333,
     534,   535,     0,   536,  1334,     0,   538,   539,   540,   541,
     542,   543,   544,   545,     0,   546,     0,   548,   549,   550,
       0,  1335,  1336,     0,   553,     0,   555,     0,   556,     0,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,  1337,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,    48,   982,   218,   601,     0,     0,     0,
       0,    51,     0,    52,   983,   984,   985,     0,   986,  2393,
     988,   989,   990,   991,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,     0,    98,    99,
     100,   340,     0,   102,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,   131,     0,   133,     0,     0,   366,   367,     0,   368,
       0,     0,   371,   599,   134,   372,     0,   374,   375,   376,
     377,   138,     0,     0,   380,   381,   382,     0,   384,   385,
     141,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,   147,   148,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
     411,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   425,   426,   159,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,     0,   448,     0,   449,
     450,   451,     0,   168,     0,   169,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,     0,   180,     0,   477,   478,
     479,   480,   181,     0,   482,   483,     0,     0,   184,   185,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,   496,     0,     0,     0,   497,   498,   499,   500,   501,
       0,   188,   502,   503,   504,     0,   506,   507,   508,   509,
     510,   190,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   196,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,     0,   533,   199,   534,
     535,     0,   536,   202,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   204,   546,     0,   548,   549,   550,     0,
     205,   206,     0,   553,     0,   555,   207,   556,   208,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,   215,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,     0,   982,   218,     0,     0,     0,     0,     0,
       0,     0,     0,   983,   984,   985,     0,   986,   987,   988,
     989,   990,   991,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,  1321,     0,  1322,  1069,     0,   366,   367,     0,   368,
       0,     0,   371,  1323,  1324,   372,     0,   374,   375,   376,
     377,     0,     0,     0,   380,   381,   382,     0,   384,   385,
       0,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,  1325,  1326,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,     0,   423,     0,     0,     0,   425,   426,  1327,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,     0,   448,     0,   449,
     450,   451,  1087,  1328,     0,  1329,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,     0,  1330,     0,   477,   478,
     479,   480,     0,     0,   482,   483,     0,     0,     0,  1331,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,   496,     0,     0,     0,   497,   498,   499,   500,   501,
       0,     0,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1332,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,     0,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,     0,   533,  1333,   534,
     535,     0,   536,  1334,     0,   538,   539,   540,   541,   542,
     543,   544,   545,     0,   546,     0,   548,   549,   550,     0,
    1335,  1336,     0,   553,     0,   555,     0,   556,     0,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,  1337,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,     0,     0,   218,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,  1670,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,   680,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,   681,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
     835,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,     0,   362,
     363,   364,     0,   131,     0,   133,     0,     0,   366,   367,
       0,   368,     0,     0,   371,   599,   134,   372,     0,   374,
     375,   376,   377,   138,     0,     0,   380,   381,   382,     0,
     384,   385,   141,   386,     0,   388,   389,     0,     0,     0,
       0,     0,   394,   395,   396,   397,   398,   147,   148,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,   411,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   425,
     426,   159,     0,   428,     0,   430,     0,     0,     0,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,     0,   448,
       0,   449,   450,   451,     0,   168,     0,   169,     0,     0,
       0,     0,   454,     0,   455,   456,   457,   458,     0,     0,
     460,     0,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,     0,   180,     0,
     477,   478,   479,   480,   181,     0,   482,   483,     0,     0,
     184,   185,   485,     0,     0,   488,     0,     0,     0,   492,
     493,     0,     0,   496,     0,     0,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,     0,   506,   507,
     508,   509,   510,   190,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,     0,   533,
     199,   534,   535,     0,   536,   202,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,     0,   548,   549,
     550,     0,   205,   206,     0,   553,     0,   555,   207,   556,
     208,     0,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,   215,   573,
       0,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,  1306,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,  1586,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,  1587,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,  1588,     0,   488,     0,  1589,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,  1590,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,    48,     0,   218,   601,     0,
       0,     0,     0,    51,     0,    52,     0,    78,    79,    80,
     337,  1228,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,  1587,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,  1588,     0,   488,     0,  1589,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,  1590,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,    48,     0,   218,   601,     0,
       0,     0,     0,    51,     0,    52,     0,    78,    79,    80,
     337,  1228,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   753,   345,   346,   347,   348,   349,   754,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     755,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   756,   159,     0,   428,     0,   757,     0,   758,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,   759,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   760,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   761,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   762,
     507,   508,   509,   510,   190,   511,     0,   513,   763,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     0,   218,   601,    78,
      79,    80,   337,    51,    82,    83,     0,    84,    85,    86,
     338,   764,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   753,   345,   346,   347,   348,   349,   754,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   755,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,     0,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   756,   159,     0,   428,     0,   757,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     760,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   761,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   762,   507,   508,   509,   510,   190,   511,     0,   513,
     763,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,     0,     0,   218,
     601,    78,    79,    80,   337,    51,    82,    83,     0,    84,
      85,    86,   338,   764,   339,     0,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,     0,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,   620,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,   433,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,     0,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,     0,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,     0,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,     0,   548,   549,   550,     0,   205,   206,  1164,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,    48,
       0,   218,   601,    78,    79,    80,   337,     0,    82,    83,
    1165,    84,    85,    86,   338,     0,   339,     0,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,     0,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   531,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   205,
     206,     0,   553,     0,   555,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,    48,     0,   218,   601,     0,     0,  1114,  1115,    51,
       0,    52,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,   340,
       0,   102,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,     0,     0,
       0,   359,   360,   361,     0,   362,   363,   364,     0,   131,
       0,   133,     0,     0,   366,   367,     0,   368,     0,     0,
     371,   599,   134,   372,     0,   374,   375,   376,   377,   138,
       0,     0,   380,   381,   382,     0,   384,   385,   141,   386,
       0,   388,   389,     0,     0,     0,     0,     0,   394,   395,
     396,   397,   398,   147,   148,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,   411,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   425,   426,   159,     0,   428,
       0,   430,     0,     0,     0,   432,     0,   433,     0,     0,
     436,     0,   438,   439,     0,   440,   441,   442,     0,   443,
     444,   445,   446,     0,     0,   448,     0,   449,   450,   451,
       0,   168,     0,   169,     0,     0,     0,     0,   454,     0,
     455,   456,   457,   458,     0,     0,   460,     0,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,     0,   180,     0,   477,   478,   479,   480,
     181,     0,   482,   483,     0,     0,   184,   185,   485,     0,
       0,   488,     0,     0,     0,   492,   493,     0,     0,   496,
       0,     0,     0,   497,   498,   499,   500,   501,     0,   188,
     502,   503,   504,     0,   506,   507,   508,   509,   510,   190,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   196,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,     0,   533,   199,   534,   535,     0,
     536,   202,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   204,   546,     0,   548,   549,   550,     0,   205,   206,
       0,   553,     0,   555,   207,   556,   208,     0,   558,   559,
     560,   561,     0,     0,   563,   564,   565,   566,   567,     0,
       0,   570,   571,   572,   215,   573,     0,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,     0,   816,  1246,    78,    79,    80,   337,
     817,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,     0,   362,
     363,   364,     0,   131,     0,   133,     0,     0,   366,   367,
       0,   368,     0,     0,   371,   599,   134,   372,     0,   374,
     375,   376,   377,   138,     0,     0,   380,   381,   382,     0,
     818,   385,   141,   386,     0,   388,   389,     0,     0,     0,
       0,     0,   394,   395,   396,   397,   398,   147,   148,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,   411,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   425,
     426,   159,     0,   428,     0,   430,     0,     0,     0,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,     0,   448,
       0,   449,   450,   451,     0,   168,     0,   169,     0,     0,
       0,     0,   454,     0,   455,   456,   457,   458,     0,     0,
     460,     0,     0,   462,   463,   819,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   820,   475,     0,   180,     0,
     477,   478,   479,   480,   181,     0,   482,   483,     0,     0,
     184,   185,   485,     0,     0,   488,     0,     0,     0,   492,
     493,     0,     0,   496,     0,     0,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,     0,   506,   507,
     508,   509,   510,   190,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   821,     0,   533,
     199,   534,   535,     0,   536,   202,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,     0,   548,   549,
     550,     0,   822,   206,     0,   553,     0,   823,   207,   556,
     208,     0,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,   215,   573,
       0,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,   629,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,   630,    98,    99,   100,   340,   631,   102,     0,   103,
     104,   105,   106,   632,   633,     0,   108,   109,   110,     0,
     111,   634,   635,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     128,   362,   363,   364,   130,   131,   132,   133,     0,   365,
     366,   367,     0,   368,   369,   370,   371,   636,   134,   372,
     373,   374,   375,   376,   377,   138,   378,   379,   380,   381,
     382,   383,   384,   385,   141,   386,   387,   388,   389,   144,
     390,   391,   392,   393,   394,   395,   396,   397,   398,   147,
     148,   399,   400,   401,   402,   403,     0,   404,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   155,   423,     0,   157,
     424,   425,   426,   159,   427,   428,   429,   430,   160,   431,
     161,   432,     0,   433,   434,   435,   436,   437,   438,   439,
     164,   440,   441,   442,   165,   443,   444,   445,   446,   447,
     166,   448,   637,   449,   450,   451,   638,   168,   452,   169,
     453,     0,   170,   171,   454,   172,   455,   456,   457,   458,
     459,   173,   460,   174,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   179,
     180,   476,   477,   478,   479,   480,   181,   481,   482,   483,
     183,   484,   184,   185,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   186,   187,     0,   497,
     498,   499,   500,   501,     0,   188,   502,   503,   504,   505,
     506,   507,   508,   509,   510,   190,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   194,   522,   196,
     523,   524,   525,   526,   527,     0,   528,   529,   530,   531,
     532,   533,   199,   534,   535,   201,   536,   202,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   204,   546,   547,
     548,   549,   550,   551,   205,   206,   552,   553,   554,   555,
     207,   556,   208,   557,   558,   559,   560,   561,   639,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     215,   573,   216,   574,   575,     0,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     0,   218,    78,
      79,    80,   337,     0,    82,    83,   618,    84,    85,    86,
     338,     0,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,   619,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,   620,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,    48,     0,   218,
     601,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,     0,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,  1414,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,     0,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,     0,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,  1979,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
    1980,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,   680,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,   681,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,     0,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,  1981,  1982,   549,  1983,     0,   205,   206,     0,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,     0,
       0,   218,  1415,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,     0,   339,     0,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,     0,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   531,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   205,
     206,   600,   553,     0,   555,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,    48,     0,   218,   601,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,   889,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,     0,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,     0,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,    48,     0,   218,   601,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,   620,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,    48,     0,   218,   601,    78,
      79,    80,   337,     0,    82,    83,     0,    84,    85,    86,
     338,     0,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,     0,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,  1571,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,    48,     0,   218,
     601,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,     0,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,     0,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,     0,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,   433,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,     0,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,     0,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,     0,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,     0,   548,   549,   550,     0,   205,   206,     0,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,    48,
       0,   218,   601,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,   718,   339,     0,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,     0,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   719,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   531,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   205,
     206,     0,   553,     0,   555,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,   720,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   749,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,     0,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,     0,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,   720,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     0,   218,   720,    78,
      79,    80,   337,     0,    82,    83,     0,    84,    85,    86,
     338,     0,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,     0,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,     0,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,     0,     0,   218,
    1916,   629,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,   630,    98,    99,   100,   340,
     631,   102,     0,   103,   104,   105,   106,   632,   633,     0,
     108,   109,   110,     0,   111,   634,   635,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,     0,     0,
       0,   359,   360,   361,     0,   362,   363,   364,     0,  1321,
       0,  1322,  1069,     0,   366,   367,     0,   368,     0,     0,
     371,  1323,  1324,   372,     0,   374,   375,   376,   377,     0,
       0,     0,   380,   381,   382,     0,   384,   385,     0,   386,
       0,   388,   389,     0,     0,     0,     0,     0,   394,   395,
     396,   397,   398,  1325,  1326,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,  1082,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
       0,   423,     0,     0,     0,   425,   426,  1327,     0,   428,
       0,   430,     0,     0,     0,   432,     0,   433,     0,     0,
     436,     0,   438,   439,     0,   440,   441,   442,     0,   443,
     444,   445,   446,     0,     0,   448,     0,   449,   450,   451,
    1087,  1328,     0,  1329,     0,     0,     0,     0,   454,     0,
     455,   456,   457,   458,     0,     0,   460,     0,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,  1090,     0,  1330,     0,   477,   478,   479,   480,
    1813,     0,   482,   483,     0,     0,     0,  1331,   485,     0,
       0,   488,     0,     0,     0,   492,   493,     0,     0,   496,
       0,     0,     0,   497,   498,   499,   500,   501,     0,     0,
     502,   503,   504,     0,   506,   507,   508,   509,   510,  1332,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,     0,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,     0,   533,  1333,   534,   535,     0,
     536,  1334,     0,   538,   539,   540,   541,   542,   543,   544,
     545,     0,   546,     0,   548,   549,   550,     0,  1335,  1336,
       0,   553,     0,   555,     0,   556,     0,     0,   558,   559,
     560,   561,     0,     0,   563,   564,   565,   566,   567,     0,
       0,   570,   571,   572,  1337,   573,     0,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,   629,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,   630,    98,    99,
     100,   340,   631,   102,     0,   103,   104,   105,   106,   632,
     633,     0,   108,   109,   110,     0,   111,   634,   635,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,  1321,     0,  1322,  1069,     0,   366,   367,     0,   368,
       0,     0,   371,  1323,  1324,   372,     0,   374,   375,   376,
     377,     0,     0,     0,   380,   381,   382,     0,   384,   385,
       0,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,  1325,  1326,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
    1082,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,     0,   423,     0,     0,     0,   425,   426,  1327,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
    1689,   443,   444,   445,   446,     0,     0,  1690,     0,   449,
     450,   451,  1087,  1328,     0,  1329,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,  1090,     0,  1330,     0,   477,   478,
     479,   480,     0,     0,   482,   483,     0,     0,     0,  1331,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,  1691,     0,     0,     0,   497,   498,   499,   500,   501,
       0,     0,   502,   503,   504,     0,   506,   507,   508,   509,
     510,  1332,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,     0,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   531,     0,   533,  1333,   534,
     535,     0,   536,  1334,     0,   538,   539,   540,   541,   542,
     543,   544,   545,     0,   546,     0,   548,   549,   550,     0,
    1335,  1336,     0,   553,     0,   555,     0,   556,     0,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,  1337,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,     0,     0,   218,   629,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,   630,
      98,    99,   100,   340,   631,   102,     0,   103,   104,   105,
     106,   632,   633,     0,   108,   109,   110,     0,   111,   634,
     635,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,     0,   362,
     363,   364,     0,  1321,     0,  1322,  1069,     0,   366,   367,
       0,   368,     0,     0,   371,  1323,  1324,   372,     0,   374,
     375,   376,   377,     0,     0,     0,   380,   381,   382,     0,
     384,   385,     0,   386,     0,   388,   389,     0,     0,     0,
       0,     0,   394,   395,   396,   397,   398,  1325,  1326,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,  1082,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,     0,   423,     0,     0,     0,   425,
     426,  1327,     0,   428,     0,   430,     0,     0,     0,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,     0,   448,
       0,   449,   450,   451,  1087,  1328,     0,  1329,     0,     0,
       0,     0,   454,     0,   455,   456,   457,   458,     0,     0,
     460,     0,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,  1090,     0,  1330,     0,
     477,   478,   479,   480,  2471,     0,   482,   483,     0,     0,
       0,  1331,   485,     0,     0,   488,     0,     0,     0,   492,
     493,     0,     0,   496,     0,     0,     0,   497,   498,   499,
     500,   501,     0,     0,   502,   503,   504,     0,   506,   507,
     508,   509,   510,  1332,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,     0,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,     0,   533,
    1333,   534,   535,     0,   536,  1334,     0,   538,   539,   540,
     541,   542,   543,   544,   545,     0,   546,     0,   548,   549,
     550,     0,  1335,  1336,     0,   553,     0,   555,     0,   556,
       0,     0,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,  1337,   573,
       0,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,   629,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,   630,    98,    99,   100,   340,   631,   102,     0,   103,
     104,   105,   106,   632,   633,     0,   108,   109,   110,     0,
     111,   634,   635,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,     0,     0,     0,   359,   360,   361,
       0,   362,   363,   364,     0,  1321,     0,  1322,  1069,     0,
     366,   367,     0,   368,     0,     0,   371,  1323,  1324,   372,
       0,   374,   375,   376,   377,     0,     0,     0,   380,   381,
     382,     0,   384,   385,     0,   386,     0,   388,   389,     0,
       0,     0,     0,     0,   394,   395,   396,   397,   398,  1325,
    1326,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,  1082,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,     0,   423,     0,     0,
       0,   425,   426,  1327,     0,   428,     0,   430,     0,     0,
       0,   432,     0,   433,     0,     0,   436,     0,   438,   439,
       0,   440,   441,   442,     0,   443,   444,   445,   446,     0,
       0,   448,     0,   449,   450,   451,  1087,  1328,     0,  1329,
       0,     0,     0,     0,   454,     0,   455,   456,   457,   458,
       0,     0,   460,     0,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,  1090,     0,
    1330,     0,   477,   478,   479,   480,     0,     0,   482,   483,
       0,     0,     0,  1331,   485,     0,     0,   488,     0,     0,
       0,   492,   493,     0,     0,   496,     0,     0,     0,   497,
     498,   499,   500,   501,     0,     0,   502,   503,   504,     0,
     506,   507,   508,   509,   510,  1332,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,     0,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
       0,   533,  1333,   534,   535,     0,   536,  1334,     0,   538,
     539,   540,   541,   542,   543,   544,   545,     0,   546,     0,
     548,   549,   550,     0,  1335,  1336,     0,   553,     0,   555,
       0,   556,     0,     0,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,     0,     0,   570,   571,   572,
    1337,   573,     0,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     0,   218,   629,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,   630,    98,    99,   100,   340,   631,   102,
       0,   103,   104,   105,   106,   632,   633,     0,   108,   109,
     110,     0,   111,   634,   635,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
       0,   351,     0,     0,     0,     0,     0,     0,     0,   359,
     360,   361,     0,   362,   363,   364,     0,  1321,     0,  1322,
    1069,     0,   366,   367,     0,   368,     0,     0,   371,  1323,
    1324,   372,     0,   374,   375,   376,   377,     0,     0,     0,
     380,   381,   382,     0,   384,   385,     0,   386,     0,   388,
     389,     0,     0,     0,     0,     0,   394,   395,   396,   397,
     398,  1325,  1326,   399,     0,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,  1082,   412,   413,     0,
     415,   416,     0,   418,     0,   420,   421,   422,     0,   423,
       0,     0,     0,   425,   426,  1327,     0,   428,     0,   430,
       0,     0,     0,   432,     0,   433,     0,     0,   436,     0,
     438,   439,     0,   440,   441,   442,     0,   443,   444,   445,
     446,     0,     0,   448,     0,   449,   450,   451,  1087,  1328,
       0,  1329,     0,     0,     0,     0,   454,     0,   455,   456,
     457,   458,     0,     0,   460,     0,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
    1090,     0,  1330,     0,   477,   478,   479,   480,     0,     0,
     482,   483,     0,     0,     0,  1331,   485,     0,     0,   488,
       0,     0,     0,   492,   493,     0,     0,   496,     0,     0,
       0,   497,   498,   499,   500,   501,     0,     0,   502,   503,
     504,     0,   506,   507,   508,   509,   510,  1332,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,     0,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,     0,   533,     0,   534,   535,     0,   536,  1334,
       0,   538,   539,   540,   541,   542,   543,   544,   545,     0,
     546,     0,   548,   549,   550,     0,  1335,  1336,     0,   553,
       0,   555,     0,   556,     0,     0,   558,   559,   560,   561,
       0,     0,   563,   564,   565,   566,   567,     0,     0,   570,
     571,   572,  1337,   573,     0,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,     0,     0,
     218,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,    89,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,   107,     0,   108,
     109,   110, -1232,   111,   112,   113,     0,   341,   342,     0,
       0,     0,   116,   117,     0,     0,     0,     0,   118,     0,
       0,     0,     0,     0,     0,     0,     0,   119,     0,   120,
       0,   121,   122,     0,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   128,   362,   363,   364,   130,   131,   132,
     133,     0,   365,   366,   367,     0,   368,   369,   370,   371,
       0,   134,   372,   373,   374,   375,   376,   377,   138,   378,
     379,   380,   381,   382,   383,   384,   385,   141,   386,   387,
     388,   389,   144,   390,   391,   392,   393,   394,   395,   396,
     397,   398,   147,   148,   399,   400,   401,   402,   403,     0,
     404,   405,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   155,
     423,     0,   157,   424,   425,   426,   159,   427,   428,   429,
     430,   160,   431,   161,   432,     0,   433,   434,   435,   436,
     437,   438,   439,   164,   440,   441,   442,   165,   443,   444,
     445,   446,   447,   166,   448,     0,   449,   450,   451,     0,
     168,   452,   169,   453,     0,   170,   171,   454,   172,   455,
     456,   457,   458,   459,   173,   460,   174,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   179,   180,   476,   477,   478,   479,   480,   181,
     481,   482,   483,   183,   484,   184,   185,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   186,
     187,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,   505,   506,   507,   508,   509,   510,   190,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     194,   522,   196,   523,   524,   525,   526,   527,     0,   528,
     529,   530,   531,   532,   533,   199,   534,   535,   201,   536,
     202,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,   547,   548,   549,   550,   551,   205,   206,   552,
     553,   554,   555,   207,   556,   208,   557,   558,   559,   560,
     561,   211,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   215,   573,   216,   574,   575,     0,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   217,     0,
       0,   218,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,    89,    90,     0,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,   340,
       0,   102,     0,   103,   104,   105,   106,     0,   107,     0,
     108,   109,   110, -1233,   111,   112,   113,     0,   341,   342,
       0,     0,     0,   116,   117,     0,     0,     0,     0,   118,
       0,     0,     0,     0,     0,     0,     0,     0,   119,     0,
     120,     0,   121,   122,     0,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   128,   362,   363,   364,   130,   131,
     132,   133,     0,   365,   366,   367,     0,   368,   369,   370,
     371,     0,   134,   372,   373,   374,   375,   376,   377,   138,
     378,   379,   380,   381,   382,   383,   384,   385,   141,   386,
     387,   388,   389,   144,   390,   391,   392,   393,   394,   395,
     396,   397,   398,   147,   148,   399,   400,   401,   402,   403,
       0,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     155,   423,     0,   157,   424,   425,   426,   159,   427,   428,
     429,   430,   160,   431,   161,   432,     0,   433,   434,   435,
     436,   437,   438,   439,   164,   440,   441,   442,   165,   443,
     444,   445,   446,   447,   166,   448,     0,   449,   450,   451,
       0,   168,   452,   169,   453,     0,   170,   171,   454,   172,
     455,   456,   457,   458,   459,   173,   460,   174,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   179,   180,   476,   477,   478,   479,   480,
     181,   481,   482,   483,   183,   484,   184,   185,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     186,   187,     0,   497,   498,   499,   500,   501,     0,   188,
     502,   503,   504,   505,   506,   507,   508,   509,   510,   190,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   194,   522,   196,   523,   524,   525,   526,   527,     0,
     528,   529,   530,   531,   532,   533,   199,   534,   535,   201,
     536,   202,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   204,   546,   547,   548,   549,   550,   551,   205,   206,
     552,   553,   554,   555,   207,   556,   208,   557,   558,   559,
     560,   561,   211,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,   215,   573,   216,   574,   575,     0,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,     0,   339,    89,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110,     0,   111,   112,   113,     0,   341,
     342,     0,     0,     0,   116,   117,     0,     0,     0,     0,
     118,     0,     0,     0,     0,     0,     0,     0,     0,   119,
       0,   120,     0,   121,     0,     0,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   128,   362,   363,   364,   130,
     131,   132,   133,     0,   365,   366,   367,     0,   368,   369,
     370,   371,     0,   134,   372,   373,   374,   375,   376,   377,
     138,   378,   379,   380,   381,   382,   383,   384,   385,   141,
     386,   387,   388,   389,   144,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   147,   148,   399,   400,   401,   402,
     403,     0,   404,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   155,   423,     0,   157,   424,   425,   426,   159,   427,
     428,   429,   430,   160,   431,   161,   432,     0,   433,   434,
     435,   436,   437,   438,   439,   164,   440,   441,   442,   165,
     443,   444,   445,   446,   447,   166,   448,     0,   449,   450,
     451,     0,   168,   452,   169,   453,     0,   170,   171,   454,
     172,   455,   456,   457,   458,   459,   173,   460,   174,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   179,   180,   476,   477,   478,   479,
     480,   181,   481,   482,   483,   183,   484,   184,   185,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   186,   187,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,   505,   506,   507,   508,   509,   510,
     190,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   194,   522,   196,   523,   524,   525,   526,   527,
       0,   528,   529,   530,   531,   532,   533,   199,   534,   535,
     201,   536,   202,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,   547,   548,   549,   550,   551,   205,
     206,   552,   553,   554,   555,   207,   556,   208,   557,   558,
     559,   560,   561,   211,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   215,   573,   216,   574,   575,
       0,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,    89,    90,
       0,    92,    93,    94,    95,    96,    97,     0,    98,    99,
     100,   340,     0,   102,     0,   103,   104,   105,   106,     0,
     107,     0,   108,   109,   110,     0,   111,   112,   113,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   128,   362,   363,   364,
     130,   131,   132,   133,     0,   365,   366,   367,     0,   368,
     369,   370,   371,     0,   134,   372,   373,   374,   375,   376,
     377,   138,   378,   379,   380,   381,   382,   383,   384,   385,
     141,   386,   387,   388,   389,   144,   390,   391,   392,   393,
     394,   395,   396,   397,   398,   147,   148,   399,   400,   401,
     402,   403,     0,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   155,   423,     0,   157,   424,   425,   426,   159,
     427,   428,   429,   430,   160,   431,   161,   432,     0,   433,
     434,   435,   436,   437,   438,   439,   164,   440,   441,   442,
     165,   443,   444,   445,   446,   447,   166,   448,     0,   449,
     450,   451,     0,   168,   452,   169,   453,     0,   170,   171,
     454,   172,   455,   456,   457,   458,   459,   173,   460,   174,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   179,   180,   476,   477,   478,
     479,   480,   181,   481,   482,   483,   183,   484,   184,   185,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   186,   187,     0,   497,   498,   499,   500,   501,
       0,   188,   502,   503,   504,   505,   506,   507,   508,   509,
     510,   190,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   194,   522,   196,   523,   524,   525,   526,
     527,     0,   528,   529,   530,   531,   532,   533,   199,   534,
     535,   201,   536,   202,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   204,   546,   547,   548,   549,   550,   551,
     205,   206,   552,   553,   554,   555,   207,   556,   208,   557,
     558,   559,   560,   561,   211,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   215,   573,   216,   574,
     575,     0,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   217,     0,     0,   218,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,   128,   362,   363,
     364,   130,   131,   132,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,   144,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,   160,     0,   161,   432,     0,
     433,     0,     0,   436,     0,   438,   439,   164,   440,   441,
     442,   165,   443,   444,   445,   446,     0,   166,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,   170,
     171,   454,   172,   455,   456,   457,   458,     0,   173,   460,
     174,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   179,   180,   680,   477,
     478,   479,   480,   181,     0,   482,   483,   183,     0,   184,
     185,   485,     0,     0,   488,   681,     0,     0,   492,   493,
       0,     0,   496,   186,   187,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   194,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,   201,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,   216,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,     0,   362,
     363,   364,     0,   131,     0,   133,     0,     0,   366,   367,
       0,   368,     0,     0,   371,   599,   134,   372,  1676,   374,
     375,   376,   377,   138,     0,     0,   380,   381,   382,  1677,
     384,   385,   141,   386,     0,   388,   389,     0,     0,     0,
       0,     0,   394,   395,   396,   397,   398,   147,   148,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,   411,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   425,
     426,   159,     0,   428,  1678,   430,     0,     0,     0,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,     0,   448,
       0,   449,   450,   451,     0,   168,     0,   169,     0,     0,
       0,     0,   454,     0,   455,   456,   457,   458,     0,     0,
     460,  2144,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,     0,   180,     0,
     477,   478,   479,   480,   181,     0,   482,   483,     0,     0,
     184,   185,   485,     0,     0,   488,     0,     0,     0,   492,
     493,     0,     0,   496,     0,     0,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,  1679,   506,   507,
     508,   509,   510,   190,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,   531,     0,   533,
     199,   534,   535,     0,   536,   202,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,     0,   548,   549,
     550,     0,   205,   206,     0,   553,     0,   555,   207,   556,
     208,     0,   558,   559,   560,   561,     0,  1680,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,   215,   573,
       0,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,   125,
     126,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,     0,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
     680,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,   681,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     0,   218,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,     0,    98,    99,   100,   340,     0,   102,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,     0,     0,     0,   359,   360,   361,
       0,   362,   363,   364,     0,   131,     0,   133,     0,     0,
     366,   367,     0,   368,     0,     0,   371,   599,   134,   372,
       0,   374,   375,   376,   377,   138,     0,     0,   380,   381,
     382,     0,   384,   385,   141,   386,     0,   388,   389,     0,
       0,     0,     0,     0,   394,   395,   396,   397,   398,   147,
     148,   399,     0,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,   411,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   425,   426,   159,     0,   428,     0,   430,     0,     0,
       0,   432,     0,   433,     0,     0,   436,     0,   438,   439,
       0,   440,   441,   442,     0,   443,   444,   445,   446,     0,
       0,   448,     0,   449,   450,   451,     0,   168,     0,   169,
       0,     0,     0,     0,   454,     0,   455,   456,   457,   458,
       0,     0,   460,     0,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,     0,
     180,   680,   477,   478,   479,   480,   181,     0,   482,   483,
       0,     0,   184,   185,   485,     0,     0,   488,   681,     0,
     837,   492,   493,     0,     0,   496,     0,     0,     0,   497,
     498,   499,   500,   501,     0,   188,   502,   503,   504,     0,
     506,   507,   508,   509,   510,   190,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
       0,   533,   199,   534,   535,     0,   536,   202,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   204,   546,     0,
     548,   549,   550,     0,   205,   206,     0,   553,     0,   555,
     207,   556,   208,     0,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,     0,     0,   570,   571,   572,
     215,   573,     0,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     0,   218,    78,
      79,    80,   337,     0,    82,    83,     0,    84,    85,    86,
     338,     0,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,     0,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,  1424,   397,   398,
     147,   148,   399,     0,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,  1425,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,  1426,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,   680,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,   681,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,  1427,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
    1428,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,     0,     0,   218,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,     0,    98,    99,   100,   340,     0,   102,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
       0,   351,     0,     0,     0,     0,     0,     0,     0,   359,
     360,   361,     0,   362,   363,   364,     0,   131,     0,   133,
       0,     0,   366,   367,     0,   368,     0,     0,   371,   599,
     134,   372,     0,   374,   375,   376,   377,   138,     0,     0,
     380,   381,   382,     0,   384,   385,   141,   386,     0,   388,
     389,     0,     0,     0,     0,     0,   394,   395,   396,   397,
     398,   147,   148,   399,     0,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,   411,   412,   413,     0,
     415,   416,     0,   418,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   425,   426,   159,     0,   428,     0,   430,
       0,     0,     0,   432,     0,   433,     0,     0,   436,     0,
     438,   439,     0,   440,   441,   442,     0,   443,   444,   445,
     446,     0,     0,   448,     0,   449,   450,   451,     0,   168,
       0,   169,     0,     0,     0,     0,   454,     0,   455,   456,
     457,   458,     0,     0,   460,     0,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,     0,   180,   680,   477,   478,   479,   480,   181,     0,
     482,   483,     0,     0,   184,   185,   485,     0,     0,   488,
     681,     0,     0,   492,   493,     0,     0,   496,     0,     0,
       0,   497,   498,   499,   500,   501,     0,   188,   502,   503,
     504,     0,   506,   507,   508,   509,   510,   190,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   196,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,     0,   533,   199,   534,   535,     0,   536,   202,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   204,
     546,     0,   548,   549,   550,     0,   205,   206,     0,   553,
       0,   555,   207,   556,   208,     0,   558,   559,   560,   561,
       0,     0,   563,   564,   565,   566,   567,     0,  2874,   570,
     571,   572,   215,   573,     0,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,     0,     0,
     218,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,     0,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,     0,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,     0,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,   433,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,   680,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,   681,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,     0,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,     0,   548,   549,   550,     0,   205,   206,     0,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,     0,
       0,   218,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,   340,
       0,   102,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,     0,     0,
       0,   359,   360,   361,     0,   362,   363,   364,     0,   131,
       0,   133,     0,     0,   366,   367,     0,   368,     0,     0,
     371,   599,   134,   372,     0,   374,   375,   376,   377,   138,
       0,     0,   380,   381,   382,     0,   384,   385,   141,   386,
       0,   388,   389,     0,     0,     0,     0,     0,   394,   395,
     396,   397,   398,   147,   148,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,   411,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   425,   426,   159,     0,   428,
       0,   430,     0,   758,     0,   432,     0,   433,     0,     0,
     436,     0,   438,   439,     0,   440,   441,   442,   759,   443,
     444,   445,   446,     0,     0,   448,     0,   449,   450,   451,
       0,   168,     0,   169,     0,     0,     0,     0,   454,     0,
     455,   456,   457,   458,     0,     0,   460,     0,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,     0,   180,     0,   477,   478,   479,   480,
     181,     0,   482,   483,     0,     0,   184,   185,   485,     0,
       0,   488,     0,     0,     0,   492,   493,     0,     0,   496,
       0,     0,     0,   497,   498,   499,   500,   501,     0,   188,
     502,   503,   504,     0,   506,   507,   508,   509,   510,   190,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   196,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,     0,   533,   199,   534,   535,     0,
     536,   202,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   204,   546,     0,   548,   549,   550,     0,   205,   206,
       0,   553,     0,   555,   207,   556,   208,     0,   558,   559,
     560,   561,     0,     0,   563,   564,   565,   566,   567,     0,
       0,   570,   571,   572,   215,   573,     0,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,     0,   339,     0,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,   805,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   806,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   807,
     206,     0,   553,     0,   808,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,     0,    98,    99,
     100,   340,     0,   102,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,   826,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,   131,     0,   133,     0,     0,   366,   367,     0,   368,
       0,     0,   371,   599,   134,   372,     0,   374,   375,   376,
     377,   138,     0,     0,   380,   381,   382,     0,   384,   385,
     141,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,   147,   148,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
     411,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   425,   426,   159,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,     0,   448,     0,   449,
     450,   451,     0,   168,     0,   169,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,     0,   180,     0,   477,   478,
     479,   480,   181,     0,   482,   483,     0,     0,   184,   185,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,   496,     0,     0,     0,   497,   498,   499,   500,   501,
       0,   188,   502,   503,   504,     0,   506,   507,   508,   509,
     510,   190,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   196,   523,   524,   525,   526,
     527,     0,     0,   529,   530,   827,     0,   533,   199,   534,
     535,     0,   536,   202,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   204,   546,     0,   548,   549,   550,     0,
     828,   206,     0,   553,     0,   829,   207,   556,   208,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,   215,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,     0,     0,   218,    78,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,  1167,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,     0,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,     0,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,    78,    79,    80,   337,
       0,    82,    83,     0,    84,    85,    86,   338,     0,   339,
       0,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,   340,     0,   102,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   341,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   347,   348,   349,     0,   351,     0,     0,
       0,     0,     0,     0,     0,   359,   360,   361,  1176,   362,
     363,   364,     0,   131,     0,   133,     0,     0,   366,   367,
       0,   368,     0,     0,   371,   599,   134,  1177,     0,   374,
     375,   376,   377,   138,     0,     0,   380,   381,   382,     0,
     384,   385,   141,   386,     0,   388,   389,     0,     0,     0,
       0,     0,   394,   395,   396,   397,   398,   147,   148,   399,
       0,   401,     0,   403,     0,   404,   405,   406,     0,     0,
       0,   410,   411,   412,   413,     0,   415,   416,     0,   418,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   425,
     426,   159,     0,   428,     0,   430,     0,     0,     0,   432,
       0,   433,     0,     0,   436,     0,   438,   439,     0,   440,
     441,   442,     0,   443,   444,   445,   446,     0,     0,   448,
       0,   449,   450,   451,     0,   168,     0,   169,     0,     0,
       0,     0,   454,     0,   455,   456,   457,   458,     0,     0,
     460,     0,     0,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   820,   475,     0,   180,     0,
     477,   478,   479,   480,   181,     0,   482,   483,     0,     0,
     184,   185,   485,     0,     0,   488,     0,     0,     0,   492,
     493,     0,     0,   496,     0,     0,     0,   497,   498,   499,
     500,   501,     0,   188,   502,   503,   504,     0,   506,   507,
     508,   509,   510,   190,   511,     0,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   196,   523,   524,
     525,   526,   527,     0,     0,   529,   530,  1171,     0,   533,
     199,   534,   535,     0,   536,   202,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   204,   546,     0,   548,   549,
     550,     0,   822,   206,     0,   553,     0,   823,   207,   556,
     208,     0,   558,   559,   560,   561,     0,     0,   563,   564,
     565,   566,   567,     0,     0,   570,   571,   572,   215,   573,
       0,   574,   575,     0,     0,     0,   578,   579,   580,   581,
     582,   583,     0,   217,     0,     0,   218,    78,    79,    80,
     337,     0,    82,    83,     0,    84,    85,    86,   338,     0,
     339,     0,    90,     0,    92,    93,    94,    95,    96,    97,
       0,    98,    99,   100,   340,     0,   102,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   341,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   347,   348,   349,     0,   351,     0,
       0,     0,     0,     0,     0,     0,   359,   360,   361,     0,
     362,   363,   364,     0,   131,     0,   133,     0,     0,   366,
     367,     0,   368,     0,     0,   371,   599,   134,   372,     0,
     374,   375,   376,   377,   138,     0,     0,   380,   381,   382,
       0,   384,   385,   141,   386,     0,   388,   389,     0,     0,
       0,     0,     0,   394,   395,   396,   397,   398,   147,   148,
     399,     0,   401,     0,   403,     0,   404,   405,   406,     0,
       0,     0,   410,   411,   412,   413,     0,   415,   416,     0,
     418,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     425,   426,   159,     0,   428,     0,   430,     0,     0,     0,
     432,     0,   433,     0,  2188,   436,     0,   438,   439,     0,
     440,   441,   442,     0,   443,   444,   445,   446,     0,     0,
     448,     0,   449,   450,   451,     0,   168,     0,   169,     0,
       0,     0,     0,   454,     0,   455,   456,   457,   458,     0,
       0,   460,     0,     0,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,     0,   180,
       0,   477,   478,   479,   480,   181,     0,   482,   483,     0,
       0,   184,   185,   485,     0,     0,   488,     0,     0,     0,
     492,   493,     0,     0,   496,     0,     0,     0,   497,   498,
     499,   500,   501,     0,   188,   502,   503,   504,     0,   506,
     507,   508,   509,   510,   190,   511,     0,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   196,   523,
     524,   525,   526,   527,     0,     0,   529,   530,   531,     0,
     533,   199,   534,   535,     0,   536,   202,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   204,   546,     0,   548,
     549,   550,     0,   205,   206,     0,   553,     0,   555,   207,
     556,   208,     0,   558,   559,   560,   561,     0,     0,   563,
     564,   565,   566,   567,     0,     0,   570,   571,   572,   215,
     573,     0,   574,   575,     0,     0,     0,   578,   579,   580,
     581,   582,   583,     0,   217,     0,     0,   218,    78,    79,
      80,   337,     0,    82,    83,     0,    84,    85,    86,   338,
       0,   339,     0,    90,     0,    92,    93,    94,    95,    96,
      97,     0,    98,    99,   100,   340,     0,   102,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   341,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   347,   348,   349,     0,   351,
       0,     0,     0,     0,     0,     0,     0,   359,   360,   361,
       0,   362,   363,   364,     0,   131,     0,   133,     0,     0,
     366,   367,     0,   368,     0,     0,   371,   599,   134,   372,
       0,   374,   375,   376,   377,   138,     0,     0,   380,   381,
     382,     0,   384,   385,   141,   386,     0,   388,   389,     0,
       0,     0,     0,     0,   394,   395,   396,   397,   398,   147,
     148,   399,  2420,   401,     0,   403,     0,   404,   405,   406,
       0,     0,     0,   410,   411,   412,   413,     0,   415,   416,
       0,   418,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   425,   426,   159,     0,   428,     0,   430,     0,     0,
       0,   432,     0,   433,     0,     0,   436,     0,   438,   439,
       0,   440,   441,   442,     0,   443,   444,   445,   446,     0,
       0,   448,     0,   449,   450,   451,     0,   168,     0,   169,
       0,     0,     0,     0,   454,     0,   455,   456,   457,   458,
       0,     0,   460,     0,     0,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,     0,
     180,     0,   477,   478,   479,   480,   181,     0,   482,   483,
       0,     0,   184,   185,   485,     0,     0,   488,     0,     0,
       0,   492,   493,     0,     0,   496,     0,     0,     0,   497,
     498,   499,   500,   501,     0,   188,   502,   503,   504,     0,
     506,   507,   508,   509,   510,   190,   511,     0,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   196,
     523,   524,   525,   526,   527,     0,     0,   529,   530,   531,
       0,   533,   199,   534,   535,     0,   536,   202,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   204,   546,     0,
     548,   549,   550,     0,   205,   206,     0,   553,     0,   555,
     207,   556,   208,     0,   558,   559,   560,   561,     0,     0,
     563,   564,   565,   566,   567,     0,     0,   570,   571,   572,
     215,   573,     0,   574,   575,     0,     0,     0,   578,   579,
     580,   581,   582,   583,     0,   217,     0,     0,   218,    78,
      79,    80,   337,     0,    82,    83,     0,    84,    85,    86,
     338,     0,   339,     0,    90,     0,    92,    93,    94,    95,
      96,    97,     0,    98,    99,   100,   340,     0,   102,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   341,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   347,   348,   349,     0,
     351,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,   362,   363,   364,     0,   131,     0,   133,     0,
       0,   366,   367,     0,   368,     0,     0,   371,   599,   134,
     372,     0,   374,   375,   376,   377,   138,     0,     0,   380,
     381,   382,     0,   384,   385,   141,   386,     0,   388,   389,
       0,     0,     0,     0,     0,   394,   395,   396,   397,   398,
     147,   148,   399,  2422,   401,     0,   403,     0,   404,   405,
     406,     0,     0,     0,   410,   411,   412,   413,     0,   415,
     416,     0,   418,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   425,   426,   159,     0,   428,     0,   430,     0,
       0,     0,   432,     0,   433,     0,     0,   436,     0,   438,
     439,     0,   440,   441,   442,     0,   443,   444,   445,   446,
       0,     0,   448,     0,   449,   450,   451,     0,   168,     0,
     169,     0,     0,     0,     0,   454,     0,   455,   456,   457,
     458,     0,     0,   460,     0,     0,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
       0,   180,     0,   477,   478,   479,   480,   181,     0,   482,
     483,     0,     0,   184,   185,   485,     0,     0,   488,     0,
       0,     0,   492,   493,     0,     0,   496,     0,     0,     0,
     497,   498,   499,   500,   501,     0,   188,   502,   503,   504,
       0,   506,   507,   508,   509,   510,   190,   511,     0,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     196,   523,   524,   525,   526,   527,     0,     0,   529,   530,
     531,     0,   533,   199,   534,   535,     0,   536,   202,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   204,   546,
       0,   548,   549,   550,     0,   205,   206,     0,   553,     0,
     555,   207,   556,   208,     0,   558,   559,   560,   561,     0,
       0,   563,   564,   565,   566,   567,     0,     0,   570,   571,
     572,   215,   573,     0,   574,   575,     0,     0,     0,   578,
     579,   580,   581,   582,   583,     0,   217,     0,     0,   218,
      78,    79,    80,   337,     0,    82,    83,     0,    84,    85,
      86,   338,     0,   339,     0,    90,     0,    92,    93,    94,
      95,    96,    97,     0,    98,    99,   100,   340,     0,   102,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,     0,   341,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   347,   348,   349,
       0,   351,     0,     0,     0,     0,     0,  2562,     0,   359,
     360,   361,     0,   362,   363,   364,     0,   131,     0,   133,
       0,     0,   366,   367,     0,   368,     0,     0,   371,   599,
     134,   372,     0,   374,   375,   376,   377,   138,     0,     0,
     380,   381,   382,     0,   384,   385,   141,   386,     0,   388,
     389,     0,     0,     0,     0,     0,   394,   395,   396,   397,
     398,   147,   148,   399,     0,   401,     0,   403,     0,   404,
     405,   406,     0,     0,     0,   410,   411,   412,   413,     0,
     415,   416,     0,   418,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   425,   426,   159,     0,   428,     0,   430,
       0,     0,     0,   432,     0,   433,     0,     0,   436,     0,
     438,   439,     0,   440,   441,   442,     0,   443,   444,   445,
     446,     0,     0,   448,     0,   449,   450,   451,     0,   168,
       0,   169,     0,     0,     0,     0,   454,     0,   455,   456,
     457,   458,     0,     0,   460,     0,     0,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,     0,   180,     0,   477,   478,   479,   480,   181,     0,
     482,   483,     0,     0,   184,   185,   485,     0,     0,   488,
       0,     0,     0,   492,   493,     0,     0,   496,     0,     0,
       0,   497,   498,   499,   500,   501,     0,   188,   502,   503,
     504,     0,   506,   507,   508,   509,   510,   190,   511,     0,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   196,   523,   524,   525,   526,   527,     0,     0,   529,
     530,   531,     0,   533,   199,   534,   535,     0,   536,   202,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   204,
     546,     0,   548,   549,   550,     0,   205,   206,     0,   553,
       0,   555,   207,   556,   208,     0,   558,   559,   560,   561,
       0,     0,   563,   564,   565,   566,   567,     0,     0,   570,
     571,   572,   215,   573,     0,   574,   575,     0,     0,     0,
     578,   579,   580,   581,   582,   583,     0,   217,     0,     0,
     218,    78,    79,    80,   337,     0,    82,    83,     0,    84,
      85,    86,   338,     0,   339,     0,    90,     0,    92,    93,
      94,    95,    96,    97,     0,    98,    99,   100,   340,     0,
     102,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   341,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   347,   348,
     349,     0,   351,     0,     0,     0,     0,     0,  2576,     0,
     359,   360,   361,     0,   362,   363,   364,     0,   131,     0,
     133,     0,     0,   366,   367,     0,   368,     0,     0,   371,
     599,   134,   372,     0,   374,   375,   376,   377,   138,     0,
       0,   380,   381,   382,     0,   384,   385,   141,   386,     0,
     388,   389,     0,     0,     0,     0,     0,   394,   395,   396,
     397,   398,   147,   148,   399,     0,   401,     0,   403,     0,
     404,   405,   406,     0,     0,     0,   410,   411,   412,   413,
       0,   415,   416,     0,   418,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   425,   426,   159,     0,   428,     0,
     430,     0,     0,     0,   432,     0,   433,     0,     0,   436,
       0,   438,   439,     0,   440,   441,   442,     0,   443,   444,
     445,   446,     0,     0,   448,     0,   449,   450,   451,     0,
     168,     0,   169,     0,     0,     0,     0,   454,     0,   455,
     456,   457,   458,     0,     0,   460,     0,     0,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,     0,   180,     0,   477,   478,   479,   480,   181,
       0,   482,   483,     0,     0,   184,   185,   485,     0,     0,
     488,     0,     0,     0,   492,   493,     0,     0,   496,     0,
       0,     0,   497,   498,   499,   500,   501,     0,   188,   502,
     503,   504,     0,   506,   507,   508,   509,   510,   190,   511,
       0,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   196,   523,   524,   525,   526,   527,     0,     0,
     529,   530,   531,     0,   533,   199,   534,   535,     0,   536,
     202,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     204,   546,     0,   548,   549,   550,     0,   205,   206,     0,
     553,     0,   555,   207,   556,   208,     0,   558,   559,   560,
     561,     0,     0,   563,   564,   565,   566,   567,     0,     0,
     570,   571,   572,   215,   573,     0,   574,   575,     0,     0,
       0,   578,   579,   580,   581,   582,   583,     0,   217,     0,
       0,   218,    78,    79,    80,   337,     0,    82,    83,     0,
      84,    85,    86,   338,     0,   339,     0,    90,     0,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,   340,
       0,   102,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   341,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   347,
     348,   349,     0,   351,     0,     0,     0,     0,     0,     0,
       0,   359,   360,   361,     0,   362,   363,   364,     0,   131,
       0,   133,     0,     0,   366,   367,     0,   368,     0,     0,
     371,   599,   134,   372,     0,   374,   375,   376,   377,   138,
       0,     0,   380,   381,   382,     0,   384,   385,   141,   386,
       0,   388,   389,     0,     0,     0,     0,     0,   394,   395,
     396,   397,   398,   147,   148,   399,     0,   401,     0,   403,
       0,   404,   405,   406,     0,     0,     0,   410,   411,   412,
     413,     0,   415,   416,     0,   418,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   425,   426,   159,     0,   428,
       0,   430,     0,     0,     0,   432,     0,   433,     0,     0,
     436,     0,   438,   439,     0,   440,   441,   442,     0,   443,
     444,   445,   446,     0,     0,   448,     0,   449,   450,   451,
       0,   168,     0,   169,     0,     0,     0,     0,   454,     0,
     455,   456,   457,   458,     0,     0,   460,     0,     0,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,     0,   180,     0,   477,   478,   479,   480,
     181,     0,   482,   483,     0,     0,   184,   185,   485,     0,
       0,   488,     0,     0,     0,   492,   493,     0,     0,   496,
       0,     0,     0,   497,   498,   499,   500,   501,     0,   188,
     502,   503,   504,     0,   506,   507,   508,   509,   510,   190,
     511,     0,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   196,   523,   524,   525,   526,   527,     0,
       0,   529,   530,   531,     0,   533,   199,   534,   535,     0,
     536,   202,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   204,   546,     0,   548,   549,   550,     0,   205,   206,
       0,   553,     0,   555,   207,   556,   208,     0,   558,   559,
     560,   561,     0,     0,   563,   564,   565,   566,   567,     0,
       0,   570,   571,   572,   215,   573,     0,   574,   575,     0,
       0,     0,   578,   579,   580,   581,   582,   583,     0,   217,
       0,     0,   218,    78,    79,    80,   337,     0,    82,    83,
       0,    84,    85,    86,   338,     0,   339,     0,    90,     0,
      92,    93,    94,    95,    96,    97,     0,    98,    99,   100,
     340,     0,   102,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   341,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     347,   348,   349,     0,   351,     0,     0,     0,     0,     0,
       0,     0,   359,   360,   361,     0,   362,   363,   364,     0,
     131,     0,   133,     0,     0,   366,   367,     0,   368,     0,
       0,   371,   599,   134,   372,     0,   374,   375,   376,   377,
     138,     0,     0,   380,   381,   382,     0,   384,   385,   141,
     386,     0,   388,   389,     0,     0,     0,     0,     0,   394,
     395,   396,   397,   398,   147,   148,   399,     0,   401,     0,
     403,     0,   404,   405,   406,     0,     0,     0,   410,   411,
     412,   413,     0,   415,   416,     0,   418,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   425,   426,   159,     0,
     428,     0,   430,     0,     0,     0,   432,     0,   433,     0,
       0,   436,     0,   438,   439,     0,   440,   441,   442,     0,
     443,   444,   445,   446,     0,     0,   448,     0,   449,   450,
     451,     0,   168,     0,   169,     0,     0,     0,     0,   454,
       0,   455,   456,   457,   458,     0,     0,   460,     0,     0,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,     0,   180,     0,   477,   478,   479,
     480,   181,     0,   482,   483,     0,     0,   184,   185,   485,
       0,     0,   488,     0,     0,     0,   492,   493,     0,     0,
     496,     0,     0,     0,   497,   498,   499,   500,   501,     0,
     188,   502,   503,   504,     0,   506,   507,   508,   509,   510,
     190,   511,     0,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   196,   523,   524,   525,   526,   527,
       0,     0,   529,   530,   531,     0,   533,   199,   534,   535,
       0,   536,   202,     0,   538,   539,   724,   541,   542,   543,
     544,   545,   204,   546,     0,   548,   549,   550,     0,   205,
     206,     0,   553,     0,   555,   207,   556,   208,     0,   558,
     559,   560,   561,     0,     0,   563,   564,   565,   566,   567,
       0,     0,   570,   571,   572,   215,   573,     0,   574,   575,
       0,     0,     0,   578,   579,   580,   581,   582,   583,     0,
     217,     0,     0,   218,    78,    79,    80,   337,     0,    82,
      83,     0,    84,    85,    86,   338,     0,   339,     0,    90,
       0,    92,    93,    94,    95,    96,    97,     0,    98,    99,
     100,   340,     0,   102,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     341,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   347,   348,   349,     0,   351,     0,     0,     0,     0,
       0,     0,     0,   359,   360,   361,     0,   362,   363,   364,
       0,   131,     0,   133,     0,     0,   366,   367,     0,   368,
       0,     0,   371,   599,   134,   372,     0,   374,   375,   376,
     377,   138,     0,     0,   380,   381,   382,     0,   384,   385,
     141,   386,     0,   388,   389,     0,     0,     0,     0,     0,
     394,   395,   396,   397,   398,   147,   148,   399,     0,   401,
       0,   403,     0,   404,   405,   406,     0,     0,     0,   410,
     411,   412,   413,     0,   415,   416,     0,   418,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   425,   426,   159,
       0,   428,     0,   430,     0,     0,     0,   432,     0,   433,
       0,     0,   436,     0,   438,   439,     0,   440,   441,   442,
       0,   443,   444,   445,   446,     0,     0,   448,     0,   449,
     450,   451,     0,   168,     0,   169,     0,     0,     0,     0,
     454,     0,   455,   456,   457,   458,     0,     0,   460,     0,
       0,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   820,   475,     0,   180,     0,   477,   478,
     479,   480,   181,     0,   482,   483,     0,     0,   184,   185,
     485,     0,     0,   488,     0,     0,     0,   492,   493,     0,
       0,   496,     0,     0,     0,   497,   498,   499,   500,   501,
       0,   188,   502,   503,   504,     0,   506,   507,   508,   509,
     510,   190,   511,     0,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   196,   523,   524,   525,   526,
     527,     0,     0,   529,   530,  1171,     0,   533,   199,   534,
     535,     0,   536,   202,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   204,   546,     0,   548,   549,   550,     0,
     822,   206,     0,   553,     0,   823,   207,   556,   208,     0,
     558,   559,   560,   561,     0,     0,   563,   564,   565,   566,
     567,     0,     0,   570,   571,   572,   215,   573,     0,   574,
     575,     0,     0,     0,   578,   579,   580,   581,   582,   583,
       0,   217,     0,     0,   218,  1268,    79,    80,   337,     0,
      82,    83,     0,    84,    85,    86,   338,     0,   339,     0,
      90,     0,    92,    93,    94,    95,    96,    97,     0,    98,
      99,   100,   340,     0,   102,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   341,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   347,   348,   349,     0,   351,     0,     0,     0,
       0,     0,     0,     0,   359,   360,   361,     0,   362,   363,
     364,     0,   131,     0,   133,     0,     0,   366,   367,     0,
     368,     0,     0,   371,   599,   134,   372,     0,   374,   375,
     376,   377,   138,     0,     0,   380,   381,   382,     0,   384,
     385,   141,   386,     0,   388,   389,     0,     0,     0,     0,
       0,   394,   395,   396,   397,   398,   147,   148,   399,     0,
     401,     0,   403,     0,   404,   405,   406,     0,     0,     0,
     410,   411,   412,   413,     0,   415,   416,     0,   418,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   425,   426,
     159,     0,   428,     0,   430,     0,     0,     0,   432,     0,
     433,     0,     0,   436,     0,   438,   439,     0,   440,   441,
     442,     0,   443,   444,   445,   446,     0,     0,   448,     0,
     449,   450,   451,     0,   168,     0,   169,     0,     0,     0,
       0,   454,     0,   455,   456,   457,   458,     0,     0,   460,
       0,     0,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,     0,   180,     0,   477,
     478,   479,   480,   181,     0,   482,   483,     0,     0,   184,
     185,   485,     0,     0,   488,     0,     0,     0,   492,   493,
       0,     0,   496,     0,     0,     0,   497,   498,   499,   500,
     501,     0,   188,   502,   503,   504,     0,   506,   507,   508,
     509,   510,   190,   511,     0,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   196,   523,   524,   525,
     526,   527,     0,     0,   529,   530,   531,     0,   533,   199,
     534,   535,     0,   536,   202,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   204,   546,     0,   548,   549,   550,
       0,   205,   206,     0,   553,     0,   555,   207,   556,   208,
       0,   558,   559,   560,   561,     0,     0,   563,   564,   565,
     566,   567,     0,     0,   570,   571,   572,   215,   573,     0,
     574,   575,     0,     0,     0,   578,   579,   580,   581,   582,
     583,     0,   217,     0,     0,   218,    78,    79,    80,     0,
       0,    82,    83,     0,    84,    85,    86,     0,     0,     0,
      89,    90,     0,    92,    93,    94,    95,    96,    97,     0,
      98,    99,   100,     0,     0,   102,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110,     0,   111,   112,
     113,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   128,     0,
       0,     0,   130,   131,   132,   133,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   134,     0,     0,     0,
       0,     0,     0,   138,     0,     0,     0,     0,     0,     0,
       0,     0,   141,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   147,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   165,     0,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   168,     0,   169,     0,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,   173,
       0,   174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   179,   180,     0,
       0,     0,     0,     0,   181,     0,     0,     0,   183,     0,
     184,   185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
       0,     0,     0,   188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   194,     0,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
       0,     0,   205,   206,     0,     0,     0,     0,   207,     0,
     208,     0,     0,     0,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
     216,     0,    78,    79,    80,     0,     0,    82,    83,     0,
      84,    85,    86,   217,     0,     0,   218,    90,     0,    92,
      93,    94,    95,    96,    97,     0,    98,    99,   100,     0,
       0,   102,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,     0,   130,   131,
     132,   133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   134,     0,     0,     0,     0,     0,     0,   138,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   147,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,   157,     0,     0,     0,   159,     0,     0,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,   165,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   173,     0,   174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   179,   180,     0,     0,     0,     0,     0,
     181,     0,     0,     0,   183,     0,   184,   185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,     0,     0,     0,   188,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   199,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,     0,     0,   205,   206,
       0,     0,     0,     0,   207,     0,   208,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   218
};

static const short yycheck[] =
{
       2,   702,   154,   219,    73,    81,   664,  1017,   666,   818,
     796,    76,   992,  1374,    73,  1742,   655,    73,   998,    89,
     831,  1349,    73,   909,   598,    76,   158,   665,   875,   718,
      73,   209,   668,    89,  1257,   736,    89,   189,    89,   675,
     698,  1364,   112,    73,    73,   127,   178,    76,   213,  1364,
    1364,   709,   588,  1932,  1812,  1105,   112,    73,   696,   112,
      89,   112,  1137,   145,   700,  1746,    91,  1143,   704,    73,
    1146,  1988,   815,  1116,  2186,   711,   101,  1449,   663,  1712,
    1713,  1630,   667,   112,   773,    76,  1965,  2139,  1484,   747,
     819,  2008,   821,   731,  2316,  1695,  1031,   752,   734,  1031,
     176,  2321,  2322,  1522,    25,  1524,    26,   692,   744,  1700,
    1701,   136,  1530,   883,  1041,  1042,  1665,  1388,    43,     2,
    1669,   146,   904,   659,   149,    51,    78,  1072,  1073,   154,
     817,    78,    92,   158,  1530,   892,   893,   111,    78,    92,
     122,   211,   727,    93,   718,    97,  1091,   657,   733,   116,
     219,   220,   134,   178,   134,   211,   158,    97,   211,   640,
     211,   134,  1081,    86,   189,   150,  2049,    78,    91,  2640,
      83,   116,   111,   187,   150,   749,   178,   220,    83,    78,
    2261,   165,   211,   134,  2777,  1776,    97,    73,   102,  1517,
     220,   118,   202,    73,   833,    86,   218,    81,    97,   773,
      91,   144,   129,   102,   220,    92,  1755,   111,    86,   187,
      34,   152,   192,    91,   189,    78,   220,  1144,   314,   192,
      76,   218,   150,   307,  1448,  1449,   218,  2916,   166,   218,
      92,   264,   163,    89,   294,  1459,  1460,   153,   157,   171,
     344,   192,   376,   150,   303,   262,   259,   303,  1390,   150,
     163,   292,   303,    78,  1396,   336,   112,   184,   163,   960,
     150,  2950,   205,  1487,  1307,   344,   384,   315,  2234,   387,
     169,  1495,    97,    86,   303,    84,    73,   102,    91,     0,
     414,   155,   363,   199,   198,   943,  1336,   171,   202,   337,
     408,   100,   222,  1179,    73,   277,  2262,    76,   236,   198,
      44,  1311,    46,   202,    18,   150,   972,     8,  1351,   220,
      89,   415,   408,    14,    15,    16,   395,   231,   259,   155,
     361,   220,   221,   981,   408,    26,    27,    28,   302,    30,
      31,    32,   231,   112,   309,  1559,    37,    38,    39,   277,
     220,    29,   364,  2565,  2116,  1003,   104,  2569,   408,  1015,
      29,  2573,   259,  2232,    83,   211,   116,   149,    87,   258,
     287,  1019,   292,   302,   277,   255,   344,   364,  1378,   954,
     269,   384,   364,   958,   387,   364,   212,   202,  1323,  1324,
     137,   414,  2975,    86,   307,  1330,   210,   218,   319,   321,
     374,   408,   414,   298,   337,   220,   221,   372,   302,   384,
     414,   339,   387,   326,   414,   111,   319,  1326,   384,   323,
     255,   387,    78,   314,  2095,   925,   392,   303,   175,   401,
    1005,   902,  2503,   307,   323,   182,   411,  1503,  2899,   409,
     357,   411,   211,   258,   163,   326,   409,   321,   411,   384,
     414,   408,   387,   364,   269,   364,   406,  1217,   326,   401,
     402,   403,   404,   406,  2003,   212,   384,   404,   408,   387,
     411,   387,   387,   408,   404,  1235,   367,   387,  1403,  1740,
    1402,  1253,  1890,  1891,  1892,   414,  1894,  1164,  1165,  2362,
    2363,   402,  1239,  1057,  1411,   408,   385,   361,   399,   400,
     401,   402,   403,   404,  1890,  1891,  1892,    78,  1894,  2090,
     399,   400,   401,   402,   403,   404,   303,   408,   673,  2109,
    2730,   255,  2734,   326,   155,   218,    97,  2739,   600,   406,
     585,  2743,   409,   410,   303,   361,   214,   414,  1604,   588,
    1475,  1476,   118,   364,   585,   214,   154,   588,   401,   402,
     403,   404,  1960,  1198,   406,   251,  1275,   409,   410,   262,
     218,   152,   414,  1302,   220,   347,   585,   112,  2158,   588,
     385,   726,    78,   220,  1960,   218,  2115,   719,   171,   298,
     159,   212,  1301,   598,   399,   400,   401,   402,   403,   404,
     411,   218,   149,   284,   267,   655,   378,   159,   155,    86,
     319,   616,   617,  2645,   585,   155,   302,    78,   184,   655,
     659,   219,   655,   269,   655,     5,  1272,   154,   659,   369,
     267,  2833,   145,   319,   187,  1424,   257,  1426,  1427,   188,
     240,   753,  1371,   755,   384,   757,   655,   387,   145,    29,
     659,   763,   764,  2405,  2406,  2407,  2408,  2409,   640,   220,
     221,    41,  1428,   155,   669,   212,   671,    78,   408,   674,
     104,   163,   212,   354,   255,  1698,   211,   197,   134,    29,
     129,   364,  2774,   406,   197,    18,   255,   410,   693,  1997,
     259,    41,   219,   314,  1816,  1817,   268,   258,   153,  1318,
     197,   150,   707,   255,   387,  1909,  1910,  1911,  1912,   392,
     262,  1357,   312,   718,   719,   408,   364,   400,   145,  2457,
     240,   287,   156,   728,   220,  2386,  2387,   240,   411,   278,
     243,   364,   145,   738,   153,   115,   192,   742,   321,   385,
     361,   218,  1388,   240,   199,  1949,  1392,   364,  1264,   585,
     396,   397,   588,   399,   400,   401,   402,   403,   404,   220,
     765,  1399,   767,   411,   820,   115,   170,   314,   773,   337,
     197,   753,    86,   755,   314,   757,  2389,   640,   411,  1395,
     199,   763,   764,   833,   197,  1989,  1990,   408,   118,  1845,
     187,   357,   312,   285,   411,   218,   801,   833,  1664,   312,
     833,  1482,   833,    78,   292,   202,   255,   379,   269,   220,
     347,   407,   216,   240,   361,   312,   243,  1606,   414,   655,
     150,   361,  1649,   659,   833,   259,   585,   240,   316,   588,
     243,   265,  1555,   192,   214,   143,   892,   893,   399,   400,
     401,   402,   403,   404,  2242,   159,  1836,  2245,  2246,  2247,
    2248,  2249,  2250,  2251,  2252,  2253,  2254,   188,   269,  2211,
    1425,   408,   307,   152,   214,  1921,  2242,   380,   272,  2245,
    2246,  2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,  1706,
    1526,  2410,  1709,  1710,  2283,   312,   411,   364,   135,   136,
     347,  2289,   178,   875,    35,   408,   655,   150,  1921,   312,
     659,   386,   387,   399,   400,   401,   402,   403,   404,  1528,
     387,   916,  2288,  2289,   919,   392,   361,   922,   207,   901,
     902,   378,   904,   400,   385,   255,  1122,   909,  2050,   259,
     370,   239,   182,   241,   411,   672,   673,  1277,   399,   400,
     401,   402,   403,   404,   189,   220,  2607,  2608,   376,   377,
    2006,  1291,   356,   380,   691,   202,   961,   287,  2080,  2081,
     965,  2016,   155,   968,   232,   295,   255,   380,   973,  1025,
     182,    78,   407,   259,   385,  2872,   262,   172,   411,   414,
     408,   408,   232,  1032,   395,   396,   397,  2884,   399,   400,
     401,   402,   403,   404,   376,   377,   264,   833,   409,     7,
     118,  1006,   255,    11,  1053,   252,   253,   125,   203,  1032,
     145,   129,   875,    58,   264,    23,    24,  1066,   240,   212,
     232,   243,  1032,   314,   269,   263,   408,   357,  2426,   267,
    1053,    76,   279,   307,  1083,  1040,  1032,    45,   901,   902,
      48,   904,   159,   104,  2782,  2167,   909,  2169,  1032,  2171,
    2426,  1056,   264,   790,  2109,   329,  1674,    88,    89,   796,
    1109,   178,   197,   256,   257,   351,   184,   804,  1124,  2273,
    1686,   412,   358,  1122,   833,    85,   367,   330,    47,  1135,
     333,   142,    98,  1599,  1700,  1701,  1702,   170,   333,   336,
     312,   938,   387,   411,  1740,   832,  1742,   392,   765,   182,
     837,   117,   949,  2411,  2963,   240,  1744,  1745,   243,  1725,
    1756,  1727,   849,   220,   409,   125,  2744,   408,  2746,   366,
    1176,   314,   385,    93,   399,   400,   401,   402,   403,   404,
     797,   387,   408,   216,   144,  2438,   392,  1249,   255,   416,
     110,   188,   259,  2438,  2438,   262,   387,  2350,  2546,   232,
     211,   161,   160,   412,  1299,  1204,  1205,  1826,  1207,  1828,
    1776,   208,   269,  1779,  1810,   298,   364,   300,   361,   287,
    2546,   331,   332,    78,   214,  1237,   223,   312,   369,   189,
    1216,   264,   229,  1239,    21,  1216,   319,  1218,  1219,   272,
     251,   120,    97,   384,   104,   205,   387,  1179,   267,   298,
     387,   300,  1184,  1185,  1995,   392,   176,  1216,  2836,  1218,
    1219,   413,   414,   400,  2945,   408,   953,   408,    78,  2275,
     319,    40,  2278,   387,   384,  1264,  2534,   387,   392,  2018,
     200,     2,   142,  1264,   351,  1271,  2266,  2267,  1434,   357,
    1271,   358,  2069,  2109,   384,   380,  1228,   387,  2075,  2076,
     311,  1932,   392,  2984,   394,  1264,   226,   410,   305,   269,
     400,  1266,  1271,  1000,  1001,   267,   411,  1249,  1318,   414,
    1007,  1253,  1826,   356,  1828,  1257,   408,   376,   385,  3010,
     384,   123,  1318,   387,  1965,  1318,   349,  1318,   395,   396,
     397,  2998,   399,   400,   401,   402,   403,   404,   140,   309,
     310,   211,   409,   409,   408,   315,   299,   409,   414,  1318,
      81,   153,   414,  2711,  1051,  2713,  1179,    88,  1374,   409,
     131,  1184,  1185,   387,   414,  2666,   409,   337,   392,   409,
     394,  1078,  1079,   303,   414,  2711,   400,  2713,   338,   349,
     340,   251,   202,   313,   354,  2467,   290,   384,   125,  1461,
     387,  1463,   129,   195,  1101,  1467,   127,   327,   115,   116,
     220,  1473,   372,  1110,   334,  1228,  2488,   384,  1480,    81,
     387,   408,   413,   414,   145,  2579,    88,   226,  1490,    91,
    1492,   409,  1218,  1219,   137,  1434,   414,   376,   377,   101,
    1253,   408,   205,   384,  1257,   384,   387,   383,   387,  1404,
     386,   311,  1514,   373,  1516,   176,   376,   191,   753,   269,
     755,  1909,   757,  1911,  1912,   127,  1472,  2035,   763,   408,
     384,  2819,  1987,   387,   136,   137,   409,   384,  1264,   408,
     387,   414,  2078,   145,   146,   188,   409,   149,  1420,   376,
     377,   414,   154,  2819,  2752,   289,   158,   384,   409,    78,
     387,   235,   338,   414,   340,   208,  1193,  1216,   409,  1218,
    1219,    90,   409,   414,   376,   377,   178,   414,   409,  1518,
     223,   408,   267,   414,  2090,  1524,   229,   189,  1528,  1461,
     192,  1463,  1318,  1532,   414,  1467,   198,   271,   200,  2108,
      78,  1473,  1528,  1498,   247,  1528,  2142,  1528,  1480,  1204,
    1205,   384,  1207,   384,   387,  1264,   387,  2153,  1490,    97,
    1492,   409,  1271,    78,   102,   409,   414,   409,   384,  1528,
     414,   387,   414,  1579,  2170,   385,  2172,   408,  1204,  1205,
     187,  1207,  1514,   222,  1516,   395,   396,   397,    78,   399,
     400,   401,   402,   403,   404,  2749,   384,    98,   409,   387,
      90,  2232,   305,   414,   338,   384,   340,   270,   387,  1318,
    1599,   409,   384,   381,  1569,   387,   414,   381,  1599,   384,
     408,  2217,   387,   399,   400,   401,   402,   403,   406,   408,
     408,  2219,   406,   409,   408,   267,   408,  1632,   372,  1634,
    1599,   220,   409,   408,    98,  2241,   392,   414,   394,  1655,
     409,  1632,   409,  1634,   409,   414,   269,   414,   409,   414,
     198,   409,   409,   414,   202,   409,   414,   414,   376,   377,
     414,  2186,  2268,  1632,  1736,  1634,   409,   381,   338,   382,
     340,   414,   220,   221,   399,   400,   401,   402,   403,   409,
     269,   120,   407,   231,   414,   409,   376,   377,   409,   409,
     414,  1763,  2298,   414,   414,   220,  1393,  1394,   222,  2715,
     145,   409,   109,  1775,   409,   120,   414,  1649,  1673,   414,
     258,   409,  1677,  2877,   409,   409,   414,   411,  1683,   414,
     220,   269,  1664,   409,  1666,   319,  1668,  1743,   414,   186,
    1746,  1428,  1528,   338,  1750,   340,   143,  1893,  1703,   401,
    1705,  1438,   409,   411,   269,   411,   414,   414,   414,   409,
    1447,   411,   197,   851,  1719,   853,  1721,   411,  1723,  2570,
     414,  2572,   385,   409,  1706,   376,   377,  1709,  1710,   269,
    2847,  2848,   395,   396,   397,   323,   399,   400,   401,   402,
     403,   404,  1798,  1939,  2020,  2021,  1858,   401,   402,   403,
     409,  2316,    86,  1949,  1736,   240,   385,   204,   243,  1292,
    1293,  1294,   411,  1599,   894,   895,   395,   396,   397,  1528,
     399,   400,   401,   402,   403,   404,  1758,  1768,  1769,  1770,
     108,  1763,   401,   214,   412,   412,  1649,   344,   344,   344,
     344,  2437,   239,  1775,   241,   344,  1632,   385,  1634,   168,
      93,  1664,   108,  1666,   251,  1668,   364,   395,   396,   397,
     416,   399,   400,   401,   402,   403,   404,  1554,   214,   220,
     385,  1826,   344,  1828,  1982,  1983,   408,   312,   408,   600,
     395,   396,   397,   408,   399,   400,   401,   402,   403,   404,
    1599,   137,   408,  1706,  1893,   385,  1709,  1710,   298,   410,
     298,  2811,   298,   267,   301,   395,   396,   397,   408,   399,
     400,   401,   402,   403,   404,   411,   376,   408,  1605,   640,
     118,   376,    93,  1632,   376,  1634,  1858,   376,   226,   375,
     408,   328,  1931,   408,  1996,   267,   598,   267,   600,    43,
    1939,   414,   188,  1942,   183,   380,  2542,   230,   383,   384,
    1949,   386,   387,   182,   616,   617,   385,   267,   408,   284,
     408,   414,   208,  1962,   408,   408,   395,   396,   397,   408,
     399,   400,   401,   402,   403,   404,   118,   223,   408,  1978,
     385,   408,   408,   229,   408,   408,   408,   129,  1987,   408,
     395,   396,   397,   408,   399,   400,   401,   402,   403,   404,
     408,   247,   664,   665,   666,   408,   668,   669,   150,   671,
     152,    93,   674,   675,   408,   408,   408,   230,   222,   230,
     220,   267,   408,   182,   401,   214,   312,    93,   243,   414,
     149,   693,   363,   344,   696,   410,   698,   408,   700,   408,
    2980,   414,   704,   408,   110,   707,   298,   709,   344,   711,
    2565,   344,  2114,   344,  2569,   363,   718,   719,  2573,   305,
     363,   125,   344,   364,  1996,   207,   728,   344,   377,   731,
    2002,   267,   734,   345,   344,  2791,   738,   344,   265,   408,
     742,   408,   744,   267,  2166,   747,   220,  2826,   408,  2095,
     369,   408,   408,   408,    84,    93,   817,  2836,   150,   820,
      86,    98,   408,   765,  2059,   767,   182,  1794,  2108,   267,
     176,   773,  1799,   255,    93,    93,   408,   259,   364,   311,
     364,  2127,  2108,  2719,   218,  2108,    18,  2108,    18,   414,
     395,   367,   344,   414,   200,   408,   382,  2069,   414,   801,
     408,   374,   406,  2075,  2076,   287,  2661,   409,   134,  2108,
      78,   150,  2891,   295,   342,   817,   818,   819,   409,   821,
     226,  2307,  2224,   342,  2163,   414,   319,  2166,  2230,   155,
    2316,   892,   893,  2128,  2129,   202,   408,  2109,   342,   344,
     901,   902,  2114,   904,  2116,   408,   408,   173,   909,  2002,
    2163,   187,   347,  2166,  2126,   230,   414,  2196,   216,   409,
    2155,  2309,  2310,  2311,  2312,   414,   268,   262,  2796,   232,
     409,  2166,   406,    40,   409,   357,   402,   408,   217,  2734,
     224,   224,   259,  2196,  2739,   408,   212,   259,  2743,   344,
     892,   893,   108,   298,   896,   265,   235,   303,   337,   193,
     384,   395,  2838,   360,   220,   406,   344,   313,   344,   395,
     182,   267,   271,    93,   916,   385,  2069,   919,   194,  2774,
     922,   327,  2075,  2076,   303,   395,   396,   397,   334,   399,
     400,   401,   402,   403,   404,    93,  2282,   196,   196,   182,
     409,   943,   414,   409,   387,   387,  2874,   414,    12,   951,
     387,   414,  2224,   242,  1981,   409,  2109,   409,  2230,   961,
     187,    85,   409,   965,  1025,   187,   968,   373,  2307,   295,
     410,   973,   381,   414,   409,   187,   409,  2316,  2833,   981,
     409,   409,  2108,   309,   409,   409,   409,   381,   314,   409,
     409,   409,  2963,   995,   409,   259,   381,   187,  2400,   344,
     408,  1003,  1004,   128,  1006,   408,  2942,   131,   409,   292,
     409,   395,   338,   395,   340,   411,    36,  1019,  2873,   409,
     144,   414,   409,   349,   298,   411,   409,    78,   408,   403,
     408,   298,   344,   344,   220,   361,   362,   161,  1040,    90,
    2386,  2387,   220,   409,   383,   384,    97,   386,   387,   406,
     243,   102,   267,   392,  1056,   394,   409,   409,   354,  2108,
     337,   400,  2998,  1124,   372,   189,   972,   408,   414,   193,
     267,   344,   364,   395,  1135,   409,   409,   171,  2350,   414,
     171,   406,   409,   168,  2379,  2380,   187,    78,   116,   182,
     414,   193,   409,   395,   409,   409,   409,   385,   408,   344,
     409,   408,   226,  1164,  1165,   408,   354,  2962,   409,  1015,
    2456,  2138,  2451,   344,   414,  1176,   220,  2144,  1179,   157,
     220,  2393,   407,  1184,  1185,   224,   408,   182,  2400,   271,
    2425,   206,   192,  2405,  2406,  2407,  2408,  2409,  2451,   225,
    2995,   187,   408,   408,   262,   269,   409,   198,   409,   409,
     223,   202,   409,   408,   274,   409,   409,   408,   223,   408,
     108,   195,  1164,  1165,   408,   152,   207,   259,   407,   220,
     221,   259,   189,   189,  1176,   187,  1237,   364,  1239,   164,
     231,   173,  1184,  1185,   409,   151,   310,   151,   408,   187,
     267,   315,  1253,  1195,   313,   344,  1257,  2350,   259,   182,
     270,  2603,   408,   408,   255,   223,   408,   258,   295,    93,
     259,   238,   291,   337,   267,   265,   408,   265,   269,   414,
     271,   409,   259,   267,   408,   349,  2565,    96,   182,    93,
    2569,   267,   127,   210,  2573,  1237,   259,  1239,  2584,   363,
    2393,   164,   267,   267,   408,   210,   160,   361,   307,   155,
     308,   414,   308,   213,   173,    82,   291,   408,   220,   409,
    1358,  2607,  2608,   294,  1266,  2135,  2612,    78,  2001,  1185,
    2002,  2079,   323,  1275,  1780,  2445,  2448,  1717,  2633,    90,
    2373,  2046,  2462,  2930,  2954,  2910,    97,  2314,  2315,   134,
    2909,   102,  2935,    73,  2788,  2864,    76,  1372,  2593,  1301,
     713,  2450,  1766,  3010,  2599,  2984,  2618,  2617,    88,    89,
     155,  2657,  2108,  1374,  2965,  1360,  2662,  3011,   178,    78,
    2666,   811,  1052,  1447,  2206,  2873,  2158,  2479,   173,  1780,
    2056,  2603,   112,  2851,   385,  2672,  1059,  2974,    97,  2000,
    3009,  1605,  1771,   102,   395,   396,   397,   127,   399,   400,
     401,   402,   403,   404,   156,  1032,  2197,  1823,  2013,  2473,
    1212,  1211,  2022,   414,  1602,   145,  1272,   212,  2316,  2834,
    2443,  1333,  1374,  2281,  1485,  1552,  1282,  2571,  2542,  1962,
    1860,  2587,  2897,  2007,  2482,  2412,  2702,   198,  1658,  1004,
     951,   202,   899,  1395,  1251,  2734,   595,  1399,  1655,   303,
    2739,    73,  1404,  1219,  2743,  2432,   304,   643,  1629,   220,
     221,  1472,  2439,   926,   895,  1057,  1044,  1832,  1664,  2475,
     231,  1830,  1424,  2337,  1426,  1427,  1668,  1333,  1163,   584,
    1415,   211,  1434,   901,  1827,     2,    -1,    -1,    -1,   198,
      -1,    -1,    -1,   202,   255,    -1,    -1,   258,    -1,    -1,
     295,  1357,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,
     271,   220,   221,    -1,   309,    -1,    -1,    -1,    -1,   314,
      -1,    -1,   231,    -1,    -1,    -1,  2815,    -1,    -1,    -1,
    1482,    -1,  1388,   134,    -1,    -1,  1392,    -1,    -1,    -1,
      -1,    -1,    -1,   338,  2833,   340,  1498,    -1,    -1,   258,
    2986,    -1,  2815,    -1,   349,    -1,    -1,    -1,    -1,    -1,
     269,    -1,   323,    -1,    -1,    -1,   361,   362,  1579,   170,
      -1,    -1,    -1,   303,    -1,    -1,  2553,  2554,  2555,  2556,
      -1,   182,  2878,    -1,    -1,    -1,   187,    -1,  2940,  2941,
      -1,   192,   193,    -1,   195,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2900,  2901,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   323,   216,    -1,  1569,  2863,    -1,
      -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,
      -1,   232,    -1,    -1,   395,   396,   397,    85,   399,   400,
     401,   402,   403,   404,  1655,    -1,    -1,    95,   409,  1601,
      -1,    -1,    -1,  1664,  1606,  1666,    -1,  1668,    -1,    -1,
      -1,    -1,    -1,   264,    -1,   113,    -1,    -1,    -1,    -1,
    1526,   272,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,  2974,    -1,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,   144,  2986,    -1,    -1,
      -1,   972,    -1,  1655,    -1,    -1,  1658,    -1,    -1,    -1,
      -1,    -1,    -1,   161,    -1,    -1,    -1,    -1,  2940,  2941,
    3009,  1673,  1674,    -1,  1735,  1677,    -1,    -1,    -1,    -1,
      -1,  1683,  1743,    -1,  1686,  1746,   337,    -1,    -1,  1750,
      -1,   189,    -1,    -1,  1015,   193,    -1,  1758,  1700,  1701,
    1702,  1703,  1704,  1705,    -1,   356,    -1,   205,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1717,  1718,  1719,  1720,  1721,
      -1,  1723,    -1,  1725,   375,  1727,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1798,    -1,    -1,
      -1,    -1,  1744,  1745,    -1,    -1,    -1,    -1,    -1,  2776,
      -1,    -1,    -1,    -1,    -1,    -1,  1758,    78,   409,   410,
     411,    -1,    -1,    -1,  2791,    -1,    -1,    -1,    -1,    90,
      -1,   269,    -1,    -1,  1776,    -1,    97,  1779,    -1,    -1,
      -1,   102,    78,    -1,    -1,    -1,    -1,  2814,  1790,  1695,
      -1,    -1,   290,  1795,    90,    -1,    -1,    -1,    -1,    -1,
    1802,    97,    -1,    -1,    -1,   585,   102,    -1,   588,    -1,
    1812,   309,   310,    -1,    -1,    -1,    -1,   315,  2845,    -1,
     600,    -1,    -1,    -1,  1826,    -1,  1828,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1740,    -1,  1742,    -1,  1840,   337,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1756,   349,    -1,    -1,    -1,    -1,   354,    -1,  1179,    -1,
      -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   372,   655,    -1,   198,    -1,   659,
      -1,   202,    -1,   663,    -1,    -1,    -1,   667,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   220,
     221,    -1,   198,    -1,  1810,    -1,   202,    -1,    -1,    -1,
     231,    -1,   692,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1923,    -1,    -1,   220,   221,    -1,    -1,    -1,    -1,
    1932,    -1,   134,    -1,   255,   231,    -1,   258,    -1,    -1,
      -1,  2002,    -1,    -1,   724,    -1,   202,   727,   269,    -1,
     271,  1272,    -1,   733,    -1,    -1,    -1,    -1,    -1,   255,
      -1,  1282,   258,  1965,   220,    -1,    -1,    -1,   170,    -1,
      -1,    -1,    -1,   269,    -1,   271,    -1,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,   187,    -1,    -1,    -1,    -1,
     192,   193,    -1,   195,    -1,    -1,    -1,    -1,    -1,   255,
    2002,    -1,   323,    -1,    -1,  2007,    -1,    -1,    -1,    -1,
      -1,    -1,  1333,   269,   216,    -1,  2018,    -1,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,
     232,    -1,  2093,  2035,  2095,   815,  1357,   817,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2049,  2109,    -1,
      -1,    -1,    -1,   833,    -1,  2116,    -1,  2059,    -1,    -1,
      -1,    -1,   264,    -1,   385,  2126,  2127,  1388,    -1,    -1,
     272,  1392,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,   407,    -1,  2090,   385,
      -1,    78,    -1,    -1,    -1,   416,    -1,    -1,    -1,   395,
     396,   397,    -1,   399,   400,   401,   402,   403,   404,    -1,
      97,    -1,    -1,    -1,  2116,   102,    -1,    -1,   414,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2128,  2129,    -1,   385,
      -1,    -1,    -1,    -1,    -1,   337,    -1,    -1,    -1,   395,
     396,   397,    -1,   399,   400,   401,   402,   403,   404,    -1,
    2056,    -1,    -1,  2155,   356,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2166,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2078,   375,   954,    -1,    -1,    -1,   958,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2188,    -1,    -1,    -1,
      -1,    -1,   972,    -1,    -1,  2197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2109,  2206,  1526,    -1,   409,   410,   411,
      -1,   198,    -1,    -1,    -1,   202,    -1,  2219,   972,    -1,
      -1,  2282,    -1,    -1,    -1,  1005,    -1,    -1,    -1,    -1,
    2232,    -1,    -1,   220,   221,  1015,  2142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,  2153,    -1,    -1,
      -1,    -1,  2158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1015,    -1,    -1,  2170,    -1,  2172,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,  2350,
    1070,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2217,  1092,    -1,    -1,  2317,    -1,    -1,    -1,  2321,
    2322,    -1,    -1,    -1,    -1,  2386,  2387,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2241,   323,  1117,  1118,    -1,
    1120,  1121,  1122,    -1,  2405,  2406,  2407,  2408,  2409,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1138,    -1,
    2362,  2363,  2268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1695,    -1,    -1,  2379,  2380,    -1,
      -1,    -1,    -1,    -1,  1164,  1165,    -1,    -1,    -1,    -1,
      -1,    -1,  2298,    -1,    -1,  2456,    -1,    -1,   385,  1179,
      -1,    -1,    -1,  2405,  2406,  2407,  2408,  2409,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,  1740,
      -1,  1742,    -1,  2425,    -1,    -1,  1206,    -1,    -1,  1209,
    1210,    -1,    -1,    -1,    -1,  1756,  1216,    -1,  1218,  1219,
      -1,  2443,    -1,  2445,    -1,    -1,  2448,    -1,  2450,    -1,
      -1,    -1,    -1,    -1,    -1,  2457,    -1,  1237,    -1,    -1,
    2462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2479,    -1,    -1,
      -1,    -1,    -1,    -1,  1264,    -1,    -1,    -1,    -1,  1810,
      -1,  1271,  1272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   972,  1282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1272,    -1,
      -1,    -1,    -1,  2584,    -1,    -1,    -1,    -1,  1282,    -1,
      -1,  2437,    -1,    -1,    -1,    -1,    -1,    -1,  1318,    -1,
      -1,    -1,    -1,    -1,  1015,    -1,  2607,  2608,    -1,    -1,
      -1,  2612,    -1,  1333,    -1,    -1,    -1,  2559,    -1,    -1,
    2562,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      -1,    -1,    -1,    -1,  2576,    -1,    -1,  1357,    -1,  1333,
      -1,    -1,    -1,    -1,    -1,  2587,    -1,    -1,    97,  2591,
      -1,  2593,    -1,   102,    -1,    -1,  2657,  2599,    -1,    -1,
      -1,  2662,  2604,  1357,    -1,  2666,  1386,    -1,  1388,    -1,
      -1,    -1,  1392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1388,    -1,  2542,    -1,  1392,    -1,
      -1,    -1,    -1,    -1,    -1,  1425,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2661,
     169,    -1,    -1,    -1,  2666,    -1,    -1,    -1,  1448,  1449,
      -1,    -1,    -1,    -1,    -1,    -1,  1456,    -1,    -1,  1459,
    1460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,
      -1,    -1,  1472,   202,    -1,    -1,    -1,    -1,    -1,  1479,
      -1,    -1,    -1,  1483,  1484,  1485,    -1,  1487,    -1,    -1,
      -1,   220,   221,    -1,  1494,  1495,    -1,    -1,    -1,    -1,
      -1,  1501,   231,    -1,    -1,    -1,    -1,    -1,  2730,    -1,
    2732,    -1,    -1,    -1,    -1,  2056,    -1,    -1,    -1,    -1,
      -1,    -1,  2744,    -1,  2746,    -1,  1526,  1527,  1528,   258,
    1530,  1531,    -1,    -1,    -1,  1535,    -1,  2078,    -1,  1539,
     269,    -1,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,  1551,  1526,    -1,    -1,  1555,    -1,    -1,    -1,  1559,
    2782,  2783,    -1,    -1,    76,    -1,    -1,    -1,  2109,    -1,
      -1,    -1,    -1,    -1,  2796,    -1,    -1,    89,  2800,    -1,
      -1,  1272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1282,    -1,  2719,   323,    -1,    -1,  2878,    -1,  1599,
     112,  2142,    -1,    -1,  2826,    -1,    78,    -1,    -1,    -1,
      -1,    -1,  2153,    -1,  2836,    -1,    -1,  2158,    90,  2900,
    2901,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,  2170,
     102,  2172,  1632,    -1,  1634,    -1,    -1,    -1,    -1,    -1,
      -1,  2863,  1333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2873,  2874,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,  2891,
     399,   400,   401,   402,   403,   404,  2217,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,
      -1,    -1,    -1,    -1,  2916,  1695,    -1,  1388,    -1,   211,
    2241,  1392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2838,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1695,    -1,  2945,    -1,    -1,   198,  2268,  2950,    -1,
     202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1740,  2963,  1742,    -1,    -1,    -1,    78,    -1,   220,   221,
      -1,    -1,    -1,    -1,  1754,    -1,  1756,  2298,    -1,   231,
      -1,    -1,  2984,    -1,    -1,    97,  1740,    -1,  1742,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1756,   255,    -1,    -1,   258,    -1,  3010,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1810,    -1,    -1,    -1,    -1,    -1,  2942,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1526,  1810,   169,    -1,    -1,
      -1,    -1,  1842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1859,
      -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
     202,    -1,  2998,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   220,   221,
    1890,  1891,  1892,  1893,  1894,    -1,  2437,    -1,    -1,   231,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1909,
    1910,  1911,  1912,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1922,   395,   396,   397,   258,   399,   400,   401,
     402,   403,   404,    -1,  1934,    -1,    -1,   269,    -1,  1939,
      -1,    -1,   414,    -1,    -1,    -1,    -1,    -1,    -1,  1949,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
    1960,  1961,    -1,  1963,    -1,    -1,    -1,  1967,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,  1987,    -1,  1989,
    1990,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2542,    -1,    -1,  1695,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2013,    -1,    -1,    -1,    -1,    -1,    -1,
    2020,  2021,  2022,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2045,    -1,    -1,    -1,  1740,
     169,  1742,    -1,   385,    -1,    -1,  2056,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1756,    -1,   399,   400,   401,
     402,   403,   404,   585,    -1,    -1,   588,    -1,  2078,   198,
      -1,    78,  2056,   202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,   220,   221,    -1,  2078,   102,    -1,    -1,  2108,  2109,
      -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,  1810,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2109,    -1,    -1,    -1,   258,
      -1,    -1,  2142,   655,    -1,    -1,    -1,   659,    -1,    -1,
     269,   663,    -1,  2153,    -1,   667,    -1,    -1,  2158,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2142,    -1,
    2170,    -1,  2172,    -1,    -1,    -1,    -1,    -1,  2719,  2153,
     692,    -1,    -1,    -1,  2158,    -1,  2186,    -1,    78,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2170,    -1,  2172,    -1,
      -1,   198,    -1,    -1,   323,   202,    -1,    97,  2208,    -1,
      -1,    -1,   102,    -1,  2214,   727,    -1,  2217,    -1,    -1,
      -1,   733,    -1,   220,   221,    -1,  2226,    -1,  2228,    -1,
      -1,    -1,    -1,  2233,   231,    -1,    -1,    -1,    -1,    -1,
      -1,  2241,  2242,  2217,    -1,  2245,  2246,  2247,  2248,  2249,
    2250,  2251,  2252,  2253,  2254,    -1,    -1,    -1,   255,  2259,
    2260,   258,    -1,    -1,    -1,    -1,   385,  2241,  2268,    -1,
      -1,    -1,   269,  2273,   271,    -1,  2276,    -1,    -1,   169,
     399,   400,   401,   402,   403,   404,    -1,    -1,  2288,  2289,
    2290,    -1,  2292,    -1,  2268,    -1,    -1,  2838,  2298,  2299,
      -1,    -1,    -1,   815,  2304,    -1,    -1,  2307,   198,    -1,
      -1,    -1,   202,    -1,    -1,    -1,  2316,    -1,    -1,    -1,
      -1,   833,    -1,    -1,  2298,    -1,   323,    -1,    -1,    -1,
     220,   221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,  2342,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,  2056,    -1,    -1,   258,   102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2078,   385,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   395,   396,
     397,  2942,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,  2109,    -1,
      81,    -1,    -1,    -1,    -1,    -1,  2426,    88,    -1,    -1,
      -1,    -1,    -1,   323,    -1,    -1,    -1,  2437,    -1,    -1,
      -1,    -1,   954,    -1,    -1,    -1,   958,    -1,    -1,    -1,
      -1,  2142,    -1,    -1,    -1,    -1,    -1,  2998,    -1,    -1,
     972,    -1,  2153,  2437,    -1,   198,   127,  2158,    -1,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2170,
      -1,  2172,  2482,    -1,   145,    -1,    -1,   220,   221,    -1,
      -1,    -1,  2492,  1005,    -1,   385,    -1,   158,   231,    -1,
      -1,   972,    -1,  1015,    -1,    -1,    -1,    -1,    -1,   399,
     400,   401,   402,   403,   404,   176,    -1,   178,    -1,    -1,
      -1,    -1,   255,    -1,    -1,   258,  2217,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,    -1,
      -1,    -1,  2542,    -1,  1015,    -1,  2546,  2547,  2548,    -1,
    2241,  2551,    -1,    -1,    -1,    -1,    -1,    -1,  1070,    -1,
      -1,    -1,    -1,    -1,    -1,  2565,    -1,    -1,  2542,  2569,
      -1,    -1,    -1,  2573,    -1,    85,    -1,  2268,    -1,  2579,
    1092,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   113,    -1,  1117,  1118,  2298,  1120,  1121,
    1122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,
      -1,   131,    -1,    -1,    -1,    -1,  1138,    -1,    -1,    -1,
      -1,    -1,  2632,    -1,   144,    -1,    -1,    -1,    -1,    -1,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   161,   385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2661,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1206,   205,    -1,  1209,  1210,    -1,
      -1,    -1,  2702,    -1,    -1,    -1,  1218,  1219,    -1,    -1,
      -1,  2711,    -1,  2713,    -1,    -1,   226,    -1,    -1,  2719,
      -1,    -1,    -1,  2723,    -1,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,  2739,
      -1,    -1,    -1,  2743,    -1,  2719,  2437,    -1,    -1,  2749,
    2750,    -1,  1264,  2753,    -1,    -1,    -1,    -1,    -1,   269,
    1272,   271,    -1,    -1,   972,    -1,    -1,    -1,    -1,    -1,
    1282,    -1,    -1,    -1,  2774,    -1,    -1,    -1,    -1,    -1,
     290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2797,    -1,    -1,
     310,  1272,    -1,    -1,    -1,   315,  1318,  1015,    -1,    -1,
      -1,  1282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2819,
      -1,  1333,    -1,    -1,    -1,    -1,    -1,   337,   338,  2829,
     340,    -1,    -1,  2833,    -1,    -1,    -1,    -1,  2838,   349,
      -1,    -1,    -1,   353,   354,  1357,    -1,   357,    -1,    -1,
      -1,  2542,    -1,   363,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1333,    -1,  2838,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2873,  1386,    -1,  1388,  2877,    -1,    -1,
    1392,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2897,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1425,    -1,    -1,    -1,  1388,    -1,    -1,
      -1,  1392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1448,  1449,    -1,   600,
      -1,    -1,  2942,    -1,  1456,    -1,    -1,  1459,  1460,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
      -1,    -1,  2962,    -1,    -1,    -1,    -1,  1479,  2942,    90,
      -1,  1483,  1484,  1485,    -1,  1487,    97,    -1,    -1,    -1,
      -1,   102,  1494,  1495,    -1,    -1,    -1,    -1,    -1,  1501,
      -1,    -1,    -1,    -1,    -1,  2995,    -1,    -1,  2998,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1526,  1527,  1528,    -1,  1530,  1531,
      -1,    -1,    -1,  1535,  2998,    -1,    -1,  1539,  2719,    -1,
    1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,
      -1,    -1,    -1,  1555,    -1,    -1,    -1,  1559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1526,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1272,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1282,    -1,    -1,   198,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,  1599,    -1,    -1,
      -1,    -1,   753,    -1,   755,    -1,   757,    -1,    -1,   220,
     221,    -1,   763,   764,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
    1632,    -1,  1634,    -1,    -1,  1333,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   255,    -1,    97,   258,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,  2838,   269,  1357,
     271,    -1,    -1,    -1,    -1,    -1,   817,    -1,    -1,   820,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,    -1,    -1,
    1388,    -1,    -1,  1695,  1392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,    -1,    -1,   972,    -1,   169,    -1,
      -1,    -1,    -1,    -1,   875,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1695,    -1,    -1,    -1,  1740,    -1,
    1742,   892,   893,    -1,    78,    -1,    -1,   198,    -1,    -1,
      -1,   202,  1754,    -1,  1756,    -1,    90,    -1,   909,  1015,
      -1,  2942,    -1,    97,    -1,    -1,    -1,    -1,   102,   220,
     221,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,  1740,
     231,  1742,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,  1756,    -1,    -1,   409,    -1,
      -1,    -1,    78,    -1,    -1,    -1,    -1,   258,  1810,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,  2998,   269,    -1,
     137,    97,    -1,    -1,    -1,    -1,   102,    -1,  1526,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1810,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1859,   175,    -1,
      -1,    -1,    -1,    -1,   198,   182,    -1,    -1,   202,    -1,
      -1,    -1,   323,    -1,  1025,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   220,   221,  1890,  1891,
    1892,  1893,  1894,    -1,    -1,   212,   213,   231,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1909,  1910,  1911,
    1912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1922,   255,   198,    -1,   258,    -1,   202,    -1,    -1,    -1,
      -1,    -1,  1934,    -1,   385,   269,    -1,  1939,    -1,    -1,
      -1,    -1,    -1,    -1,   220,   221,    -1,  1949,   399,   400,
     401,   402,   403,   404,    -1,   231,    -1,    -1,  1960,  1961,
      -1,  1963,    -1,    -1,    -1,  1967,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1124,    -1,    -1,    -1,    -1,    -1,   255,
      -1,    -1,   258,    -1,  1135,  1987,    -1,  1989,  1990,   323,
      -1,    -1,    -1,   269,    -1,   271,    -1,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2013,    -1,  1164,  1165,    -1,  1272,    -1,  2020,  2021,
    2022,    -1,    -1,    -1,    -1,  1176,  1282,    -1,  1179,    -1,
      -1,    -1,    -1,  1184,  1185,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1740,  2045,  1742,    -1,    -1,   323,    -1,    -1,
      -1,   385,    -1,    -1,  2056,    -1,    -1,    -1,  1756,    -1,
      -1,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,    -1,    -1,  2078,  1333,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1237,    -1,  1239,    -1,
      -1,    -1,    -1,    -1,    -1,  2056,    -1,    -1,  1249,    -1,
      -1,  1357,    -1,    -1,    -1,    -1,  2108,  2109,    -1,   385,
      -1,    -1,  1810,    -1,    -1,    -1,    -1,  2078,    -1,   395,
     396,   397,    -1,   399,   400,   401,   402,   403,   404,    -1,
      -1,    -1,  1388,   409,    -1,    -1,  1392,    -1,    -1,    -1,
    2142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2109,    -1,
      -1,  2153,    -1,    -1,    -1,    -1,  2158,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2170,    -1,
    2172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2142,    -1,    -1,  2186,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2153,    -1,    -1,    -1,    -1,  2158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2208,    -1,    -1,  2170,
      -1,  2172,  2214,    -1,    -1,  2217,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1374,  2226,    -1,  2228,    -1,    -1,    -1,
      -1,  2233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2241,
    2242,    -1,    -1,  2245,  2246,  2247,  2248,  2249,  2250,  2251,
    2252,  2253,  2254,    -1,    -1,    -1,  2217,  2259,  2260,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2268,    -1,    -1,    -1,
    1526,  2273,    -1,    -1,  2276,    -1,    -1,    -1,    -1,    -1,
    2241,    -1,    -1,    -1,    -1,    -1,  2288,  2289,  2290,    -1,
    2292,    -1,    -1,    -1,    -1,    -1,  2298,  2299,    -1,    -1,
      -1,    -1,  2304,    -1,    -1,  2307,    -1,  2268,    -1,    -1,
    1461,    -1,  1463,    -1,  2316,    -1,  1467,    -1,    -1,    -1,
      -1,  1472,  1473,    -1,    -1,    -1,    -1,    -1,    -1,  1480,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2298,    -1,  1490,
    2342,  1492,    -1,    -1,    -1,    -1,   663,   664,    -1,   666,
     667,    -1,    -1,    -1,    -1,   672,   673,    -1,  2056,    -1,
      -1,    -1,    -1,  1514,    -1,  1516,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   691,   692,    -1,    -1,    -1,    -1,
    2078,   698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   709,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   726,
     727,  2109,    -1,    -1,    -1,    -1,   733,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2426,    -1,    -1,    -1,  1579,    -1,
     747,    -1,    -1,    -1,    -1,  2437,    -1,    -1,    -1,  1695,
     972,    -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2153,    -1,    -1,    -1,    -1,
    2158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2170,   790,  2172,    -1,  2437,    -1,    -1,   796,
    2482,    -1,    -1,  1015,  1740,    -1,  1742,   804,    -1,    -1,
    2492,    -1,    -1,    -1,    -1,    -1,    -1,   137,  1649,    -1,
    1756,    -1,    -1,    -1,  1655,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1664,    -1,   832,    -1,    -1,    -1,  2217,
     837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   849,    -1,    -1,   175,    -1,    -1,    -1,    -1,
    2542,    -1,   182,  2241,  2546,  2547,  2548,    -1,    -1,  2551,
      -1,    -1,    -1,    -1,  1810,  1706,    -1,    -1,  1709,  1710,
      -1,    -1,    -1,  2565,    -1,    -1,    -1,  2569,    -1,    -1,
    2268,  2573,   212,   213,    -1,    -1,    -1,  2579,    -1,    -1,
      -1,  2542,    -1,    -1,    -1,  1736,    -1,    -1,    -1,    -1,
      -1,    -1,  1743,    -1,    -1,  1746,    -1,    -1,    -1,  1750,
    2298,    -1,    -1,    -1,    -1,    -1,    -1,  1758,    -1,    -1,
      -1,    -1,  1763,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1775,    -1,   943,    -1,    -1,    -1,
    2632,    -1,    -1,    -1,    -1,    -1,   953,   954,    -1,    -1,
      -1,   958,    -1,    -1,    -1,    -1,    -1,  1798,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2661,
      -1,    -1,    -1,    -1,   981,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1000,  1001,    -1,  1003,    -1,  1005,    -1,
    1007,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2702,    -1,  1019,    -1,    -1,    -1,    -1,  1858,    -1,  2711,
      -1,  2713,    -1,    -1,    -1,    -1,    -1,  2719,    -1,    -1,
      -1,  2723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2734,    -1,  1051,    -1,    -1,  2739,    -1,  2437,
    1272,  2743,    -1,    -1,    -1,    -1,    -1,  2749,  2750,    -1,
    1282,  2753,    -1,    -1,    -1,    -1,    -1,    -1,  2719,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2774,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2797,    -1,    -1,    -1,    -1,
    2056,  1333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2819,    -1,    -1,
      -1,    -1,  2078,    -1,    -1,  1357,    -1,  2829,    -1,    -1,
      -1,  2833,    -1,    -1,    -1,    -1,  2838,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2542,  1996,    -1,    -1,    -1,    -1,
      -1,  2002,    -1,  2109,    -1,    -1,  1388,    -1,    -1,    -1,
    1392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2873,    -1,    -1,    -1,  2877,  1193,  2838,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2897,    -1,  2153,    -1,    -1,
      -1,    -1,  2158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2170,    -1,  2172,    -1,  2069,    -1,
      -1,    -1,    -1,    -1,  2075,  2076,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2942,    -1,    -1,    -1,  2095,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2109,    -1,
    2962,  2217,    -1,  2114,   815,  2116,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2126,  2127,    -1,    -1,    -1,
      -1,  2942,  1299,    -1,    -1,  2241,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2995,  1526,    -1,  2998,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2719,    -1,   663,   664,    -1,   666,   667,    -1,    -1,
      -1,    -1,   672,   673,    -1,    -1,    -1,  2998,    -1,    -1,
      -1,    -1,  2298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   691,   692,    -1,    -1,    -1,    -1,    -1,   698,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   709,
      -1,    -1,    -1,  2224,    -1,    -1,  1393,  1394,    -1,  2230,
      -1,    -1,  1399,    -1,    -1,    -1,   726,   727,    -1,    -1,
      -1,    -1,    -1,   733,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   747,  1425,    -1,
      -1,  1428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1447,  2282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2838,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     790,    -1,    -1,    -1,    -1,    -1,   796,    -1,    -1,    -1,
      -1,    -1,    -1,  1695,   804,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
      -1,  2437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,   832,    -1,    -1,    -1,    97,   837,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,  1740,   849,
    1742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1070,
      -1,    -1,    -1,    -1,  1756,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2386,  2387,  1554,    -1,    -1,
      -1,  1092,    -1,    -1,  2942,    -1,    -1,    -1,    -1,  2400,
      -1,    -1,    -1,    -1,  2405,  2406,  2407,  2408,  2409,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1117,  1118,    -1,  1120,
    1121,  1122,    -1,    -1,    -1,    -1,    -1,    -1,  1810,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2542,  1138,  1605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
    2998,   202,    -1,   943,    -1,  2456,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   953,   954,    -1,    -1,    -1,   958,   220,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   255,  1206,    -1,   258,  1209,  1210,
    1000,  1001,    -1,  1003,    -1,  1005,    -1,  1007,   269,    -1,
     271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1019,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,  1051,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,   323,    -1,    -1,    -1,    -1,  1744,  1745,    -1,
      -1,    -1,    -1,  2584,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2603,    -1,    -1,    -1,  2607,  2608,    -1,    -1,
      -1,  2612,    -1,  2719,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,
      -1,    -1,  1799,    -1,   385,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,  2657,    -1,   409,    -1,
      -1,  2662,    -1,    -1,   198,  2666,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,  2056,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1386,   220,   221,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2078,   231,    -1,    -1,
      -1,    -1,    -1,  1193,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   255,    -1,    -1,   258,    -1,    -1,  2109,    -1,    -1,
      -1,    -1,  2838,    -1,    -1,   269,    -1,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1456,    -1,    -1,    -1,  1460,
    2142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2153,    -1,    -1,    -1,    -1,  2158,    -1,  1479,    -1,
      -1,   972,  1483,    -1,  1485,    -1,  1487,    -1,  2170,   323,
    2172,    -1,    -1,  1494,  1495,    -1,    -1,    -1,    -1,    -1,
    1501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1299,
      -1,    -1,    -1,    78,  1981,    -1,    -1,    -1,    -1,    -1,
    1987,    -1,    -1,    -1,  1015,    90,  1527,    -1,    -1,    -1,
    1531,    -1,    97,    -1,  1535,  2217,  2942,   102,  1539,    -1,
      -1,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
    1551,   385,    -1,    -1,  1555,    -1,    -1,    -1,    -1,  2241,
      -1,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,    -1,   409,    -1,  2878,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2268,    -1,    -1,    -1,
      -1,    -1,  2998,    -1,    -1,    -1,    -1,    -1,    -1,  2900,
    2901,    -1,    -1,  1393,  1394,    -1,    78,    -1,    -1,  1399,
      -1,    -1,    -1,    -1,    -1,    -1,  2298,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,   198,    -1,  1425,    -1,   202,  1428,  2940,
    2941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1438,    -1,
      -1,    -1,    -1,    -1,    -1,   220,   221,  1447,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,
      -1,  2138,    -1,    -1,    -1,    -1,   663,  2144,    -1,    -1,
     667,    -1,    -1,    -1,    -1,    -1,  1687,    -1,  2155,    -1,
     255,    -1,    -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,   692,   271,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2186,
      -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
     202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     727,    -1,    -1,    -1,    -1,    -1,   733,    -1,   220,   221,
      -1,    -1,  2219,  1754,    -1,  2437,    78,    -1,   323,   231,
      -1,    -1,    -1,    -1,  1554,    -1,    -1,    -1,    90,    -1,
      -1,    93,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,  1272,    -1,   255,    -1,    -1,   258,    -1,    -1,    -1,
      -1,  1282,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1605,    -1,    -1,    -1,    -1,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   815,    -1,
     395,   396,   397,    -1,   399,   400,   401,   402,   403,   404,
      -1,  1842,  1333,    -1,   409,    -1,    -1,  2314,  2315,  2316,
      -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,  1859,    -1,
    2542,    -1,    -1,    78,    -1,    -1,  1357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,   198,    -1,    -1,    94,
     202,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,  1893,    -1,    -1,    -1,    -1,  1388,   220,   221,
      -1,  1392,    -1,    -1,    -1,    -1,    -1,    -1,  1909,   231,
    1911,  1912,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1922,    -1,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,   255,    -1,   407,   258,    -1,    -1,    -1,
      -1,    -1,    -1,   158,    -1,  2412,    -1,   269,    -1,   271,
      -1,    -1,    -1,    -1,  1744,  1745,    -1,    -1,    -1,    -1,
    1961,    -1,  1963,    -1,    -1,  2432,  1967,   954,    -1,    -1,
      -1,   958,  2439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   198,    -1,   972,    -1,   202,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,    -1,  1794,   220,   221,    -1,    -1,  1799,
      -1,    -1,  2013,    -1,    -1,    -1,   231,    -1,  1005,  2020,
    2021,  2022,    -1,    -1,    -1,    -1,    -1,    -1,  1015,    -1,
      -1,    -1,    -1,    -1,    -1,  1526,    -1,  2719,    -1,    -1,
     255,    -1,    -1,   258,  2045,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,   271,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,  1070,    -1,    -1,  2553,  2554,  2555,  2556,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,  2565,    -1,
      -1,    -1,  2569,    90,    -1,  1092,  2573,    -1,   323,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1117,  1118,    -1,  1120,  1121,  1122,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,
      -1,  1138,    -1,    -1,    -1,    -1,  2838,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     395,   396,   397,    -1,   399,   400,   401,   402,   403,   404,
      -1,  1981,    -1,    -1,  2661,   182,    -1,  1987,    -1,    -1,
     187,    -1,    -1,    -1,  1695,    -1,    -1,  2208,    -1,    -1,
      -1,   198,    -1,  2214,    -1,   202,    -1,    -1,    -1,  1206,
      -1,    -1,  1209,  1210,    -1,  2226,    -1,  2228,    -1,    -1,
      -1,    -1,  2233,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,  1740,
      -1,  1742,    -1,    -1,    -1,    -1,    -1,    -1,  2259,  2260,
    2942,    -1,    -1,    -1,    -1,  1756,    -1,  2734,   255,    -1,
      -1,   258,  2739,    -1,    -1,  2276,  2743,    -1,    -1,    -1,
      -1,    -1,   269,    -1,   271,  1272,    -1,    -1,    -1,  2290,
      -1,  2292,    -1,    -1,    -1,  1282,    -1,    -1,  2299,    -1,
      -1,    -1,    -1,  2304,    -1,    -1,  2307,  2774,    -1,  2776,
      -1,    -1,    -1,    -1,    -1,    -1,  2998,    -1,    -1,  1810,
      -1,    -1,    -1,    -1,  2791,    -1,    -1,    -1,    -1,  2796,
      -1,    -1,    -1,  2800,    -1,    -1,   323,    -1,    -1,    -1,
      -1,  2342,    -1,    -1,    -1,    -1,  1333,  2814,  2138,    -1,
      -1,    -1,    -1,    -1,  2144,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2155,  2833,    -1,    -1,    -1,
    1357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2845,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2186,    -1,   385,  1386,
      -1,  1388,    -1,    -1,    -1,  1392,  2873,  2874,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2219,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1425,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2916,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1448,  1449,    -1,    -1,    -1,    -1,    -1,    -1,  1456,
      -1,    -1,  1459,  1460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2482,    -1,  2950,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2492,  1479,    -1,    -1,  2962,  1483,  1484,  1485,    -1,
    1487,    -1,    -1,    -1,    -1,    -1,    -1,  1494,  1495,    -1,
      -1,    -1,    -1,    -1,  1501,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2314,  2315,  2316,    -1,  2995,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1526,
    1527,    -1,    -1,  1530,  1531,    -1,  2547,  2548,  1535,    -1,
    2551,    -1,  1539,    -1,    -1,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,  1550,  1551,  2056,    -1,    78,  1555,    -1,
      -1,    -1,  1559,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    93,    -1,    -1,    -1,    97,  2078,    -1,    -1,
      -1,   102,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,  2109,    -1,
      -1,    -1,  2412,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2632,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2432,    -1,    -1,    -1,    -1,    -1,    -1,  2439,
      -1,  2142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2153,    -1,    -1,    -1,    -1,  2158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2170,
      -1,  2172,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1687,  2702,    -1,    -1,    -1,    -1,    -1,    -1,  1695,   220,
     221,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,
     231,    -1,  2723,    -1,    -1,    -1,  2217,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   255,    -1,   231,   258,    -1,  2750,
    2241,    -1,  2753,  1740,    -1,  1742,    -1,    -1,   269,    -1,
     271,    -1,    -1,  2553,  2554,  2555,  2556,  1754,    -1,  1756,
     255,    -1,    -1,   258,    -1,  2565,    -1,  2268,    78,  2569,
      -1,    -1,    -1,  2573,   269,    -1,   271,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,  2797,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,  2298,    -1,    -1,
      -1,    -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,  2829,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1842,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2661,  1859,    -1,   385,    -1,    -1,    -1,    -1,   364,
      -1,    -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,  2897,    -1,   198,    -1,
     385,    -1,   202,  1890,  1891,  1892,  1893,  1894,    -1,    -1,
     395,   396,   397,    -1,   399,   400,   401,   402,   403,   404,
     220,   221,  1909,  1910,  1911,  1912,    -1,    -1,    -1,    -1,
      -1,   231,    -1,    -1,    -1,  1922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2734,    -1,  2437,  1934,    -1,  2739,
      -1,    -1,  1939,  2743,    -1,   255,    -1,    -1,   258,    -1,
      -1,    -1,  1949,    -1,    -1,    -1,    -1,    -1,    -1,   269,
      -1,   271,    -1,  1960,  1961,    -1,  1963,    -1,    -1,    -1,
    1967,    -1,   282,    -1,  2774,    -1,  2776,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1987,  2791,  1989,  1990,    -1,    -1,  2796,    -1,    -1,    -1,
    2800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   323,  2814,    -1,  2013,    -1,  1139,    -1,
      -1,    -1,    -1,  2020,  2021,  2022,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2833,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2542,    -1,    -1,    -1,  2845,    -1,    -1,  2045,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2056,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2873,  2874,   385,    -1,    -1,    -1,    -1,
      -1,  2078,    -1,    -1,    -1,   395,   396,   397,    -1,   399,
     400,   401,   402,   403,   404,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2109,    -1,    -1,    -1,  2916,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,
    2950,    -1,    -1,    -1,    -1,    -1,  2153,    -1,    -1,    -1,
      -1,  2158,  2962,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2170,    -1,  2172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,  2186,
      -1,    -1,    -1,    -1,    -1,  2995,    -1,    90,    -1,    -1,
      93,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,  2208,    -1,    -1,    -1,    -1,    -1,  2214,  2719,    -1,
    2217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2226,
      -1,  2228,    -1,    -1,    -1,    -1,  2233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2241,  2242,    -1,    -1,  2245,  2246,
    2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,    -1,    -1,
      -1,    -1,  2259,  2260,    -1,    -1,    -1,    -1,    -1,    -1,
      78,  2268,    -1,    -1,    -1,    -1,  2273,    -1,    -1,  2276,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      -1,  2288,  2289,  2290,   102,  2292,    78,    -1,    -1,    -1,
      -1,  2298,  2299,    -1,    -1,   198,    -1,  2304,    90,   202,
    2307,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,  2316,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,
      -1,    -1,    -1,  1454,    -1,    -1,    -1,  2838,   231,    -1,
      -1,    -1,    -1,    -1,    -1,  2342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1478,    -1,    -1,
      -1,    -1,   255,  1484,    -1,   258,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,   187,
      -1,    -1,    -1,  1504,  1505,  1506,  1507,    -1,    -1,  1510,
     198,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1525,    -1,    -1,    -1,    -1,  1530,
      -1,    -1,   220,   221,    -1,    -1,   198,    -1,    -1,    -1,
     202,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,  2426,
     323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   220,   221,
    2437,  2942,    -1,    -1,    -1,    -1,    -1,   255,    -1,   231,
     258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,   271,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   255,    -1,    -1,   258,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2482,    -1,   269,    -1,   271,
      -1,    -1,   385,  1614,    -1,  2492,    -1,  2998,    -1,  1620,
      -1,  1622,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,   323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,    -1,    -1,  2542,    -1,    -1,    -1,  2546,
    2547,  2548,    -1,    -1,  2551,    -1,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2565,    -1,
      -1,    -1,  2569,    -1,    -1,    -1,  2573,   385,    -1,    -1,
      -1,    -1,  2579,    -1,    -1,    -1,    -1,   395,   396,   397,
      -1,   399,   400,   401,   402,   403,   404,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2632,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2661,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1808,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2702,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2711,    -1,  2713,    -1,    -1,    -1,
      -1,    -1,  2719,    -1,    -1,    -1,  2723,    -1,    -1,    -1,
      -1,    -1,  1853,    -1,    -1,    -1,    -1,  2734,    -1,    -1,
      -1,  1862,  2739,  1864,    -1,    -1,  2743,    -1,    -1,    -1,
      -1,    -1,  2749,  2750,    -1,    -1,  2753,    -1,    -1,    -1,
      -1,    -1,  1883,    -1,    -1,    -1,    -1,  1888,    -1,  1890,
    1891,  1892,    -1,  1894,  1895,    -1,    -1,  2774,    -1,  1900,
    1901,    -1,    -1,    -1,    -1,    -1,    -1,  1908,    -1,    -1,
      -1,    -1,  1913,    -1,    -1,    -1,    -1,  1918,    -1,    -1,
    2797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2819,  1944,    -1,    -1,  1947,  1948,    -1,    -1,
      -1,    -1,  2829,    -1,    -1,    -1,  2833,    -1,  1959,  1960,
      -1,  2838,    -1,    -1,    -1,  1966,    -1,  1968,  1969,  1970,
    1971,  1972,  1973,  1974,  1975,  1976,  1977,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    20,    -1,  2873,    -1,    -1,    -1,
    2877,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    41,    42,    -1,    -1,    -1,
    2897,    47,    -1,    49,    50,    -1,    -1,    -1,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,  2053,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2942,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2962,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2995,    -1,
      -1,  2998,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2213,    -1,   240,    -1,    -1,   243,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   259,    -1,  2236,  2237,  2238,  2239,  2240,
      -1,  2242,    -1,    -1,  2245,  2246,  2247,  2248,  2249,  2250,
    2251,  2252,  2253,  2254,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   312,    -1,  2289,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2300,
    2301,    -1,  2303,    -1,    -1,  2306,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   380,    -1,    -1,   383,   384,  2360,
     386,    -1,   388,    -1,    -1,    -1,   392,    -1,   394,   395,
      -1,    -1,    -1,   399,   400,   401,   402,   403,    -1,    -1,
     406,   407,   408,   409,    -1,   411,   412,   413,   414,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2426,    -1,    -1,    41,    42,
      -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,
      -1,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2489,    -1,
      -1,    -1,  2493,    -1,    -1,    -1,    -1,  2498,  2499,    -1,
      -1,  2502,   115,    -1,  2505,    -1,    -1,    -1,  2509,  2510,
    2511,  2512,  2513,  2514,  2515,  2516,  2517,  2518,  2519,  2520,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2531,    78,    -1,    -1,    -1,    -1,    -1,  2538,  2539,    -1,
    2541,    -1,    -1,    90,  2545,  2546,    -1,    -1,  2549,    -1,
      97,  2552,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,  2589,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
     243,    -1,    -1,  2634,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   259,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   312,
      -1,    -1,    -1,  2704,    -1,    -1,    -1,    -1,   255,    -1,
    2711,   258,  2713,    -1,    -1,    -1,    -1,    -1,    -1,  2720,
    2721,  2722,   269,  2724,   271,    -1,    -1,    -1,    -1,    -1,
      -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,
     383,   384,    -1,   386,    -1,    -1,   323,  2778,    -1,   392,
      -1,   394,   395,    -1,    -1,    -1,   399,   400,   401,   402,
     403,    -1,    -1,   406,   407,   408,    -1,    -1,    -1,   412,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2818,  2819,  2820,
      -1,    -1,    -1,  2824,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,
    2841,    -1,  2843,    -1,    -1,    -1,    -1,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2871,    -1,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,  2886,    19,    -1,    21,  2890,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,    -1,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,   374,   375,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,   412,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,   107,   108,   109,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
      -1,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,   212,   213,    -1,   215,   216,   217,   218,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,   374,   375,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    20,    21,    -1,    23,    24,    25,
      26,    27,    28,   413,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,   107,   108,   109,    -1,   111,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,    -1,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,   212,   213,    -1,   215,
     216,   217,   218,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,   374,   375,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     3,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,   413,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    -1,    -1,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,   119,    -1,   121,
     122,   123,    -1,    -1,   126,   127,    -1,    -1,    -1,    -1,
     132,   133,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,    -1,
     162,   163,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,   175,    -1,   177,    -1,   179,    -1,   181,
      -1,    -1,    -1,    -1,   186,    -1,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
     202,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,   215,    -1,   217,    -1,    -1,   220,   221,
      -1,   223,    -1,    -1,    -1,    -1,    -1,   229,    -1,   231,
      -1,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,    -1,
      -1,    -1,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,
      -1,    -1,   254,    -1,    -1,   257,   258,    -1,   260,   261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   274,   275,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   283,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,
      -1,   293,    -1,    -1,   296,    -1,    -1,    -1,   300,    -1,
      -1,    -1,   304,   305,   306,   307,    -1,    -1,    -1,    -1,
      -1,    -1,   314,    -1,    -1,    -1,    -1,   319,   320,    -1,
     322,   323,    -1,   325,    -1,    -1,   328,    -1,     3,    -1,
      -1,    -1,    -1,   335,     9,    -1,    -1,    -1,    -1,    -1,
     342,   343,    17,    -1,    19,    -1,   348,    22,   350,    -1,
     352,    -1,   354,    -1,   356,    -1,    -1,   359,    33,   361,
      -1,    -1,    -1,   365,    -1,    -1,   368,    -1,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,   383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   119,    -1,   121,   122,    -1,    -1,
      -1,   126,   127,    -1,    -1,    -1,    -1,    -1,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
      -1,   146,    -1,    -1,   149,    -1,    -1,    -1,    -1,    -1,
     155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   163,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,    -1,    -1,    -1,   300,    -1,    -1,    -1,   304,
      -1,   306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   314,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,   354,
      -1,    -1,    -1,    -1,   359,    -1,   361,    -1,    -1,    -1,
     365,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,   408,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,   159,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,    -1,   183,
      -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,   231,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,    -1,    -1,   408,   409,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,
     409,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,    -1,   183,
      -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,   231,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,
     404,    -1,    -1,    -1,   408,   409,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,    -1,   175,    -1,    -1,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,    -1,    -1,   256,   257,    -1,
      -1,    -1,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,    -1,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,    -1,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,    -1,
     349,    -1,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,     5,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    20,   386,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,    42,    -1,
     409,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,    -1,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    41,    42,    -1,    -1,    -1,    -1,    -1,    -1,
      49,    50,    -1,    -1,    -1,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,
      -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,   243,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,    -1,   259,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   312,    -1,
      -1,   240,    -1,    -1,   243,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,   383,
     384,    -1,   386,   312,    -1,    -1,    -1,    -1,   392,    -1,
     394,   395,    -1,    -1,    -1,   399,   400,   401,   402,   403,
      -1,    -1,   406,   407,   408,   409,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   380,    -1,    -1,   383,   384,    -1,   386,    -1,    -1,
      -1,    -1,    -1,   392,    -1,   394,   395,    -1,    -1,    -1,
     399,   400,   401,   402,   403,    -1,    -1,   406,   407,   408,
     409,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,    -1,   183,
      -1,   185,   186,   187,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,
     404,    -1,    -1,    -1,   408,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,    -1,   183,    -1,   185,   186,    -1,   188,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,    -1,   208,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,   231,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,
     400,   401,    -1,   403,   404,    -1,    -1,    -1,   408,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,    -1,   183,    -1,   185,
     186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,    -1,   208,   209,    -1,   211,   212,   213,   214,   215,
      -1,   217,    -1,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,   231,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,
     276,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,    -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,
      -1,    -1,   408,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,   220,   221,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,   231,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,
      -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,   186,    -1,
     188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
     208,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,   231,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,
      -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,
     408,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,    -1,   183,
      -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,   231,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,   408,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,    -1,   183,    -1,   185,   186,   187,   188,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,    -1,   208,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,   231,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,
     400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,    -1,   183,    -1,   185,
     186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,    -1,   208,   209,    -1,   211,   212,   213,   214,   215,
      -1,   217,    -1,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,   231,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,
     276,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,    -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,
      -1,    -1,   408,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,   220,   221,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,   231,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,
      -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,   186,    -1,
     188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
     208,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,   231,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
     258,   259,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,
     408,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,    -1,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,    -1,   183,
      -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,   258,   259,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,
     404,    -1,    -1,    -1,   408,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,    -1,   183,    -1,   185,   186,    -1,   188,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,    -1,   208,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,   231,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,
     390,   391,   392,   393,   394,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,   408,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,    -1,   183,    -1,   185,   186,    -1,   188,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,   208,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,    -1,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,    -1,
     400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,    -1,   183,    -1,   185,
     186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,   208,   209,    -1,   211,   212,   213,   214,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,   259,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,    -1,   270,    -1,    -1,   273,   274,   275,
     276,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   404,    -1,
      -1,    -1,   408,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    91,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
      -1,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,   259,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,    -1,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,   391,
     392,   393,   394,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,   408,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
      -1,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,    -1,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   404,    -1,    -1,    -1,   408,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,   186,    -1,
     188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
     208,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,    -1,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
      -1,    -1,   390,   391,   392,   393,   394,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
     408,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,   170,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,   264,   265,    -1,    -1,
      -1,   269,   270,    -1,   272,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,     5,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    20,   386,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,    42,
      -1,   409,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,
      -1,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
     243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   259,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   312,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,
     383,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,   392,
      -1,   394,   395,    -1,    -1,    -1,   399,   400,   401,   402,
     403,    -1,    -1,   406,   407,   408,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,   186,    -1,   188,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,    -1,   208,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,   231,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,   258,    -1,
     260,   261,   262,    -1,    -1,   265,   266,    -1,   268,   269,
     270,    -1,    -1,   273,   274,   275,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   408,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,   208,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,   231,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,   258,    -1,   260,   261,   262,    -1,
      -1,   265,   266,    -1,   268,   269,   270,    -1,    -1,   273,
     274,   275,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   408,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,   186,    -1,
     188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
     208,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,   231,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
     258,    -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,   275,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     408,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,    -1,    -1,
     392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   407,   408,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,    -1,    -1,   392,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,   408,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   408,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,   387,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   408,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   408,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   408,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   408,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,
     131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,    -1,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,    -1,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,    -1,   394,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,   385,   386,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,
      -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,    -1,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,    -1,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,   401,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     401,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,   401,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,   263,    -1,   265,    -1,   267,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,    -1,    -1,   392,    -1,   394,    -1,     6,     7,     8,
       9,   400,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,   263,    -1,   265,    -1,   267,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,    -1,    -1,   392,    -1,   394,    -1,     6,     7,     8,
       9,   400,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,   187,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,   387,     6,
       7,     8,     9,   392,    11,    12,    -1,    14,    15,    16,
      17,   400,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
     387,     6,     7,     8,     9,   392,    11,    12,    -1,    14,
      15,    16,    17,   400,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,   344,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,     6,     7,     8,     9,    -1,    11,    12,
     395,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,    -1,    -1,   390,   391,   392,
      -1,   394,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,    -1,     4,   389,     6,     7,     8,     9,
      10,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,   107,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,    -1,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,   374,   375,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    13,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    43,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,   249,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,   387,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,   344,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    18,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,   387,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,   387,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,   387,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
     387,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
      -1,   175,    -1,    -1,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,    -1,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,    -1,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,    -1,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,    -1,   349,    -1,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,
      -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,    -1,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,    -1,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,   106,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,
     130,   131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
      -1,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,    -1,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,    -1,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,
      -1,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,    -1,   175,    -1,    -1,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,   257,
      -1,    -1,    -1,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,    -1,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,    -1,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
      -1,   349,    -1,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
     106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,
     126,   127,   128,    -1,   130,   131,    -1,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,    -1,   175,
      -1,    -1,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,   214,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,
     256,   257,    -1,    -1,    -1,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,    -1,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,    -1,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,    -1,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,    -1,   349,    -1,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    42,    -1,    44,
      45,    46,    47,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,    -1,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,   212,   213,    -1,
     215,   216,   217,   218,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,   374,
     375,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    42,    -1,
      44,    45,    46,    47,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,   107,   108,   109,    -1,   111,   112,   113,
     114,    -1,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
      -1,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,    -1,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,   212,   213,
      -1,   215,   216,   217,   218,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
     374,   375,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,    -1,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,   212,
     213,    -1,   215,   216,   217,   218,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,   374,   375,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,   107,   108,   109,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,    -1,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
     212,   213,    -1,   215,   216,   217,   218,    -1,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,   374,   375,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,   258,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,   184,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,   231,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      89,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,
     268,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,   249,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,   249,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,   187,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,   202,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,    -1,
      -1,    11,    12,    -1,    14,    15,    16,    -1,    -1,    -1,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    -1,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,    -1,    -1,   177,    -1,    -1,
      -1,   181,    -1,    -1,    -1,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,
      -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,   215,    -1,   217,    -1,    -1,
     220,   221,    -1,   223,    -1,    -1,    -1,    -1,    -1,   229,
      -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
     260,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   274,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   283,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   305,    -1,   307,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,    -1,    -1,   323,    -1,   325,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
      -1,    -1,   342,   343,    -1,    -1,    -1,    -1,   348,    -1,
     350,    -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
     370,    -1,     6,     7,     8,    -1,    -1,    11,    12,    -1,
      14,    15,    16,   383,    -1,    -1,   386,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    -1,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   147,   148,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,    -1,
      -1,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,
      -1,   215,    -1,   217,    -1,    -1,   220,   221,    -1,   223,
      -1,    -1,    -1,    -1,    -1,   229,    -1,   231,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,
     254,    -1,    -1,    -1,   258,    -1,   260,   261,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     274,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   293,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   305,    -1,   307,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,   323,
      -1,   325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,    -1,    -1,   342,   343,
      -1,    -1,    -1,    -1,   348,    -1,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,    -1,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   383,
      -1,    -1,   386
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   418,   419,     0,     5,    20,    29,    41,    42,    47,
      49,    50,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    77,   115,   181,   197,   214,   240,
     243,   259,   312,   344,   356,   368,   380,   383,   384,   386,
     388,   392,   394,   395,   399,   400,   401,   402,   403,   406,
     407,   408,   409,   411,   412,   413,   414,   420,   763,   764,
     767,   801,   803,   894,   906,   907,   802,     3,     6,     7,
       8,     9,    11,    12,    14,    15,    16,    17,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    30,    31,
      32,    33,    35,    37,    38,    39,    40,    42,    44,    45,
      46,    48,    49,    50,    52,    53,    57,    58,    63,    72,
      74,    76,    77,    79,    87,    88,    89,    97,    98,   101,
     102,   103,   104,   105,   116,   119,   121,   122,   123,   126,
     127,   132,   133,   134,   137,   144,   146,   147,   148,   149,
     155,   162,   163,   168,   173,   174,   175,   177,   179,   181,
     186,   188,   190,   192,   198,   202,   208,   212,   215,   217,
     220,   221,   223,   229,   231,   233,   234,   237,   244,   247,
     248,   254,   257,   258,   260,   261,   274,   275,   283,   286,
     293,   296,   300,   304,   305,   306,   307,   314,   319,   320,
     322,   323,   325,   328,   335,   342,   343,   348,   350,   352,
     354,   356,   359,   361,   365,   368,   370,   383,   386,   408,
     421,   422,   423,   425,   426,   427,   431,   434,   435,   436,
     440,   450,   451,   452,   455,   456,   459,   460,   469,   494,
     499,   500,   504,   508,   510,   523,   524,   525,   526,   532,
     537,   538,   542,   543,   547,   550,   551,   562,   568,   580,
     581,   583,   586,   588,   589,   592,   595,   603,   604,   605,
     606,   607,   612,   613,   614,   618,   619,   620,   621,   623,
     624,   625,   626,   627,   632,   635,   639,   640,   643,   644,
     647,   648,   649,   650,   651,   777,   790,   791,   792,   793,
     794,   800,   808,   813,   814,   815,   816,   818,   820,   822,
     824,   825,   826,   827,   829,   834,   835,   838,   843,   844,
     854,   855,   857,   858,   865,   866,   867,   868,   870,   871,
     874,   876,   879,   887,   890,   891,   900,     9,    17,    19,
      33,    52,    53,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    99,   100,   101,   107,   108,   109,   111,   112,
     113,   114,   117,   118,   119,   120,   121,   122,   124,   125,
     126,   127,   128,   129,   130,   131,   133,   134,   135,   136,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   149,
     150,   151,   152,   153,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   175,   178,   179,   180,   182,   183,   184,
     185,   187,   189,   191,   192,   193,   194,   195,   196,   197,
     199,   200,   201,   203,   204,   205,   206,   207,   209,   211,
     212,   213,   216,   218,   222,   224,   225,   226,   227,   228,
     230,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   249,   250,   251,   252,
     253,   255,   256,   257,   259,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   277,   278,   279,
     280,   281,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   306,   308,   309,   310,   311,   312,   314,   315,
     316,   317,   318,   319,   321,   322,   324,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   336,   337,   338,   339,
     340,   341,   344,   345,   346,   347,   349,   351,   352,   353,
     354,   355,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   369,   371,   372,   374,   375,   376,   377,
     378,   379,   380,   381,   805,   806,   808,   810,   813,   816,
     817,   820,   824,   880,   887,   888,   889,   892,    18,   115,
     344,   387,   767,   770,   775,   786,   787,   878,   879,   880,
     883,   889,   890,   898,   900,    34,   210,   856,    13,    86,
     150,   756,   770,   778,   779,   836,   837,   883,   900,     5,
      29,    34,    41,    42,    49,    50,   115,   210,   214,   356,
     412,   819,   881,   882,   886,   887,   888,   755,   883,   755,
     882,    29,    41,   115,   214,   875,    44,    46,   255,   809,
     347,   378,   608,    85,   131,   144,   161,   189,   193,   226,
     269,   310,   315,   337,   349,   363,   778,   149,   608,   755,
     249,   266,   740,   751,   753,   759,   776,   883,   267,   608,
     104,   465,    85,    95,   113,   129,   144,   150,   161,   191,
     193,   235,   269,   271,   310,   338,   340,   349,   353,   354,
     357,   363,   470,   505,   535,   563,   569,   778,    18,   286,
     387,   755,   788,   842,   329,   755,   187,    85,    95,   113,
     131,   144,   161,   189,   193,   205,   269,   290,   309,   310,
     315,   337,   349,   354,   363,   372,   509,   539,   608,   199,
     842,   627,   634,    80,    86,    99,   180,   185,   187,   202,
     227,   250,   288,   297,   400,   544,   545,   546,   755,   763,
     768,   769,   898,    18,    86,   134,   155,   173,   212,   295,
     309,   314,   338,   340,   349,   361,   362,   552,   553,   554,
     218,   753,   883,   760,   770,   337,   654,   544,   755,   753,
     842,   144,   205,   337,   590,    86,   317,   342,   347,   883,
     192,   559,   608,    86,   159,   656,     4,    10,   130,   235,
     245,   317,   342,   347,   441,   883,    86,   317,   342,   347,
     883,   347,   654,   872,   882,   401,   753,   268,   678,   753,
     188,   629,   648,   649,   101,   422,   411,    35,   370,   628,
     170,   216,   272,   356,   657,   658,   796,   800,   820,   815,
     411,   821,   823,     5,    29,    41,   115,   214,   828,   145,
     197,   240,   243,   312,   380,   408,   707,   799,   804,   894,
     808,   810,   817,   812,   411,   799,   755,   788,   901,   150,
     778,    25,   364,   402,   755,   755,   385,   780,   781,   416,
     387,   408,   412,   902,   903,   904,   905,   907,   819,   364,
     845,   846,    29,   214,   214,   886,     7,    11,    23,    24,
      45,    48,   160,   877,   877,    21,   817,   740,   751,   761,
     878,   885,   889,   891,   900,   541,   740,   883,   756,   541,
     761,   775,   755,   120,   755,   753,   678,   753,   755,   775,
      40,   410,   741,   267,    85,   125,   144,   161,   189,   205,
     269,   309,   310,   315,   337,   349,   354,   372,   548,   753,
     761,   755,   408,   349,   756,   541,   338,   340,   775,   338,
     340,   120,   385,   395,   396,   397,   399,   400,   401,   402,
     403,   404,   712,   713,   299,   775,   883,   755,   541,   775,
     315,   337,   509,   131,   205,   189,   309,   372,   901,   842,
     900,   645,   678,   761,   755,   408,   756,   761,   775,   120,
     712,   755,   755,   430,   775,   226,   540,   541,   386,   788,
     841,   839,   628,   545,    86,   545,    86,   545,   545,   768,
     546,   755,   755,   218,   364,   847,   848,   850,   851,   901,
     289,   267,   414,   753,   752,   753,   546,   187,   755,   753,
      98,   381,   222,   270,   552,   267,    92,   103,   105,   106,
     112,   113,   115,   116,   123,   132,   138,   139,   140,   141,
     147,   148,   162,   174,   177,   178,   181,   214,   215,   217,
     246,   248,   255,   259,   260,   261,   269,   276,   283,   293,
     307,   318,   325,   335,   342,   343,   348,   350,   351,   357,
     363,   368,   385,   387,   390,   391,   393,   399,   400,   401,
     403,   404,   408,   648,   687,   688,   689,   694,   695,   696,
     698,   699,   700,   701,   704,   705,   708,   709,   714,   716,
     718,   734,   739,   740,   743,   744,   751,   761,   762,   763,
     764,   765,   766,   767,   774,   878,   881,   884,   889,   897,
     898,   900,   344,   395,   344,   395,   837,    86,   453,   754,
     755,   317,   441,   150,   448,   770,    98,   117,   441,   381,
     222,   292,   609,   611,   344,   415,    98,   381,   222,   609,
     610,   753,   886,   408,   753,   319,   401,   186,   630,   409,
     409,   411,   753,    86,   655,   655,   108,   655,   182,   232,
     264,   661,   667,   401,   830,   831,   833,   795,   412,   412,
      29,   214,   214,   344,   344,   344,   344,   344,   400,   763,
     764,   772,   797,   898,   168,   811,   830,    93,   784,   108,
     787,   787,   847,   218,   847,   848,   389,   782,   883,   416,
     783,   780,   409,   903,   904,   902,   413,   414,   767,   772,
     773,   852,   853,   214,   220,   755,   344,   755,     6,   755,
     877,   833,   408,   298,   298,   319,   451,    83,   163,   277,
     319,   457,   408,   570,    83,   163,   298,   298,   541,   298,
     501,    83,    87,   163,   298,   319,   122,   134,   277,   267,
     298,   319,   376,   428,   451,   411,   401,   758,   883,   753,
     761,   761,   712,   755,   755,   755,   376,   466,   408,   528,
     118,   103,   105,   115,   116,   147,   148,   181,   215,   217,
     248,   261,   293,   320,   325,   342,   343,   368,   683,   686,
     688,   689,   693,   695,   696,   697,   699,   700,   704,   705,
     878,   884,   889,   900,   755,   376,    93,   622,   376,   432,
     541,   528,   437,   883,   438,    84,   100,   511,    93,   528,
     376,   424,   753,   753,   226,   541,   759,   883,   761,   755,
     753,   104,   142,   211,   251,   311,   375,   680,   408,   683,
     570,   541,   408,   267,   267,   414,   770,   111,   302,   414,
     458,   840,   846,   851,   149,   633,   635,   639,   643,   644,
     647,   755,   850,   850,    43,   387,   849,   893,   896,   849,
      51,   387,   859,   863,   144,   189,   226,   310,   337,   555,
     752,   554,   150,   367,   408,   636,   647,   202,   414,   641,
     755,   841,   183,   591,   591,   230,   182,   267,   408,   406,
     648,   724,   369,   702,   716,   738,   408,   702,   702,   408,
     408,   408,   742,   408,   742,   408,   742,   408,   692,   692,
     284,   648,   408,   408,   690,   115,   116,   702,   716,   408,
     408,   691,   408,   408,   408,   408,   742,   408,   376,   377,
     408,   706,   408,   706,   408,   408,   648,   742,    26,   387,
     899,   406,   719,   741,   716,   716,   716,   716,   648,   710,
     716,   720,   770,   116,   408,   703,   408,   770,   202,   220,
     255,   269,   275,   712,   715,   716,    78,    90,    93,    97,
     102,   198,   202,   220,   221,   231,   255,   258,   269,   271,
     323,   385,   395,   396,   397,   399,   400,   401,   402,   403,
     404,   714,   715,   719,   218,   414,   652,   850,   719,   408,
     263,   267,   869,   869,   837,   837,   153,   199,   454,   414,
     117,   150,   449,   770,   883,    93,   150,   235,   447,   705,
     773,   900,   230,   268,   379,   222,   150,   178,   263,   267,
     351,   442,   443,   445,   446,   773,   883,   442,   230,   220,
     753,   408,   745,   748,   883,   628,   408,   631,   648,   650,
     651,   650,   659,   660,   716,   650,   292,   361,    86,   663,
     716,   664,   716,   667,   668,   661,   662,   401,   411,   414,
     887,   830,   807,   810,   807,   214,   145,   197,   240,   312,
     240,   312,   312,   243,   240,   243,   312,   763,   764,   414,
     798,   149,   830,   411,   778,   363,   785,   787,   410,   768,
     783,   409,   413,   905,   414,   817,   408,   755,   408,   887,
     401,   582,   683,   344,   344,   441,   118,   129,   184,   287,
     357,   481,   482,   129,   150,   255,   344,   150,   255,   202,
     209,   273,   409,   571,   572,   573,   576,   683,   884,   298,
     363,   363,   344,   344,   364,   344,   109,   143,   204,   239,
     241,   251,   301,   328,   502,   125,   481,   594,   594,   129,
     594,   594,   377,   267,   345,   344,   678,   344,   441,   428,
     135,   136,   202,   252,   253,   279,   336,   366,   429,   741,
     408,   570,   408,   220,   267,   267,   220,   265,   187,   344,
     461,   529,   530,   886,   408,   686,    93,    92,   406,   684,
     145,   243,   380,   408,   707,   741,    84,   166,   236,   277,
     339,   615,   616,   683,   432,   336,   363,   433,   535,    98,
     134,   439,   469,   550,   612,   155,   212,   361,   512,   513,
     408,   527,   428,   501,   262,   408,   496,   449,   182,   267,
     570,    93,   408,   483,   376,   377,   646,   311,   716,   582,
      93,   458,   364,   254,   584,   683,   753,   753,   775,   458,
     541,   851,   846,   755,   850,   899,    18,   414,    18,   387,
     763,   395,   414,   754,   560,   561,   761,   754,   754,   752,
     344,   367,   408,   637,   638,   883,    81,   171,   307,   321,
     642,   753,   555,   716,   720,   720,   723,   724,   408,   374,
     735,   736,   716,   720,   716,   720,   409,   768,   768,   768,
     145,   197,   240,   243,   312,   380,   721,   725,   770,   900,
     768,   702,   702,   716,   768,   585,   712,   883,   716,   726,
     400,   403,   404,   408,   714,   717,   718,   728,   409,   710,
     716,   716,   720,   729,   342,   342,   768,   768,   716,   107,
     187,   228,   346,   716,   720,   732,   387,   755,   716,   719,
     409,   409,   414,   319,   768,   768,   707,   648,   159,   255,
     259,   202,   408,   307,   408,   709,    86,    91,   326,   408,
     648,   709,   711,   683,   716,   886,   342,   717,   716,   408,
     648,   733,   159,   178,   255,   259,   262,   351,   358,   716,
     102,   198,   202,   231,   323,   408,   716,   344,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   711,   191,
     235,   337,   338,   340,   653,   753,   744,   187,   670,    86,
     159,   401,   409,   720,   755,   347,   408,   770,   292,   316,
     444,   230,   414,   817,   409,   746,   883,   414,   670,   719,
     626,   753,   754,   414,    94,   158,   364,   268,   262,   669,
     264,   414,   232,   831,   684,   411,   413,   810,   413,   772,
     409,    40,   411,   786,   782,   402,   852,   684,   895,   904,
     895,   684,   409,   755,   756,   408,   755,   224,   224,   408,
     755,   259,   775,   716,   259,   409,   414,   576,   741,   344,
     430,   430,   775,   755,   757,   883,   755,   772,   108,   503,
     772,   772,   143,   239,   241,   424,   424,   474,   883,   883,
     755,   883,   593,   755,   265,   755,   337,   775,   298,   775,
     193,   767,   768,   360,   582,   220,   584,   259,   549,   770,
     541,   541,   549,   331,   332,   462,   770,   409,   414,   395,
     716,    92,   684,   683,   406,   407,   408,   685,   767,   768,
     883,   344,   344,   768,   512,   395,   617,   617,   617,   617,
     616,   475,   768,   430,   182,   775,   470,   569,   267,   271,
     681,   682,   883,   753,   231,   471,   472,   473,   474,   479,
     481,   497,   498,   883,    93,   194,   770,   753,   303,   596,
     484,   485,   883,    93,   196,   196,   182,   409,   683,   757,
     414,   409,   414,   458,   458,   645,   901,   896,   901,   387,
     861,   864,   864,    12,   860,   859,   414,   570,   193,   556,
     557,   883,   150,   744,   749,   750,   409,   414,   719,   171,
     321,   171,   321,   307,   361,   242,   187,   409,   414,   407,
     407,   414,   768,   716,   165,   736,   737,    93,   409,   364,
     409,   409,   409,   409,   414,   409,   187,   409,   414,   409,
     414,   409,   410,   282,   727,   409,   717,   717,   717,   716,
     717,    78,   202,   220,   269,   385,   395,   396,   397,   399,
     400,   401,   402,   403,   404,   714,   409,   409,   409,   182,
     187,   730,   731,   409,   381,   381,   409,   409,    93,   732,
     720,   732,   732,   187,   409,   407,   416,   719,   741,   716,
     883,   409,   409,   187,   259,   648,   585,   648,   381,    90,
     169,   720,   187,   178,   259,   262,   351,   358,   408,   169,
     717,   716,   733,   716,   344,   585,   716,   408,   648,   338,
     340,   338,   340,   753,   654,   654,   408,   648,   671,   672,
     673,   678,   679,   740,   761,   680,   720,   720,   409,   409,
     609,   768,   707,   128,   611,   444,   445,   684,   409,   719,
     748,   680,   395,   409,   660,   715,   754,   664,   664,   663,
     395,   832,   411,   756,    36,   873,   409,   409,   411,   298,
     716,   482,   408,   408,   484,   458,   572,   403,   755,   298,
     772,   772,   772,   683,   163,   319,   457,   458,   458,   344,
     344,   430,   767,   409,   549,   409,   220,   220,   364,   467,
     468,   530,   269,   400,   531,   575,   576,   715,   773,   409,
     406,   409,   768,   684,   685,   399,   400,   401,   402,   403,
     407,   409,   267,   150,   763,   767,   771,   898,   150,   770,
     150,   755,   150,   755,   118,   129,   150,   152,   207,   255,
     259,   287,   295,   357,   476,   477,   478,   354,   438,   337,
     753,   513,   409,   414,   683,   408,   753,   409,   414,   409,
     414,   495,   506,   740,   755,   883,   344,   364,   564,   575,
     267,   409,   414,   647,   647,   842,   458,   409,   458,   683,
     458,   254,   683,   142,   395,   414,   561,   883,   376,   414,
     558,   409,   414,   367,   647,   638,   171,   171,   556,   716,
     724,   409,   341,   716,   168,   683,   541,   768,   716,   716,
     768,   585,   716,   730,   683,   717,   159,   255,   262,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   716,
     716,   731,   730,   706,   706,   683,   409,   409,   409,   720,
     719,   716,   719,   703,   770,   709,   409,   718,   717,   716,
     409,   716,   408,   683,   722,   716,    90,   169,   169,   716,
     409,   169,   716,   654,   654,   654,   654,   753,   753,   648,
     672,   673,    93,   674,   883,   414,   137,   188,   208,   223,
     229,   247,   305,   382,   675,   674,    93,   674,   883,   408,
     193,   665,   409,   409,   409,   873,   395,   414,   150,   716,
     905,   385,   789,   344,   409,   484,   484,   409,   354,   344,
     475,   255,   255,   330,   333,   755,   755,   220,   220,   549,
     549,   424,   157,   152,   207,   255,   520,   521,   522,   768,
     376,   377,   407,   409,   685,   685,   685,   685,   685,   684,
     707,   753,   408,   755,   717,   153,   199,   152,   259,   224,
     753,   683,   753,   182,   514,   271,   682,   471,   172,   203,
     480,   206,   491,   473,   498,   883,   647,   225,   507,   770,
     757,   408,    93,   110,   176,   200,   226,   303,   313,   327,
     334,   373,   577,   578,   155,   212,   314,   361,   601,   485,
     458,   646,     8,    14,    15,    16,    26,    27,    28,    30,
      31,    32,    37,    38,    39,   284,   354,   862,   861,   192,
     557,   750,   408,   458,   716,   409,   409,   409,   409,   409,
     731,   187,   262,   408,   409,   407,   707,   722,   409,   414,
     717,   716,   716,   169,   716,   409,   753,   753,   753,   753,
     409,   883,   408,   672,   223,   274,   676,   672,   676,   223,
     675,   676,   672,   223,   408,   883,   408,   409,   720,   108,
     195,   666,   770,   408,   746,   883,   755,   409,   409,   755,
     259,   259,   768,   883,   549,   549,   463,   770,   153,   199,
     152,   522,   521,   407,   189,   189,   187,   519,   716,   255,
     477,   483,   364,   408,   164,   515,   173,   513,   409,   151,
     151,   408,   376,   377,   492,   770,   187,   408,   565,   566,
     758,   761,   883,   574,   770,   267,   313,   449,   259,   154,
     219,   376,   578,   579,   344,   182,   270,   749,   717,   408,
     717,   719,   409,   683,   716,   674,   408,   754,   672,   267,
     364,   677,   672,   223,   672,   681,   408,   681,   883,   409,
     720,   716,   707,   716,   747,   295,   104,   156,   259,   265,
     464,   561,    93,   587,   753,   520,   409,   238,   486,   757,
     307,   329,   516,   291,   492,   752,   265,   265,   267,   493,
     541,   716,   409,   414,   364,   541,   567,   408,   414,   259,
     154,   219,   267,   528,   753,   409,   717,   409,   754,   409,
     716,   408,   672,   677,   409,   681,   409,   414,   409,   753,
     622,   622,   587,    96,   182,   188,   278,   267,   487,   488,
     489,    93,   755,   493,   409,   127,   409,   680,   566,   541,
     720,   770,   210,   259,   680,   409,   409,   754,   409,   747,
     483,   770,   770,   164,   155,   361,   267,   489,   267,   488,
     189,   269,   333,   533,   534,   408,   155,   163,   285,   567,
     409,   210,   160,   409,   486,   307,   111,   251,   302,   319,
     490,   490,   768,   768,   683,   414,   517,   518,   774,   883,
     308,   308,   567,   213,   602,   487,   173,    82,   150,   259,
     761,   585,   534,   409,   414,   256,   408,   597,   599,   604,
     635,   639,   643,   647,   520,   291,   570,   294,   408,   536,
     518,   598,   599,   600,   648,   649,   761,   584,   409,   411,
     408,   409,   600,   517,   536,   409
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 566 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 569 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 575 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 576 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 577 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 578 "preproc.y"
    { remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 582 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 593 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 594 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 595 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 596 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 597 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 598 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 599 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 600 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 601 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 603 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 24:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 25:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 628 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 629 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 630 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 631 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 632 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 633 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 634 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 635 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 636 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 637 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 638 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 639 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 640 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 641 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 642 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 644 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 44:
#line 645 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 646 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 46:
#line 647 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 648 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 48:
#line 649 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 650 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 651 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 652 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 58:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 61:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 64:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 670 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 671 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 673 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 674 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 73:
#line 677 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 74:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 76:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 77:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 686 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 80:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 689 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 691 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 83:
#line 697 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 84:
#line 707 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 85:
#line 711 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, \"%s\");", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 719 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 727 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 731 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdescribe(__LINE__, %s,", yyvsp[0].str);
			dump_variables(argsresult, 1);
			fputs("ECPGt_EORT);", yyout);
			fprintf(yyout, "}");
			output_line_number();
				
			/* whenever_action(2); */
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 742 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for disconnect statement.\n");

			fprintf(yyout, "{ ECPGdisconnect(__LINE__, %s);",
					yyvsp[0].str ? yyvsp[0].str : "\"CURRENT\"");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 752 "preproc.y"
    {
			output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 91:
#line 756 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, \"%s\");", compat, yyvsp[0].str);

			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 92:
#line 763 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_get_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 93:
#line 770 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_get_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 94:
#line 776 "preproc.y"
    {
			struct cursor *ptr;

			if ((ptr = add_additional_variables(yyvsp[0].str, true)) != NULL)
				output_statement(mm_strdup(ptr->command), 0, ptr->connection ? mm_strdup(ptr->connection) : NULL);
		}
    break;

  case 95:
#line 783 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for prepare statement.\n");

			fprintf(yyout, "{ ECPGprepare(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 96:
#line 791 "preproc.y"
    { /* output already done */ }
    break;

  case 97:
#line 793 "preproc.y"
    {
			fprintf(yyout, "{ ECPGsetcommit(__LINE__, \"%s\", %s);", yyvsp[0].str, connection ? connection : "NULL");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 98:
#line 799 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for set connection statement.\n");

			fprintf(yyout, "{ ECPGsetconn(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 99:
#line 808 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for typedef statement.\n");

			fprintf(yyout, "%s", yyvsp[0].str);
			free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 100:
#line 817 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for var statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 101:
#line 824 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for whenever statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 102:
#line 845 "preproc.y"
    { yyval.str = cat_str(4, make_str("create user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 103:
#line 848 "preproc.y"
    { yyval.str = make_str("with"); }
    break;

  case 104:
#line 849 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 105:
#line 861 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 106:
#line 863 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 107:
#line 867 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("set"), yyvsp[0].str); }
    break;

  case 108:
#line 869 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 109:
#line 879 "preproc.y"
    { yyval.str = cat2_str(make_str("drop user"), yyvsp[0].str);}
    break;

  case 110:
#line 885 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 111:
#line 886 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 112:
#line 890 "preproc.y"
    { yyval.str = cat2_str(make_str("password"), yyvsp[0].str); }
    break;

  case 113:
#line 892 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 114:
#line 894 "preproc.y"
    { yyval.str = make_str("createdb"); }
    break;

  case 115:
#line 896 "preproc.y"
    { yyval.str = make_str("nocreatedb"); }
    break;

  case 116:
#line 898 "preproc.y"
    { yyval.str = make_str("createuser"); }
    break;

  case 117:
#line 900 "preproc.y"
    { yyval.str = make_str("nocreateuser"); }
    break;

  case 118:
#line 902 "preproc.y"
    { yyval.str = cat2_str(make_str("in group"), yyvsp[0].str); }
    break;

  case 119:
#line 904 "preproc.y"
    { yyval.str = cat2_str(make_str("valid until"), yyvsp[0].str); }
    break;

  case 120:
#line 908 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 121:
#line 910 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 122:
#line 920 "preproc.y"
    { yyval.str = cat_str(3, make_str("create group"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 123:
#line 922 "preproc.y"
    { yyval.str = cat_str(4, make_str("create group"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 124:
#line 928 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 125:
#line 929 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 126:
#line 933 "preproc.y"
    { yyval.str = cat2_str(make_str("user"), yyvsp[0].str); }
    break;

  case 127:
#line 935 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 128:
#line 946 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("add user"), yyvsp[0].str); }
    break;

  case 129:
#line 948 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("drop user"), yyvsp[0].str); }
    break;

  case 130:
#line 958 "preproc.y"
    { yyval.str = cat2_str(make_str("drop group"), yyvsp[0].str); }
    break;

  case 131:
#line 969 "preproc.y"
    { yyval.str = cat_str(6, make_str("create schema"), yyvsp[-4].str, yyvsp[-3].str, make_str("authorization"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 132:
#line 971 "preproc.y"
    { yyval.str = cat_str(3, make_str("create schema"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 133:
#line 974 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 134:
#line 975 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 135:
#line 978 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 136:
#line 979 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 137:
#line 986 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 138:
#line 987 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 139:
#line 988 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 140:
#line 1002 "preproc.y"
    { yyval.str = cat2_str(make_str("set"), yyvsp[0].str ); }
    break;

  case 141:
#line 1004 "preproc.y"
    { yyval.str = cat2_str(make_str("set local"), yyvsp[0].str ); }
    break;

  case 142:
#line 1006 "preproc.y"
    { yyval.str = cat2_str(make_str("set session"), yyvsp[0].str ); }
    break;

  case 143:
#line 1010 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("to"), yyvsp[0].str); }
    break;

  case 144:
#line 1012 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("="), yyvsp[0].str); }
    break;

  case 145:
#line 1014 "preproc.y"
    { yyval.str = cat2_str(make_str("time zone"), yyvsp[0].str); }
    break;

  case 146:
#line 1016 "preproc.y"
    { yyval.str = cat2_str(make_str("transaction"), yyvsp[0].str); }
    break;

  case 147:
#line 1018 "preproc.y"
    { yyval.str = cat2_str(make_str("session characteristics as transaction"), yyvsp[0].str); }
    break;

  case 148:
#line 1020 "preproc.y"
    { yyval.str = cat2_str(make_str("names"), yyvsp[0].str); }
    break;

  case 149:
#line 1022 "preproc.y"
    { yyval.str = cat2_str(make_str("session authorization"), yyvsp[0].str); }
    break;

  case 150:
#line 1024 "preproc.y"
    { yyval.str = make_str("session authorization default"); }
    break;

  case 151:
#line 1028 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 152:
#line 1030 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 153:
#line 1034 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 154:
#line 1036 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 155:
#line 1039 "preproc.y"
    { yyval.str = make_str("read committed"); }
    break;

  case 156:
#line 1040 "preproc.y"
    { yyval.str = make_str("serializable"); }
    break;

  case 157:
#line 1043 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 158:
#line 1044 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 159:
#line 1045 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 160:
#line 1048 "preproc.y"
    { yyval.str = make_str("true"); }
    break;

  case 161:
#line 1049 "preproc.y"
    { yyval.str = make_str("false"); }
    break;

  case 162:
#line 1050 "preproc.y"
    { yyval.str = make_str("on"); }
    break;

  case 163:
#line 1051 "preproc.y"
    { yyval.str = make_str("off"); }
    break;

  case 164:
#line 1061 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 165:
#line 1062 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 166:
#line 1064 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 167:
#line 1066 "preproc.y"
    { yyval.str = cat_str(6, yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 168:
#line 1068 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 169:
#line 1070 "preproc.y"
    { yyval.str = make_str("local"); }
    break;

  case 170:
#line 1073 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 171:
#line 1074 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 172:
#line 1075 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 173:
#line 1078 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 174:
#line 1079 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 175:
#line 1083 "preproc.y"
    { yyval.str = cat2_str(make_str("show"), yyvsp[0].str); }
    break;

  case 176:
#line 1085 "preproc.y"
    { yyval.str = make_str("show time zone"); }
    break;

  case 177:
#line 1087 "preproc.y"
    { yyval.str = make_str("show transaction isolation level"); }
    break;

  case 178:
#line 1089 "preproc.y"
    { yyval.str = make_str("show session authorization"); }
    break;

  case 179:
#line 1091 "preproc.y"
    { yyval.str = make_str("show all"); }
    break;

  case 180:
#line 1095 "preproc.y"
    { yyval.str = cat2_str(make_str("reset"), yyvsp[0].str); }
    break;

  case 181:
#line 1097 "preproc.y"
    { yyval.str = make_str("reset time zone"); }
    break;

  case 182:
#line 1099 "preproc.y"
    { yyval.str = make_str("reset transaction isolation level"); }
    break;

  case 183:
#line 1101 "preproc.y"
    { yyval.str = make_str("reset session authorization"); }
    break;

  case 184:
#line 1103 "preproc.y"
    { yyval.str = make_str("reset all"); }
    break;

  case 185:
#line 1107 "preproc.y"
    { yyval.str = cat_str(3, make_str("set constraints"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 186:
#line 1111 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 187:
#line 1113 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 188:
#line 1116 "preproc.y"
    { yyval.str = make_str("deferred"); }
    break;

  case 189:
#line 1117 "preproc.y"
    { yyval.str = make_str("immediate"); }
    break;

  case 190:
#line 1123 "preproc.y"
    { yyval.str= make_str("checkpoint"); }
    break;

  case 191:
#line 1136 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-3].str, make_str("add"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 192:
#line 1139 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("alter"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 193:
#line 1142 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("drop not null")); }
    break;

  case 194:
#line 1145 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set not null")); }
    break;

  case 195:
#line 1148 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set statistics"), yyvsp[0].str); }
    break;

  case 196:
#line 1151 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set storage"), yyvsp[0].str); }
    break;

  case 197:
#line 1154 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("drop"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 198:
#line 1157 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-2].str, make_str("add"), yyvsp[0].str); }
    break;

  case 199:
#line 1160 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-4].str, make_str("drop constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 200:
#line 1163 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("set without oids")); }
    break;

  case 201:
#line 1166 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("create toast table")); }
    break;

  case 202:
#line 1169 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("owner to"), yyvsp[0].str); }
    break;

  case 203:
#line 1172 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("cluster on"), yyvsp[0].str); }
    break;

  case 204:
#line 1176 "preproc.y"
    { yyval.str = cat2_str(make_str("set default"), yyvsp[0].str); }
    break;

  case 205:
#line 1177 "preproc.y"
    { yyval.str = make_str("drop default"); }
    break;

  case 206:
#line 1180 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 207:
#line 1181 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 208:
#line 1182 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 209:
#line 1193 "preproc.y"
    {
			yyval.str = cat2_str(make_str("close"), yyvsp[0].str);
		}
    break;

  case 210:
#line 1208 "preproc.y"
    { yyval.str = cat_str(9, make_str("copy"), yyvsp[-7].str, yyvsp[-6].str, yyvsp[-5].str, yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 211:
#line 1211 "preproc.y"
    { yyval.str = make_str("to"); }
    break;

  case 212:
#line 1212 "preproc.y"
    { yyval.str = make_str("from"); }
    break;

  case 213:
#line 1220 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 214:
#line 1221 "preproc.y"
    { yyval.str = make_str("stdin"); }
    break;

  case 215:
#line 1222 "preproc.y"
    { yyval.str = make_str("stdout"); }
    break;

  case 216:
#line 1225 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 217:
#line 1226 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 218:
#line 1229 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 219:
#line 1230 "preproc.y"
    { yyval.str = make_str("oids"); }
    break;

  case 220:
#line 1232 "preproc.y"
    { yyval.str = cat_str(3, make_str("delimiter"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 221:
#line 1234 "preproc.y"
    { yyval.str = cat_str(3, make_str("null"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 222:
#line 1237 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 223:
#line 1238 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 224:
#line 1241 "preproc.y"
    { yyval.str = make_str("with oids"); }
    break;

  case 225:
#line 1242 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 226:
#line 1250 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("delimiters"), yyvsp[0].str); }
    break;

  case 227:
#line 1252 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 228:
#line 1255 "preproc.y"
    { yyval.str = make_str("using"); }
    break;

  case 229:
#line 1256 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 230:
#line 1268 "preproc.y"
    { yyval.str = cat_str(10, make_str("create"), yyvsp[-8].str, make_str("table"), yyvsp[-6].str, make_str("("), yyvsp[-4].str, make_str(")"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 231:
#line 1271 "preproc.y"
    { yyval.str = cat_str(11, make_str("create"), yyvsp[-9].str, make_str("table"), yyvsp[-7].str, make_str("of"), yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 232:
#line 1279 "preproc.y"
    { yyval.str = make_str("temporary"); }
    break;

  case 233:
#line 1280 "preproc.y"
    { yyval.str = make_str("temp"); }
    break;

  case 234:
#line 1281 "preproc.y"
    { yyval.str = make_str("local temporary"); }
    break;

  case 235:
#line 1282 "preproc.y"
    { yyval.str = make_str("local temp"); }
    break;

  case 236:
#line 1283 "preproc.y"
    { yyval.str = make_str("global temporary"); }
    break;

  case 237:
#line 1284 "preproc.y"
    { yyval.str = make_str("global temp"); }
    break;

  case 238:
#line 1285 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 239:
#line 1290 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 240:
#line 1292 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 241:
#line 1295 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 242:
#line 1297 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 243:
#line 1300 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 244:
#line 1301 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 245:
#line 1302 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 246:
#line 1306 "preproc.y"
    {
			yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 247:
#line 1311 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str,yyvsp[0].str); }
    break;

  case 248:
#line 1312 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 249:
#line 1316 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 250:
#line 1317 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 251:
#line 1318 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 252:
#line 1333 "preproc.y"
    { yyval.str = make_str("not null"); }
    break;

  case 253:
#line 1335 "preproc.y"
    { yyval.str = make_str("null"); }
    break;

  case 254:
#line 1337 "preproc.y"
    { yyval.str = make_str("unique"); }
    break;

  case 255:
#line 1339 "preproc.y"
    { yyval.str = make_str("primary key"); }
    break;

  case 256:
#line 1341 "preproc.y"
    { yyval.str = cat_str(3, make_str("check ("), yyvsp[-1].str, make_str(")")); }
    break;

  case 257:
#line 1343 "preproc.y"
    { yyval.str = cat2_str(make_str("default"), yyvsp[0].str); }
    break;

  case 258:
#line 1345 "preproc.y"
    { yyval.str = cat_str(5, make_str("references"), yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 259:
#line 1359 "preproc.y"
    { yyval.str = make_str("deferrable"); }
    break;

  case 260:
#line 1360 "preproc.y"
    { yyval.str = make_str("not deferrable"); }
    break;

  case 261:
#line 1361 "preproc.y"
    { yyval.str = make_str("initially deferred"); }
    break;

  case 262:
#line 1362 "preproc.y"
    { yyval.str = make_str("initially immediate"); }
    break;

  case 263:
#line 1366 "preproc.y"
    {
			yyval.str = cat_str(3, make_str("like"), yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 264:
#line 1372 "preproc.y"
    { yyval.str = make_str("including defaults"); }
    break;

  case 265:
#line 1373 "preproc.y"
    { yyval.str = make_str("excluding defaults"); }
    break;

  case 266:
#line 1374 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 267:
#line 1382 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 268:
#line 1384 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 269:
#line 1388 "preproc.y"
    { yyval.str = cat_str(3, make_str("check("), yyvsp[-1].str, make_str(")")); }
    break;

  case 270:
#line 1390 "preproc.y"
    { yyval.str = cat_str(3, make_str("unique("), yyvsp[-1].str, make_str(")")); }
    break;

  case 271:
#line 1392 "preproc.y"
    { yyval.str = cat_str(3, make_str("primary key("), yyvsp[-1].str, make_str(")")); }
    break;

  case 272:
#line 1395 "preproc.y"
    { yyval.str = cat_str(8, make_str("foreign key("), yyvsp[-7].str, make_str(") references"), yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 273:
#line 1398 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 274:
#line 1399 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 275:
#line 1403 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 276:
#line 1405 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 277:
#line 1408 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 278:
#line 1412 "preproc.y"
    { yyval.str = make_str("match full"); }
    break;

  case 279:
#line 1414 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported FOREIGN KEY/MATCH PARTIAL will be passed to backend");
			yyval.str = make_str("match partial");
		}
    break;

  case 280:
#line 1419 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 281:
#line 1422 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 282:
#line 1423 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 283:
#line 1424 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 284:
#line 1425 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 285:
#line 1426 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 286:
#line 1430 "preproc.y"
    { yyval.str = cat2_str(make_str("on delete"), yyvsp[0].str); }
    break;

  case 287:
#line 1434 "preproc.y"
    { yyval.str = cat2_str(make_str("on update"), yyvsp[0].str); }
    break;

  case 288:
#line 1437 "preproc.y"
    { yyval.str = make_str("no action"); }
    break;

  case 289:
#line 1438 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 290:
#line 1439 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 291:
#line 1440 "preproc.y"
    { yyval.str = make_str("set default"); }
    break;

  case 292:
#line 1441 "preproc.y"
    { yyval.str = make_str("set null"); }
    break;

  case 293:
#line 1445 "preproc.y"
    { yyval.str = cat_str(3, make_str("inherits ("), yyvsp[-1].str, make_str(")")); }
    break;

  case 294:
#line 1447 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 295:
#line 1450 "preproc.y"
    { yyval.str = make_str("with oids"); }
    break;

  case 296:
#line 1451 "preproc.y"
    { yyval.str = make_str("without oids"); }
    break;

  case 297:
#line 1452 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 298:
#line 1455 "preproc.y"
    { yyval.str = make_str("on commit drop"); }
    break;

  case 299:
#line 1456 "preproc.y"
    { yyval.str = make_str("on commit delete rows"); }
    break;

  case 300:
#line 1457 "preproc.y"
    { yyval.str = make_str("on commit preserve rows"); }
    break;

  case 301:
#line 1458 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 302:
#line 1468 "preproc.y"
    { FoundInto = 0; }
    break;

  case 303:
#line 1470 "preproc.y"
    {
			if (FoundInto == 1)
				mmerror(PARSE_ERROR, ET_ERROR, "CREATE TABLE / AS SELECT may not specify INTO");

			yyval.str = cat_str(7, make_str("create"), yyvsp[-6].str, make_str("table"), yyvsp[-4].str, yyvsp[-3].str, make_str("as"), yyvsp[0].str);
		}
    break;

  case 304:
#line 1479 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 305:
#line 1481 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 306:
#line 1485 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 307:
#line 1487 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 308:
#line 1490 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 309:
#line 1502 "preproc.y"
    { yyval.str = cat_str(4, make_str("create"), yyvsp[-3].str, make_str("sequence"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 310:
#line 1506 "preproc.y"
    { yyval.str = cat_str(3,make_str("alter sequence"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 311:
#line 1509 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 312:
#line 1510 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 313:
#line 1514 "preproc.y"
    { yyval.str = cat2_str(make_str("cache"), yyvsp[0].str); }
    break;

  case 314:
#line 1516 "preproc.y"
    { yyval.str = make_str("cycle"); }
    break;

  case 315:
#line 1518 "preproc.y"
    { yyval.str = make_str("no cycle"); }
    break;

  case 316:
#line 1520 "preproc.y"
    { yyval.str = cat_str(3, make_str("increment"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 317:
#line 1522 "preproc.y"
    { yyval.str = cat2_str(make_str("maxvalue"), yyvsp[0].str); }
    break;

  case 318:
#line 1524 "preproc.y"
    { yyval.str = cat2_str(make_str("minvalue"), yyvsp[0].str); }
    break;

  case 319:
#line 1526 "preproc.y"
    { yyval.str = make_str("no maxvalue"); }
    break;

  case 320:
#line 1528 "preproc.y"
    { yyval.str = make_str("no minvalue"); }
    break;

  case 321:
#line 1530 "preproc.y"
    { yyval.str = cat_str(3, make_str("start"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 322:
#line 1532 "preproc.y"
    { yyval.str = cat_str(3, make_str("restart"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 323:
#line 1535 "preproc.y"
    { yyval.str = make_str("by"); }
    break;

  case 324:
#line 1536 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 325:
#line 1549 "preproc.y"
    { yyval.str = cat_str(8, make_str("create"), yyvsp[-6].str, yyvsp[-5].str, make_str("language"), yyvsp[-3].str, make_str("handler"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 326:
#line 1552 "preproc.y"
    { yyval.str = make_str("trusted"); }
    break;

  case 327:
#line 1553 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 328:
#line 1561 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 329:
#line 1563 "preproc.y"
    { yyval.str = yyvsp[0].str; /* XXX changing soon */ }
    break;

  case 330:
#line 1567 "preproc.y"
    { yyval.str = cat2_str(make_str("lancompiler"), yyvsp[0].str); }
    break;

  case 331:
#line 1569 "preproc.y"
    { yyval.str = ""; }
    break;

  case 332:
#line 1573 "preproc.y"
    { yyval.str = cat_str(5, make_str("drop"), yyvsp[-3].str, make_str("language"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 333:
#line 1576 "preproc.y"
    { yyval.str = make_str("prcedural"); }
    break;

  case 334:
#line 1577 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 335:
#line 1592 "preproc.y"
    { yyval.str = cat_str(12, make_str("create trigger"), yyvsp[-11].str, yyvsp[-10].str, yyvsp[-9].str, make_str("on"), yyvsp[-7].str, yyvsp[-6].str, make_str("execute procedure"), yyvsp[-3].str, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 336:
#line 1598 "preproc.y"
    { yyval.str = cat_str(13, make_str("create constraint trigger"), yyvsp[-15].str, make_str("after"), yyvsp[-13].str, make_str("on"), yyvsp[-11].str, yyvsp[-10].str, yyvsp[-9].str, make_str("for each row execute procedure"), yyvsp[-3].str, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 337:
#line 1601 "preproc.y"
    { yyval.str = make_str("before"); }
    break;

  case 338:
#line 1602 "preproc.y"
    { yyval.str = make_str("after"); }
    break;

  case 339:
#line 1606 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 340:
#line 1608 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("or"), yyvsp[0].str); }
    break;

  case 341:
#line 1610 "preproc.y"
    { yyval.str = cat_str(5, yyvsp[-4].str, make_str("or"), yyvsp[-2].str, make_str("or"), yyvsp[0].str); }
    break;

  case 342:
#line 1613 "preproc.y"
    { yyval.str = make_str("insert"); }
    break;

  case 343:
#line 1614 "preproc.y"
    { yyval.str = make_str("delete"); }
    break;

  case 344:
#line 1615 "preproc.y"
    { yyval.str = make_str("update"); }
    break;

  case 345:
#line 1619 "preproc.y"
    { yyval.str = cat_str(3, make_str("for"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 346:
#line 1621 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 347:
#line 1624 "preproc.y"
    { yyval.str = make_str("each"); }
    break;

  case 348:
#line 1625 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 349:
#line 1628 "preproc.y"
    { yyval.str = make_str("row"); }
    break;

  case 350:
#line 1629 "preproc.y"
    { yyval.str = make_str("statement"); }
    break;

  case 351:
#line 1633 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 352:
#line 1635 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 353:
#line 1637 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 354:
#line 1640 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 355:
#line 1641 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 356:
#line 1644 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 357:
#line 1645 "preproc.y"
    { yyval.str = cat2_str(make_str("from"), yyvsp[0].str); }
    break;

  case 358:
#line 1648 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 359:
#line 1650 "preproc.y"
    {
			if (strcmp(yyvsp[-1].str, "deferrable") != 0 && strcmp(yyvsp[0].str, "initially deferrable") == 0 )
				mmerror(PARSE_ERROR, ET_ERROR, "INITIALLY DEFERRED constraint must be DEFERRABLE");

			yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 360:
#line 1656 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 361:
#line 1658 "preproc.y"
    {
			if (strcmp(yyvsp[0].str, "deferrable") != 0 && strcmp(yyvsp[-1].str, "initially deferrable") == 0 )
				mmerror(PARSE_ERROR, ET_ERROR, "INITIALLY DEFERRED constraint must be DEFERRABLE");

			yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 362:
#line 1667 "preproc.y"
    { yyval.str = make_str("not deferrable"); }
    break;

  case 363:
#line 1669 "preproc.y"
    { yyval.str = make_str("deferrable"); }
    break;

  case 364:
#line 1673 "preproc.y"
    { yyval.str = make_str("initially immediate"); }
    break;

  case 365:
#line 1675 "preproc.y"
    { yyval.str = make_str("initially deferred"); }
    break;

  case 366:
#line 1679 "preproc.y"
    { yyval.str = cat_str(5, make_str("drop trigger"), yyvsp[-3].str, make_str("on"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 367:
#line 1691 "preproc.y"
    {
				mmerror(PARSE_ERROR, ET_ERROR, "CREATE ASSERTION is not yet supported");
		       		yyval.str = cat_str(6, make_str("create assertion"), yyvsp[-5].str, make_str("check ("), yyvsp[-2].str, make_str(")"), yyvsp[0].str);
			}
    break;

  case 368:
#line 1698 "preproc.y"
    {
		mmerror(PARSE_ERROR, ET_ERROR, "DROP ASSERTION is not yet supported");
		yyval.str = cat2_str(make_str("drop assertion"), yyvsp[0].str);
	}
    break;

  case 369:
#line 1713 "preproc.y"
    { yyval.str = cat_str(3, make_str("create aggregate"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 370:
#line 1715 "preproc.y"
    { yyval.str = cat_str(3, make_str("create operator"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 371:
#line 1717 "preproc.y"
    { yyval.str = cat_str(3, make_str("create type"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 372:
#line 1719 "preproc.y"
    { yyval.str = cat_str(4, make_str("create type"), yyvsp[-2].str, make_str("as"), yyvsp[0].str); }
    break;

  case 373:
#line 1723 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")"));}
    break;

  case 374:
#line 1727 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 375:
#line 1730 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 376:
#line 1731 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 377:
#line 1734 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("="), yyvsp[0].str); }
    break;

  case 378:
#line 1735 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 379:
#line 1739 "preproc.y"
    {  yyval.str = yyvsp[0].str; }
    break;

  case 380:
#line 1740 "preproc.y"
    {  yyval.str = yyvsp[0].str; }
    break;

  case 381:
#line 1741 "preproc.y"
    {  yyval.str = yyvsp[0].str; }
    break;

  case 382:
#line 1746 "preproc.y"
    {
					yyval.str = cat_str(9, make_str("create operator class"), yyvsp[-8].str, yyvsp[-7].str, make_str("for type"), yyvsp[-4].str, make_str("using"), yyvsp[-2].str, make_str("as"), yyvsp[0].str);
				}
    break;

  case 383:
#line 1751 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 384:
#line 1752 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 385:
#line 1756 "preproc.y"
    { yyval.str = cat_str(4, make_str("operator"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 386:
#line 1758 "preproc.y"
    { yyval.str =  cat_str(7, make_str("operator"), yyvsp[-5].str, yyvsp[-4].str, make_str("("), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 387:
#line 1760 "preproc.y"
    { yyval.str = cat_str(4, make_str("function"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 388:
#line 1762 "preproc.y"
    { yyval.str = cat2_str(make_str("storage"), yyvsp[0].str); }
    break;

  case 389:
#line 1765 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 390:
#line 1766 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 391:
#line 1769 "preproc.y"
    { yyval.str = make_str("recheck"); }
    break;

  case 392:
#line 1770 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 393:
#line 1774 "preproc.y"
    { yyval.str = cat_str(5,make_str("drop operator class"), yyvsp[-3].str, make_str("using"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 394:
#line 1786 "preproc.y"
    { yyval.str = cat_str(4, make_str("drop"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 395:
#line 1789 "preproc.y"
    { yyval.str = make_str("table"); }
    break;

  case 396:
#line 1790 "preproc.y"
    { yyval.str = make_str("sequence"); }
    break;

  case 397:
#line 1791 "preproc.y"
    { yyval.str = make_str("view"); }
    break;

  case 398:
#line 1792 "preproc.y"
    { yyval.str = make_str("index"); }
    break;

  case 399:
#line 1793 "preproc.y"
    { yyval.str = make_str("type"); }
    break;

  case 400:
#line 1794 "preproc.y"
    { yyval.str = make_str("domain"); }
    break;

  case 401:
#line 1795 "preproc.y"
    { yyval.str = make_str("conversion"); }
    break;

  case 402:
#line 1796 "preproc.y"
    { yyval.str = make_str("schema"); }
    break;

  case 403:
#line 1800 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 404:
#line 1802 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 405:
#line 1806 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 406:
#line 1808 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 407:
#line 1817 "preproc.y"
    { yyval.str = cat_str(3, make_str("truncate table"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 408:
#line 1832 "preproc.y"
    {
				add_additional_variables(yyvsp[-1].str, false);
				yyval.str = cat_str(4, make_str("fetch"), yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str);
			}
    break;

  case 409:
#line 1837 "preproc.y"
    {
				add_additional_variables(yyvsp[-1].str, false);
				yyval.str = cat_str(4, make_str("fetch"), yyvsp[-2].str, make_str("from"), yyvsp[-1].str);
			}
    break;

  case 410:
#line 1842 "preproc.y"
    {
			        add_additional_variables(yyvsp[-1].str, false);
				yyval.str = cat_str(3, make_str("fetch"), yyvsp[-2].str, yyvsp[-1].str);
			}
    break;

  case 411:
#line 1847 "preproc.y"
    {
			        add_additional_variables(yyvsp[-1].str, false);
				yyval.str = cat2_str(make_str("fetch"), yyvsp[-1].str);
			}
    break;

  case 412:
#line 1852 "preproc.y"
    {
			        add_additional_variables(yyvsp[0].str, false);
				yyval.str = cat_str(4, make_str("fetch"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str);
			}
    break;

  case 413:
#line 1857 "preproc.y"
    {
			        add_additional_variables(yyvsp[0].str, false);
				yyval.str = cat_str(4, make_str("fetch"), yyvsp[-1].str, make_str("from"), yyvsp[0].str);
			}
    break;

  case 414:
#line 1862 "preproc.y"
    {
				add_additional_variables(yyvsp[0].str, false);
				yyval.str = cat_str(3, make_str("fetch"), yyvsp[-1].str, yyvsp[0].str);
			}
    break;

  case 415:
#line 1867 "preproc.y"
    {
			        add_additional_variables(yyvsp[0].str, false);
				yyval.str = cat2_str(make_str("fetch"), yyvsp[0].str);
			}
    break;

  case 416:
#line 1872 "preproc.y"
    { yyval.str = cat_str(4, make_str("move"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 417:
#line 1874 "preproc.y"
    { yyval.str = cat2_str(make_str("move"), yyvsp[0].str); }
    break;

  case 418:
#line 1877 "preproc.y"
    { yyval.str = make_str("next"); }
    break;

  case 419:
#line 1878 "preproc.y"
    { yyval.str = make_str("prior"); }
    break;

  case 420:
#line 1879 "preproc.y"
    { yyval.str = make_str("first"); }
    break;

  case 421:
#line 1880 "preproc.y"
    { yyval.str = make_str("last"); }
    break;

  case 422:
#line 1881 "preproc.y"
    { yyval.str = cat2_str(make_str("absolute"), yyvsp[0].str); }
    break;

  case 423:
#line 1882 "preproc.y"
    { yyval.str = cat2_str(make_str("relative"), yyvsp[0].str); }
    break;

  case 424:
#line 1883 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 425:
#line 1884 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 426:
#line 1885 "preproc.y"
    { yyval.str = make_str("forward"); }
    break;

  case 427:
#line 1886 "preproc.y"
    { yyval.str = cat2_str(make_str("forward"), yyvsp[0].str); }
    break;

  case 428:
#line 1887 "preproc.y"
    { yyval.str = make_str("forward all"); }
    break;

  case 429:
#line 1888 "preproc.y"
    { yyval.str = make_str("backward"); }
    break;

  case 430:
#line 1889 "preproc.y"
    { yyval.str = cat2_str(make_str("backward"), yyvsp[0].str); }
    break;

  case 431:
#line 1890 "preproc.y"
    { yyval.str = make_str("backward all"); }
    break;

  case 432:
#line 1893 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 433:
#line 1896 "preproc.y"
    { yyval.str = make_str("in"); }
    break;

  case 434:
#line 1897 "preproc.y"
    { yyval.str = make_str("from"); }
    break;

  case 435:
#line 1913 "preproc.y"
    { yyval.str = cat_str(5, make_str("comment on"), yyvsp[-3].str, yyvsp[-2].str, make_str("is"), yyvsp[0].str); }
    break;

  case 436:
#line 1915 "preproc.y"
    { yyval.str = cat_str(6, make_str("comment on aggregate"), yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(") is"), yyvsp[0].str); }
    break;

  case 437:
#line 1917 "preproc.y"
    { yyval.str = cat_str(5, make_str("comment on function"), yyvsp[-3].str, yyvsp[-2].str, make_str("is"), yyvsp[0].str); }
    break;

  case 438:
#line 1919 "preproc.y"
    { yyval.str = cat_str(6, make_str("comment on operator"), yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(") is"), yyvsp[0].str); }
    break;

  case 439:
#line 1921 "preproc.y"
    { yyval.str = cat_str(6, make_str("comment on trigger"), yyvsp[-4].str, make_str("on"), yyvsp[-2].str, make_str("is"), yyvsp[0].str); }
    break;

  case 440:
#line 1923 "preproc.y"
    { yyval.str = cat_str(6, make_str("comment on rule"), yyvsp[-4].str, make_str("on"), yyvsp[-2].str, make_str("is"), yyvsp[0].str); }
    break;

  case 441:
#line 1925 "preproc.y"
    { yyval.str = cat_str(4, make_str("comment on rule"), yyvsp[-2].str, make_str("is"), yyvsp[0].str); }
    break;

  case 442:
#line 1928 "preproc.y"
    { yyval.str = make_str("column"); }
    break;

  case 443:
#line 1929 "preproc.y"
    { yyval.str = make_str("database"); }
    break;

  case 444:
#line 1930 "preproc.y"
    { yyval.str = make_str("schema"); }
    break;

  case 445:
#line 1931 "preproc.y"
    { yyval.str = make_str("idnex"); }
    break;

  case 446:
#line 1932 "preproc.y"
    { yyval.str = make_str("sequence"); }
    break;

  case 447:
#line 1933 "preproc.y"
    { yyval.str = make_str("table"); }
    break;

  case 448:
#line 1934 "preproc.y"
    { yyval.str = make_str("domain"); }
    break;

  case 449:
#line 1935 "preproc.y"
    { yyval.str = make_str("type"); }
    break;

  case 450:
#line 1936 "preproc.y"
    { yyval.str = make_str("view"); }
    break;

  case 451:
#line 1939 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 452:
#line 1940 "preproc.y"
    { yyval.str = make_str("null"); }
    break;

  case 453:
#line 1951 "preproc.y"
    { yyval.str = cat_str(7, make_str("grant"), yyvsp[-5].str, make_str("on"), yyvsp[-3].str, make_str("to"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 454:
#line 1955 "preproc.y"
    {
			  yyval.str = cat_str(9, make_str("revoke"), yyvsp[-6].str, yyvsp[-5].str, make_str("on"), yyvsp[-3].str, make_str("from"), yyvsp[-1].str, yyvsp[0].str);
			}
    break;

  case 455:
#line 1961 "preproc.y"
    { yyval.str = make_str("all privileges"); }
    break;

  case 456:
#line 1962 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 457:
#line 1963 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 458:
#line 1967 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 459:
#line 1969 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 460:
#line 1972 "preproc.y"
    { yyval.str = make_str("select"); }
    break;

  case 461:
#line 1973 "preproc.y"
    { yyval.str = make_str("insert"); }
    break;

  case 462:
#line 1974 "preproc.y"
    { yyval.str = make_str("update"); }
    break;

  case 463:
#line 1975 "preproc.y"
    { yyval.str = make_str("delete"); }
    break;

  case 464:
#line 1976 "preproc.y"
    { yyval.str = make_str("rule"); }
    break;

  case 465:
#line 1977 "preproc.y"
    { yyval.str = make_str("references"); }
    break;

  case 466:
#line 1978 "preproc.y"
    { yyval.str = make_str("trigger"); }
    break;

  case 467:
#line 1979 "preproc.y"
    { yyval.str = make_str("execute"); }
    break;

  case 468:
#line 1980 "preproc.y"
    { yyval.str = make_str("usage"); }
    break;

  case 469:
#line 1981 "preproc.y"
    { yyval.str = make_str("create"); }
    break;

  case 470:
#line 1982 "preproc.y"
    { yyval.str = make_str("temporary"); }
    break;

  case 471:
#line 1983 "preproc.y"
    { yyval.str = make_str("temp"); }
    break;

  case 472:
#line 1987 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 473:
#line 1989 "preproc.y"
    { yyval.str = cat2_str(make_str("table"), yyvsp[0].str); }
    break;

  case 474:
#line 1991 "preproc.y"
    { yyval.str = cat2_str(make_str("function"), yyvsp[0].str); }
    break;

  case 475:
#line 1993 "preproc.y"
    { yyval.str = cat2_str(make_str("database"), yyvsp[0].str); }
    break;

  case 476:
#line 1995 "preproc.y"
    { yyval.str = cat2_str(make_str("language") , yyvsp[0].str); }
    break;

  case 477:
#line 1997 "preproc.y"
    { yyval.str = cat2_str(make_str("schema") , yyvsp[0].str); }
    break;

  case 478:
#line 2001 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 479:
#line 2003 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 480:
#line 2006 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 481:
#line 2007 "preproc.y"
    { yyval.str = cat2_str(make_str("group"), yyvsp[0].str); }
    break;

  case 482:
#line 2011 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported GRANT/WITH GRANT OPTION will be passed to backend");
			yyval.str = make_str("with grant option");
		}
    break;

  case 483:
#line 2015 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 484:
#line 2019 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported REVOKE/GRANT OPTION FOR will be passed to backend");
			yyval.str = make_str("with grant option");
		}
    break;

  case 485:
#line 2023 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 486:
#line 2027 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 487:
#line 2029 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 488:
#line 2032 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 489:
#line 2045 "preproc.y"
    { yyval.str = cat_str(11, make_str("create"), yyvsp[-9].str, make_str("index"), yyvsp[-7].str, make_str("on"), yyvsp[-5].str, yyvsp[-4].str, make_str("("), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 490:
#line 2048 "preproc.y"
    { yyval.str = make_str("unique"); }
    break;

  case 491:
#line 2049 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 492:
#line 2053 "preproc.y"
    { yyval.str = cat2_str(make_str("using"), yyvsp[0].str); }
    break;

  case 493:
#line 2055 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 494:
#line 2058 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 495:
#line 2059 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 496:
#line 2063 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 497:
#line 2065 "preproc.y"
    { yyval.str = cat_str(5, yyvsp[-4].str, make_str("("), yyvsp[-2].str, ")", yyvsp[0].str); }
    break;

  case 498:
#line 2067 "preproc.y"
    { yyval.str = cat_str(4, make_str("("), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 499:
#line 2070 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 500:
#line 2071 "preproc.y"
    { yyval.str = cat2_str(make_str("using"), yyvsp[0].str); }
    break;

  case 501:
#line 2072 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 502:
#line 2077 "preproc.y"
    { yyval.str = cat_str(8, make_str("create"), yyvsp[-7].str, make_str("function"), yyvsp[-5].str, yyvsp[-4].str, make_str("returns"), yyvsp[-2].str, yyvsp[-1].str); }
    break;

  case 503:
#line 2080 "preproc.y"
    { yyval.str = make_str("or replace"); }
    break;

  case 504:
#line 2081 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 505:
#line 2085 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 506:
#line 2087 "preproc.y"
    { yyval.str = make_str("()"); }
    break;

  case 507:
#line 2091 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 508:
#line 2093 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 509:
#line 2097 "preproc.y"
    {
			/* We can catch over-specified arguments here if we want to,
			 * but for now better to silently swallow typmod, etc.
			 * - thomas 2000-03-22
			 */
			yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 510:
#line 2104 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 511:
#line 2107 "preproc.y"
    { yyval.str = make_str("in"); }
    break;

  case 512:
#line 2109 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported CREATE FUNCTION/OUT will be passed to backend");

			yyval.str = make_str("out");
		}
    break;

  case 513:
#line 2115 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported CREATE FUNCTION/INOUT will be passed to backend");

			yyval.str = make_str("inout");
		}
    break;

  case 514:
#line 2123 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 515:
#line 2125 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 516:
#line 2129 "preproc.y"
    {
			/* We can catch over-specified arguments here if we want to,
			 * but for now better to silently swallow typmod, etc.
			 * - thomas 2000-03-22
			 */
			yyval.str = yyvsp[0].str;
		}
    break;

  case 517:
#line 2139 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 518:
#line 2141 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-3].str, yyvsp[-2].str, make_str("% type")); }
    break;

  case 519:
#line 2146 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 520:
#line 2148 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 521:
#line 2152 "preproc.y"
    { yyval.str = cat2_str(make_str("as"), yyvsp[0].str); }
    break;

  case 522:
#line 2154 "preproc.y"
    { yyval.str = cat2_str(make_str("language"), yyvsp[0].str); }
    break;

  case 523:
#line 2156 "preproc.y"
    { yyval.str = make_str("immutable"); }
    break;

  case 524:
#line 2158 "preproc.y"
    { yyval.str = make_str("stable"); }
    break;

  case 525:
#line 2160 "preproc.y"
    { yyval.str = make_str("volatile"); }
    break;

  case 526:
#line 2162 "preproc.y"
    { yyval.str = make_str("called on null input"); }
    break;

  case 527:
#line 2164 "preproc.y"
    { yyval.str = make_str("returns null on null input"); }
    break;

  case 528:
#line 2166 "preproc.y"
    { yyval.str = make_str("strict"); }
    break;

  case 529:
#line 2168 "preproc.y"
    { yyval.str = make_str("external security definer"); }
    break;

  case 530:
#line 2170 "preproc.y"
    { yyval.str = make_str("external security invoker"); }
    break;

  case 531:
#line 2172 "preproc.y"
    { yyval.str = make_str("security definer"); }
    break;

  case 532:
#line 2174 "preproc.y"
    { yyval.str = make_str("security invoker"); }
    break;

  case 533:
#line 2177 "preproc.y"
    { yyval.str = cat2_str(make_str("with"), yyvsp[0].str); }
    break;

  case 534:
#line 2178 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 535:
#line 2192 "preproc.y"
    { yyval.str = cat_str(4, make_str("drop function"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 536:
#line 2196 "preproc.y"
    { yyval.str = cat_str(6, make_str("drop aggregate"), yyvsp[-4].str, make_str("("), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 537:
#line 2199 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 538:
#line 2200 "preproc.y"
    { yyval.str = make_str("*"); }
    break;

  case 539:
#line 2205 "preproc.y"
    { yyval.str = cat_str(6, make_str("drop operator"), yyvsp[-4].str, make_str("("), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 540:
#line 2209 "preproc.y"
    { mmerror(PARSE_ERROR, ET_ERROR, "parser: argument type missing (use NONE for unary operators)"); }
    break;

  case 541:
#line 2211 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 542:
#line 2213 "preproc.y"
    { yyval.str = cat2_str(make_str("none,"), yyvsp[0].str); }
    break;

  case 543:
#line 2215 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-2].str, make_str(", none")); }
    break;

  case 544:
#line 2220 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 545:
#line 2222 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("."), yyvsp[0].str); }
    break;

  case 546:
#line 2227 "preproc.y"
    { yyval.str = cat_str(6, make_str("create cast ("), yyvsp[-7].str, make_str("as"), yyvsp[-5].str, make_str(") with function"), yyvsp[-1].str); }
    break;

  case 547:
#line 2230 "preproc.y"
    { yyval.str = cat_str(6, make_str("create cast ("), yyvsp[-6].str, make_str("as"), yyvsp[-4].str, make_str(") without function"), yyvsp[0].str); }
    break;

  case 548:
#line 2233 "preproc.y"
    { yyval.str = make_str("as assignment"); }
    break;

  case 549:
#line 2234 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 550:
#line 2239 "preproc.y"
    { yyval.str = cat_str(6, make_str("drop cast ("), yyvsp[-4].str, make_str("as"), yyvsp[-2].str, make_str(")"), yyvsp[0].str); }
    break;

  case 551:
#line 2250 "preproc.y"
    { yyval.str = cat_str(4, make_str("reindex"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 552:
#line 2252 "preproc.y"
    { yyval.str = cat_str(3, make_str("reindex database"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 553:
#line 2255 "preproc.y"
    { yyval.str = make_str("index"); }
    break;

  case 554:
#line 2256 "preproc.y"
    { yyval.str = make_str("table"); }
    break;

  case 555:
#line 2259 "preproc.y"
    { yyval.str = make_str("force"); }
    break;

  case 556:
#line 2260 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 557:
#line 2272 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter aggregate"), yyvsp[-6].str, make_str("("), yyvsp[-4].str, make_str(") rename to"), yyvsp[0].str); }
    break;

  case 558:
#line 2274 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter conversion"), yyvsp[-3].str, make_str("rename to"), yyvsp[0].str); }
    break;

  case 559:
#line 2276 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter database"), yyvsp[-3].str, make_str("rename to"), yyvsp[0].str); }
    break;

  case 560:
#line 2278 "preproc.y"
    { yyval.str 