.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE VIEW" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE VIEW \- define a new view
.SH SYNOPSIS
.sp
.nf
CREATE [ OR REPLACE ] VIEW \fIview\fR [ ( \fIcolumn name list\fR ) ] AS SELECT \fIquery\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIview\fB\fR
The name (optionally schema-qualified) of a view to be created.
.TP
\fB\fIcolumn name list\fB\fR
An optional list of names to be used for columns of the view.
If given, these names override the column names that would be
deduced from the SQL query.
.TP
\fB\fIquery\fB\fR
An SQL query (that is, a \fBSELECT\fR statement)
which will provide the columns and rows of the view.

Refer to SELECT [\fBselect\fR(l)] for more information
about valid arguments.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE VIEW\fR
The message returned if the view is successfully created.
.TP
\fBERROR: Relation '\fIview\fB' already exists\fR
This error occurs if the view specified already exists in the database.
.TP
\fBWARNING: Attribute '\fIcolumn\fB' has an unknown type\fR
The view will be created having a column with an unknown type
if you do not specify it. For example, the following command gives
a warning:
.sp
.nf
CREATE VIEW vista AS SELECT 'Hello World'
	
.sp
.fi
whereas this command does not:
.sp
.nf
CREATE VIEW vista AS SELECT text 'Hello World'
	
.sp
.fi
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE VIEW\fR defines a view of a query.
The view is not physically materialized. Instead, a query
rewrite rule (an ON SELECT rule) is automatically generated to
support SELECT operations on views.
.PP
\fBCREATE OR REPLACE VIEW\fR is similar, but if a view
of the same name already exists, it is replaced. You can only replace
a view with a new query that generates the identical set of columns
(i.e., same column names and data types).
.PP
If a schema name is given (for example, CREATE VIEW
myschema.myview ...) then the view is created in the
specified schema. Otherwise it is created in the current schema (the one
at the front of the search path; see CURRENT_SCHEMA()).
The view name must be distinct from the name of any other view, table,
sequence, or index in the same schema.
.SS "NOTES"
.PP
Currently, views are read only: the system will not allow an insert,
update, or delete on a view. You can get the effect of an updatable
view by creating rules that rewrite inserts, etc. on the view into
appropriate actions on other tables. For more information see
CREATE RULE [\fBcreate_rule\fR(l)].
.PP
Use the \fBDROP VIEW\fR statement to drop views.
.SH "USAGE"
.PP
Create a view consisting of all Comedy films:
.sp
.nf
CREATE VIEW kinds AS
    SELECT *
    FROM films
    WHERE kind = 'Comedy';

SELECT * FROM kinds;

 code  |           title           | did | date_prod  |  kind  | len
-------+---------------------------+-----+------------+--------+-------
 UA502 | Bananas                   | 105 | 1971-07-13 | Comedy | 01:22
 C_701 | There's a Girl in my Soup | 107 | 1970-06-11 | Comedy | 01:36
(2 rows)
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for the
\fBCREATE VIEW\fR statement:
.sp
.nf
CREATE VIEW \fIview\fR [ \fIcolumn\fR [, ...] ]
    AS SELECT \fIexpression\fR [ AS \fIcolname\fR ] [, ...]
    FROM \fItable\fR [ WHERE \fIcondition\fR ]
    [ WITH [ CASCADE | LOCAL ] CHECK OPTION ]
   
.sp
.fi
.PP
The optional clauses for the full SQL92 command are:
.TP
\fBCHECK OPTION\fR
This option is to do with updatable views.
All \fBINSERT\fR and \fBUPDATE\fR commands on the view will be
checked to ensure data satisfy the view-defining
condition. If they do not, the update will be rejected.
.TP
\fBLOCAL\fR
Check for integrity on this view.
.TP
\fBCASCADE\fR
Check for integrity on this view and on any dependent
view. CASCADE is assumed if neither CASCADE nor LOCAL is specified.
.PP
.PP
\fBCREATE OR REPLACE VIEW\fR is a
PostgreSQL language extension.
