-- SQL_ASCII --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION ascii_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/ascii_and_mic', 'ascii_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.ascii_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.ascii_to_mic FOR 'SQL_ASCII' TO 'MULE_INTERNAL' FROM ascii_to_mic;
-- MULE_INTERNAL --> SQL_ASCII
CREATE OR REPLACE FUNCTION mic_to_ascii (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/ascii_and_mic', 'mic_to_ascii' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_ascii;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_ascii FOR 'MULE_INTERNAL' TO 'SQL_ASCII' FROM mic_to_ascii;
-- KOI8R --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION koi8r_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'koi8r_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.koi8_r_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.koi8_r_to_mic FOR 'KOI8R' TO 'MULE_INTERNAL' FROM koi8r_to_mic;
-- MULE_INTERNAL --> KOI8R
CREATE OR REPLACE FUNCTION mic_to_koi8r (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'mic_to_koi8r' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_koi8_r;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_koi8_r FOR 'MULE_INTERNAL' TO 'KOI8R' FROM mic_to_koi8r;
-- ISO-8859-5 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION iso_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'iso_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_5_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_5_to_mic FOR 'ISO-8859-5' TO 'MULE_INTERNAL' FROM iso_to_mic;
-- MULE_INTERNAL --> ISO-8859-5
CREATE OR REPLACE FUNCTION mic_to_iso (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'mic_to_iso' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_iso_8859_5;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_iso_8859_5 FOR 'MULE_INTERNAL' TO 'ISO-8859-5' FROM mic_to_iso;
-- WIN1251 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION win1251_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'win1251_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1251_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.windows_1251_to_mic FOR 'WIN1251' TO 'MULE_INTERNAL' FROM win1251_to_mic;
-- MULE_INTERNAL --> WIN1251
CREATE OR REPLACE FUNCTION mic_to_win1251 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'mic_to_win1251' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_windows_1251;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_windows_1251 FOR 'MULE_INTERNAL' TO 'WIN1251' FROM mic_to_win1251;
-- ALT --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION alt_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'alt_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_866_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.windows_866_to_mic FOR 'ALT' TO 'MULE_INTERNAL' FROM alt_to_mic;
-- MULE_INTERNAL --> ALT
CREATE OR REPLACE FUNCTION mic_to_alt (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'mic_to_alt' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_windows_866;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_windows_866 FOR 'MULE_INTERNAL' TO 'ALT' FROM mic_to_alt;
-- KOI8R --> WIN1251
CREATE OR REPLACE FUNCTION koi8r_to_win1251 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'koi8r_to_win1251' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.koi8_r_to_windows_1251;
CREATE DEFAULT CONVERSION pg_catalog.koi8_r_to_windows_1251 FOR 'KOI8R' TO 'WIN1251' FROM koi8r_to_win1251;
-- WIN1251 --> KOI8R
CREATE OR REPLACE FUNCTION win1251_to_koi8r (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'win1251_to_koi8r' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1251_to_koi8_r;
CREATE DEFAULT CONVERSION pg_catalog.windows_1251_to_koi8_r FOR 'WIN1251' TO 'KOI8R' FROM win1251_to_koi8r;
-- KOI8R --> ALT
CREATE OR REPLACE FUNCTION koi8r_to_alt (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'koi8r_to_alt' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.koi8_r_to_windows_866;
CREATE DEFAULT CONVERSION pg_catalog.koi8_r_to_windows_866 FOR 'KOI8R' TO 'ALT' FROM koi8r_to_alt;
-- ALT --> KOI8R
CREATE OR REPLACE FUNCTION alt_to_koi8r (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'alt_to_koi8r' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_866_to_koi8_r;
CREATE DEFAULT CONVERSION pg_catalog.windows_866_to_koi8_r FOR 'ALT' TO 'KOI8R' FROM alt_to_koi8r;
-- ALT --> WIN1251
CREATE OR REPLACE FUNCTION alt_to_win1251 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'alt_to_win1251' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_866_to_windows_1251;
CREATE DEFAULT CONVERSION pg_catalog.windows_866_to_windows_1251 FOR 'ALT' TO 'WIN1251' FROM alt_to_win1251;
-- WIN1251 --> ALT
CREATE OR REPLACE FUNCTION win1251_to_alt (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'win1251_to_alt' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1251_to_windows_866;
CREATE DEFAULT CONVERSION pg_catalog.windows_1251_to_windows_866 FOR 'WIN1251' TO 'ALT' FROM win1251_to_alt;
-- ISO-8859-5 --> KOI8R
CREATE OR REPLACE FUNCTION iso_to_koi8r (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'iso_to_koi8r' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_5_to_koi8_r;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_5_to_koi8_r FOR 'ISO-8859-5' TO 'KOI8R' FROM iso_to_koi8r;
-- KOI8R --> ISO-8859-5
CREATE OR REPLACE FUNCTION koi8r_to_iso (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'koi8r_to_iso' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.koi8_r_to_iso_8859_5;
CREATE DEFAULT CONVERSION pg_catalog.koi8_r_to_iso_8859_5 FOR 'KOI8R' TO 'ISO-8859-5' FROM koi8r_to_iso;
-- ISO-8859-5 --> WIN1251
CREATE OR REPLACE FUNCTION iso_to_win1251 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'iso_to_win1251' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_5_to_windows_1251;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_5_to_windows_1251 FOR 'ISO-8859-5' TO 'WIN1251' FROM iso_to_win1251;
-- WIN1251 --> ISO-8859-5
CREATE OR REPLACE FUNCTION win1251_to_iso (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'win1251_to_iso' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1251_to_iso_8859_5;
CREATE DEFAULT CONVERSION pg_catalog.windows_1251_to_iso_8859_5 FOR 'WIN1251' TO 'ISO-8859-5' FROM win1251_to_iso;
-- ISO-8859-5 --> ALT
CREATE OR REPLACE FUNCTION iso_to_alt (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'iso_to_alt' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_5_to_windows_866;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_5_to_windows_866 FOR 'ISO-8859-5' TO 'ALT' FROM iso_to_alt;
-- ALT --> ISO-8859-5
CREATE OR REPLACE FUNCTION alt_to_iso (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/cyrillic_and_mic', 'alt_to_iso' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_866_to_iso_8859_5;
CREATE DEFAULT CONVERSION pg_catalog.windows_866_to_iso_8859_5 FOR 'ALT' TO 'ISO-8859-5' FROM alt_to_iso;
-- EUC_CN --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION euc_cn_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_cn_and_mic', 'euc_cn_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_cn_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.euc_cn_to_mic FOR 'EUC_CN' TO 'MULE_INTERNAL' FROM euc_cn_to_mic;
-- MULE_INTERNAL --> EUC_CN
CREATE OR REPLACE FUNCTION mic_to_euc_cn (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_cn_and_mic', 'mic_to_euc_cn' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_euc_cn;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_euc_cn FOR 'MULE_INTERNAL' TO 'EUC_CN' FROM mic_to_euc_cn;
-- EUC_JP --> SJIS
CREATE OR REPLACE FUNCTION euc_jp_to_sjis (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'euc_jp_to_sjis' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_jp_to_sjis;
CREATE DEFAULT CONVERSION pg_catalog.euc_jp_to_sjis FOR 'EUC_JP' TO 'SJIS' FROM euc_jp_to_sjis;
-- SJIS --> EUC_JP
CREATE OR REPLACE FUNCTION sjis_to_euc_jp (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'sjis_to_euc_jp' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.sjis_to_euc_jp;
CREATE DEFAULT CONVERSION pg_catalog.sjis_to_euc_jp FOR 'SJIS' TO 'EUC_JP' FROM sjis_to_euc_jp;
-- EUC_JP --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION euc_jp_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'euc_jp_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_jp_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.euc_jp_to_mic FOR 'EUC_JP' TO 'MULE_INTERNAL' FROM euc_jp_to_mic;
-- SJIS --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION sjis_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'sjis_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.sjis_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.sjis_to_mic FOR 'SJIS' TO 'MULE_INTERNAL' FROM sjis_to_mic;
-- MULE_INTERNAL --> EUC_JP
CREATE OR REPLACE FUNCTION mic_to_euc_jp (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'mic_to_euc_jp' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_euc_jp;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_euc_jp FOR 'MULE_INTERNAL' TO 'EUC_JP' FROM mic_to_euc_jp;
-- MULE_INTERNAL --> SJIS
CREATE OR REPLACE FUNCTION mic_to_sjis (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_jp_and_sjis', 'mic_to_sjis' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_sjis;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_sjis FOR 'MULE_INTERNAL' TO 'SJIS' FROM mic_to_sjis;
-- EUC_KR --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION euc_kr_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_kr_and_mic', 'euc_kr_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_kr_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.euc_kr_to_mic FOR 'EUC_KR' TO 'MULE_INTERNAL' FROM euc_kr_to_mic;
-- MULE_INTERNAL --> EUC_KR
CREATE OR REPLACE FUNCTION mic_to_euc_kr (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_kr_and_mic', 'mic_to_euc_kr' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_euc_kr;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_euc_kr FOR 'MULE_INTERNAL' TO 'EUC_KR' FROM mic_to_euc_kr;
-- EUC_TW --> BIG5
CREATE OR REPLACE FUNCTION euc_tw_to_big5 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'euc_tw_to_big5' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_tw_to_big5;
CREATE DEFAULT CONVERSION pg_catalog.euc_tw_to_big5 FOR 'EUC_TW' TO 'BIG5' FROM euc_tw_to_big5;
-- BIG5 --> EUC_TW
CREATE OR REPLACE FUNCTION big5_to_euc_tw (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'big5_to_euc_tw' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.big5_to_euc_tw;
CREATE DEFAULT CONVERSION pg_catalog.big5_to_euc_tw FOR 'BIG5' TO 'EUC_TW' FROM big5_to_euc_tw;
-- EUC_TW --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION euc_tw_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'euc_tw_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_tw_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.euc_tw_to_mic FOR 'EUC_TW' TO 'MULE_INTERNAL' FROM euc_tw_to_mic;
-- BIG5 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION big5_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'big5_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.big5_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.big5_to_mic FOR 'BIG5' TO 'MULE_INTERNAL' FROM big5_to_mic;
-- MULE_INTERNAL --> EUC_TW
CREATE OR REPLACE FUNCTION mic_to_euc_tw (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'mic_to_euc_tw' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_euc_tw;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_euc_tw FOR 'MULE_INTERNAL' TO 'EUC_TW' FROM mic_to_euc_tw;
-- MULE_INTERNAL --> BIG5
CREATE OR REPLACE FUNCTION mic_to_big5 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/euc_tw_and_big5', 'mic_to_big5' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_big5;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_big5 FOR 'MULE_INTERNAL' TO 'BIG5' FROM mic_to_big5;
-- LATIN2 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION latin2_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'latin2_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_2_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_2_to_mic FOR 'LATIN2' TO 'MULE_INTERNAL' FROM latin2_to_mic;
-- MULE_INTERNAL --> LATIN2
CREATE OR REPLACE FUNCTION mic_to_latin2 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'mic_to_latin2' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_iso_8859_2;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_iso_8859_2 FOR 'MULE_INTERNAL' TO 'LATIN2' FROM mic_to_latin2;
-- WIN1250 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION win1250_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'win1250_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1250_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.windows_1250_to_mic FOR 'WIN1250' TO 'MULE_INTERNAL' FROM win1250_to_mic;
-- MULE_INTERNAL --> WIN1250
CREATE OR REPLACE FUNCTION mic_to_win1250 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'mic_to_win1250' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_windows_1250;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_windows_1250 FOR 'MULE_INTERNAL' TO 'WIN1250' FROM mic_to_win1250;
-- LATIN2 --> WIN1250
CREATE OR REPLACE FUNCTION latin2_to_win1250 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'latin2_to_win1250' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_2_to_windows_1250;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_2_to_windows_1250 FOR 'LATIN2' TO 'WIN1250' FROM latin2_to_win1250;
-- WIN1250 --> LATIN2
CREATE OR REPLACE FUNCTION win1250_to_latin2 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin2_and_win1250', 'win1250_to_latin2' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1250_to_iso_8859_2;
CREATE DEFAULT CONVERSION pg_catalog.windows_1250_to_iso_8859_2 FOR 'WIN1250' TO 'LATIN2' FROM win1250_to_latin2;
-- LATIN1 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION latin1_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'latin1_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_1_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_1_to_mic FOR 'LATIN1' TO 'MULE_INTERNAL' FROM latin1_to_mic;
-- MULE_INTERNAL --> LATIN1
CREATE OR REPLACE FUNCTION mic_to_latin1 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'mic_to_latin1' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_iso_8859_1;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_iso_8859_1 FOR 'MULE_INTERNAL' TO 'LATIN1' FROM mic_to_latin1;
-- LATIN3 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION latin3_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'latin3_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_3_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_3_to_mic FOR 'LATIN3' TO 'MULE_INTERNAL' FROM latin3_to_mic;
-- MULE_INTERNAL --> LATIN3
CREATE OR REPLACE FUNCTION mic_to_latin3 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'mic_to_latin3' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_iso_8859_3;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_iso_8859_3 FOR 'MULE_INTERNAL' TO 'LATIN3' FROM mic_to_latin3;
-- LATIN4 --> MULE_INTERNAL
CREATE OR REPLACE FUNCTION latin4_to_mic (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'latin4_to_mic' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_4_to_mic;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_4_to_mic FOR 'LATIN4' TO 'MULE_INTERNAL' FROM latin4_to_mic;
-- MULE_INTERNAL --> LATIN4
CREATE OR REPLACE FUNCTION mic_to_latin4 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/latin_and_mic', 'mic_to_latin4' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.mic_to_iso_8859_4;
CREATE DEFAULT CONVERSION pg_catalog.mic_to_iso_8859_4 FOR 'MULE_INTERNAL' TO 'LATIN4' FROM mic_to_latin4;
-- SQL_ASCII --> UNICODE
CREATE OR REPLACE FUNCTION ascii_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_ascii', 'ascii_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.ascii_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.ascii_to_utf_8 FOR 'SQL_ASCII' TO 'UNICODE' FROM ascii_to_utf8;
-- UNICODE --> SQL_ASCII
CREATE OR REPLACE FUNCTION utf8_to_ascii (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_ascii', 'utf8_to_ascii' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_ascii;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_ascii FOR 'UNICODE' TO 'SQL_ASCII' FROM utf8_to_ascii;
-- BIG5 --> UNICODE
CREATE OR REPLACE FUNCTION big5_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_big5', 'big5_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.big5_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.big5_to_utf_8 FOR 'BIG5' TO 'UNICODE' FROM big5_to_utf8;
-- UNICODE --> BIG5
CREATE OR REPLACE FUNCTION utf8_to_big5 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_big5', 'utf8_to_big5' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_big5;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_big5 FOR 'UNICODE' TO 'BIG5' FROM utf8_to_big5;
-- UNICODE --> KOI8R
CREATE OR REPLACE FUNCTION utf8_to_koi8r (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'utf8_to_koi8r' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_koi8_r;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_koi8_r FOR 'UNICODE' TO 'KOI8R' FROM utf8_to_koi8r;
-- KOI8R --> UNICODE
CREATE OR REPLACE FUNCTION koi8r_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'koi8r_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.koi8_r_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.koi8_r_to_utf_8 FOR 'KOI8R' TO 'UNICODE' FROM koi8r_to_utf8;
-- UNICODE --> WIN1251
CREATE OR REPLACE FUNCTION utf8_to_win1251 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'utf8_to_win1251' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_windows_1251;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_windows_1251 FOR 'UNICODE' TO 'WIN1251' FROM utf8_to_win1251;
-- WIN1251 --> UNICODE
CREATE OR REPLACE FUNCTION win1251_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'win1251_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1251_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.windows_1251_to_utf_8 FOR 'WIN1251' TO 'UNICODE' FROM win1251_to_utf8;
-- UNICODE --> ALT
CREATE OR REPLACE FUNCTION utf8_to_alt (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'utf8_to_alt' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_windows_866;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_windows_866 FOR 'UNICODE' TO 'ALT' FROM utf8_to_alt;
-- ALT --> UNICODE
CREATE OR REPLACE FUNCTION alt_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_cyrillic', 'alt_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_866_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.windows_866_to_utf_8 FOR 'ALT' TO 'UNICODE' FROM alt_to_utf8;
-- EUC_CN --> UNICODE
CREATE OR REPLACE FUNCTION euc_cn_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_cn', 'euc_cn_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_cn_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.euc_cn_to_utf_8 FOR 'EUC_CN' TO 'UNICODE' FROM euc_cn_to_utf8;
-- UNICODE --> EUC_CN
CREATE OR REPLACE FUNCTION utf8_to_euc_cn (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_cn', 'utf8_to_euc_cn' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_euc_cn;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_euc_cn FOR 'UNICODE' TO 'EUC_CN' FROM utf8_to_euc_cn;
-- EUC_JP --> UNICODE
CREATE OR REPLACE FUNCTION euc_jp_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_jp', 'euc_jp_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_jp_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.euc_jp_to_utf_8 FOR 'EUC_JP' TO 'UNICODE' FROM euc_jp_to_utf8;
-- UNICODE --> EUC_JP
CREATE OR REPLACE FUNCTION utf8_to_euc_jp (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_jp', 'utf8_to_euc_jp' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_euc_jp;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_euc_jp FOR 'UNICODE' TO 'EUC_JP' FROM utf8_to_euc_jp;
-- EUC_KR --> UNICODE
CREATE OR REPLACE FUNCTION euc_kr_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_kr', 'euc_kr_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_kr_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.euc_kr_to_utf_8 FOR 'EUC_KR' TO 'UNICODE' FROM euc_kr_to_utf8;
-- UNICODE --> EUC_KR
CREATE OR REPLACE FUNCTION utf8_to_euc_kr (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_kr', 'utf8_to_euc_kr' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_euc_kr;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_euc_kr FOR 'UNICODE' TO 'EUC_KR' FROM utf8_to_euc_kr;
-- EUC_TW --> UNICODE
CREATE OR REPLACE FUNCTION euc_tw_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_tw', 'euc_tw_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.euc_tw_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.euc_tw_to_utf_8 FOR 'EUC_TW' TO 'UNICODE' FROM euc_tw_to_utf8;
-- UNICODE --> EUC_TW
CREATE OR REPLACE FUNCTION utf8_to_euc_tw (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_euc_tw', 'utf8_to_euc_tw' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_euc_tw;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_euc_tw FOR 'UNICODE' TO 'EUC_TW' FROM utf8_to_euc_tw;
-- GB18030 --> UNICODE
CREATE OR REPLACE FUNCTION gb18030_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_gb18030', 'gb18030_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.gb18030_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.gb18030_to_utf_8 FOR 'GB18030' TO 'UNICODE' FROM gb18030_to_utf8;
-- UNICODE --> GB18030
CREATE OR REPLACE FUNCTION utf8_to_gb18030 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_gb18030', 'utf8_to_gb18030' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_gb18030;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_gb18030 FOR 'UNICODE' TO 'GB18030' FROM utf8_to_gb18030;
-- GBK --> UNICODE
CREATE OR REPLACE FUNCTION gbk_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_gbk', 'gbk_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.gbk_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.gbk_to_utf_8 FOR 'GBK' TO 'UNICODE' FROM gbk_to_utf8;
-- UNICODE --> GBK
CREATE OR REPLACE FUNCTION utf8_to_gbk (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_gbk', 'utf8_to_gbk' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_gbk;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_gbk FOR 'UNICODE' TO 'GBK' FROM utf8_to_gbk;
-- UNICODE --> LATIN2
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_2;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_2 FOR 'UNICODE' TO 'LATIN2' FROM utf8_to_iso8859;
-- LATIN2 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_2_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_2_to_utf_8 FOR 'LATIN2' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN3
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_3;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_3 FOR 'UNICODE' TO 'LATIN3' FROM utf8_to_iso8859;
-- LATIN3 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_3_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_3_to_utf_8 FOR 'LATIN3' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN4
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_4;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_4 FOR 'UNICODE' TO 'LATIN4' FROM utf8_to_iso8859;
-- LATIN4 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_4_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_4_to_utf_8 FOR 'LATIN4' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN5
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_9;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_9 FOR 'UNICODE' TO 'LATIN5' FROM utf8_to_iso8859;
-- LATIN5 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_9_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_9_to_utf_8 FOR 'LATIN5' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN6
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_10;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_10 FOR 'UNICODE' TO 'LATIN6' FROM utf8_to_iso8859;
-- LATIN6 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_10_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_10_to_utf_8 FOR 'LATIN6' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN7
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_13;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_13 FOR 'UNICODE' TO 'LATIN7' FROM utf8_to_iso8859;
-- LATIN7 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_13_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_13_to_utf_8 FOR 'LATIN7' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN8
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_14;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_14 FOR 'UNICODE' TO 'LATIN8' FROM utf8_to_iso8859;
-- LATIN8 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_14_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_14_to_utf_8 FOR 'LATIN8' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN9
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_15;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_15 FOR 'UNICODE' TO 'LATIN9' FROM utf8_to_iso8859;
-- LATIN9 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_15_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_15_to_utf_8 FOR 'LATIN9' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> LATIN10
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_16;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_16 FOR 'UNICODE' TO 'LATIN10' FROM utf8_to_iso8859;
-- LATIN10 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_16_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_16_to_utf_8 FOR 'LATIN10' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> ISO-8859-5
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_5;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_5 FOR 'UNICODE' TO 'ISO-8859-5' FROM utf8_to_iso8859;
-- ISO-8859-5 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_5_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_5_to_utf_8 FOR 'ISO-8859-5' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> ISO-8859-6
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_6;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_6 FOR 'UNICODE' TO 'ISO-8859-6' FROM utf8_to_iso8859;
-- ISO-8859-6 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_6_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_6_to_utf_8 FOR 'ISO-8859-6' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> ISO-8859-7
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_7;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_7 FOR 'UNICODE' TO 'ISO-8859-7' FROM utf8_to_iso8859;
-- ISO-8859-7 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_7_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_7_to_utf_8 FOR 'ISO-8859-7' TO 'UNICODE' FROM iso8859_to_utf8;
-- UNICODE --> ISO-8859-8
CREATE OR REPLACE FUNCTION utf8_to_iso8859 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'utf8_to_iso8859' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_8;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_8 FOR 'UNICODE' TO 'ISO-8859-8' FROM utf8_to_iso8859;
-- ISO-8859-8 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859', 'iso8859_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_8_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_8_to_utf_8 FOR 'ISO-8859-8' TO 'UNICODE' FROM iso8859_to_utf8;
-- LATIN1 --> UNICODE
CREATE OR REPLACE FUNCTION iso8859_1_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859_1', 'iso8859_1_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.iso_8859_1_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.iso_8859_1_to_utf_8 FOR 'LATIN1' TO 'UNICODE' FROM iso8859_1_to_utf8;
-- UNICODE --> LATIN1
CREATE OR REPLACE FUNCTION utf8_to_iso8859_1 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_iso8859_1', 'utf8_to_iso8859_1' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_iso_8859_1;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_iso_8859_1 FOR 'UNICODE' TO 'LATIN1' FROM utf8_to_iso8859_1;
-- JOHAB --> UNICODE
CREATE OR REPLACE FUNCTION johab_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_johab', 'johab_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.johab_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.johab_to_utf_8 FOR 'JOHAB' TO 'UNICODE' FROM johab_to_utf8;
-- UNICODE --> JOHAB
CREATE OR REPLACE FUNCTION utf8_to_johab (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_johab', 'utf8_to_johab' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_johab;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_johab FOR 'UNICODE' TO 'JOHAB' FROM utf8_to_johab;
-- SJIS --> UNICODE
CREATE OR REPLACE FUNCTION sjis_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_sjis', 'sjis_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.sjis_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.sjis_to_utf_8 FOR 'SJIS' TO 'UNICODE' FROM sjis_to_utf8;
-- UNICODE --> SJIS
CREATE OR REPLACE FUNCTION utf8_to_sjis (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_sjis', 'utf8_to_sjis' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_sjis;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_sjis FOR 'UNICODE' TO 'SJIS' FROM utf8_to_sjis;
-- TCVN --> UNICODE
CREATE OR REPLACE FUNCTION tcvn_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_tcvn', 'tcvn_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.tcvn_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.tcvn_to_utf_8 FOR 'TCVN' TO 'UNICODE' FROM tcvn_to_utf8;
-- UNICODE --> TCVN
CREATE OR REPLACE FUNCTION utf8_to_tcvn (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_tcvn', 'utf8_to_tcvn' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_tcvn;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_tcvn FOR 'UNICODE' TO 'TCVN' FROM utf8_to_tcvn;
-- UHC --> UNICODE
CREATE OR REPLACE FUNCTION uhc_to_utf8 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_uhc', 'uhc_to_utf8' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.uhc_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.uhc_to_utf_8 FOR 'UHC' TO 'UNICODE' FROM uhc_to_utf8;
-- UNICODE --> UHC
CREATE OR REPLACE FUNCTION utf8_to_uhc (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_uhc', 'utf8_to_uhc' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_uhc;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_uhc FOR 'UNICODE' TO 'UHC' FROM utf8_to_uhc;
-- UNICODE --> WIN1250
CREATE OR REPLACE FUNCTION utf_to_win1250 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win1250', 'utf_to_win1250' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_windows_1250;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_windows_1250 FOR 'UNICODE' TO 'WIN1250' FROM utf_to_win1250;
-- WIN1250 --> UNICODE
CREATE OR REPLACE FUNCTION win1250_to_utf (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win1250', 'win1250_to_utf' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1250_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.windows_1250_to_utf_8 FOR 'WIN1250' TO 'UNICODE' FROM win1250_to_utf;
-- UNICODE --> WIN1256
CREATE OR REPLACE FUNCTION utf_to_win1256 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win1256', 'utf_to_win1256' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_windows_1256;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_windows_1256 FOR 'UNICODE' TO 'WIN1256' FROM utf_to_win1256;
-- WIN1256 --> UNICODE
CREATE OR REPLACE FUNCTION win1256_to_utf (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win1256', 'win1256_to_utf' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_1256_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.windows_1256_to_utf_8 FOR 'WIN1256' TO 'UNICODE' FROM win1256_to_utf;
-- UNICODE --> WIN874
CREATE OR REPLACE FUNCTION utf_to_win874 (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win874', 'utf_to_win874' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.utf_8_to_windows_874;
CREATE DEFAULT CONVERSION pg_catalog.utf_8_to_windows_874 FOR 'UNICODE' TO 'WIN874' FROM utf_to_win874;
-- WIN874 --> UNICODE
CREATE OR REPLACE FUNCTION win874_to_utf (INTEGER, INTEGER, CSTRING, INTERNAL, INTEGER) RETURNS VOID AS '$libdir/utf8_and_win874', 'win874_to_utf' LANGUAGE 'c' STRICT;
DROP CONVERSION pg_catalog.windows_874_to_utf_8;
CREATE DEFAULT CONVERSION pg_catalog.windows_874_to_utf_8 FOR 'WIN874' TO 'UNICODE' FROM win874_to_utf;
