<?php

/**************************************************
Program name:	get_array_triggers.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of triggers (regular and RI)
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/
/*
pg_trigger
0 -  tgrelid        | oid        | 
1 -  tgname         | name       |
2 -  tgtype (WHEN)
3 -  EVENT
4 -  pg_class.relname
5 -  pg_proc.proname 
6 -  tgfoid         | oid        | 
7 -  tgenabled      | boolean    | 
8 -  tgisconstraint | boolean    | 
9 -  tgconstrname   | name       | 
10 -  tgconstrrelid  | oid        | 
11 -  tgdeferrable   | boolean    | 
12 - tginitdeferred | boolean    | 
13 - tgnargs        | smallint   | 
14 - tgattr         | int2vector | 
15 - tgargs         | bytea      |

           tgname            | tgtype 
-----------------------------+--------
 after_insert                |      5
 before_Insert               |      7
 after_delete                |      9
 before_delete               |     11
 after_insert_delete         |     13
 before_insert_delete        |     15
 after_update                |     17
 before_update               |     19
 after_insert_Update         |     21
 before_insert_update        |     23
 after_update_delete         |     25
 before_update_delete        |     27
 after_insert_update_delete  |     29
 before_insert_update_delete |     31
(14 rows)
*/

// SQL string to get triggers on table
$sql_get = "
	SELECT  
	 	ptr.tgrelid,
		ptr.tgname as ".dquotes($strTrigger).",
		ptr.tgtype as ".dquotes($strWhen).",
		4 as ".dquotes($strOnEvents).",
		pc.relname as ".dquotes($strTable).",
		pp.proname as ".dquotes($strFunction).",
		ptr.tgfoid,
		ptr.tgenabled as ".dquotes($strEnabled).",
		ptr.tgisconstraint as ".dquotes($strIsConstraint).",
		ptr.tgconstrname as ".dquotes($strConstraintName).",
		ptr.tgconstrrelid,
		ptr.tgdeferrable as ".dquotes($strDeferrable).",
		ptr.tginitdeferred as ".dquotes($strInitDeferred).",
		ptr.tgnargs,
		ptr.tgattr,
		ptr.tgargs, 
		obj_description(ptr.oid) as ".dquotes($strDescription)." 
	FROM 
		(pg_trigger ptr LEFT JOIN pg_proc pp ON pp.oid = ptr.tgfoid) 
		LEFT JOIN pg_class pc ON ptr.tgrelid = pc.oid
	";

# filter for list of all non-RI triggers
If (webpage($PHP_SELF) == "triglistpage.php") {
		$sql_get .= "WHERE 
		pc.relname !~ 'pg_.*' 
		AND ptr.tgname !~ '^RI_Const' 
		";

# filter for non-ri triggers of table only
} elseif (webpage($PHP_SELF) == "tbl_triggerspage.php") {
		$sql_get .= "WHERE 
		pc.relname = '$table'
		AND ptr.tgname !~ '^RI_Const' 
		";

# filter for ALL ri triggers of table;
# tgtype = 21 is because there are two constraint triggers for every RI.  One trigger is tgtype=21 (after insert_update) and one is tgtype = 17 (after update)
} elseif ( (webpage($PHP_SELF) == "tbl_ripage.php") )   {
		$sql_get .= "WHERE 
		pc.relname !~ '^pg_'
		AND ptr.tgname ~ '^RI_Const'
		";
} elseif ( (webpage($PHP_SELF) == "rilistpage.php") )   {
		$sql_get .= "WHERE 
		pc.relname !~ '^pg_'
		AND ptr.tgname ~ '^RI_Const'
		";
} elseif ( substr(webpage($PHP_SELF),0,5) == "trig_" )   {
		$sql_get .= "WHERE ptr.tgname = '$trigger'
		";
}
	$sql_get .= "ORDER BY ptr.oid";


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modify

for ($i = 0; $i < $num_rows; $i++) {
	// Is constraint
	$sql_array[$i][8] = bool_YesNo($sql_array[$i][8]);

	// Deferr
	$sql_array[$i][11] = bool_YesNo($sql_array[$i][11]);

	// Init Deferr
	$sql_array[$i][12] = bool_YesNo($sql_array[$i][12]);

	// Enabled
	$sql_array[$i][7] = bool_YesNo($sql_array[$i][7]);

	// Contrsraint Name
	$sql_array[$i][9] = htmlspecialchars($sql_array[$i][9]);

	// trigger name - make link
	$sql_array[$i][1] = "<a class=link href=trig_properties.php?ntrigger=".$sql_array[$i][1]."&ntable=".$sql_array[$i][4].">".$sql_array[$i][1]."</a>";

	// Function name - make link
	$sql_array[$i][5] = "<a class=link href=func_properties.php?nfoid=".$sql_array[$i][6].">".$sql_array[$i][5]."()"."</a>";

	// table name - make link
	$sql_array[$i][4] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][4].">".$sql_array[$i][4]."</a>";

	// tgtype - (when) BEFORE or AFTER
	If ( ($sql_array[$i][2] == 9) OR ($sql_array[$i][2] == 5) OR ($sql_array[$i][2] == 21) OR ($sql_array[$i][2] == 13) OR ($sql_array[$i][2] == 29) OR ($sql_array[$i][2] == 17) OR ($sql_array[$i][2] == 25) ) {		
		$sql_array[$i][when] = "AFTER";
	} else {
#If ( ($sql_array[$i][2] == 7) OR ($sql_array[$i][2] == 11) OR ($sql_array[$i][2] == 15) OR ($sql_array[$i][2] == 19) OR ($sql_array[$i][2] == 23) OR ($sql_array[$i][2] == 27) OR ($sql_array[$i][2] == 31) ) {  
		$sql_array[$i][when] = "BEFORE";
	}

	// tgtype - (event) INSERT DELETE UPDATE

	If ( ($sql_array[$i][2] == 5) OR ($sql_array[$i][2] == 7) ) {
		$sql_array[$i][event] = "INSERT";
	} elseif ( ($sql_array[$i][2] == 9) OR ($sql_array[$i][2] == 11) ) {
		$sql_array[$i][event] = "DELETE";
	} elseif ( ($sql_array[$i][2] == 13) OR ($sql_array[$i][2] == 15) ) {
		$sql_array[$i][event] = "INSERT or DELETE";
	} elseif ( ($sql_array[$i][2] == 17) OR ($sql_array[$i][2] == 19) ) {
		$sql_array[$i][event] = "UPDATE";
	} elseif ( ($sql_array[$i][2] == 21) OR ($sql_array[$i][2] == 23) ) {
		$sql_array[$i][event] = "INSERT or UPDATE";
	} elseif ( ($sql_array[$i][2] == 25) OR ($sql_array[$i][2] == 27) ) {
		$sql_array[$i][event] = "UPDATE or DELETE";
	} elseif ( ($sql_array[$i][2] == 29) OR ($sql_array[$i][2] == 31) ) {
		$sql_array[$i][event] = "INSERT or UPDATE or DELETE";

	}

	$sql_array[$i][2] = $sql_array[$i][when];
	$sql_array[$i][3] = $sql_array[$i][event];	
	

}  // end For Loop


// Parse tgargs - Make RI trigger

If ((webpage($PHP_SELF) == "tbl_ripage.php")  OR (webpage($PHP_SELF) == "rilistpage.php") ) {
	include ($PATH_INCLUDE."ri_trig.inc.php");
}

?>
