/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.dsl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.groovy.ginq.dsl.GinqAstBaseVisitor;
import org.apache.groovy.ginq.dsl.GinqSyntaxError;
import org.apache.groovy.ginq.dsl.SyntaxErrorReportable;
import org.apache.groovy.ginq.dsl.expression.AbstractGinqExpression;
import org.apache.groovy.ginq.dsl.expression.DataSourceExpression;
import org.apache.groovy.ginq.dsl.expression.DataSourceHolder;
import org.apache.groovy.ginq.dsl.expression.FilterExpression;
import org.apache.groovy.ginq.dsl.expression.FromExpression;
import org.apache.groovy.ginq.dsl.expression.GinqExpression;
import org.apache.groovy.ginq.dsl.expression.GroupExpression;
import org.apache.groovy.ginq.dsl.expression.HavingExpression;
import org.apache.groovy.ginq.dsl.expression.JoinExpression;
import org.apache.groovy.ginq.dsl.expression.LimitExpression;
import org.apache.groovy.ginq.dsl.expression.OnExpression;
import org.apache.groovy.ginq.dsl.expression.OrderExpression;
import org.apache.groovy.ginq.dsl.expression.SelectExpression;
import org.apache.groovy.ginq.dsl.expression.ShutdownExpression;
import org.apache.groovy.ginq.dsl.expression.WhereExpression;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;

public class GinqAstBuilder
extends CodeVisitorSupport
implements SyntaxErrorReportable {
    public static final String ROOT_GINQ_EXPRESSION = "__ROOT_GINQ_EXPRESSION";
    public static final String GINQ_SELECT_DISTINCT = "__GINQ_SELECT_DISTINCT";
    private final Deque<GinqExpression> ginqExpressionStack = new ArrayDeque<GinqExpression>();
    private GinqExpression latestGinqExpression;
    private final SourceUnit sourceUnit;
    private final List<MethodCallExpression> ignoredMethodCallExpressionList = new ArrayList<MethodCallExpression>();
    private static final List<String> SHUTDOWN_OPTION_LIST = Arrays.asList("immediate", "abort");
    private boolean visitingOverClause;
    private static final String __LATEST_GINQ_EXPRESSION_CLAUSE = "__latestGinqExpressionClause";
    private static final String KW_WITH = "with";
    private static final String KW_FROM = "from";
    private static final String KW_IN = "in";
    private static final String KW_ON = "on";
    private static final String KW_WHERE = "where";
    private static final String KW_EXISTS = "exists";
    private static final String KW_GROUPBY = "groupby";
    private static final String KW_HAVING = "having";
    private static final String KW_ORDERBY = "orderby";
    private static final String KW_LIMIT = "limit";
    private static final String KW_OFFSET = "offset";
    private static final String KW_SELECT = "select";
    private static final String KW_DISTINCT = "distinct";
    private static final String KW_WITHINGROUP = "withingroup";
    private static final String KW_OVER = "over";
    private static final String KW_AS = "as";
    private static final String KW_SHUTDOWN = "shutdown";
    private static final Set<String> KEYWORD_SET = new HashSet<String>();

    public GinqAstBuilder(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public AbstractGinqExpression buildAST(ASTNode astNode) {
        Statement statement;
        List statementList;
        if (astNode instanceof BlockStatement && 1 == (statementList = ((BlockStatement)astNode).getStatements()).size() && (statement = (Statement)statementList.get(0)) instanceof ExpressionStatement) {
            Expression expression = ((ExpressionStatement)statement).getExpression();
            if (expression instanceof MethodCallExpression && KW_SHUTDOWN.equals(((MethodCallExpression)expression).getMethodAsString())) {
                Expression argExpression;
                List argExpressionList = ((ArgumentListExpression)((MethodCallExpression)expression).getArguments()).getExpressions();
                if (1 == argExpressionList.size() && (argExpression = (Expression)argExpressionList.get(0)) instanceof VariableExpression) {
                    int mode = SHUTDOWN_OPTION_LIST.indexOf(argExpression.getText());
                    if (-1 == mode) {
                        this.collectSyntaxError(new GinqSyntaxError("Invalid option: " + argExpression.getText() + ". (supported options: " + SHUTDOWN_OPTION_LIST + ")", argExpression.getLineNumber(), argExpression.getColumnNumber()));
                    }
                    return new ShutdownExpression(expression, mode);
                }
            } else if (expression instanceof VariableExpression && KW_SHUTDOWN.equals(expression.getText())) {
                return new ShutdownExpression(expression, SHUTDOWN_OPTION_LIST.indexOf("immediate"));
            }
        }
        astNode.visit((GroovyCodeVisitor)this);
        return this.getGinqExpression(astNode);
    }

    private GinqExpression getGinqExpression(ASTNode astNode) {
        if (null == this.latestGinqExpression) {
            ASTNode node = this.ginqExpressionStack.isEmpty() ? astNode : (ASTNode)this.ginqExpressionStack.peek();
            this.collectSyntaxError(new GinqSyntaxError("`select` clause is missing", node.getLineNumber(), node.getColumnNumber()));
        }
        this.latestGinqExpression.visit((GroovyCodeVisitor)new GinqAstBaseVisitor(){

            public void visitMethodCallExpression(MethodCallExpression call) {
                GinqAstBuilder.this.ignoredMethodCallExpressionList.remove(call);
                super.visitMethodCallExpression(call);
            }
        });
        if (!this.ignoredMethodCallExpressionList.isEmpty()) {
            MethodCallExpression methodCallExpression = this.ignoredMethodCallExpressionList.get(0);
            this.collectSyntaxError(new GinqSyntaxError("Unknown clause: " + methodCallExpression.getMethodAsString(), methodCallExpression.getLineNumber(), methodCallExpression.getColumnNumber()));
        }
        this.latestGinqExpression.putNodeMetaData(ROOT_GINQ_EXPRESSION, (Object)this.latestGinqExpression);
        return this.latestGinqExpression;
    }

    private void setLatestGinqExpressionClause(AbstractGinqExpression ginqExpressionClause) {
        GinqExpression ginqExpression = this.ginqExpressionStack.peek();
        ginqExpression.putNodeMetaData(__LATEST_GINQ_EXPRESSION_CLAUSE, (Object)ginqExpressionClause);
    }

    private AbstractGinqExpression getLatestGinqExpressionClause(MethodCallExpression call) {
        GinqExpression ginqExpression = this.ginqExpressionStack.peek();
        if (null == ginqExpression) {
            this.collectSyntaxError(new GinqSyntaxError("One `from` is expected and must be the first clause", call.getLineNumber(), call.getColumnNumber()));
        }
        return (AbstractGinqExpression)((Object)ginqExpression.getNodeMetaData(__LATEST_GINQ_EXPRESSION_CLAUSE));
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        ArgumentListExpression argumentListExpression;
        String methodName = call.getMethodAsString();
        if (KW_OVER.equals(methodName)) {
            this.visitingOverClause = true;
        }
        super.visitMethodCallExpression(call);
        if (KW_OVER.equals(methodName)) {
            this.visitingOverClause = false;
        }
        if (!KEYWORD_SET.contains(methodName)) {
            this.ignoredMethodCallExpressionList.add(call);
            return;
        }
        if (KW_FROM.equals(methodName)) {
            GinqExpression ginqExpression = new GinqExpression();
            ginqExpression.setSourcePosition((ASTNode)call);
            this.ginqExpressionStack.push(ginqExpression);
        }
        GinqExpression currentGinqExpression = this.ginqExpressionStack.peek();
        AbstractGinqExpression latestGinqExpressionClause = this.getLatestGinqExpressionClause(call);
        if (KW_FROM.equals(methodName) || JoinExpression.isJoinExpression(methodName)) {
            DataSourceExpression dataSourceExpression;
            Expression expression;
            ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
            if (arguments.getExpressions().size() != 1) {
                this.collectSyntaxError(new GinqSyntaxError("Only 1 argument expected for `" + methodName + "`, e.g. `" + methodName + " n in nums`", call.getLineNumber(), call.getColumnNumber()));
            }
            if (!((expression = arguments.getExpression(0)) instanceof BinaryExpression) || ((BinaryExpression)expression).getOperation().getType() != 573) {
                this.collectSyntaxError(new GinqSyntaxError("`in` is expected for `" + methodName + "`, e.g. `" + methodName + " n in nums`", call.getLineNumber(), call.getColumnNumber()));
            }
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression aliasExpr = binaryExpression.getLeftExpression();
            Expression dataSourceExpr = binaryExpression.getRightExpression();
            if (KW_FROM.equals(methodName)) {
                dataSourceExpression = new FromExpression(aliasExpr, dataSourceExpr);
                currentGinqExpression.setFromExpression((FromExpression)dataSourceExpression);
            } else {
                dataSourceExpression = new JoinExpression(methodName, aliasExpr, dataSourceExpr);
                currentGinqExpression.addJoinExpression((JoinExpression)dataSourceExpression);
            }
            dataSourceExpression.setSourcePosition((ASTNode)call.getMethod());
            this.setLatestGinqExpressionClause(dataSourceExpression);
            return;
        }
        if (KW_WHERE.equals(methodName) || KW_ON.equals(methodName) || KW_HAVING.equals(methodName)) {
            Expression filterExpr = ((ArgumentListExpression)call.getArguments()).getExpression(0);
            FilterExpression filterExpression = KW_WHERE.equals(methodName) ? new WhereExpression(filterExpr) : (KW_ON.equals(methodName) ? new OnExpression(filterExpr) : new HavingExpression(filterExpr));
            filterExpression.setSourcePosition((ASTNode)call.getMethod());
            if (latestGinqExpressionClause instanceof JoinExpression && filterExpression instanceof OnExpression) {
                ((JoinExpression)latestGinqExpressionClause).setOnExpression((OnExpression)filterExpression);
            } else if (latestGinqExpressionClause instanceof DataSourceHolder && filterExpression instanceof WhereExpression) {
                if (null != currentGinqExpression.getGroupExpression() || null != currentGinqExpression.getOrderExpression() || null != currentGinqExpression.getLimitExpression()) {
                    this.collectSyntaxError(new GinqSyntaxError("The preceding clause of `" + methodName + "` should be `from`/join clause", call.getLineNumber(), call.getColumnNumber()));
                }
                currentGinqExpression.setWhereExpression((WhereExpression)filterExpression);
            } else if (latestGinqExpressionClause instanceof GroupExpression && filterExpression instanceof HavingExpression) {
                ((GroupExpression)latestGinqExpressionClause).setHavingExpression((HavingExpression)filterExpression);
            } else {
                this.collectSyntaxError(new GinqSyntaxError("The preceding clause of `" + methodName + "` should be " + (KW_ON.equals(methodName) ? "" : "`from`/") + "join clause", call.getLineNumber(), call.getColumnNumber()));
            }
            if (latestGinqExpressionClause instanceof DataSourceHolder) {
                if (latestGinqExpressionClause instanceof DataSourceExpression) {
                    filterExpression.setDataSourceExpression((DataSourceExpression)latestGinqExpressionClause);
                } else {
                    filterExpression.setDataSourceExpression(((DataSourceHolder)((Object)latestGinqExpressionClause)).getDataSourceExpression());
                }
            }
            this.setLatestGinqExpressionClause(filterExpression);
            return;
        }
        if (KW_EXISTS.equals(methodName) && null != this.latestGinqExpression && (argumentListExpression = (ArgumentListExpression)call.getArguments()).getExpressions().isEmpty() && GinqAstBuilder.isSelectMethodCallExpression(call.getObjectExpression())) {
            call.setObjectExpression((Expression)this.latestGinqExpression);
            this.latestGinqExpression = null;
        }
        if (KW_GROUPBY.equals(methodName)) {
            GroupExpression groupExpression = new GroupExpression(call.getArguments());
            groupExpression.setSourcePosition((ASTNode)call.getMethod());
            currentGinqExpression.setGroupExpression(groupExpression);
            if (latestGinqExpressionClause instanceof OrderExpression) {
                this.collectSyntaxError(new GinqSyntaxError("The clause `" + methodName + "` should be in front of `orderby`", call.getLineNumber(), call.getColumnNumber()));
            } else if (latestGinqExpressionClause instanceof LimitExpression) {
                this.collectSyntaxError(new GinqSyntaxError("The clause `" + methodName + "` should be in front of `limit`", call.getLineNumber(), call.getColumnNumber()));
            }
            if (latestGinqExpressionClause instanceof DataSourceHolder) {
                groupExpression.setDataSourceExpression(((DataSourceHolder)((Object)latestGinqExpressionClause)).getDataSourceExpression());
            }
            this.setLatestGinqExpressionClause(groupExpression);
            return;
        }
        if (KW_ORDERBY.equals(methodName) && !this.visitingOverClause) {
            OrderExpression orderExpression = new OrderExpression(call.getArguments());
            orderExpression.setSourcePosition((ASTNode)call.getMethod());
            currentGinqExpression.setOrderExpression(orderExpression);
            if (latestGinqExpressionClause instanceof LimitExpression) {
                this.collectSyntaxError(new GinqSyntaxError("The clause `" + methodName + "` should be in front of `limit`", call.getLineNumber(), call.getColumnNumber()));
            }
            if (latestGinqExpressionClause instanceof DataSourceHolder) {
                orderExpression.setDataSourceExpression(((DataSourceHolder)((Object)latestGinqExpressionClause)).getDataSourceExpression());
            }
            this.setLatestGinqExpressionClause(orderExpression);
            return;
        }
        if (KW_LIMIT.equals(methodName)) {
            LimitExpression limitExpression = new LimitExpression(call.getArguments());
            limitExpression.setSourcePosition((ASTNode)call.getMethod());
            currentGinqExpression.setLimitExpression(limitExpression);
            if (latestGinqExpressionClause instanceof DataSourceHolder) {
                limitExpression.setDataSourceExpression(((DataSourceHolder)((Object)latestGinqExpressionClause)).getDataSourceExpression());
            }
            this.setLatestGinqExpressionClause(limitExpression);
            return;
        }
        if (KW_SELECT.equals(methodName)) {
            TupleExpression tupleExpression = (TupleExpression)call.getArguments();
            if (1 == tupleExpression.getExpressions().size()) {
                MethodCallExpression mce;
                Expression firstExpression = (Expression)tupleExpression.getExpressions().get(0);
                if (firstExpression instanceof MethodCallExpression && KW_DISTINCT.equals((mce = (MethodCallExpression)firstExpression).getMethodAsString())) {
                    tupleExpression = (TupleExpression)mce.getArguments();
                    currentGinqExpression.putNodeMetaData(GINQ_SELECT_DISTINCT, true);
                }
            } else {
                for (Expression expression : tupleExpression.getExpressions()) {
                    MethodCallExpression mce;
                    if (!(expression instanceof MethodCallExpression) || !KW_DISTINCT.equals((mce = (MethodCallExpression)expression).getMethodAsString())) continue;
                    this.collectSyntaxError(new GinqSyntaxError("Invalid usage of `distinct`", mce.getLineNumber(), mce.getColumnNumber()));
                }
            }
            SelectExpression selectExpression = new SelectExpression((Expression)tupleExpression);
            selectExpression.setSourcePosition((ASTNode)call.getMethod());
            currentGinqExpression.setSelectExpression(selectExpression);
            if (latestGinqExpressionClause instanceof DataSourceHolder) {
                selectExpression.setDataSourceExpression(((DataSourceHolder)((Object)latestGinqExpressionClause)).getDataSourceExpression());
            }
            this.setLatestGinqExpressionClause(selectExpression);
            this.latestGinqExpression = this.ginqExpressionStack.pop();
            this.latestGinqExpression.setSourcePosition((ASTNode)call);
            return;
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        super.visitBinaryExpression(expression);
        int opType = expression.getOperation().getType();
        if ((opType == 573 || opType == 129) && null != this.latestGinqExpression && GinqAstBuilder.isSelectMethodCallExpression(expression.getRightExpression())) {
            expression.setRightExpression((Expression)this.latestGinqExpression);
            this.latestGinqExpression = null;
        }
    }

    public void visitVariableExpression(VariableExpression expression) {
        if (KEYWORD_SET.contains(expression.getText())) {
            this.collectSyntaxError(new GinqSyntaxError("Invalid syntax found in `" + expression.getText() + "` clause", expression.getLineNumber(), expression.getColumnNumber()));
        }
        super.visitVariableExpression(expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        super.visitPropertyExpression(expression);
        if (GinqAstBuilder.isSelectMethodCallExpression(expression.getObjectExpression())) {
            this.collectSyntaxError(new GinqSyntaxError("Invalid syntax found in `select` clause, maybe `as` is missing when renaming field.", expression.getLineNumber(), expression.getColumnNumber()));
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        String typeName = expression.getLeftExpression().getType().getNameWithoutPackage();
        if (KEYWORD_SET.contains(typeName)) {
            this.collectSyntaxError(new GinqSyntaxError("`" + typeName + "` clause cannot contain assignment expression", expression.getLineNumber(), expression.getColumnNumber()));
        }
        super.visitDeclarationExpression(expression);
    }

    public void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
        if (null != this.latestGinqExpression && GinqAstBuilder.isSelectMethodCallExpression(expression.getExpression())) {
            expression.setExpression((Expression)this.latestGinqExpression);
            this.latestGinqExpression = null;
        }
    }

    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        List list = expression.getExpressions();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Expression expr = (Expression)list.get(i);
                expr.visit((GroovyCodeVisitor)this);
                if (null == this.latestGinqExpression || !GinqAstBuilder.isSelectMethodCallExpression(expr)) continue;
                list.set(i, this.latestGinqExpression);
                this.latestGinqExpression = null;
            }
        }
    }

    private static boolean isSelectMethodCallExpression(Expression expression) {
        return expression instanceof MethodCallExpression && KW_SELECT.equals(((MethodCallExpression)expression).getMethodAsString());
    }

    @Override
    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    static {
        KEYWORD_SET.addAll(Arrays.asList(KW_WITH, KW_FROM, KW_IN, KW_ON, KW_WHERE, KW_EXISTS, KW_GROUPBY, KW_HAVING, KW_ORDERBY, KW_LIMIT, KW_OFFSET, KW_SELECT, KW_DISTINCT, KW_WITHINGROUP, KW_OVER, KW_AS, KW_SHUTDOWN));
        KEYWORD_SET.addAll(JoinExpression.JOIN_NAME_LIST);
    }
}

