/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -7 -C -k 1,3-11,$ src/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 291
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 2380
/* maximum key range = 2377, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381,    0,   40, 2381,  130,  150,
        50,  510,  220,   20,   30,  493,    0,  115,  130, 2381,
      2381, 2381, 2381, 2381, 2381,  384,  480,  323,  470,    0,
        20,   45,   25,    0,    0,   70,  320,   30,   15,    0,
       105, 2381,   60,    0,    0,  275,   30,    0,   15,   30,
         0, 2381, 2381, 2381, 2381,  500, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
      2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
        hval += asso_values[(unsigned char) str[7]];
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  static const struct alias wordlist[] =
    {
      {""}, {""}, {""}, {""},
      {"SJIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"HZ", ei_hz},
      {""},
      {"SHIFT-JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""},
      {"MS-EE", ei_cp1250},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"R8", ei_hp_roman8},
      {"866", ei_cp866},
      {"TCVN", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-58", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"JP", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"GREEK8", ei_iso8859_7},
      {""}, {""}, {""}, {""},
      {"IBM866", ei_cp866},
      {""},
      {"ISO-IR-6", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-8859-5", ei_iso8859_5},
      {""}, {""},
      {"GBK", ei_ces_gbk},
      {""},
      {"GREEK", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""},
      {"KOI8-R", ei_koi8_r},
      {""}, {""}, {""},
      {"X0208", ei_jisx0208},
      {""}, {""}, {""}, {""},
      {"ISO-8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-226", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-2", ei_iso8859_2},
      {""}, {""},
      {"NEXTSTEP", ei_nextstep},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"850", ei_cp850},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"US", ei_ascii},
      {""}, {""}, {""}, {""}, {""},
      {"MS-GREEK", ei_cp1253},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-165", ei_isoir165},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-8", ei_utf8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-166", ei_tis620},
      {""}, {""}, {""}, {""}, {""},
      {"IBM850", ei_cp850},
      {"JIS0208", ei_jisx0208},
      {""}, {""},
      {"X0212", ei_jisx0212},
      {""},
      {"L8", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""},
      {"EUCTW", ei_euc_tw},
      {"EUC-TW", ei_euc_tw},
      {"ISO-IR-126", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-15", ei_iso8859_15},
      {""}, {""}, {""},
      {"CN", ei_iso646_cn},
      {"LATIN8", ei_iso8859_14},
      {"L5", ei_iso8859_9},
      {""}, {""},
      {"CHINESE", ei_gb2312},
      {"TIS620", ei_tis620},
      {"TIS-620", ei_tis620},
      {""}, {""}, {""}, {""},
      {"L6", ei_iso8859_10},
      {""}, {""}, {""},
      {"ISO-8859-16", ei_iso8859_16},
      {""}, {""},
      {"VISCII", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"L2", ei_iso8859_2},
      {""}, {""},
      {"ISO-8859-9", ei_iso8859_9},
      {""}, {""},
      {"CSSHIFTJIS", ei_sjis},
      {""},
      {"UCS-2", ei_ucs2},
      {"LATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"LATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"IBM819", ei_iso8859_1},
      {""},
      {"CP866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACINTOSH", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-ANSI", ei_cp1252},
      {""}, {""}, {""},
      {"ISO-IR-148", ei_iso8859_9},
      {"LATIN2", ei_iso8859_2},
      {""}, {""}, {""},
      {"ISO-8859-1", ei_iso8859_1},
      {""}, {""},
      {"ISO-2022-JP-2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-IR-159", ei_jisx0212},
      {""},
      {"L1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""},
      {"TIS620-0", ei_tis620},
      {""}, {""},
      {"ISO-2022-KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ROMAN8", ei_hp_roman8},
      {""}, {""}, {""},
      {"ISO646-JP", ei_iso646_jp},
      {"X0201", ei_jisx0201},
      {"ISO-2022-JP", ei_iso2022_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-16", ei_utf16},
      {"MS-TURK", ei_cp1254},
      {""}, {""}, {""}, {""}, {""},
      {"EUCKR", ei_euc_kr},
      {"EUC-KR", ei_euc_kr},
      {"CSKOI8R", ei_koi8_r},
      {""}, {""},
      {"HP-ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""},
      {"SHIFT_JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"EUCJP", ei_euc_jp},
      {"EUC-JP", ei_euc_jp},
      {""}, {""},
      {"L4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-JP-1", ei_iso2022_jp1},
      {"CP1258", ei_cp1258},
      {"KOREAN", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-10", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO646-US", ei_ascii},
      {"ISO-IR-199", ei_iso8859_14},
      {""}, {""}, {""},
      {"BIG5", ei_ces_big5},
      {"BIG-5", ei_ces_big5},
      {"HEBREW", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-109", ei_iso8859_3},
      {""},
      {"BIGFIVE", ei_ces_big5},
      {"BIG-FIVE", ei_ces_big5},
      {""},
      {"ISO-8859-4", ei_iso8859_4},
      {""}, {""}, {""},
      {"CP1255", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACGREEK", ei_mac_greek},
      {""},
      {"CP850", ei_cp850},
      {"CP1256", ei_cp1256},
      {"ISO-IR-100", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"KOI8-U", ei_koi8_u},
      {""}, {""}, {""},
      {"ISO-IR-110", ei_iso8859_4},
      {""}, {""},
      {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN1", ei_iso8859_1},
      {"ISO646-CN", ei_iso646_cn},
      {""},
      {"ISO-2022-CN", ei_iso2022_cn},
      {"ISO_8859-8", ei_iso8859_8},
      {""}, {""},
      {"TIS620.2529-1", ei_tis620},
      {"CP1252", ei_cp1252},
      {"ISO-IR-101", ei_iso8859_2},
      {""}, {""},
      {"UCS-2-LE", ei_ucs2le},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-14", ei_iso646_jp},
      {""}, {""},
      {"MS-HEBR", ei_cp1255},
      {""}, {""},
      {"GEORGIAN-PS", ei_georgian_ps},
      {""}, {""}, {""}, {""},
      {"ISO-IR-149", ei_ksc5601},
      {""}, {""},
      {"ELOT_928", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""},
      {"MAC", ei_mac_roman},
      {""},
      {"EUCCN", ei_euc_cn},
      {"EUC-CN", ei_euc_cn},
      {""},
      {"CSVISCII", ei_viscii},
      {"ISO_8859-5", ei_iso8859_5},
      {""},
      {"KOI8-RU", ei_koi8_ru},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-6", ei_iso8859_6},
      {""}, {""},
      {"CP819", ei_iso8859_1},
      {""}, {""}, {""},
      {"ASCII", ei_ascii},
      {""}, {""}, {""}, {""},
      {"WINDOWS-1258", ei_cp1258},
      {""}, {""},
      {"UCS-4", ei_ucs4},
      {""},
      {"ECMA-118", ei_iso8859_7},
      {"CP950", ei_cp950},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-138", ei_iso8859_8},
      {""}, {""}, {""},
      {"UCS-2-INTERNAL", ei_ucs2internal},
      {""},
      {"ISO-8859-14", ei_iso8859_14},
      {"WINDOWS-1255", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-2", ei_iso8859_2},
      {"ARMSCII-8", ei_armscii_8},
      {"WINDOWS-1256", ei_cp1256},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISO159JISX02121990", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1252", ei_cp1252},
      {""},
      {"MACTHAI", ei_mac_thai},
      {"CSISO2022JP2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8:1988", ei_iso8859_8},
      {"LATIN4", ei_iso8859_4},
      {""},
      {"JISX0201-1976", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-5:1988", ei_iso8859_5},
      {""},
      {"JAVA", ei_java},
      {""},
      {"CSISO2022KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""},
      {"CP1250", ei_cp1250},
      {""}, {""}, {""},
      {"UCS-2-BE", ei_ucs2be},
      {""},
      {"L7", ei_iso8859_13},
      {""},
      {"TCVN-5712", ei_tcvn},
      {"MACTURKISH", ei_mac_turkish},
      {""}, {""},
      {"ISO_8859-15:1998", ei_iso8859_15},
      {""},
      {"UCS-4-LE", ei_ucs4le},
      {"CSISO2022JP", ei_iso2022_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"L3", ei_iso8859_3},
      {""},
      {"JIS_X0208", ei_jisx0208},
      {""},
      {"ISO_8859-15", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO87JISX0208", ei_jisx0208},
      {"WINDOWS-1250", ei_cp1250},
      {""},
      {"CP1251", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-16", ei_iso8859_16},
      {""}, {""}, {""}, {""},
      {"GB2312", ei_euc_cn},
      {""}, {""}, {""},
      {"MACROMAN", ei_mac_roman},
      {""},
      {"WINDOWS-1251", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-9", ei_iso8859_9},
      {""}, {""}, {""}, {""},
      {"ISO-IR-144", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CP949", ei_cp949},
      {"CSBIG5", ei_ces_big5},
      {"CN-BIG5", ei_ces_big5},
      {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-2", ei_ucs2},
      {""}, {""}, {""},
      {"UCS-4-INTERNAL", ei_ucs4internal},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UHC", ei_cp949},
      {""}, {""},
      {"MACHEBREW", ei_mac_hebrew},
      {"CSEUCTW", ei_euc_tw},
      {""}, {""},
      {"CSIBM866", ei_cp866},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1254", ei_cp1254},
      {""}, {""}, {""}, {""},
      {"CN-GB-ISOIR165", ei_isoir165},
      {"ISO-IR-179", ei_iso8859_13},
      {""},
      {"ISO_8859-1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSHPROMAN8", ei_hp_roman8},
      {""},
      {"JIS_X0212", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-16:2000", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""},
      {"CSISO2022CN", ei_iso2022_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO_8859-10:1992", ei_iso8859_10},
      {""},
      {"UCS-4-BE", ei_ucs4be},
      {""}, {""}, {""}, {""}, {""},
      {"CP1254", ei_cp1254},
      {"US-ASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-4:1988", ei_iso8859_4},
      {""}, {""}, {""},
      {"VISCII1.1-1", ei_viscii},
      {""}, {""},
      {"MS_KANJI", ei_sjis},
      {""}, {""},
      {"ISO_8859-9:1989", ei_iso8859_9},
      {""}, {""},
      {"CP936", ei_ces_gbk},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-14:1998", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSISO14JISC6220RO", ei_iso646_jp},
      {""}, {""}, {""},
      {"CSASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ASMO-708", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP932", ei_cp932},
      {""},
      {"ISO-IR-87", ei_jisx0208},
      {"ISO_8859-10", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"TCVN5712-1", ei_tcvn},
      {""},
      {"ISO-10646-UCS-4", ei_ucs4},
      {""}, {""}, {""}, {""},
      {"ISO-IR-57", ei_iso646_cn},
      {"ISO_646.IRV:1991", ei_ascii},
      {""}, {""}, {""},
      {"GB_1988-80", ei_iso646_cn},
      {""}, {""},
      {"CSISOLATINHEBREW", ei_iso8859_8},
      {""},
      {"ISO_8859-4", ei_iso8859_4},
      {""}, {""}, {""}, {""},
      {"MS-CYRL", ei_cp1251},
      {""}, {""},
      {"CSISOLATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISOLATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""},
      {"CSEUCKR", ei_euc_kr},
      {"JIS_X0208-1990", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO-8859-7", ei_iso8859_7},
      {""}, {""},
      {"JIS_X0201", ei_jisx0201},
      {""},
      {"CSMACINTOSH", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ECMA-114", ei_iso8859_6},
      {""}, {""},
      {"ISO-8859-3", ei_iso8859_3},
      {""},
      {"MACUKRAINE", ei_mac_ukraine},
      {""}, {""}, {""}, {""},
      {"CSISOLATINGREEK", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"JIS_X0212-1990", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"WINDOWS-1257", ei_cp1257},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-157", ei_iso8859_10},
      {"WINDOWS-1253", ei_cp1253},
      {""}, {""}, {""},
      {"JIS_X0212.1990-0", ei_jisx0212},
      {""}, {""}, {""}, {""},
      {"ISO_8859-14", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"JIS_C6220-1969-RO", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-127", ei_iso8859_6},
      {""}, {""}, {""}, {""},
      {"CP874", ei_cp874},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-203", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-7", ei_utf7},
      {""}, {""}, {""},
      {"ISO_8859-3:1988", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"GEORGIAN-ACADEMY", ei_georgian_academy},
      {"ISO_8859-6:1987", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-8859-13", ei_iso8859_13},
      {""}, {""},
      {"CP1361", ei_johab},
      {""}, {""}, {""},
      {"ISO_8859-2:1987", ei_iso8859_2},
      {""}, {""}, {""},
      {"LATIN7", ei_iso8859_13},
      {""},
      {"WINBALTRIM", ei_cp1257},
      {""}, {""}, {""},
      {"CN-GB", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISOLATIN1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN3", ei_iso8859_3},
      {""},
      {"MULELAO-1", ei_mulelao},
      {""}, {""}, {""},
      {"CSUCS4", ei_ucs4},
      {""}, {""},
      {"HZ-GB-2312", ei_hz},
      {""}, {""}, {""},
      {"JOHAB", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"KSC_5601", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UNICODELITTLE", ei_ucs2le},
      {"UCS-2-SWAPPED", ei_ucs2swapped},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSUNICODE", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-1:1987", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-874", ei_cp874},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"MACCENTRALEUROPE", ei_mac_centraleurope},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"TIS620.2533-0", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_X0208-1983", ei_jisx0208},
      {""}, {""}, {""},
      {"TIS620.2533-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""},
      {"CP1257", ei_cp1257},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACCROATIAN", ei_mac_croatian},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM367", ei_ascii},
      {"TCVN5712-1:1993", ei_tcvn},
      {""}, {""}, {""}, {""}, {""},
      {"CP1253", ei_cp1253},
      {""}, {""},
      {"UCS-4-SWAPPED", ei_ucs4swapped},
      {"CSISO58GB231280", ei_gb2312},
      {""},
      {"GB_2312-80", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACROMANIA", ei_mac_romania},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"ISO_8859-7", ei_iso8859_7},
      {""}, {""}, {""},
      {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
      {""}, {""}, {""},
      {"CSISO57GB1988", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODEBIG", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3", ei_iso8859_3},
      {"CSGB2312", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISOLATINCYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSISOLATINARABIC", ei_iso8859_6},
      {"ISO_8859-7:1987", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-13", ei_iso8859_13},
      {"CSKSC56011987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-ARAB", ei_cp1256},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ANSI_X3.4-1968", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CP367", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSPC850MULTILINGUAL", ei_cp850},
      {""},
      {"CSUNICODE11", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UNICODE-1-1-UTF-7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSHALFWIDTHKATAKANA", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"KS_C_5601-1989", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACCYRILLIC", ei_mac_cyrillic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSUNICODE11UTF7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"IBM-CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACARABIC", ei_mac_arabic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MACICELAND", ei_mac_iceland},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KS_C_5601-1987", ei_ksc5601}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
