static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * This operation is a port of the Darktable Shadows Highlights filter        \n"
" * copyright (c) 2012--2015 Ulrich Pegelow.                                   \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (shadows, _(\"Shadows\"), 50.0)                               \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (highlights, _(\"Highlights\"), -50.0)                        \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (whitepoint, _(\"White point adjustment\"), 0.0)              \n"
"    value_range (-10.0, 10.0)                                                 \n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 100.0)                                \n"
"    value_range (0.1, G_MAXDOUBLE)                                            \n"
"    ui_range    (0.1, 200.0)                                                  \n"
"                                                                              \n"
"property_double (compress, _(\"Compress\"), 50.0)                             \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (shadows_ccorrect, _(\"Shadows color adjustment\"), 100.0)    \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (highlights_ccorrect, _(\"Highlights color adjustment\"), 50.0)\n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     shadows_highlights                                   \n"
"#define GEGL_OP_C_SOURCE shadows-highlights.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl;                                                             \n"
"  GeglNode *input;                                                            \n"
"  GeglNode *output;                                                           \n"
"  GeglNode *blur;                                                             \n"
"  GeglNode *shprocess;                                                        \n"
"                                                                              \n"
"  gegl   = operation->node;                                                   \n"
"  input  = gegl_node_get_input_proxy (gegl, \"input\");                       \n"
"  output = gegl_node_get_output_proxy (gegl, \"output\");                     \n"
"                                                                              \n"
"  blur = gegl_node_new_child (gegl,                                           \n"
"                              \"operation\",    \"gegl:gaussian-blur\",       \n"
"                              \"abyss-policy\", 1,                            \n"
"                               NULL);                                         \n"
"                                                                              \n"
"                                                                              \n"
"  shprocess = gegl_node_new_child (gegl,                                      \n"
"                                   \"operation\", \"gegl:shadows-highlights-correction\",\n"
"                                   NULL);                                     \n"
"                                                                              \n"
"  gegl_node_link (input, blur);                                               \n"
"  gegl_node_link_many (input, shprocess, output, NULL);                       \n"
"                                                                              \n"
"  gegl_node_connect_to (blur, \"output\", shprocess, \"aux\");                \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"radius\", blur, \"std-dev-x\");  \n"
"  gegl_operation_meta_redirect (operation, \"radius\", blur, \"std-dev-y\");  \n"
"  gegl_operation_meta_redirect (operation, \"shadows\", shprocess, \"shadows\");\n"
"  gegl_operation_meta_redirect (operation, \"highlights\", shprocess, \"highlights\");\n"
"  gegl_operation_meta_redirect (operation, \"whitepoint\", shprocess, \"whitepoint\");\n"
"  gegl_operation_meta_redirect (operation, \"compress\", shprocess, \"compress\");\n"
"  gegl_operation_meta_redirect (operation, \"shadows-ccorrect\", shprocess, \"shadows-ccorrect\");\n"
"  gegl_operation_meta_redirect (operation, \"highlights-ccorrect\", shprocess, \"highlights-ccorrect\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, blur, shprocess, NULL);         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:shadows-highlights\",                             \n"
"    \"title\",       _(\"Shadows-Highlights\"),                               \n"
"    \"categories\",  \"light\",                                               \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Perform shadows and highlights correction\"),        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
