static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color (value, _(\"Color\"), \"black\")                               \n"
"    description ((\"The color to render (Idefaults to 'black')\"))            \n"
"    ui_meta     (\"role\", \"color-primary\")                                 \n"
"                                                                              \n"
"property_format (format, _(\"Babl Format\"), 666)                             \n"
"    description (_(\"The babl format of the output\"))                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_C_SOURCE color.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_color_op_prepare (GeglOperation *operation)                              \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->format)                                                              \n"
"    gegl_operation_set_format (operation, \"output\", o->format);             \n"
"  else                                                                        \n"
"    gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_color_op_get_bounding_box (GeglOperation *operation)                     \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_color_op_process (GeglOperation       *operation,                        \n"
"                       void                *out_buf,                          \n"
"                       glong                n_pixels,                         \n"
"                       const GeglRectangle *roi,                              \n"
"                       gint                 level)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint        pixel_size = babl_format_get_bytes_per_pixel (out_format);      \n"
"  void       *out_color  = alloca(pixel_size);                                \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->value, out_format, out_color);                     \n"
"                                                                              \n"
"  gegl_memset_pattern (out_buf, out_color, pixel_size, n_pixels);             \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process       = gegl_color_op_process;                  \n"
"  operation_class->get_bounding_box = gegl_color_op_get_bounding_box;         \n"
"  operation_class->prepare          = gegl_color_op_prepare;                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color\",                                          \n"
"    \"title\",      _(\"Color\"),                                             \n"
"    \"categories\" , \"render\",                                              \n"
"    \"description\",                                                          \n"
"      _(\"Generates a buffer entirely filled with the specified color, \"     \n"
"        \"use gegl:crop to get smaller dimensions.\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
