static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2004, 2006 Øyvind Kolås <pippin@gimp.org>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#define THRESHOLD_SCRIPT \\                                                   \n"
"\"r,g,b = get_rgb (x,y)\\n\"\\                                                \n"
"\"set_rgb (x,y,g,g,g)\\n\"\\                                                  \n"
"                                                                              \n"
"property_string (script, _(\"Script\"), THRESHOLD_SCRIPT)                     \n"
"    description(_(\"The lua script containing the implementation of this operation.\"))\n"
"    ui_meta    (\"multiline\", \"true\")                                      \n"
"                                                                              \n"
"property_string (error, _(\"Lua error\"), \"\")                               \n"
"    description(_(\"parse/compile error, if any\"))                           \n"
"    ui_meta    (\"error\", \"true\")                                          \n"
"                                                                              \n"
"property_file_path (file, _(\"File\"), \"\")                                  \n"
"    description(_(\"a stored lua script on disk implementing an operation.\"))\n"
"                                                                              \n"
"property_double (user_value, _(\"User value\"), 1.0)                          \n"
"    description(_(\"(appears in the global variable 'user_value' in lua.\"))  \n"
"    value_range (-1000.0, 1000.0)                                             \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     gluas                                                \n"
"#define GEGL_OP_C_SOURCE gluas.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <lua.h>                                                              \n"
"#include <lualib.h>                                                           \n"
"#include <lauxlib.h>                                                          \n"
"                                                                              \n"
"typedef struct Priv                                                           \n"
"{                                                                             \n"
"  gint        bpp;                                                            \n"
"  GeglBuffer *in_drawable;                                                    \n"
"  GeglBuffer *aux_drawable;                                                   \n"
"  GeglBuffer *out_drawable;                                                   \n"
"  const Babl *rgba_float;                                                     \n"
"                                                                              \n"
"  gint        bx1, by1;                                                       \n"
"  gint        bx2, by2;    /* mask bounds */                                  \n"
"                                                                              \n"
"  gint        width;                                                          \n"
"  gint        height;                                                         \n"
"                                                                              \n"
"  lua_State  *L;                                                              \n"
"}                                                                             \n"
"Priv;                                                                         \n"
"                                                                              \n"
"#define TILE_CACHE_SIZE   16                                                  \n"
"#define SCALE_WIDTH      125                                                  \n"
"#define ENTRY_WIDTH       50                                                  \n"
"                                                                              \n"
"static int l_set_rgba  (lua_State * lua);                                     \n"
"static int l_get_rgba  (lua_State * lua);                                     \n"
"static int l_set_rgb   (lua_State * lua);                                     \n"
"static int l_get_rgb   (lua_State * lua);                                     \n"
"static int l_set_hsl   (lua_State * lua);                                     \n"
"static int l_get_hsl   (lua_State * lua);                                     \n"
"static int l_set_hsv   (lua_State * lua);                                     \n"
"static int l_get_hsv   (lua_State * lua);                                     \n"
"static int l_set_value (lua_State * lua);                                     \n"
"static int l_get_value (lua_State * lua);                                     \n"
"static int l_set_alpha (lua_State * lua);                                     \n"
"static int l_get_alpha (lua_State * lua);                                     \n"
"static int l_set_lab   (lua_State * lua);                                     \n"
"static int l_get_lab   (lua_State * lua);                                     \n"
"static int l_in_width  (lua_State * lua);                                     \n"
"static int l_in_height (lua_State * lua);                                     \n"
"                                                                              \n"
"static int l_progress  (lua_State * lua);                                     \n"
"static int l_flush     (lua_State * lua);                                     \n"
"static int l_print     (lua_State * lua);                                     \n"
"                                                                              \n"
"static const luaL_Reg gluas_functions[] =                                     \n"
"{                                                                             \n"
"    {\"set_rgba\",    l_set_rgba},                                            \n"
"    {\"get_rgba\",    l_get_rgba},                                            \n"
"    {\"set_rgb\",     l_set_rgb},                                             \n"
"    {\"get_rgb\",     l_get_rgb},                                             \n"
"    {\"set_hsl\",     l_set_hsl},                                             \n"
"    {\"get_hsl\",     l_get_hsl},                                             \n"
"    {\"set_hsv\",     l_set_hsv},                                             \n"
"    {\"get_hsv\",     l_get_hsv},                                             \n"
"    {\"set_lab\",     l_set_lab},                                             \n"
"    {\"get_lab\",     l_get_lab},                                             \n"
"    {\"set_value\",   l_set_value},                                           \n"
"    {\"get_value\",   l_get_value},                                           \n"
"    {\"set_alpha\",   l_set_alpha},                                           \n"
"    {\"get_alpha\",   l_get_alpha},                                           \n"
"    {\"in_width\",    l_in_width},                                            \n"
"    {\"in_height\",   l_in_height},                                           \n"
"    {\"progress\",    l_progress},                                            \n"
"    {\"flush\",       l_flush},                                               \n"
"    {\"print\",       l_print},                                               \n"
"    {NULL,          NULL}                                                     \n"
"};                                                                            \n"
"static void                                                                   \n"
"register_functions (lua_State      *L,                                        \n"
"                    const luaL_Reg *l)                                        \n"
"{                                                                             \n"
"  for (;l->name; l++)                                                         \n"
"    lua_register (L, l->name, l->func);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"drawable_lua_process (GeglOperation       *op,                                \n"
"                      GeglBuffer          *drawable,                          \n"
"                      GeglBuffer          *aux,                               \n"
"                      GeglBuffer          *result,                            \n"
"                      const GeglRectangle *roi,                               \n"
"                      const gchar         *file,                              \n"
"                      const gchar         *buffer,                            \n"
"                      gdouble              user_value)                        \n"
"{                                                                             \n"
"    /*GimpRGB    background;*/                                                \n"
"                                                                              \n"
"    GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (GEGL_OPERATION (op),\n"
"                                                                       \"input\");\n"
"                                                                              \n"
"    lua_State *L;                                                             \n"
"    Priv p;                                                                   \n"
"                                                                              \n"
"    L = luaL_newstate ();                                                     \n"
"    luaL_openlibs (L);                                                        \n"
"                                                                              \n"
"    register_functions (L, gluas_functions);                                  \n"
"                                                                              \n"
"    p.rgba_float = babl_format (\"RGBA float\");                              \n"
"    p.L = L;                                                                  \n"
"    p.width = in_rect->width;                                                 \n"
"    p.height = in_rect->height;                                               \n"
"                                                                              \n"
"    p.bx1 = roi->x;                                                           \n"
"    p.by1 = roi->y;                                                           \n"
"    p.bx2 = roi->x + roi->width;                                              \n"
"    p.by2 = roi->y + roi->height;                                             \n"
"                                                                              \n"
"    lua_pushnumber (L, (double) user_value);                                  \n"
"    lua_setglobal (L, \"user_value\");                                        \n"
"    lua_pushnumber (L, (double) p.width);                                     \n"
"    lua_setglobal (L, \"width\");                                             \n"
"    lua_pushnumber (L, (double) p.height);                                    \n"
"    lua_setglobal (L, \"height\");                                            \n"
"                                                                              \n"
"    lua_pushstring (L, \"priv\");                                             \n"
"    lua_pushlightuserdata (L, &p);                                            \n"
"    lua_settable (L, LUA_REGISTRYINDEX);                                      \n"
"                                                                              \n"
"    p.in_drawable  = drawable;                                                \n"
"    p.aux_drawable = aux;                                                     \n"
"    p.out_drawable = result;                                                  \n"
"                                                                              \n"
"    lua_pushnumber (L, (double) p.bx1);                                       \n"
"    lua_setglobal (L, \"bound_x0\");                                          \n"
"    lua_pushnumber (L, (double) p.bx2);                                       \n"
"    lua_setglobal (L, \"bound_x1\");                                          \n"
"    lua_pushnumber (L, (double) p.by1);                                       \n"
"    lua_setglobal (L, \"bound_y0\");                                          \n"
"    lua_pushnumber (L, (double) p.by2);                                       \n"
"    lua_setglobal (L, \"bound_y1\");                                          \n"
"                                                                              \n"
"        {                                                                     \n"
"      gint status = 0;                                                        \n"
"                                                                              \n"
"      luaL_loadstring (L, \"os.setlocale ('C', 'numeric')\");                 \n"
"                                                                              \n"
"                                                                              \n"
"      /* insert default loop start/end filling the selection */               \n"
"      if (file && file[0]!='\\0')                                             \n"
"        status = luaL_loadfile (L, file);                                     \n"
"      else if (buffer)                                                        \n"
"      {                                                                       \n"
"        GString *str = g_string_new (buffer);                                 \n"
"                                                                              \n"
"        if (!strstr (buffer, \"for x\"))                                      \n"
"        {                                                                     \n"
"          g_string_prepend (str, \"for y=bound_y0, bound_y1 do\\n for x=bound_x0, bound_x1 do\\n\");\n"
"          g_string_append (str, \" end \\n progress (y/height)\\n end\\n\");  \n"
"        }                                                                     \n"
"        status = luaL_loadbuffer (L, str->str, str->len, \"buffer\");         \n"
"                                                                              \n"
"        g_string_free (str, TRUE);                                            \n"
"      }                                                                       \n"
"                                                                              \n"
"      if (status == 0)                                                        \n"
"        status = lua_pcall (L, 0, LUA_MULTRET, 0);                            \n"
"                                                                              \n"
"      if (status != 0)                                                        \n"
"        gegl_node_set (op->node, \"error\", lua_tostring (L, -1), NULL);      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"void                                                                          \n"
"drawable_lua_do_file (GeglBuffer    *drawable,                                \n"
"                      GeglBuffer    *result,                                  \n"
"                      GeglRectangle *roi,                                     \n"
"                      const gchar   *file,                                    \n"
"                      gdouble        user_value)                              \n"
"{                                                                             \n"
"  drawable_lua_process (drawable, result, roi, file, NULL, user_value);       \n"
"}                                                                             \n"
"                                                                              \n"
"void                                                                          \n"
"drawable_lua_do_buffer (GeglBuffer    *drawable,                              \n"
"                        GeglBuffer    *result,                                \n"
"                        GeglRectangle *roi,                                   \n"
"                        const gchar   *buffer,                                \n"
"                        gdouble        user_value)                            \n"
"{                                                                             \n"
"  drawable_lua_process (drawable, result, roi, NULL, buffer, user_value);     \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void inline                                                            \n"
"get_rgba_pixel (void       *data,                                             \n"
"                int         img_no,                                           \n"
"                int         x,                                                \n"
"                int         y,                                                \n"
"                lua_Number  pixel[4])                                         \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  gfloat buf[4];                                                              \n"
"                                                                              \n"
"  p = data;                                                                   \n"
"                                                                              \n"
"  if (img_no == 0)                                                            \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      if (!p->in_drawable)                                                    \n"
"        return;                                                               \n"
"      gegl_buffer_sample (p->in_drawable, x, y, NULL, buf,                    \n"
"                          p->rgba_float,                                      \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        pixel[i] = buf[i];                                                    \n"
"    }                                                                         \n"
"  else if (img_no == 1)                                                       \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      if (!p->aux_drawable)                                                   \n"
"        return;                                                               \n"
"      gegl_buffer_sample (p->aux_drawable, x, y, NULL, buf,                   \n"
"                          p->rgba_float,                                      \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        pixel[i] = buf[i];                                                    \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"set_rgba_pixel (void       *data,                                             \n"
"                int         x,                                                \n"
"                int         y,                                                \n"
"                lua_Number  pixel[4])                                         \n"
"{                                                                             \n"
"  Priv   *p;                                                                  \n"
"  GeglRectangle roi = {x,y,1,1};                                              \n"
"  gint    i;                                                                  \n"
"  gfloat  buf[4];                                                             \n"
"                                                                              \n"
"  p = data;                                                                   \n"
"                                                                              \n"
"  /*FIXME: */                                                                 \n"
"  if (x < p->bx1 || y < p->by1 || x > p->bx2 || y > p->by2)                   \n"
"      return;     /* outside selection, ignore */                             \n"
"#if 0                                                                         \n"
"  if (x < 0 || y < 0 || x >= p->width || y >= p->height)                      \n"
"      return;    /* out of drawable bounds */                                 \n"
"#endif                                                                        \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    {                                                                         \n"
"      buf[i]=pixel[i];                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
" gegl_buffer_set (p->out_drawable, &roi,                                      \n"
"                  0, p->rgba_float, buf,                                      \n"
"                  GEGL_AUTO_ROWSTRIDE);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"l_in_width (lua_State * lua)                                                  \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"                                                                              \n"
"  lua_pushstring(lua, \"priv\");                                              \n"
"  lua_gettable(lua, LUA_REGISTRYINDEX);                                       \n"
"  p = lua_touserdata(lua, -1);                                                \n"
"  lua_pop(lua, 1);                                                            \n"
"  lua_pushnumber(lua, (double)p->width);                                      \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"l_in_height(lua_State * lua)                                                  \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"                                                                              \n"
"  lua_pushstring(lua, \"priv\");                                              \n"
"  lua_gettable(lua, LUA_REGISTRYINDEX);                                       \n"
"  p = lua_touserdata(lua, -1);                                                \n"
"  lua_pop(lua, 1);                                                            \n"
"  lua_pushnumber(lua, (double)p->height);                                     \n"
"                                                                              \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"l_flush (lua_State * lua)                                                     \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"                                                                              \n"
"  lua_pushstring(lua, \"priv\");                                              \n"
"  lua_gettable(lua, LUA_REGISTRYINDEX);                                       \n"
"  p = lua_touserdata(lua, -1);                                                \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"l_progress(lua_State * lua)                                                   \n"
"{                                                                             \n"
"  lua_Number percent;                                                         \n"
"                                                                              \n"
"  if (!lua_gettop(lua))                                                       \n"
"    return 0;                                                                 \n"
"  percent = lua_tonumber(lua, -1);                                            \n"
"                                                                              \n"
"#if 0                                                                         \n"
"  g_warning (\"progress,.. %f\", percent);                                    \n"
"  gimp_progress_update((double) percent);                                     \n"
"#endif                                                                        \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"l_print (lua_State * lua)                                                     \n"
"{                                                                             \n"
"  if (!lua_gettop(lua))                                                       \n"
"    return 0;                                                                 \n"
"  g_print (\"%s\\n\", lua_tostring(lua, -1));                                 \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static int l_set_rgba (lua_State * lua)                                       \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y;                                                          \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 6)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_rgba (x, y, r, g, b, a)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x        = lua_tonumber (lua, -6);                                        \n"
"    y        = lua_tonumber (lua, -5);                                        \n"
"    pixel[0] = lua_tonumber (lua, -4);                                        \n"
"    pixel[1] = lua_tonumber (lua, -3);                                        \n"
"    pixel[2] = lua_tonumber (lua, -2);                                        \n"
"    pixel[3] = lua_tonumber (lua, -1);                                        \n"
"                                                                              \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_rgba (lua_State * lua)                                       \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number pixel[4];                                                        \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_rgba (x, y)\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"                                                                              \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"  get_rgba_pixel (p, img_no, x, y, pixel);                                    \n"
"                                                                              \n"
"  lua_pushnumber (lua, pixel[0]);                                             \n"
"  lua_pushnumber (lua, pixel[1]);                                             \n"
"  lua_pushnumber (lua, pixel[2]);                                             \n"
"  lua_pushnumber (lua, pixel[3]);                                             \n"
"                                                                              \n"
"  return 4;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_rgb (lua_State * lua)                                        \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y;                                                          \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 5)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_rgb (x, y, r, g, b)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -5);                                               \n"
"    y = lua_tonumber (lua, -4);                                               \n"
"                                                                              \n"
"    pixel[0] = lua_tonumber (lua, -3);                                        \n"
"    pixel[1] = lua_tonumber (lua, -2);                                        \n"
"    pixel[2] = lua_tonumber (lua, -1);                                        \n"
"    pixel[3] = 1.0;                                                           \n"
"                                                                              \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"                                                                              \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_rgb (lua_State * lua)                                        \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number pixel[4];                                                        \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_rgb (x, y, [, image_no])\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"  get_rgba_pixel (p, img_no, x, y, pixel);                                    \n"
"                                                                              \n"
"  lua_pushnumber (lua, pixel[0]);                                             \n"
"  lua_pushnumber (lua, pixel[1]);                                             \n"
"  lua_pushnumber (lua, pixel[2]);                                             \n"
"                                                                              \n"
"  return 3;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_value (lua_State * lua)                                      \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number x, y, v;                                                       \n"
"    lua_Number pixel[4];                                                      \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 3)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_value (x, y, value)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -3);                                               \n"
"    y = lua_tonumber (lua, -2);                                               \n"
"    v = lua_tonumber (lua, -1);                                               \n"
"                                                                              \n"
"    pixel[0] = pixel[1] = pixel[2] = v;                                       \n"
"    pixel[3] = 1.0;                                                           \n"
"                                                                              \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"int l_get_value (lua_State * lua)                                             \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number pixel[4];                                                        \n"
"  lua_Number x,y;                                                             \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_value (x, y [, image_no])\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"  get_rgba_pixel (p, img_no, x, y, pixel);                                    \n"
"                                                                              \n"
"  lua_pushnumber (lua, (pixel[0]+pixel[1]+pixel[2]) * (1.0/3));               \n"
"                                                                              \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_alpha (lua_State * lua)                                      \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y, a;                                                       \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 3)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_alpha (x, y, a)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -3);                                               \n"
"    y = lua_tonumber (lua, -2);                                               \n"
"    a = lua_tonumber (lua, -1);                                               \n"
"                                                                              \n"
"    get_rgba_pixel (p, 0, x, y, pixel);                                       \n"
"    pixel[3] = a;                                                             \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"                                                                              \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_alpha (lua_State * lua)                                      \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number pixel[4];                                                        \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_alpha (x, y [,image])\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"  get_rgba_pixel (p, img_no, x, y, pixel);                                    \n"
"  lua_pushnumber (lua, pixel[3]);                                             \n"
"                                                                              \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_lab (lua_State * lua)                                        \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y, l, a, b;                                                 \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 5)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_lab (x, y, l, a, b)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -5);                                               \n"
"    y = lua_tonumber (lua, -4);                                               \n"
"    l = lua_tonumber (lua, -3);                                               \n"
"    a = lua_tonumber (lua, -2);                                               \n"
"    b = lua_tonumber (lua, -1);                                               \n"
"                                                                              \n"
"    /* pixel assumed to be of type double */                                  \n"
"                                                                              \n"
"    get_rgba_pixel (p, 0, x, y, pixel);                                       \n"
"#if 0                                                                         \n"
"    cpercep_space_to_rgb (l, a, b, &(pixel[0]), &(pixel[1]), &(pixel[2]));    \n"
"      {                                                                       \n"
"      int i;                                                                  \n"
"      for (i=0;i<3;i++)                                                       \n"
"        pixel[i] *= (1.0/255.0);                                              \n"
"      }                                                                       \n"
"#endif                                                                        \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"                                                                              \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_lab (lua_State * lua)                                        \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_Number pixel[4];                                                        \n"
"  /*double lab_pixel[3];*/                                                    \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_rgb (x, y, [, image_no])\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"  get_rgba_pixel (p, img_no, x, y, pixel);                                    \n"
"                                                                              \n"
"#if 0                                                                         \n"
"  cpercep_rgb_to_space (pixel[0] * 255.0,                                     \n"
"                        pixel[1] * 255.0,                                     \n"
"                        pixel[2] * 255.0,                                     \n"
"                                                                              \n"
"                        &(lab_pixel[0]),                                      \n"
"                        &(lab_pixel[1]),                                      \n"
"                        &(lab_pixel[2]));                                     \n"
"                                                                              \n"
"  lua_pushnumber (lua, lab_pixel[0]);                                         \n"
"  lua_pushnumber (lua, lab_pixel[1]);                                         \n"
"  lua_pushnumber (lua, lab_pixel[2]);                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"  return 3;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_hsl (lua_State * lua)                                        \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y, h, s, l;                                                 \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 5)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_lab (x, y, l, a, b)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -5);                                               \n"
"    y = lua_tonumber (lua, -4);                                               \n"
"    h = lua_tonumber (lua, -3);                                               \n"
"    s = lua_tonumber (lua, -2);                                               \n"
"    l = lua_tonumber (lua, -1);                                               \n"
"                                                                              \n"
"    get_rgba_pixel (p, 0, x, y, pixel);                                       \n"
"                                                                              \n"
"#if 0                                                                         \n"
"    {                                                                         \n"
"      GimpRGB rgb;                                                            \n"
"      GimpHSL hsl;                                                            \n"
"                                                                              \n"
"      hsl.h = h;                                                              \n"
"      hsl.s = s;                                                              \n"
"      hsl.l = l;                                                              \n"
"                                                                              \n"
"      gimp_hsl_to_rgb (&hsl, &rgb);                                           \n"
"                                                                              \n"
"      pixel[0]=rgb.r;                                                         \n"
"      pixel[1]=rgb.g;                                                         \n"
"      pixel[2]=rgb.b;                                                         \n"
"    }                                                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_hsl (lua_State * lua)                                        \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_Number pixel[4];                                                        \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_rgb ([image_no,] x, y)\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"    get_rgba_pixel (p, img_no, x, y, pixel);                                  \n"
"                                                                              \n"
"#if 0                                                                         \n"
"    {                                                                         \n"
"      GimpRGB rgb;                                                            \n"
"      GimpHSL hsl;                                                            \n"
"                                                                              \n"
"      rgb.r = pixel[0];                                                       \n"
"      rgb.g = pixel[1];                                                       \n"
"      rgb.b = pixel[2];                                                       \n"
"                                                                              \n"
"      gimp_rgb_to_hsl (&rgb, &hsl);                                           \n"
"                                                                              \n"
"      lua_pushnumber (lua, hsl.h );                                           \n"
"      lua_pushnumber (lua, hsl.s );                                           \n"
"      lua_pushnumber (lua, hsl.l );                                           \n"
"    }                                                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"  return 3;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_set_hsv (lua_State * lua)                                        \n"
"{                                                                             \n"
"    Priv *p;                                                                  \n"
"    lua_Number pixel[4];                                                      \n"
"    lua_Number x, y, h, s, v;                                                 \n"
"                                                                              \n"
"    lua_pushstring (lua, \"priv\");                                           \n"
"    lua_gettable (lua, LUA_REGISTRYINDEX);                                    \n"
"    p = lua_touserdata (lua, -1);                                             \n"
"    lua_pop (lua, 1);                                                         \n"
"                                                                              \n"
"    if (lua_gettop (lua) != 5)                                                \n"
"      {                                                                       \n"
"        lua_pushstring(lua,                                                   \n"
"                       \"incorrect number of arguments to set_lab (x, y, l, a, b)\\n\");\n"
"        lua_error (lua);                                                      \n"
"        return 0;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"    x = lua_tonumber (lua, -5);                                               \n"
"    y = lua_tonumber (lua, -4);                                               \n"
"    h = lua_tonumber (lua, -3);                                               \n"
"    s = lua_tonumber (lua, -2);                                               \n"
"    v = lua_tonumber (lua, -1);                                               \n"
"                                                                              \n"
"    get_rgba_pixel (p, 0, x, y, pixel);                                       \n"
"                                                                              \n"
"#if 0                                                                         \n"
"    {                                                                         \n"
"      GimpRGB rgb;                                                            \n"
"      GimpHSV hsv;                                                            \n"
"                                                                              \n"
"      hsv.h = h;                                                              \n"
"      hsv.s = s;                                                              \n"
"      hsv.v = v;                                                              \n"
"                                                                              \n"
"      gimp_hsv_to_rgb (&hsv, &rgb);                                           \n"
"                                                                              \n"
"      pixel[0]=rgb.r;                                                         \n"
"      pixel[1]=rgb.g;                                                         \n"
"      pixel[2]=rgb.b;                                                         \n"
"    }                                                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"    set_rgba_pixel (p, x, y, pixel);                                          \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int l_get_hsv (lua_State * lua)                                        \n"
"{                                                                             \n"
"  Priv *p;                                                                    \n"
"  lua_Number x, y;                                                            \n"
"  lua_Number img_no = 0;                                                      \n"
"                                                                              \n"
"  lua_Number pixel[4];                                                        \n"
"                                                                              \n"
"  lua_pushstring (lua, \"priv\");                                             \n"
"  lua_gettable (lua, LUA_REGISTRYINDEX);                                      \n"
"  p = lua_touserdata (lua, -1);                                               \n"
"  lua_pop(lua, 1);                                                            \n"
"                                                                              \n"
"  switch (lua_gettop (lua))                                                   \n"
"    {                                                                         \n"
"    case 3:                                                                   \n"
"      img_no = lua_tonumber(lua, -3);                                         \n"
"      break;                                                                  \n"
"    case 2:                                                                   \n"
"      img_no = 0;                                                             \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      lua_pushstring (lua, \"incorrect number of arguments to get_rgb ([image_no,] x, y)\\n\");\n"
"      lua_error (lua);                                                        \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"  x = lua_tonumber(lua, -2);                                                  \n"
"  y = lua_tonumber(lua, -1);                                                  \n"
"                                                                              \n"
"    get_rgba_pixel (p, img_no, x, y, pixel);                                  \n"
"                                                                              \n"
"#if 0                                                                         \n"
"    {                                                                         \n"
"      GimpRGB rgb;                                                            \n"
"      GimpHSV hsv;                                                            \n"
"                                                                              \n"
"      rgb.r = pixel[0];                                                       \n"
"      rgb.g = pixel[1];                                                       \n"
"      rgb.b = pixel[2];                                                       \n"
"                                                                              \n"
"      gimp_rgb_to_hsv (&rgb, &hsv);                                           \n"
"                                                                              \n"
"      lua_pushnumber (lua, hsv.h );                                           \n"
"      lua_pushnumber (lua, hsv.s );                                           \n"
"      lua_pushnumber (lua, hsv.v );                                           \n"
"    }                                                                         \n"
"#endif                                                                        \n"
"  return 3;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"aux\",    babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  result = *in_rect;                                                          \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->file && g_file_test (o->file, G_FILE_TEST_IS_REGULAR))               \n"
"    {                                                                         \n"
"      drawable_lua_process (operation, input, aux, output, result, o->file, NULL, o->user_value);\n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      drawable_lua_process (operation, input, aux, output, result, NULL, o->script, o->user_value);\n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation        *operation,                     \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  composer_class->process = process;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\"        , \"gegl:gluas\",                                           \n"
"  \"categories\"  , \"script:misc\",                                          \n"
"  \"description\" ,                                                           \n"
"        _(\"A general purpose filter/composer implementation proxy for the\"  \n"
"          \" lua programming language.\"),                                    \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
