static const char* op_c_source =
"/* This file is part of GEGL                                                  \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås                                              \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x,      _(\"X\"),      0.0)                                  \n"
"  ui_range      (0.0, 1024.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-coordinate\")                              \n"
"  ui_meta       (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (y,      _(\"Y\"),      0.0)                                  \n"
"  ui_range      (0.0, 1024.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-coordinate\")                              \n"
"  ui_meta       (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (width,  _(\"Width\"),  10.0 )                                \n"
"  ui_range      (0.0, 1024.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-distance\")                                \n"
"  ui_meta       (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (height, _(\"Height\"), 10.0 )                                \n"
"  ui_range      (0.0, 1024.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-distance\")                                \n"
"  ui_meta       (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_boolean (reset_origin, _(\"Reset origin\"), FALSE)                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     crop                                                 \n"
"#define GEGL_OP_C_SOURCE crop.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_crop_prepare (GeglOperation *operation)                                  \n"
"{                                                                             \n"
"  const Babl *format = gegl_operation_get_source_format (operation, \"input\");\n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglNode *                                                             \n"
"gegl_crop_detect (GeglOperation *operation,                                   \n"
"                  gint           x,                                           \n"
"                  gint           y)                                           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglNode   *input_node;                                                     \n"
"                                                                              \n"
"  input_node = gegl_operation_get_source_node (operation, \"input\");         \n"
"                                                                              \n"
"  if (input_node)                                                             \n"
"    return gegl_node_detect (input_node,                                      \n"
"                             x - floor (o->x),                                \n"
"                             y - floor (o->y));                               \n"
"                                                                              \n"
"  return operation->node;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_crop_get_bounding_box (GeglOperation *operation)                         \n"
"{                                                                             \n"
"  GeglProperties      *o = GEGL_PROPERTIES (operation);                       \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  GeglRectangle  result  = { 0, 0, 0, 0 };                                    \n"
"                                                                              \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  result.x      = o->x;                                                       \n"
"  result.y      = o->y;                                                       \n"
"  result.width  = o->width;                                                   \n"
"  result.height = o->height;                                                  \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&result, &result, in_rect);                       \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_crop_get_invalidated_by_change (GeglOperation       *operation,          \n"
"                                     const gchar         *input_pad,          \n"
"                                     const GeglRectangle *input_region)       \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle   result;                                                     \n"
"                                                                              \n"
"  result.x      = o->x;                                                       \n"
"  result.y      = o->y;                                                       \n"
"  result.width  = o->width;                                                   \n"
"  result.height = o->height;                                                  \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&result, &result, input_region);                  \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_crop_get_required_for_output (GeglOperation       *operation,            \n"
"                                   const gchar         *input_pad,            \n"
"                                   const GeglRectangle *roi)                  \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle   result;                                                     \n"
"                                                                              \n"
"  result.x      = o->x;                                                       \n"
"  result.y      = o->y;                                                       \n"
"  result.width  = o->width;                                                   \n"
"  result.height = o->height;                                                  \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&result, &result, roi);                           \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_crop_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer     *input;                                                      \n"
"  gboolean        success = FALSE;                                            \n"
"                                                                              \n"
"  input = gegl_operation_context_get_source (context, \"input\");             \n"
"                                                                              \n"
"  if (input)                                                                  \n"
"    {                                                                         \n"
"      GeglRectangle  extent;                                                  \n"
"      GeglBuffer    *output;                                                  \n"
"                                                                              \n"
"      extent = *GEGL_RECTANGLE (o->x, o->y,  o->width, o->height);            \n"
"                                                                              \n"
"      /* The output buffer's extent must be a subset of the input buffer's    \n"
"       * extent; otherwise, if the output buffer is reused for in-place output,\n"
"       * we might try to write to areas of the buffer that lie outside the    \n"
"       * input buffer, erroneously discarding the data.                       \n"
"       */                                                                     \n"
"      gegl_rectangle_intersect (&extent,                                      \n"
"                                &extent, gegl_buffer_get_extent (input));     \n"
"                                                                              \n"
"      output = gegl_buffer_create_sub_buffer (input, &extent);                \n"
"                                                                              \n"
"      if (gegl_object_get_has_forked (G_OBJECT (input)))                      \n"
"        gegl_object_set_has_forked (G_OBJECT (output));                       \n"
"                                                                              \n"
"      gegl_operation_context_take_object (context, \"output\", G_OBJECT (output));\n"
"                                                                              \n"
"      g_object_unref (input);                                                 \n"
"      success = TRUE;                                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      g_warning (\"%s got NULL input pad\", gegl_node_get_operation (operation->node));\n"
"    }                                                                         \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"  gchar              *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='x'>50</param>\"                                        \n"
"    \"    <param name='y'>80</param>\"                                        \n"
"    \"    <param name='width'>70</param>\"                                    \n"
"    \"    <param name='height'>60</param>\"                                   \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->threaded                  = FALSE;                         \n"
"  operation_class->process                   = gegl_crop_process;             \n"
"  operation_class->prepare                   = gegl_crop_prepare;             \n"
"  operation_class->get_bounding_box          = gegl_crop_get_bounding_box;    \n"
"  operation_class->detect                    = gegl_crop_detect;              \n"
"  operation_class->get_invalidated_by_change = gegl_crop_get_invalidated_by_change;\n"
"  operation_class->get_required_for_output   = gegl_crop_get_required_for_output;\n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",        \"gegl:crop\",                                         \n"
"      \"categories\",  \"core\",                                              \n"
"      \"title\",       _(\"Crop\"),                                           \n"
"      \"description\", _(\"Crop a buffer\"),                                  \n"
"      \"reference-composition\", composition,                                 \n"
"      NULL);                                                                  \n"
"                                                                              \n"
"  operation_class->no_cache = TRUE;                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
