static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * This operation is a port of the GIMP antialias plugin:                     \n"
" *                                                                            \n"
" *     Auntie Alias 0.92 --- image filter plug-in                             \n"
" *     Copyright (C) 1995 Spencer Kimball and Peter Mattis                    \n"
" *     Copyright (C) 2005 Adam D. Moss (adam@gimp.org)                        \n"
" *                                                                            \n"
" * The porting to GEGL was done by Barak Itkin                                \n"
" *                                                                            \n"
" *     Copyright 2013 Barak Itkin <lightningismyname@gmail.com>               \n"
" */                                                                           \n"
"                                                                              \n"
"/* This plugin performs a pseudo-antialiasing effect on hard-edged source     \n"
" * material.  It does this by performing a 'clever' edge extrapolation for    \n"
" * each pixel which is then resampled back to a single pixel for output.      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"/* This operation has no properties */                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     antialias                                            \n"
"#define GEGL_OP_C_SOURCE antialias.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *input_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  if (input_format == NULL || babl_format_has_alpha (input_format))           \n"
"    format = babl_format (\"R'G'B'A float\");                                 \n"
"  else                                                                        \n"
"    format = babl_format (\"R'G'B' float\");                                  \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  =                                                           \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = 1;                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle *region;                                                      \n"
"                                                                              \n"
"  region = gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"                                                                              \n"
"  if (region != NULL)                                                         \n"
"    return *region;                                                           \n"
"  else                                                                        \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"extrapolate9 (const int components,                                           \n"
"              gfloat *E0, gfloat *E1, gfloat *E2,                             \n"
"              gfloat *E3, gfloat *E4, gfloat *E5,                             \n"
"              gfloat *E6, gfloat *E7, gfloat *E8,                             \n"
"              gfloat *A,  gfloat *B,  gfloat *C,                              \n"
"              gfloat *D,  gfloat *E,  gfloat *F,                              \n"
"              gfloat *G,  gfloat *H,  gfloat *I)                              \n"
"{                                                                             \n"
"#define PEQ(X,Y)      (0 == memcmp ((X), (Y), components * sizeof(gfloat)))   \n"
"#define PCPY(DST,SRC) memcpy ((DST), (SRC), components * sizeof(gfloat))      \n"
"                                                                              \n"
"  /* an implementation of the Scale3X edge-extrapolation algorithm */         \n"
"  if ( (!PEQ(B,H)) && (!PEQ(D,F)) )                                           \n"
"    {                                                                         \n"
"      if (PEQ(D,B)) PCPY(E0,D); else PCPY(E0,E);                              \n"
"      if ((PEQ(D,B) && !PEQ(E,C)) || (PEQ(B,F) && !PEQ(E,A)))                 \n"
"        PCPY(E1,B); else PCPY(E1,E);                                          \n"
"      if (PEQ(B,F)) PCPY(E2,F); else PCPY(E2,E);                              \n"
"      if ((PEQ(D,B) && !PEQ(E,G)) || (PEQ(D,H) && !PEQ(E,A)))                 \n"
"        PCPY(E3,D); else PCPY(E3,E);                                          \n"
"      PCPY(E4,E);                                                             \n"
"      if ((PEQ(B,F) && !PEQ(E,I)) || (PEQ(H,F) && !PEQ(E,C)))                 \n"
"        PCPY(E5,F); else PCPY(E5,E);                                          \n"
"      if (PEQ(D,H)) PCPY(E6,D); else PCPY(E6,E);                              \n"
"      if ((PEQ(D,H) && !PEQ(E,I)) || (PEQ(H,F) && !PEQ(E,G)))                 \n"
"        PCPY(E7,H); else PCPY(E7,E);                                          \n"
"      if (PEQ(H,F)) PCPY(E8,F); else PCPY(E8,E);                              \n"
"      return 1;                                                               \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      return 0;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"#undef PEQ                                                                    \n"
"#undef PCPY                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gint          components;                                                   \n"
"  gint          col, c;                                                       \n"
"  gfloat       *rowbefore;                                                    \n"
"  gfloat       *rowthis;                                                      \n"
"  gfloat       *rowafter;                                                     \n"
"  gfloat       *dest;                                                         \n"
"  gfloat       *ninepix;                                                      \n"
"  gboolean      has_alpha;                                                    \n"
"  guint         alpha;                                                        \n"
"  const Babl   *format = gegl_operation_get_format (operation, \"input\");    \n"
"                                                                              \n"
"  /* The rectangle of the current row we are working on */                    \n"
"  GeglRectangle rowrect;                                                      \n"
"                                                                              \n"
"  /* The rectangle of the sample we are going to take for the                 \n"
"   * next line (this does include the interpolation distance!) */             \n"
"  GeglRectangle rownext_bufrect;                                              \n"
"                                                                              \n"
"  components = babl_format_get_n_components (format);                         \n"
"  has_alpha  = babl_format_has_alpha (format);                                \n"
"  alpha      = components - 1;                                                \n"
"                                                                              \n"
"  /* The original algorithm that appeared in GIMP did a manual clamping       \n"
"   * of samples outside the input rectangle, by always allocating a           \n"
"   * buffer which is 1-pixel wider than necessary, and then filling the       \n"
"   * edges of the buffer with repetitions of the edges.                       \n"
"   * We don't need this complexity here thanks to the CLAMP abyss policy      \n"
"   * which is implemented by GEGL. We still allocate buffers which are        \n"
"   * larger, but we let GEGL fill the edges with the clamped values.          \n"
"   */                                                                         \n"
"                                                                              \n"
"  rowbefore  = g_new (gfloat, (roi->width + 2) * components);                 \n"
"  rowthis    = g_new (gfloat, (roi->width + 2) * components);                 \n"
"  rowafter   = g_new (gfloat, (roi->width + 2) * components);                 \n"
"  dest       = g_new (gfloat, roi->width * components);                       \n"
"  ninepix    = g_new (gfloat, 9 * components);                                \n"
"                                                                              \n"
"  gegl_rectangle_set (&rowrect, roi->x, roi->y, roi->width, 1);               \n"
"  gegl_rectangle_set (&rownext_bufrect, roi->x - 1, roi->y - 1, roi->width + 2, 1);\n"
"                                                                              \n"
"  gegl_buffer_get (input, &rownext_bufrect, 1.0, format,                      \n"
"                   rowbefore, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);         \n"
"  ++rownext_bufrect.y;                                                        \n"
"                                                                              \n"
"  gegl_buffer_get (input, &rownext_bufrect, 1.0, format,                      \n"
"                   rowthis, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);           \n"
"  ++rownext_bufrect.y;                                                        \n"
"                                                                              \n"
"  gegl_buffer_get (input, &rownext_bufrect, 1.0, format,                      \n"
"                   rowafter, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);          \n"
"  ++rownext_bufrect.y;                                                        \n"
"                                                                              \n"
"  for (rowrect.y = roi->y; rowrect.y < (roi->y + roi->height); ++rowrect.y)   \n"
"    {                                                                         \n"
"      gfloat *tmp;                                                            \n"
"                                                                              \n"
"      /* this macro returns the current pixel if it has some opacity. Otherwise\n"
"       * it returns the center pixel of the current 3x3 area. */              \n"
"#define USE_IF_ALPHA(p) (((!has_alpha) || *((p)+alpha)) ? (p) : &rowthis[(col+1) * components])\n"
"                                                                              \n"
"      for (col = 0; col < roi->width; ++col)                                  \n"
"        {                                                                     \n"
"          /* do 9x extrapolation pass */                                      \n"
"          if (((!has_alpha) || (rowthis[(col + 1) * components + alpha] > 0)) &&\n"
"              extrapolate9 (components,                                       \n"
"                            &ninepix[0 * components],                         \n"
"                            &ninepix[1 * components],                         \n"
"                            &ninepix[2 * components],                         \n"
"                            &ninepix[3 * components],                         \n"
"                            &ninepix[4 * components],                         \n"
"                            &ninepix[5 * components],                         \n"
"                            &ninepix[6 * components],                         \n"
"                            &ninepix[7 * components],                         \n"
"                            &ninepix[8 * components],                         \n"
"                            USE_IF_ALPHA (&rowbefore[(col + 0) * components]),\n"
"                            USE_IF_ALPHA (&rowbefore[(col + 1) * components]),\n"
"                            USE_IF_ALPHA (&rowbefore[(col + 2) * components]),\n"
"                            USE_IF_ALPHA (&rowthis  [(col + 0) * components]),\n"
"                                          &rowthis  [(col + 1) * components], \n"
"                            USE_IF_ALPHA (&rowthis  [(col + 2) * components]),\n"
"                            USE_IF_ALPHA (&rowafter [(col + 0) * components]),\n"
"                            USE_IF_ALPHA (&rowafter [(col + 1) * components]),\n"
"                            USE_IF_ALPHA (&rowafter [(col + 2) * components]) \n"
"                            ))                                                \n"
"            {                                                                 \n"
"              /* subsample results and put into dest */                       \n"
"              for (c = 0; c < components; ++c)                                \n"
"                {                                                             \n"
"#define NINEPIX(index, c) ninepix[(index) * components + (c)]                 \n"
"                  dest[(col * components) + c] =                              \n"
"                    (3 * NINEPIX(0, c) + 5 * NINEPIX(1, c) + 3 * NINEPIX(2, c) +\n"
"                     5 * NINEPIX(3, c) + 6 * NINEPIX(4, c) + 5 * NINEPIX(5, c) +\n"
"                     3 * NINEPIX(6, c) + 5 * NINEPIX(7, c) + 3 * NINEPIX(8, c)\n"
"                    /* The GIMP implementation added 19 (out of 255) here before\n"
"                     * normalizing (dividing by 38), which is equivalent to a \n"
"                     * call to \"ceil\". We don't need this since we are working\n"
"                     * with floating point numbers... */                      \n"
"                    ) / 38;                                                   \n"
"#undef NINEPIX                                                                \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              memcpy (&dest[col * components], &rowthis[(col + 1) * components], components * sizeof(gfloat));\n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"#undef USE_IF_ALPHA                                                           \n"
"                                                                              \n"
"      /* write result row to dest */                                          \n"
"      gegl_buffer_set (output, &rowrect, 0, format, &dest[0], GEGL_AUTO_ROWSTRIDE);\n"
"                                                                              \n"
"      /* rotate pointers */                                                   \n"
"      tmp       = rowbefore;                                                  \n"
"      rowbefore = rowthis;                                                    \n"
"      rowthis   = rowafter;                                                   \n"
"      rowafter  = tmp;                                                        \n"
"                                                                              \n"
"      /* populate new after-row */                                            \n"
"      gegl_buffer_get (input, &rownext_bufrect, 1.0, format,                  \n"
"                       rowafter, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);      \n"
"      ++rownext_bufrect.y;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (rowbefore);                                                         \n"
"  g_free (rowthis);                                                           \n"
"  g_free (rowafter);                                                          \n"
"  g_free (dest);                                                              \n"
"  g_free (ninepix);                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class          = GEGL_OPERATION_CLASS (klass);                    \n"
"  filter_class             = GEGL_OPERATION_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  filter_class->process             = process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:antialias\",                                      \n"
"    \"title\",       _(\"Scale3X Antialiasing\"),                             \n"
"    \"categories\",  \"enhance\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Antialias using the Scale3X edge-extrapolation algorithm\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
