/* p11-getslotinfo.c - Cryptoki implementation.
   Copyright (C) 2006 g10 Code GmbH

   This file is part of Scute[1].

   [1] Derived from the RSA Security Inc. PKCS #11 Cryptographic Token
   Interface (Cryptoki).
 
   Scute is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Scute is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Scute; if not, write to the Free Software Foundation,
   Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

   In addition, as a special exception, g10 Code GmbH gives permission
   to link this library: with the Mozilla Foundation's code for
   Mozilla (or with modified versions of it that use the same license
   as the "Mozilla" code), and distribute the linked executables.  You
   must obey the GNU General Public License in all respects for all of
   the code used other than "Mozilla".  If you modify this file, you
   may extend this exception to your version of the file, but you are
   not obligated to do so.  If you do not wish to do so, delete this
   exception statement from your version.  */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "cryptoki.h"

#include "locking.h"
#include "support.h"
#include "settings.h"
#include "slots.h"


CK_DEFINE_FUNCTION(CK_RV, C_GetSlotInfo)
     (CK_SLOT_ID slotID, CK_SLOT_INFO_PTR pInfo)
{
  CK_RV err = CKR_OK;
  slot_iterator_t slot;

  err = scute_global_lock ();
  if (err)
    return err;

  err = slots_lookup (slotID, &slot);
  if (err)
    goto out;

  err = slots_update_slot (slot);
  if (err)
    goto out;

  /* FIXME: Query some of this from SCD.  */
  scute_copy_string (pInfo->slotDescription, SLOT_DESCRIPTION, 64);
  scute_copy_string (pInfo->manufacturerID, SLOT_MANUFACTURER_ID, 32);

  pInfo->flags = CKF_REMOVABLE_DEVICE | CKF_HW_SLOT;
  if (slot_token_present (slot))
    pInfo->flags |= CKF_TOKEN_PRESENT;
  pInfo->hardwareVersion.major = SLOT_HARDWARE_VERSION_MAJOR;
  pInfo->hardwareVersion.minor = SLOT_HARDWARE_VERSION_MINOR;
  pInfo->firmwareVersion.major = SLOT_FIRMWARE_VERSION_MAJOR;
  pInfo->firmwareVersion.minor = SLOT_FIRMWARE_VERSION_MINOR;

 out:
  scute_global_unlock ();
  return err;
}
