/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.Activator;

public class SelectionUtils {
    private SelectionUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static IFile getSelectedIFile() {
        IFileEditorInput iFileEditorInput;
        IEditorInput input;
        IEditorInput iEditorInput;
        try {
            ISelection selection;
            ISelection iSelection = selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (iSelection instanceof IStructuredSelection var1_3) {
                void structuredSelection;
                return (IFile)Adapters.adapt((Object)structuredSelection.getFirstElement(), IFile.class);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e));
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (iEditorInput = (input = editor.getEditorInput())) instanceof IFileEditorInput && (iFileEditorInput = (IFileEditorInput)iEditorInput) == (IFileEditorInput)iEditorInput) {
            void file;
            return file.getFile();
        }
        return null;
    }

    public static File getSelectedFile(Predicate<File> condition) {
        File file;
        IEditorPart editor;
        IFile iFile = SelectionUtils.getSelectedIFile();
        if (iFile != null) {
            File file2 = iFile.getRawLocation().makeAbsolute().toFile();
            if (condition == null || condition.test(file2)) {
                return file2;
            }
        }
        if ((editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (file = SelectionUtils.getFile(editor.getEditorInput(), condition)) != null) {
            return file;
        }
        return null;
    }

    public static File getSelectedProject() {
        IFile iFile = SelectionUtils.getSelectedIFile();
        if (iFile != null) {
            return iFile.getProject().getLocation().toFile();
        }
        File file = SelectionUtils.getSelectedFile(null);
        if (file != null) {
            return file.getParentFile();
        }
        return null;
    }

    public static String pathOrEmpty(File file) {
        return file != null ? file.getAbsolutePath() : "";
    }

    public static File getFile(ISelection selection, Predicate<File> condition) {
        if (selection instanceof IStructuredSelection var2_3 && (resource = (IResource)Adapters.adapt((Object)(firstElement = structuredSelection.getFirstElement()), IResource.class)) != null) {
            File file = resource.getLocation().toFile();
            if (condition == null || condition.test(file)) {
                return file;
            }
        }
        if (selection instanceof TextSelection && (var8_7 = (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart())) instanceof ITextEditor && (resource = (ITextEditor)var8_7) == (ITextEditor)var8_7) {
            return SelectionUtils.getFile(editor.getEditorInput(), condition);
        }
        return null;
    }

    public static File getFile(IEditorInput editorInput, Predicate<File> condition) {
        if (editorInput instanceof FileEditorInput var2_3 && (file = input.getFile().getLocation().toFile()) != null && (condition == null || condition.test((File)file))) {
            return file;
        }
        IEditorInput iEditorInput = editorInput;
        if (iEditorInput instanceof IURIEditorInput && (file = (IURIEditorInput)iEditorInput) == (IURIEditorInput)iEditorInput) {
            File file = new File(input.getURI());
            if (condition == null || condition.test(file)) {
                return file;
            }
        }
        return null;
    }
}

