/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.wizards;

import java.io.FileReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.LanguageConfigurationInfoWidget;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

final class SelectLanguageConfigurationWizardPage
extends WizardPage
implements Listener {
    private static final String PAGE_NAME = SelectLanguageConfigurationWizardPage.class.getName();
    private static final String[] TEXTMATE_EXTENSIONS = new String[]{"*language-configuration.json"};
    private @Nullable Text fileText;
    private @Nullable Text contentTypeText;
    private @Nullable LanguageConfigurationInfoWidget infoWidget;
    private final ILanguageConfigurationRegistryManager registryManager;

    SelectLanguageConfigurationWizardPage(ILanguageConfigurationRegistryManager registryManager) {
        super(PAGE_NAME);
        this.registryManager = registryManager;
        super.setTitle(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_page_title);
        super.setDescription(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_page_description);
    }

    public void createControl(@Nullable Composite parent) {
        assert (parent != null);
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.createBody(topLevel);
        this.setPageComplete(false);
        this.setControl((Control)topLevel);
    }

    public void handleEvent(@Nullable Event event) {
        this.validateAndUpdateStatus();
    }

    private void validateAndUpdateStatus() {
        IStatus status = this.validatePage();
        this.statusChanged(status == null ? Status.OK_STATUS : status);
    }

    private void statusChanged(IStatus status) {
        this.setPageComplete(!status.matches(4));
        SelectLanguageConfigurationWizardPage.applyToStatusLine((DialogPage)this, status);
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = Status.OK_STATUS.equals(status) ? null : status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                page.setMessage(null);
                page.setErrorMessage((String)(message != null && message.isEmpty() ? null : message));
            }
        }
    }

    private void createBody(Composite ancestor) {
        LanguageConfigurationInfoWidget infoWidget;
        Text fileText;
        final Composite parent = new Composite(ancestor, 0);
        parent.setFont(parent.getFont());
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.fileText = fileText = this.createText(parent, LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_file);
        fileText.addListener(24, (Listener)this);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.infoWidget = infoWidget = new LanguageConfigurationInfoWidget(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        infoWidget.setLayoutData(data);
        Button browseFileSystemButton = new Button(buttons, 0);
        browseFileSystemButton.setText(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_browse_fileSystem);
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell());
                dialog.setFilterExtensions(TEXTMATE_EXTENSIONS);
                dialog.setFilterPath(fileText.getText());
                String result = dialog.open();
                if (result != null && !result.isEmpty()) {
                    fileText.setText(result);
                }
            }
        });
        final Button browseWorkspaceButton = new Button(buttons, 0);
        browseWorkspaceButton.setText(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_browse_workspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(browseWorkspaceButton.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_workspace_description);
                dialog.setTitle(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_workspace_title);
                int returnCode = dialog.open();
                Object[] results = dialog.getResult();
                if (returnCode == 0 && results.length > 0) {
                    fileText.setText(((IResource)results[0]).getFullPath().makeRelative().toString());
                }
            }
        });
        this.contentTypeText = this.createText(parent, LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_contentType);
        this.contentTypeText.addListener(24, (Listener)this);
        this.createContentTypeTreeViewer(parent);
    }

    private void createContentTypeTreeViewer(Composite composite) {
        TreeViewer contentTypesViewer = new TreeViewer(composite, 2820);
        contentTypesViewer.getControl().setFont(composite.getFont());
        contentTypesViewer.setContentProvider((IContentProvider)new ContentTypesContentProvider());
        contentTypesViewer.setLabelProvider((IBaseLabelProvider)new ContentTypesLabelProvider());
        contentTypesViewer.setComparator(new ViewerComparator());
        contentTypesViewer.setInput((Object)Platform.getContentTypeManager());
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        contentTypesViewer.getControl().setLayoutData((Object)data);
        contentTypesViewer.addSelectionChangedListener(event -> {
            Text contentTypeText = this.contentTypeText;
            if (contentTypeText != null) {
                contentTypeText.setText(((IContentType)event.getStructuredSelection().getFirstElement()).toString());
            }
        });
    }

    private Text createText(Composite parent, String s) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText(s);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private @Nullable IStatus validatePage() {
        LanguageConfigurationInfoWidget infoWidget = this.infoWidget;
        assert (infoWidget != null);
        infoWidget.refresh(null);
        Text fileText = this.fileText;
        assert (fileText != null);
        String path = fileText.getText();
        if (path.length() == 0) {
            return new Status(4, "org.eclipse.tm4e.languageconfiguration", LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_fileError_noSelection);
        }
        Path p = new Path(path);
        if (!p.isAbsolute()) {
            p = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p).getLocation();
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileReader file = new FileReader(p.toFile());){
                LanguageConfiguration configuration = LanguageConfiguration.load(file);
                if (configuration == null) {
                    return new Status(4, "org.eclipse.tm4e.languageconfiguration", LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_fileError_invalid);
                }
                infoWidget.refresh(configuration);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.tm4e.languageconfiguration", String.valueOf(LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_fileError_error) + e.getLocalizedMessage());
        }
        Text contentTypeText = this.contentTypeText;
        if (contentTypeText == null || contentTypeText.getText().isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.languageconfiguration", LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_contentTypeError_noSelection);
        }
        IContentType contentType = ContentTypeHelper.getContentTypeById((String)contentTypeText.getText());
        if (contentType == null) {
            return new Status(4, "org.eclipse.tm4e.languageconfiguration", LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_contentTypeError_invalid);
        }
        if (this.registryManager.getLanguageConfigurationFor(contentType) != null) {
            return new Status(2, "org.eclipse.tm4e.languageconfiguration", LanguageConfigurationMessages.SelectLanguageConfigurationWizardPage_contentTypeWarning_duplicate);
        }
        return null;
    }

    ILanguageConfigurationDefinition getDefinition() {
        assert (this.fileText != null);
        Path path = new Path(this.fileText.getText());
        if (!path.isAbsolute()) {
            path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getLocation();
        }
        assert (this.contentTypeText != null);
        IContentType contentType = ContentTypeHelper.getContentTypeById((String)this.contentTypeText.getText());
        assert (contentType != null);
        return new LanguageConfigurationDefinition(contentType, path.toString());
    }

    private static final class ContentTypesContentProvider
    implements ITreeContentProvider {
        private IContentTypeManager manager = Platform.getContentTypeManager();

        private ContentTypesContentProvider() {
        }

        public Object[] getChildren(@Nullable Object parentElement) {
            ArrayList<IContentType> elements = new ArrayList<IContentType>();
            IContentType baseType = (IContentType)parentElement;
            IContentType[] iContentTypeArray = this.manager.getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType contentType = iContentTypeArray[n2];
                if (contentType.getBaseType() == null && baseType == null || contentType.getBaseType() != null && contentType.getBaseType().equals(baseType)) {
                    elements.add(contentType);
                }
                ++n2;
            }
            return elements.toArray();
        }

        public @Nullable Object getParent(@Nullable Object element) {
            if (element == null) {
                return null;
            }
            IContentType contentType = (IContentType)element;
            return contentType.getBaseType();
        }

        public boolean hasChildren(@Nullable Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(@Nullable Object inputElement) {
            return this.getChildren(null);
        }

        public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
            this.manager = newInput == null ? Platform.getContentTypeManager() : (IContentTypeManager)newInput;
        }
    }

    private static final class ContentTypesLabelProvider
    extends LabelProvider {
        private ContentTypesLabelProvider() {
        }

        public String getText(@Nullable Object element) {
            if (element == null) {
                return "";
            }
            IContentType contentType = (IContentType)element;
            return contentType.getName();
        }
    }
}

