/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.core.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.eclipse.wst.server.http.core.internal.HttpRuntime;
import org.eclipse.wst.server.http.core.internal.HttpServer;
import org.eclipse.wst.server.http.core.internal.Messages;
import org.eclipse.wst.server.http.core.internal.PingThread;
import org.eclipse.wst.server.http.core.internal.ProgressUtil;

public class HttpServerBehaviour
extends ServerBehaviourDelegate {
    protected transient PingThread ping = null;

    public void initialize(IProgressMonitor monitor) {
    }

    public HttpRuntime getHttpRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (HttpRuntime)((Object)this.getServer().getRuntime().loadAdapter(HttpRuntime.class, null));
    }

    public HttpServer getHttpServer() {
        return (HttpServer)((Object)this.getServer().getAdapter(HttpServer.class));
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (!this.getHttpServer().isPublishing()) {
            return;
        }
        String contextRoot = null;
        IModule module = moduleTree[moduleTree.length - 1];
        IStaticWeb sw = (IStaticWeb)module.loadAdapter(IStaticWeb.class, monitor);
        contextRoot = sw != null ? sw.getContextRoot() : module.getName();
        IPath to = this.getServer().getRuntime().getLocation();
        File temp = null;
        try {
            if (to.removeLastSegments(1).toFile().exists()) {
                temp = to.removeLastSegments(1).append("temp").toFile();
            }
        }
        catch (Exception exception) {}
        if (contextRoot != null && !contextRoot.equals("")) {
            to = to.append(contextRoot);
        }
        IModuleResource[] res = this.getResources(moduleTree);
        PublishHelper pubHelper = new PublishHelper(temp);
        IStatus[] status = pubHelper.publishSmart(res, to, monitor);
        if (temp.exists()) {
            temp.delete();
        }
        HttpServerBehaviour.throwException(status);
        this.setModulePublishState(moduleTree, 1);
    }

    private static void throwException(IStatus[] status) throws CoreException {
        if (status == null || status.length == 0) {
            return;
        }
        if (status.length == 1) {
            throw new CoreException(status[0]);
        }
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.http.core", 0, status, message, null);
        throw new CoreException((IStatus)status2);
    }

    public void restart(String launchMode) throws CoreException {
        this.setServerState(4);
        this.setServerState(2);
    }

    public void stop(boolean force) {
        this.setServerState(4);
    }

    public String toString() {
        return "HttpServer";
    }
}

