/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.tm4e.core.internal.rule.ICompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class IncludeOnlyRule
extends Rule {
    public final boolean hasMissingPatterns;
    public final Integer[] patterns;
    private RegExpSourceList cachedCompiledPatterns;

    public IncludeOnlyRule(int id, String name, String contentName, ICompilePatternsResult patterns) {
        super(id, name, contentName);
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
        this.cachedCompiledPatterns = null;
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        Integer[] integerArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Integer pattern = integerArray[n2];
            Rule rule = grammar.getRule(pattern);
            rule.collectPatternsRecursive(grammar, out, false);
            ++n2;
        }
    }

    @Override
    public ICompiledRule compile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        if (this.cachedCompiledPatterns == null) {
            this.cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, this.cachedCompiledPatterns, true);
        }
        return this.cachedCompiledPatterns.compile(grammar, allowA, allowG);
    }
}

