/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Transformer;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;

public class TransformationIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TransformationIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TransformationIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TransformationIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationIteratorTests.assertEquals((int)8, (int)i);
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationIteratorTests.assertEquals((int)8, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)((Integer)stream.next()));
        }
    }

    public void testInnerNext() {
        int i = 0;
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            TransformationIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)((Integer)stream.next()));
        }
    }

    public void testRemove() {
        Collection c = this.buildCollection();
        Iterator stream = this.buildInnerTransformationIterator(c.iterator());
        while (stream.hasNext()) {
            if ((Integer)stream.next() != 3) continue;
            stream.remove();
        }
        TransformationIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildCollection().size() - 1), (int)c.size());
        TransformationIteratorTests.assertFalse((String)"element still in collection", (boolean)c.contains("333"));
        TransformationIteratorTests.assertTrue((String)"wrong element removed", (boolean)c.contains("22"));
    }

    public void testInnerRemove() {
        Collection c = this.buildCollection();
        Iterator stream = this.buildTransformationIterator(c.iterator(), this.buildTransformer());
        while (stream.hasNext()) {
            if ((Integer)stream.next() != 3) continue;
            stream.remove();
        }
        TransformationIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildCollection().size() - 1), (int)c.size());
        TransformationIteratorTests.assertFalse((String)"element still in collection", (boolean)c.contains("333"));
        TransformationIteratorTests.assertTrue((String)"wrong element removed", (boolean)c.contains("22"));
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        Integer integer = null;
        while (stream.hasNext()) {
            integer = (Integer)stream.next();
        }
        try {
            integer = (Integer)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TransformationIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + integer), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator stream = this.buildUnmodifiableIterator();
        while (stream.hasNext()) {
            int i = (Integer)stream.next();
            if (i != 3) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        TransformationIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalStateException() {
        boolean exCaught = false;
        try {
            this.buildIterator().remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        TransformationIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    private Iterator buildIterator() {
        return this.buildTransformationIterator(this.buildNestedIterator(), this.buildTransformer());
    }

    private Iterator buildInnerIterator() {
        return this.buildInnerTransformationIterator(this.buildNestedIterator());
    }

    private Iterator buildUnmodifiableIterator() {
        return this.buildTransformationIterator(this.buildUnmodifiableNestedIterator(), this.buildTransformer());
    }

    private Iterator buildTransformationIterator(Iterator nestedIterator, Transformer transformer) {
        return new TransformationIterator(nestedIterator, transformer);
    }

    private Transformer buildTransformer() {
        return new Transformer(){

            public Object transform(Object next) {
                return new Integer(((String)next).length());
            }
        };
    }

    private Iterator buildInnerTransformationIterator(Iterator nestedIterator) {
        return new TransformationIterator(nestedIterator){

            protected Object transform(Object next) {
                return new Integer(((String)next).length());
            }
        };
    }

    private Iterator buildNestedIterator() {
        return this.buildCollection().iterator();
    }

    private Iterator buildUnmodifiableNestedIterator() {
        return this.buildUnmodifiableCollection().iterator();
    }

    private Collection buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    private Collection buildUnmodifiableCollection() {
        return Collections.unmodifiableCollection(this.buildCollection());
    }
}

