/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.NullIterator;

public class NullIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.NullIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.NullIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public NullIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = NullIterator.instance();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        NullIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNext() {
        Iterator stream = NullIterator.instance();
        while (stream.hasNext()) {
            NullIteratorTests.fail((String)("bogus element: " + stream.next()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = NullIterator.instance();
        Object element = null;
        while (stream.hasNext()) {
            element = stream.next();
        }
        try {
            element = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        NullIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        try {
            NullIterator.instance().remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        NullIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }
}

