/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.GraphIterator;
import org.eclipse.dali.utility.tests.TestTools;

public class GraphIteratorTests
extends TestCase {
    Collection nodes = new ArrayList();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.GraphIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.GraphIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public GraphIteratorTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext1() {
        this.verifyHasNext(this.buildGraphIterator1());
    }

    public void testHasNext2() {
        this.verifyHasNext(this.buildGraphIterator2());
    }

    private void verifyHasNext(Iterator iterator) {
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        GraphIteratorTests.assertEquals((int)this.nodes.size(), (int)i);
    }

    public void testNext1() {
        this.verifyNext(this.buildGraphIterator1());
    }

    public void testNext2() {
        this.verifyNext(this.buildGraphIterator2());
    }

    private void verifyNext(Iterator iterator) {
        while (iterator.hasNext()) {
            GraphIteratorTests.assertTrue((String)"bogus element", (boolean)this.nodes.contains(iterator.next()));
        }
    }

    public void testNoSuchElementException1() {
        this.verifyNoSuchElementException(this.buildGraphIterator1());
    }

    public void testNoSuchElementException2() {
        this.verifyNoSuchElementException(this.buildGraphIterator2());
    }

    private void verifyNoSuchElementException(Iterator iterator) {
        boolean exCaught = false;
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        GraphIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    public void testSize1() {
        this.verifySize(this.buildGraphIterator1());
    }

    public void testSize2() {
        this.verifySize(this.buildGraphIterator2());
    }

    private void verifySize(Iterator iterator) {
        int actualSize;
        int iteratorSize = CollectionTools.size((Iterator)iterator);
        GraphIteratorTests.assertTrue((String)"Too few items in iterator.", (iteratorSize >= (actualSize = this.nodes.size()) ? 1 : 0) != 0);
        GraphIteratorTests.assertTrue((String)"Too many items in iterator.", (iteratorSize <= actualSize ? 1 : 0) != 0);
    }

    private Iterator buildGraphIterator1() {
        return new GraphIterator(this.buildGraph(), this.buildMisterRogers());
    }

    private GraphIterator.MisterRogers buildMisterRogers() {
        return new GraphIterator.MisterRogers(){

            public Iterator neighbors(Object next) {
                return ((GraphNode)next).neighbors();
            }
        };
    }

    private Iterator buildGraphIterator2() {
        return new GraphIterator(this.buildGraph()){

            public Iterator neighbors(Object next) {
                return ((GraphNode)next).neighbors();
            }
        };
    }

    private Object buildGraph() {
        GraphNode ncNode = new GraphNode("North Carolina");
        GraphNode vaNode = new GraphNode("Virginia");
        GraphNode scNode = new GraphNode("South Carolina");
        GraphNode gaNode = new GraphNode("Georgia");
        GraphNode flNode = new GraphNode("Florida");
        GraphNode alNode = new GraphNode("Alabama");
        GraphNode msNode = new GraphNode("Mississippi");
        GraphNode tnNode = new GraphNode("Tennessee");
        ncNode.setNeighbors(new Object[]{vaNode, scNode, gaNode, tnNode});
        vaNode.setNeighbors(new Object[]{ncNode, tnNode});
        scNode.setNeighbors(new Object[]{ncNode, gaNode});
        gaNode.setNeighbors(new Object[]{ncNode, scNode, flNode, alNode, tnNode});
        flNode.setNeighbors(new Object[]{gaNode});
        alNode.setNeighbors(new Object[]{gaNode, msNode, tnNode});
        msNode.setNeighbors(new Object[]{alNode, tnNode});
        tnNode.setNeighbors(new Object[]{vaNode, ncNode, gaNode, alNode, msNode});
        return ncNode;
    }

    private class GraphNode {
        private String name;
        private Collection neighbors = new ArrayList();

        public GraphNode(String name) {
            GraphIteratorTests.this.nodes.add(this);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setNeighbors(Object[] neighbors) {
            this.neighbors = CollectionTools.list((Object[])neighbors);
        }

        public Iterator neighbors() {
            return this.neighbors.iterator();
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }

        public String toString() {
            return "GraphNode(" + this.name + ")";
        }
    }
}

