/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.junitx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.ComparisonFailure;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Flags;
import org.eclipse.test.performance.PerformanceTestCase;

public class TestCase
extends PerformanceTestCase {
    public static String TESTS_PREFIX = null;
    public static String[] TESTS_NAMES = null;
    public static int[] TESTS_NUMBERS = null;
    public static int[] TESTS_RANGE = null;
    static /* synthetic */ Class class$0;

    public TestCase(String name) {
        this.setName(name);
    }

    public static void assertEquals(String expected, String actual) {
        TestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        String formatted = message != null ? String.valueOf(message) + "." : "";
        String expectedWithLineSeparators = expected == null ? null : TestCase.showLineSeparators(expected);
        String actualWithLineSeparators = actual == null ? null : TestCase.showLineSeparators(actual);
        throw new ComparisonFailure(String.valueOf(formatted) + "\n----------- Expected ------------\n" + expectedWithLineSeparators + "\n------------ but was ------------\n" + actualWithLineSeparators + "\n--------- Difference is ----------\n", expectedWithLineSeparators, actualWithLineSeparators);
    }

    protected static String showLineSeparators(String string) {
        StringBuffer buffer = new StringBuffer();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char car = string.charAt(i);
            switch (car) {
                case '\n': {
                    buffer.append("\\n\n");
                    break;
                }
                case '\r': {
                    if (i < length - 1 && string.charAt(i + 1) == '\n') {
                        buffer.append("\\r\\n\n");
                        ++i;
                        break;
                    }
                    buffer.append("\\r\n");
                    break;
                }
                default: {
                    buffer.append(car);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static List buildTestsList(Class evaluationTestClass) {
        return TestCase.buildTestsList(evaluationTestClass, 0);
    }

    public static List buildTestsList(Class evaluationTestClass, int inheritedDepth) {
        ArrayList tests = new ArrayList();
        HashSet<String> testNames = new HashSet<String>();
        Constructor constructor = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] paramTypes = classArray;
            constructor = evaluationTestClass.getConstructor(paramTypes);
        }
        catch (Exception exception) {
            return tests;
        }
        Method[] methods = evaluationTestClass.getDeclaredMethods();
        Class evaluationTestSuperclass = evaluationTestClass.getSuperclass();
        int i = 0;
        while (i < inheritedDepth && !Flags.isAbstract((int)evaluationTestSuperclass.getModifiers())) {
            Method[] superMethods = evaluationTestSuperclass.getDeclaredMethods();
            Method[] mergedMethods = new Method[methods.length + superMethods.length];
            System.arraycopy(superMethods, 0, mergedMethods, 0, superMethods.length);
            System.arraycopy(methods, 0, mergedMethods, superMethods.length, methods.length);
            methods = mergedMethods;
            evaluationTestSuperclass = evaluationTestSuperclass.getSuperclass();
            ++i;
        }
        int m = 0;
        int max = methods.length;
        while (m < max) {
            block27: {
                try {
                    Object[] params;
                    String methName;
                    block28: {
                        int length;
                        int numStart;
                        int modifiers = methods[m].getModifiers();
                        if (!Flags.isPublic((int)modifiers) || Flags.isStatic((int)modifiers) || !methods[m].getName().startsWith("test")) break block27;
                        methName = methods[m].getName();
                        params = new Object[]{methName};
                        if (TESTS_PREFIX == null && TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null) {
                            if (testNames.add(methName)) {
                                tests.add(constructor.newInstance(params));
                            }
                            break block27;
                        }
                        if (TESTS_PREFIX != null && !methName.startsWith(TESTS_PREFIX)) break block27;
                        int n = numStart = TESTS_PREFIX == null ? 4 : TESTS_PREFIX.length();
                        if (TESTS_NAMES != null) {
                            int i2 = 0;
                            int imax = TESTS_NAMES.length;
                            while (i2 < imax) {
                                if (methName.indexOf(TESTS_NAMES[i2]) >= 0) {
                                    if (testNames.add(methName)) {
                                        tests.add(constructor.newInstance(params));
                                    }
                                    break block27;
                                }
                                ++i2;
                            }
                        }
                        if (numStart < (length = methName.length())) {
                            while (numStart < length && !Character.isDigit(methName.charAt(numStart))) {
                                ++numStart;
                            }
                            while (numStart < length && methName.charAt(numStart) == '0') {
                                ++numStart;
                            }
                            int n2 = numStart;
                            while (n2 < length && Character.isDigit(methName.charAt(n2))) {
                                ++n2;
                            }
                            if (n2 > numStart && n2 <= length) {
                                try {
                                    int num = Integer.parseInt(methName.substring(numStart, n2));
                                    if (TESTS_NUMBERS != null && !tests.contains(methName)) {
                                        int i3 = 0;
                                        while (i3 < TESTS_NUMBERS.length) {
                                            if (TESTS_NUMBERS[i3] == num) {
                                                testNames.add(methName);
                                                tests.add(constructor.newInstance(params));
                                                break block27;
                                            }
                                            ++i3;
                                        }
                                    }
                                    if (TESTS_RANGE == null || TESTS_RANGE.length != 2 || tests.contains(methName) || TESTS_RANGE[0] != -1 && num < TESTS_RANGE[0] || TESTS_RANGE[1] != -1 && num > TESTS_RANGE[1]) break block28;
                                    testNames.add(methName);
                                    tests.add(constructor.newInstance(params));
                                    break block27;
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Method " + methods[m] + " has an invalid number format: " + e.getMessage());
                                }
                            }
                        }
                    }
                    if (TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null && testNames.add(methName)) {
                        tests.add(constructor.newInstance(params));
                    }
                }
                catch (Exception e) {
                    System.out.println("Method " + methods[m] + " removed from suite due to exception: " + e.getMessage());
                }
            }
            ++m;
        }
        return tests;
    }

    public void startMeasuring() {
        super.startMeasuring();
    }

    public void stopMeasuring() {
        super.stopMeasuring();
    }

    public void assertPerformance() {
        super.assertPerformance();
    }

    public void commitMeasurements() {
        super.commitMeasurements();
    }

    public void waitForJobs() {
        while (Platform.getJobManager().currentJob() != null) {
        }
    }
}

