/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.DiscriminatorColumn;
import org.eclipse.dali.orm.DiscriminatorType;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IntAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEntityModelAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaDiscriminatorColumnModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaDiscriminatorColumnModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaDiscriminatorColumnModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private JavaEntityModelAdapter getEntityModelAdapter() {
        return (JavaEntityModelAdapter)this.testClassType.getTypeMapping().getModelAdapter();
    }

    private JavaDiscriminatorColumnModelAdapter getDiscriminatorColumnModelAdapter() {
        return (JavaDiscriminatorColumnModelAdapter)this.getDiscriminatorColumn().getModelAdapter();
    }

    private DiscriminatorColumn getDiscriminatorColumn() {
        return ((Entity)this.testClassType.getTypeMapping()).getInheritance().getDiscriminatorColumn();
    }

    public void testSetDiscriminatorColumnTypeInJavaUpdatesPersistenceModel() {
        EnumAnnotationElementAdapter adapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorColumnModelAdapter(), (String)"discriminatorTypeAdapter");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((Object)DiscriminatorType.DEFAULT_LITERAL, (Object)this.getDiscriminatorColumn().getDiscriminatorType());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"INTEGER");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((Object)DiscriminatorType.INTEGER_LITERAL, (Object)this.getDiscriminatorColumn().getDiscriminatorType());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz2, (Object)"CHAR");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((Object)DiscriminatorType.CHAR_LITERAL, (Object)this.getDiscriminatorColumn().getDiscriminatorType());
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz3, (Object)"STRING");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((Object)DiscriminatorType.STRING_LITERAL, (Object)this.getDiscriminatorColumn().getDiscriminatorType());
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz4, (Object)"Default");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((Object)DiscriminatorType.DEFAULT_LITERAL, (Object)this.getDiscriminatorColumn().getDiscriminatorType());
    }

    public void testSetDiscriminatorColumnTypeInPersistenceModelUpdatesJava() {
        DiscriminatorColumn discriminatorColumn = this.getDiscriminatorColumn();
        EnumAnnotationElementAdapter adapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorColumnModelAdapter(), (String)"discriminatorTypeAdapter");
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.STRING_LITERAL);
        CompilationUnit astRoot = type.createASTRoot();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"STRING", (String)javaValue);
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.INTEGER_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"INTEGER", (String)javaValue);
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.CHAR_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz3, (Object)astRoot);
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"CHAR", (String)javaValue);
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.DEFAULT_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz4, (Object)astRoot);
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"Default", (String)javaValue);
    }

    public void testSetDiscriminatorColumnNameInJavaUpdatesPersistenceModel() {
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorColumnModelAdapter(), (String)"discriminatorColumnSpecifiedNameAdapter");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals(null, (String)this.getDiscriminatorColumn().getSpecifiedName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DTYPE", (String)this.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DTYPE", (String)this.getDiscriminatorColumn().getName());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"DISCRIMINATOR_TYPE");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DISCRIMINATOR_TYPE", (String)this.getDiscriminatorColumn().getSpecifiedName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DTYPE", (String)this.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DISCRIMINATOR_TYPE", (String)this.getDiscriminatorColumn().getName());
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"removeAnnotationElement", (Class)clazz2, (Object)type.createASTRoot());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals(null, (String)this.getDiscriminatorColumn().getSpecifiedName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DTYPE", (String)this.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"DTYPE", (String)this.getDiscriminatorColumn().getName());
    }

    public void testSetDiscriminatorColumnDefinitionInJavaUpdatesPersistenceModel() {
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorColumnModelAdapter(), (String)"discriminatorColumnDefinitionAdapter");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals(null, (String)this.getDiscriminatorColumn().getColumnDefinition());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"here's some sql for creating the column");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"here's some sql for creating the column", (String)this.getDiscriminatorColumn().getColumnDefinition());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz2, (Object)"");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((String)"", (String)this.getDiscriminatorColumn().getColumnDefinition());
    }

    public void testSetDiscriminatorColumnLengthInJavaUpdatesPersistenceModel() {
        IntAnnotationElementAdapter adapter = (IntAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorColumnModelAdapter(), (String)"discriminatorColumnLengthAdapter");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((int)31, (int)this.getDiscriminatorColumn().getLength());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"20");
        JavaDiscriminatorColumnModelAdapterTests.assertEquals((int)20, (int)this.getDiscriminatorColumn().getLength());
    }
}

