/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorDelegateDescriptor {
    private IConfigurationElement _delegateConfiguration;
    private String _delegatingValidatorID;
    private String _id;
    private String _name;

    public ValidatorDelegateDescriptor(String id, IConfigurationElement delegateConfiguration, String delegateName, String targetValidatorID) {
        assert (id != null);
        assert (delegateConfiguration != null);
        assert (targetValidatorID != null);
        this._id = id;
        this._delegateConfiguration = delegateConfiguration;
        this._name = delegateName;
        this._delegatingValidatorID = targetValidatorID;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getTargetID() {
        return this._delegatingValidatorID;
    }

    public IValidator getValidator() throws ValidationException {
        try {
            IValidator delegate = (IValidator)this._delegateConfiguration.createExecutableExtension("class");
            return delegate;
        }
        catch (CoreException e) {
            this.handleException(e);
            return null;
        }
    }

    public AbstractValidator getValidator2() throws ValidationException {
        try {
            Object o = this._delegateConfiguration.createExecutableExtension("class");
            if (o instanceof AbstractValidator) {
                return (AbstractValidator)o;
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return null;
    }

    private void handleException(CoreException e) throws ValidationException {
        ValidationPlugin.getPlugin().handleException(e);
        String delegatingValidatorName = this.getTargetID();
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(this.getTargetID());
        if (vmd != null) {
            delegatingValidatorName = vmd.getValidatorDisplayName();
        }
        throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_CANNOT_INSTANTIATE_DELEGATE", new String[]{this.getName(), delegatingValidatorName})));
    }
}

