/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;

public class DelegatingValidatorPreferencesDialog
extends Dialog {
    private ValidatorMetaData delegatingValidatorDescriptor;
    private String delegateID;

    public DelegatingValidatorPreferencesDialog(Shell parentShell, ValidatorMetaData vmd, String delegateID) {
        super(parentShell);
        this.delegatingValidatorDescriptor = vmd;
        this.delegateID = delegateID;
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.getShell().setText(ValUIMessages.DelegatesDialogTitle);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.widthHint = 250;
        label.setLayoutData((Object)labelData);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        String delegatingValidatorName = this.delegatingValidatorDescriptor.getValidatorDisplayName();
        label.setText(delegatingValidatorName);
        Label separator = new Label(parent, 258);
        GridData separatorData = new GridData(4, 0x1000000, true, false);
        separator.setLayoutData((Object)separatorData);
        Composite group = new Composite(parent, 0);
        GridData groupGridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)groupGridData);
        GridLayout groupLayout = new GridLayout(2, false);
        group.setLayout((Layout)groupLayout);
        Label comboLabel = new Label(group, 0);
        comboLabel.setLayoutData((Object)new GridData());
        comboLabel.setText(ValUIMessages.DelegatesComboLabel);
        Combo combo = new Combo(group, 8);
        GridData comboGridData = new GridData(4, 0x1000000, true, false);
        combo.setLayoutData((Object)comboGridData);
        final ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)new DelegatesContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new DelegatesLabelProvider());
        String targetID = this.delegatingValidatorDescriptor.getValidatorUniqueName();
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
                DelegatingValidatorPreferencesDialog.this.setDelegateID(((ValidatorDelegateDescriptor)selection.getFirstElement()).getId());
            }
        });
        comboViewer.setInput((Object)targetID);
        ValidatorDelegateDescriptor selected = ValidatorDelegatesRegistry.getInstance().getDescriptor(targetID, this.delegateID);
        if (selected != null) {
            comboViewer.setSelection((ISelection)new StructuredSelection(new Object[]{selected}));
        }
        Label endSeparator = new Label(parent, 258);
        GridData endSeparatorData = new GridData(4, 0x1000000, true, false);
        endSeparator.setLayoutData((Object)endSeparatorData);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public String getDelegateID() {
        return this.delegateID;
    }

    private void setDelegateID(String delegateID) {
        this.delegateID = delegateID;
    }

    private final class DelegatesContentProvider
    implements IStructuredContentProvider {
        private DelegatesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            String targetID = (String)inputElement;
            Map delegatesByID = ValidatorDelegatesRegistry.getInstance().getDelegateDescriptors(targetID);
            if (delegatesByID == null) {
                return new Object[0];
            }
            return delegatesByID.values().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class DelegatesLabelProvider
    implements ILabelProvider {
        private DelegatesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((ValidatorDelegateDescriptor)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

