/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.EvaluationManager;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.StepIntoSelectionActionDelegate;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.StepIntoSelectionUtils;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public class JavaScriptHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (editor != null) {
            IJavaScriptStackFrame frame = EvaluationManager.getManager().getEvaluationContext(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            if (frame == null) {
                return null;
            }
            IEditorInput input = editor.getEditorInput();
            IJavaScriptElement element = StepIntoSelectionUtils.getJavaElement(input);
            int offset = region.getOffset();
            if (element != null) {
                try {
                    IFunction method;
                    IRegion wregion;
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    if (document != null && (wregion = JavaWordFinder.findWord((IDocument)document, (int)offset)) != null && (method = StepIntoSelectionUtils.getFunction((ITextSelection)new TextSelection(document, wregion.getOffset(), wregion.getLength()), element)) != null) {
                        return new IHyperlink[]{new StepIntoSelectionHyperlink(wregion)};
                    }
                }
                catch (JavaScriptModelException jme) {
                    JavaScriptDebugUIPlugin.log(jme);
                }
            }
        }
        return null;
    }

    class StepIntoSelectionHyperlink
    implements IHyperlink {
        private IRegion fRegion = null;

        public StepIntoSelectionHyperlink(IRegion region) {
            this.fRegion = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            return Messages.hyperlink_step_into;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            StepIntoSelectionActionDelegate delegate = new StepIntoSelectionActionDelegate(this.fRegion);
            delegate.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            delegate.run(null);
        }
    }
}

