/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.uibuilder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ease.modules.platform.uibuilder.DialogRunnable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScriptableDialog
extends TitleAreaDialog {
    private Composite fContainer;
    private final DialogRunnable fRunnableOnCreation;
    private final Map<Object, Object> fData = new HashMap<Object, Object>();
    private final Map<Control, StructuredViewer> fViewers = new HashMap<Control, StructuredViewer>();
    private String fMessageText = null;
    private String fTitleText = null;
    private Point fInitialSize = new Point(450, 450);

    public ScriptableDialog(Shell parentShell, DialogRunnable runnableOnCreation) {
        super(parentShell);
        this.fRunnableOnCreation = runnableOnCreation;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fContainer = new Composite(area, 0);
        this.fContainer.setLayoutData((Object)new GridData(1808));
        if (this.fTitleText != null) {
            this.setTitle(this.fTitleText);
        }
        if (this.fMessageText != null) {
            this.setMessage(this.fMessageText);
        }
        this.fRunnableOnCreation.setComposite(this.fContainer);
        this.fRunnableOnCreation.setDialog(this);
        this.fRunnableOnCreation.run();
        return area;
    }

    public Composite getContainer() {
        return this.fContainer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return this.fInitialSize;
    }

    public void setInitialSize(int x, int y) {
        this.fInitialSize = new Point(x, y);
    }

    protected void okPressed() {
        this.storeChildren(this.fContainer);
        super.okPressed();
    }

    private void storeChildren(Composite container) {
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            StructuredViewer viewer;
            Control child = controlArray[n2];
            if (child instanceof Text) {
                this.fData.put(child, ((Text)child).getText());
            } else if (child instanceof Button) {
                this.fData.put(child, ((Button)child).getSelection());
            } else if (child instanceof Combo) {
                viewer = this.fViewers.get(child);
                if (viewer != null) {
                    this.fData.put(viewer, viewer.getStructuredSelection().getFirstElement());
                }
            } else if (child instanceof List) {
                viewer = this.fViewers.get(child);
                if (viewer != null) {
                    this.fData.put(viewer, viewer.getStructuredSelection().toArray());
                }
            } else if (child instanceof Composite) {
                this.storeChildren((Composite)child);
            }
            ++n2;
        }
    }

    public Object getData(Object control) {
        return this.fData.get(control);
    }

    public void setMessageText(String messageText) {
        this.fMessageText = messageText;
    }

    public void setTitleText(String titleText) {
        this.fTitleText = titleText;
    }

    public void registerViewer(Control control, StructuredViewer viewer) {
        this.fViewers.put(control, viewer);
    }
}

