/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.UIModelManipulator;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.view.ScriptShell;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.FileEditorInput;

public class UIModule
extends AbstractScriptModule {
    public static final String MODULE_ID = "/System/UI";

    @WrapToScript
    public Object executeUI(Object code) throws ExecutionException {
        return this.getEnvironment().getScriptEngine().inject(code, true);
    }

    @WrapToScript
    public static boolean isUIThread() {
        return Thread.currentThread().equals(Display.getDefault().getThread());
    }

    @WrapToScript(alias="showMessageDialog")
    public void showInfoDialog(String message, @ScriptParameter(defaultValue="Info") String title) {
        if (UIModule.isHeadless()) {
            this.getEnvironment().print((Object)("INFO: " + message), true);
        } else {
            Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message));
        }
    }

    @WrapToScript
    public boolean showQuestionDialog(final String message, final @ScriptParameter(defaultValue="Question") String title) {
        if (UIModule.isHeadless()) {
            try {
                this.getEnvironment().print((Object)(String.valueOf(message) + " [Y/n])"), false);
                int character = this.getScriptEngine().getInputStream().read();
                return Character.toLowerCase(character) != 110;
            }
            catch (IOException e) {
                return false;
            }
        }
        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

            public Boolean runWithTry() throws Throwable {
                return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Boolean)runnable.getResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WrapToScript
    public String showInputDialog(final String message, final @ScriptParameter(defaultValue="") String initialValue, final @ScriptParameter(defaultValue="Information request") String title) {
        if (!UIModule.isHeadless()) {
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public String runWithTry() throws Throwable {
                    InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), title, message, initialValue, null);
                    if (dialog.open() == 0) {
                        return dialog.getValue();
                    }
                    return null;
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        try {
            this.getEnvironment().print((Object)message, initialValue == null);
            if (initialValue != null) {
                this.getEnvironment().print((Object)("[" + initialValue + "]"), true);
            }
            StringBuilder result = new StringBuilder();
            while (true) {
                int character;
                if ((character = this.getScriptEngine().getInputStream().read()) == -1) {
                    return null;
                }
                if (Character.toLowerCase(character) == 10) {
                    return result.toString();
                }
                result.append((char)character);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WrapToScript
    public Object showSelectionDialog(final Object[] elements, final @ScriptParameter(defaultValue="") String message, final @ScriptParameter(defaultValue="Selection request") String title) {
        StringBuilder result;
        if (!UIModule.isHeadless()) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public Object runWithTry() throws Throwable {
                    Object[] result;
                    ListDialog selectionDialog = new ListDialog(Display.getDefault().getActiveShell());
                    selectionDialog.setTitle(title);
                    selectionDialog.setMessage(message);
                    selectionDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    selectionDialog.setLabelProvider((ILabelProvider)new LabelProvider());
                    selectionDialog.setInput((Object)elements);
                    if (selectionDialog.open() == 0 && (result = selectionDialog.getResult()) != null && result.length > 0) {
                        return result[0];
                    }
                    return null;
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResult();
        }
        try {
            this.getEnvironment().print((Object)(String.valueOf(message) + "\n"), true);
            int index = 0;
            while (true) {
                if (index >= elements.length) {
                    result = new StringBuilder();
                    break;
                }
                this.getEnvironment().print((Object)("\t[" + index + "] " + elements[index].toString()), true);
                ++index;
            }
        }
        catch (IOException e) {
            return null;
        }
        int character;
        while ((character = this.getScriptEngine().getInputStream().read()) != -1) {
            if (Character.toLowerCase(character) == 10) {
                try {
                    int index = Integer.parseInt(result.toString().trim());
                    if (elements.length <= index) return null;
                    if (index < 0) return null;
                    return elements[index];
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return null;
            }
            result.append((char)character);
        }
        return null;
    }

    @WrapToScript
    public boolean showConfirmDialog(final String message, final @ScriptParameter(defaultValue="Confirmation") String title) {
        if (UIModule.isHeadless()) {
            return this.showQuestionDialog(message, title);
        }
        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

            public Boolean runWithTry() throws Throwable {
                return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Boolean)runnable.getResult();
    }

    @WrapToScript
    public void showWarningDialog(String message, @ScriptParameter(defaultValue="Warning") String title) {
        if (UIModule.isHeadless()) {
            this.getEnvironment().print((Object)("WARNING: " + message), true);
        } else {
            Display.getDefault().syncExec(() -> MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message));
        }
    }

    @WrapToScript
    public void showErrorDialog(String message, @ScriptParameter(defaultValue="Error") String title) {
        if (UIModule.isHeadless()) {
            this.getEnvironment().print((Object)("ERROR: " + message), true);
        } else {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message));
        }
    }

    @WrapToScript
    public static void exitApplication() {
        Display.getDefault().asyncExec(() -> {
            boolean bl = PlatformUI.getWorkbench().close();
        });
    }

    public static IViewPart showView(String name) throws Throwable {
        return UIModule.showView(name, null, 1);
    }

    @WrapToScript(alias="openView")
    public static IViewPart showView(String name, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String secondaryId, final @ScriptParameter(defaultValue="1") int mode) throws Throwable {
        final String viewID = UIModelManipulator.getIDForName(name);
        if (viewID != null) {
            RunnableWithResult<IViewPart> runnable = new RunnableWithResult<IViewPart>(){

                public IViewPart runWithTry() throws Throwable {
                    try {
                        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID, secondaryId, mode);
                    }
                    catch (NullPointerException e) {
                        if (PlatformUI.getWorkbench().getWorkbenchWindowCount() > 0) {
                            return PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView(viewID, secondaryId, mode);
                        }
                        return null;
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (IViewPart)runnable.getResultOrThrow();
        }
        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0].getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference part = iViewReferenceArray[n2];
            if (part.getTitle().equals(name)) {
                return part.getView(false);
            }
            ++n2;
        }
        return null;
    }

    @WrapToScript(alias="openEditor")
    public IEditorPart showEditor(Object location) throws Throwable {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IFile) {
            return UIModule.showEditor((IFile)file);
        }
        return null;
    }

    public static IEditorPart showEditor(final IFile file) throws Throwable {
        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (descriptor != null) {
            final IEditorDescriptor editorDescriptor = descriptor;
            RunnableWithResult<IEditorPart> runnable = new RunnableWithResult<IEditorPart>(){

                public IEditorPart runWithTry() throws Throwable {
                    try {
                        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
                    }
                    catch (NullPointerException e) {
                        if (PlatformUI.getWorkbench().getWorkbenchWindowCount() > 0) {
                            return PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
                        }
                        return null;
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (IEditorPart)runnable.getResultOrThrow();
        }
        return null;
    }

    @WrapToScript
    public static ISelection getSelection(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String name) {
        final ISelectionService selectionService = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getSelectionService();
        if (name != null && !name.isEmpty()) {
            String partID = UIModelManipulator.getIDForName(name);
            if (partID != null) {
                return selectionService.getSelection(partID);
            }
            return null;
        }
        RunnableWithResult<ISelection> runnable = new RunnableWithResult<ISelection>(){

            public ISelection runWithTry() throws Throwable {
                return selectionService.getSelection();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (ISelection)runnable.getResult();
    }

    @WrapToScript
    public static Object convertSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toArray();
        }
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText();
        }
        return null;
    }

    @WrapToScript
    public static int openDialog(final Window dialog) throws Throwable {
        RunnableWithResult<Integer> run = new RunnableWithResult<Integer>(){

            public Integer runWithTry() throws Throwable {
                return dialog.open();
            }
        };
        Display.getDefault().syncExec((Runnable)run);
        return (Integer)run.getResultOrThrow();
    }

    @WrapToScript
    public static Shell getShell() {
        RunnableWithResult<Shell> runnable = new RunnableWithResult<Shell>(){

            public Shell runWithTry() throws Throwable {
                return Display.getCurrent().getActiveShell();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Shell)runnable.getResult();
    }

    @WrapToScript
    public static IWorkbenchPart getActiveView() {
        RunnableWithResult<IWorkbenchPart> runnable = new RunnableWithResult<IWorkbenchPart>(){

            public IWorkbenchPart runWithTry() throws Throwable {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (IWorkbenchPart)runnable.getResult();
    }

    @WrapToScript
    public void renameScriptShell(String newName) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof ScriptShell) {
                ((ScriptShell)part).changePartName(newName);
            } else {
                IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                ScriptShell renamingScriptShell = null;
                IViewReference[] iViewReferenceArray = viewReferences;
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    if ("org.eclipse.ease.ui.views.scriptShell".equals(viewReference.getId())) {
                        if (renamingScriptShell != null) {
                            Logger.error((String)MODULE_ID, (String)"Detected more than one script shell, no renaming can be performed");
                            return;
                        }
                        renamingScriptShell = (ScriptShell)viewReference.getView(true);
                    }
                    ++n2;
                }
                if (renamingScriptShell != null) {
                    renamingScriptShell.changePartName(newName);
                }
            }
        });
    }

    @WrapToScript
    public static IEditorPart getActiveEditor() {
        RunnableWithResult<IEditorPart> runnable = new RunnableWithResult<IEditorPart>(){

            public IEditorPart runWithTry() throws Throwable {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (IEditorPart)runnable.getResult();
    }

    @WrapToScript
    public static void setClipboard(String data) {
        Runnable runnable = () -> {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
        };
        Display.getDefault().syncExec(runnable);
    }

    @WrapToScript
    public static Object getClipboard() {
        RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

            public Object runWithTry() throws Throwable {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                return clipboard.getContents((Transfer)TextTransfer.getInstance());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    @WrapToScript
    public void clearConsole() {
        ScriptConsole console = this.getConsole();
        if (console != null) {
            console.clearConsole();
        }
    }

    @WrapToScript
    public ScriptConsole getConsole() {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof ScriptConsole) {
                InputStream engineInput = this.getScriptEngine().getInputStream();
                IOConsoleInputStream consoleInput = ((ScriptConsole)console).getInputStream();
                if (consoleInput != null && consoleInput.equals(engineInput)) {
                    return (ScriptConsole)console;
                }
            }
            ++n2;
        }
        return null;
    }

    @WrapToScript
    public static void maximizeView(String name) throws Throwable {
        IViewPart view = UIModule.showView(name);
        if (view != null) {
            ActionFactory.MAXIMIZE.create(view.getViewSite().getWorkbenchWindow()).run();
        }
    }

    @WrapToScript
    public static void minimizeView(String name) throws Throwable {
        IViewPart view = UIModule.showView(name);
        if (view != null) {
            ActionFactory.MINIMIZE.create(view.getViewSite().getWorkbenchWindow()).run();
        }
    }

    @WrapToScript
    public static void closeView(String name, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String secondaryID) {
        String viewID = UIModelManipulator.getIDForName(name);
        Runnable runnable = () -> {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewReference[] iViewReferenceArray = activePage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference part = iViewReferenceArray[n2];
                if (part.getId().equals(viewID) && (secondaryID == null || secondaryID.equals(part.getSecondaryId()))) {
                    activePage.hideView(part);
                    return;
                }
                ++n2;
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    @WrapToScript
    public static void shutdown() {
        Display.getDefault().asyncExec(() -> {
            boolean bl = PlatformUI.getWorkbench().close();
        });
    }

    @WrapToScript
    public static boolean isHeadless() {
        return !PlatformUI.isWorkbenchRunning();
    }

    @WrapToScript
    public static Color createColor(int red, int green, int blue) {
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    @WrapToScript
    public static void moveView(String sourceView, String relativeTo, @ScriptParameter(defaultValue="x") String position) {
        String sourceId = UIModelManipulator.getIDForName(sourceView);
        if (sourceId == null) {
            throw new IllegalArgumentException("Cannot find view: " + sourceView);
        }
        String targetId = UIModelManipulator.getIDForName(relativeTo);
        if (targetId == null) {
            throw new IllegalArgumentException("Cannot find view: " + relativeTo);
        }
        Display.getDefault().syncExec(() -> {
            MUIElement sourcePlaceholder = UIModelManipulator.findElement(sourceId);
            MUIElement targetPlaceholder = UIModelManipulator.findElement(targetId);
            MElementContainer targetPartStack = targetPlaceholder.getParent();
            switch (position) {
                case "<": {
                    MPartSashContainer sashContainer = UIModelManipulator.splitPartStack((MElementContainer<MUIElement>)targetPartStack, 131072);
                    UIModelManipulator.move(sourcePlaceholder, (MElementContainer<MUIElement>)((MElementContainer)sashContainer.getChildren().get(0)));
                    break;
                }
                case ">": {
                    MPartSashContainer sashContainer = UIModelManipulator.splitPartStack((MElementContainer<MUIElement>)targetPartStack, 16384);
                    UIModelManipulator.move(sourcePlaceholder, (MElementContainer<MUIElement>)((MElementContainer)sashContainer.getChildren().get(1)));
                    break;
                }
                case "^": {
                    MPartSashContainer sashContainer = UIModelManipulator.splitPartStack((MElementContainer<MUIElement>)targetPartStack, 1024);
                    UIModelManipulator.move(sourcePlaceholder, (MElementContainer<MUIElement>)((MElementContainer)sashContainer.getChildren().get(0)));
                    break;
                }
                case "v": {
                    MPartSashContainer sashContainer = UIModelManipulator.splitPartStack((MElementContainer<MUIElement>)targetPartStack, 128);
                    UIModelManipulator.move(sourcePlaceholder, (MElementContainer<MUIElement>)((MElementContainer)sashContainer.getChildren().get(1)));
                    break;
                }
                case "o": 
                case "x": {
                    UIModelManipulator.move(sourcePlaceholder, (MElementContainer<MUIElement>)targetPlaceholder.getParent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid position indicator: " + position);
                }
            }
        });
    }
}

