/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.Activator;

public class HelpHoverImageProvider {
    private static final Map<String, String> CACHED_IMAGES = new HashMap<String, String>();

    public static String getImageLocation(String bundlePath) {
        InputStream input;
        if (!CACHED_IMAGES.containsKey(bundlePath) && (input = Activator.getResource(bundlePath)) != null) {
            try {
                File tempFile = File.createTempFile("EASE_image", "png");
                tempFile.deleteOnExit();
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                BufferedInputStream inputStream = new BufferedInputStream(input);
                byte[] buffer = new byte[1024];
                int bytes = ((InputStream)inputStream).read(buffer);
                while (bytes != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytes);
                    bytes = ((InputStream)inputStream).read(buffer);
                }
                ((InputStream)inputStream).close();
                ((OutputStream)outputStream).close();
                CACHED_IMAGES.put(bundlePath, tempFile.toURI().toString());
            }
            catch (FileNotFoundException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot find image file for help hover", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot create image file for help hover", (Throwable)e);
                return null;
            }
        }
        return CACHED_IMAGES.get(bundlePath);
    }
}

