QEMU=/tmp/allinoneqemu_linux.$$
DIR="$(dirname $0)"

[ -n "$DIR" ] && cd "$DIR"

cp allinoneqemu_linux $QEMU
chmod +x $QEMU
trap "rm -f $QEMU" 0

[ "$(which qemu 2> /dev/null)" ] && {
  QEMU="$(which qemu)"

  echo Using $QEMU... 1>&2
}

$QEMU -kernel vmlinuz -initrd initrd.gz -append root=/dev/ram0 -hda pup_save.3fs -hdb pup_217.sfs -hdc devx_217.sfs -hdd zdrv_217.sfs -m 256 -redir tcp:1534::1534 -redir tcp:4075::4075 -redir tcp:4076::4076 -redir tcp:4077::4077 -redir udp:4075::4075 $*
