/********************************************************************************
 * Copyright (c) 2007 IBM Corporation. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Initial Contributors:
 * The following IBM employees contributed to the Remote System Explorer
 * component that contains this file: David McKnight.
 * 
 * Contributors:
 * Martin Oberhuber (Wind River) - [168870] refactor org.eclipse.rse.core package of the UI plugin
 ********************************************************************************/

package org.eclipsecon.tmtutorial.nm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.model.SimpleCommandOperation;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;


public class ListSymbolsActionDelegate implements IObjectActionDelegate 
{
	private class DisplaySymbols implements Runnable
	{
		private List _symbols;
		public DisplaySymbols(List symbols)
		{
			_symbols = symbols;
		}
		
		public void run()
		{
			SymbolDialog dlg = new SymbolDialog(SystemBasePlugin.getActiveWorkbenchShell(), _symbols);
			dlg.open();
		}
	}
	
	private class ListSymbolsJob extends Job
	{
		public ListSymbolsJob()
		{
			super("List Symbols");
		}

		protected IStatus run(IProgressMonitor monitor) 
		{
			for (int i = 0; i < _selectedFiles.size(); i++)
			{
				IRemoteFile file = (IRemoteFile)_selectedFiles.get(i);
				listSymbols(file);
			}
			
			return Status.OK_STATUS;
		}
		
		private void listSymbols(IRemoteFile file)
		{	
			List lines = readOutput(file);			
			List symbols = parseLines(lines);
			
			DisplaySymbols displaySymbols = new DisplaySymbols(symbols);
			Display.getDefault().syncExec(displaySymbols);
		}
		
		private List readOutput(IRemoteFile file)
		{
			List lines = new ArrayList();
			
			IRemoteCmdSubSystem cmdSS = RemoteCommandHelpers.getCmdSubSystem(file.getParentRemoteFileSubSystem().getHost());
			SimpleCommandOperation op = new SimpleCommandOperation(cmdSS, file.getParentRemoteFile(), true);
			
			String cmdString = "nm " + file.getName(); //$NON-NLS-1$
			try {
				op.runCommand(cmdString, true);
			}
			catch (Exception e) {} 
				
			String line = op.readLine(true);
			while (line != null) {
				lines.add(line);
				line = op.readLine(true);
			}
			op.removeShell();
			return lines;
		}
		
		private List parseLines(List lines)
		{
			List symbols = new ArrayList();
			for (int i = 0; i < lines.size(); i++)
			{
				String line = (String)lines.get(i);
				Symbol symbol = parseLine(line);
				if (symbol != null)
					symbols.add(symbol);
			}
			
			return symbols;
		}	
		
		private Symbol parseLine(String line)
		{
			String value = null;
			String type = null;
			line = line.trim();
			String[] tokens = line.split(" "); //$NON-NLS-1$
			if (tokens.length == 3)
			{
				type = tokens[1];
				value = tokens[2];				
			}
			else if (tokens.length == 2)
			{
				type = tokens[0];
				value = tokens[1];
			}
			if (type != null && type.length() == 1)
			{
				return new Symbol(value, type);
			}
			else
			{
				return null;
			}
		}
	}
	
    private List _selectedFiles = new ArrayList();
	
    /**
     * Creates a new ViewActionDelegate.
     */
    public ListSymbolsActionDelegate() {
        super();
    }


    /* (non-Javadoc)
     * Method declared on IActionDelegate
     */
    public void run(org.eclipse.jface.action.IAction action) 
    {
    	ListSymbolsJob job = new ListSymbolsJob();
    	job.schedule();
    }

    /* (non-Javadoc)
     * Method declared on IActionDelegate
     */
    public void selectionChanged(org.eclipse.jface.action.IAction action,
            org.eclipse.jface.viewers.ISelection selection) 
    {
    	_selectedFiles.clear();
    	// store the selected jars to be used when running
    	Iterator theSet = ((IStructuredSelection)selection).iterator();
    	while (theSet.hasNext())
    	 {
    		 Object obj = theSet.next();
    		 if (obj instanceof IRemoteFile)
    		 {
    			 _selectedFiles.add(obj);
    		 }
    	 }
    }

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		// TODO Auto-generated method stub
		
	}
}
