/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.NumberType;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.GraphingAPIUIPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class MeterChartBuilder
extends AbstractChartWithoutAxisBuilder {
    protected IDeviceRenderer render = null;
    protected DialChart chart = null;
    protected AbstractChartBuilder builder = null;
    protected GeneratedChartState state = null;
    String[] x;
    Double[] y;
    boolean fullUpdate;
    Object[][] data;
    Composite parent = null;
    String[] labels;
    SeriesDefinition sdX;
    protected static int xSeriesTicks;
    protected static int ySeriesTicks;
    protected static int maxItems;
    protected static int viewableItems;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.meterchartbuilder";
    Double min = 0.0;
    Double max = 0.0;

    public MeterChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style);
        this.title = title;
        this.parent = parent;
        try {
            PlatformConfig pf = new PlatformConfig();
            ChartEngine ce = ChartEngine.instance((PlatformConfig)pf);
            this.render = ce.getRenderer("dv.SWT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addPaintListener(new painter());
    }

    protected void createChart() {
        this.data = this.adapter.getData();
        while (this.data.length == 0) {
            this.data = this.adapter.getData();
        }
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        xSeriesTicks = store.getInt("XSeriesTicks");
        ySeriesTicks = store.getInt("YSeriesTicks");
        maxItems = store.getInt("MaxDataItems");
        viewableItems = store.getInt("ViewableDataItems");
        this.chart = (DialChart)DialChartImpl.create();
        this.chart.setDialSuperimposition(false);
        this.chart.setType("Meter Chart");
        this.chart.setSubType("Superimposed Meter Chart");
    }

    protected void buildLegend() {
        this.createLegend();
        this.chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        this.chart.getLegend().getClientArea().getOutline().setVisible(true);
        this.chart.getLegend().getText().getFont().setSize(12.0f);
        this.chart.getLegend().setVisible(false);
    }

    protected void buildTitle() {
        this.chart.getTitle().getLabel().getCaption().setValue(this.title);
        this.chart.getTitle().getLabel().getCaption().getFont().setSize(14.0f);
        this.chart.getTitle().getLabel().getCaption().getFont().setName("MS Sans Serif");
    }

    protected void buildXAxis() {
    }

    protected void buildYAxis() {
    }

    protected void buildXSeries() {
        this.data = this.adapter.getData();
        int starting = 0;
        if (this.data.length > xSeriesTicks) {
            starting = this.data.length - xSeriesTicks;
        }
        this.x = new String[this.data.length - starting];
        try {
            int j = starting;
            int k = 0;
            while (j < this.data.length) {
                this.x[k] = this.data[j][0].toString();
                ++j;
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TextDataSet categoryValues = TextDataSetImpl.create((Object)this.x);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        this.sdX = SeriesDefinitionImpl.create();
        this.sdX.getSeries().add((Object)seCategory);
        this.chart.getSeriesDefinitions().add((Object)this.sdX);
    }

    protected void buildYSeries() {
        try {
            int starting = 0;
            if (this.data.length > xSeriesTicks) {
                starting = this.data.length - xSeriesTicks;
            }
            int i = 0;
            this.y = new Double[this.data.length - starting];
            int j = starting;
            int k = 0;
            while (j < this.data.length) {
                this.y[k] = NumberType.obj2num((Object)this.data[j][i]).doubleValue();
                if (this.max < this.y[k]) {
                    this.max = this.y[k];
                }
                if (this.min > this.y[k]) {
                    this.min = this.y[k];
                }
                ++j;
                ++k;
            }
            NumberDataSet orthoValuesDataSet = NumberDataSetImpl.create((Object)this.y);
            DialSeries ds1 = (DialSeries)DialSeriesImpl.create();
            ds1.setDataSet((DataSet)orthoValuesDataSet);
            ds1.getLabel().setVisible(true);
            ds1.setLabelPosition(Position.INSIDE_LITERAL);
            ds1.setSeriesIdentifier((Object)this.labels[i]);
            ds1.getDial().getMinorGrid().getTickAttributes().setVisible(true);
            ds1.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
            ds1.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
            ds1.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
            SeriesDefinition sdY = SeriesDefinitionImpl.create();
            sdY.getSeries().add((Object)ds1);
            this.sdX.getSeriesDefinitions().add((Object)sdY);
            ds1.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            DialRegion dregion1 = DialRegionImpl.create();
            dregion1.setFill((Fill)ColorDefinitionImpl.GREEN());
            dregion1.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            dregion1.setStartValue((DataElement)NumberDataElementImpl.create((double)70.0));
            dregion1.setEndValue((DataElement)NumberDataElementImpl.create((double)90.0));
            dregion1.setInnerRadius(40.0);
            dregion1.setOuterRadius(-1.0);
            ds1.getDial().getDialRegions().add((Object)dregion1);
            DialRegion dregion2 = DialRegionImpl.create();
            dregion2.setFill((Fill)ColorDefinitionImpl.YELLOW());
            dregion2.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            dregion2.setStartValue((DataElement)NumberDataElementImpl.create((double)40.0));
            dregion2.setEndValue((DataElement)NumberDataElementImpl.create((double)70.0));
            dregion2.setOuterRadius(70.0);
            ds1.getDial().getDialRegions().add((Object)dregion2);
            DialRegion dregion3 = DialRegionImpl.create();
            dregion3.setFill((Fill)ColorDefinitionImpl.RED());
            dregion3.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            dregion3.setStartValue((DataElement)NumberDataElementImpl.create((double)0.0));
            dregion3.setEndValue((DataElement)NumberDataElementImpl.create((double)40.0));
            dregion3.setInnerRadius(40.0);
            dregion3.setOuterRadius(90.0);
            ds1.getDial().getDialRegions().add((Object)dregion3);
            ds1.getLabel().getCaption().getFont().setSize(6.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDataSet() {
        try {
            this.data = this.adapter.getData();
            int starting = 0;
            if (this.data.length > xSeriesTicks) {
                starting = this.data.length - xSeriesTicks;
            }
            this.x = new String[this.data.length - starting];
            int j = starting;
            int k = 0;
            while (j < this.data.length) {
                this.x[k] = this.data[j][0].toString();
                ++j;
                ++k;
            }
            TextDataSet categoryValues = TextDataSetImpl.create((Object)this.x);
            SeriesDefinition sd = (SeriesDefinition)this.chart.getSeriesDefinitions().get(0);
            ((Series)sd.getSeries().get(0)).setDataSet((DataSet)categoryValues);
            int i = 1;
            this.y = new Double[this.data.length - starting];
            int j2 = starting;
            int k2 = 0;
            while (j2 < this.data.length) {
                this.y[k2] = NumberType.obj2num((Object)this.data[j2][i]).doubleValue();
                if (this.max < this.y[k2]) {
                    this.max = this.y[k2];
                }
                ++j2;
                ++k2;
            }
            NumberDataSet orthoValuesDataSet1 = NumberDataSetImpl.create((Object)this.y);
            SeriesDefinition sdY = (SeriesDefinition)sd.getSeriesDefinitions().get(0);
            ((Series)sdY.getSeries().get(0)).setDataSet((DataSet)orthoValuesDataSet1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleUpdateEvent() {
        try {
            this.updateDataSet();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void repaint() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    MeterChartBuilder.this.redraw();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    protected void createLegend() {
        this.labels = this.adapter.getLabels();
        String[] labels2 = new String[this.labels.length - 1];
        int i = 0;
        while (i < labels2.length) {
            labels2[i] = this.labels[i + 1];
            ++i;
        }
    }

    private class painter
    implements PaintListener {
        private painter() {
        }

        public void paintControl(PaintEvent pe) {
            if (MeterChartBuilder.this.chart == null) {
                return;
            }
            try {
                MeterChartBuilder.this.render.setProperty("device.output.context", (Object)pe.gc);
                Composite co = (Composite)pe.getSource();
                Rectangle re = co.getClientArea();
                Bounds bo = BoundsImpl.create((double)re.x, (double)re.y, (double)re.width, (double)re.height);
                bo.scale(72.0 / (double)MeterChartBuilder.this.render.getDisplayServer().getDpiResolution());
                Generator gr = Generator.instance();
                MeterChartBuilder.this.state = gr.build(MeterChartBuilder.this.render.getDisplayServer(), (Chart)MeterChartBuilder.this.chart, bo, null, null, null);
                gr.render(MeterChartBuilder.this.render, MeterChartBuilder.this.state);
            }
            catch (ChartException e) {
                e.printStackTrace();
            }
        }
    }
}

