/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.launch.configuration;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.oprofile.core.daemon.OprofileDaemonOptions;

public class LaunchOptions {
    private OprofileDaemonOptions _options = new OprofileDaemonOptions();

    public boolean isValid() {
        String fn = this._options.getKernelImageFile();
        if (fn != null && fn.length() > 0) {
            File file = new File(this._options.getKernelImageFile());
            return file.exists() && file.isFile();
        }
        return true;
    }

    public void saveConfiguration(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.KERNEL_IMAGE", this._options.getKernelImageFile());
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.SEPARATE_SAMPLES", this._options.getSeparateProfilesMask());
    }

    public void loadConfiguration(ILaunchConfiguration config) {
        try {
            this._options.setKernelImageFile(config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.KERNEL_IMAGE", ""));
            this._options.setSeparateProfilesMask(config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.SEPARATE_SAMPLES", 0));
        }
        catch (CoreException coreException) {}
    }

    public OprofileDaemonOptions getOprofileDaemonOptions() {
        return this._options;
    }

    public String getKernelImageFile() {
        return this._options.getKernelImageFile();
    }

    public void setKernelImageFile(String image) {
        this._options.setKernelImageFile(image);
    }

    public int getSeparateSamples() {
        return this._options.getSeparateProfilesMask();
    }

    public void setSeparateSamples(int how) {
        this._options.setSeparateProfilesMask(how);
    }

    public String getBinaryImage() {
        return this._options.getBinaryImage();
    }

    public void setBinaryImage(String _image) {
        this._options.setBinaryImage(_image);
    }
}

