/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;

public class LocalFileProxy
implements IRemoteFileProxy {
    public URI toURI(IPath path) {
        return path.toFile().toURI();
    }

    public URI toURI(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public String getDirectorySeparator() {
        return System.getProperty("file.separator");
    }

    public IFileStore getResource(String path) {
        return EFS.getLocalFileSystem().getStore((IPath)new Path(path));
    }
}

