/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;

public class EnumDeclaration
implements IDeclaration {
    private final EnumTable table = new EnumTable();
    private IntegerDeclaration containerType = null;

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.containerType = containerType;
    }

    public IntegerDeclaration getContainerType() {
        return this.containerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public EnumDefinition createDefinition(IDefinitionScope definitionScope, String fieldName) {
        return new EnumDefinition(this, definitionScope, fieldName);
    }

    public boolean add(long low, long high, String label) {
        return this.table.add(low, high, label);
    }

    public String query(long value) {
        return this.table.query(value);
    }

    public String getLabel(long i) {
        return this.table.getLabel(i);
    }

    public String toString() {
        return "[declaration] enum[" + Integer.toHexString(this.hashCode()) + ']';
    }

    private static class EnumTable {
        List<Range> ranges = new LinkedList<Range>();

        public String getLabel(long i) {
            for (Range r : this.ranges) {
                if (!r.intersects(i)) continue;
                return r.str;
            }
            return null;
        }

        public boolean add(long low, long high, String label) {
            Range newRange = new Range(low, high, label);
            for (Range r : this.ranges) {
                if (!r.intersects(newRange)) continue;
                return false;
            }
            this.ranges.add(newRange);
            return true;
        }

        public String query(long value) {
            for (Range r : this.ranges) {
                if (!r.intersects(value)) continue;
                return r.str;
            }
            return null;
        }

        private static class Range {
            long low;
            long high;
            String str;

            public Range(long low, long high, String str) {
                this.low = low;
                this.high = high;
                this.str = str;
            }

            public boolean intersects(long i) {
                return i >= this.low && i <= this.high;
            }

            public boolean intersects(Range other) {
                return this.intersects(other.low) || this.intersects(other.high);
            }
        }
    }
}

