/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.internal.console.ConsoleView;

public abstract class ConsoleAction
extends Action
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private IAction act;
    private IPropertyListener listener = new IPropertyListener(){

        public void propertyChanged(Object o, int i) {
            if (o instanceof ConsoleView) {
                ConsoleAction.this.setEnablement(ConsoleAction.this.isRunning((ConsoleView)o));
            }
        }
    };

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart part) {
    }

    public void run(IAction action) {
        this.run();
    }

    public abstract void run();

    protected ScriptConsole getActive() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.console.ConsoleView");
        IConsole activeConsole = ((ConsoleView)ivp).getConsole();
        if (activeConsole instanceof ScriptConsole) {
            return (ScriptConsole)activeConsole;
        }
        return null;
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.act = act;
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IWorkbenchPart wbp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        if (wbp instanceof ConsoleView) {
            IViewPart ivp = (IViewPart)wbp;
            this.setEnablement(this.isRunning((ConsoleView)ivp));
            ivp.addPropertyListener(this.listener);
        }
    }

    private boolean isRunning(ConsoleView cv) {
        if (cv.getConsole() instanceof ScriptConsole) {
            ScriptConsole console = (ScriptConsole)cv.getConsole();
            return console != null && console.isRunning();
        }
        return false;
    }

    private void setEnablement(boolean enabled) {
    }

    public void dispose() {
        this.act = null;
        this.listener = null;
    }
}

