/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.treeviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.swt.widgets.ScrollBar;

public class StapTreeListener
implements ITreeViewerListener {
    private static final int INCREMENT = 15;
    private int highestLevelOfExpansion = 0;
    private ScrollBar scrollbar;
    private HashMap<Integer, List<Integer>> highestLevelNodes;

    public void treeCollapsed(TreeExpansionEvent event) {
        StapData data = (StapData)event.getElement();
        if (this.highestLevelNodes.get(this.highestLevelOfExpansion) != null && this.highestLevelNodes.get(this.highestLevelOfExpansion).remove((Object)data.id)) {
            this.scrollbar.setSelection(this.scrollbar.getSelection() - 15);
            --this.highestLevelOfExpansion;
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        int lvl;
        StapData d = (StapData)event.getElement();
        if (d.levelOfRecursion > this.highestLevelOfExpansion) {
            this.scrollbar.setSelection(this.scrollbar.getSelection() + 15);
            this.highestLevelOfExpansion = ((StapData)event.getElement()).levelOfRecursion;
        }
        if (this.highestLevelNodes.get(lvl = d.levelOfRecursion) == null) {
            this.highestLevelNodes.put(lvl, new ArrayList());
        }
        this.highestLevelNodes.get(lvl).add(d.id);
    }

    public StapTreeListener(ScrollBar bar) {
        this.scrollbar = bar;
        this.highestLevelNodes = new HashMap();
    }
}

