/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.ICommand;
import org.eclipse.cdt.make.core.makefile.IComment;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IEmptyLine;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IParent;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.internal.core.makefile.NullMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.AddBuildTargetAction;
import org.eclipse.cdt.make.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class MakefileContentOutlinePage
extends ContentOutlinePage {
    protected MakefileEditor fEditor;
    protected Object fInput;
    protected AddBuildTargetAction fAddBuildTargetAction;
    protected OpenIncludeAction fOpenIncludeAction;

    public MakefileContentOutlinePage(MakefileEditor editor) {
        this.fEditor = editor;
        this.fAddBuildTargetAction = new AddBuildTargetAction(this);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new MakefileContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MakefileLabelProvider());
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        MenuManager manager = new MenuManager("#MakefileOutlinerContext");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> this.contextMenuAboutToShow(m));
        Control tree = viewer.getControl();
        Menu menu = manager.createContextMenu(tree);
        tree.setMenu(menu);
        viewer.addDoubleClickListener(event -> {
            if (this.fOpenIncludeAction != null) {
                this.fOpenIncludeAction.run();
            }
        });
        IPageSite site = this.getSite();
        site.registerContextMenu(MakeUIPlugin.getPluginId() + ".outline", manager, (ISelectionProvider)viewer);
        site.setSelectionProvider((ISelectionProvider)viewer);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (this.fOpenIncludeAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fOpenIncludeAction);
        }
        if (this.fAddBuildTargetAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fAddBuildTargetAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public Object getInput() {
        return this.fInput;
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    control.setRedraw(false);
                    viewer.setInput(this.fInput);
                    viewer.expandAll();
                    control.setRedraw(true);
                }
            });
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
    }

    private class MakefileContentProvider
    implements ITreeContentProvider {
        protected boolean showMacroDefinition = true;
        protected boolean showTargetRule = true;
        protected boolean showInferenceRule = true;
        protected boolean showIncludeChildren = false;
        protected IMakefile makefile;
        protected IMakefile nullMakefile = new NullMakefile();

        private MakefileContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element == MakefileContentOutlinePage.this.fInput) {
                return this.getElements(this.makefile);
            }
            if (element instanceof IDirective) {
                return this.getElements(element);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IMakefile) {
                return MakefileContentOutlinePage.this.fInput;
            }
            if (element instanceof IDirective) {
                return ((IDirective)element).getParent();
            }
            return MakefileContentOutlinePage.this.fInput;
        }

        public boolean hasChildren(Object element) {
            if (element == MakefileContentOutlinePage.this.fInput) {
                return true;
            }
            if (element instanceof IParent) {
                return !(element instanceof IInclude) || this.showIncludeChildren;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] directives = inputElement == MakefileContentOutlinePage.this.fInput ? this.makefile.getDirectives() : (inputElement instanceof IRule ? ((IRule)inputElement).getCommands() : (inputElement instanceof IParent ? (inputElement instanceof IInclude && !this.showIncludeChildren ? new IDirective[]{} : ((IParent)inputElement).getDirectives()) : new IDirective[]{}));
            ArrayList<IDirective> list = new ArrayList<IDirective>(directives.length);
            IDirective[] iDirectiveArray = directives;
            int n = directives.length;
            int n2 = 0;
            while (n2 < n) {
                IDirective directive = iDirectiveArray[n2];
                if (this.showMacroDefinition && directive instanceof IMacroDefinition) {
                    list.add(directive);
                } else if (this.showInferenceRule && directive instanceof IInferenceRule) {
                    list.add(directive);
                } else if (this.showTargetRule && directive instanceof ITargetRule) {
                    list.add(directive);
                } else {
                    boolean irrelevant;
                    boolean bl = irrelevant = directive instanceof IComment || directive instanceof IEmptyLine || directive instanceof ITerminal;
                    if (!irrelevant) {
                        list.add(directive);
                    }
                }
                ++n2;
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.makefile = this.nullMakefile;
            }
            if (newInput != null) {
                IWorkingCopyManager manager = MakeUIPlugin.getDefault().getWorkingCopyManager();
                this.makefile = manager.getWorkingCopy((IEditorInput)newInput);
                if (this.makefile == null) {
                    this.makefile = this.nullMakefile;
                }
            }
        }
    }

    private class MakefileLabelProvider
    extends LabelProvider {
        private MakefileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ITargetRule) {
                return MakeUIImages.getImage("icons/obj16/target_obj.gif");
            }
            if (element instanceof IInferenceRule) {
                return MakeUIImages.getImage("icons/obj16/irule_obj.gif");
            }
            if (element instanceof IMacroDefinition) {
                return CDTSharedImages.getImage((String)"icons/obj16/variable_obj.gif");
            }
            if (element instanceof ICommand) {
                return MakeUIImages.getImage("icons/obj16/command_obj.gif");
            }
            if (element instanceof IInclude) {
                return MakeUIImages.getImage("icons/etool16/makefile.gif");
            }
            if (element instanceof IBadDirective) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            if (element instanceof IParent) {
                return MakeUIImages.getImage("icons/obj16/relation_obj.gif");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            Object name = element instanceof IRule ? ((IRule)element).getTarget().toString().trim() : (element instanceof IMacroDefinition ? ((IMacroDefinition)element).getName().trim() : super.getText(element));
            if (name != null && ((String)(name = ((String)name).trim())).length() > 25) {
                name = ((String)name).substring(0, 25) + " ...";
            }
            return name;
        }
    }
}

