/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.testsrunner.internal.model.TestItem;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestSuite;

public class TestSuite
extends TestItem
implements ITestSuite {
    private List<TestItem> children = new ArrayList<TestItem>();

    public TestSuite(String name, TestSuite parent) {
        super(name, parent);
    }

    @Override
    public ITestItem.Status getStatus() {
        ITestItem.Status result = ITestItem.Status.NotRun;
        for (TestItem testItem : this.children) {
            ITestItem.Status childStatus = testItem.getStatus();
            if (result.compareTo(childStatus) >= 0) continue;
            result = childStatus;
        }
        return result;
    }

    @Override
    public int getTestingTime() {
        int result = 0;
        for (TestItem testItem : this.children) {
            result += testItem.getTestingTime();
        }
        return result;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TestItem[] getChildren() {
        return this.children.toArray(new TestItem[this.children.size()]);
    }

    @Override
    public void visit(IModelVisitor visitor) {
        visitor.visit(this);
        for (TestItem testItem : this.children) {
            testItem.visit(visitor);
        }
        visitor.leave(this);
    }

    public List<TestItem> getChildrenList() {
        return this.children;
    }
}

