/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.actions.AbstractAutotoolsHandler;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.internal.autotools.ui.actions.TwoInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;

public class AclocalHandler
extends AbstractAutotoolsHandler {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "aclocal";

    public Object execute(ExecutionEvent event) {
        return this.execute1(event);
    }

    @Override
    protected void run(Shell activeShell) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = InvokeMessages.getString("CWD") + String.valueOf(this.getCWD(container));
        TwoInputDialog optionDialog = new TwoInputDialog(activeShell, cwd, InvokeMessages.getString("InvokeAclocalAction.windowTitle.options"), InvokeMessages.getString("InvokeAclocalAction.message.options.otherOptions"), InvokeMessages.getString("InvokeAclocalAction.message.options.includeDir"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        List<String> optionsList = this.separateOptions(rawArgList);
        rawArgList = optionDialog.getSecondValue();
        List<String> targetList = this.separateTargets(rawArgList);
        if (targetList == null) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), InvokeMessages.getString("InvokeAction.windowTitle.quoteError"));
            return;
        }
        boolean iOption = false;
        if (targetList.size() > 0) {
            iOption = true;
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        argumentList.addAll(optionsList);
        if (iOption) {
            argumentList.add("-I");
        }
        argumentList.addAll(targetList);
        String aclocalCommand = null;
        IProject project = this.getSelectedContainer().getProject();
        try {
            aclocalCommand = project.getPersistentProperty(AutotoolsPropertyConstants.ACLOCAL_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (aclocalCommand == null) {
            aclocalCommand = DEFAULT_COMMAND;
        }
        this.executeConsoleCommand(DEFAULT_COMMAND, aclocalCommand, argumentList, execDir);
    }
}

