/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.packs.ui.views;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Path;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.core.zafarkhaja.semver.Version;
import org.eclipse.embedcdt.internal.packs.ui.Activator;
import org.eclipse.embedcdt.internal.packs.ui.Messages;
import org.eclipse.embedcdt.internal.packs.ui.views.BoardsView;
import org.eclipse.embedcdt.internal.packs.ui.views.DevicesView;
import org.eclipse.embedcdt.internal.packs.ui.views.KeywordsView;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.DataManager;
import org.eclipse.embedcdt.packs.core.data.DataManagerEvent;
import org.eclipse.embedcdt.packs.core.data.DurationMonitor;
import org.eclipse.embedcdt.packs.core.data.IDataManagerListener;
import org.eclipse.embedcdt.packs.core.jobs.CopyExampleJob;
import org.eclipse.embedcdt.packs.core.jobs.InstallJob;
import org.eclipse.embedcdt.packs.core.jobs.RemoveJob;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.ui.views.CopyExampleDialog;
import org.eclipse.embedcdt.packs.ui.views.NodeViewContentProvider;
import org.eclipse.embedcdt.packs.ui.views.PacksFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class PacksView
extends ViewPart
implements IDataManagerListener {
    public static final String ID = "org.eclipse.embedcdt.internal.packs.ui.views.PacksView";
    private static final int AUTOEXPAND_LEVEL = 2;
    private Composite fComposite;
    private TreeViewer fViewer;
    private ISelectionListener fPageSelectionListener;
    private ViewContentProvider fContentProvider;
    private Action fUpdateAction;
    private Action fInstallAction;
    private Action fRemoveAction;
    private Action fCopyExampleAction;
    private Action fExpandAll;
    private Action fCollapseAll;
    private PacksFilter fPacksFilter;
    private ViewerFilter[] fPacksFilters;
    private boolean fIsInstallEnabled;
    private boolean fIsRemoveEnabled;
    private boolean fIsCopyExampleEnabled;
    private DataManager fDataManager;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();

    public PacksView() {
        this.fDataManager = DataManager.getInstance();
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    public void createPartControl(Composite parent) {
        this.fComposite = parent;
        this.fPacksFilter = new PacksFilter();
        this.fPacksFilters = new PacksFilter[]{this.fPacksFilter};
        Tree tree = new Tree(parent, 68354);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText("  Name");
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnPixelData(200));
        TreeColumn descriptionColumn = new TreeColumn(tree, 0);
        descriptionColumn.setAlignment(16384);
        descriptionColumn.setText(" Description");
        layout.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnPixelData(450));
        this.fViewer = new TreeViewer(tree);
        this.fContentProvider = new ViewContentProvider();
        this.fDataManager.addListener((IDataManagerListener)this);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new NameComparator());
        this.fViewer.setAutoExpandLevel(2);
        this.fViewer.setInput((Object)this.getPacksTree());
        this.addProviders();
        this.addListners();
        this.hookPageSelection();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        if (this.fPageSelectionListener != null) {
            this.getSite().getPage().removePostSelectionListener(this.fPageSelectionListener);
        }
        this.fDataManager.removeListener((IDataManagerListener)this);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PacksView.dispose()");
        }
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PacksView.this.updateButtonsEnableStatus(selection);
            }
        });
    }

    private void hookPageSelection() {
        this.fPageSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof DevicesView || part instanceof BoardsView || part instanceof KeywordsView) {
                    PacksView.this.friendViewSelectionChanged(part, selection);
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.fPageSelectionListener);
    }

    protected void friendViewSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty()) {
            this.fViewer.expandToLevel(2);
            this.fViewer.resetFilters();
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        String selectorType = "";
        if (part instanceof DevicesView) {
            selectorType = "devicefamily";
        } else if (part instanceof BoardsView) {
            selectorType = "board";
        } else if (part instanceof KeywordsView) {
            selectorType = "keyword";
        }
        this.fPacksFilter.setSelection(selectorType, structuredSelection);
        this.fViewer.expandToLevel(2);
        this.fViewer.setFilters(this.fPacksFilters);
        this.fViewer.expandToLevel(2);
        this.fViewer.setSelection(null);
    }

    public void updateButtonsEnableStatus(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (((Leaf)selection.getFirstElement()).isType("none")) {
            return;
        }
        this.fIsInstallEnabled = false;
        this.fIsRemoveEnabled = false;
        this.fIsCopyExampleEnabled = false;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Leaf node = (Leaf)obj;
            String type = node.getType();
            boolean isInstalled = false;
            if (node.isBooleanProperty("installed")) {
                isInstalled = true;
            }
            if ("package".equals(type) && !isInstalled) {
                this.fIsInstallEnabled = true;
            }
            if ("version".equals(type)) {
                int size = 0;
                try {
                    size = Integer.valueOf(node.getProperty("archive.size", "0"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!isInstalled && size >= 0) {
                    this.fIsInstallEnabled = true;
                }
                if (isInstalled) {
                    this.fIsRemoveEnabled = true;
                }
            }
            if ("example".equals(type)) {
                this.fIsCopyExampleEnabled = true;
            }
            ++n2;
        }
        this.fInstallAction.setEnabled(this.fIsInstallEnabled);
        this.fRemoveAction.setEnabled(this.fIsRemoveEnabled);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PacksView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fInstallAction);
        manager.add((IAction)this.fRemoveAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fUpdateAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.fIsInstallEnabled) {
            manager.add((IAction)this.fInstallAction);
        }
        if (this.fIsRemoveEnabled) {
            manager.add((IAction)this.fRemoveAction);
        }
        if (this.fIsCopyExampleEnabled) {
            manager.add((IAction)this.fCopyExampleAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fInstallAction);
        manager.add((IAction)this.fRemoveAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fUpdateAction);
    }

    private void makeActions() {
        this.fUpdateAction = new Action(){

            public void run() {
                IWorkbenchPartSite serviceLocator = PacksView.this.getSite();
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                try {
                    Command command = commandService.getCommand("org.eclipse.embedcdt.packs.ui.commands.updateCommand");
                    command.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    Activator.log((Throwable)e);
                }
            }
        };
        this.fUpdateAction.setText(Messages.PacksView_UpdateAction_text);
        this.fUpdateAction.setToolTipText(Messages.PacksView_UpdateAction_toolTipText);
        this.fUpdateAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/refresh_nav.gif"));
        this.fInstallAction = new Action(){

            public void run() {
                TreeSelection selection = (TreeSelection)PacksView.this.fViewer.getSelection();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(selection);
                }
                List nodes = Arrays.stream(selection.toArray()).filter(Node.class::isInstance).map(Node.class::cast).collect(Collectors.toList());
                InstallJob job = new InstallJob("Install CMSIS Packs", nodes);
                job.schedule();
            }
        };
        this.fInstallAction.setText(Messages.PacksView_InstallAction_text);
        this.fInstallAction.setToolTipText(Messages.PacksView_InstallAction_toolTipText);
        this.fInstallAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/package_mode.png"));
        this.fInstallAction.setEnabled(false);
        this.fRemoveAction = new Action(){

            public void run() {
                TreeSelection selection = (TreeSelection)PacksView.this.fViewer.getSelection();
                List nodes = Arrays.stream(selection.toArray()).filter(Node.class::isInstance).map(Node.class::cast).collect(Collectors.toList());
                RemoveJob job = new RemoveJob("Remove CMSIS Packs", nodes);
                job.schedule();
            }
        };
        this.fRemoveAction.setText(Messages.PacksView_RemoveAction_text);
        this.fRemoveAction.setToolTipText(Messages.PacksView_RemoveAction_toolTipText);
        this.fRemoveAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/removeall.png"));
        this.fRemoveAction.setEnabled(false);
        this.fCopyExampleAction = new Action(){

            public void run() {
                String[] out;
                CopyExampleDialog dlg;
                TreeSelection selection = (TreeSelection)PacksView.this.fViewer.getSelection();
                if (!selection.isEmpty() && (dlg = new CopyExampleDialog(PacksView.this.fComposite.getShell(), selection)).open() == 0 && PacksView.this.checkCopyDestinationFolders(selection, out = dlg.getData())) {
                    List nodes = Arrays.stream(selection.toArray()).filter(PackNode.class::isInstance).map(PackNode.class::cast).collect(Collectors.toList());
                    CopyExampleJob job = new CopyExampleJob("Copy example", nodes, out);
                    job.schedule();
                }
            }
        };
        this.fCopyExampleAction.setText("Copy to folder");
        this.fExpandAll = new Action(){

            public void run() {
                PacksView.this.fViewer.expandAll();
            }
        };
        this.fExpandAll.setText(Messages.PacksView_ExpandAll_text);
        this.fExpandAll.setToolTipText(Messages.PacksView_ExpandAll_toolTipText);
        this.fExpandAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/expandall.png"));
        this.fCollapseAll = new Action(){

            public void run() {
                PacksView.this.fViewer.collapseAll();
            }
        };
        this.fCollapseAll.setText(Messages.PacksView_CollapseAll_text);
        this.fCollapseAll.setToolTipText(Messages.PacksView_CollapseAll_toolTipText);
        this.fCollapseAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/collapseall.png"));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void refresh(Object obj) {
        if (obj instanceof Collection) {
            for (Object node : (Collection)obj) {
                this.fViewer.refresh(node);
            }
        } else {
            this.fViewer.refresh(obj);
        }
        this.fViewer.setSelection(this.fViewer.getSelection());
        this.setFocus();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PacksView.refresh() " + obj);
        }
    }

    public void update(Object obj) {
        if (obj instanceof Collection) {
            for (Object node : (Collection)obj) {
                this.fViewer.update(node, null);
            }
        } else {
            this.fViewer.update(obj, null);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PacksView.updated() " + obj);
        }
    }

    public String toString() {
        return "PacksView";
    }

    private boolean checkCopyDestinationFolders(TreeSelection selection, String[] param) {
        Path m_destFolderPath = new Path(param[0]);
        boolean isNonEmpty = false;
        for (Object sel : selection.toList()) {
            PackNode exampleNode = (PackNode)sel;
            Leaf outlineExampleNode = exampleNode.getOutline().findChild("example");
            String exampleRelativeFolder = outlineExampleNode.getProperty("folder");
            File destFolder = m_destFolderPath.append(exampleRelativeFolder).toFile();
            if (!destFolder.isDirectory() || destFolder.listFiles().length <= 0) continue;
            isNonEmpty = true;
            break;
        }
        if (isNonEmpty) {
            String msg = "One of the destination folders is not empty.";
            msg = String.valueOf(msg) + "\nDo you agree to delete the previous content?";
            String[] buttons = new String[]{"OK", "Cancel"};
            MessageDialog dlg = new MessageDialog(this.fComposite.getShell(), null, null, msg, 1, buttons, 0);
            return dlg.open() == 0;
        }
        return true;
    }

    public void packsChanged(DataManagerEvent event) {
        String type = event.getType();
        if ("new.input".equals(type)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PacksView.this.fViewer.setAutoExpandLevel(2);
                    PacksView.this.fViewer.setInput((Object)PacksView.this.getPacksTree());
                }
            });
        } else if ("update.versions".equals(type)) {
            List updatedList = (List)event.getPayload();
            HashMap<String, Node> parentsMap = new HashMap<String, Node>();
            for (PackNode versionNode : updatedList) {
                String vendorName = versionNode.getProperty("vendor.name");
                String packName = versionNode.getProperty("pack.name");
                String versionName = versionNode.getProperty("version.name");
                PackNode modelNode = this.fDataManager.findCmsisPackVersion(vendorName, packName, versionName);
                this.updateVersioNode(versionNode, (Node)modelNode);
                String key = this.fDataManager.makeMapKey("cmsis", vendorName, packName);
                Node parent = versionNode.getParent();
                if (parentsMap.containsKey(key)) continue;
                parentsMap.put(key, parent);
            }
            for (Node packNode : parentsMap.values()) {
                boolean hasInstalledChildren = false;
                for (Leaf child : packNode.getChildren()) {
                    if (!child.isBooleanProperty("installed")) continue;
                    hasInstalledChildren = true;
                    break;
                }
                packNode.setBooleanProperty("installed", hasInstalledChildren);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PacksView.this.fViewer.refresh();
                    PacksView.this.updateButtonsEnableStatus((IStructuredSelection)PacksView.this.fViewer.getSelection());
                }
            });
        }
    }

    private Node getPacksTree() {
        final Node packsTree = DataManager.getInstance().getRepositoriesTree();
        final Node packsRoot = new Node("root");
        packsRoot.setName("CMSIS Packs");
        if (packsTree.hasChildren()) {
            new DurationMonitor().displayTimeAndRun(new Runnable(){

                @Override
                public void run() {
                    PacksView.this.fOut.println("Collecting packs...");
                    int count = 0;
                    try {
                        count = PacksView.this.getPacksRecursive((Leaf)packsTree, null, packsRoot);
                    }
                    catch (Exception e) {
                        Activator.log((Throwable)e);
                    }
                    if (packsRoot.hasChildren()) {
                        PacksView.this.fOut.println("Found " + count + " package version(s), from " + packsRoot.getChildren().size() + " vendor(s).");
                    } else {
                        PacksView.this.fOut.println("Found none.");
                    }
                }
            });
        }
        if (!packsRoot.hasChildren()) {
            Node empty = Node.addNewChild((Node)packsRoot, (String)"none");
            empty.setName("(no packages)");
            empty.setDescription("Press the Refresh button to register all available packages.");
        }
        return packsRoot;
    }

    private int getPacksRecursive(Leaf modelNode, PackNode parentPackNode, Node root) {
        int count = 0;
        if (modelNode.isType("package")) {
            parentPackNode = (PackNode)modelNode;
        }
        if (modelNode.isType("version")) {
            count += this.addVersion((PackNode)modelNode, parentPackNode, root);
        } else if (modelNode instanceof Node && modelNode.hasChildren()) {
            for (Leaf child : ((Node)modelNode).getChildren()) {
                count += this.getPacksRecursive(child, parentPackNode, root);
            }
        }
        return count;
    }

    private int addVersion(PackNode modelNode, PackNode parentPackNode, Node tree) {
        int count = 0;
        String vendorName = modelNode.getProperty("vendor.name");
        String packName = modelNode.getProperty("pack.name");
        String versionName = modelNode.getProperty("version.name");
        String description = modelNode.getDescription();
        Node vendorNode = Node.addUniqueChild((Node)tree, (String)"vendor", (String)vendorName);
        PackNode packNode = PackNode.addUniqueChild((Node)vendorNode, (String)"package", (String)packName);
        if (parentPackNode != null) {
            packNode.setDescription(parentPackNode.getDescription());
        }
        packNode.copyProperties((Leaf)parentPackNode);
        packNode.putProperty("vendor.name", vendorName);
        packNode.copySelectorsRef(parentPackNode);
        PackNode versionNode = PackNode.addUniqueChild((Node)packNode, (String)"version", (String)versionName);
        versionNode.setDescription(description);
        versionNode.copyProperties((Leaf)modelNode);
        this.updateVersioNode(versionNode, (Node)modelNode);
        return ++count;
    }

    private void updateVersioNode(PackNode versionNode, Node modelNode) {
        if (versionNode.isBooleanProperty("installed")) {
            assert (modelNode != null);
            Node outlineNode = (Node)modelNode.findChild("outline");
            if (outlineNode != null && outlineNode.hasChildren()) {
                for (Leaf child : outlineNode.getChildren()) {
                    if (!child.isType("example")) continue;
                    PackNode node = PackNode.addNewChild((Node)versionNode, (Leaf)child);
                    node.copyProperties(child);
                }
            }
        } else {
            versionNode.removeChildren();
        }
        versionNode.setOutline(null);
    }

    class NameComparator
    extends ViewerComparator {
        NameComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Leaf n1 = (Leaf)e1;
            String name1 = n1.getName();
            String name2 = ((Leaf)e2).getName();
            if (n1.isType("version")) {
                Version v1 = Version.valueOf((String)name1);
                Version v2 = Version.valueOf((String)name2);
                return v2.compareTo(v1);
            }
            return this.getComparator().compare(name1, name2);
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Leaf node = (Leaf)obj;
                    String type = node.getType();
                    if ("vendor".equals(type)) {
                        return Activator.getInstance().getImage("pack_folder");
                    }
                    if ("package".equals(type)) {
                        if (node.isBooleanProperty("installed")) {
                            return Activator.getInstance().getImage("package_obj");
                        }
                        return Activator.getInstance().getImage("package_obj_grey");
                    }
                    if ("version".equals(type)) {
                        if (node.isBooleanProperty("installed")) {
                            return Activator.getInstance().getImage("jtypeassist_co");
                        }
                        return Activator.getInstance().getImage("jtypeassist_co_grey");
                    }
                    if (!"example".equals(type)) break;
                    return Activator.getInstance().getImage("binaries_obj");
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int columnIndex) {
            Leaf node = (Leaf)obj;
            switch (columnIndex) {
                case 0: {
                    String name = node.getName();
                    String extra = "";
                    if (node.isBooleanProperty("installed")) {
                        extra = "installed";
                    } else if (node.isType("version")) {
                        String date;
                        String size = node.getProperty("archive.size");
                        if (!size.isEmpty()) {
                            if (!extra.isEmpty()) {
                                extra = String.valueOf(extra) + ", ";
                            }
                            try {
                                int n = Integer.parseInt(size);
                                extra = n <= 0 ? String.valueOf(extra) + "n/a" : String.valueOf(extra) + StringUtils.convertSizeToString((int)n);
                            }
                            catch (NumberFormatException n) {
                                // empty catch block
                            }
                        }
                        if (!(date = node.getProperty("date")).isEmpty()) {
                            if (!extra.isEmpty()) {
                                extra = String.valueOf(extra) + ", ";
                            }
                            extra = String.valueOf(extra) + date;
                        }
                    }
                    if (!extra.isEmpty()) {
                        name = String.valueOf(name) + " (" + extra + ")";
                    }
                    return " " + name;
                }
                case 1: {
                    String description = node.getDescription();
                    String[] lines = description.split("\\r?\\n");
                    description = lines[0];
                    return " " + description;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }
    }
}

