/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterRootNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "ROOT";
    private static final String[] VALID_CHILDREN = new String[]{"FILTER"};

    public TmfFilterRootNode() {
        super(null);
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            if (!node.matches(event)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public List<String> getValidChildren() {
        return Arrays.asList(VALID_CHILDREN);
    }

    @Override
    public String toString(boolean explicit) {
        StringBuffer buf = new StringBuffer("root");
        if (this.getChildrenCount() > 0) {
            buf.append(' ');
            ArrayList<String> strings = new ArrayList<String>();
            ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
            int n = iTmfFilterTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfFilterTreeNode child = iTmfFilterTreeNodeArray[n2];
                strings.add(child.toString(explicit));
                ++n2;
            }
            buf.append(((Object)strings).toString());
        }
        return buf.toString();
    }
}

