/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;

class UnsynchronizedHashtable {
    private ElementDefinition[] linearTable = new ElementDefinition[256];
    private int count = 0;
    private Entry[] table = new Entry[256];

    UnsynchronizedHashtable() {
    }

    private void expand() {
        ElementDefinition[] elementDefinitionArray = new ElementDefinition[this.count * 2];
        System.arraycopy(this.linearTable, 0, elementDefinitionArray, 0, this.count);
        this.linearTable = elementDefinitionArray;
    }

    private int hashCode(char[] cArray) {
        int n = 0;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            n = 25 * n + (cArray[n2] & 0x1F) - 1;
            --n2;
        }
        return n;
    }

    final ElementDefinition get(int n) {
        return this.linearTable[n];
    }

    final ElementDefinition get(String string) {
        char[] cArray = string.toCharArray();
        Entry entry = this.table[0xFF & this.hashCode(cArray)];
        while (entry != null) {
            String string2 = entry.key;
            if (string2.equalsIgnoreCase(string)) {
                return entry.val;
            }
            entry = entry.next;
        }
        return null;
    }

    final void put(String string, ElementDefinition elementDefinition) {
        char[] cArray = string.toCharArray();
        Entry entry = new Entry();
        entry.key = string;
        entry.val = elementDefinition;
        elementDefinition.number = entry.num = this.count;
        if (this.linearTable.length == this.count) {
            this.expand();
        }
        this.linearTable[this.count++] = elementDefinition;
        int n = 0xFF & this.hashCode(cArray);
        entry.next = this.table[n];
        this.table[n] = entry;
    }

    final int size() {
        return this.count;
    }

    class Entry {
        String key;
        ElementDefinition val;
        int num;
        Entry next;

        Entry() {
        }
    }
}

